// All material copyright ESRI, All Rights Reserved, unless otherwise specified.
// See http://@sbaseurl@/jsapi/jsapi/esri/copyright.txt and http://www.arcgis.com/apps/webappbuilder/copyright.txt for details.

//>>built
require({cache:{"widgets/GridOverlay/lib/GridOverlay":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/array ./mgrs-utils esri/layers/GraphicsLayer esri/geometry/geometryEngine esri/geometry/Extent esri/geometry/ScreenPoint esri/Color esri/geometry/webMercatorUtils jimu/utils xstyle/css!./GridOverlay.css".split(" "),function(H,g,q,m,n,e,c,a,b,l,h){Math.log10||(Math.log10=function(d){return Math.log(d)/Math.LN10});return H(null,{minIntervalSpacing:150,currentInterval:0,levelOfDetail:"default",
labelPlacement:null,verticalLabels:!0,cornerLabelXOffset:10,cornerLabelYOffset:10,intervalLabelXOffset:30,intervalLabelYOffset:30,colors:null,lineWidths:null,fontSizes:null,lineOpacity:.8,labelOpacity:1,centerLabelOpacity:.4,centerLabelScaleFactor:3,fontFamily:"Arial, Helvetica, sans-serif",map:null,_lineGraphics:null,_labelGraphics:null,constructor:function(d){d=d||{};d.map||console.warn("Before the grid will draw, you must use the 'setMap' method to define which map object to draw on");d.hasOwnProperty("enabled")?
this.enabled=d.enabled:this.enabled=!0;this._lineGraphicsLayer=new n;this._labelGraphicsLayer=new n({className:"gridOverlay"});this._centerLabelGraphicsLayer=new n({className:"gridOverlay"});this.enable=g.hitch(this,this.enable);this.disable=g.hitch(this,this.disable);this.clearGrid=g.hitch(this,this.clearGrid);this.drawGrid=g.hitch(this,this.drawGrid);this.getLayers=g.hitch(this,function(){return[this._lineGraphicsLayer,this._labelGraphicsLayer,this._centerLabelGraphicsLayer]});this.labelPlacement=
{lowerLeft:!0,lowerRight:!0,upperLeft:!0,upperRight:!0,center:!0};this.colors="#FA5858 #F7FE2E #2EFE2E #2EFEF7 #FFF #BDBDBD #000".split(" ");this.lineWidths=[3,2,1,1,1,1,1];this.fontSizes=[29,27,19,16,15,13,11];this.map=d.map||{};this._lineGraphics=[];this._labelGraphics=[];this._lineGraphicsLayer.setOpacity(this.lineOpacity);this._labelGraphicsLayer.setOpacity(this.labelOpacity);this._centerLabelGraphicsLayer.setOpacity(this.centerLabelOpacity);for(var f=0;f<this.colors.length;f++)this.colors[f]=
new b(this.colors[f]);this.setProperties(d)},setProperties:function(d){d.lineWidths&&this.setLineWidths(d.lineWidths);d.minIntervalSpacing&&this.setMinIntervalSpacing(d.minIntervalSpacing);d.levelOfDetail&&this.setLevelOfDetail(d.levelOfDetail);d.labelPlacement&&this.setLabelPlacement(d.labelPlacement);d.hasOwnProperty("verticalLabels")&&this.setVerticalLabels(d.verticalLabels);d.cornerLabelXOffset&&this.setCornerLabelXOffset(d.cornerLabelXOffset);d.cornerLabelYOffset&&this.setCornerLabelYOffset(d.cornerLabelYOffset);
d.intervalLabelXOffset&&this.setIntervalLabelXOffset(d.intervalLabelXOffset);d.intervalLabelYOffset&&this.setIntervalLabelYOffset(d.intervalLabelYOffset);d.colors&&this.setColors(d.colors);d.lineWidths&&this.setLineWidths(d.lineWidths);d.fontSizes&&this.setFontSizes(d.fontSizes);d.lineOpacity&&this.setLineOpacity(d.lineOpacity);d.labelOpacity&&this.setLabelOpacity(d.labelOpacity);d.centerLabelOpacity&&this.setCenterLabelOpacity(d.centerLabelOpacity);d.centerLabelScaleFactor&&this.setCenterLabelScaleFactor(d.centerLabelScaleFactor);
d.fontFamily&&this.setFontFamily(d.fontFamily);if(this.enabled&&this.map.loaded)this.enable();else if(this.enabled&&this.map.on)this.map.on("load",g.hitch(this,this.enable))},getMinIntervalSpacing:function(){return this.minIntervalSpacing},setMinIntervalSpacing:function(d){"number"===typeof d&&(this.minIntervalSpacing=d,this.drawGrid())},setLevelOfDetail:function(d){if("string"!==typeof d)return null;d=d.toLowerCase();switch(d){case "more":case "best":case "high":case "maximum":case "max":this.levelOfDetail=
"more";break;case "less":case "low":case "minimum":case "mim":this.levelOfDetail="less";break;default:this.levelOfDetail="default"}this.drawGrid()},getLevelOfDetail:function(){return this.levelOfDetail},getLabelPlacement:function(){return this.labelPlacement},setLabelPlacement:function(d,f){if("object"===typeof d&&d.length)for(this.labelPlacement={lowerLeft:!1,lowerRight:!1,upperLeft:!1,upperRight:!1,center:!1},f=0;f<d.length;f++)this.setLabelPlacement(d[f],!0);else if("object"===typeof d)this.labelPlacement=
d;else if("undefined"===typeof f?(this.labelPlacement={lowerLeft:!1,lowerRight:!1,upperLeft:!1,upperRight:!1,center:!1},f=!0):f=!0===f,d.toLowerCase){switch(d.toLowerCase()){case "center":case "middle":this.labelPlacement.center=f;break;case "top":case "upper":this.labelPlacement.upperLeft=f;this.labelPlacement.upperRight=f;break;case "bottom":case "lower":this.labelPlacement.lowerLeft=f;this.labelPlacement.lowerRight=f;break;case "left":this.labelPlacement.lowerLeft=f;this.labelPlacement.upperLeft=
f;break;case "right":this.labelPlacement.lowerRight=f;this.labelPlacement.upperRight=f;break;case "lower-left":case "bottom-left":this.labelPlacement.lowerLeft=f;break;case "upper-left":case "top-left":this.labelPlacement.upperLeft=f;break;case "lower-right":case "bottom-right":this.labelPlacement.lowerRight=f;break;case "upper-right":case "top-right":this.labelPlacement.upperRight=f;break;case "all":this.labelPlacement.lowerLeft=f;this.labelPlacement.lowerRight=f;this.labelPlacement.upperLeft=f;
this.labelPlacement.upperRight=f;this.labelPlacement.center=f;break;default:this.labelPlacement.lowerLeft=f,this.labelPlacement.lowerRight=f,this.labelPlacement.upperLeft=f,this.labelPlacement.upperRight=f}this.drawGrid()}},getVerticalLabels:function(){return this.verticalLabels},setVerticalLabels:function(d){"boolean"===typeof d&&(this.verticalLabels=d,this.drawGrid())},getCornerLabelXOffset:function(){return this.cornerLabelXOffset},setCornerLabelXOffset:function(d){"number"===typeof d&&(this.cornerLabelXOffset=
d,this.drawGrid())},getCornerLabelYOffset:function(){return this.cornerLabelYOffset},setCornerLabelYOffset:function(d){"number"===typeof d&&(this.cornerLabelYOffset=d,this.drawGrid())},getIntervalLabelXOffset:function(){return this.intervalLabelXOffset},setIntervalLabelXOffset:function(d){"number"===typeof d&&(this.intervalLabelXOffset=d,this.drawGrid())},getIntervalLabelYOffset:function(){return this.intervalLabelYOffset},setIntervalLabelYOffset:function(d){"number"===typeof d&&(this.intervalLabelYOffset=
d,this.drawGrid())},getColor:function(d){return"number"!==typeof d||0>d||d>this.colors.length-1?null:this.colors[d]},setColor:function(d,f){if("number"!==typeof d||0>d||d>this.colors.length-1)return null;this.colors[d]=new b(f);this.drawGrid()},setColors:function(d){if("object"!==typeof d||!d.length)return null;for(var f,k=0;k<this.colors.length;k++)f=d.length>k?k:d.length-1,this.colors[k]=new b(d[f]);this.drawGrid()},getLineWidth:function(d){return"number"!==typeof d||0>d||d>this.lineWidths.length-
1?null:this.lineWidths[d]},setLineWidth:function(d,f){if("number"!==typeof d||"number"!==typeof f||0>d||d>this.lineWidths.length-1)return null;this.lineWidths[d]=f;this.drawGrid()},setLineWidths:function(d){if("object"!==typeof d||!d.length)return null;for(var f,k=0;k<this.lineWidths.length;k++)f=d.length>k?k:d.length-1,"number"===typeof d[f]&&(this.lineWidths[k]=d[f]);this.drawGrid()},getFontSize:function(d){return"number"!==typeof d||0>d||d>this.fontSizes.length-1?null:this.fontSizes[d]},setFontSize:function(d,
f){if("number"!==typeof d||"number"!==typeof f||0>d||d>this.fontSizes.length-1)return null;this.fontSizes[d]=f;this.drawGrid()},setFontSizes:function(d){if("object"!==typeof d||!d.length)return null;for(var f,k=0;k<this.fontSizes.length;k++)f=d.length>k?k:d.length-1,"number"===typeof d[f]&&(this.fontSizes[k]=d[f]);this.drawGrid()},getCenterLabelScaleFactor:function(){return this.centerLabelScaleFactor},setCenterLabelScaleFactor:function(d){"number"===typeof d&&(this.centerLabelScaleFactor=d,this.drawGrid())},
getCenterLabelOpacity:function(){return this.centerLabelOpacity},setCenterLabelOpacity:function(d){"number"===typeof d&&(this.centerLabelOpacity=d,this._centerLabelGraphicsLayer.setOpacity(d),this.drawGrid())},getFontFamily:function(){return this.fontFamily},setFontFamily:function(d){"string"===typeof d&&(this.fontFamily=d,this.drawGrid())},getInterval:function(){return this.currentInterval},setInterval:function(){this.currentInterval=m.getInterval(this.getMinIntervalSpacing(),this.map,this.getLevelOfDetail())},
getMap:function(){return this.map},setMap:g.hitch(this,function(d){this.map.loaded&&this.clearGrid();this.map=d;if(this.enabled&&this.map.loaded)this.enable();else if(this.enabled)this.map.on("load",g.hitch(this,this.enable))}),getLineOpacity:function(){return this.lineOpacity},setLineOpacity:function(d){"number"===typeof d&&(this.lineOpacity=d,this._lineGraphicsLayer.setOpacity(d))},getLabelOpacity:function(){return this.labelOpacity},setLabelOpacity:function(d){"number"===typeof d&&(this.labelOpacity=
d,this._labelGraphicsLayer.setOpacity(d))},getSettings:function(){return{minIntervalSpacing:this.minIntervalSpacing,levelOfDetail:this.levelOfDetail,labelPlacement:this.labelPlacement,verticalLabels:this.verticalLabels,cornerLabelXOffset:this.cornerLabelXOffset,cornerLabelYOffset:this.cornerLabelYOffset,intervalLabelXOffset:this.intervalLabelXOffset,intervalLabelYOffset:this.intervalLabelYOffset,colors:q.map(this.colors,function(d){return d.toHex()}),lineWidths:this.lineWidths,fontSizes:this.fontSizes,
lineOpacity:this.lineOpacity,labelOpacity:this.labelOpacity,centerLabelOpacity:this.centerLabelOpacity,centerLabelScaleFactor:this.centerLabelScaleFactor,fontFamily:this.fontFamily}},enable:function(){var d=this.getMap();this.enabled=!0;d.addLayers(this.getLayers());this._drawEvent=d.on("extent-change",g.hitch(this,function(){this._drawGrid()}));this._drawGrid()},disable:function(){var d=this.getMap();this.enabled=!1;this._drawEvent&&(this._drawEvent.remove(),this._drawEvent=null);this.clearGrid();
for(var f=this.getLayers(),k=0;k<f.length;k++)d.removeLayer(f[k])},clearGrid:function(){var d=this.getMap();if(!d.loaded)var f=d.on("load",g.hitch(this,function(){f.remove();this.clearGrid()}));this._lineGraphicsLayer.clear();this._labelGraphicsLayer.clear();this._centerLabelGraphicsLayer.clear();this._lineGraphics=[];this._labelGraphics=[];this._centerLabelGraphics=[]},drawGrid:function(){this._drawing&&this._drawGrid()},_createExtentFromScreen:function(d,f,k,p){var v=this.map.toScreen(d);f=this.map.toMap(new a(v.x+
f,v.y+k));return new c(d.x,d.y,f.x,f.y,p)},_performOverlapCheck:function(d){for(var f=0;f<d.length;f++)for(var k=f+1;k<d.length;k++)this._doLabelsOverlap(d[f],d[k])&&d[f].symbol.setOffset(0,40)},_doLabelsOverlap:function(d,f){return d&&f?(d=this._createExtentFromScreen(d.geometry,d.symbol.getWidth(),d.symbol.getHeight(),this.map.spatialReference),f=this._createExtentFromScreen(f.geometry,f.symbol.getWidth(),f.symbol.getHeight(),this.map.spatialReference),e.intersects(d,f)):!1},_drawGrid:function(){var d=
this.getMap(),f,k;this._drawing&&clearTimeout(this._drawing);this._drawing=setTimeout(g.hitch(this,function(){if(d.loaded&&this.enabled){k=m.zonesFromExtent(this);this._zoneCount=k.length;this.clearGrid();this.setInterval();this._lineGraphics=[];this._lineGraphics0=[];this._lineGraphics1=[];this._lineGraphics2=[];this._lineGraphics3=[];this._lineGraphics4=[];this._lineGraphics5=[];m.processZonePolygons(k,this);for(f=0;f<this._centerLabelGraphics.length;f++)this._centerLabelGraphicsLayer.add(this._centerLabelGraphics[f]);
q.forEach([this._lineGraphics5,this._lineGraphics4,this._lineGraphics3,this._lineGraphics2,this._lineGraphics1,this._lineGraphics0],function(t){this._lineGraphics=this._lineGraphics.concat(t)},this);for(f=0;f<this._lineGraphics.length;f++)this._lineGraphics[f].geometry=l.project(this._lineGraphics[f].geometry,this._lineGraphicsLayer.spatialReference),this._lineGraphicsLayer.add(this._lineGraphics[f]);this._performOverlapCheck(this._labelGraphics);for(f=0;f<this._labelGraphics.length;f++){this._labelGraphics[f].geometry=
l.project(this._labelGraphics[f].geometry,this._lineGraphicsLayer.spatialReference);this._labelGraphicsLayer.add(this._labelGraphics[f]);var p=this._labelGraphics[f].getNode();if(p){var v=this._labelGraphics[f].symbol.color;v=128<.2126*v.r+.7152*v.g+.0722*v.b?"black":"white";h.has("ie")||h.has("edge")?p.className+=" text-symbol-halo-"+v:p.classList.add("text-symbol-halo-"+v)}}delete this._lineGraphics;delete this._lineGraphics0;delete this._lineGraphics1;delete this._lineGraphics2;delete this._lineGraphics3;
delete this._lineGraphics4;delete this._lineGraphics5}}),50)}})})},"widgets/GridOverlay/lib/mgrs-utils":function(){define("dojo/json ./constants ./geometry-utils ./labeling-utils ./mgrs ./NonPolarGridZone ./VisibleGridZone ./GridPolygon esri/geometry/geometryEngine esri/graphic esri/geometry/Point esri/geometry/Polyline esri/geometry/Polygon esri/symbols/SimpleLineSymbol esri/symbols/TextSymbol esri/symbols/Font esri/Color".split(" "),function(H,g,q,m,n,e,c,a,b,l,h,d,f,k,p,v,t){return{_ZonesDictionary:function(){var r,
w,u,y="CDEFGHJKLMNPQRSTUVWX".split(""),x={};for(r=1;60>=r;r++)for(w=0;w<y.length;w++){var z=u=void 0,B=void 0,E=void 0;u=void 0;var I=r+y[w];"32X"===I||"34X"===I||"36X"===I?u=null:("31V"===I?u={xmin:0,ymin:56,xmax:3,ymax:64,id:I}:"32V"===I?u={xmin:3,ymin:56,xmax:12,ymax:64,id:I}:"31X"===I?u={xmin:0,ymin:72,xmax:9,ymax:84,id:I}:"33X"===I?u={xmin:9,ymin:72,xmax:21,ymax:84,id:I}:"35X"===I?u={xmin:21,ymin:72,xmax:33,ymax:84,id:I}:"37X"===I?u={xmin:33,ymin:72,xmax:42,ymax:84,id:I}:(E=(r-1)*g.ZONE_WIDTH_DEGREES-
180,B=r*g.ZONE_WIDTH_DEGREES-180,z=w*g.ZONE_HEIGHT_DEGREES+g.MIN_MGRS_LATITUDE,u=(w+1)*g.ZONE_HEIGHT_DEGREES+g.MIN_MGRS_LATITUDE,E=180===E?g.POSITIVE_180:E,E=-180===E?g.NEGATIVE_180:E,B=180===B?g.POSITIVE_180:B,B=-180===B?g.NEGATIVE_180:B,80===u&&(u=g.MAX_MGRS_LATITUDE),u={xmin:E,ymin:z,xmax:B,ymax:u,id:I}),u=new e(u));u&&(x[u.id]=u)}return x}(),getInterval:function(r,w,u){var y=0;var x=w.getResolutionInMeters()*r;var z=w.extent.getCenter();var B=w.toMap(w.toScreen(z).offset(0,r/2));for(x=w.toMap(w.toScreen(z).offset(0,
-r/2));84<=B.getLatitude()||84<=x.getLatitude();)y++,B=w.toMap(w.toScreen(z).offset(0,r/2+y*r)),x=w.toMap(w.toScreen(z).offset(0,-r/2+y*r));for(;-80>=B.getLatitude()||-80>=x.getLatitude();)y++,B=w.toMap(w.toScreen(z).offset(0,r/2-y*r)),x=w.toMap(w.toScreen(z).offset(0,-r/2-y*r));r=B.getLatitude();w=B.getLongitude();B=x.getLatitude();y=x.getLongitude();x=n.getZoneNumber(r,w);x=Math.abs(n.LLtoUTM(r,w,x)[1]-n.LLtoUTM(B,y,x)[1]);r=Math.log10(x);switch(u){case "more":u=Math.floor(r);break;case "less":case "strict":u=
Math.ceil(r);break;default:u=Math.round(r)}u=Math.pow(10,u);x>2*u&&(u*=10);return 1E5<u?!1:u},zonesFromExtent:function(r){var w;var u=r.map.extent;var y=u.spatialReference.isWebMercator()?g.WEBMERCATOR_360:g.GEOGRAPHIC_360,x={xOffset:r.getCornerLabelXOffset(),yOffset:r.getCornerLabelYOffset(),rotation:0,color:r.getColor(0),fontFamily:r.getFontFamily(),fontSize:r.getFontSize(0)},z="CDEFGHJKLMNPQRSTUVWX".split(""),B=[];if(u.xmax-u.xmin>y)return B;y=q.extentToPolygon(u);y=q.toWebMercator(y);var E=q.pointToGeographic(new h([u.xmin,
u.ymin],u.spatialReference)),I=q.pointToGeographic(new h([u.xmax,u.ymax],u.spatialReference));u=E.y;var C=I.y;var A=E.offsetX;var F=I.offsetX;for(var G=A;G<=F;G++){var O=G>A?g.NEGATIVE_180:E.x;var N=G<F?g.POSITIVE_180:I.x;var R=Math.min(Math.max(Math.floor((u+80)/g.ZONE_HEIGHT_DEGREES),0),19);var T=Math.min(Math.floor((C+80)/g.ZONE_HEIGHT_DEGREES),19);O=Math.floor((O+180)/g.ZONE_WIDTH_DEGREES);for(N=Math.min(Math.floor((N+180)/g.ZONE_WIDTH_DEGREES)+2,60);O<=N;O++)for(var W=R;W<=T;W++){var Y=z[W];
Y=O+Y;if(this._ZonesDictionary[Y]){var Z=H.parse(H.stringify(this._ZonesDictionary[Y]._rings));for(w=0;w<Z[0].length;w++)Z[0][w][0]+=G*g.GEOGRAPHIC_360;w=new f({rings:Z});var J=new d({paths:Z});if(Z=b.intersect(q.toWebMercator(w),y))w=b.intersect(q.toWebMercator(J),y),B.push(new c({map:r.map,polyline:w,polygon:Z,offset:G,nonPolarGridZone:this._ZonesDictionary[Y],labelParameters:x}))}}}return B},processZonePolygons:function(r,w){for(var u={},y=w.getInterval(),x=0;x<r.length;x++){var z=r[x];z&&(this.handleZonePolygon(z,
w),y&&(u[z.nonPolarGridZone.utmZone]?u[z.nonPolarGridZone.utmZone].polygon=b.union([q.toWebMercator(z.polygon),u[z.nonPolarGridZone.utmZone].polygon]):u[z.nonPolarGridZone.utmZone]={polygon:q.toWebMercator(z.polygon),offset:z.offset}))}if(y)for(r=Object.keys(u),x=0;x<r.length;x++){z=r[x];var B=u[z].polygon,E=u[z].offset,I=q.toGeographic(B.getExtent()),C=n.LLtoUTM(I.ymin,I.xmin,z),A=n.LLtoUTM(I.ymin,I.xmax,z),F=n.LLtoUTM(I.ymax,I.xmax,z);I=n.LLtoUTM(I.ymax,I.xmin,z);z={minE:Math.min(C[0],A[0],F[0],
I[0]),maxE:Math.max(C[0],A[0],F[0],I[0]),minN:Math.min(C[1],A[1],F[1],I[1]),maxN:Math.max(C[1],A[1],F[1],I[1]),utmZone:z,polygon:B,offset:E,grid:w};this.handle100kGrids(z);1E5>y&&this.handleIntervals(z)}},handleZonePolygon:function(r,w){var u=r.polyline;var y=w.getColor(0);var x=w.getLineWidth(0);w._lineGraphics0.push(new l(u,new k(k.STYLE_SOLID,new t(y),x)));36978596<w.map.getScale()||w._labelGraphics.push(r.getCenterLabel(!0))},handle100kGrids:function(r){var w=r.polygon,u=r.offset,y=r.utmZone,
x=r.minE,z=r.maxE,B=r.minN,E=r.maxN;r=r.grid;var I=r.getColor(1),C=r.getLineWidth(1),A=r.getMap(),F,G;for(B=1E5*Math.floor(B/1E5);B<E;B+=1E5)for(F=1E5*Math.floor(x/1E5);F<z;F+=1E5){var O=n.findGridLetters(y,0>B+5E4?1E7+(B+5E4):B+5E4,F+5E4);var N=[];for(G=F;G<=F+1E5;G+=1E4){var R=n.UTMtoLL(B,G,y);N.push([R.lon,R.lat])}for(G=B;G<B+1E5;G+=1E4)R=n.UTMtoLL(G,F+1E5,y),N.push([R.lon,R.lat]);for(G=F+1E5;G>=F;G-=1E4)R=n.UTMtoLL(B+1E5,G,y),N.push([R.lon,R.lat]);for(G=B+1E5;G>=B;G-=1E4)R=n.UTMtoLL(G,F,y),N.push([R.lon,
R.lat]);for(G=0;G<N.length;G++)N[G][0]+=u*g.GEOGRAPHIC_360;N=new f([N]);G=q.polygonToPolyline(N);R=b.intersect(q.toWebMercator(N),q.toWebMercator(w));G=b.intersect(q.toWebMercator(G),q.toWebMercator(w));if(R&&(O={clippedPolygon:R,unclippedPolygon:N,map:A,xmin:F%1E6,ymin:B%1E6,xmax:(F+1E5)%1E6,ymax:(B+1E5)%1E6,minMaxType:"utm",utmZone:y,text:O,labelParameters:{xOffset:10,yOffset:10,rotation:0,color:r.getColor(1),fontFamily:r.getFontFamily(),fontSize:r.getFontSize(1)}},O=new a(O),!(4622324<r.map.getScale())))for(O=
[O.getCenterLabel(!0)],G&&r._lineGraphics1.push(new l(G,new k(k.STYLE_SOLID,new t(I),C))),G=0;G<O.length;G++)r._labelGraphics.push(O[G])}},handleIntervals:function(r){var w=r.polygon,u=r.utmZone,y=r.offset,x=r.minE,z=r.maxE,B=r.minN,E=r.maxN;r=r.grid;var I=r.getFontFamily(),C=r.getIntervalLabelXOffset(),A=r.getIntervalLabelYOffset(),F=r.getInterval(),G=r.getMap(),O=r.getVerticalLabels(),N;for(N=Math.floor(B/F)*F;N<=E;N+=F)if(0!==N%1E5){if(0===N%1E4){var R=2;var T=r._lineGraphics2}else 0===N%1E3?(R=
3,T=r._lineGraphics3):0===N%100?(R=4,T=r._lineGraphics4):(R=5,T=r._lineGraphics5);var W=r.getColor(R);var Y=r.getLineWidth(R);R=r.getFontSize(R);var Z=new v(R,v.STYLE_NORMAL,v.VARIANT_NORMAL,v.WEIGHT_BOLD,I);var J=[];var P=n.UTMtoLL(N,x,u);var U=n.UTMtoLL(N,z,u);for(P=0;P<z;P+=1E4){var V=n.UTMtoLL(N,x+P,u);J.push([V.lon,V.lat])}J.push([U.lon,U.lat]);for(P=0;P<J.length;P++)J[P][0]+=y*g.GEOGRAPHIC_360;if(U=b.intersect(q.toWebMercator(new d([J])),q.toWebMercator(w))){Y=new l(U,new k(k.STYLE_SOLID,new t(W),
Y));T.push(Y);T=m.padZero((0>B?1E7+N:N)%1E5/F,5-Math.log10(F));J=U.paths[0];P=new h({x:J[0][0]+.001,y:J[0][1],spatialReference:U.spatialReference});U=new h({x:J[J.length-1][0]-.001,y:J[J.length-1][1],spatialReference:U.spatialReference});Y=m.screenDistanceBetweenPoints(P,U,G).horizontal;J=m.distanceFromMapEdge(P,G).horizontal;if(2>J||200<J&&300<Y)J=(new p(T)).setAngle(0).setColor(W).setOffset(C,-(R/1.333)/2).setAlign("start").setFont(Z),J=new l(P,J),r._labelGraphics.push(J);J=m.distanceFromMapEdge(U,
G).horizontal;if(2>J||200<J&&300<Y)J=(new p(T)).setAngle(0).setColor(W).setOffset(-C,-(R/1.333)/2).setAlign("end").setFont(Z),J=new l(U,J),r._labelGraphics.push(J)}}for(x=Math.floor(x/F)*F;x<=z;x+=F)if(0!==x%1E5){0===x%1E4?(R=2,T=r._lineGraphics2):0===x%1E3?(R=3,T=r._lineGraphics3):0===x%100?(R=4,T=r._lineGraphics4):(R=5,T=r._lineGraphics5);W=r.getColor(R);Y=r.getLineWidth(R);R=r.getFontSize(R);Z=new v(R,v.STYLE_NORMAL,v.VARIANT_NORMAL,v.WEIGHT_BOLD,I);J=[];N=n.UTMtoLL(B-1E4,x,u);C=n.UTMtoLL(E+1E4,
x,u);J.push([N.lon,N.lat]);J.push([C.lon,C.lat]);for(P=0;P<J.length;P++)J[P][0]+=y*g.GEOGRAPHIC_360;if(C=b.intersect(q.toWebMercator(new d([J])),q.toWebMercator(w))){N=new l(C,new k(k.STYLE_SOLID,new t(W),Y));T.push(N);T=m.padZero(x%1E5/F,5-Math.log10(F));J=C.paths[0];N=new h({x:J[0][0],y:J[0][1]+.001,spatialReference:{wkid:102100}});C=new h({x:J[J.length-1][0],y:J[J.length-1][1]-.001,spatialReference:{wkid:102100}});Y=m.screenDistanceBetweenPoints(N,C,G).vertical;J=m.distanceFromMapEdge(N,G).vertical;
if(2>J||200<J&&300<Y)J=(new p(T)).setAngle(O?90:0).setColor(W).setOffset(O?-(R/1.333)/2:0,A).setAlign(O?"end":"middle").setFont(Z),J=new l(N,J),r._labelGraphics.push(J);J=m.distanceFromMapEdge(C,G).vertical;if(2>J||200<J&&300<Y)J=(new p(T)).setAngle(O?90:0).setColor(W).setOffset(O?-(R/1.333)/2:0,O?-A:-A-R/1.333).setAlign(O?"start":"middle").setFont(Z),J=new l(C,J),r._labelGraphics.push(J)}}}}})},"widgets/GridOverlay/lib/constants":function(){define([],function(){return{ZONE_WIDTH_DEGREES:6,ZONE_HEIGHT_DEGREES:8,
MIN_MGRS_LATITUDE:-80,MAX_MGRS_LATITUDE:84,POSITIVE_180:179.99999999,NEGATIVE_180:-179.99999999,WEST_GEOGRAPHIC_LIMIT:-180,EAST_GEOGRAPHIC_LIMIT:180,GEOGRAPHIC_360:360,WEST_WEBMERCATOR_LIMIT:-2.0037508342789244E7,EAST_WEBMERCATOR_LIMIT:2.0037508342789244E7,WEBMERCATOR_360:4.007501668557849E7,DEGREES_PER_RADIAN:57.29577951308232,RADIANS_PER_DEGREE:.017453292519943295,WGS84_EQUATORIAL_RADIUS:6378137,WGS84_HALF_EQUATORIAL_RADIUS:3189068.5,HALF_PI:1.5707963267948966}})},"widgets/GridOverlay/lib/geometry-utils":function(){define(["./constants",
"esri/geometry/webMercatorUtils","esri/geometry/Polyline","esri/geometry/Polygon"],function(H,g,q,m){return{toGeographic:function(n){return n.spatialReference.isWebMercator()?g.webMercatorToGeographic(n):n},toWebMercator:function(n){return n.spatialReference.isWebMercator()?n:g.geographicToWebMercator(n)},_latitudeToWebMercatorY:function(n){return H.GEOGRAPHIC_360/2*(H.HALF_PI-2*Math.atan(Math.exp(-1*n/H.WGS84_EQUATORIAL_RADIUS)))/Math.PI},_longitudeToWebMercatorX:function(n){var e=H.GEOGRAPHIC_360,
c=H.GEOGRAPHIC_360/2,a=H.WGS84_EQUATORIAL_RADIUS;return n/a*c/Math.PI-Math.floor((n/a*c/Math.PI+c)/e)*e},pointToGeographic:function(n){for(var e=n.x,c=n.y,a=(n=n.spatialReference.isWebMercator())?H.WEST_WEBMERCATOR_LIMIT:H.WEST_GEOGRAPHIC_LIMIT,b=n?H.EAST_WEBMERCATOR_LIMIT:H.EAST_GEOGRAPHIC_LIMIT,l=n?H.WEBMERCATOR_360:H.GEOGRAPHIC_360,h=0;e<=a;)e+=l,--h;for(;e>b;)e-=l,h+=1;n&&(e=this._longitudeToWebMercatorX(e),c=this._latitudeToWebMercatorY(c));return{x:e,y:c,offsetX:h}},extentToPolygon:function(n){return new m({rings:[[[n.xmin,
n.ymin],[n.xmax,n.ymin],[n.xmax,n.ymax],[n.xmin,n.ymax],[n.xmin,n.ymin]]],spatialReference:n.spatialReference})},polygonToPolyline:function(n){return new q({paths:n.rings,spatialReference:{wkid:n.spatialReference.wkid}})}}})},"widgets/GridOverlay/lib/labeling-utils":function(){define(["./mgrs","esri/geometry/Point"],function(H,g){var q=document.createElement("canvas").getContext("2d");return{getWidthOfText:function(m,n,e){q.font=e+"px "+n;return q.measureText(m).width},padZero:function(m,n){for(m=
m.toString();m.length<n;)m="0"+m;return m},getScreenSize:function(m,n){var e=m.getExtent();m=new g([e.xmin,e.ymin],e.spatialReference);e=new g([e.xmax,e.ymax],e.spatialReference);m=n.toScreen(m);n=n.toScreen(e);return{width:Math.abs(n.x-m.x),height:Math.abs(n.y-m.y)}},distanceFromMapEdge:function(m,n){var e=n.toScreen(m);"undefined"===typeof H&&(H=!0);var c=Math.min(Math.abs(n.width-e.x),Math.abs(e.x));n=Math.min(Math.abs(n.height-e.y),Math.abs(e.y));H&&(m=Math.round(1E4*m.getLatitude())/1E4,84===
m||-80===m)&&(n=0);return{horizontal:c,vertical:n,total:Math.sqrt(c*c+n*n)}},screenDistanceBetweenPoints:function(m,n,e){m=e.toScreen(m);e=e.toScreen(n);n=Math.abs(m.x-e.x);m=Math.abs(m.y-e.y);return{horizontal:n,vertical:m,total:Math.sqrt(n*n+m*m)}}}})},"widgets/GridOverlay/lib/mgrs":function(){define(["esri/geometry/Point"],function(H){var g=6378137;var q=.00669437999;var m=q/(1-q);var n=(1-Math.sqrt(1-q))/(1+Math.sqrt(1-q));return{setSpheroid:function(e){e=e.toUpperCase();switch(e){case "AIRY 1830":g=
6377563.396;q=.00667053999998536;break;case "AIRY MODIFIED":g=6377340.189;q=.00667053999998536;break;case "AVERAGE TERRESTRIAL SYSTEM 1977":g=6378135;q=.00669438499958795;break;case "AUSTRALIAN NATIONAL":g=6378160;q=.00669454185458764;break;case "BESSEL 1841":g=6377397.155;q=.00667437223180214;break;case "BESSEL MODIFIED":g=6377492.018;q=.00667437223180214;break;case "BESSEL NAMIBIA":g=6377483.865;q=.00667437223180214;break;case "CLARKE 1858":g=6378293.639;q=.00678514600473303;break;case "NAD27":case "CLARKE 1866":g=
6378206.4;q=.00676865799760964;break;case "CLARKE 1866 MICHIGAN":g=6378450.047;q=.00676865830738507;break;case "CLARKE 1880":g=6378249.138;q=.00680348101883452;break;case "CLARKE 1880 (ARC)":g=6378249.145;q=.00680348101883452;break;case "CLARKE 1880 (BENOIT)":g=6378300.79;q=.00680348271028565;break;case "CLARKE 1880 (IGN)":g=6378249.2;q=.00680348767623919;break;case "CLARKE 1880 (RGS)":g=6378249.145;q=.00680351128284906;break;case "CLARKE 1880 (SGA)":g=6378249.2;q=.00680348860198551;break;case "EVEREST 1830 (DEFINITION)":g=
6377299.36;q=.00663784663019969;break;case "EVEREST 1830 (MODIFIED)":g=6377304.063;q=.00663784663019969;break;case "EVEREST (ADJUSTMENT 1937)":g=6377276.345;q=.00663784663019969;break;case "EVEREST (DEFINITION 1962)":g=6377301.243;q=.00663784606842344;break;case "EVEREST (DEFINITION 1967)":g=6377298.556;q=.00663784663019969;break;case "EVEREST (DEFINITION 1975)":g=6377299.151;q=.00663784606842344;break;case "NAD83":case "GEM GRAVITY POTENTIAL MODEL":case "GRS 1980":g=6378137;q=.00669438002290079;
break;case "GRS 1967 \x3d INTERNATIONAL 1967":g=6378160;q=.00669460532856765;break;case "HELMERT 1906":g=6378200;q=.00669342162296594;break;case "INDONESIAN NATIONAL":g=6378160;q=.0066946090804091;break;case "INTERNATIONAL 1924":g=6378388;q=.00672267002233332;break;case "INTERNATIONAL 1967":g=6378160;q=.00669454185458764;break;case "KRASOVSKY 1940":g=6378245;q=.00669342162296594;break;case "TRANSIT PRECISE EPHEMERIS":g=6378145;q=.00669454185458764;break;case "OSU 1986 GEOIDAL MODEL":g=6378136.2;q=
.00669438006997852;break;case "OSU 1991 GEOIDAL MODEL":g=6378136.3;q=.00669438006997852;break;case "PLESSIS 1817":g=6376523;q=.00646954373789485;break;case "STRUVE 1860":g=6378298.3;q=.00677435980080942;break;case "WAR OFFICE":g=6378300.583;q=.00674534331628926;break;case "NWL-10D \x3d\x3d WGS 1972":g=6378135;q=.00669431777826672;break;case "WGS 1972":g=6378135;q=.00669431777826672;break;case "WGS84":case "WGS 1984":g=6378137;q=.00669437999014132;break;case "WGS 1966":g=6378145;q=.00669454185458764;
break;case "FISCHER 1960":g=6378166;q=.00669342162296594;break;case "FISCHER 1968":g=6378150;q=.00669342162296594;break;case "FISCHER MODIFIED":g=6378155;q=.00669342162296594;break;case "HOUGH 1960":g=6378270;q=.00672267002233332;break;case "EVEREST MODIFIED 1969":g=6377295.664;q=.00663784663019969;break;case "WALBECK":g=6376896;q=.00659454809414964;break;case "GRS 1967 TRUNCATED":g=6378160,q=.00669454185458764}m=q/(1-q);n=(1-Math.sqrt(1-q))/(1+Math.sqrt(1-q))},getSpheroidList:function(){return"AIRY 1830;AIRY MODIFIED;AUSTRALIAN NATIONAL;AVERAGE TERRESTRIAL SYSTEM 1977;BESSEL 1841;BESSEL MODIFIED;BESSEL NAMIBIA;CLARKE 1858;CLARKE 1866 MICHIGAN;CLARKE 1866;CLARKE 1880 (ARC);CLARKE 1880 (BENOIT);CLARKE 1880 (IGN);CLARKE 1880 (RGS);CLARKE 1880 (SGA);CLARKE 1880;EVEREST (ADJUSTMENT 1937);EVEREST (DEFINITION 1962);EVEREST (DEFINITION 1967);EVEREST (DEFINITION 1975);EVEREST 1830 (DEFINITION);EVEREST 1830 (MODIFIED);EVEREST MODIFIED 1969;FISCHER 1960;FISCHER 1968;FISCHER MODIFIED;GEM GRAVITY POTENTIAL MODEL;GRS 1967 \x3d INTERNATIONAL 1967;GRS 1967 TRUNCATED;GRS 1980;HELMERT 1906;HOUGH 1960;INDONESIAN NATIONAL;INTERNATIONAL 1924;INTERNATIONAL 1967;KRASOVSKY 1940;NWL-10D \x3d\x3d WGS 1972;OSU 1986 GEOIDAL MODEL;OSU 1991 GEOIDAL MODEL;PLESSIS 1817;STRUVE 1860;TRANSIT PRECISE EPHEMERIS;WALBECK;WAR OFFICE;WGS 1966;WGS 1972;WGS 1984".split(";")},
getZoneNumber:function(e,c){e=parseFloat(e);c=parseFloat(c);if(360<c||-180>c){for(;-180>c;)c+=360;for(;180<c;)c-=360}(360<c||-180>c||90<e||-90>e)&&console.error("Bad input. lat: "+e+" lon: "+c);c=c+180-360*Math.floor((c+180)/360)-180;var a=Math.floor((c+180)/6)+1;56<=e&&64>e&&3<=c&&12>c&&(a=32);72<=e&&84>e&&(0<=c&&9>c?a=31:9<=c&&21>c?a=33:21<=c&&33>c?a=35:33<=c&&42>c&&(a=37));return a},LLtoUTM:function(e,c,a){e=parseFloat(e);c=parseFloat(c);if(84<e||-80>e)return"undefined, ensure 84N \x3e Lat \x3e 80S";
if(360<c||-180>c){for(;-180>c;)c+=360;for(;180<c;)c-=360}(360<c||-180>c||90<e||-90>e)&&console.error("Bad input. lat: "+e+" lon: "+c);var b=c+180-360*Math.floor((c+180)/360)-180;var l=e*Math.PI/180;b=b*Math.PI/180;c=a?a:this.getZoneNumber(e,c);a=(6*(c-1)-180+3)*Math.PI/180;this.UTMLetterDesignator(e);e=g/Math.sqrt(1-q*Math.sin(l)*Math.sin(l));var h=Math.tan(l)*Math.tan(l);var d=m*Math.cos(l)*Math.cos(l);b=Math.cos(l)*(b-a);return[.9996*e*(b+(1-h+d)*b*b*b/6+(5-18*h+h*h+72*d-58*m)*b*b*b*b*b/120)+5E5,
.9996*(g*((1-q/4-3*q*q/64-5*q*q*q/256)*l-(3*q/8+3*q*q/32+45*q*q*q/1024)*Math.sin(2*l)+(15*q*q/256+45*q*q*q/1024)*Math.sin(4*l)-35*q*q*q/3072*Math.sin(6*l))+e*Math.tan(l)*(b*b/2+(5-h+9*d+4*d*d)*b*b*b*b/24+(61-58*h+h*h+600*d-330*m)*b*b*b*b*b*b/720)),c]},LLtoUSNG:function(e,c,a,b){a=a||5;var l=b?b:this.getZoneNumber(e,c);e=parseFloat(e);c=parseFloat(c);var h=this.LLtoUTM(e,c,l);b=h[0];var d=h[1];0>e&&(d+=1E7);h=this.findGridLetters(l,d,b);l=Math.round(d)%1E5;b=Math.round(b)%1E5;l=Math.floor(l/Math.pow(10,
5-a));b=Math.floor(b/Math.pow(10,5-a));e=this.getZoneNumber(e,c)+this.UTMLetterDesignator(e)+" "+h+" ";for(c=String(b).length;c<a;c++)e+="0";e+=b+" ";for(c=String(l).length;c<a;c++)e+="0";return e+l},UTMLetterDesignator:function(e){e=parseFloat(e);return 84>=e&&72<=e?"X":72>e&&64<=e?"W":64>e&&56<=e?"V":56>e&&48<=e?"U":48>e&&40<=e?"T":40>e&&32<=e?"S":32>e&&24<=e?"R":24>e&&16<=e?"Q":16>e&&8<=e?"P":8>e&&0<=e?"N":0>e&&-8<=e?"M":-8>e&&-16<=e?"L":-16>e&&-24<=e?"K":-24>e&&-32<=e?"J":-32>e&&-40<=e?"H":-40>
e&&-48<=e?"G":-48>e&&-56<=e?"F":-56>e&&-64<=e?"E":-64>e&&-72<=e?"D":-72>e&&-80<=e?"C":"Z"},findSet:function(e){e=parseInt(e,10);switch(e%6){case 0:return 6;case 1:return 1;case 2:return 2;case 3:return 3;case 4:return 4;case 5:return 5;default:return-1}},findGridLetters:function(e,c,a){e=parseInt(e,10);c=parseFloat(c);a=parseFloat(a);var b=1;for(c=Math.round(c);1E5<=c;)c-=1E5,b++;b%=20;c=0;for(a=Math.round(a);1E5<=a;)a-=1E5,c++;c%=8;return this.lettersHelper(this.findSet(e),b,c)},lettersHelper:function(e,
c,a){0===c?c=19:c--;0===a?a=7:a--;switch(e){case 1:return e="ABCDEFGHJKLMNPQRSTUV","ABCDEFGH".charAt(a)+e.charAt(c);case 2:return e="FGHJKLMNPQRSTUVABCDE","JKLMNPQR".charAt(a)+e.charAt(c);case 3:return e="ABCDEFGHJKLMNPQRSTUV","STUVWXYZ".charAt(a)+e.charAt(c);case 4:return e="FGHJKLMNPQRSTUVABCDE","ABCDEFGH".charAt(a)+e.charAt(c);case 5:return e="ABCDEFGHJKLMNPQRSTUV","JKLMNPQR".charAt(a)+e.charAt(c);case 6:return e="FGHJKLMNPQRSTUVABCDE","STUVWXYZ".charAt(a)+e.charAt(c)}},UTMtoLL:function(e,c,a){c=
parseFloat(c)-5E5;e=parseFloat(e);a=parseInt(a,10);e=e/.9996/(g*(1-q/4-3*q*q/64-5*q*q*q/256));e=e+(3*n/2-27*n*n*n/32)*Math.sin(2*e)+(21*n*n/16-55*n*n*n*n/32)*Math.sin(4*e)+151*n*n*n/96*Math.sin(6*e);var b=g/Math.sqrt(1-q*Math.sin(e)*Math.sin(e)),l=Math.tan(e)*Math.tan(e),h=m*Math.cos(e)*Math.cos(e),d=c/(.9996*b);c=e-b*Math.tan(e)/(g*(1-q)/Math.pow(1-q*Math.sin(e)*Math.sin(e),1.5))*(d*d/2-(5+3*l+10*h-4*h*h-9*m)*d*d*d*d/24+(61+90*l+298*h+45*l*l-252*m-3*h*h)*d*d*d*d*d*d/720);c=180*c/Math.PI;e=(d-(1+
2*l+h)*d*d*d/6+(5-2*h+28*l-3*h*h+8*m+24*l*l)*d*d*d*d*d/120)/Math.cos(e);e=6*(a-1)-180+3+180*e/Math.PI;a={};a.lat=c;a.lon=e;return a},USNGtoUTM:function(e,c,a,b,l,h){a=1+"ABCDEFGHJKLMNPQRSTUVWXYZ".indexOf(a)%8;var d="CDEFGHJKLMNPQRSTUVWX".indexOf(c);b=e%2?"ABCDEFGHJKLMNPQRSTUV".indexOf(b):"FGHJKLMNPQRSTUVABCDE".indexOf(b);b=Number([0,2,2,2,4,4,6,6,8,8,0,0,0,2,2,4,4,6,6,6][d])+b/10;b<[1.1,2,2.9,3.8,4.7,5.6,6.5,7.3,8.2,9.1,0,.8,1.7,2.6,3.5,4.4,5.3,6.2,7,7.9][d]&&(b+=2);d={};d.N=1E6*b+Number(h)*Math.pow(10,
5-h.length);d.E=1E5*a+Number(l)*Math.pow(10,5-l.length);d.zone=e;d.letter=c;return d},USNGtoLL:function(e){e=this.parseUSNG_str(e);var c=this.USNGtoUTM(e.zone,e.ltr,e.sq1,e.sq2,e.east,e.north);"N">e.ltr&&(c.N-=1E7);c=this.UTMtoLL(c.N,c.E,e.zone);return[c.lat,c.lon]},parseUSNG_str:function(e){var c=[];e=e.toUpperCase();c=/%20/g;c=e.replace(c,"");c=/ /g;c=e.replace(c,"");if(7>c.length)return 0;e={};var a=0;e.zone=10*c.charAt(a++)+1*c.charAt(a++);e.ltr=c.charAt(a++);e.sq1=c.charAt(a++);e.sq2=c.charAt(a++);
e.precision=(c.length-a)/2;e.east="";e.north="";for(var b=0;b<e.precision;b++)e.east+=c.charAt(a++);" "===c[a]&&a++;for(b=0;b<e.precision;b++)e.north+=c.charAt(a++);return e},isUSNG:function(e){e=e.toUpperCase();var c=/%20/g;e=e.replace(c,"");c=/ /g;e=e.replace(c,"");if(15<e.length)return 0;c=/^[0-9]{2}[CDEFGHJKLMNPQRSTUVWX]$/;if(e.match(c))return 0;c=/^[0-9]{2}[CDEFGHJKLMNPQRSTUVWX][ABCDEFGHJKLMNPQRSTUVWXYZ][ABCDEFGHJKLMNPQRSTUV]([0-9][0-9]){0,5}/;return!e.match(c)||7>e.length?0:e},LLtoMGRS:function(e,
c,a){return this.LLtoUSNG(e,c,a||5).replace(/ /g,"")},USNGtoPoint:function(e){e=this.USNGtoLL(e);return new H(e[1],e[0])},pointToUSNG:function(e,c){var a=e.getLatitude();e=e.getLongitude();return this.LLtoUSNG(a,e,c)},LLtoUSNG_nad27:function(e,c,a){return this.LLtoUSNG(e,c,a||5)+" (NAD27)"}}})},"widgets/GridOverlay/lib/NonPolarGridZone":function(){define("dojo/_base/declare dojo/json ./constants esri/geometry/Polygon esri/geometry/Polyline esri/geometry/Extent".split(" "),function(H,g,q,m,n,e){return H(null,
{extent:null,id:null,utmZone:null,latitudeZone:null,_rings:[],constructor:function(c){var a=c.id.match(/(\d+)|([A-Za-z]+)/g);this.id=c.id;this.utmZone=1*a[0];this.latitudeZone=a[1];this.extent=new e({xmin:c.xmin,ymin:c.ymin,xmax:c.xmax,ymax:c.ymax,spatialReference:c.spatialReference||{wkid:4326}});c=[this.extent.xmin,this.extent.ymin];this._rings=[[c,[this.extent.xmax,this.extent.ymin],[this.extent.xmax,this.extent.ymax],[this.extent.xmin,this.extent.ymax],c]]},toPolygon:function(c){var a=g.parse(g.stringify(this._rings));
if(c)for(var b=0;b<a[0].length;b++)a[0][b][0]+=c*q.GEOGRAPHIC_360;return new m({rings:a,spatialReference:this.spatialReference})},toPolyline:function(c){var a=g.parse(g.stringify(this._rings));if(c)for(var b=0;b<a[0].length;b++)a[0][b][0]+=c*q.GEOGRAPHIC_360;return new n({paths:a,spatialReference:this.spatialReference})}})})},"widgets/GridOverlay/lib/VisibleGridZone":function(){define(["dojo/_base/declare","./GridPolygon"],function(H,g){return H(null,{polyline:null,polygon:null,offset:null,nonPolarGridZone:null,
map:null,constructor:function(q){this.offset=Math.round(q.offset);this.polyline=q.polyline;this.polygon=q.polygon;this.nonPolarGridZone=q.nonPolarGridZone;this.map=q.map;q={clippedPolygon:this.polygon,unclippedPolygon:this.nonPolarGridZone.toPolygon(q.offset),map:this.map,xmin:this.nonPolarGridZone.extent.xmin,ymin:this.nonPolarGridZone.extent.ymin,xmax:this.nonPolarGridZone.extent.xmax,ymax:this.nonPolarGridZone.extent.ymax,minMaxType:"degrees",utmZone:0,text:this.nonPolarGridZone.id,labelParameters:q.labelParameters};
this.gridPolygon=new g(q)},getLabels:function(){return this.gridPolygon.getLabels(!0)},getCenterLabel:function(){return this.gridPolygon.getCenterLabel(!0)}})})},"widgets/GridOverlay/lib/GridPolygon":function(){define(["dojo/_base/declare","./mgrs","./labeling-utils","./LabelElement","esri/geometry/Point"],function(H,g,q,m,n){return H(null,{clippedPolygon:null,unclippedPolygon:null,map:null,xmin:0,ymin:0,xmax:0,ymax:0,minMaxType:"",utmZone:0,text:"",color:null,labelParameters:null,_centerLabelSet:!1,
_centerLabel:null,_labelsSet:!1,_labels:[],_cornerLabels:[],_borderLabels:[],_interiorLabels:[],candidatePoint:null,constructor:function(e){this.unclippedPolygon=e.unclippedPolygon;this.clippedPolygon=e.clippedPolygon;this.map=e.map;this.xmin=e.xmin;this.ymin=e.ymin;this.xmax=e.xmax;this.ymax=e.ymax;this.minMaxType=e.minMaxType;this.utmZone=Math.round(e.utmZone);this.text=e.text;this.labelParameters=e.labelParameters;this._cornerLabels=[];this._borderLabels=[];this._interiorLabels=[];this._centerLabel=
null;this._labelsSet=this._centerLabelSet=!1},getLabels:function(e){e=e||!1;this._labelsSet||(this._cornerLabels=this.setLabels(e),this._labelsSet=!0);e=0<this._cornerLabels.length?this._cornerLabels:0<this._borderLabels.length?this._borderLabels:this._interiorLabels;for(var c=0;c<e.length;c++)e[c]=e[c].getLabelGraphic();return e},getCenterLabel:function(e){this._centerLabelSet||(this.setCenterLabel(e),this._centerLabelSet=!0);return this._centerLabel.getLabelGraphic()},setCenterLabel:function(e){e=
e?this.clippedPolygon:this.unclippedPolygon;var c={xOffset:0,yOffset:0,rotation:0,color:this.labelParameters.color,fontFamily:this.labelParameters.fontFamily,fontSize:this.labelParameters.fontSize};this._centerLabel=new m({map:this.map,point:e.getCentroid(),labelParameters:c,text:this.text,verticalAlign:"middle",horizontalAlign:"middle"});c=new m({map:this._centerLabel.map,point:this._centerLabel.point,labelParameters:c,text:"utm"===this.minMaxType?"WW":"22W",verticalAlign:"middle",horizontalAlign:"middle"});
c.shrinkToFit(e,12);this._centerLabel.font.setSize(c.font.size);this._centerLabel.setExtent()},setLabels:function(e){e=e||!1;for(var c=this.clippedPolygon.rings,a=q.getScreenSize(this.clippedPolygon.getExtent(),this.map),b={xmin:Math.round(1E3*this.xmin)/1E3,ymin:Math.round(1E3*this.ymin)/1E3,xmax:Math.round(1E3*this.xmax)/1E3,ymax:Math.round(1E3*this.ymax)/1E3,map_xmin:this.map.extent.xmin,map_ymin:this.map.extent.ymin,map_xmax:this.map.extent.xmax,map_ymax:this.map.extent.ymax},l,h,d={"lower-left":{label:null,
priority:99,hidden:!1},"lower-right":{label:null,priority:99,hidden:!1},"upper-left":{label:null,priority:99,hidden:!1},"upper-right":{label:null,priority:99,hidden:!1}},f=0;f<c.length;f++){l=null;for(var k=0;k<c[f].length-1;k++){this.candidatePoint=new n(c[f][k],this.clippedPolygon.spatialReference);h=new n(c[f][k+1],this.clippedPolygon.spatialReference);if(0===k){var p=new n(c[f][c[f].length-2],this.clippedPolygon.spatialReference);l=this._findAngle(p,this.candidatePoint)}h=this._findAngle(this.candidatePoint,
h);if(h!==l&&(p="",0===h&&90===l?p="lower-right":270===h&&180===l?p="lower-right":0===h&&270===l?p="lower-left":90===h&&180===l?p="lower-left":90===h&&0===l?p="upper-left":180===h&&270===l?p="upper-left":180===h&&90===l?p="upper-right":270===h&&0===l&&(p="upper-right"),p)){l=this._findType(this.candidatePoint,b);var v=l.priority,t=new m({map:this.map,point:this.candidatePoint,labelParameters:this.labelParameters,text:this.text,verticalAlign:p.split("-")[0],horizontalAlign:p.split("-")[1]});d[p].priority>
v&&(d[p].label=t,d[p].priority=v,d[p].xOffset=l.xOffset,d[p].yOffset=l.yOffset)}l=h}}c=d["lower-left"];b=d["upper-left"];f=d["lower-right"];d=d["upper-right"];300>a.width&&(c.priority>f.priority&&(c.hidden=!0),f.priority>c.priority&&(f.hidden=!0),b.priority>d.priority&&(b.hidden=!0),d.priority>b.priority&&(d.hidden=!0));200>a.height&&(c.priority>b.priority&&(c.hidden=!0),f.priority>d.priority&&(f.hidden=!0),b.priority>c.priority&&(b.hidden=!0),d.priority>f.priority&&(d.hidden=!0));"utm"===this.minMaxType&&
(c.xOffset&&(c.label.xOffset=70),b.xOffset&&(b.label.xOffset=70),d.xOffset&&(d.label.xOffset=70),f.xOffset&&(f.label.xOffset=70),c.yOffset&&(c.label.yOffset=40),b.yOffset&&(b.label.yOffset=40),d.yOffset&&(d.label.yOffset=40),f.yOffset&&(f.label.yOffset=40));a=[];!c.hidden&&c.label&&a.push(c.label);!b.hidden&&b.label&&a.push(b.label);!d.hidden&&d.label&&a.push(d.label);!f.hidden&&f.label&&a.push(f.label);e=e?this.unclippedPolygon:this.clippedPolygon;for(d=0;d<a.length;d++)(new m({map:this.map,point:a[d].point,
labelParameters:this.labelParameters,text:"utm"===this.minMaxType?"WW":"22W",verticalAlign:a[d].verticalAlign,horizontalAlign:a[d].horizontalAlign})).fitsInPolygon(e)||(a.splice(d,1),d--);return a},_findXY:function(e){var c=e.getLongitude();e=e.getLatitude();"utm"===this.minMaxType?(e=g.LLtoUTM(e,c,this.utmZone),c=100*Math.round(e[0]/100),e=100*Math.round(e[1]/100),c%=1E6,e%=1E6):(c=Math.round(1E3*c)/1E3,e=Math.round(1E3*e)/1E3);return{x:c,y:e}},_findAngle:function(e,c){for(e=-(180*Math.atan2(c.y-
e.y,c.x-e.x)/Math.PI)+90;0>e;)e+=360;for(;360<=e;)e-=360;15>e||345<e?e=0:105>e&&75<e?e=90:195>e&&165<e?e=180:285>e&&255<e&&(e=270);return e},_findType:function(e,c){var a=this._findXY(this.candidatePoint),b=a.x;a=a.y;var l=!1,h=!1,d=0;e.x===c.map_xmin||e.x===c.map_xmax?(l=!0,d+=2):b===c.xmin||b===c.xmax?console.warn():d+=1;e.y===c.map_ymin||e.y===c.map_ymax?(h=!0,d+=2):a===c.ymin||a===c.ymax?console.warn():d+=1;return{priority:d,xOffset:l,yOffset:h}}})})},"widgets/GridOverlay/lib/LabelElement":function(){define("dojo/_base/declare ./geometry-utils ./labeling-utils esri/geometry/geometryEngine esri/geometry/screenUtils esri/graphic esri/geometry/Point esri/geometry/Extent esri/symbols/Font esri/symbols/TextSymbol".split(" "),
function(H,g,q,m,n,e,c,a,b,l){return H(null,{map:null,point:null,xOffset:0,yOffset:0,text:"",verticalAlign:"",horizontalAlign:"",rotation:0,color:null,fontFamily:"",fontSize:0,font:null,constructor:function(h){this.map=h.map;this.point=h.point;this.xOffset=h.labelParameters.xOffset||0;this.yOffset=h.labelParameters.yOffset||0;this.text=h.text;this.verticalAlign=h.verticalAlign||"bottom";this.verticalAlign.toLowerCase();this.horizontalAlign=h.horizontalAlign||"middle";this.horizontalAlign.toLowerCase();
this.rotation=h.labelParameters.rotation||0;this.rotation=90*Math.round(this.rotation/90);this.color=h.labelParameters.color;this.font=(new b).setFamily(h.labelParameters.fontFamily||"Arial, Helvetica, sans-serif").setSize(h.labelParameters.fontSize||0).setWeight(b.WEIGHT_BOLD)},getPixelWidth:function(){return 0!==this.rotation%180?this.font.size:q.getWidthOfText(this.text,this.font.family,this.font.size)},getPixelHeight:function(){return 0!==this.rotation%180?q.getWidthOfText(this.text,this.font.family,
this.font.size):this.font.size},decreaseFontSize:function(h){0!==this.font.size&&(this.font.setSize(this.font.size-(h||1)),this.setExtent())},setExtent:function(){var h=this.map,d=h.toScreen(this.point),f=this.getPixelWidth(),k=this.getPixelHeight()/1.3333;switch(this.horizontalAlign){case "left":d=d.offset(this.xOffset,0);var p=d.x;var v=d.x+f;break;case "middle":case "center":p=d.x-f/2;v=d.x+f/2;break;case "right":d=d.offset(-this.xOffset,0),p=d.x-f,v=d.x}switch(this.verticalAlign){case "bottom":case "lower":d=
d.offset(0,-this.yOffset);var t=d.y;var r=d.y-k;break;case "middle":case "center":t=d.y+k/2;r=d.y-k/2;break;case "upper":case "top":d=d.offset(0,this.yOffset),t=d.y+k,r=d.y}d=new a({xmin:p,ymin:t,xmax:v,ymax:r});this.extent=g.toWebMercator(n.toMapGeometry(h.extent,h.width,h.height,d))},getExtent:function(){this.extent||this.setExtent();return this.extent},fitsInPolygon:function(h){var d=this.getExtent();d=g.toWebMercator(d);h=g.toWebMercator(h);return m.contains(h,d)},fitsInExtent:function(h){var d=
this.getExtent();d=g.toWebMercator(d);h=g.toWebMercator(h);return m.contains(h,d)},shrinkToFit:function(h,d){d=d||0;!this.fitsInPolygon(h)&&0<this.font.size&&(this.font.setSize(this.font.size-1),this.font.size<d&&this.font.setSize(0),this.setExtent(),this.shrinkToFit(h,d))},getLabelGraphic:function(){var h=(new l(this.text)).setColor(this.color).setAlign(l.ALIGN_START).setFont(this.font),d=this.getExtent(),f=this.map.toScreen(this.point);d=this.map.toScreen(new c([d.xmin,d.ymin],d.spatialReference));
h.setOffset(d.x-f.x,-(d.y-f.y));return new e(this.point,h)}})})},"esri/dijit/BasemapGallery":function(){define("require dojo/_base/declare dojo/_base/array dojo/_base/connect dojo/_base/lang dojo/_base/kernel dojo/_base/sniff dojo/has dojo/query dojo/Deferred dojo/DeferredList dojo/dom dojo/dom-construct dojo/dom-class dijit/_Widget dijit/_Templated ../kernel ../lang ../urlUtils ../request ../geometry/Extent ../SpatialReference ../virtualearth/VETiledLayer ../layers/OpenStreetMapLayer ../layers/ArcGISTiledMapServiceLayer ../layers/ArcGISDynamicMapServiceLayer ../layers/WebTiledLayer ../layers/VectorTileLayer ../layers/TileInfo ../layers/ArcGISImageServiceLayer ../layers/ImageServiceParameters ../layers/ImageParameters ../layers/RasterFunction ../layers/RasterXLayer ./Basemap ./_EventedWidget dojo/text!./templates/BasemapGallery.html".split(" "),
function(H,g,q,m,n,e,c,a,b,l,h,d,f,k,p,v,t,r,w,u,y,x,z,B,E,I,C,A,F,G,O,N,R,T,W,Y,Z){g=g([Y,p,v],{declaredClass:"esri.dijit.BasemapGallery",widgetsInTemplate:!0,templateString:Z,loaded:!1,basemaps:[],bingMapsKey:null,flowContainer:null,_hasUI:!1,_supportsVTL:null,_selectedBasemap:null,_selectBasemapInProgress:!1,_eventMap:{load:!0,"selection-change":!0,add:["basemap"],remove:["basemap"],error:["message"]},constructor:function(J,P){J=J||{};J.map||console.error("esri.dijit.BasemapGallery: Unable to find the 'map' property in parameters");
this.map=J.map;this._hasUI=P?!0:!1;this.bingMapsKey=J.bingMapsKey&&0<J.bingMapsKey.length?J.bingMapsKey:null;this.showArcGISBasemaps=!1!==J.showArcGISBasemaps;this.basemaps=J.basemaps||[];this.basemapIds=J.basemapIds;this.referenceIds=J.referenceIds;this.basemapsGroup=J.basemapsGroup;this.arcgisUrl=t.dijit._arcgisUrl;J.portalUrl&&(this.arcgisUrl=J.portalUrl+"/sharing/rest");0>this.arcgisUrl.indexOf("://")?this.arcgisUrl=w.getProtocolForWebResource()+"//"+this.arcgisUrl:"https:"===window.location.protocol&&
(this.arcgisUrl=this.arcgisUrl.replace("http:","https:"));this.init()},init:function(){this.inherited(arguments);this._checkVTLSupport().then(n.hitch(this,function(J){this._supportsVTL=J}));q.forEach(this.basemaps,function(J){J.id&&0!==J.id.length||(J.id=this._getUniqueId());q.forEach(J.layers,function(P){P.opacity=0<=P.opacity?P.opacity:1;P.visibility=!0},this)},this);this.basemapIds&&0<this.basemapIds.length&&q.forEach(this.basemapIds,function(J){this.map.getLayer(J)._basemapGalleryLayerType="basemap"},
this);this.referenceIds&&0<this.referenceIds.length&&q.forEach(this.referenceIds,function(J){J=this.map.getLayer(J);J._basemapGalleryLayerType="reference";J.attr("data-reference",!0)},this);this.basemapsGroup&&(this.basemapsGroup.owner&&this.basemapsGroup.title||this.basemapsGroup.id)?this._findCustomBasemapsGroup(n.hitch(this,"_handleArcGISBasemapsResponse")):this.showArcGISBasemaps?this._findArcGISBasemapsGroup(n.hitch(this,"_handleArcGISBasemapsResponse")):this._finishStartup()},startup:function(){this.loaded?
this._refreshUI():m.connect(this,"onLoad",n.hitch(this,function(){this._refreshUI()}))},select:function(J){this._select(J)},getSelected:function(){return this._selectedBasemap},get:function(J){var P;for(P=0;P<this.basemaps.length;P++)if(this.basemaps[P].id===J)return this.basemaps[P];return null},add:function(J){return J&&!J.id?(J.id=this._getUniqueId(),this.basemaps.push(J),this._refreshUI(),this.onAdd(J),!0):J&&this._isUniqueId(J.id)?(this.basemaps.push(J),this._refreshUI(),this.onAdd(J),!0):!1},
remove:function(J){var P;for(P=0;P<this.basemaps.length;P++){var U=this.basemaps[P];if(U.id===J)return this._selectedBasemap&&this._selectedBasemap.id===U.id&&(this._selectedBasemap=null),this.basemaps.splice(P,1),this._refreshUI(),this.onRemove(U),U}return null},onLoad:function(){},onSelectionChange:function(){},onAdd:function(J){},onRemove:function(J){},onError:function(J){},_defaultBasemapGalleryGroupQuery:'title:"ArcGIS Online Basemaps" AND owner:esri',_basemapGalleryGroupQuery:null,_finishStartup:function(){this.loaded=
!0;this.onLoad();0===this.map.layerIds.length&&0<this.basemaps.length&&!this._selectBasemapInProgress&&this._select(this.basemaps[0].id)},_findCustomBasemapsGroup:function(J){this.basemapsGroup&&this.basemapsGroup.id?this._findArcGISBasemaps(this.basemapsGroup.id,J):(this._basemapGalleryGroupQuery='title:"'+this.basemapsGroup.title+'" AND owner:'+this.basemapsGroup.owner,this._findArcGISBasemapsGroup(J))},_findArcGISBasemapsGroup:function(J){if(this._basemapGalleryGroupQuery)this._findArcGISBasemapsGroupContent(J);
else{var P=this.arcgisUrl+"/portals/self",U={f:"json"};U.culture=e.locale;u({url:P,content:U,callbackParamName:"callback",load:n.hitch(this,function(V,D){V&&V.useVectorBasemaps&&V.vectorBasemapGalleryGroupQuery?this._checkVTLSupport().then(n.hitch(this,function(K){this._basemapGalleryGroupQuery=K?V.vectorBasemapGalleryGroupQuery:V&&V.basemapGalleryGroupQuery?V.basemapGalleryGroupQuery:this._defaultBasemapGalleryGroupQuery;this._findArcGISBasemapsGroupContent(J)})):(this._basemapGalleryGroupQuery=
V&&V.basemapGalleryGroupQuery?V.basemapGalleryGroupQuery:this._defaultBasemapGalleryGroupQuery,this._findArcGISBasemapsGroupContent(J))}),error:n.hitch(this,function(V,D){this._basemapGalleryGroupQuery=this._defaultBasemapGalleryGroupQuery})})}},_findArcGISBasemapsGroupContent:function(J){var P=n.hitch(this,"_findArcGISBasemaps"),U=this.arcgisUrl+"/community/groups",V={};V.q=this._basemapGalleryGroupQuery;V.f="json";u({url:U,content:V,callbackParamName:"callback",load:n.hitch(this,function(D,K){if(0<
D.results.length)P(D.results[0].id,J,D.results[0].sortField,D.results[0].sortOrder);else this.onError("esri.dijit.BasemapGallery: could not find group for basemaps.")}),error:n.hitch(this,function(D){this.onError("esri.dijit.BasemapGallery: could not find group for basemaps.")})})},_findArcGISBasemaps:function(J,P,U,V){var D=n.hitch(this,function(K,L,M,Q){var S=this.arcgisUrl+"/search",X={};X.q="group:"+K+' AND type:"web map" NOT type:"web mapping application"';X.sortField=M;X.sortOrder="asc"===Q?
"desc":"asc";X.num=100;X.f="json";u({url:S,content:X,callbackParamName:"callback",load:n.hitch(this,function(aa,ja){if(0<aa.results.length)L(aa.results);else this.onError("esri.dijit.BasemapGallery: could not find group for basemaps.")}),error:n.hitch(this,function(aa,ja){this.onError("esri.dijit.BasemapGallery: could not find group for basemaps.")})})});U&&V?D(J,P,U,V):u({url:this.arcgisUrl+"/community/groups/"+J,content:{f:"json"},callbackParamName:"callback",load:n.hitch(this,function(K,L){K.sortField?
D(J,P,K.sortField,K.sortOrder):D(J,P,"name","desc")}),error:n.hitch(this,function(K,L){D(J,P,"name","desc")})})},_handleArcGISBasemapsResponse:function(J){0<J.length&&(q.forEach(J,function(P,U){if(this.bingMapsKey||!this.bingMapsKey&&P.title&&-1===P.title.indexOf("Bing Maps")){U={};U.id=this._getUniqueId();U.title=P.title;U.thumbnailUrl="";if(P.thumbnail&&P.thumbnail.length&&(U.thumbnailUrl=this.arcgisUrl+"/content/items/"+P.id+"/info/"+P.thumbnail,t.id)){var V=t.id.findCredential(w.urlToObject(this.arcgisUrl).path);
V&&(U.thumbnailUrl+="?token\x3d"+V.token)}U.itemId=P.id;P=new W(U,this);this.basemaps.splice(0,0,P)}},this),this._finishStartup())},_refreshUI:function(){this._hasUI&&(f.empty(this.flowContainer),q.forEach(this.basemaps,function(J,P){J.id||(J.id="basemap_"+P);this.flowContainer.appendChild(this._buildNodeLayout(J))},this),f.create("br",{style:{clear:"both"}},this.flowContainer),this._markSelected(this._selectedBasemap))},_buildNodeLayout:function(J){var P=f.create("div",{id:"galleryNode_"+J.id,"class":"esriBasemapGalleryNode"}),
U=f.create("a",{href:"javascript:void(0);"},P);m.connect(U,"onclick",n.hitch(this,"_onNodeClick",J));var V=J.title||"";J.thumbnailUrl?f.create("img",{"class":"esriBasemapGalleryThumbnail",src:J.thumbnailUrl,title:V,alt:V},U):f.create("img",{"class":"esriBasemapGalleryThumbnail",src:H.toUrl("./images/transparent.gif"),title:V,alt:V},U);J=f.create("div",{"class":"esriBasemapGalleryLabelContainer"},P);f.create("span",{innerHTML:V,alt:V,title:V},J);return P},_onNodeClick:function(J,P){P.preventDefault();
this._markSelected(J);this.select(J.id)},_markSelected:function(J){J&&(q.forEach(e.query(".esriBasemapGallerySelectedNode",this.domNode),function(P){k.remove(P,"esriBasemapGallerySelectedNode")}),(J=d.byId("galleryNode_"+J.id))&&k.add(J,"esriBasemapGallerySelectedNode"))},_select:function(J){this._selectBasemapInProgress=!0;var P=this.get(J);P?(P.layers?this._getServiceInfos(P):(J=P.getLayers(this.arcgisUrl),n.isArray(J)?this._getServiceInfos(P):J.addCallback(n.hitch(this,function(U){this._getServiceInfos(P)}))),
this._markSelected(P)):this._selectBasemapInProgress=!1},_getServiceInfos:function(J){"https:"===location.protocol&&q.forEach(J.layers,function(U){if(this._isAgolService(U.url)||this._isHostedService(U.url))U.url=U.url.replace("http:","https:")},this);this._selectedBasemap=J;var P=[];q.forEach(J.layers,function(U){U.url&&0<U.url.length&&!U.isReference&&!U.type&&(U.deferredsPos=P.length,P.push(this._getServiceInfo(U.url)))},this);0<P.length?(new h(P)).addCallback(n.hitch(this,function(U){var V=null;
q.forEach(J.layers,function(D){if(0===D.deferredsPos||D.deferredsPos){D.serviceInfoResponse=U[D.deferredsPos][1];var K=D.serviceInfoResponse.fullExtent;K||(K=D.serviceInfoResponse.extent);V=V?V.union(new y(K)):new y(K)}},this);this.map.extent&&5>this._getIntersectionPercent(V,this.map.extent)&&this.map.setExtent(V,!0);this._switchBasemapLayers(J);this._updateReferenceLayer(J)})):(this._switchBasemapLayers(J),this._updateReferenceLayer(J))},_checkVTLSupport:function(){var J=new l;c("ie")?J.resolve(!1):
J.resolve(A.supported());return J},_switchBasemapLayers:function(J){var P=J.layers,U=!1,V,D,K;q.forEach(P,function(M){"VectorTileLayer"===M.type&&(U=!0)});if(U&&!0!==this._supportsVTL)this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because layer type is not supported by your current browser version.");else if(0<this.map.layerIds.length&&0===this.map.getNumLevels()&&("OpenStreetMap"===P[0].type||P[0].type&&-1<P[0].type.indexOf("BingMaps")||"WebTiledLayer"===P[0].type||"VectorTileLayer"===
P[0].type))this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap is a tiled service and cannot be loaded as a dynamic layer.");else{q.forEach(P,function(M){if(!M.isReference&&M.type&&-1<M.type.indexOf("BingMaps")&&!this.bingMapsKey)this.onError("esri.dijit.BasemapGallery: Invalid Bing Maps key.")},this);var L=0;q.forEach(P,function(M,Q){if(!M.isReference){if("OpenStreetMap"===M.type){if(0<this.map.layerIds.length&&0===this.map.getNumLevels()){this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap is a tiled service and cannot be loaded as a dynamic layer.");
return}var S=new B({id:"layer_osm",opacity:M.opacity})}else if(M.type&&-1<M.type.indexOf("BingMaps")){if(0<this.map.layerIds.length&&0===this.map.getNumLevels()){this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap is a tiled service and cannot be loaded as a dynamic layer.");return}S=z.MAP_STYLE_AERIAL_WITH_LABELS;"BingMapsAerial"===M.type?S=z.MAP_STYLE_AERIAL:"BingMapsRoad"===M.type&&(S=z.MAP_STYLE_ROAD);S=new z({id:"layer_bing",bingMapsKey:this.bingMapsKey,mapStyle:S,
opacity:M.opacity})}else if("WebTiledLayer"===M.type){if(0<this.map.layerIds.length&&0===this.map.getNumLevels()){this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap is a tiled service and cannot be loaded as a dynamic layer.");return}S=M.initialExtent||M.fullExtent;S=new C(M.templateUrl||M.url,{visible:M.visibility,opacity:M.opacity,copyright:M.copyright,fullExtent:M.fullExtent&&new y(M.fullExtent),initialExtent:S&&new y(S),subDomains:M.subDomains,tileInfo:M.tileInfo?
new F(M.tileInfo):null,tileServers:M.tileServers})}else if("VectorTileLayer"===M.type){S=new A(M.styleUrl,{visible:M.visibility,opacity:M.opacity});0===Q&&1<P.length&&this._removeBasemapLayers();var X=this;m.connect(S,"onLoad",n.hitch(this,function(aa,ja,oa){var qa=X._sameSpatialReference(oa.spatialReference,X.map.spatialReference);if(X.map.spatialReference&&!qa)X.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap has a different spatial reference.");else{if(0<X.map.getNumLevels()){if(qa=
X._sameTilingScheme(oa.tileInfo,X.map.__tileInfo),!qa){X.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap has a different tiling scheme.");return}}else if(X.map.loaded){X.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap is a vector tile layer and cannot be loaded as a dynamic layer.");return}0===ja&&1===P.length&&X._removeBasemapLayers();oa._basemapGalleryLayerType="basemap";X.map.addLayer(oa,aa)}},L,Q))}else if(M.serviceInfoResponse&&
M.serviceInfoResponse.mapName){V=new x(M.serviceInfoResponse.spatialReference);D=this._sameSpatialReference(V,this.map.spatialReference);if(this.map.spatialReference&&!D){this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap has a different spatial reference.");return}if(!0===M.serviceInfoResponse.singleFusedMapCache&&0<this.map.getNumLevels()){if(K=this._sameTilingScheme(M.serviceInfoResponse.tileInfo,this.map.__tileInfo),!K){this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap has a different tiling scheme.");
return}}else if(!0===M.serviceInfoResponse.singleFusedMapCache&&-1<M.serviceInfoResponse.capabilities.toLowerCase().indexOf("tilesonly")&&this.map.loaded&&0===this.map.getNumLevels()){this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap is a tiled service and cannot be loaded as a dynamic layer.");return}S=(0===this.map.layerIds.length||0<this.map.getNumLevels())&&!0===M.serviceInfoResponse.singleFusedMapCache?this._loadAsCached(M):this._loadAsDynamic(M)}else if(M.serviceInfoResponse&&
M.serviceInfoResponse.pixelSizeX){V=new x(M.serviceInfoResponse.spatialReference);D=this._sameSpatialReference(V,this.map.spatialReference);if(this.map.spatialReference&&!D){this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap has a different spatial reference.");return}if(!0===M.serviceInfoResponse.singleFusedMapCache&&0<this.map.getNumLevels()&&(K=this._sameTilingScheme(M.serviceInfoResponse.tileInfo,this.map.__tileInfo),!K)){this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap has a different tiling scheme.");
return}M.serviceInfoResponse.singleFusedMapCache&&"ArcGISImageServiceLayer"!==M.type?S="Raster"===M.serviceInfoResponse.cacheType?new T(M.url,{serviceInfo:M.serviceInfoResponse,opacity:M.opacity,visible:M.visibility,bandIds:M.bandIds&&0<M.bandIds.length?M.bandIds:null}):new E(M.url,{resourceInfo:M.serviceInfoResponse,opacity:M.opacity,visible:M.visibility}):M.serviceInfoResponse.pixelSizeX?(S=new O,S.bandIds=M.bandIds,M.renderingRule?S.renderingRule=new R(M.renderingRule):!M.bandIds&&M.serviceInfoResponse.bandCount&&
3<parseInt(M.serviceInfoResponse.bandCount,10)&&(S.bandIds=[0,1,2]),S=new G(M.url,{resourceInfo:M.serviceInfoResponse,opacity:M.opacity,visible:M.visibility,imageServiceParameters:S})):(S=new N,S.format="png24",M.serviceInfoResponse.supportedImageFormatTypes&&-1<M.serviceInfoResponse.supportedImageFormatTypes.indexOf("PNG32")&&(S.format="png32"),S=new I(M.url,{resourceInfo:M.serviceInfoResponse,opacity:M.opacity,visible:M.visibility,imageParameters:S}))}"VectorTileLayer"===M.type?L++:S&&(0===Q&&this._removeBasemapLayers(),
S._basemapGalleryLayerType="basemap",this.map.addLayer(S,L),L++)}},this);this._selectBasemapInProgress=!1;this.onSelectionChange()}},_removeBasemapLayers:function(){var J=this.map.layerIds,P=[];q.forEach(J,function(U){U=this.map.getLayer(U);"basemap"===U._basemapGalleryLayerType&&P.push(U)},this);0===P.length&&0<J.length&&P.push(this.map.getLayer(J[0]));0<P.length&&q.forEach(P,function(U){this.map.removeLayer(U)},this)},_updateReferenceLayer:function(J){var P;this._removeReferenceLayer();for(P=0;P<
J.layers.length;P++)!0===J.layers[P].isReference&&this._addReferenceLayer(J.layers[P])},_removeReferenceLayer:function(){var J;for(J=this.map.layerIds.length-1;0<=J;J--){var P=this.map.getLayer(this.map.layerIds[J]);"reference"===P._basemapGalleryLayerType&&this.map.removeLayer(P)}},_addReferenceLayer:function(J){"VectorTileLayer"===J.type?this._handleReferenceServiceInfoResponse(J):this._getServiceInfo(J.url,n.hitch(this,"_handleReferenceServiceInfoResponse",J))},_handleReferenceServiceInfoResponse:function(J,
P,U){J.serviceInfoResponse=P;if("VectorTileLayer"===J.type)var V=new A(J.styleUrl,{visible:J.visibility,opacity:J.opacity});else P&&P.mapName?V=!0===P.singleFusedMapCache?this._loadAsCached(J):this._loadAsDynamic(J):P&&P.pixelSizeX&&(J.serviceInfoResponse.singleFusedMapCache?V=new E(J.url,{resourceInfo:J.serviceInfoResponse,opacity:J.opacity,visible:J.visibility}):J.serviceInfoResponse.pixelSizeX?(U=new O,U.bandIds=J.bandIds,J.renderingRule?U.renderingRule=new R(J.renderingRule):!J.bandIds&&P.bandCount&&
3<parseInt(P.bandCount,10)&&(U.bandIds=[0,1,2]),V=new G(J.url,{resourceInfo:P,opacity:J.opacity,visible:J.visibility,imageServiceParameters:U})):(P=new N,P.format="png24",J.serviceInfoResponse.supportedImageFormatTypes&&-1<J.serviceInfoResponse.supportedImageFormatTypes.indexOf("PNG32")&&(P.format="png32"),P.transparent=!0,V=new I(J.url,{resourceInfo:J.serviceInfoResponse,opacity:J.opacity,visible:J.visibility,imageParameters:P})));V&&(V._basemapGalleryLayerType="reference",V.attr("data-reference",
!0),this.map.addLayer(V))},_getServiceInfo:function(J,P){return u({url:J,content:{f:"json"},callbackParamName:"callback",load:function(U,V){P&&P(U,V)},error:n.hitch(this,function(U,V){this.onError("esri.dijit.BasemapGallery: service not accessible.")})})},_loadAsCached:function(J){var P=[];J.displayLevels||(P=q.map(J.serviceInfoResponse.tileInfo.lods,function(V){return V.level}));var U=null;J.exclusionAreas&&J.exclusionAreas.length&&(U=[],q.forEach(J.exclusionAreas,function(V){U.push({minZoom:V.minZoom,
maxZoom:V.maxZoom,minScale:V.minScale,maxScale:V.maxScale,geometry:new y(V.geometry)})}));return new E(J.url,{resourceInfo:J.serviceInfoResponse,opacity:J.opacity,visible:J.visibility,exclusionAreas:U,displayLevels:J.displayLevels||P})},_loadAsDynamic:function(J){var P=new I(J.url,{resourceInfo:J.serviceInfoResponse,opacity:J.opacity,visible:J.visibility});J.visibleLayers&&P.setVisibleLayers(J.visibleLayers);return P},_getIntersectionPercent:function(J,P){return(J=P.intersects(J))?(J=J.getWidth()*
J.getHeight(),P=P.getWidth()*P.getHeight(),J/P*100):0},_getIds:function(){var J=[];q.forEach(this.basemaps,function(P){J.push(P.id)},this);return J},_getUniqueId:function(){for(var J=","+this._getIds().toString()+",",P=0;;)if(-1<J.indexOf(",basemap_"+P+","))P++;else return"basemap_"+P},_isUniqueId:function(J){return-1===(","+this._getIds().toString()+",").indexOf(","+J+",")?!0:!1},_isAgolService:function(J){return J?-1!==J.indexOf("/services.arcgisonline.com/")||-1!==J.indexOf("/server.arcgisonline.com/"):
!1},_isHostedService:function(J){return J?-1!==J.indexOf(".arcgis.com/"):!1},_sameSpatialReference:function(J,P){return J&&P&&J.wkt==P.wkt&&(J.wkid===P.wkid||r.isDefined(J.latestWkid)&&J.latestWkid===P.wkid||r.isDefined(P.latestWkid)&&J.wkid===P.latestWkid||r.isDefined(J.latestWkid)&&J.latestWkid===P.latestWkid)||J&&P&&J.isWebMercator()&&P.isWebMercator()?!0:!1},_sameTilingScheme:function(J,P){var U=this.map;U=U.width>U.height?U.width:U.height;var V=!1,D=!1,K,L;for(K=0;K<J.lods.length;K++){var M=
J.lods[K].scale;J.dpi!==P.dpi&&(M=J.lods[K].scale/J.dpi);for(L=0;L<P.lods.length;L++){var Q=P.lods[L].scale;J.dpi!==P.dpi&&(Q=P.lods[L].scale/P.dpi);if(Math.abs(Q-M)/Q<1/U)if(V){D=!0;break}else V=!0;if(Q<M)break}if(D)break}return D||V&&(1===J.lods.length||1===P.lods.length)?!0:!1}});a("extend-esri")&&n.setObject("dijit.BasemapGallery",g,t);return g})},"esri/virtualearth/VETiledLayer":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/json dojo/_base/array dojo/_base/config dojo/has dojo/string dojo/_base/Deferred ../kernel ../urlUtils ../SpatialReference ../layers/TileInfo ../layers/TiledMapServiceLayer ../geometry/Extent ../request".split(" "),
function(H,g,q,m,n,e,c,a,b,l,h,d,f,k,p){H=H(f,{declaredClass:"esri.virtualearth.VETiledLayer",constructor:function(v){try{if(v=g.mixin({bingMapsKey:null,culture:"en-US"},v||{}),this.url=l.getProtocolForWebResource()+"//dev.virtualearth.net/REST/v1",this._url=l.urlToObject(this.url),this.spatialReference=new h({wkid:102100}),this.tileInfo=new d({rows:256,cols:256,dpi:96,origin:{x:-2.0037508342787E7,y:2.0037508342787E7},spatialReference:{wkid:102100},lods:[{level:1,resolution:78271.5169639999,scale:2.95828763795777E8},
{level:2,resolution:39135.7584820001,scale:1.47914381897889E8},{level:3,resolution:19567.8792409999,scale:7.3957190948944E7},{level:4,resolution:9783.93962049996,scale:3.6978595474472E7},{level:5,resolution:4891.96981024998,scale:1.8489297737236E7},{level:6,resolution:2445.98490512499,scale:9244648.868618},{level:7,resolution:1222.99245256249,scale:4622324.434309},{level:8,resolution:611.49622628138,scale:2311162.217155},{level:9,resolution:305.748113140558,scale:1155581.108577},{level:10,resolution:152.874056570411,
scale:577790.554289},{level:11,resolution:76.4370282850732,scale:288895.277144},{level:12,resolution:38.2185141425366,scale:144447.638572},{level:13,resolution:19.1092570712683,scale:72223.819286},{level:14,resolution:9.55462853563415,scale:36111.909643},{level:15,resolution:4.77731426794937,scale:18055.954822},{level:16,resolution:2.38865713397468,scale:9027.977411},{level:17,resolution:1.19432856685505,scale:4513.988705},{level:18,resolution:.597164283559817,scale:2256.994353},{level:19,resolution:.298582141647617,
scale:1128.497176},{level:20,resolution:.1492910708238085,scale:564.248588}]}),this.initialExtent=this.fullExtent=new k(-2.0037508342787E7,-2.003750834278E7,2.003750834278E7,2.0037508342787E7,new h({wkid:102100})),g.mixin(this,v),this.hasAttributionData=this.showAttribution,this._initLayer=g.hitch(this,this._initLayer),this._errorHandler=g.hitch(this,this._errorHandler),this._getTileInfo=g.hitch(this,this._getTileInfo),this.bingMapsKey)this._getTileInfo();else throw Error("BingMapsKey must be provided.");
}catch(t){throw this.onError(t),t;}},_unsetMap:function(v,t){this.inherited("_unsetMap",arguments)},_getTileInfo:function(){if(this.mapStyle){var v=this._url.path+"/Imagery/Metadata/"+this.mapStyle,t=window.location.protocol;if(this.bingMapsKey){var r=this.resourceInfo;!this.loaded&&r?this._initLayer(r):p({url:v,content:g.mixin({},{uriScheme:"https:"===t?"https":"http",key:this.bingMapsKey,ss:!0,c:this.culture,include:this.hasAttributionData?"imageryProviders":null}),callbackParamName:"jsonp",load:this._initLayer,
error:this._errorHandler})}}},_initLayer:function(v,t){if(200!==v.statusCode)t=Error(),t.code=v.statusCode,t.message=v.statusDescription,t.details=v.errorDetails,t.authenticationResultCode=v.authenticationResultCode,this.onError(t);else try{this.resourceInfo=q.toJson(v);var r=v.resourceSets[0].resources[0],w=r.imageUrl.replace("{","${");this.tileServers=m.map(r.imageUrlSubdomains,function(y){var x=l.getProtocolForWebResource();return c.substitute(w,{subdomain:y}).replace("http:",x)});this._tsLength=
this.tileServers.length;if(this.loaded)this.refresh(),this.onMapStyleChange();else{this.copyright=this.copyright||"\x26copy; 2017 Microsoft Corporation and its data suppliers";this.loaded=!0;this.onLoad(this);var u=this.loadCallback;u&&(delete this.loadCallback,u(this))}}catch(y){this.onError(y)}},getAttributionData:function(){var v=new a,t=q.fromJson(this.resourceInfo),r;this.hasAttributionData&&t&&(r=g.getObject("resourceSets.0.resources.0.imageryProviders",!1,t));r?v.callback({contributors:r}):
(t=Error("Layer does not have attribution data"),t.log=n.isDebug,v.errback(t));return v},getTileUrl:function(v,t,r){return c.substitute(this.tileServers[t%this._tsLength].replace(/\{/g,"${"),{quadkey:this._getQuadKey(v,t,r),culture:this.culture,token:this.bingMapsKey})},_getQuadKey:function(v,t,r){var w="",u;for(u=v;0<u;u--){v="0";var y=1<<u-1;0!=(r&y)&&v++;0!=(t&y)&&(v++,v++);w+=v}return w},setMapStyle:function(v){this.mapStyle=v;this._getTileInfo()},setCulture:function(v){this.culture=v;this._getTileInfo()},
setBingMapsKey:function(v){this.bingMapsKey=v},onMapStyleChange:function(){}});g.mixin(H,{MAP_STYLE_AERIAL:"aerial",MAP_STYLE_AERIAL_WITH_LABELS:"aerialWithLabelsOnDemand",MAP_STYLE_ROAD:"roadOnDemand"});e("extend-esri")&&g.setObject("virtualearth.VETiledLayer",H,b);return H})},"esri/layers/WebTiledLayer":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/array dojo/_base/url dojo/sniff dojo/string ../config ../kernel ../request ../urlUtils ../SpatialReference ../geometry/Extent ./TiledMapServiceLayer ./TileInfo".split(" "),
function(H,g,q,m,n,e,c,a,b,l,h,d,f,k){function p(v,t){var r=[];if(v&&t&&(t.customLayerParameters||t.customParameters)){var w=g.clone(t.customParameters||{});g.mixin(w,t.customLayerParameters||{});v=l.urlToObject(v);for(var u in v.query)w.hasOwnProperty(u)||r.push(u+"\x3d"+v.query[u]);v=v.path+(r.length?"?"+r.join("\x26"):"")}return v}H=H(f,{declaredClass:"esri.layers.WebTiledLayer",constructor:function(v,t){t||(t={});this.urlTemplate=v=p(v,t.wmtsInfo);var r=new d(-2.0037508342787E7,-2.003750834278E7,
2.003750834278E7,2.0037508342787E7,new h({wkid:102100})),w=new d(-2.0037508342787E7,-2.003750834278E7,2.003750834278E7,2.0037508342787E7,new h({wkid:102100}));this.initialExtent=t.initialExtent||r;this.fullExtent=t.fullExtent||w;this.tileInfo=t.tileInfo?t.tileInfo:new k({dpi:96,rows:256,cols:256,origin:{x:-2.0037508342787E7,y:2.0037508342787E7},spatialReference:{wkid:102100},lods:[{level:0,resolution:156543.033928,scale:5.91657527591555E8},{level:1,resolution:78271.5169639999,scale:2.95828763795777E8},
{level:2,resolution:39135.7584820001,scale:1.47914381897889E8},{level:3,resolution:19567.8792409999,scale:7.3957190948944E7},{level:4,resolution:9783.93962049996,scale:3.6978595474472E7},{level:5,resolution:4891.96981024998,scale:1.8489297737236E7},{level:6,resolution:2445.98490512499,scale:9244648.868618},{level:7,resolution:1222.99245256249,scale:4622324.434309},{level:8,resolution:611.49622628138,scale:2311162.217155},{level:9,resolution:305.748113140558,scale:1155581.108577},{level:10,resolution:152.874056570411,
scale:577790.554289},{level:11,resolution:76.4370282850732,scale:288895.277144},{level:12,resolution:38.2185141425366,scale:144447.638572},{level:13,resolution:19.1092570712683,scale:72223.819286},{level:14,resolution:9.55462853563415,scale:36111.909643},{level:15,resolution:4.77731426794937,scale:18055.954822},{level:16,resolution:2.38865713397468,scale:9027.977411},{level:17,resolution:1.19432856685505,scale:4513.988705},{level:18,resolution:.597164283559817,scale:2256.994353},{level:19,resolution:.298582141647617,
scale:1128.497176},{level:20,resolution:.14929107082380833,scale:564.248588},{level:21,resolution:.07464553541190416,scale:282.124294},{level:22,resolution:.03732276770595208,scale:141.062147},{level:23,resolution:.01866138385297604,scale:70.5310735}]});this.spatialReference=new h(this.tileInfo.spatialReference.toJson());this.copyright=t.copyright||"";var u=new m(v);r=u.scheme+"://"+u.authority+"/";this.urlPath=v.substring(r.length);this.tileServers=t.tileServers||[];-1===u.authority.indexOf("{subDomain}")&&
this.tileServers.push(r);if(t.subDomains&&0<t.subDomains.length&&1<u.authority.split(".").length){this.subDomains=t.subDomains;var y;q.forEach(t.subDomains,function(B){-1<u.authority.indexOf("${subDomain}")?y=u.scheme+"://"+e.substitute(u.authority,{subDomain:B})+"/":-1<u.authority.indexOf("{subDomain}")&&(y=u.scheme+"://"+u.authority.replace(/\{subDomain\}/gi,B)+"/");this.tileServers.push(y)},this)}this.tileServers=q.map(this.tileServers,function(B){"/"!==B.charAt(B.length-1)&&(B+="/");return B});
this._levelToLevelValue=[];var x=0;q.forEach(this.tileInfo.lods,function(B,E){this._levelToLevelValue[B.level]=B.levelValue||B.level;0===E&&(x=this._levelToLevelValue[B.level])},this);this._wmtsInfo=t.wmtsInfo;var z=g.hitch(this,function(){this.loaded=!0;this.onLoad(this)});n("chrome")?(v=this.getTileUrl(x,0,0),t=c.defaults.io,r="with-credentials"===t.useCors?l.canUseXhr(v,!0):-1,(t=-1<r?t.corsEnabledServers[r]:null)&&t.withCredentials?b({url:v,handleAs:"arraybuffer"}).addBoth(function(){z()}):z()):
z()},getTileUrl:function(v,t,r){v=this._levelToLevelValue[v];var w=this.tileServers[t%this.tileServers.length]+e.substitute(this.urlPath,{level:v,z:v,col:r,x:r,row:t,y:t});w=w.replace(/\{level\}/gi,v).replace(/\{row\}/gi,t).replace(/\{col\}/gi,r).replace(/\{z\}/gi,v).replace(/\{x\}/gi,r).replace(/\{y\}/gi,t);w=this._appendCustomLayerParameters(w);w=this.addTimestampToURL(w);return l.addProxy(w)},_appendCustomLayerParameters:function(v){var t;if(this._wmtsInfo&&(this._wmtsInfo.customLayerParameters||
this._wmtsInfo.customParameters)){var r=g.clone(this._wmtsInfo.customParameters||{});g.mixin(r,this._wmtsInfo.customLayerParameters||{});for(t in r)v+=(-1===v.indexOf("?")?"?":"\x26")+t+"\x3d"+encodeURIComponent(r[t])}return v}});n("extend-esri")&&g.setObject("layers.WebTiledLayer",H,a);return H})},"esri/layers/VectorTileLayer":function(){(function(){var H=function(){try{var q=window.WebGLRenderingContext}catch(b){q=!1}try{for(var m=document.createElement("canvas"),n=["webgl","experimental-webgl",
"webkit-3d","moz-webgl"],e=null,c=0;c<n.length;++c){try{e=m.getContext(n[c])}catch(b){}if(e)break}var a=e}catch(b){a=!1}return q&&a?!0:!1}(),g=["dojo/_base/lang","dojo/has","dojo/Deferred","../sniff","./layer"];H&&g.push("./VectorTileLayerImpl");define(g,function(q,m,n,e,c,a){c=a?a:c.createSubclass({declaredClass:"esri.layers.VectorTileLayer",constructor:function(){var b=new n;b.reject(Error("esri.layers.VectorTileLayer is not supported"));b.promise.otherwise(q.hitch(this,function(l){this._errorHandler(l)}))}});
c.ACCESS_TOKEN=null;c.supported=function(){return H};m("extend-esri")&&q.setObject("layers.VectorTileLayer",c,e);return c})})()},"esri/layers/ImageServiceParameters":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/json dojo/has ../kernel ../lang".split(" "),function(H,g,q,m,n,e){H=H(null,{declaredClass:"esri.layers.ImageServiceParameters",extent:null,width:null,height:null,imageSpatialReference:null,format:null,interpolation:null,compressionQuality:null,bandIds:null,timeExtent:null,
mosaicRule:null,renderingRule:null,renderer:null,noData:null,compressionTolerance:null,adjustAspectRatio:null,lercVersion:null,toJson:function(c){var a=this.bbox||this.extent;c=(a=a&&c&&a._normalize(!0))?a.spatialReference.wkid||q.toJson(a.spatialReference.toJson()):null;var b=this.imageSpatialReference;a={bbox:a?a.xmin+","+a.ymin+","+a.xmax+","+a.ymax:null,bboxSR:c,size:null!==this.width&&null!==this.height?this.width+","+this.height:null,imageSR:b?b.wkid||q.toJson(b.toJson()):c,format:this.format,
interpolation:this.interpolation,compressionQuality:this.compressionQuality,bandIds:this.bandIds?this.bandIds.join(","):null,mosaicRule:this.mosaicRule?q.toJson(this.mosaicRule.toJson()):null,renderingRule:this.renderingRule?q.toJson(this.renderingRule.toJson()):null,renderer:this.renderer?q.toJson(this.renderer.toJson()):null,noData:this.noData,noDataInterpretation:this.noDataInterpretation,compressionTolerance:this.compressionTolerance,adjustAspectRatio:this.adjustAspectRatio,lercVersion:this.lercVersion};
c=this.timeExtent;a.time=c?c.toJson().join(","):null;return e.filter(a,function(l){if(null!==l&&void 0!==l)return!0})}});g.mixin(H,{INTERPOLATION_BILINEAR:"RSP_BilinearInterpolation",INTERPOLATION_CUBICCONVOLUTION:"RSP_CubicConvolution",INTERPOLATION_MAJORITY:"RSP_Majority",INTERPOLATION_NEARESTNEIGHBOR:"RSP_NearestNeighbor",NODATA_MATCH_ALL:"esriNoDataMatchAll",NODATA_MATCH_ANY:"esriNoDataMatchAny"});m("extend-esri")&&g.setObject("layers.ImageServiceParameters",H,n);return H})},"esri/layers/RasterXLayer":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/connect dojo/_base/array dojo/_base/Deferred dojo/sniff dojo/dom-construct dojo/dom-style dojo/on dojox/gfx/matrix dojo/when dojo/DeferredList ../kernel ../config ../lang ../domUtils ../urlUtils ../graphic ../request ../renderers/ClassBreaksRenderer ../renderers/StretchRenderer ../renderers/UniqueValueRenderer ../renderers/ColormapRenderer ../renderers/ShadedReliefRenderer ../geometry/Extent ../SpatialReference ../geometry/Point ./Field ./TimeInfo ./MosaicRule ./DimensionalDefinition ./PixelBlock ./ImageServiceLayerMixin ./rasterLib/raster/rasterFactory ./rasterLib/raster/rasterProjectionHelper ./rasterLib/renderer/rasterRendererHelper ./rasterLib/tile/RasterTileInfo ./rasterLib/tile/RasterTileManager ./rasterLib/tile/RasterHandler ./layer".split(" "),
function(H,g,q,m,n,e,c,a,b,l,h,d,f,k,p,v,t,r,w,u,y,x,z,B,E,I,C,A,F,G,O,N,R,T,W,Y,Z,J,P,U){var V=k.defaults.map.zoomDuration;H=H([U],{declaredClass:"esri.layers.RasterXLayer",managedSuspension:!0,opacity:1,tileMode:!0,useWebGL:!0,drawMode:!0,_eventMap:{"raster-change":!0,"renderer-change":!0},_lastPopup:[],_rasterFieldPrefix:"Raster.",_cachedVariableStats:{},_cachedVariableHistogram:{},constructor:function(D,K){K=K||{};this.tileMode=null!=K.tileMode?K.tileMode:this.tileMode;this.useWebGL=null!=K.useWebGL?
K.useWebGL:this.useWebGL;this.roaming=null!=K.roaming?K.roaming:this.roaming;this.drawMode=null!=K.drawMode?K.drawMode:this.drawMode;this.bandIds=K.bandIds&&0<K.bandIds.length?K.bandIds:null;this.renderer=K.renderer;this._customModules=K.customModules;this.useMapTime=K.useMapTime;if(K.multidimensionalDefinition&&0<K.multidimensionalDefinition.length){var L=new G;L.multidimensionalDefinition=K.multidimensionalDefinition.map(function(M){return M.toJson?M:new O(M)});L.method=G.METHOD_NONE;this.mosaicRule=
L}this.infoTemplate=K.infoTemplate;this.drawMode||(this._contextType=K._contextType||K.drawType);this._supportLegacyPropMethods=!1!==K.legacySupport;this._rasterHandler=new P({customModules:this._customModules});this._workInitPromise=this._rasterHandler.start();this.pixelData=null;this._initialize(D,K);b(this,"load",g.hitch(this,function(){h(this._rasterHandler._connected||this._rasterHandler._connectionPromise,g.hitch(this,function(){this._rasterHandler.setLayer({layerId:this.id,raster:{rasterInfo:this.raster.rasterInfo,
rasterFunction:this.raster.rasterFunction&&this.raster.rasterFunction.toJson()},bandCount:this.raster.rasterInfo.bandCount});this.raster.rasterFunction&&this._rasterHandler.setRasterFunction({layerId:this.id,data:this.raster.rasterFunction.toJson(!0)});this._rasterRenderer&&this._rasterHandler.setRasterRenderer({layerId:this.id,data:this._rasterRenderer.toJson(!0)})}))}));this._animatePan2d=g.hitch(this,this._animatePan2d)},setOpacity:function(D){this.opacity!==D&&(this.opacity=D,this.onOpacityChange(D))},
onOpacityChange:function(){},onRendererChange:function(){},refresh:function(){if(this.loaded&&this._map)if(!this._canDraw()||10>e("ie"))this.onError(Error("Unable to refresh. This layer is not supported in the current browser."));else this._map&&this._extentChangeHandler(this._map.extent)},clear:function(D,K,L,M){this._canDraw()&&(this.useWebGL||(L?this._context.clearRect(D,K,L,M):this._context.clearRect(0,0,this._map.width,this._map.height)))},getContext:function(){return this._context},onResume:function(){this.inherited(arguments);
this._toggleTime();v.show(this._div);if("css-transforms"===this._map.navigationMode){var D=this._map.__visibleDelta;this._left=this._tdx=D.x;this._top=this._tdy=D.y;a.set(this._div,f._css.names.transform,f._css.translate(this._left,this._top))}this._displayTimer=this._displayTimer||setTimeout(g.hitch(this,function(){this._extentChangeHandler(this._map.extent,null,!0)}),0)},onSuspend:function(){this.inherited(arguments);this._fireUpdateEnd();this._toggleTime();v.hide(this._div);clearTimeout(this._displayTimer);
this._displayTimer=null},redraw:function(){this.useWebGL&&this._glSetting&&(this._glSetting.hasNewTexture=!1);var D=this.tileMode?this.tileManager.originalPixelData:this.originalPixelData;if(this.tileMode?D&&(D.src||D.texture):D)if(this.tileMode)if(this.useWebGL)this._updateAllTilesOnce(D);else{this.tileManager.tiles.forEach(function(L){L&&(L.update=null,L.completed=!1,L.processedPixelBlock=null,L.renderedPixelBlock=null)});D.processedPixelBlock=null;var K=this.raster.rasterFunction?this.raster.rasterFunction.read(D):
{extent:D.extent,pixelBlock:D.src[this.tileManager.identifiers[0]]&&D.src[this.tileManager.identifiers[0]].pixelBlock};D.renderedPixelBlock=null;D=this._rasterRenderer?this._rasterRenderer.draw(K):K;this._drawOneFrame(D)}else this._supportLegacyPropMethods&&this.pixelFilter?this._setPixelData(this.originalPixelData):(D.processedPixelBlock=null,K=this.raster.rasterFunction?this.raster.rasterFunction.read(D):{extent:D.extent,pixelBlock:D.src?D.src[this.tileManager.identifiers[0]]&&D.src[this.tileManager.identifiers[0]].pixelBlock:
D.pixelBlock},D.renderedPixelBlock=null,D=this._rasterRenderer?this._rasterRenderer.draw(K):K,this._drawOneFrame(D))},getCurrentResolution:function(){var D=this._map.extent;return new C((D.xmax-D.xmin)/this._map.width,(D.ymax-D.ymin)/this._map.height,D.spatialReference)},getCustomRasterFields:function(D){var K=D?D.rasterAttributeTableFieldPrefix:this._rasterFieldPrefix,L={name:this._rasterFieldPrefix+"ServicePixelValue",alias:"Pixel Value",domain:null,editable:!1,length:50,type:10.3<=this.version?
"esriFieldTypeDouble":"esriFieldTypeString"};D=this.fields?g.clone(this.fields):[];D.push(L);(L=this.rasterAttributeTable&&this.rasterAttributeTable.fields)&&0<L.length&&(L=m.filter(L,function(M){return"esriFieldTypeOID"!==M.type&&"value"!==M.name.toLowerCase()}),L=m.map(L,function(M){var Q=g.clone(M);Q.name=K+M.name;return Q}),D=D.concat(L));return D},setRenderer:function(D,K){if(this.loaded&&D){if(D.declaredClass&&-1<D.declaredClass.indexOf("esri.layers.rasterLib")){this._rasterRenderer=D;this._rasterRenderer.bind({layer:this});
var L=this.bandIds=D.bandIndex;this.raster&&this.raster.setFetchParameters({bandIds:L});this._params&&(this._params.bandIds=L&&0<L.length?L.join(","):null);this.renderer=this._getCommonRenderer(D)}else L=g.clone(D.toJson?D.toJson():D),"rasterStretch"===L.type&&(L.bandIndex=this.bandIds,L.bandIndex&&1<L.bandIndex.length||!L.bandIndex&&this.raster&&1<this.raster.rasterInfo.bandCount)&&(L.type="rgb"),this._rasterRenderer=Y.create(L),this.renderer=D.declaredClass?D:this._getCommonRenderer(this._rasterRenderer),
this._rasterRenderer.bind({layer:this});if(this._map){if(this.loaded&&this._rasterHandler._connected){var M=this._rasterHandler.setRasterRenderer({layerId:this.id,data:this._rasterRenderer.toJson(!0)});this._updateTilingEffects()}K||(M?M.then(g.hitch(this,function(){this.redraw()})):this.redraw());this.onRendererChange()}}},setBandIds:function(D,K){this.bandIds=D;this.raster&&this.raster.setFetchParameters({bandIds:D});this._params&&(this._params.bandIds=D&&0<D.length?D.join(","):null);this.setRenderer(this.renderer,
K)},_setTime:function(D){D=D?D.toJson():null;this._params&&(this._params.time=D);this.raster.setFetchParameters({time:D});this.tileManager&&this.tileManager.tiles&&this.tileManager.resetTiles()},setInfoTemplate:function(D){this.infoTemplate=D;this._updateInfoTemplateFields(this.fields)},setMultiDimensionalDefinition:function(D,K){var L=D&&D.multidimensionalDefinition;if(L&&this.loaded){var M=L&&L[0].variableName;""===M&&(M=this._multidimensionalInfo.variables[0].name,L.forEach(function(S){S.variableName=
M}));if("ImageService"===this.raster.sourceType){var Q=this.raster._getAllDimensionDefinition(L,M);Q.defChanged&&(D.multidimensionalDefinition=Q.definition,this.setMosaicRule(D,!0))}this.raster.setFetchParameters({multidimensionalDefinition:L});this.tileManager&&this.tileManager.tiles&&this.tileManager.resetTiles();M&&this._updateRasterInfo(M);K||this.refresh()}},_updateRasterInfo:function(D){var K=this.raster.rasterInfo,L=this.getHistograms(D);D=this.getStatistics(D);(new d([L,D])).then(g.hitch(this,
function(M){M[0][0]&&(K.histograms=M[0][1].histograms);M[1][0]&&(K.statistics=M[1][1]);this.refresh()}))},_updateInfoTemplateFields:function(D){if(D&&!(1>D.length)&&this.infoTemplate&&this.infoTemplate.info&&this.infoTemplate.info.fieldInfos&&!(1>this.infoTemplate.info.fieldInfos.length)){var K,L;var M=this.infoTemplate.info.fieldInfos;for(K=0;K<D.length;K++){var Q=D[K];for(L=0;L<M.length;L++)if(M[L].fieldName.toLowerCase()===Q.name.toLowerCase()&&M[L].fieldName!==Q.name){M[L].fieldName=Q.name;break}}}},
getPixelData:function(D){return this.tileMode?D?this.tileManager.originalPixelData.src&&this.tileManager.originalPixelData.src[this.tileManager.identifiers[0]]:null:this.inherited(arguments)},fetchPopupFromTiles:function(D){var K=new n;this.identify(D.geometry).then(function(L){var M=L.pixelValue;this.hasStdTime()&&M&&M.length&&null!=M[0]&&(M=M.map(function(X){return this.getStdTimeValue(X)}.bind(this)).join(", "));if(M){L={ObjectId:0,"Raster.ServicePixelValue":M};var Q=this.rasterAttributeTable&&
this.rasterAttributeTable.features;if(Q&&0<Q.length&&(Q=m.filter(Q,function(X){if(X&&X.attributes)return X.attributes.hasOwnProperty("Value")?X.attributes.Value==M:X.attributes.VALUE==M}),0<Q.length&&(Q=g.clone(Q[0]))))for(var S in Q.attributes)Q.attributes.hasOwnProperty(S)&&(L[this._rasterFieldPrefix+S]=Q.attributes[S]);S=new r(new E(this.projectedFullExtent||this.fullExtent),null,L);S.setInfoTemplate(this.infoTemplate);S._layer=this;this._lastPopup=[S];K.resolve([S])}else this._lastPopup=[],K.resolve()}.bind(this),
function(L){this._lastPopup=[];K.resolve(L)});return K},getPopupFromTiles:function(){return this._lastPopup},identify:function(D,K){return this.raster?this.raster.identify(D):(D=new n,D.reject("layer must be initialized to identify"),D.promise)},_getCommonRenderer:function(D){switch(D.rendererName){case "RGB":case "Stretch":return new y(D.toCommonRendererJson());case "UniqueValue":return new x(D.toCommonRendererJson());case "ClassBreaks":return new u(D.toCommonRendererJson());case "Colormap":return new z(D.toCommonRendererJson());
case "ShadedRelief":return new B(D.toCommonRendererJson())}},_getProjectedFullExtent:function(D){return this.raster.getProjectedFullExtent(D).then(g.hitch(this,function(K){this.projectedFullExtent=K}))},_initialize:function(D,K){K=K||{};this._supportLegacyPropMethods&&this.constructor._onMap&&(this.constructor._onMap["rendering-change"]={method:"onRenderingChange"},this.constructor._onMap["mosaic-rule-change"]={method:"onMosaicRuleChange"},this.constructor._onMap["spatial-reference-change"]={method:"onSpatialReferenceChange"});
this.raster={};var L=K.raster?K.raster.url:D;L&&-1<L.toLowerCase().indexOf("/imageserver")&&this._supportLegacyPropMethods&&this._addLegacySupport(L,K);var M=g.hitch(this,function(){this.loaded=!0;this.mosaicRule&&this.mosaicRule.multidimensionalDefinition&&0<this.mosaicRule.multidimensionalDefinition.length&&this.setMultiDimensionalDefinition(this.mosaicRule,!0);this.raster._setRasterHandler(this._rasterHandler);this.onLoad(this);var Q=this._loadCallback;Q&&(delete this._loadCallback,Q(this))});
(D?T.create(g.mixin({url:D},K)):K.raster&&K.raster.open()).then(g.hitch(this,function(Q){if(Q){this.raster=Q;var S=this._getSourceImageServiceRaster();this.url||(this.url=S&&S.url);this.url&&(this._url=t.urlToObject(D));var X=K.minScale,aa=K.maxScale,ja=Q.tileInfo&&"Raster"===Q.tileInfo.tileType;null==aa&&(aa=ja&&K.zoomFactor?Q.tileInfo.lods[Q.tileInfo.lods.length-1].scale/K.zoomFactor:this.maxScale);null==X&&(X=ja&&K.zoomFactor?Q.tileInfo.lods[0].scale*K.zoomFactor:this.minScale);S&&"ImageService"===
S.sourceType&&this._supportLegacyPropMethods&&this._addGeneralProperties(D,K);this.initialExtent=this.fullExtent=this.extent=this.raster.rasterInfo.extent;this.spatialReference=this.extent.spatialReference;this.timeInfo=this.raster.rasterInfo.timeInfo?new F(this.raster.rasterInfo.timeInfo):null;this.rasterAttributeTable=this.raster.rasterInfo.vat;this._multidimensionalInfo=this.raster.rasterInfo.multidimensionalInfo;this.rasterAttributeTable&&(this._rasterAttributeTableFields=this.rasterAttributeTable.fields);
this.mosaicRule&&this.raster.setFetchParameters({multidimensionalDefinition:this.mosaicRule.multidimensionalDefinition});this._multidimensionalInfo&&(this._getDefaultMultidimensionalDefinition(this._multidimensionalInfo,!0,!0),this.mosaicRule||(this.mosaicRule=this.defaultMosaicRule,this.raster.setFetchParameters({multidimensionalDefinition:this._defaultMultidimensionalDefinition})),this.raster.defaultMultidimensionalDefinition=this._defaultMultidimensionalDefinition);null==X||this._hasMin||this.setMinScale(X);
null==aa||this._hasMax||this.setMaxScale(aa);this._workInitPromise?this._workInitPromise.then(M,M):M()}else console.error("cannot create rasterx layer as the raster data source cannot be opened")}),this._errorHandler)},_getSourceImageServiceRaster:function(){var D=this.raster&&"Function"===this.raster.sourceType?1===this.raster.getMemberRasters().length?this.raster.getMemberRasters()[0]:null:this.raster;if(D&&"ImageService"===D.sourceType)return D},_addLegacySupport:function(D,K){this._url=t.urlToObject(D);
K=K||{};this.format=(D=K.imageServiceParameters)&&D.format;this.compressionTolerance=D&&D.compressionTolerance?D.compressionTolerance:.01;this.interpolation=D?D.interpolation:null;this.compressionQuality=D?D.compressionQuality:null;this.bandIds=D&&D.bandIds||K&&K.bandIds||null;this.mosaicRule||(this.mosaicRule=D?D.mosaicRule:null);this.renderingRule||(this.renderingRule=D?D.renderingRule:null);this.useMapDimensionValue=K.hasOwnProperty("useMapDimensionValue")?!!K.useMapDimensionValue:!0;this.hasImageFilter=
K.hasImageFilter;this.activeMapDimensions=K.activeMapDimensions;this._params=g.mixin({},this._url.query,{f:"image",interpolation:this.interpolation,format:this.format,compressionQuality:this.compressionQuality,bandIds:this.bandIds?this.bandIds.join(","):null},D?D.toJson():{});this.pixelFilter=K.pixelFilter;this.originalPixelData=this.pixelData=null;this._queryVisibleRastersHandler=g.hitch(this,this._queryVisibleRastersHandler);this._useRenderingRuleAttributeTable=!1;this._rasterFunctionTemplateInfos=
{};this._customRenderingRuleId={};this._setDefaultFilter=function(){};var L={setInterpolation:"interpolation",setCompressionQuality:"compressionQuality",setCompressionTolerance:"compressionTolerance",setBandIds:"bandIds",setDefaultBandIds:"bandIds",setMosaicRule:"mosaicRule",setRenderingRule:"renderingRule",setImageFormat:"format"},M,Q=new R;Object.keys(L).forEach(g.hitch(this,function(S){this[S]=g.hitch(this,function(X,aa){M={};M[L[S]]=X;this.raster&&(this.raster.setFetchParameters(M),Q[S].bind(this)(X,
aa))})}));this.setDisableClientCaching=function(S){Q.setDisableClientCaching.bind(this)(S);var X=this._getSourceImageServiceRaster();X?X.disableClientCaching=S:null}.bind(this);this.setDefinitionExpression=Q.setDefinitionExpression.bind(this);this.setUseMapTime=Q.setUseMapTime.bind(this);this._toggleTime=Q._toggleTime.bind(this);this._onTimeExtentChangeHandler=Q._onTimeExtentChangeHandler.bind(this);this.setPixelFilter=Q.setPixelFilter.bind(this);this.getHistograms=Q.getHistograms.bind(this);this.getRasterFunctionInfos=
Q.getRasterFunctionInfos.bind(this);this.getKeyProperties=Q.getKeyProperties.bind(this);this.getRasterAttributeTable=Q.getRasterAttributeTable.bind(this);this.getRenderingRuleServiceInfo=Q.getRenderingRuleServiceInfo.bind(this);this._getRenderingRuleId=Q._getRenderingRuleId.bind(this);this._isRenderingRuleAProcessingTemplate=Q._isRenderingRuleAProcessingTemplate.bind(this);this.handleSpatialReferenceChange=Q.handleSpatialReferenceChange.bind(this);this.onRenderingChange=this.onRenderingChange||function(){};
this.onSpatialReferenceChange=this.onSpatialReferenceChange||function(){};this.onMosaicRuleChange=this.onMosaicRuleChange||function(S){};this.setRasterRenderer=this.setRenderer;this.getMultidimensionalInfo=Q.getMultidimensionalInfo.bind(this);this.getColormap=Q.getColormap.bind(this);this.getRenderingRuleColormap=Q.getRenderingRuleColormap.bind(this);this.getDefaultMultidimensionalDefinition=Q.getDefaultMultidimensionalDefinition.bind(this);this._getDefaultMultidimensionalDefinition=Q._getDefaultMultidimensionalDefinition.bind(this);
this._getDefaultDimensionValue=Q._getDefaultDimensionValue.bind(this);this.getStatistics=Q.getStatistics.bind(this)},_addGeneralProperties:function(){var D=this._getSourceImageServiceRaster();if(D){var K=["minScale","maxScale","tileInfo"];Object.keys(D.serviceInfo).forEach(function(Q){null==this[Q]&&-1===K.indexOf(Q)&&(this[Q]=D.serviceInfo[Q])}.bind(this));this.pixelSizeX=parseFloat(this.pixelSizeX);this.pixelSizeY=parseFloat(this.pixelSizeY);this.bands=D.rasterInfo.statistics;var L,M=[];this.fields=
this.fields||[];for(L=0;L<this.fields.length;L++)M.push(new A(this.fields[L]));this.fields=M;this.version=this.currentVersion;this.defaultMosaicRule=D.serviceInfo.defaultMosaicRule}},setDefaultRenderer:function(){if(this.loaded&&this._canvas&&!this.pixelFilter){var D=Y.createDefaultRenderer(this);if(null!=D){var K=this.mosaicRule&&this.mosaicRule.multidimensionalDefinition&&0<this.mosaicRule.multidimensionalDefinition.length;if(this._multidimensionalInfo&&K&&"Stretch"===D.rendererName){var L=this.mosaicRule.multidimensionalDefinition[0].variableName;
(K=this._multidimensionalInfo.variables.filter(function(M){return M.name===L})[0])&&K.histograms&&K.histograms.length&&(D.histograms=K.histograms,6===D.stretchType&&(D.dra=!1));K&&K.statistics&&K.statistics.length&&(D.statistics=K.statistics.map(function(M){return[M.min,M.max,M.mean,M.stddev||M.standardDeviation]}),6!==D.stretchType&&(D.dra=!1))}this.setRenderer(D,!0)}}},setDefaultInterpolation:function(){if(this.loaded&&this._canvas){var D=this.raster.serviceInfo&&this.raster.serviceInfo.defaultResamplingMethod;
if(D)switch(D.toLowerCase()){case "bilinear":this.interpolation="RSP_BilinearInterpolation";break;case "cubic":this.interpolation="RSP_CubicConvolution";break;case "majority":this.interpolation="RSP_Majority";break;case "nearest":this.interpolation="RSP_NearestNeighbor"}else{D=this.raster.dataType&&this.raster.dataType.toLowerCase();var K=!!this.raster.rasterInfo.colormap;this.raster.rasterInfo.vat||K||"thematic"===D||"StdTime"===D?"RSP_NearestNeighbor":"RSP_BilinearInterpolation"}}},_toggleTime:function(){},
_updateTilingEffects:function(){(this._hasTilingEffects=this._rasterRenderer&&this._rasterRenderer.hasTilingEffects()||this.raster&&this.raster.rasterFunction&&this.raster.rasterFunction.hasTilingEffects())&&this._map&&this.tileMode&&this.useWebGL&&this.tileManager&&(this._hasTilingEffects=!1)},_setMap:function(D,K){this.inherited(arguments);D.spatialReference&&(D.spatialReference.ics||D.spatialReference.icsId)&&(this.roaming=this.useWebGL=this.tileMode=!1);if(this.tileMode){this.virtualTileInfo=
new Z(null,{refTileInfo:D.tileInfo,spatialReference:D.spatialReference,extent:this.raster.rasterInfo.extent});var L=this.raster.tileInfo&&(-1<["Elevation","Raster"].indexOf(this.raster.tileInfo.tileType)||3===this.raster.rasterInfo.bandCount&&"U8"===this.raster.rasterInfo.pixelType)?this.raster.tileInfo:this.virtualTileInfo;this._tileParams=this._tileParams||{};this._tileParams.size=L.cols+","+L.rows;this.tileManager=new J({tileInfo:L,layer:this,mapSR:D.spatialReference})}this._dragOrigin={x:0,y:0};
L=this._div=c.create("div",null,K);var M={width:D.width+"px",height:D.height+"px",position:"absolute"};"css-transforms"===D.navigationMode?this.roaming&&this.tileMode&&this.useWebGL||(M[f._css.names.transform]=f._css.translate(D.__visibleDelta.x,D.__visibleDelta.y),this._left=D.__visibleDelta.x,this._top=D.__visibleDelta.y):this._left=this._top=0;a.set(L,M);this._canvas=c.create("canvas",{width:D.width+"px",height:D.height+"px",style:"position: absolute;"},L);p.isDefined(this.opacity)&&a.set(L,"opacity",
this.opacity);this._contextType?(this._context=this._canvas.getContext(this._contextType,null),this.useWebGL=this._context instanceof WebGLRenderingContext):this.useWebGL?(this._context=this._canvas.getContext("webgl",null)||this._canvas.getContext("experimental-webgl",null),this.drawMode=!1):(this._context=this._canvas.getContext("2d"),this.drawMode=!0);this._context||console.error("Unable to create the context. This browser might not support \x3ccanvas\x3e elements.");this.useWebGL&&(D.acquireWebGLContext(this),
this._glSetting={gl:this._context,branchCount:this.raster.rasterFunction?this.raster.rasterFunction.branchCount:0,pingpong:null,branches:null,drawMesh:this._drawMesh,programUniforms:{}});this.raster.rasterFunction&&(this._updateTilingEffects(),this.raster.setProcessingContext({layer:this}));this.setRenderer(this.renderer,!0);this._rasterRenderer||this.setDefaultRenderer();this.interpolation||this.setDefaultInterpolation();this._mapWidth=D.width;this._mapHeight=D.height;this._connects=[];this._connects.push(q.connect(D,
"onPan",this,this._panHandler));this._connects.push(q.connect(D,"onPanEnd",this,this._panEndHandler));"css-transforms"===D.navigationMode?this._connects.push(q.connect(D,"onScale",this,this._onScaleHandler)):(this._connects.push(q.connect(D,"onZoom",this,this._onZoomHandler)),this._connects.push(q.connect(D,"onZoomEnd",this,this._onZoomEndHandler)));this._connects.push(q.connect(D,"onResize",this,this._onResizeHandler));this._connects.push(q.connect(D,"onExtentChange",this,this._extentChangeHandler));
this._connects.push(q.connect(this,"onVisibilityChange",this,this._visibilityChangeHandler));this._connects.push(q.connect(this,"onOpacityChange",this,this._opacityChangeHandler));this._startRect={left:0,top:0,width:D.width,height:D.height};this.evaluateSuspension();if(this.suspended&&!D.loaded)var Q=q.connect(D,"onLoad",this,function(){q.disconnect(Q);Q=null;this.evaluateSuspension()});return L},_unsetMap:function(D,K){this.useWebGL&&D.releaseWebGLContext(this);m.forEach(this._connects,q.disconnect,
this);var L=this._div;L&&(K.removeChild(L),c.destroy(L));this._map=this._canvas=this._context=this.data=this._connects=null;clearTimeout(this._displayTimer);this._displayTimer=null;this.inherited(arguments)},_canDraw:function(){return!!(this._map&&this._canvas&&this._context)},_requestDataErrorHandler:function(D){"CancelError"!==D.name&&(this.clear(),this.onError(D))},_clonePixelData:function(D){if(null===D||D.texture)return D;var K={};D.extent&&(K.extent=g.clone(D.extent));var L=D.pixelBlock;null!=
L&&(K.pixelBlock=L.clone());K.texture=D.texture;return K},_setPixelData:function(D){if(D){D=this._clonePixelData(D);this.pixelFilter&&(this.pixelFilter.filter?(this.pixelFilter.renderTexture=!0,this.pixelFilter.filter(D)):this.pixelFilter(D));this.pixelData=D;if(this._rasterReadPromise&&this._rasterReadPromise.isCanceled())return;this._drawPixelData()}this._rasterReadPromise=null},_requestData:function(D,K,L){this._rasterReadPromise&&this._rasterReadPromise.cancel();D=g.clone(D)._normalize(!0);this._rasterReadPromise=
this.raster.read({extent:D,width:this._map.width,height:this._map.height});this._rasterReadPromise.then(g.hitch(this,function(M){this._rasterReadPromise&&this._rasterReadPromise.isCanceled()||(this.originalPixelData=M&&M.srcData?{extent:M.extent,src:M.srcData}:M,this.useWebGL&&this._glSetting&&(this._glSetting.hasNewTexture=!0),this._setPixelData(M))}),g.hitch(this,this._requestDataErrorHandler));return this._rasterReadPromise},_drawPixelData:function(D){a.set(this._canvas,{left:"0px",top:"0px",width:this._map.width+
"px",height:this._map.height+"px"});this._startRect={left:0,top:0,width:this._map.width,height:this._map.height};this.drawMode||"css-transforms"!==this._map.navigationMode||(this._tdx=this._left,this._tdy=this._top,this._multiply=null,a.set(this._div,f._css.names.transform,f._css.translate(this._left,this._top)),a.set(this._canvas,f._css.names.transform,f._css.translate(-this._left,-this._top)),this._dragOrigin={x:0,y:0});this.useWebGL&&this._rasterRenderer&&this._rasterRenderer.draw(this.pixelData);
if(this._canDraw()&&this.drawMode&&this.drawMode&&(D=D||this.pixelData)&&D.pixelBlock){var K=this.pixelFilter?this.pixelData:this._rasterRenderer?this._rasterRenderer.draw(D):D;D=K.pixelBlock;var L=this._context,M=L.createImageData(D.width,D.height);M.data.set(D.getAsRGBA());K=K.extent;var Q=this._map.extent,S=this.getCurrentResolution(),X=0,aa=0;Math.abs(K.xmin-Q.xmin)>S.x&&(X=Math.round((K.xmin-Q.xmin)/S.x));Math.abs(Q.ymax-K.ymax)>S.y&&(aa=Math.round((Q.ymax-K.ymax)/S.y));"css-transforms"===this._map.navigationMode?
(this._tdx=this._left,this._tdy=this._top,this._multiply=null,a.set(this._div,f._css.names.transform,f._css.translate(this._left,this._top)),a.set(this._canvas,f._css.names.transform,f._css.translate(-this._left,-this._top))):(a.set(this._div,{left:"0px",top:"0px",width:this._map.width+"px",height:this._map.height+"px"}),a.set(this._canvas,{left:"0px",top:"0px",width:this._map.width+"px",height:this._map.height+"px"}));this._dragOrigin={x:0,y:0};this.tileMode?this.clear(X,aa,D.width,D.height):this.clear();
L.putImageData(M,X,aa,0,0,D.width,D.height);this._fireUpdateEnd()}},hasStdTime:function(){if(!this.hasMultidimensions||"StdTime"!==this.raster.dataType)return!1;var D=this.mosaicRule&&this.mosaicRule.multidimensionalDefinition,K=D&&D.length?D[0].variableName:this._defaultMultidimensionalDefinition[0].variableName;return this.raster.rasterInfo.multidimensionalInfo.variables.some(function(L){if(L.name===K)return L.dimensions.some(function(M){return"StdTime"===M.name})})},getStdTimeValue:function(D){return(new Date(864E5*
(D-25569))).toString()},_animatePan2d:function(){this._oldDelta&&this._delta.x===this._oldDelta.x&&this._delta.y===this._oldDelta.y||(this.tileManager.updateTile(this.tileManager.originalPixelData,!0),this._oldDelta={x:this._delta.x,y:this._delta.y});this._roamingAnimation&&this.tileMode&&this.useWebGL&&(this._roamingAnimation=requestAnimationFrame(this._animatePan2d))},_cancelAnimation:function(){this._animation&&(cancelAnimationFrame(this._animation),this._animation=null)},_updateAllTilesOnce:function(D,
K){return this.tileManager.updateTile(D,!0).then(g.hitch(this,function(L){(this._hasTilingEffects||this.useWebGL||K)&&this._drawOneFrame(L)}))},_drawOneFrame:function(D,K){if(!(this.suspended||!this._map||this.tileMode&&!this._drawTile||(this.tileMode&&this.useWebGL&&this.tileManager.originalPixelData.isEmpty&&this._context.clear(this._context.COLOR_BUFFER_BIT),this.tileMode&&this.useWebGL&&this.tileManager.xformSetting&&this.tileManager.xformSetting.requireProjection&&!this.tileManager.xformSetting.gridConfig))){if(!this._resetCss||
this._levelChange)this._levelChange=!1,this._resetDrawing();if(D&&(D.renderedPixelBlock||D.pixelBlock)&&this._canDraw()&&this.drawMode){K=D.extent;var L=this._map.extent;if(!this._isExtentOutSide(K,L)){var M=D.pixelBlock||D.renderedPixelBlock,Q=this._context,S=Q.createImageData(M.width,M.height);S.data.set((D.renderedPixelBlock||D.pixelBlock).getAsRGBA());D=this.getCurrentResolution();var X=0,aa=0;Math.abs(K.xmin-L.xmin)>D.x&&(X=Math.round((K.xmin-L.xmin)/D.x));Math.abs(L.ymax-K.ymax)>D.y&&(aa=Math.round((L.ymax-
K.ymax)/D.y));Q.putImageData(S,X,aa,0,0,M.width,M.height)}}else this._fireUpdateEnd()}},_isExtentOutSide:function(D,K){return D.xmax<=K.xmin||D.xmin>=K.xmax||D.ymax<=K.ymin||D.ymin>=K.ymax},_resetDrawing:function(){this._resetCss=!0;if(!this.useWebGL)if(this._multiply||this._startRect.width!==this._map.width||this._startRect.height!==this._map.height)this.clear();else{var D=this._context.getImageData(0,0,this._map.width,this._map.height);this.clear();this._context.putImageData(D,this._startRect.left,
this._startRect.top)}this._dragOrigin={x:0,y:0};this._startRect={left:0,top:0,width:this._map.width,height:this._map.height};a.set(this._canvas,{left:"0px",top:"0px",width:this._map.width+"px",height:this._map.height+"px"});"css-transforms"===this._map.navigationMode?(this.roaming&&this.tileMode&&this.useWebGL&&(this._delta=null),this._tdx=this._left,this._tdy=this._top,this._multiply=null,a.set(this._div,f._css.names.transform,f._css.translate(this._left,this._top)),a.set(this._canvas,f._css.names.transform,
f._css.translate(-this._left,-this._top))):(a.set(this._div,{left:"0px",top:"0px",width:this._map.width+"px",height:this._map.height+"px"}),a.set(this._canvas,{left:"0px",top:"0px",width:this._map.width+"px",height:this._map.height+"px"}))},_drawAllFrames:function(){if(!this.suspended&&this._map&&(!this.tileMode||this._drawTile))if(this._resetCss){var D=this._frames,K=0,L;for(L=0;L<D.length;L++)if(D[L].completed)K++;else if(D[L].tileData.renderedPixelBlock){D[L].completed=!0;var M=D[L].tileData;break}else if(D[L].tileData._fetched&&
!D[L].tileData.src){D[L].completed=!0;break}else if(D[L].tileData.update&&D[L].tileData.update.isFulfilled()&&!D[L].tileData.renderedPixelBlock){D[L].completed=!0;break}else D[L].tileData.fetch&&(!0===D[L].tileData.fetch||D[L].tileData.fetch.isCanceled()||D[L].tileData.fetch.isRejected())?(D[L].completed=!0,K++):this._isExtentOutSide(D[L].tileData.extent,this._map.extent)&&(D[L].completed=!0,K++);if(M){K++;var Q=M.extent,S=this._map.extent,X=this.getCurrentResolution(),aa=L=0;Math.abs(Q.xmin-S.xmin)>
X.x&&(L=Math.round((Q.xmin-S.xmin)/X.x));Math.abs(S.ymax-Q.ymax)>X.y&&(aa=Math.round((S.ymax-Q.ymax)/X.y));M.renderedPixelBlock?(Q=M.renderedPixelBlock,S=this._context.createImageData(Q.width,Q.height),S.data.set(M.renderedPixelBlock.getAsRGBA()),this._context.putImageData(S,L,aa,0,0,Q.width,Q.height)):this.clear(L,aa,M.width,M.height)}K===D.length?(this._animation=null,this._fireUpdateEnd()):this._animation=requestAnimationFrame(g.hitch(this,this._drawAllFrames))}else this._resetDrawing(),this._animation=
requestAnimationFrame(g.hitch(this,this._drawAllFrames))},_fetchTiles:function(D,K){if(!this.suspended&&this.loaded){this._cancelAnimation();var L=this.tileManager,M=!(L.xformSetting.requireProjection&&L.xformSetting.requirePE)||W.load();h(M,g.hitch(this,function(){L.updateExtent(D,this.getCurrentResolution());this._resetCss=!1;L.fetchTiles(K);K&&(this._hasTilingEffects||this.useWebGL?this.useWebGL&&0<L.tiles.length?(L.fillupTiles(),L._validateRawPixelBlocks(L.originalPixelData)?this._updateAllTilesOnce(L.originalPixelData):
L.originalPixelData&&L.originalPixelData.src&&L.tiles.some(function(Q){return Q.updateCompleted})&&this._context.clear(this._context.COLOR_BUFFER_BIT),L.tiles.forEach(g.hitch(this,function(Q){Q.update&&!Q.updateCompleted&&Q.update.then(function(S){Q.updateCompleted||(Q.updateCompleted=!0);(this._hasTilingEffects||this.useWebGL)&&this._drawOneFrame(S)}.bind(this))}))):this._hasTilingEffects&&h(L.fetchAllCompleted.isResolved()||L.fetchAllCompleted,g.hitch(this,function(){this._updateAllTilesOnce(L.originalPixelData)})):
(this._frames=L.tiles.map(function(Q){return{completed:!1,tileData:Q}}),this._drawAllFrames()))}))}},_redrawTiles:function(){this._fetchTiles(this._map.extent,!0)},_panHandler:function(D,K){this._drawTile=!1;"css-transforms"===this._map.navigationMode?this.roaming&&this.tileMode&&this.useWebGL?(this._delta=K,!this._roamingAnimation&&this.tileMode&&(this._roamingAnimation=requestAnimationFrame(this._animatePan2d))):(this._left=this._map.__visibleDelta.x+K.x,this._top=this._map.__visibleDelta.y+K.y,
a.set(this._div,f._css.names.transform,f._css.translate(this._left,this._top))):a.set(this._div,{left:this._startRect.left+K.x+"px",top:this._startRect.top+K.y+"px"});this.tileMode&&this._fetchTiles(D)},_panEndHandler:function(D,K){K&&(this._startRect.left+=K.x,this._startRect.top+=K.y);this.oldData=null;this._roamingAnimation&&(cancelAnimationFrame(this._roamingAnimation),this._oldDelta=this._roamingAnimation=null)},_onScaleHandler:function(D,K){var L={},M=f._css.names;a.set(this._canvas,M.transition,
K?"none":M.transformName+" "+V+"ms ease");this._matrix=D;D=this._multiply?l.multiply(D,this._multiply):D;if(this._tdx||this._tdy)D=l.multiply(D,{xx:1,xy:0,yx:0,yy:1,dx:-this._tdx,dy:-this._tdy});L[M.transform]=f._css.matrix(D);a.set(this._canvas,L)},_onZoomHandler:function(D,K,L){var M=this._startRect;D=M.width*K;K*=M.height;var Q=M.left-(D-M.width)*(L.x-M.left)/M.width;L=M.top-(K-M.height)*(L.y-M.top)/M.height;a.set(this._canvas,{left:Q+"px",top:L+"px",width:D+"px",height:K+"px"});this._endRect=
{left:Q,top:L,width:D,height:K}},_onZoomEndHandler:function(){this._endRect&&(this._startRect=this._endRect)},_onResizeHandler:function(D,K,L){a.set(this._div,{width:K+"px",height:L+"px"});a.set(this._canvas,{width:K+"px",height:L+"px"});this._startRect.width=this._canvas.width=K;this._startRect.height=this._canvas.height=L;this.useWebGL&&this._glSetting&&(this._glSetting.pingpong=null,this._glSetting.branches=null)},_extentChangeHandler:function(D,K,L,M){if(this.loaded&&!this.suspended&&(!K||0!==
K.x||0!==K.y||L)){this._drawTile=!0;"css-transforms"===this._map.navigationMode&&(K&&(this._dragOrigin.x+=K.x,this._dragOrigin.y+=K.y),this._left=this._map.__visibleDelta.x,this._top=this._map.__visibleDelta.y,this.roaming&&this.tileMode&&this.useWebGL||L||a.set(this._div,f._css.names.transform,f._css.translate(this._left,this._top)),L&&(a.set(this._canvas,f._css.names.transition,"none"),this._multiply=this._multiply?l.multiply(this._matrix,this._multiply):this._matrix,this._levelChange=!0));this._fireUpdateStart();
var Q=this._map;K=this.raster.rasterFunction?this.raster.getMemberRasters().map(function(X){return X._rasterId}):[this.raster._rasterId];var S={};this.tileMode?((this.roaming||this.useWebGL)&&this.tileMode||(K.forEach(function(X,aa){S[X]={extent:Q.extent,pixelBlock:new N({width:Q.width,height:Q.height,pixels:[],pixelType:"",mask:null,statistics:[]})}}),this.tileManager.originalPixelData={extent:Q.extent,src:S}),this.projectedFullExtent?this._fetchTiles(D,!0):this._getProjectedFullExtent(Q.spatialReference).then(g.hitch(this,
function(){this._fetchTiles(D,!0)}))):this._requestData(Q.extent,Q.width,Q.height)}},_visibilityChangeHandler:function(D){D?v.show(this._div):v.hide(this._div)},_opacityChangeHandler:function(D){a.set(this._div,"opacity",D)}});e("extend-esri")&&g.setObject("layers.RasterXLayer",H,f);return H})},"esri/layers/rasterLib/raster/rasterFactory":function(){define("require dojo/_base/declare dojo/_base/lang dojo/_base/Deferred dojo/_base/array dojo/_base/config dojo/sniff dojo/when ../../../kernel ../../../Evented ../../../request ../../../deferredUtils ../../../urlUtils ./ImageServiceRaster ./TileServiceRaster ./TileRaster ./FunctionRaster".split(" "),
function(H,g,q,m,n,e,c,a,b,l,h,d,f,k,p,v,t){H={customDrivers:[],create:function(r){if(r){if(r.url){var w=f.urlToObject(r.url);var u=w.path;var y=w.query}w=r.serviceInfo;var x=r.rasterFxArgs||{},z=new m,B=q.hitch(this,function(A){console.error(A);this._trycustomDrivers(q.mixin({url:u},r),0,z)});if(u)if(-1===u.toLowerCase().indexOf("imageserver")&&-1===u.toLowerCase().indexOf("mapserver")){var E=new v(q.mixin({},r,{url:u}));r.rasterFx&&(E=new t({rasterFx:r.rasterFx,rasterFxArgs:q.mixin({},x,{raster:E})}));
var I=E}else{I=new m;w=w||this._getServiceInfo(u,y);var C=q.hitch(this,function(A){A.bandCount?E=A.capabilities&&-1<A.capabilities.toLowerCase().indexOf("tileonly")?new p(q.mixin({},{serviceInfo:A},y,r,{url:u})):new k(q.mixin({},{serviceInfo:A},y,r,{url:u})):A.tileInfo&&(E=new p(q.mixin({},{serviceInfo:A},y,this._options,{url:u})));r.rasterFx&&(E=new t({rasterFx:r.rasterFx,rasterFxArgs:q.mixin({},x,{raster:E})}));I.resolve(E)});a(w,C,B)}else I=E=new t({rasterFx:r.rasterFx,rasterFxArgs:q.mixin({},
x,{raster:E})});a(I,q.hitch(this,function(A){A?A.open().then(q.hitch(this,function(F){z.resolve(A)}),B):B(Error("There is no raster to open"))}),B);return z.promise}},register:function(r){this.customDrivers=this.customDrivers||[];0<this.customDrivers.filter(function(w){return w.sourceType===r.prototype.sourceType}).length||this.customDrivers.push(r)},_trycustomDrivers:function(r,w,u){u=u||new m;var y=this.customDrivers[w];if(y){var x=new y(r);x.open().then(q.hitch(this,function(z){u.resolve(x)}),
q.hitch(this,function(z){this._trycustomDrivers(r,w+1,u)}))}else u.reject("cannot load layer "+(r&&r.url||""));return u.promise},_getServiceInfo:function(r,w){w=w||{};var u=w.bandIds;w=w.renderingRule;var y=new m(d._dfdCanceller),x={f:"json"};u&&(x.bandIds=u);w&&(x.renderingRule=w.toJson?JSON.stringify(w.toJson()):JSON.stringify(w));y._pendingDfd=h({url:r,content:x,handleAs:"json",callbackParamName:"callback"});y._pendingDfd.then(function(z){y.callback(z)},function(z){y.errback(z)});return y.promise}};
c("extend-esri")&&q.setObject("layers.rasterLib.raster.rasterFactory",H,b);return H})},"esri/layers/rasterLib/raster/ImageServiceRaster":function(){define("require dojo/_base/declare dojo/_base/lang dojo/_base/Deferred dojo/_base/array dojo/_base/config dojo/_base/json dojo/sniff dojo/DeferredList dojo/when ../../../kernel ../../../Evented ../../../request ../../../geometry/Extent ../../../geometry/Point ../../../SpatialReference ../../../WKIDUnitConversion ../../../deferredUtils ../../../urlUtils ../../MosaicRule ../../ImageServiceParameters ../../PixelBlock ./RasterInfo ./BasicRaster ../../rasterFormats/rasterCodec ../tile/RasterTileInfo".split(" "),
function(H,g,q,m,n,e,c,a,b,l,h,d,f,k,p,v,t,r,w,u,y,x,z,B,E,I){H=g([B],{declaredClass:"esri.layers.rasterLib.raster.ImageServiceRaster",sourceType:"ImageService",constructor:function(C){C&&(this._imageServiceParams=C.imageServiceParameters,this._commonReqParams=C._commonReqParams,this._imageServiceParams||(this._imageServiceParams={interpolation:C.interpolation,pixelType:C.pixelType,format:C.format||"lerc",compressionQuality:C.compressionQuality,bandIds:C.bandIds,noDataInterpretation:C.noDataInterpretation,
adjustAspectRatio:C.adjustAspectRatio,mosaicRule:C.mosaicRule,renderingRule:C.interpolation}))},open:function(){var C=new m;if(this.serviceInfo&&this.rasterInfo)return this.loaded=!0,this._findCredential(),this.setFetchParameters(this._imageServiceParams),C.resolve(this),C.promise;var A=this.serviceInfo||this._generateServiceInfo(this._imageServiceParams&&this._imageServiceParams.renderingRule),F=q.hitch(this,function(O){this._fixServiceInfo(O);this.serviceInfo=O;this._findCredential();var N=this._parseRasterInfo(O),
R={};O.defaultMosaicMethod?(R.method=O.defaultMosaicMethod,R.operation=O.mosaicOperator,R.sortField=O.sortField,R.sortValue=O.sortValue):R.method=u.METHOD_NONE;this.serviceInfo.defaultMosaicRule=new u(R);this.serviceInfo.defaultMosaicRule.ascending=!0;O=this._getColormap(this);R=this._getHistograms(this);var T=this._getRasterAttributeTable(this),W=this._getKeyProperties(this),Y=this._getMultidimensionalInfo(),Z=this._getSlices();(new b([O,R,T,W,Y,Z])).then(q.hitch(this,function(J){J[0][0]&&(N.colormap=
J[0][1]);J[1][0]&&(N.histograms=J[1][1]);J[2][0]&&(N.vat=J[2][1]);J[3][0]&&(N.keyProperties=J[3][1]);J[4][0]&&(N.multidimensionalInfo=J[4][1]);this._slices=J[5][0]?J[5][1]:null;N.keyProperties&&N.keyProperties.DataType&&(this.dataType=N.keyProperties.DataType);this.loaded=!0;this.rasterInfo=N;this.setFetchParameters(this._imageServiceParams);C.resolve(this)}))}),G=q.hitch(this,function(O){this.loaded=!0;C.reject(O)});l(A,F,G);return C.promise},setFetchParameters:function(C,A){if(A)this.imageServiceParams=
C;else{var F=this.imageServiceParams;F&&C?Object.keys(C).forEach(function(G){F[G]=C[G]}):this.imageServiceParams=C}this._constructGetImageParams();this._getRasterIdentifier(!0)},read:function(C){if(C.pixelBlock||C.texture){var A=new m;A.resolve(C);return A.promise}if(!1===C.virtual&&this.tileInfo&&!this.tileInfo.virtual)return this.readTile(C);if(this._slices){var F=this._getSliceId();if(null==F)return A=new m,A.resolve(C),A.promise}var G=C.extent,O=G.spatialReference.wkid||c.toJson(G.spatialReference.toJson(!1)),
N=C.timeExtent?C.timeExtent.toJson().join(","):null;A=this.url+"/exportImage";var R={};this._slices&&(R.sliceid=F);this.disableClientCaching&&(R._ts=(new Date).getTime());F=q.mixin({},this._commonReqParams,{bbox:G.xmin+","+G.ymin+","+G.xmax+","+G.ymax,imageSR:O,bboxSR:O,size:C.width+","+C.height,time:N},R);return this._requestPixels({url:A,payload:F,decodeParams:{width:C.width,height:C.height,planes:null,pixelType:null,format:null,decodeFunc:null,isPoint:!1},tileOptions:C})},readTile:function(C){var A=
this.tileBoundary&&this.tileBoundary[C.level];if(A&&(A.minRow>C.row||A.maxRow<C.row||A.minCol>C.col||A.maxCol<C.col)){var F=new m;F.resolve(C);return F.promise}if(this._slices&&(F=this._getSliceId(),null==F))return F=new m,F.resolve(C),F.promise;A=this.url+"/tile/"+C.level+"/"+C.row+"/"+C.col;var G={width:this.tileInfo.cols,height:this.tileInfo.rows,planes:null,pixelType:null,format:null,decodeFunc:null,isPoint:"elevation"===C.tileType.toLowerCase()?!0:!1};F=this._slices?"sliceid\x3d"+F+"\x26":"";
F=this.disableClientCaching?"_ts\x3d "+(new Date).getTime():F.replace(/&$/,"");return this._requestPixels({url:A+(0<F.length?"?"+F:""),payload:{},decodeParams:G,tileOptions:C})},toJson:function(){return{url:this.url,tileInfo:this.tileInfo,rasterInfo:this.rasterInfo,serviceInfo:this.serviceInfo,sourceType:this.sourceType,_commonReqParams:this._commonReqParams,_rasterId:this._rasterId}},_getSliceId:function(){var C=q.clone(this._imageServiceParams.multidimensionalDefinition),A=q.clone(this._imageServiceParams.time);
if(null==this._slices||null==A&&(null==C||0===C.length))return 0;var F=C||this.defaultMultidimensionalDefinition,G=F[0].variableName;F=this._getAllDimensionDefinition(F,G).definition;C=null;if(null==F||0===F.length)return null;if(A&&this.serviceInfo.timeInfo){if(null==A[1]||A[1]===A[0])var O=A[0];else{var N=this.serviceInfo.timeInfo.startTimeField;O=this.rasterInfo.multidimensionalInfo.variables.find(function(W){return W.name===G}).dimensions.find(function(W){return W.name===N}).values.filter(function(W){return Array.isArray(W)?
Math.max(W[0],A[0])<Math.min(W[1],A[1]):W>=A[0]&&W<=A[1]}).sort(function(W,Y){W=Array.isArray(W)?W[1]:W;Y=Array.isArray(Y)?W[1]:Y;return Math.abs(A[1]-W)-Math.abs(A[1]-Y)})[0]||[A[1]]}F.some(function(W){if(W.dimensionName===N)return W.values[0]=O,!0;if(!W.dimensionName)return W.dimensionName=N,W.isSlice=!0,W.values=[O],!0})||F.push({variableName:G,dimensionName:N,isSlice:!0,values:[O]})}for(var R=0;R<this._slices.length;R++){var T=this._slices[R].multidimensionalDefinition;if(T.length===F.length&&
!T.some(function(W){var Y=F.filter(function(J){return W.variableName===J.variableName&&J.dimensionName===W.dimensionName})[0];if(!Y)return!0;var Z=Array.isArray(W.values[0])?W.values[0][0]:W.values[0];Y=Array.isArray(Y.values[0])?Y.values[0][0]:Y.values[0];return Z!==Y})){C=R;break}}return C},_getAllDimensionDefinition:function(C,A){var F=C.map(function(O){return O.dimensionName}),G=!1;this.rasterInfo.multidimensionalInfo.variables.forEach(function(O){O.name!==A||O.dimensions.length===C.length&&F[0]||
(O.dimensions.forEach(function(N){0>F.indexOf(N.name)&&(F[0]?C.push({variableName:A,dimensionName:N.name,values:[N.values[0]]}):(C[0].dimensionName=N.name,C[0].values=[N.values[0]],N[0]=N.name))}),G=!0)},this);return{defChanged:G,definition:C}},_generateServiceInfo:function(C){var A=this.url,F=new m(r._dfdCanceller);F._pendingDfd=f({url:A,content:{f:"json",renderingRule:C?c.toJson(C.toJson()):null},handleAs:"json",callbackParamName:"callback"});F._pendingDfd.then(function(G){F.callback(G)},function(G){F.errback(G)});
return F},_fixServiceInfo:function(C){var A=C.spatialReference.wkid;C.tileInfo&&0===C.extent.xmin&&360===C.extent.xmax&&A&&null==t[A]&&(C.tileInfo.applyGCS360Transform=!0)},_parseRasterInfo:function(C){var A=new z;A.bandCount=C.bandCount;A.extent=new k(C.fullExtent);A.spatialReference=C.spatialReference;A.pixelType=C.pixelType;A.width=Math.floor((C.fullExtent.xmax-C.fullExtent.xmin)/C.pixelSizeX+.5);A.height=Math.floor((C.fullExtent.ymax-C.fullExtent.ymin)/C.pixelSizeY+.5);A.cellSize=new p({x:C.pixelSizeX,
y:C.pixelSizeY,spatialReference:C.spatialReference});var F;if(C.minValues&&0<C.minValues.length&&C.maxValues&&C.stdvValues&&C.meanValues){var G=[];for(F=0;F<C.minValues.length;F++)G.push({min:C.minValues[F],max:C.maxValues[F],mean:C.meanValues[F],stddev:C.stdvValues[F]});C.bandCount!==G.length&&(G=null)}this.dataType=C.serviceDataType?C.serviceDataType.replace("esriImageServiceDataType",""):"Generic";A.statistics=G;C.objectIdField&&C.fields&&(A.catalogInfo={objectIdField:C.objectIdField,fields:C.fields});
A.timeInfo=C.timeInfo;if(C.tileInfo){this.tileInfo=new I(C.tileInfo);this.tileInfo.tileType=C.cacheType||"Map";A.tileInfo=this.tileInfo;var O=A.extent,N=this.tileInfo.origin,R=this.tileInfo.cols,T=this.tileInfo.rows;this.tileBoundary=this.tileInfo.lods.map(function(W){return{minCol:Math.floor((O.xmin-N.x+.1*W.resolution)/R/W.resolution),maxCol:Math.floor((O.xmax-N.x-.1*W.resolution)/R/W.resolution),minRow:Math.floor((N.y-O.ymax+.1*W.resolution)/T/W.resolution),maxRow:Math.floor((N.y-O.ymin-.1*W.resolution)/
T/W.resolution)}})}return A},_getColormap:function(C){C=this.url+"/colormap";var A=new m(r._dfdCanceller),F={f:"json"},G=this.serviceInfo.hasColormap||this.rasterInfo&&this.rasterInfo.hasColormap;10<this.serviceInfo.currentVersion&&G?(A._pendingDfd=f({url:C,content:F,handleAs:"json",callbackParamName:"callback"}),A._pendingDfd.then(function(O){A.callback(O.colormap)},function(O){A.errback(O)})):A.callback(null);return A},_getHistograms:function(C){var A=this.url+"/histograms",F=new m(r._dfdCanceller),
G={f:"json"},O=this.serviceInfo.hasHistograms||this.rasterInfo&&this.rasterInfo.hasHistograms;C&&C.renderingRule&&(G.renderingRule=c.toJson(C.renderingRule.toJson()),O=!0);10<this.serviceInfo.currentVersion&&O?(F._pendingDfd=f({url:A,content:G,handleAs:"json",callbackParamName:"callback"}),F._pendingDfd.then(function(N){F.callback(N.histograms)},function(N){F.errback(N)})):F.callback(null);return F},_getRasterAttributeTable:function(C){var A=this.url+"/rasterAttributeTable",F=new m(r._dfdCanceller),
G={f:"json"},O=this.serviceInfo.hasRasterAttributeTable;C&&C.renderingRule&&(G.renderingRule=c.toJson(C.renderingRule.toJson()),O=!0);10<this.serviceInfo.currentVersion&&O?(F._pendingDfd=f({url:A,content:G,handleAs:"json",callbackParamName:"callback"}),F._pendingDfd.then(function(N){F.callback(N)},function(N){F.errback(N)})):F.callback(null);return F},_getKeyProperties:function(C){var A=this.url+"/keyProperties",F=new m(r._dfdCanceller),G={f:"json"};C&&C.renderingRule&&(G.renderingRule=c.toJson(C.renderingRule.toJson()));
10<this.serviceInfo.currentVersion?(F._pendingDfd=f({url:A,content:G,handleAs:"json",callbackParamName:"callback"}),F._pendingDfd.then(function(O){F.callback(O)},function(O){F.errback(O)})):F.callback(null);return F},_getMultidimensionalInfo:function(){var C=this.url+"/multidimensionalInfo",A=new m(r._dfdCanceller);10.3<=this.serviceInfo.currentVersion&&this.serviceInfo.hasMultidimensions?(A._pendingDfd=f({url:C,content:{f:"json"},handleAs:"json",callbackParamName:"callback"}),A._pendingDfd.then(q.hitch(this,
function(F){A.callback(F.multidimensionalInfo)}),function(F){A.errback(F)})):A.callback(null);return A},_getSlices:function(){var C=this.url+"/slices",A=new m(r._dfdCanceller);this.serviceInfo.hasMultidimensions?(A._pendingDfd=f({url:C,content:{f:"json"},handleAs:"json",callbackParamName:"callback"}),A._pendingDfd.then(q.hitch(this,function(F){A.callback(F.slices)}),function(F){A.errback(F)})):A.callback(null);return A},_initializationFailed:function(){},_constructGetImageParams:function(){var C=
this.imageServiceParams||{},A=q.mixin({},this._query,{f:"image",interpolation:C.interpolation,pixelType:C.pixelType,format:C.format||"lerc",compressionQuality:C.compressionQuality,bandIds:C.bandIds?C.bandIds.join(","):null,noData:null!=C.noData?C.noData.join(","):null,noDataInterpretation:C.noDataInterpretation,adjustAspectRatio:null==C.adjustAspectRatio?null:C.adjustAspectRatio,mosaicRule:C.mosaicRule?c.toJson(C.mosaicRule.toJson()):null,renderingRule:C.renderingRule?c.toJson(C.renderingRule.toJson()):
null,token:this.credential&&this.credential.token||null});"lerc"===A.format.toLowerCase()?(A.compressionTolerance=C.compressionTolerance,10.5<=this.serviceInfo.currentVersion&&(A.lercVersion=C.lercVersion||2)):"tiff"===A.format.toLowerCase()?A.compression=C.compression:-1<["jpg","jpeg","jpg","jpgpng"].indexOf(A.format.toLowerCase())&&(A.compression=C.compression);this._commonReqParams=A},_getRasterIdentifier:function(C){if(this._rasterId)return this._rasterId;C=this.url.replace("http:","").replace("https:",
"");var A=[],F=this.imageServiceParams||{};A.push(C);A.push(F.interpolation);A.push(F.pixelType);A.push(F.compressionQuality);A.push(F.bandIds?F.bandIds.join(","):"");A.push(F.mosaicRule?c.toJson(F.mosaicRule.toJson()):"");A.push(F.renderingRule?c.toJson(F.renderingRule.toJson()):"");C=A.join("|");return this._rasterId=this._computeSignature(C)},_wrapExtent:function(C){var A=C.spatialReference._getInfo();if(A){var F=A.valid[0];A=A.valid[1];if(C.xmin<F-this.resolution.x||C.xmax>A+this.resolution.y){var G=
new k((C.xmin-F)%(A-F),C.ymin,(C.xmax-A)%(A-F),C.ymax,C.spatialReference);G.xmax<G.xmin&&(G=null)}}return G||C}});a("extend-esri")&&q.setObject("layers.rasterLib.raster.ImageServiceRaster",H,h);return H})},"esri/layers/rasterLib/raster/RasterInfo":function(){define(["dojo/_base/declare","dojo/_base/lang","../../../geometry/Extent","../../../SpatialReference","../tile/RasterTileInfo"],function(H,g,q,m,n){return H(null,{declaredClass:"esri.layers.rasterLib.raster.RasterInfo",bandCount:null,pixelType:null,
extent:null,spatialReference:null,width:null,height:null,colormap:null,attributeTable:null,multiDimensionalInfo:null,statistics:null,histograms:null,catalogInfo:null,keyProperties:null,cellSize:null,format:null,compression:null,compressionQuality:null,packetSize:null,geodataXform:null,constructor:function(e){g.mixin(this,e);this.extent=this.extent?this.extent.toJson?this.extent:new q(this.extent):null;this.spatialReference=this.spatialReference?this.spatialReference.toJson?this.spatialReference:new m(this.spatialReference):
null;this.tileInfo=this.tileInfo?this.tileInfo.toJson?this.tileInfo:new n(this.tileInfo):null},toJson:function(){return{bandCount:this.bandCount,pixelType:this.pixelType,extent:this.extent&&this.extent.toJson?this.extent.toJson():this.extent,spatialReference:this.spatialReference&&this.spatialReference.toJson?this.spatialReference.toJson():this.spatialReference,width:this.width,height:this.height,colormap:this.colormap?g.clone(this.colormap):null,attributeTable:this.attributeTable?g.clone(this.attributeTable):
null,multiDimensionalInfo:this.multiDimensionalInfo?g.clone(this.multiDimensionalInfo):null,statistics:this.statistics?g.clone(this.statistics):null,histograms:this.histograms?g.clone(this.histograms):null,catalogInfo:this.catalogInfo?g.clone(this.catalogInfo):null,keyProperties:this.keyProperties?g.clone(this.keyProperties):null,cellSize:this.cellSize&&this.cellSize.toJson?this.cellSize.toJson():this.cellSize,tileInfo:this.tileInfo&&this.tileInfo.toJson?this.tileInfo.toJson():this.tileInfo,format:this.format,
compression:this.compression,compressionQuality:this.compressionQuality,packetSize:this.packetSize,geodataXform:this.geodataXform?g.clone(this.geodataXform):null}},clone:function(){return new this.constructor(this.toJson())}})})},"esri/layers/rasterLib/tile/RasterTileInfo":function(){define("dojo/_base/declare dojo/_base/lang ../../../geometry/Extent ../../../SpatialReference ../../../geometry/Point ../../../lang ../../TileInfo".split(" "),function(H,g,q,m,n,e,c){return H([c],{declaredClass:"esri.layers.rasterLib.tile.RasterTileInfo",
rows:512,cols:512,compressionQuality:95,lercError:.01,spatialReference:null,origin:null,virtual:!0,tileType:"Raster",constructor:function(a,b){if(a||b){var l=b&&b.refTileInfo;a?this.virtual=!1:(this.virtual=!0,g.mixin(this,{rows:b.rows||this.rows,cols:b.cols||this.cols,compressionQuality:b.compressionQuality||95,lercError:b.compressionTolerance||.01,spatialReference:b.spatialReference,origin:b.origin}),this.width=this.cols,this.height=this.rows,this.origin||(l?this.origin=l.origin:b.spatialReference.isWebMercator()||
b.extent&&360<=Math.max(Math.abs(b.extent.xmin),Math.abs(b.extent.xmax))?this.origin={x:-2.0037508342787E7,y:2.0037508342787E7}:-1<[4326,4269].indexOf(b.spatialReference.wkid)||360>Math.max(Math.abs(b.extent.xmin),Math.abs(b.extent.xmax))?this.origin={x:-180,y:90}:this.origin={x:b.extent.xmin,y:b.extent.ymax}))}},toJson:function(){var a=c.prototype.toJson.apply(this);a.tileType=this.tileType;a.virtual=this.virtual;a.lercError=this.lercError;return a},clone:function(){return new this.prototype(this.toJson())}})})},
"esri/layers/rasterLib/raster/BasicRaster":function(){define("require dojo/_base/declare dojo/_base/lang dojo/_base/Deferred dojo/_base/array dojo/_base/config dojo/_base/json dojo/sniff dojo/DeferredList dojo/when ../../../kernel ../../../Evented ../../../request ../../../geometry/Extent ../../../geometry/Point ../../../SpatialReference ../../../deferredUtils ../../../urlUtils ../../MosaicRule ../../ImageServiceParameters ../../PixelBlock ../../rasterFormats/rasterCodec ../tile/RasterHandler ./rasterProjectionHelper ./RasterInfo".split(" "),
function(H,g,q,m,n,e,c,a,b,l,h,d,f,k,p,v,t,r,w,u,y,x,z,B,E){return g([d],{url:null,dataType:null,rasterInfo:null,tileInfo:null,serviceInfo:null,loaded:null,constructor:function(I){if(I){var C=I.url;C&&(C=r.urlToObject(C),this.url=C.path,this._query=C.query);this.dataType=I.dataType;this.serviceInfo=I.serviceInfo;this.rasterInfo=I.rasterInfo;this.tileInfo=I.tileInfo;this.serviceInfo=I.serviceInfo}},open:function(){},read:function(I){},identify:function(I){var C=new m,A=this.rasterInfo.extent;if(B.requirePE(A.spatialReference,
I.spatialReference))B.load().then(q.hitch(this,function(){F=B.project(I,A.spatialReference);C.resolve(F)}),function(){C.reject(Error("cannot project into this spatial reference"))});else{var F=B.project(I,A.spatialReference);C.resolve(F)}return C.then(q.hitch(this,function(G){var O=this.tileInfo,N=O.origin,R=O.lods[O.lods.length-1],T=(G.x-N.x)/O.cols/R.resolution;G=(N.y-G.y)/O.rows/R.resolution;var W=Math.round((G-Math.floor(G))*O.rows)*O.cols+Math.round((T-Math.floor(T))*O.cols);N=new k(N.x+R.resolution*
O.cols*T,N.y-R.resolution*O.rows*(G+1),N.x+R.resolution*O.cols*(T+1),N.y-R.resolution*O.rows*G,A.spatialReference);var Y=this.getMemberRasters?this.getMemberRasters()[0]:this;return Y.read({level:R.level,row:Math.floor(G),col:Math.floor(T),extent:N,width:O.cols,height:O.rows,virtual:Y.tileInfo.virtual,tileType:Y.tileInfo.tileType}).then(function(Z){return(Z=Z&&Z.pixelBlock)&&Z.pixels&&0<Z.pixels.length&&(!Z.mask||Z.mask[W])?{pixelValue:Z.pixels.map(function(J){return J[W]})}:{pixelValue:null}})}))},
getProjectedFullExtent:function(I,C){var A=new m;if(this.projectedFullExtent&&!C)return A.resolve(this.projectedFullExtent),A.promise;var F=this.rasterInfo.extent;if(B.requirePE(this.rasterInfo.extent.spatialReference,I))B.load().then(q.hitch(this,function(){G=B.project(F,I);this.projectedFullExtent=G=new k(G.toJson());A.resolve(G)}),function(){A.reject(Error("cannot project into this spatial reference"))});else{var G=B.project(F,I);this.projectedFullExtent=G=new k(G.toJson());A.resolve(G)}return A.promise},
setFetchParameters:function(I,C){},_setRasterHandler:function(I){this._rasterHandler=I;this.getMemberRasters&&this.getMemberRasters().forEach(q.hitch(this,function(C){C._rasterHandler=I}))},_findCredential:function(){this.url&&((this._credential=h.id&&h.id.findCredential(this.url))&&this._credential.ssl||this.serviceInfo&&this.serviceInfo._ssl)&&(this.url=this.url.replace(/^http:/i,"https:"))},_initWorker:function(){this._rasterHandler=new z;this._rasterHandler.start().then(function(){this._rasterHandlerInitialized=
!0}.bind(this))},_requestPixels:function(I){var C=I.url,A=I.payload,F=I.decodeParams,G=I.tileOptions,O=new m(t._dfdCanceller);this._rasterHandler||this._initWorker();var N=this._rasterHandler,R={};C={url:C,handleAs:"arraybuffer",content:A};I.headers&&(C.headers=I.headers);O._pendingDfd=f(C).then(q.hitch(this,function(T){(N&&this._rasterHandlerInitialized?N.decode({encodedData:T,decodeParams:F}):x.decode(T,F)).then(function(W){R.pixelBlock=new y(W);R.extent=G.extent;R.level=G.level;R.row=G.row;R.col=
G.col;R.width=G.width;R.height=G.height;t._resDfd(O,[R])},function(W){t._resDfd(O,[W],!0)})}),function(T){t._resDfd(O,[T],!0)});return O},_computeSignature:function(I){if("string"===typeof I){for(var C=new Uint8Array(I.length),A=0;A<I.length;A++)C[A]=I.charCodeAt(A);I=C}A=C=65535;for(var F=I.length,G=Math.floor(F/2),O=0;G;){var N=359<=G?359:G;G-=N;do C+=I[O++]<<8,A+=C+=I[O++];while(--N);C=(C&65535)+(C>>>16);A=(A&65535)+(A>>>16)}F&1&&(A+=C+=I[O]<<8);return((A&65535)+(A>>>16)<<16|(C&65535)+(C>>>16))>>>
0}})})},"esri/layers/rasterFormats/rasterCodec":function(){define("require dojo/_base/declare dojo/_base/lang dojo/_base/Deferred ../PixelBlock ./LercCodec ./Lerc2Codec ./JpgPlus ./Png ./Raw ./TiffDecoder".split(" "),function(H,g,q,m,n,e,c,a,b,l,h){return{validPixelTypes:"U1 U2 U4 U8 U16 U32 S8 S16 S32 F32".split(" "),supportedFormats:"lerc jpeg jpg jpgpng png png8 png24 png32 bip bsq tiff".split(" "),_isPlatformLittleEndian:function(){var d=new ArrayBuffer(4),f=new Uint8Array(d);(new Uint32Array(d))[0]=
1;return 1===f[0]}(),decode:function(d,f){if(void 0===f||null===f)throw"missing decode options";var k;f.format&&(k=f.format.toUpperCase());"BSQ"!==k&&"BIP"!==k&&(k=this._getFormat(d));var p=f.decodeFunc;if(void 0===p||null===p)p=this._getFormatDecoderDfd(k);return p(d,f)},_getFormatDecoderDfd:function(d){var f=null;switch(d){case "LERC":f=this._decodeLerc;break;case "LERC2":f=this._decodeLerc2;break;case "JPEG":f=this._decodeJpeg;break;case "PNG":f=this._decodePng;break;case "BSQ":f=this._decodeBsq;
break;case "BIP":f=this._decodeBip;break;case "TIFF":f=this._decodeTiff;break;default:f=function(k,p){throw"The raster format is not supported";}}f=q.hitch(this,f);return function(k,p){var v=new m;p.isPoint&&p.width&&(p.width++,p.height++);k=f(k,p);p.isPoint&&p.width&&(this._interpolatePointGrid(k),p.width--,p.height--);v.resolve(k);return v}.bind(this)},_getFormat:function(d){d=new Uint8Array(d,0,10);var f="";if(255===d[0]&&216===d[1])f="JPEG";else if(137===d[0]&&80===d[1]&&78===d[2]&&71===d[3])f=
"PNG";else if(67===d[0]&&110===d[1]&&116===d[2]&&90===d[3]&&73===d[4]&&109===d[5]&&97===d[6]&&103===d[7]&&101===d[8]&&32===d[9])f="LERC";else if(76===d[0]&&101===d[1]&&114===d[2]&&99===d[3]&&50===d[4]&&32===d[5])f="LERC2";else if(-1<String.fromCharCode.apply(null,d).toLowerCase().indexOf("error"))f="ERROR";else if(73===d[0]&&73===d[1]&&42===d[2]&&0===d[3]||77===d[0]&&77===d[1]&&0===d[2]&&42===d[3])f="TIFF";return f},_validateDecodeParams:function(d){if(!d.height||Math.floor(d.height)!==d.height)throw"Height not provided.";
if(!d.width||Math.floor(d.width)!==d.width)throw"Width not provided.";},_decodeJpeg:function(d,f){if(!a)throw"The jpeg decoder module is not loaded.";this._validateDecodeParams(f);d=(new a).decode(d);if(!this._verifyResult(d,f))throw"The decoded image dimensions are incorrect.";f=new n({width:d.width,height:d.height,pixels:d.pixels,pixelType:"U8",mask:d.mask,statistics:null});f.calculateStatistics();return f},_decodePng:function(d,f){if(!b)throw"The png decoder module is not loaded.";this._validateDecodeParams(f);
d=new Uint8Array(d);var k=new b(d);d=new Uint8Array(f.width*f.height*4);k.copyToImageData(d,k.decodePixels());var p=k=0;p=new Uint8Array(f.width*f.height);for(k=0;k<f.width*f.height;k++)p[k]=d[4*k+3];var v=new n({width:f.width,height:f.height,pixels:[],pixelType:"U8",mask:p,statistics:[]});for(k=0;3>k;k++){var t=new Uint8Array(f.width*f.height);for(p=0;p<f.width*f.height;p++)t[p]=d[4*p+k];v.addData({pixels:t})}v.calculateStatistics();return v},_decodeBsq:function(d,f){if(!l)throw"The bsq decoder module is not loaded.";
this._validateDecodeParams(f);var k=f.noDataValue;f.pixelType=this._getpixelTypeAndNoData(f.pixelType);d=l.decodeBSQ(d,{bandCount:f.planes,width:f.width,height:f.height,pixelType:f.pixelType,noDataValue:k});f=new n({width:f.width,height:f.height,pixels:d.pixels,pixelType:f.pixelType,mask:d.maskData,statistics:null});f.calculateStatistics();return f},_decodeBip:function(d,f){this._validateDecodeParams(f);var k=f.noDataValue;f.pixelType=this._getpixelTypeAndNoData(f.pixelType);d=l.decodeBIP(d,{bandCount:f.planes,
width:f.width,height:f.height,pixelType:f.pixelType,noDataValue:k});f=new n({width:f.width,height:f.height,pixels:d.pixels,pixelType:f.pixelType,mask:d.maskData,statistics:null});f.calculateStatistics();return f},_decodeTiff:function(d,f){this._validateDecodeParams(f);f.pixelType=this._getpixelTypeAndNoData(f.pixelType);d=h.decode(d);d=new n({width:d.width,height:d.height,pixels:d.pixels,pixelType:d.pixelType,mask:d.maskData,statistics:null});d.calculateStatistics();return d},_decodeLerc:function(d,
f){if(!this._isPlatformLittleEndian)throw"lerc decoder is not supported on big endian platform";this._validateDecodeParams(f);var k=f.noDataValue;f.pixelType=this._getpixelTypeAndNoData(f.pixelType);for(var p=0,v,t=0,r,w=d.byteLength-10;t<w;){var u=e.decode(d,{inputOffset:t,encodedMaskData:v,returnMask:0===p?!0:!1,returnEncodedMask:0===p?!0:!1,returnFileInfo:!0,pixelType:f.pixelType,noDataValue:k});t=u.fileInfo.eofOffset;0===p&&(v=u.encodedMaskData,r=new n({width:f.width,height:f.height,pixels:[],
pixelType:f.pixelType,mask:u.maskData,statistics:[]}));p++;if(!this._verifyResult(u,f))throw"The decoded image dimensions are incorrect";r.addData({pixels:u.pixelData,statistics:{minValue:u.minValue,maxValue:u.maxValue,noDataValue:u.noDataValue}})}return r},_decodeLerc2:function(d,f){if(!this._isPlatformLittleEndian)throw"lerc2 decoder is not supported on big endian platform";this._validateDecodeParams(f);f.pixelType=this._getpixelTypeAndNoData(f.pixelType);for(var k=0,p,v,t,r=0,w,u=d.byteLength-
10,y=[],x,z=0;r<u;){v=c.decode(d,{inputOffset:r,maskData:p,returnFileInfo:!0});r=v.fileInfo.eofOffset;p=v.maskData;0===k&&(t=v.fileInfo.numValidPixel,w=new n({width:f.width,height:f.height,pixels:[],dimCount:v.dimCount||1,pixelType:v.fileInfo.pixelType,mask:p,statistics:[]}));v.fileInfo.mask&&0<v.fileInfo.mask.numBytes&&z++;p&&y.push(p);k++;if(!this._verifyResult(v,f))throw"The decoded image dimensions are incorrect";w.addData({pixels:v.pixelData,statistics:{minValue:v.minValue,maxValue:v.maxValue,
noDataValue:v.noDataValue,dimStats:v.dimStats}})}if(1<z){f=w.width*w.height;w.bandMasks=y;p=new Uint8Array(f);p.set(y[0]);for(t=1;t<y.length;t++)for(x=y[t],d=0;d<f;d++)p[d]&=x[d];for(d=t=0;d<f;d++)t+=x[d];w.mask=p}w.validPixelCount=t;return w},_interpolatePointGrid:function(d,f){var k=d.pixels;if(k&&0!==k.length){var p=k.length,v=d.width,t=d.mask,r=v-1,w=d.height-1,u=[],y,x;if(0===(null==f?1:f)){for(f=0;f<p;f++){var z=k[f];var B=new z.constructor(r*w);for(y=0;y<w;y++){var E=y*v;for(x=0;x<r;x++)B[y*
r+x]=z[E+x]}u.push(B)}if(t){var I=new Uint8Array(r*w);for(y=0;y<w;y++)for(E=y*v,x=0;x<r;x++)I[y*r+x]=t[E+x]}}else{for(f=0;f<p;f++){z=k[f];B=new z.constructor(r*w);for(y=0;y<w;y++)for(E=y*v,x=0;x<r;x++)B[y*r+x]=(z[E+x]+z[E+x+1]+z[E+v+x]+z[E+v+x+1])/4;u.push(B)}if(t)for(I=new Uint8Array(r*w),y=0;y<w;y++)for(E=y*v,x=0;x<r;x++)I[y*r+x]=Math.min.apply(null,[t[E+x],t[E+x+1],t[E+v+x],t[E+v+x+1]])}d.width=r;d.height=w;d.mask=I;d.pixels=u;return d}},_getpixelTypeAndNoData:function(d){return"U1"===d||"U2"===
d||"U4"===d||"U8"===d?"U8":d},_verifyResult:function(d,f){return d.height!==f.height||d.width!==f.width?!1:!0}}})},"esri/layers/rasterFormats/JpgPlus":function(){define(["dojo/_base/declare","./Zlib","./Jpg"],function(H,g,q){return H(null,{constructor:function(){},decode:function(m){var n=new Uint8Array(m);m=new q;m.parse(n);var e=m.numComponents,c=m.getData(m.width,m.height,!0),a=m.width*m.height,b=m.eof,l=0,h=0,d=0;if(b<n.length-1){h=(new g(n.subarray(b))).getBytes();var f=new Uint8Array(a);for(l=
n=0;l<h.length;l++)for(d=7;0<=d;d--)f[n++]=h[l]>>d&1}n=[];if(1===e)n=[c,c,c];else{for(l=0;3>l;l++)e=new Uint8Array(a),n.push(e);for(h=d=0;h<a;h++)for(l=0;3>l;l++)n[l][h]=c[d++]}return{width:m.width,height:m.height,pixels:n,mask:f}}})})},"esri/layers/rasterFormats/Zlib":function(){define([],function(){var H=function(){function g(){this.bufferLength=this.pos=0;this.eof=!1;this.buffer=null}g.prototype={ensureBuffer:function(q){var m=this.buffer,n=m?m.byteLength:0;if(q<n)return m;for(var e=512;e<q;)e<<=
1;q=new Uint8Array(e);for(e=0;e<n;++e)q[e]=m[e];return this.buffer=q},getByte:function(){for(var q=this.pos;this.bufferLength<=q;){if(this.eof)return null;this.readBlock()}return this.buffer[this.pos++]},getBytes:function(q){var m=this.pos;if(q){this.ensureBuffer(m+q);for(q=m+q;!this.eof&&this.bufferLength<q;)this.readBlock();var n=this.bufferLength;q>n&&(q=n)}else{for(;!this.eof;)this.readBlock();q=this.bufferLength}this.pos=q;return this.buffer.subarray(m,q)},lookChar:function(){for(var q=this.pos;this.bufferLength<=
q;){if(this.eof)return null;this.readBlock()}return String.fromCharCode(this.buffer[this.pos])},getChar:function(){for(var q=this.pos;this.bufferLength<=q;){if(this.eof)return null;this.readBlock()}return String.fromCharCode(this.buffer[this.pos++])},makeSubStream:function(q,m,n){for(var e=q+m;this.bufferLength<=e&&!this.eof;)this.readBlock();return new Stream(this.buffer,q,m,n)},skip:function(q){q||(q=1);this.pos+=q},reset:function(){this.pos=0}};return g}();return function(){function g(b){throw Error(b);
}function q(b){var l=0,h=b[l++],d=b[l++];-1!=h&&-1!=d||g("Invalid header in flate stream");8!=(h&15)&&g("Unknown compression method in flate stream");0!=((h<<8)+d)%31&&g("Bad FCHECK in flate stream");d&32&&g("FDICT bit set in flate stream");this.bytes=b;this.bytesPos=l;this.codeBuf=this.codeSize=0;H.call(this)}if(!self||!self.Uint32Array)return null;var m=new Uint32Array([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),n=new Uint32Array([3,4,5,6,7,8,9,10,65547,65549,65551,65553,131091,131095,131099,
131103,196643,196651,196659,196667,262211,262227,262243,262259,327811,327843,327875,327907,258,258,258]),e=new Uint32Array([1,2,3,4,65541,65543,131081,131085,196625,196633,262177,262193,327745,327777,393345,393409,459009,459137,524801,525057,590849,591361,657409,658433,724993,727041,794625,798721,868353,876545]),c=[new Uint32Array([459008,524368,524304,524568,459024,524400,524336,590016,459016,524384,524320,589984,524288,524416,524352,590048,459012,524376,524312,589968,459028,524408,524344,590032,
459020,524392,524328,59E4,524296,524424,524360,590064,459010,524372,524308,524572,459026,524404,524340,590024,459018,524388,524324,589992,524292,524420,524356,590056,459014,524380,524316,589976,459030,524412,524348,590040,459022,524396,524332,590008,524300,524428,524364,590072,459009,524370,524306,524570,459025,524402,524338,590020,459017,524386,524322,589988,524290,524418,524354,590052,459013,524378,524314,589972,459029,524410,524346,590036,459021,524394,524330,590004,524298,524426,524362,590068,
459011,524374,524310,524574,459027,524406,524342,590028,459019,524390,524326,589996,524294,524422,524358,590060,459015,524382,524318,589980,459031,524414,524350,590044,459023,524398,524334,590012,524302,524430,524366,590076,459008,524369,524305,524569,459024,524401,524337,590018,459016,524385,524321,589986,524289,524417,524353,590050,459012,524377,524313,589970,459028,524409,524345,590034,459020,524393,524329,590002,524297,524425,524361,590066,459010,524373,524309,524573,459026,524405,524341,590026,
459018,524389,524325,589994,524293,524421,524357,590058,459014,524381,524317,589978,459030,524413,524349,590042,459022,524397,524333,590010,524301,524429,524365,590074,459009,524371,524307,524571,459025,524403,524339,590022,459017,524387,524323,589990,524291,524419,524355,590054,459013,524379,524315,589974,459029,524411,524347,590038,459021,524395,524331,590006,524299,524427,524363,590070,459011,524375,524311,524575,459027,524407,524343,590030,459019,524391,524327,589998,524295,524423,524359,590062,
459015,524383,524319,589982,459031,524415,524351,590046,459023,524399,524335,590014,524303,524431,524367,590078,459008,524368,524304,524568,459024,524400,524336,590017,459016,524384,524320,589985,524288,524416,524352,590049,459012,524376,524312,589969,459028,524408,524344,590033,459020,524392,524328,590001,524296,524424,524360,590065,459010,524372,524308,524572,459026,524404,524340,590025,459018,524388,524324,589993,524292,524420,524356,590057,459014,524380,524316,589977,459030,524412,524348,590041,
459022,524396,524332,590009,524300,524428,524364,590073,459009,524370,524306,524570,459025,524402,524338,590021,459017,524386,524322,589989,524290,524418,524354,590053,459013,524378,524314,589973,459029,524410,524346,590037,459021,524394,524330,590005,524298,524426,524362,590069,459011,524374,524310,524574,459027,524406,524342,590029,459019,524390,524326,589997,524294,524422,524358,590061,459015,524382,524318,589981,459031,524414,524350,590045,459023,524398,524334,590013,524302,524430,524366,590077,
459008,524369,524305,524569,459024,524401,524337,590019,459016,524385,524321,589987,524289,524417,524353,590051,459012,524377,524313,589971,459028,524409,524345,590035,459020,524393,524329,590003,524297,524425,524361,590067,459010,524373,524309,524573,459026,524405,524341,590027,459018,524389,524325,589995,524293,524421,524357,590059,459014,524381,524317,589979,459030,524413,524349,590043,459022,524397,524333,590011,524301,524429,524365,590075,459009,524371,524307,524571,459025,524403,524339,590023,
459017,524387,524323,589991,524291,524419,524355,590055,459013,524379,524315,589975,459029,524411,524347,590039,459021,524395,524331,590007,524299,524427,524363,590071,459011,524375,524311,524575,459027,524407,524343,590031,459019,524391,524327,589999,524295,524423,524359,590063,459015,524383,524319,589983,459031,524415,524351,590047,459023,524399,524335,590015,524303,524431,524367,590079]),9],a=[new Uint32Array([327680,327696,327688,327704,327684,327700,327692,327708,327682,327698,327690,327706,
327686,327702,327694,0,327681,327697,327689,327705,327685,327701,327693,327709,327683,327699,327691,327707,327687,327703,327695,0]),5];q.prototype=Object.create(H.prototype);q.prototype.getBits=function(b){for(var l=this.codeSize,h=this.codeBuf,d=this.bytes,f=this.bytesPos,k;l<b;)"undefined"==typeof(k=d[f++])&&g("Bad encoding in flate stream"),h|=k<<l,l+=8;this.codeBuf=h>>b;this.codeSize=l-=b;this.bytesPos=f;return h&(1<<b)-1};q.prototype.getCode=function(b){var l=b[0],h=b[1];b=this.codeSize;for(var d=
this.codeBuf,f=this.bytes,k=this.bytesPos;b<h;){var p;"undefined"==typeof(p=f[k++])&&g("Bad encoding in flate stream");d|=p<<b;b+=8}h=l[d&(1<<h)-1];l=h>>16;h&=65535;(0==b||b<l||0==l)&&g("Bad encoding in flate stream");this.codeBuf=d>>l;this.codeSize=b-l;this.bytesPos=k;return h};q.prototype.generateHuffmanTable=function(b){for(var l=b.length,h=0,d=0;d<l;++d)b[d]>h&&(h=b[d]);for(var f=1<<h,k=new Uint32Array(f),p=1,v=0,t=2;p<=h;++p,v<<=1,t<<=1)for(var r=0;r<l;++r)if(b[r]==p){var w=0,u=v;for(d=0;d<p;++d)w=
w<<1|u&1,u>>=1;for(d=w;d<f;d+=t)k[d]=p<<16|r;++v}return[k,h]};q.prototype.readBlock=function(){function b(w,u,y,x,z){for(w=w.getBits(y)+x;0<w--;)u[v++]=z}var l=this.getBits(3);l&1&&(this.eof=!0);l>>=1;if(0==l){var h=this.bytes,d=this.bytesPos,f;"undefined"==typeof(f=h[d++])&&g("Bad block header in flate stream");var k=f;"undefined"==typeof(f=h[d++])&&g("Bad block header in flate stream");k|=f<<8;"undefined"==typeof(f=h[d++])&&g("Bad block header in flate stream");l=f;"undefined"==typeof(f=h[d++])&&
g("Bad block header in flate stream");(l|f<<8)!=(~k&65535)&&g("Bad uncompressed block length in flate stream");this.codeSize=this.codeBuf=0;f=this.bufferLength;l=this.ensureBuffer(f+k);this.bufferLength=k=f+k;for(var p=f;p<k;++p){if("undefined"==typeof(f=h[d++])){this.eof=!0;break}l[p]=f}this.bytesPos=d}else{if(1==l)d=c,f=a;else if(2==l){l=this.getBits(5)+257;f=this.getBits(5)+1;h=this.getBits(4)+4;d=Array(m.length);for(var v=0;v<h;)d[m[v++]]=this.getBits(3);d=this.generateHuffmanTable(d);v=h=0;f=
l+f;for(k=Array(f);v<f;)p=this.getCode(d),16==p?b(this,k,2,3,h):17==p?b(this,k,3,3,h=0):18==p?b(this,k,7,11,h=0):k[v++]=h=p;d=this.generateHuffmanTable(k.slice(0,l));f=this.generateHuffmanTable(k.slice(l,f))}else g("Unknown block type in flate stream");k=(l=this.buffer)?l.length:0;for(p=this.bufferLength;;){var t=this.getCode(d);if(256>t)p+1>=k&&(l=this.ensureBuffer(p+1),k=l.length),l[p++]=t;else{if(256==t){this.bufferLength=p;break}t-=257;t=n[t];var r=t>>16;0<r&&(r=this.getBits(r));h=(t&65535)+r;
t=this.getCode(f);t=e[t];r=t>>16;0<r&&(r=this.getBits(r));t=(t&65535)+r;p+h>=k&&(l=this.ensureBuffer(p+h),k=l.length);for(r=0;r<h;++r,++p)l[p]=l[p-t]}}}};return q}()})},"esri/layers/rasterFormats/Jpg":function(){define([],function(){var H=function(){function g(q){this.message="JPEG error: "+q}g.prototype=Error();g.prototype.name="JpegError";return g.constructor=g}();return function(){function g(){this.decodeTransform=null;this.colorTransform=-1}function q(a,b){for(var l=0,h=[],d,f,k=16;0<k&&!a[k-
1];)k--;h.push({children:[],index:0});var p=h[0],v;for(d=0;d<k;d++){for(f=0;f<a[d];f++){p=h.pop();for(p.children[p.index]=b[l];0<p.index;)p=h.pop();p.index++;for(h.push(p);h.length<=d;)h.push(v={children:[],index:0}),p.children[p.index]=v.children,p=v;l++}d+1<k&&(h.push(v={children:[],index:0}),p.children[p.index]=v.children,p=v)}return h[0].children}function m(a,b,l,h,d,f,k,p,v){function t(){if(0<F)return F--,A>>F&1;A=a[b++];if(255===A){var K=a[b++];if(K)throw new H("unexpected marker "+(A<<8|K).toString(16));
}F=7;return A>>>7}function r(K){for(;;){K=K[t()];if("number"===typeof K)return K;if("object"!==typeof K)throw new H("invalid huffman sequence");}}function w(K){for(var L=0;0<K;)L=L<<1|t(),K--;return L}function u(K){if(1===K)return 1===t()?1:-1;var L=w(K);return L>=1<<K-1?L:L+(-1<<K)+1}function y(K,L){var M=r(K.huffmanTableDC);M=0===M?0:u(M);K.blockData[L]=K.pred+=M;for(M=1;64>M;){var Q=r(K.huffmanTableAC),S=Q&15;Q>>=4;if(0===S){if(15>Q)break;M+=16}else M+=Q,K.blockData[L+c[M]]=u(S),M++}}function x(K,
L){var M=r(K.huffmanTableDC);M=0===M?0:u(M)<<v;K.blockData[L]=K.pred+=M}function z(K,L){K.blockData[L]|=t()<<v}function B(K,L){if(0<G)G--;else for(var M=f;M<=k;){var Q=r(K.huffmanTableAC),S=Q&15;Q>>=4;if(0===S){if(15>Q){G=w(Q)+(1<<Q)-1;break}M+=16}else M+=Q,K.blockData[L+c[M]]=u(S)*(1<<v),M++}}function E(K,L){for(var M=f,Q=0,S;M<=k;){S=c[M];switch(O){case 0:Q=r(K.huffmanTableAC);S=Q&15;Q>>=4;if(0===S)15>Q?(G=w(Q)+(1<<Q),O=4):(Q=16,O=1);else{if(1!==S)throw new H("invalid ACn encoding");N=u(S);O=Q?
2:3}continue;case 1:case 2:K.blockData[L+S]?K.blockData[L+S]+=t()<<v:(Q--,0===Q&&(O=2===O?3:0));break;case 3:K.blockData[L+S]?K.blockData[L+S]+=t()<<v:(K.blockData[L+S]=N<<v,O=0);break;case 4:K.blockData[L+S]&&(K.blockData[L+S]+=t()<<v)}M++}4===O&&(G--,0===G&&(O=0))}var I=l.mcusPerLine,C=b,A=0,F=0,G=0,O=0,N,R=h.length,T,W,Y,Z;p=l.progressive?0===f?0===p?x:z:0===p?B:E:y;var J=0;l=1===R?h[0].blocksPerLine*h[0].blocksPerColumn:I*l.mcusPerColumn;for(var P,U;J<l;){var V=d?Math.min(l-J,d):l;for(T=0;T<R;T++)h[T].pred=
0;G=0;if(1===R){var D=h[0];for(Z=0;Z<V;Z++)p(D,64*((D.blocksPerLine+1)*(J/D.blocksPerLine|0)+J%D.blocksPerLine)),J++}else for(Z=0;Z<V;Z++){for(T=0;T<R;T++)for(D=h[T],P=D.h,U=D.v,W=0;W<U;W++)for(Y=0;Y<P;Y++)p(D,64*((D.blocksPerLine+1)*((J/I|0)*D.v+W)+(J%I*D.h+Y)));J++}F=0;(D=e(a,b))&&D.invalid&&(console.log("decodeScan - unexpected MCU data, next marker is: "+D.invalid),b=D.offset);D=D&&D.marker;if(!D||65280>=D)throw new H("marker was not found");if(65488<=D&&65495>=D)b+=2;else break}(D=e(a,b))&&D.invalid&&
(console.log("decodeScan - unexpected Scan data, next marker is: "+D.invalid),b=D.offset);return b-C}function n(a,b){a=b.blocksPerLine;for(var l=b.blocksPerColumn,h=new Int16Array(64),d=0;d<l;d++)for(var f=0;f<a;f++){var k=void 0,p=void 0,v=void 0,t=void 0,r=void 0,w=void 0,u=void 0,y=void 0,x=r=w=t=p=k=void 0,z=void 0,B=void 0,E=void 0,I=64*((b.blocksPerLine+1)*d+f),C=h,A=b.quantizationTable,F=b.blockData;if(!A)throw new H("missing required Quantization Table.");for(var G=0;64>G;G+=8)k=F[I+G],y=
F[I+G+1],u=F[I+G+2],w=F[I+G+3],r=F[I+G+4],t=F[I+G+5],v=F[I+G+6],p=F[I+G+7],k*=A[G],0===(y|u|w|r|t|v|p)?(k=5793*k+512>>10,C[G]=k,C[G+1]=k,C[G+2]=k,C[G+3]=k,C[G+4]=k,C[G+5]=k,C[G+6]=k,C[G+7]=k):(y*=A[G+1],u*=A[G+2],w*=A[G+3],r*=A[G+4],t*=A[G+5],v*=A[G+6],p*=A[G+7],E=5793*k+128>>8,B=5793*r+128>>8,z=u,x=v,r=2896*(y-p)+128>>8,p=2896*(y+p)+128>>8,w<<=4,t<<=4,E=E+B+1>>1,B=E-B,k=3784*z+1567*x+128>>8,z=1567*z-3784*x+128>>8,x=k,r=r+t+1>>1,t=r-t,p=p+w+1>>1,w=p-w,E=E+x+1>>1,x=E-x,B=B+z+1>>1,z=B-z,k=2276*r+3406*
p+2048>>12,r=3406*r-2276*p+2048>>12,p=k,k=799*w+4017*t+2048>>12,w=4017*w-799*t+2048>>12,t=k,C[G]=E+p,C[G+7]=E-p,C[G+1]=B+t,C[G+6]=B-t,C[G+2]=z+w,C[G+5]=z-w,C[G+3]=x+r,C[G+4]=x-r);for(A=0;8>A;++A)k=C[A],y=C[A+8],u=C[A+16],w=C[A+24],r=C[A+32],t=C[A+40],v=C[A+48],p=C[A+56],0===(y|u|w|r|t|v|p)?(k=5793*k+8192>>14,k=-2040>k?0:2024<=k?255:k+2056>>4,F[I+A]=k,F[I+A+8]=k,F[I+A+16]=k,F[I+A+24]=k,F[I+A+32]=k,F[I+A+40]=k,F[I+A+48]=k,F[I+A+56]=k):(E=5793*k+2048>>12,B=5793*r+2048>>12,z=u,x=v,r=2896*(y-p)+2048>>
12,p=2896*(y+p)+2048>>12,E=(E+B+1>>1)+4112,B=E-B,k=3784*z+1567*x+2048>>12,z=1567*z-3784*x+2048>>12,x=k,r=r+t+1>>1,t=r-t,p=p+w+1>>1,w=p-w,E=E+x+1>>1,x=E-x,B=B+z+1>>1,z=B-z,k=2276*r+3406*p+2048>>12,r=3406*r-2276*p+2048>>12,p=k,k=799*w+4017*t+2048>>12,w=4017*w-799*t+2048>>12,t=k,k=E+p,p=E-p,y=B+t,v=B-t,u=z+w,t=z-w,w=x+r,r=x-r,k=16>k?0:4080<=k?255:k>>4,y=16>y?0:4080<=y?255:y>>4,u=16>u?0:4080<=u?255:u>>4,w=16>w?0:4080<=w?255:w>>4,r=16>r?0:4080<=r?255:r>>4,t=16>t?0:4080<=t?255:t>>4,v=16>v?0:4080<=v?255:
v>>4,p=16>p?0:4080<=p?255:p>>4,F[I+A]=k,F[I+A+8]=y,F[I+A+16]=u,F[I+A+24]=w,F[I+A+32]=r,F[I+A+40]=t,F[I+A+48]=v,F[I+A+56]=p)}return b.blockData}function e(a,b,l){var h=a.length-1;l=l<b?l:b;if(b>=h)return null;var d=a[b]<<8|a[b+1];if(65472<=d&&65534>=d)return{invalid:null,marker:d,offset:b};for(b=a[l]<<8|a[l+1];!(65472<=b&&65534>=b);){if(++l>=h)return null;b=a[l]<<8|a[l+1]}return{invalid:d.toString(16),marker:b,offset:l}}if(!self||!self.Uint8ClampedArray)return null;var c=new Uint8Array([0,1,8,16,9,
2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,29,22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,61,54,47,55,62,63]);g.prototype={parse:function(a){function b(){var A=a[d]<<8|a[d+1];d+=2;return A}function l(){var A=b();A=d+A-2;var F=e(a,A,d);F&&F.invalid&&(console.log("readDataBlock - incorrect length, next marker is: "+F.invalid),A=F.offset);A=a.subarray(d,A);d+=A.length;return A}function h(A){for(var F=Math.ceil(A.samplesPerLine/8/A.maxH),
G=Math.ceil(A.scanLines/8/A.maxV),O=0;O<A.components.length;O++){C=A.components[O];var N=Math.ceil(Math.ceil(A.samplesPerLine/8)*C.h/A.maxH),R=Math.ceil(Math.ceil(A.scanLines/8)*C.v/A.maxV);C.blockData=new Int16Array(64*G*C.v*(F*C.h+1));C.blocksPerLine=N;C.blocksPerColumn=R}A.mcusPerLine=F;A.mcusPerColumn=G}var d=0,f=null,k=null,p=[],v=[],t=[],r=b();if(65496!==r)throw new H("SOI not found");for(r=b();65497!==r;){switch(r){case 65504:case 65505:case 65506:case 65507:case 65508:case 65509:case 65510:case 65511:case 65512:case 65513:case 65514:case 65515:case 65516:case 65517:case 65518:case 65519:case 65534:var w=
l();65504===r&&74===w[0]&&70===w[1]&&73===w[2]&&70===w[3]&&0===w[4]&&(f={version:{major:w[5],minor:w[6]},densityUnits:w[7],xDensity:w[8]<<8|w[9],yDensity:w[10]<<8|w[11],thumbWidth:w[12],thumbHeight:w[13],thumbData:w.subarray(14,14+3*w[12]*w[13])});65518===r&&65===w[0]&&100===w[1]&&111===w[2]&&98===w[3]&&101===w[4]&&(k={version:w[5]<<8|w[6],flags0:w[7]<<8|w[8],flags1:w[9]<<8|w[10],transformCode:w[11]});break;case 65499:r=b()+d-2;for(var u;d<r;){var y=a[d++],x=new Uint16Array(64);if(0===y>>4)for(w=
0;64>w;w++)u=c[w],x[u]=a[d++];else if(1===y>>4)for(w=0;64>w;w++)u=c[w],x[u]=b();else throw new H("DQT - invalid table spec");p[y&15]=x}break;case 65472:case 65473:case 65474:if(z)throw new H("Only single frame JPEGs supported");b();var z={};z.extended=65473===r;z.progressive=65474===r;z.precision=a[d++];z.scanLines=b();z.samplesPerLine=b();z.components=[];z.componentIds={};w=a[d++];for(r=x=y=0;r<w;r++){u=a[d];var B=a[d+1]>>4;var E=a[d+1]&15;y<B&&(y=B);x<E&&(x=E);B=z.components.push({h:B,v:E,quantizationId:a[d+
2],quantizationTable:null});z.componentIds[u]=B-1;d+=3}z.maxH=y;z.maxV=x;h(z);break;case 65476:u=b();for(r=2;r<u;){y=a[d++];x=new Uint8Array(16);for(w=B=0;16>w;w++,d++)B+=x[w]=a[d];E=new Uint8Array(B);for(w=0;w<B;w++,d++)E[w]=a[d];r+=17+B;(0===y>>4?t:v)[y&15]=q(x,E)}break;case 65501:b();var I=b();break;case 65498:b();u=a[d++];w=[];for(r=0;r<u;r++){y=z.componentIds[a[d++]];var C=z.components[y];y=a[d++];C.huffmanTableDC=t[y>>4];C.huffmanTableAC=v[y&15];w.push(C)}r=a[d++];u=a[d++];y=a[d++];r=m(a,d,
z,w,I,r,u,y>>4,y&15);d+=r;break;case 65535:255!==a[d]&&d--;break;default:if(255===a[d-3]&&192<=a[d-2]&&254>=a[d-2])d-=3;else throw new H("unknown marker "+r.toString(16));}r=b()}this.width=z.samplesPerLine;this.height=z.scanLines;this.jfif=f;this.eof=d;this.adobe=k;this.components=[];for(r=0;r<z.components.length;r++){C=z.components[r];if(f=p[C.quantizationId])C.quantizationTable=f;this.components.push({output:n(z,C),scaleX:C.h/z.maxH,scaleY:C.v/z.maxV,blocksPerLine:C.blocksPerLine,blocksPerColumn:C.blocksPerColumn})}this.numComponents=
this.components.length},_getLinearizedBlockData:function(a,b){var l=this.width/a,h=this.height/b,d,f,k=0,p=this.components.length,v=a*b*p,t=new Uint8ClampedArray(v),r=new Uint32Array(a);for(f=0;f<p;f++){var w=this.components[f];var u=w.scaleX*l;var y=w.scaleY*h;k=f;var x=w.output;var z=w.blocksPerLine+1<<3;for(d=0;d<a;d++)w=0|d*u,r[d]=(w&4294967288)<<3|w&7;for(u=0;u<b;u++)for(w=0|u*y,w=z*(w&4294967288)|(w&7)<<3,d=0;d<a;d++)t[k]=x[w+r[d]],k+=p}if(b=this.decodeTransform)for(f=0;f<v;)for(a=w=0;w<p;w++,
f++,a+=2)t[f]=(t[f]*b[a]>>8)+b[a+1];return t},_isColorConversionNeeded:function(){return this.adobe?!!this.adobe.transformCode:3===this.numComponents?0===this.colorTransform?!1:!0:1===this.colorTransform?!0:!1},_convertYccToRgb:function(a){for(var b,l,h,d=0,f=a.length;d<f;d+=3)b=a[d],l=a[d+1],h=a[d+2],a[d]=b-179.456+1.402*h,a[d+1]=b+135.459-.344*l-.714*h,a[d+2]=b-226.816+1.772*l;return a},_convertYcckToRgb:function(a){for(var b,l,h,d,f=0,k=0,p=a.length;k<p;k+=4)b=a[k],l=a[k+1],h=a[k+2],d=a[k+3],a[f++]=
-122.67195406894+l*(-6.60635669420364E-5*l+4.37130475926232E-4*h-5.4080610064599E-5*b+4.8449797120281E-4*d-.154362151871126)+h*(-9.57964378445773E-4*h+8.17076911346625E-4*b-.00477271405408747*d+1.53380253221734)+b*(9.61250184130688E-4*b-.00266257332283933*d+.48357088451265)+d*(-3.36197177618394E-4*d+.484791561490776),a[f++]=107.268039397724+l*(2.19927104525741E-5*l-6.40992018297945E-4*h+6.59397001245577E-4*b+4.26105652938837E-4*d-.176491792462875)+h*(-7.78269941513683E-4*h+.00130872261408275*b+7.70482631801132E-4*
d-.151051492775562)+b*(.00126935368114843*b-.00265090189010898*d+.25802910206845)+d*(-3.18913117588328E-4*d-.213742400323665),a[f++]=-20.810012546947+l*(-5.70115196973677E-4*l-2.63409051004589E-5*h+.0020741088115012*b-.00288260236853442*d+.814272968359295)+h*(-1.53496057440975E-5*h-1.32689043961446E-4*b+5.60833691242812E-4*d-.195152027534049)+b*(.00174418132927582*b-.00255243321439347*d+.116935020465145)+d*(-3.43531996510555E-4*d+.24165260232407);return a},_convertYcckToCmyk:function(a){for(var b,
l,h,d=0,f=a.length;d<f;d+=4)b=a[d],l=a[d+1],h=a[d+2],a[d]=434.456-b-1.402*h,a[d+1]=119.541-b+.344*l+.714*h,a[d+2]=481.816-b-1.772*l;return a},_convertCmykToRgb:function(a){for(var b,l,h,d,f=0,k=1/255,p=0,v=a.length;p<v;p+=4)b=a[p]*k,l=a[p+1]*k,h=a[p+2]*k,d=a[p+3]*k,a[f++]=255+b*(-4.387332384609988*b+54.48615194189176*l+18.82290502165302*h+212.25662451639585*d-285.2331026137004)+l*(1.7149763477362134*l-5.6096736904047315*h-17.873870861415444*d-5.497006427196366)+h*(-2.5217340131683033*h-21.248923337353073*
d+17.5119270841813)-d*(21.86122147463605*d+189.48180835922747),a[f++]=255+b*(8.841041422036149*b+60.118027045597366*l+6.871425592049007*h+31.159100130055922*d-79.2970844816548)+l*(-15.310361306967817*l+17.575251261109482*h+131.35250912493976*d-190.9453302588951)+h*(4.444339102852739*h+9.8632861493405*d-24.86741582555878)-d*(20.737325471181034*d+187.80453709719578),a[f++]=255+b*(.8842522430003296*b+8.078677503112928*l+30.89978309703729*h-.23883238689178934*d-14.183576799673286)+l*(10.49593273432072*
l+63.02378494754052*h+50.606957656360734*d-112.23884253719248)+h*(.03296041114873217*h+115.60384449646641*d-193.58209356861505)-d*(22.33816807309886*d+180.12613974708367);return a},getData:function(a,b,l){if(4<this.numComponents)throw new H("Unsupported color mode");a=this._getLinearizedBlockData(a,b);if(1===this.numComponents&&l){l=a.length;b=new Uint8ClampedArray(3*l);for(var h=0,d=0;d<l;d++){var f=a[d];b[h++]=f;b[h++]=f;b[h++]=f}return b}if(3===this.numComponents&&this._isColorConversionNeeded())return this._convertYccToRgb(a);
if(4===this.numComponents){if(this._isColorConversionNeeded())return l?this._convertYcckToRgb(a):this._convertYcckToCmyk(a);if(l)return this._convertCmykToRgb(a)}return a}};return g}()})},"esri/layers/rasterFormats/Png":function(){define(["./Zlib"],function(H){return function(){function g(m){var n,e;this.data=m;this.pos=8;this.palette=[];this.imgData=[];this.transparency={};this.animation=null;this.text={};for(e=null;;){var c=this.readUInt32();var a=m=void 0;m=[];for(a=0;4>a;++a)m.push(String.fromCharCode(this.data[this.pos++]));
m=m.join("");switch(m){case "IHDR":this.width=this.readUInt32();this.height=this.readUInt32();this.bits=this.data[this.pos++];this.colorType=this.data[this.pos++];this.compressionMethod=this.data[this.pos++];this.filterMethod=this.data[this.pos++];this.interlaceMethod=this.data[this.pos++];break;case "acTL":this.animation={numFrames:this.readUInt32(),numPlays:this.readUInt32()||Infinity,frames:[]};break;case "PLTE":this.palette=this.read(c);break;case "fcTL":e&&this.animation.frames.push(e);this.pos+=
4;e={width:this.readUInt32(),height:this.readUInt32(),xOffset:this.readUInt32(),yOffset:this.readUInt32()};m=this.readUInt16();c=this.readUInt16()||100;e.delay=1E3*m/c;e.disposeOp=this.data[this.pos++];e.blendOp=this.data[this.pos++];e.data=[];break;case "IDAT":case "fdAT":"fdAT"===m&&(this.pos+=4,c-=4);m=(null!=e?e.data:void 0)||this.imgData;for(a=0;0<=c?a<c:a>c;0<=c?++a:--a)m.push(this.data[this.pos++]);break;case "tRNS":this.transparency={};switch(this.colorType){case 3:this.transparency.indexed=
this.read(c);c=255-this.transparency.indexed.length;if(0<c)for(m=0;0<=c?m<c:m>c;0<=c?++m:--m)this.transparency.indexed.push(255);break;case 0:this.transparency.grayscale=this.read(c)[0];break;case 2:this.transparency.rgb=this.read(c)}break;case "tEXt":a=this.read(c);c=a.indexOf(0);m=String.fromCharCode.apply(String,a.slice(0,c));this.text[m]=String.fromCharCode.apply(String,a.slice(c+1));break;case "IEND":e&&this.animation.frames.push(e);a:{switch(this.colorType){case 0:case 3:case 4:e=1;break a;
case 2:case 6:e=3;break a}e=void 0}this.colors=e;this.hasAlphaChannel=4===(n=this.colorType)||6===n;n=this.colors+(this.hasAlphaChannel?1:0);this.pixelBitlength=this.bits*n;a:{switch(this.colors){case 1:n="DeviceGray";break a;case 3:n="DeviceRGB";break a}n=void 0}this.colorSpace=n;this.imgData=new Uint8Array(this.imgData);return;default:this.pos+=c}this.pos+=4;if(this.pos>this.data.length)throw Error("Incomplete or corrupt PNG file");}}g.load=function(m,n,e){"function"===typeof n&&(e=n);var c=new XMLHttpRequest;
c.open("GET",m,!0);c.responseType="arraybuffer";c.onload=function(){var a=new Uint8Array(c.response||c.mozResponseArrayBuffer);a=new g(a);"function"===typeof(null!=n?n.getContext:void 0)&&a.render(n);return"function"===typeof e?e(a):void 0};return c.send(null)};g.prototype.read=function(m){var n;var e=[];for(n=0;0<=m?n<m:n>m;0<=m?++n:--n)e.push(this.data[this.pos++]);return e};g.prototype.readUInt32=function(){var m=this.data[this.pos++]<<24;var n=this.data[this.pos++]<<16;var e=this.data[this.pos++]<<
8;var c=this.data[this.pos++];return m|n|e|c};g.prototype.readUInt16=function(){var m=this.data[this.pos++]<<8;var n=this.data[this.pos++];return m|n};g.prototype.decodePixels=function(m){var n,e,c,a,b,l,h,d;null==m&&(m=this.imgData);if(0===m.length)return new Uint8Array(0);m=new H(m);m=m.getBytes();var f=this.pixelBitlength/8;var k=f*this.width;var p=new Uint8Array(k*this.height);var v=m.length;for(e=a=b=0;a<v;){switch(m[a++]){case 0:for(c=n=0;n<k;c=n+=1)p[e++]=m[a++];break;case 1:for(c=l=0;l<k;c=
l+=1){n=m[a++];var t=c<f?0:p[e-f];p[e++]=(n+t)%256}break;case 2:for(c=t=0;t<k;c=t+=1){n=m[a++];var r=(c-c%f)/f;l=b&&p[(b-1)*k+r*f+c%f];p[e++]=(l+n)%256}break;case 3:for(c=d=0;d<k;c=d+=1)n=m[a++],r=(c-c%f)/f,t=c<f?0:p[e-f],l=b&&p[(b-1)*k+r*f+c%f],p[e++]=(n+Math.floor((t+l)/2))%256;break;case 4:for(c=d=0;d<k;c=d+=1){n=m[a++];r=(c-c%f)/f;t=c<f?0:p[e-f];0===b?l=h=0:(l=p[(b-1)*k+r*f+c%f],h=r&&p[(b-1)*k+(r-1)*f+c%f]);var w=t+l-h;c=Math.abs(w-t);r=Math.abs(w-l);w=Math.abs(w-h);t=c<=r&&c<=w?t:r<=w?l:h;p[e++]=
(n+t)%256}break;default:throw Error("Invalid filter algorithm: "+m[a-1]);}b++}return p};g.prototype.decodePalette=function(){var m,n,e,c,a;var b=this.palette;var l=this.transparency.indexed||[];var h=new Uint8Array((l.length||0)+b.length);var d=e=m=n=0;for(c=b.length;e<c;d=e+=3)h[n++]=b[d],h[n++]=b[d+1],h[n++]=b[d+2],h[n++]=null!=(a=l[m++])?a:255;return h};g.prototype.copyToImageData=function(m,n){var e,c;var a=this.colors;var b=null;var l=this.hasAlphaChannel;this.palette.length&&(b=null!=(e=this._decodedPalette)?
e:this._decodedPalette=this.decodePalette(),a=4,l=!0);m=m.data||m;var h=m.length;var d=b||n;e=c=0;if(1===a)for(;e<h;)a=b?4*n[e/4]:c,c=d[a++],m[e++]=c,m[e++]=c,m[e++]=c,m[e++]=l?d[a++]:this.transparency.grayscale&&this.transparency.grayscale===c?0:255,c=a;else for(;e<h;)a=b?4*n[e/4]:c,m[e++]=d[a++],m[e++]=d[a++],m[e++]=d[a++],m[e++]=l?d[a++]:this.transparency.rgb&&this.transparency.rgb[1]===d[a-3]&&this.transparency.rgb[3]===d[a-2]&&this.transparency.rgb[5]===d[a-1]?0:255,c=a};g.prototype.decode=function(){var m=
new Uint8Array(this.width*this.height*4);this.copyToImageData(m,this.decodePixels());return m};var q=function(m){(void 0).clearRect(0,0,m.width,m.height);(void 0).putImageData(m,0,0);m=new Image;m.src=(void 0).toDataURL();return m};g.prototype.decodeFrames=function(m){var n,e;if(this.animation){var c=this.animation.frames;var a=[];var b=n=0;for(e=c.length;n<e;b=++n){b=c[b];var l=m.createImageData(b.width,b.height);var h=this.decodePixels(new Uint8Array(b.data));this.copyToImageData(l,h);b.imageData=
l;a.push(b.image=q(l))}return a}};g.prototype.renderFrame=function(m,n){var e=this.animation.frames;var c=e[n];e=e[n-1];0===n&&m.clearRect(0,0,this.width,this.height);1===(null!=e?e.disposeOp:void 0)?m.clearRect(e.xOffset,e.yOffset,e.width,e.height):2===(null!=e?e.disposeOp:void 0)&&m.putImageData(e.imageData,e.xOffset,e.yOffset);0===c.blendOp&&m.clearRect(c.xOffset,c.yOffset,c.width,c.height);return m.drawImage(c.image,c.xOffset,c.yOffset)};g.prototype.animate=function(m){var n,e=this;var c=0;var a=
this.animation;var b=a.numFrames;var l=a.frames;var h=a.numPlays;return(n=function(){var d=c++%b;var f=l[d];e.renderFrame(m,d);if(1<b&&c/b<h)return e.animation._timeout=setTimeout(n,f.delay)})()};g.prototype.stopAnimation=function(){var m;return clearTimeout(null!=(m=this.animation)?m._timeout:void 0)};g.prototype.render=function(m){m._png&&m._png.stopAnimation();m._png=this;m.width=this.width;m.height=this.height;m=m.getContext("2d");if(this.animation)return this.decodeFrames(m),this.animate(m);
var n=m.createImageData(this.width,this.height);this.copyToImageData(n,this.decodePixels());return m.putImageData(n,0,0)};return g}()})},"esri/layers/rasterFormats/Raw":function(){define([],function(){return{decodeBIP:function(H,g){var q=g.pixelType,m=g.bandCount,n=[],e=g.width*g.height,c=this.getBandCount(H,g);m=m||c;var a=H.byteLength-H.byteLength%(e*this._getPixelLength(q)),b=new q(H,0,e*c),l,h,d;for(l=0;l<m;l++){var f=new q(e);for(h=0;h<e;h++)f[h]=b[h*c+l];n.push(f)}a<H.byteLength-1&&(d=this._decodeMask(H.slice(a),
g));return{pixels:n,maskData:d}},decodeBSQ:function(H,g){var q=g.pixelType,m=g.bandCount;if(void 0===m||null===m)m=this.getBandCount(H,g);var n=[],e=g.width*g.height,c=e*m,a=H.byteLength-H.byteLength%(e*this._getPixelLength(q));q=new q(H,0,c);var b;for(c=0;c<m;c++)n.push(q.subarray(c*e,(c+1)*e));a<H.byteLength-1&&(b=this._decodeMask(H.slice(a),g));return{pixels:n,maskData:b}},getBandCount:function(H,g){return Math.floor(H.byteLength/(g.width*g.height*this._getPixelLength(g.pixelType)))},_getPixelLength:function(H){var g=
1;switch(H){case Uint8Array:case Int8Array:case Uint8ClampedArray:g=1;break;case Uint16Array:case Int16Array:g=2;break;case Uint32Array:case Int32Array:case Float32Array:g=4;break;case Float64Array:g=8}return g},_decodeMask:function(H,g){var q=g.width*g.height;if(8*H.byteLength<q)return null;H=new Uint8Array(H,0,Math.ceil(q/8));g=new Uint8Array(g.width*g.height);var m=0,n=0,e=0,c=0;for(e=0;e<H.length-1;e++)for(n=H[e],c=7;0<=c;c--)g[m++]=n>>c&1;for(c=7;m<q-1;)n=H[H.length-1],g[m++]=n>>c&1,c--;return g}}})},
"esri/layers/rasterFormats/TiffDecoder":function(){define(["./Jpg","./Zlib"],function(H,g){var q=function(){var c=new ArrayBuffer(4),a=new Uint8Array(c);c=new Uint32Array(c);a[0]=1;a[1]=2;a[2]=3;a[3]=4;return 67305985===c[0]},m=function(){var c=[];c[254]="NEWSUBFILETYPE";c[255]="SUBFILETYPE";c[256]="IMAGEWIDTH";c[257]="IMAGELENGTH";c[258]="BITSPERSAMPLE";c[259]="COMPRESSION";c[262]="PHOTOMETRICINTERPRETATION";c[263]="THRESHHOLDING";c[264]="CELLWIDTH";c[265]="CELLLENGTH";c[266]="FILLORDER";c[269]=
"DOCUMENTNAME";c[270]="IMAGEDESCRIPTION";c[271]="MAKE";c[272]="MODEL";c[273]="STRIPOFFSETS";c[274]="ORIENTATION";c[277]="SAMPLESPERPIXEL";c[278]="ROWSPERSTRIP";c[279]="STRIPBYTECOUNTS";c[280]="MINSAMPLEVALUE";c[281]="MAXSAMPLEVALUE";c[282]="XRESOLUTION";c[283]="YRESOLUTION";c[284]="PLANARCONFIGURATION";c[285]="PAGENAME";c[286]="XPOSITION";c[287]="YPOSITION";c[288]="FREEOFFSETS";c[289]="FREEBYTECOUNTS";c[290]="GRAYRESPONSEUNIT";c[291]="GRAYRESPONSECURVE";c[292]="T4OPTIONS";c[293]="T6OPTIONS";c[296]=
"RESOLUTIONUNIT";c[297]="PAGENUMBER";c[300]="COLORRESPONSEUNIT";c[301]="TRANSFERFUNCTION";c[305]="SOFTWARE";c[306]="DATETIME";c[315]="ARTIST";c[316]="HOSTCOMPUTER";c[317]="PREDICTOR";c[318]="WHITEPOINT";c[319]="PRIMARYCHROMATICITIES";c[320]="COLORMAP";c[321]="HALFTONEHINTS";c[322]="TILEWIDTH";c[323]="TILELENGTH";c[324]="TILEOFFSETS";c[325]="TILEBYTECOUNTS";c[326]="BADFAXLINES";c[327]="CLEANFAXDATA";c[328]="CONSECUTIVEBADFAXLINES";c[330]="SUBIFD";c[332]="INKSET";c[333]="INKNAMES";c[334]="NUMBEROFINKS";
c[336]="DOTRANGE";c[337]="TARGETPRINTER";c[338]="EXTRASAMPLES";c[339]="SAMPLEFORMAT";c[340]="SMINSAMPLEVALUE";c[341]="SMAXSAMPLEVALUE";c[342]="TRANSFERRANGE";c[347]="JPEGTABLES";c[512]="JPEGPROC";c[513]="JPEGIFOFFSET";c[514]="JPEGIFBYTECOUNT";c[515]="JPEGRESTARTINTERVAL";c[517]="JPEGLOSSLESSPREDICTORS";c[518]="JPEGPOINTTRANSFORM";c[519]="JPEGQTABLES";c[520]="JPEGDCTABLES";c[521]="JPEGACTABLES";c[529]="YCBCRCOEFFICIENTS";c[530]="YCBCRSUBSAMPLING";c[531]="YCBCRPOSITIONING";c[532]="REFERENCEBLACKWHITE";
c[33550]="GEOPIXELSCALE";c[33922]="GEOTIEPOINTS";c[33432]="COPYRIGHT";c[42112]="GDAL_METADATA";c[42113]="GDAL_NODATA";c[50844]="RPCCOEFFICIENT";c[34735]="GEOKEYDIRECTORY";c[34736]="GEODOUBLEPARAMS";c[34737]="GEOASCIIPARAMS";return c}(),n=[0,1,1,2,4,8,1,1,2,4,8,4,8],e=function(c,a){var b="UNKNOWN";3===c?b="F32":1===c?8>=a?b="U8":16>=a?b="U16":32>=a&&(b="U32"):2===c&&(8>=a?b="S8":16>=a?b="S16":32>=a&&(b="S32"));return b};return{decode:function(c){var a=new DataView(c,0,8),b=a.getUint16(0,!1);if(18761===
b)var l=!0;else if(19789===b)l=!1;else throw"unexpected endianess byte";if(42!==a.getUint16(2,l))throw"unexpected tiff identifier";var h=a.getUint32(4,l);var d=l;var f,k;var p=h;for(var v=[];p;){var t=(new DataView(c,p,2)).getUint16(0,d);var r=p+2;p=(new DataView(c,r+12*t,4)).getUint32(0,d);var w={};for(f=0;f<t;f++){var u=new DataView(c,r,12);var y=u.getUint16(0,d);var x=u.getUint16(2,d);var z=u.getUint32(4,d);var B=u.getUint32(8,d);r+=12;if(!(7===x||12<x)){var E=k={fieldTag:y,fieldType:x,fieldValueCount:z,
fieldValueOffset:B},I=void 0,C=void 0,A=c,F=d,G=[],O=k.fieldType,N=k.fieldValueCount,R=k.fieldValueOffset,T=R,W=n[O],Y=8*W,Z=N*W,J=N*n[O]*8;if(32>=J)if(F||(R>>>=32-J),1===N)G=[R];else for(I=0;I<N;I++)G.push(R<<Y*I>>>32-Y);else for(T=R;T<R+Z;T+=W){switch(O){case 1:C=(new DataView(A,T,1)).getUint8(0);break;case 2:C=(new DataView(A,T,1)).getUint8(0);break;case 3:C=(new DataView(A,T,2)).getUint16(0,F);break;case 4:C=(new DataView(A,T,4)).getUint32(0,F);break;case 5:C=(new DataView(A,T,4)).getUint32(0,
F)/(new DataView(A,T+4,4)).getUint32(0,F);break;case 6:C=(new DataView(A,T,1)).getInt8(0);break;case 8:C=(new DataView(A,T,2)).getInt16(0,F);break;case 9:C=(new DataView(A,T,4)).getInt32(0,F);break;case 10:C=(new DataView(A,T,4)).getInt32(0,F)/(new DataView(A,T+4,4)).getInt32(0,F);break;case 11:C=(new DataView(A,T,4)).getFloat32(0,F);break;case 12:C=(new DataView(A,T,8)).getFloat64(0,F);break;case 7:C=null;break;default:C=null}G.push(C)}if(2===O){var P="",U=G;G=[];for(I=0;I<U.length;I++)0===U[I]&&
""!==P?(G.push(P),P=""):P+=String.fromCharCode(U[I]);""===P&&0!==G.length||G.push(P)}E.fieldValues=G;var V=w,D=m[y];void 0===D&&(D="unknown"+y);V[D]={type:x,values:k.fieldValues}}}v.push(w)}if(0===v.length)throw"no valid image file directory";var K,L=v[0],M=void 0===L.GDAL_NODATA||null===L.GDAL_NODATA?null:parseFloat(L.GDAL_NODATA.values[0]);if(L.TILEOFFSETS){var Q=q()===d,S=L.TILEOFFSETS?L.TILEOFFSETS.values:void 0;if(void 0===S)var X=void 0;else{var aa=L.TILEBYTECOUNTS.values,ja=L.TILEWIDTH.values[0],
oa=L.TILELENGTH.values[0],qa=L.IMAGEWIDTH.values[0],Sa=L.IMAGELENGTH.values[0],ra=qa*Sa,la=L.BITSPERSAMPLE.values[0],fa=L.SAMPLESPERPIXEL.values[0],Ea=L.SAMPLEFORMAT?L.SAMPLEFORMAT.values[0]:1,Ma=e(Ea,la);if(1!==(L.PLANARCONFIGURATION?L.PLANARCONFIGURATION.values[0]:1))throw console.log("can only handle PLANARCONFIGURATION\x3d1"),"can only handle PLANARCONFIGURATION\x3d1";var pa=L.COMPRESSION?L.COMPRESSION.values[0]:1;if(1!==pa&&6!==pa&&8!==pa&&32946!==pa)throw console.log("this compression is not supported at this moment"),
"this compression is not supported at this moment";if(3<Ea)X=void 0;else{if(3===Ea){var sa=new Float32Array(ra*fa);var wa=Float32Array}else 1===Ea?8>=la?(sa=new Uint8Array(ra*fa),wa=Uint8Array):16>=la?(sa=new Uint16Array(ra*fa),wa=Uint16Array):32>=la&&(sa=new Uint32Array(ra*fa),wa=Uint32Array):2===Ea&&(8>=la?(sa=new Int8Array(ra*fa),wa=Int8Array):16>=la?(sa=new Int16Array(ra*fa),wa=Int16Array):32>=la&&(sa=new Int32Array(ra*fa),wa=Int32Array));var ca,Fa,ha,Ga,Ta,Ya=Math.ceil(qa/ja);if(0===la%8)for(ca=
0;ca<S.length;ca++){var Za=Math.floor(ca/Ya)*oa;var $a=ca%Ya*ja;var ab=(Za*qa+$a)*fa;if("U8"===Ma||"S8"===Ma||Q)if(8===pa||32946===pa){var da=new Uint8Array(c,S[ca],aa[ca]);var Ua=new g(da);var bb=Ua.getBytes();var ta=new ArrayBuffer(bb.length);da=new Uint8Array(ta);da.set(bb);da.length!==ja*oa*fa*la/8&&console.log("tile byte counts is different than expected")}else if(6===pa){da=new Uint8Array(c,S[ca],aa[ca]);var Na=new H;Na.parse(da);var cb=Na.getData(Na.width,Na.height);ta=new ArrayBuffer(cb.length);
da=new Uint8Array(ta);da.set(cb)}else 1===pa&&(aa[ca]!==ja*oa*fa*la/8&&console.log("tile byte counts is different than expected"),ta=c.slice(S[ca],S[ca]+aa[ca]));else{if(8===pa||32946===pa){da=new Uint8Array(c,S[ca],aa[ca]);Ua=new g(da);da=Ua.getBytes();ta=new ArrayBuffer(da.length);var Ca=new Uint8Array(ta);da.length!==ja*oa*fa*la/8&&console.log("tile byte counts is different than expected")}else 1===pa&&(aa[ca]!==ja*oa*fa*la/8&&console.log("tile byte counts is different than expected"),ta=new ArrayBuffer(aa[ca]),
da=new Uint8Array(c,S[ca],aa[ca]),Ca=new Uint8Array(ta));switch(Ma){case "U16":case "S16":for(ha=0;ha<da.length;ha+=2)Ca[ha]=da[ha+1],Ca[ha+1]=da[ha];break;case "U32":case "S32":case "F32":for(ha=0;ha<da.length;ha+=4)Ca[ha]=da[ha+3],Ca[ha+1]=da[ha+2],Ca[ha+2]=da[ha+1],Ca[ha+3]=da[ha]}}var hb=new wa(ta);var Va=0;var Wa=ab;var ib=Math.min(ja,qa-$a);var jb=Math.min(oa,Sa-Za);for(Ga=0;Ga<jb;Ga++)for(Wa=ab+Ga*qa*fa,Va=Ga*ja*fa,Ta=0;Ta<ib*fa;Ta++,Wa++,Va++)sa[Wa]=hb[Va]}var Oa={width:qa,height:Sa,pixelType:Ma};
if(1===fa)Oa.pixels=[sa];else for(Oa.pixels=[],ca=0;ca<fa;ca++){var db=new wa(ra);for(Fa=0;Fa<ra;Fa++)db[Fa]=sa[Fa*fa+ca];Oa.pixels.push(db)}X=Oa}}}else if(L.STRIPOFFSETS){var kb=q()===d,xa=L.STRIPOFFSETS?L.STRIPOFFSETS.values:void 0;if(void 0===xa)X=void 0;else{var ya=L.STRIPBYTECOUNTS.values,Ha=L.ROWSPERSTRIP.values,za=L.IMAGEWIDTH.values[0],Ia=L.IMAGELENGTH.values[0],Aa=za*Ia,ma=L.BITSPERSAMPLE.values[0],ka=L.SAMPLESPERPIXEL.values[0],Ja=L.SAMPLEFORMAT?L.SAMPLEFORMAT.values[0]:1,Pa=e(Ja,ma);if(1!==
(L.PLANARCONFIGURATION?L.PLANARCONFIGURATION.values[0]:1))throw console.log("can only handle PLANARCONFIGURATION\x3d1"),"can only handle PLANARCONFIGURATION\x3d1";var na=L.COMPRESSION?L.COMPRESSION.values[0]:1;if(1!==na&&6!==na&&8!==na&&32946!==na)throw console.log("compressed tiff is not supported at this moment"),"compressed tiff is not supported at this moment";if(3<Ja)X=void 0;else{if(3===Ja){var ua=new Float32Array(Aa*ka);var Ba=Float32Array}else 1===Ja?8>=ma?(ua=new Uint8Array(Aa*ka),Ba=Uint8Array):
16>=ma?(ua=new Uint16Array(Aa*ka),Ba=Uint16Array):32>=ma&&(ua=new Uint32Array(Aa*ka),Ba=Uint32Array):2===Ja&&(8>=ma?(ua=new Int8Array(Aa*ka),Ba=Int8Array):16>=ma?(ua=new Int16Array(Aa*ka),Ba=Int16Array):32>=ma&&(ua=new Int32Array(za*Ia*ka),Ba=Int32Array));var ba,Ka,ia,La=Ha;if(0===ma%8)for(ba=0;ba<xa.length;ba++){var lb=ba*Ha*za*ka;La=(ba+1)*Ha>Ia?Ia-ba*Ha:Ha;if("U8"===Pa||"S8"===Pa||kb)if(8===na||32946===na){var ea=new Uint8Array(c,xa[ba],ya[ba]);var Xa=new g(ea);var eb=Xa.getBytes();var va=new ArrayBuffer(eb.length);
ea=new Uint8Array(va);ea.set(eb);ea.length!==La*za*ka*ma/8&&console.log("strip byte counts is different than expected")}else if(6===na){ea=new Uint8Array(c,xa[ba],ya[ba]);var Qa=new H;Qa.parse(ea);var fb=Qa.getData(Qa.width,Qa.height);va=new ArrayBuffer(fb.length);ea=new Uint8Array(va);ea.set(fb)}else 1===na&&(ya[ba]!==La*za*ka*ma/8&&console.log("strip byte counts is different than expected"),va=c.slice(xa[ba],xa[ba]+ya[ba]));else{if(6===na||8===na||32946===na){ea=new Uint8Array(c,xa[ba],ya[ba]);
Xa=new g(ea);ea=Xa.getBytes();va=new ArrayBuffer(ea.length);var Da=new Uint8Array(va);ea.length!==La*za*ka*ma/8&&console.log("strip byte counts is different than expected")}else 1===na&&(ya[ba]!==La*za*ka*ma/8&&console.log("strip byte counts is different than expected"),va=new ArrayBuffer(ya[ba]),ea=new Uint8Array(c,xa[ba],ya[ba]),Da=new Uint8Array(va));switch(Pa){case "U16":case "S16":for(ia=0;ia<ea.length;ia+=2)Da[ia]=ea[ia+1],Da[ia+1]=ea[ia];break;case "U32":case "S32":case "F32":for(ia=0;ia<ea.length;ia+=
4)Da[ia]=ea[ia+3],Da[ia+1]=ea[ia+2],Da[ia+2]=ea[ia+1],Da[ia+3]=ea[ia]}}var mb=new Ba(va);ua.set(mb,lb)}var Ra={width:za,height:Ia,pixelType:Pa};if(1===ka)Ra.pixels=[ua];else for(Ra.pixels=[],ba=0;ba<ka;ba++){var gb=new Ba(Aa);for(Ka=0;Ka<Aa;Ka++)gb[Ka]=ua[Ka*ka+ba];Ra.pixels.push(gb)}X=Ra}}}if(null!==M){X.maskData=new Uint8Array(X.width*X.height);if(1E24<Math.abs(M))for(K=0;K<X.width*X.height;K++)X.maskData[K]=1E-6>Math.abs((X.pixels[0][K]-M)/M)?0:1;else for(K=0;K<X.width*X.height;K++)X.maskData[K]=
X.pixels[0][K]===M?0:1;X.noDataValue=M}return X}}})},"esri/layers/rasterLib/tile/RasterHandler":function(){define("require exports module dojo/Deferred dojo/promise/all ../../PixelBlock ../../vectorTiles/core/workers ../../vectorTiles/core/promiseUtils ../../vectorTiles/core/requireUtils ../../vectorTiles/request ../../rasterLib/function/rasterFunctionHelper ../../rasterLib/renderer/rasterRendererHelper".split(" "),function(H,g,q,m,n,e,c,a,b,l,h,d){function f(k){var p=new m;n(k).then(function(v){p.resolve()});
return p.promise}return function(){function k(p){this.customModules=p&&p.customModules}k.prototype.destroy=function(){this.stop();this.customModules=this.rasterLayer=null};k.prototype.start=function(){this.stop();var p=new m,v=0,t=this.customModules?this.customModules.length+1:1,r=b.getAbsMid("esri/layers/rasterLib/tile/RasterWorker",H,q),w=c.open(r,{client:this}).then(function(u){this._connection=u;v++;v===t&&(this._connected=!0,p.resolve())}.bind(this));this._openDL=[w];this.customModules&&this.customModules.forEach(function(u){w=
c.open(u,{client:this}).then(function(y){v++;v===t&&(this._connected=!0,p.resolve())});this._openDL.push(w);console.log(u)}.bind(this));return this._connectionPromise=p.promise};k.prototype.stop=function(){this._openDL?this._openDL.forEach(function(p){p.isFulfilled()||p.cancel()}.bind(this)):this._connectionPromise&&!this._connectionPromise.isFulfilled()&&this._connectionPromise.cancel();this._connection&&(this._connection.close(),this._connection=null)};k.prototype.decode=function(p){if(!this._connectionPromise.isFulfilled()||
!this._connection)return a.reject(Error("no connection"));var v={id:null};return this._connection.invoke("decode",p,[],v).then(function(t){t.targetWorker=v;return t})};k.prototype.process=function(p){if(!this._connectionPromise.isFulfilled()||!this._connection)return a.reject(Error("no connection"));var v={id:null};p.layerId=this.rasterLayer.layerId;var t=new m;this._connection.invoke("process",p,[],v).then(function(r){r.targetWorker=v;r.src?Object.keys(r.src).forEach(function(w){r.src[w].pixelBlock=
new e(r.src[w].pixelBlock)}):r.src=null;r.pixelBlock&&(r.pixelBlock=new e(r.pixelBlock));t.resolve(r)});return t.promise};k.prototype.render=function(p){if(!this._connectionPromise.isFulfilled()||!this._connection)return a.reject(Error("no connection"));var v={id:null};p.layerId=this.rasterLayer.layerId;return this._connection.invoke("render",p,[],v).then(function(t){t.targetWorker=v;t.pixelBlock=t.pixelBlock?new e(t.pixelBlock):null;return t})};k.prototype.setLayer=function(p){if(!this._connectionPromise.isFulfilled()||
!this._connection)return a.reject(Error("no connection"));this.rasterLayer=p;p=this._connection.broadcast("setLayer",p,[],{id:null});return f(p)};k.prototype.setRasterFunction=function(p){if(!this._connectionPromise.isFulfilled()||!this._connection)return a.reject(Error("no connection"));p=this._connection.broadcast("setRasterFunction",p,[],{id:null});return f(p)};k.prototype.setRasterRenderer=function(p){if(!this._connectionPromise.isFulfilled()||!this._connection)return a.reject(Error("no connection"));
p=this._connection.broadcast("setRasterRenderer",p,[],{id:null});return f(p)};return k}()})},"esri/layers/vectorTiles/core/workers":function(){define(["require","exports","./workers/workers"],function(H,g,q){Object.defineProperty(g,"__esModule",{value:!0});for(var m in q)g.hasOwnProperty(m)||(g[m]=q[m])})},"esri/layers/vectorTiles/core/workers/workers":function(){define("require exports dojo/sniff dojo/promise/all ../Logger ../promiseUtils ./Connection ./RemoteClient ./WorkerOwner".split(" "),function(H,
g,q,m,n,e,c,a,b){function l(){if(v)return v;for(var t=h+d,r=[],w=function(y){var x=b.create(y).then(function(z){return p[y]=z});r.push(x)},u=0;u<t;u++)w(u);return v=m(r).then(function(){})}Object.defineProperty(g,"__esModule",{value:!0});g.Connection=c;g.RemoteClient=a;(c=navigator.hardwareConcurrency)||(c=q("safari")&&q("mac")||q("trident")?8:2);var h=q("esri-workers-debug")?1:Math.max(1,Math.ceil(c/2)),d=q("esri-workers-debug")?1:Math.max(1,Math.floor(c/2)),f=n.getLogger("esri.core.workers"),k=
0,p=[];g.initialize=function(){l()};g.open=function(t,r,w){void 0===r&&(r={});if(Array.isArray(t))return new g.Connection(t.map(function(x){return new g.RemoteClient(x,r.client)}));if("string"!==typeof t){f.warn("workers-open:signature-deprecated","DEPRECATED: workers.open() changed signature.");var u=t;t=r;r={client:u,strategy:w?"dedicated":"distributed"}}var y=r.strategy||"distributed";return"local"===y?e.create(function(x){H([t],function(z){x(g.RemoteClient.connect(z))})}).then(function(x){return new g.Connection([new g.RemoteClient(x,
r.client)])}):l().then(function(){if("dedicated"===y){var x=h+k++;k%=d;return p[x].open(t).then(function(z){return new g.Connection([new g.RemoteClient(z,r.client)])})}return e.all(p.map(function(z){return z.open(t)})).then(function(z){return new g.Connection(z.map(function(B){return new g.RemoteClient(B,r.client)}))})})};g.terminate=function(){for(var t=0;t<p.length;t++)p[t]&&p[t].terminate();p.length=0};var v})},"esri/layers/vectorTiles/core/Logger":function(){define(["require","exports","dojo/has"],
function(H,g,q){var m={info:0,warn:1,error:2};H=function(){function n(e){void 0===e&&(e={});this.module=e.module||"";this.writer=e.writer||null;this.level=e.level||null;null!=e.enabled&&(this.enabled=!!e.enabled);n._loggers[this.module]=this;e=this.module.lastIndexOf(".");-1!==e&&(this.parent=n.getLogger(this.module.slice(0,e)))}n.prototype.log=function(e){for(var c=[],a=1;a<arguments.length;a++)c[a-1]=arguments[a];this._isEnabled()&&this._matchLevel(e)&&(a=this._inheritedWriter())&&a.apply(void 0,
[e,this.module].concat(c))};n.prototype.error=function(){for(var e=[],c=0;c<arguments.length;c++)e[c]=arguments[c];this.log.apply(this,["error"].concat(e))};n.prototype.warn=function(){for(var e=[],c=0;c<arguments.length;c++)e[c]=arguments[c];this.log.apply(this,["warn"].concat(e))};n.prototype.info=function(){for(var e=[],c=0;c<arguments.length;c++)e[c]=arguments[c];this.log.apply(this,["info"].concat(e))};n.prototype.getLogger=function(e){return n.getLogger(this.module+"."+e)};n.getLogger=function(e){var c=
n._loggers[e];c||(c=new n({module:e}));return c};n.prototype._parentWithMember=function(e,c){for(var a=this;a&&null==a[e];)a=a.parent;return a?a[e]:c};n.prototype._inheritedWriter=function(){return this._parentWithMember("writer",this._consoleWriter)};n.prototype._consoleWriter=function(e,c){for(var a=[],b=2;b<arguments.length;b++)a[b-2]=arguments[b];console[e].apply(console,["["+c+"]"].concat(a))};n.prototype._matchLevel=function(e){return m[this._parentWithMember("level","error")]<=m[e]};n.prototype._isEnabled=
function(){return this._parentWithMember("enabled",!0)};n._loggers={};return n}();g=H.getLogger("esri");q("dojo-debug-messages")?g.level="info":g.level="warn";return H})},"esri/layers/vectorTiles/core/promiseUtils":function(){define("require exports dojo/Deferred dojo/when dojo/promise/all ./Error".split(" "),function(H,g,q,m,n,e){function c(a){if(a){if("function"!==typeof a.forEach){var b=Object.keys(a),l=b.map(function(k){return a[k]});return c(l).then(function(k){var p={};b.forEach(function(v,
t){return p[v]=k[t]});return p})}var h=new q,d=[],f=a.length;0===f&&h.resolve(d);a.forEach(function(k){var p={promise:k};d.push(p);k.then(function(v){p.value=v}).catch(function(v){p.error=v}).then(function(){--f;0===f&&h.resolve(d)})});return h.promise}}Object.defineProperty(g,"__esModule",{value:!0});g.all=function(a){return n(a)};g.filter=function(a,b){var l=a.slice();return n(a.map(function(h,d){return b(h,d)})).then(function(h){return l.filter(function(d,f){return h[f]})})};g.eachAlways=c;g.create=
function(a,b){var l=new q(b);a(function(h){void 0===h&&(h=null);return m(h).then(l.resolve)},l.reject);return l.promise};g.reject=function(a){var b=new q;b.reject(a);return b.promise};g.resolve=function(a){void 0===a&&(a=null);var b=new q;b.resolve(a);return b.promise};g.after=function(a,b){void 0===b&&(b=null);var l=0,h=new q(function(){l&&(clearTimeout(l),l=0)});l=setTimeout(function(){h.resolve(b)},a);return h.promise};g.timeout=function(a,b,l){var h=0,d=new q(a.cancel);a.then(function(f){d.isFulfilled()||
(d.resolve(f),h&&(clearTimeout(h),h=0))});a.catch(function(f){d.isFulfilled()||(d.reject(f),h&&(clearTimeout(h),h=0))});h=setTimeout(function(){var f=l||new e("promiseUtils:timeout","The wrapped promise did not resolve within "+b+" ms");d.reject(f)},b);return d.promise};g.wrapCallback=function(a){var b=!1,l=new q(function(){return b=!0});a(function(h){b||l.resolve(h)});return l.promise};g.isThenable=function(a){return a&&"function"===typeof a.then};g.when=function(a){return m(a)}})},"esri/layers/vectorTiles/core/Error":function(){define(["require",
"exports","./tsSupport/extendsHelper","./lang","./Message"],function(H,g,q,m,n){H=function(e){function c(a,b,l){var h=e.call(this,a,b,l)||this;return h instanceof c?h:new c(a,b,l)}q(c,e);c.prototype.toJSON=function(){return{name:this.name,message:this.message,details:m.clone(this.details),dojoType:this.dojoType}};c.fromJSON=function(a){var b=new c(a.name,a.message,a.details);null!=a.dojoType&&(b.dojoType=a.dojoType);return b};return c}(n);H.prototype.type="error";return H})},"esri/layers/vectorTiles/core/tsSupport/extendsHelper":function(){define([],
function(){return function(){var H=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(g,q){g.__proto__=q}||function(g,q){for(var m in q)q.hasOwnProperty(m)&&(g[m]=q[m])};return function(g,q){function m(){this.constructor=g}H(g,q);g.prototype=null===q?Object.create(q):(m.prototype=q.prototype,new m)}}()})},"esri/layers/vectorTiles/core/lang":function(){define("dojo/_base/kernel dojo/_base/lang dojo/date dojo/number dojo/date/locale dojo/i18n!../nls/common".split(" "),function(H,g,q,m,
n,e){function c(k){return void 0!==k&&null!==k}function a(k){return c(k)?k:""}function b(k,p,v){var t=v.match(/([^\(]+)(\([^\)]+\))?/i),r=g.trim(t[1]);v=p[k];t=JSON.parse((t[2]?g.trim(t[2]):"{}").replace(/^\(/,"{").replace(/\)$/,"}").replace(/([{,])\s*([0-9a-zA-Z_]+)\s*:/gi,'$1"$2":').replace(/"\s*:\s*'/gi,'":"').replace(/'\s*(,|\})/gi,'"$1'));var w=t.utcOffset;if(-1===d.indexOf(r))r=g.getObject(r),g.isFunction(r)&&(v=r(v,k,p,t));else if("number"===typeof v||"string"===typeof v&&v&&!isNaN(Number(v)))switch(v=
Number(v),r){case "NumberFormat":k=g.mixin({},t);p=parseFloat(k.places);if(isNaN(p)||0>p)k.places=Infinity;return m.format(v,k);case "DateString":v=new Date(v);if(t.local||t.systemLocale)return t.systemLocale?v.toLocaleDateString()+(t.hideTime?"":" "+v.toLocaleTimeString()):v.toDateString()+(t.hideTime?"":" "+v.toTimeString());v=v.toUTCString();t.hideTime&&(v=v.replace(/\s+\d\d:\d\d:\d\d\s+(utc|gmt)/i,""));return v;case "DateFormat":return v=new Date(v),c(w)&&(v=q.add(v,"minute",v.getTimezoneOffset()-
w)),n.format(v,t)}return a(v)}function l(k,p){var v;if(p)for(v in k)k.hasOwnProperty(v)&&(void 0===k[v]?delete k[v]:k[v]instanceof Object&&l(k[v],!0));else for(v in k)k.hasOwnProperty(v)&&void 0===k[v]&&delete k[v];return k}function h(k){if(!k||"object"!=typeof k||g.isFunction(k))return k;if(k instanceof Int8Array||k instanceof Uint8Array||k instanceof Uint8ClampedArray||k instanceof Int16Array||k instanceof Int32Array||k instanceof Uint16Array||k instanceof Uint32Array||k instanceof Float32Array||
k instanceof Float64Array||k instanceof Date)return new k.constructor(k);if(k instanceof ArrayBuffer)return k.slice(0,k.byteLength);if("function"===typeof k.clone)k=k.clone();else if("function"===typeof k.map&&"function"===typeof k.forEach)k=k.map(h);else if("function"===typeof k.notifyChange&&"function"===typeof k.watch)k=k.clone();else{var p={},v,t={};for(v in k){var r=k[v];var w=!(v in t)||t[v]!==r;if(!(v in p)||p[v]!==r&&w)p[v]=h?h(r):r}k=p}return k}var d=["NumberFormat","DateString","DateFormat"],
f=/<\/?[^>]+>/g;return{equals:function(k,p){return k===p||"number"===typeof k&&isNaN(k)&&"number"===typeof p&&isNaN(p)||g.isFunction((k||{}).getTime)&&g.isFunction((p||{}).getTime)&&k.getTime()==p.getTime()||g.isFunction((k||{}).equals)&&k.equals(p)||g.isFunction((p||{}).equals)&&p.equals(k)||!1},mixin:g.mixin,valueOf:function(k,p){for(var v in k)if(k[v]==p)return v;return null},stripTags:function(k){if(k){var p=typeof k;if("string"===p)k=k.replace(f,"");else if("object"===p)for(var v in k)(p=k[v])&&
"string"===typeof p&&(p=p.replace(f,"")),k[v]=p}return k},substitute:function(k,p,v){if(c(v))if(g.isObject(v)){var t=v.first;var r=v.dateFormat;var w=v.numberFormat}else t=v;if(p&&"{*}"!==p)return g.replace(p,g.hitch({obj:k},function(y,x){y=x.split(":");return 1<y.length?(x=y[0],y.shift(),b(x,this.obj,y.join(":"))):r&&-1!==(r.properties||[]).indexOf(x)?b(x,this.obj,r.formatter||"DateString"):w&&-1!==(w.properties||[]).indexOf(x)?b(x,this.obj,w.formatter||"NumberFormat"):a(this.obj[x])}));p=[];var u;
p.push('\x3ctable class\x3d"esri-widget__table" summary\x3d"'+e.fieldsSummary+'"\x3e\x3ctbody\x3e');for(u in k)if(v=k[u],r&&-1!==(r.properties||[]).indexOf(u)?v=b(u,k,r.formatter||"DateString"):w&&-1!==(w.properties||[]).indexOf(u)&&(v=b(u,k,w.formatter||"NumberFormat")),p.push("\x3ctr\x3e\x3cth\x3e"+u+"\x3c/th\x3e\x3ctd\x3e"+a(v)+"\x3c/td\x3e\x3c/tr\x3e"),t)break;p.push("\x3c/tbody\x3e\x3c/table\x3e");return p.join("")},filter:function(k,p,v){p=[g.isString(k)?k.split(""):k,v||H.global,g.isString(p)?
new Function("item","index","array",p):p];v={};var t;k=p[0];for(t in k)p[2].call(p[t],k[t],t,k)&&(v[t]=k[t]);return v},startsWith:function(k,p,v){v=v||0;return k.indexOf(p,v)===v},endsWith:function(k,p,v){if("number"!==typeof v||!isFinite(v)||Math.floor(v)!==v||v>k.length)v=k.length;v-=p.length;k=k.indexOf(p,v);return-1!==k&&k===v},isDefined:c,fixJson:l,clone:h}})},"esri/layers/vectorTiles/core/Message":function(){define(["require","exports","dojo/string"],function(H,g,q){return function(){function m(n,
e,c){this instanceof m&&(this.name=n,this.message=e&&q.substitute(e,c,function(a){return null==a?"":a})||"",this.details=c)}m.prototype.toString=function(){return"["+this.name+"]: "+this.message};return m}()})},"esri/layers/vectorTiles/core/workers/Connection":function(){define(["require","exports","../promiseUtils"],function(H,g,q){return function(){function m(n){this._clientIdx=0;this._clients=n}m.prototype.broadcast=function(n,e,c){for(var a=[],b=0,l=this._clients;b<l.length;b++)a.push(l[b].invoke(n,
e,c));return a};m.prototype.close=function(){for(var n=0,e=this._clients;n<e.length;n++)e[n].close();this._clients=[]};m.prototype.invoke=function(n,e,c,a){var b=a&&a.client;if(!this._clients||!this._clients.length)return q.reject(Error("Connection closed"));null!=b&&-1!==this._clients.indexOf(b)||this._clients.some(function(l){return l.isBusy()?!1:(b=l,!0)})||(this._clientIdx=(this._clientIdx+1)%this._clients.length,b=this._clients[this._clientIdx]);n=b.invoke(n,e,c);a&&(a.client=b);return n};m.prototype.openPorts=
function(){return q.all(this._clients.map(function(n){return n.openPort()}))};return m}()})},"esri/layers/vectorTiles/core/workers/RemoteClient":function(){define("require exports dojo/Deferred ../Error ../promiseUtils ./utils".split(" "),function(H,g,q,m,n,e){function c(k,p){k["delete"](p)}var a=e.MessageType.CLOSE,b=e.MessageType.CANCEL,l=e.MessageType.INVOKE,h=e.MessageType.RESPONSE,d=e.MessageType.OPEN_PORT,f=function(){function k(p){this._timer=null;this._cancelledJobIds=new Set;this._invokeMessages=
[];this._invoke=p;this._timer=null;this._process=this._process.bind(this)}k.prototype.push=function(p){p.type===e.MessageType.CANCEL?this._cancelledJobIds.add(p.jobId):(this._invokeMessages.push(p),null===this._timer&&(this._timer=setTimeout(this._process,0)))};k.prototype.clear=function(){this._invokeMessages.length=0;this._cancelledJobIds.clear();this._timer=null};k.prototype._process=function(){this._timer=null;for(var p=0,v=this._invokeMessages;p<v.length;p++){var t=v[p];this._cancelledJobIds.has(t.jobId)||
this._invoke(t)}this._cancelledJobIds.clear();this._invokeMessages.length=0};return k}();return function(){function k(p,v,t){this._outJobs=new Map;this._inJobs=new Map;this._queue=new f(this._onInvoke.bind(this));this._onMessage=this._onMessage.bind(this);this._client=v;this._port=p;this._port.addEventListener("message",this._onMessage);this._port.start();this._channel=t}k.connect=function(p){var v=new MessageChannel;p="function"===typeof p?new p:"default"in p&&"function"===typeof p.default?new p.default:
p;p.remoteClient=new k(v.port1,p,v);return v.port2};k.prototype.close=function(){this._post({type:a});this._close()};k.prototype.isBusy=function(){return 0<this._outJobs.size};k.prototype.invoke=function(p,v,t){var r=this;if(!this._port)return n.reject(new m("remote-client:port-closed","Can't invoke(), port is closed"));var w=e.newJobId(),u=new q(function(){c(r._outJobs,w);r._post({type:b,jobId:w})});this._outJobs.set(w,u);this._post({type:l,jobId:w,methodName:p},v,t);return u.promise};k.prototype.openPort=
function(){var p=this,v=e.newJobId(),t=new q(function(){c(p._outJobs,v);p._post({type:b,jobId:v})});this._outJobs.set(v,t);this._post({type:d,jobId:v});return t.promise};k.prototype._close=function(){this._channel&&(this._channel=null);this._port.removeEventListener("message",this._onMessage);this._port.close();this._outJobs.forEach(function(p){p.cancel()});this._inJobs.clear();this._outJobs.clear();this._queue.clear();this._port=this._client=null};k.prototype._onMessage=function(p){if(p=e.receiveMessage(p))switch(p.type){case h:this._onResponse(p);
break;case l:this._queue.push(p);break;case b:this._onCancel(p);break;case a:this._close();break;case d:this._onOpenPort(p)}};k.prototype._onCancel=function(p){var v=this._inJobs,t=p.jobId,r=v.get(t);this._queue.push(p);r&&(c(v,t),r.cancel())};k.prototype._onInvoke=function(p){var v=this,t=p.methodName,r=p.jobId;p=p.data;var w=this._inJobs,u=this._client,y=u[t];try{if(!y&&t&&-1!==t.indexOf("."))for(var x=t.split("."),z=0;z<x.length-1;z++)u=u[x[z]],y=u[x[z+1]];if("function"!==typeof y)throw new TypeError(t+
" is not a function");var B=y.call(u,p,this)}catch(E){this._post({type:h,jobId:r,error:e.toInvokeError(E)});return}n.isThenable(B)?(w.set(r,B),B.then(function(E){w.has(r)&&(c(w,r),v._post({type:h,jobId:r},E))}).catch(function(E){w.has(r)&&(c(w,r),E&&"cancel"===E.dojoType||v._post({type:h,jobId:r,error:e.toInvokeError(E||{message:"Error encountered at method "+t})}))})):this._post({type:h,jobId:r},B)};k.prototype._onOpenPort=function(p){var v=new MessageChannel;new k(v.port1,this._client);this._post({type:h,
jobId:p.jobId},v.port2,[v.port2])};k.prototype._onResponse=function(p){var v=p.jobId,t=p.error;p=p.data;var r=this._outJobs;if(r.has(v)){var w=r.get(v);c(r,v);t?w.reject(m.fromJSON(JSON.parse(t))):w.resolve(p)}};k.prototype._post=function(p,v,t){return e.postMessage(this._port,p,v,t)};return k}()})},"esri/layers/vectorTiles/core/workers/utils":function(){define(["require","exports","dojo/has"],function(H,g,q){function m(e){return e&&"object"===typeof e&&("result"in e||"transferList"in e)}Object.defineProperty(g,
"__esModule",{value:!0});(function(e){e[e.HANDSHAKE=0]="HANDSHAKE";e[e.CONFIGURE=1]="CONFIGURE";e[e.CONFIGURED=2]="CONFIGURED";e[e.OPEN=3]="OPEN";e[e.OPENED=4]="OPENED";e[e.RESPONSE=5]="RESPONSE";e[e.INVOKE=6]="INVOKE";e[e.CANCEL=7]="CANCEL";e[e.CLOSE=8]="CLOSE";e[e.OPEN_PORT=9]="OPEN_PORT"})(g.MessageType||(g.MessageType={}));var n=0;g.newJobId=function(){return n++};g.isTranferableResult=m;g.toInvokeError=function(e){return e?e.toJSON?JSON.stringify(e):JSON.stringify({name:e.name,message:e.message,
details:e.details,stack:e.stack}):null};g.postMessage=function(e,c,a,b){2===arguments.length||void 0===a&&void 0===b?e.postMessage(c):(q("esri-workers-supports-transfer-arraybuffer")||(b?(b=b.filter(function(l){return!(l instanceof ArrayBuffer)}),b.length||(b=null)):m(a)&&a.transferList&&(a.transferList=a.transferList.filter(function(l){return!(l instanceof ArrayBuffer)}),a.transferList.length||(a.transferList=null))),b?(c.data=a,e.postMessage(c,b)):m(a)?(c.data=a.result,a.transferList?e.postMessage(c,
a.transferList):e.postMessage(c)):(c.data=a,e.postMessage(c)))};g.receiveMessage=function(e){return e?(e=e.data)?"string"===typeof e?JSON.parse(e):e:null:null}})},"esri/layers/vectorTiles/core/workers/WorkerOwner":function(){define("require exports dojo/Deferred ../../kernel ../Error ../Logger ../promiseUtils ./utils ./workerFactory".split(" "),function(H,g,q,m,n,e,c,a,b){var l=e.getLogger("esri.core.workers"),h=a.MessageType.CANCEL,d=a.MessageType.INVOKE,f=a.MessageType.OPEN,k=a.MessageType.OPENED,
p=a.MessageType.RESPONSE;return function(){function v(t,r){this._outJobs=new Map;this._inJobs=new Map;this.worker=t;this.id=r;t.addEventListener("message",this._onMessage.bind(this));t.addEventListener("error",function(w){w.preventDefault();l.error(w)})}v.create=function(t){return b.createWorker().then(function(r){return new v(r,t)})};v.prototype.terminate=function(){this.worker.terminate()};v.prototype.open=function(t){var r=this,w=a.newJobId(),u=new q(function(y){r._outJobs["delete"](w);r._post({type:h,
jobId:w})});this._outJobs.set(w,u);this._post({type:f,jobId:w,modulePath:t});return u.promise};v.prototype._onMessage=function(t){if(t=a.receiveMessage(t))switch(t.type){case k:case p:this._onResponse(t);break;case h:this._onCancel(t);break;case d:this._onInvoke(t)}};v.prototype._onCancel=function(t){(t=this._inJobs.get(t.jobId))&&t.cancel()};v.prototype._onInvoke=function(t){var r=this,w=t.methodName,u=t.jobId;t=t.data;var y=this._inJobs,x=m.workerMessages[w];try{if("function"!==typeof x)throw new TypeError(w+
" is not a function");var z=x.call(null,t)}catch(B){this._post({type:p,jobId:u,error:a.toInvokeError(B)});return}c.isThenable(z)?(y.set(u,z),z.then(function(B){y["delete"](u);r._post({type:p,jobId:u},B)}).catch(function(B){y["delete"](u);B||(B={message:"Error encountered at method"+w});B.dojoType&&"cancel"===B.dojoType||r._post({type:p,jobId:u,error:a.toInvokeError(B)})})):this._post({type:p,jobId:u},z)};v.prototype._onResponse=function(t){var r=t.jobId,w=t.error;t=t.data;var u=this._outJobs.get(r);
u&&(this._outJobs["delete"](r),w?u.reject(n.fromJSON(JSON.parse(w))):u.resolve(t))};v.prototype._post=function(t,r,w){return a.postMessage(this.worker,t,r,w)};return v}()})},"esri/layers/vectorTiles/core/workers/workerFactory":function(){define("require exports ../tsSupport/assignHelper dojo/_base/kernel ../../config ../../request ../Logger ../promiseUtils ../sniff ../urlUtils ./loaderConfig ./utils ./WorkerFallback".split(" "),function(H,g,q,m,n,e,c,a,b,l,h,d,f){function k(x){return a.create(function(z){function B(I){if(I=
d.receiveMessage(I))switch(I.type){case y:I=x;var C=n.workers.loaderUrl||h.DEFAULT_LOADER_URL;if(null!=n["default"]){var A=q({},n);delete A["default"];A=JSON.parse(JSON.stringify(A))}else A=JSON.parse(JSON.stringify(n));var F=n.workers.loaderConfig;F=h.default({baseUrl:F.baseUrl,locale:m.locale,has:q({"config-deferredInstrumentation":0,"dojo-test-sniff":0,"esri-cors":1,"esri-secure-context":b("esri-secure-context"),"esri-workers-supports-transfer-arraybuffer":b("esri-workers-supports-transfer-arraybuffer"),
"events-keypress-typed":0,"host-webworker":1},F.has),map:q({},F.map),paths:q({},F.paths),packages:F.packages||[]});I.postMessage({type:u,configure:{esriConfig:A,loaderUrl:C,loaderConfig:F}});break;case w:x.removeEventListener("message",B),x.removeEventListener("error",E),z(x)}}function E(I){I.preventDefault();x.removeEventListener("message",B);x.removeEventListener("error",E);t.warn("Failed to create Worker. Fallback to execute module in main thread",I);x=new f;x.addEventListener("message",B);x.addEventListener("error",
E)}x.addEventListener("message",B);x.addEventListener("error",E)})}Object.defineProperty(g,"__esModule",{value:!0});var p=l.normalize(H.toUrl("./worker.js")),v=!l.hasSameOrigin(p,location.href),t=c.getLogger("esri.core.workers"),r=null,w=d.MessageType.CONFIGURED,u=d.MessageType.CONFIGURE,y=d.MessageType.HANDSHAKE;g.createWorker=function(){if(!b("esri-workers"))return k(new f);if(!v){var x=void 0;try{x=new Worker(p)}catch(z){t.warn("Failed to create Worker. Fallback to execute module in main thread",
event),x=new f}return k(x)}r||(r=e(p,{responseType:"text"}));return r.then(function(z){return new Worker(URL.createObjectURL(new Blob([z.data],{type:"text/javascript"})))}).catch(function(z){t.warn("Failed to create Worker. Fallback to execute module in main thread",z);return new f}).then(function(z){return k(z)})}})},"esri/layers/vectorTiles/core/tsSupport/assignHelper":function(){define([],function(){return Object.assign||function(H){for(var g,q=1,m=arguments.length;q<m;q++){g=arguments[q];for(var n in g)Object.prototype.hasOwnProperty.call(g,
n)&&(H[n]=g[n])}return H}})},"esri/layers/vectorTiles/config":function(){define(["require","exports","esri/config"],function(H,g,q){Object.defineProperty(q,"workers",{get:function(){return q.defaults.workers},set:function(m){return q.defaults.workers=m}});return q})},"esri/layers/vectorTiles/request":function(){define(["require","exports","esri/request","dojo/_base/lang","dojo/Deferred"],function(H,g,q,m,n){return function(e,c){e=m.mixin({},{url:e,failOk:!0},c);"array-buffer"===c.responseType?(e.handleAs=
"arraybuffer",delete e.responseType):c.responseType&&(e.handleAs=c.responseType,delete e.responseType);null!==c.query&&(e.content=e.query,delete e.query);if(c.hasOwnProperty("allowImageDataAccess")){var a={allowImageDataAccess:c.allowImageDataAccess};delete e.allowImageDataAccess}var b=new n(function(){l.isFulfilled()||l.cancel()});var l=q(e,a).then(function(h){b.resolve({data:h})}).catch(function(h){h&&null!=h.httpCode&&(h.details=h.details||{},h.details.httpStatus=h.httpCode);b.reject(h)});return b.promise}})},
"esri/layers/vectorTiles/core/sniff":function(){define(["require","exports","dojo/sniff","./global","../views/webgl/context-util"],function(H,g,q,m,n){function e(){var l={available:!1,version:0,majorPerformanceCaveat:!1,supportsHighPrecisionFragment:!1,supportsVertexShaderSamplers:!1,supportsElementIndexUint:!1,supportsStandardDerivatives:!1},h=document.createElement("canvas");if(!h)return l;var d=n.createContext(h,{failIfMajorPerformanceCaveat:!0},"webgl");!d&&(d=n.createContext(h,{},"webgl"))&&
(l.majorPerformanceCaveat=!0);if(!d)return l;h=d.getParameter(d.VERSION);if(!h)return l;if(h=h.match(/^WebGL\s+([\d.]*)/))l.version=parseFloat(h[1]),l.available=.94<=l.version,h=d.getShaderPrecisionFormat(d.FRAGMENT_SHADER,d.HIGH_FLOAT),l.supportsHighPrecisionFragment=h&&0<h.precision,l.supportsVertexShaderSamplers=0<d.getParameter(d.MAX_VERTEX_TEXTURE_IMAGE_UNITS),l.supportsElementIndexUint=null!==d.getExtension("OES_element_index_uint"),l.supportsStandardDerivatives=null!==d.getExtension("OES_standard_derivatives");
return l}function c(){var l={available:!1,version:0},h=document.createElement("canvas");if(!h)return l;h=n.createContext(h,{},"webgl2");if(!h)return l;l.available=!0;h=h.getParameter(h.VERSION);if(!h)return l;if(h=h.match(/^WebGL\s+([\d.]*)/))l.version=parseFloat(h[1]);return l}(function(){var l=navigator.userAgent,h=l.match(/Android|webOS|iPhone|iPad|iPod|BlackBerry|Opera Mini|IEMobile/i);l=l.match(/iPhone/i);h&&q.add("esri-mobile",h);l&&q.add("esri-iPhone",l);q.add("esri-phonegap",!!m.cordova);
q.add("esri-cors",q("esri-phonegap")||"XMLHttpRequest"in m&&"withCredentials"in new XMLHttpRequest);q.add("esri-geolocation",function(){return!!navigator.geolocation});q.add("esri-canvas-svg-support",function(){return!(q("trident")||q("ie"))});q.add("esri-secure-context",function(){if("isSecureContext"in m)return m.isSecureContext;if(m.location&&m.location.origin)return 0===m.location.origin.indexOf("https:")});q.add("esri-wasm","WebAssembly"in m);q("host-webworker")||(q.add("esri-workers","Worker"in
m),q.add("esri-script-sandbox",function(){return"MessageChannel"in m&&"HTMLIFrameElement"in m&&"sandbox"in HTMLIFrameElement.prototype}),q.add("esri-url-encodes-apostrophe",function(){var d=m.document.createElement("a");d.href="?'";return-1<d.href.indexOf("?%27")}),a||(a=e()),q.add("esri-webgl",a.available),q.add("esri-webgl-high-precision-fragment",a.supportsHighPrecisionFragment),q.add("esri-webgl-vertex-shader-samplers",a.supportsVertexShaderSamplers),q.add("esri-webgl-element-index-uint",a.supportsElementIndexUint),
q.add("esri-webgl-standard-derivatives",a.supportsStandardDerivatives),q.add("esri-webgl-major-performance-caveat",a.majorPerformanceCaveat),q.add("esri-featurelayer-webgl-labeling",!0),b||(b=c()),q.add("esri-webgl2",b.available))})();var a=null,b=null;return q})},"esri/layers/vectorTiles/core/global":function(){define(["require","exports"],function(H,g){return function(){if("undefined"!==typeof global)return global;if("undefined"!==typeof window)return window;if("undefined"!==typeof self)return self}()})},
"esri/layers/vectorTiles/views/webgl/context-util":function(){define(["require","exports"],function(H,g){function q(c,a,b){void 0===a&&(a={});switch(b){case "webgl":var l=["webgl","experimental-webgl","webkit-3d","moz-webgl"];break;case "webgl2":l=["webgl2"];break;default:l=["webgl","experimental-webgl","webkit-3d","moz-webgl"]}b=null;for(var h=0;h<l.length;h++){var d=l[h];try{b=c.getContext(d,a)}catch(f){}if(b)break}return b}function m(c,a){(c=c.parentNode)&&(c.innerHTML='\x3ctable style\x3d"background-color: #8CE; width: 100%; height: 100%;"\x3e\x3ctr\x3e\x3ctd align\x3d"center"\x3e\x3cdiv style\x3d"display: table-cell; vertical-align: middle;"\x3e\x3cdiv style\x3d""\x3e'+
a+"\x3c/div\x3e\x3c/div\x3e\x3c/td\x3e\x3c/tr\x3e\x3c/table\x3e")}Object.defineProperty(g,"__esModule",{value:!0});g.createContextOrErrorHTML=function(c,a,b){void 0===a&&(a={});if(!window.WebGLRenderingContext)return m(c,n),null;a=q(c,a,b);return a?a:(m(c,e),null)};g.createContext=q;var n='This page requires a browser that supports WebGL.\x3cbr/\x3e\x3ca href\x3d"http://get.webgl.org"\x3eClick here to upgrade your browser.\x3c/a\x3e',e='It doesn\'t appear your computer can support WebGL.\x3cbr/\x3e\x3ca href\x3d"http://get.webgl.org/troubleshooting/"\x3eClick here for more information.\x3c/a\x3e'})},
"esri/layers/vectorTiles/core/urlUtils":function(){define(["require","exports","esri/urlUtils","dojo/_base/url"],function(H,g,q,m){function n(u){return q.normalize(u)}function e(u){return"data:"===u.slice(0,5)}function c(u){return a(u)||r.test(u)}function a(u){return u&&"/"===u[0]&&"/"===u[1]}function b(u){return q.urlToObject(u)}function l(u){if("string"===typeof u)return new m(d(u));u.scheme||(u.scheme=g.appUrl.scheme);return u}function h(u){if(e(u))return null;var y=u.indexOf("://");if(-1===y&&
a(u))y=2;else if(-1!==y)y+=3;else return null;y=u.indexOf("/",y);return-1===y?u:u.slice(0,y)}function d(u,y,x){void 0===y&&(y=g.appBaseUrl);if(a(u))return x&&x.preserveProtocolRelative?u:"http"===g.appUrl.scheme&&g.appUrl.authority===h(u).slice(2)?"http:"+u:"https:"+u;if(r.test(u))return u;"/"===u[0]&&(x=y.indexOf("//"),x=y.indexOf("/",x+2),y=-1===x?y:y.slice(0,x));return k(y,u)}function f(u,y,x){void 0===x&&(x=!1);u=l(u);y=l(y);return x||u.scheme===y.scheme?u.host.toLowerCase()===y.host.toLowerCase()&&
u.port===y.port:!1}function k(){for(var u=[],y=0;y<arguments.length;y++)u[y]=arguments[y];if(u&&u.length){y=[];if(c(u[0])){var x=u[0],z=x.indexOf("//");y.push(x.slice(0,z+1));t.test(u[0])&&(y[0]+="/");u[0]=x.slice(z+2)}else"/"===u[0][0]&&y.push("");u=u.reduce(function(B,E){return E?B.concat(E.split("/")):B},[]);for(x=0;x<u.length;x++)z=u[x],".."===z&&0<y.length?y.pop():!z||"."===z&&0!==y.length||y.push(z);return y.join("/")}}function p(u,y,x){if(!(y&&x&&u&&c(u)))return u;var z=u.indexOf("//"),B=u.indexOf("/",
z+2),E=u.indexOf(":",z+2);B=Math.min(0>B?u.length:B,0>E?u.length:E);if(u.slice(z+2,B).toLowerCase()!==y.toLowerCase())return u;y=u.slice(0,z+2);u=u.slice(B);return""+y+x+u}function v(u,y,x){void 0===y&&(y=g.appBaseUrl);if(!c(u))return u;var z=n(u),B=z.toLowerCase();y=n(y).toLowerCase().replace(/\/+$/,"");if((x=x?n(x).toLowerCase().replace(/\/+$/,""):null)&&0!==y.indexOf(x))return u;for(var E=function(A,F,G){G=A.indexOf(F,G);return-1===G?A.length:G},I=E(B,"/",B.indexOf("//")+2),C=-1;B.slice(0,I+1)===
y.slice(0,I)+"/";){C=I+1;if(I===B.length)break;I=E(B,"/",I+1)}if(-1===C||x&&C<x.length)return u;u=z.slice(C);z=y.slice(C-1).replace(/[^/]+/g,"").length;if(0<z)for(B=0;B<z;B++)u="../"+u;else u="./"+u;return u}Object.defineProperty(g,"__esModule",{value:!0});g.normalize=n;g.canUseXhr=function(u){return q.canUseXhr(u)};g.removeTrailingSlash=function(u){return u.replace(/\/+$/,"")};H=Function("return this")();g.appUrl=new m(H.location);g.appBaseUrl=function(){var u=g.appUrl.path;u=u.substring(0,u.lastIndexOf(u.split("/")[u.split("/").length-
1]));return g.appUrl.scheme+"://"+g.appUrl.host+(null!=g.appUrl.port?":"+g.appUrl.port:"")+u}();var t=/^\s*file:/i,r=/^\s*[a-z][a-z0-9-+.]*:[^0-9]/i;g.isDataProtocol=e;g.isAbsolute=c;g.isProtocolRelative=a;g.urlToObject=b;g.getOrigin=h;g.makeAbsolute=d;g.hasSameOrigin=f;g.join=k;g.removeFile=function(u){var y=0;if(c(u)){var x=u.indexOf("//");-1!==x&&(y=x+2)}x=u.lastIndexOf("/");return x<y?u:u.slice(0,x+1)};g.addProxy=function(u){return q.addProxy(u)};g.makeData=function(u){return u.isBase64?"data:"+
u.mediaType+";base64,"+u.data:"data:"+u.mediaType+","+u.data};var w=/^data:(.*?)(;base64)?,(.*)$/;g.dataComponents=function(u){return(u=u.match(w))?{mediaType:u[1],isBase64:!!u[2],data:u[3]}:null};g.changeDomain=p;g.read=function(u,y){var x=y&&y.url&&y.url.path;u&&x&&(u=d(u,x,{preserveProtocolRelative:!0}));(y=y&&y.portal)&&!y.isPortal&&y.urlKey&&y.customBaseUrl?(x=y.urlKey+"."+y.customBaseUrl,y=f(g.appUrl,g.appUrl.scheme+"://"+x)?p(u,y.portalHostname,x):p(u,x,y.portalHostname)):y=u;return y};g.write=
function(u,y){if(!u)return u;!c(u)&&y&&y.blockedRelativeUrls&&y.blockedRelativeUrls.push(u);var x=d(u);if(y){var z=y.verifyItemRelativeUrls&&y.verifyItemRelativeUrls.rootPath||y.url&&y.url.path;z&&(x=v(x,z,z),x!==u&&y.verifyItemRelativeUrls&&y.verifyItemRelativeUrls.writtenUrls.push(x))}u=x;x=(y=y&&y.portal)&&!y.isPortal&&y.urlKey&&y.customBaseUrl?p(u,y.urlKey+"."+y.customBaseUrl,y.portalHostname):u;return x};g.makeRelative=v;g.removeQueryParameters=function(u){u=b(u);Object.keys(u.query||{});return u.path}})},
"esri/layers/vectorTiles/core/workers/loaderConfig":function(){define(["require","exports","../tsSupport/assignHelper","dojo/has","../urlUtils"],function(H,g,q,m,n){Object.defineProperty(g,"__esModule",{value:!0});g.DEFAULT_LOADER_URL=n.makeAbsolute(n.removeQueryParameters(H.toUrl("./worker-init.js")));g.DEFAULT_CONFIG={baseUrl:function(){var e=n.removeQueryParameters(H.toUrl("dojo/x.js"));return n.makeAbsolute(e.slice(0,e.length-5))}(),packages:[{name:"esri"},{name:"dojo"},{name:"dojox"},{name:"dstore"},
{name:"moment",main:"moment"},{name:"@dojo"},{name:"cldrjs",main:"dist/cldr"},{name:"globalize",main:"dist/globalize"},{name:"maquette",main:"dist/maquette.umd"},{name:"maquette-css-transitions",main:"dist/maquette-css-transitions.umd"},{name:"maquette-jsx",main:"dist/maquette-jsx.umd"},{name:"tslib",main:"tslib"}],map:{globalize:{cldr:"cldrjs/dist/cldr","cldr/event":"cldrjs/dist/cldr/event","cldr/supplemental":"cldrjs/dist/cldr/supplemental","cldr/unresolved":"cldrjs/dist/cldr/unresolved"}}};g.default=
function(e){var c={async:e.async,isDebug:e.isDebug,locale:e.locale,baseUrl:e.baseUrl,has:q({},e.has),map:q({},e.map),packages:e.packages&&e.packages.concat()||[],paths:q({},e.paths)};e.hasOwnProperty("async")||(c.async=!0);e.hasOwnProperty("isDebug")||(c.isDebug=!1);e.baseUrl||(c.baseUrl=g.DEFAULT_CONFIG.baseUrl);g.DEFAULT_CONFIG.packages.forEach(function(h){a:{for(var d=c.packages,f=0;f<d.length;f++)if(d[f].name===h.name)break a;h=q({},h);f=n.removeQueryParameters(H.toUrl(h.name+"/x.js"));f=f.slice(0,
f.length-5);h.location=n.makeAbsolute(f);d.push(h)}});e=c.map=c.map||{};for(var a=0,b=Object.keys(g.DEFAULT_CONFIG.map);a<b.length;a++){var l=b[a];e[l]||(e[l]=g.DEFAULT_CONFIG.map[l])}return c}})},"esri/layers/vectorTiles/core/workers/WorkerFallback":function(){define(["require","exports","dojo/has","../global","./utils"],function(H,g,q,m,n){var e=function(){return function(){var b=this,l=document.createDocumentFragment();["addEventListener","dispatchEvent","removeEventListener"].forEach(function(h){b[h]=
function(){for(var d=[],f=0;f<arguments.length;f++)d[f]=arguments[f];return l[h].apply(l,d)}})}}(),c=m.MutationObserver||m.WebKitMutationObserver,a=function(){if(m.process&&m.process.nextTick)var b=function(d){m.process.nextTick(d)};else if(m.Promise)b=function(d){m.Promise.resolve().then(d)};else if(c){var l=[],h=document.createElement("div");(new c(function(){for(;0<l.length;)l.shift()()})).observe(h,{attributes:!0});b=function(d){l.push(d);h.setAttribute("queueStatus","1")}}return b}();return function(){function b(){this._dispatcher=
new e;this._isInitialized=!1;this._workerPostMessage({type:n.MessageType.HANDSHAKE})}b.prototype.terminate=function(){};Object.defineProperty(b.prototype,"onmessage",{get:function(){return this._onmessageHandler},set:function(l){this._onmessageHandler&&this.removeEventListener("message",this._onmessageHandler);(this._onmessageHandler=l)&&this.addEventListener("message",l)},enumerable:!0,configurable:!0});Object.defineProperty(b.prototype,"onerror",{get:function(){return this._onerrorHandler},set:function(l){this._onerrorHandler&&
this.removeEventListener("error",this._onerrorHandler);(this._onerrorHandler=l)&&this.addEventListener("error",l)},enumerable:!0,configurable:!0});b.prototype.postMessage=function(l,h){var d=this;a(function(){d._workerMessageHandler(new MessageEvent("message",{data:l}))})};b.prototype.dispatchEvent=function(l){return this._dispatcher.dispatchEvent(l)};b.prototype.addEventListener=function(l,h,d){this._dispatcher.addEventListener(l,h,d)};b.prototype.removeEventListener=function(l,h,d){this._dispatcher.removeEventListener(l,
h,d)};b.prototype._workerPostMessage=function(l,h){var d=this;a(function(){d.dispatchEvent(new MessageEvent("message",{data:l}))})};b.prototype._workerMessageHandler=function(l){var h=this;if(l=n.receiveMessage(l)){var d=l.jobId;switch(l.type){case n.MessageType.CONFIGURE:this._isInitialized||this._workerPostMessage({type:n.MessageType.CONFIGURED});break;case n.MessageType.OPEN:l=l.modulePath,q("esri-webpack")?H(["esri/core/workers/RemoteClient","esri/views/vectorTiles/WorkerTileHandler","esri/views/2d/layers/features/Pipeline",
"esri/views/3d/layers/PointCloudWorker","esri/views/3d/layers/SceneLayerWorker","esri/layers/graphics/sources/support/CSVSourceWorker","esri/views/3d/webgl-engine/lib/edgeRendering/EdgeProcessingWorker",l],function(f,k,p,v,t,r,w,u){switch(u){case "esri/views/vectorTiles/WorkerTileHandler":break;case "esri/views/2d/layers/features/Pipeline":k=p;break;case "esri/views/3d/layers/PointCloudWorker":k=v;break;case "esri/views/3d/layers/SceneLayerWorker":k=t;break;case "esri/layers/graphics/sources/support/CSVSourceWorker":k=
r;break;case "esri/views/3d/webgl-engine/lib/edgeRendering/EdgeProcessingWorker":k=w;break;default:k=u}f=f.connect(k);h._workerPostMessage({type:n.MessageType.OPENED,jobId:d,data:f})}):H(["./RemoteClient",l],function(f,k){f=f.connect(k);h._workerPostMessage({type:n.MessageType.OPENED,jobId:d,data:f})})}}};return b}()})},"esri/layers/vectorTiles/core/requireUtils":function(){define(["require","exports","dojo/Deferred"],function(H,g,q){function m(n,e){if(Array.isArray(e)){var c=new q;n(e,function(){for(var a=
[],b=0;b<arguments.length;b++)a[b]=arguments[b];c.resolve(a)});return c.promise}return m(n,[e]).then(function(a){return a[0]})}Object.defineProperty(g,"__esModule",{value:!0});g.when=m;g.getAbsMid=function(n,e,c){return e.toAbsMid?e.toAbsMid(n):c.id.replace(/\/[^\/]*$/gi,"/")+n}})},"esri/layers/rasterLib/function/rasterFunctionHelper":function(){define(["dojo/_base/declare","dojo/_base/lang","./rasterFunctionRegistry"],function(H,g,q){return{create:function(m,n){if(m){var e=m.renderTexture,c=Object.keys(m);
if(m.read&&!n)return m;m.read&&n&&(m=m.toJson());-1<c.indexOf("name")&&c.indexOf(!1)?(m=g.mixin({},m),n=this._parseV2(m,n)):(m="esri.layers.RasterFunction"===m.declaredClass?m.toJson():g.mixin({},m),n=this._parseV1(m,n));n.branchCount=n.updateBranchStructure();n.renderTexture||(n.renderTexture=!!e);return n}},_parseV1:function(m,n){var e=m.rasterFunction,c=m.rasterFunctionArguments,a=m.renderTexture||m.rasterFunctionArguments.renderTexture||!1,b,l,h,d,f,k,p;(d=c.raster||c.Raster)&&d.rasterFunction&&
(b=this._parseV1(d,n));(d=c.raster2||c.Raster2)&&d.rasterFunction&&(l=this._parseV1(d,n));(d=c.rasters||c.Rasters)&&0<d.length&&(h=d.map(g.hitch(this,function(v){return v&&v.rasterFunction?this._parseV1(v,n):v})));(d=c.dem||c.DEM)&&(d.functionName||d.rasterFunction)&&(f=this._parseV1(d,n));(d=c.fillRaster||c.FillRaster)&&(d.functionName||d.rasterFunction)&&(k=this._parseV1(d,n));d=q.functions[e];if(!d)return console.error("Function is not currently supported: "+e),null;e=new d(c);e.variableName&&
(d=c[e.variableName])&&(d.functionName||d.rasterFunction)&&(p=this._parseV1(d,n));m.outputPixelType&&(e.pixelType=m.outputPixelType);"$$"===b?e.functionArguments.raster=n&&n.raster:null!=b?e.functionArguments.raster=b:e.functionArguments.raster||(e.functionArguments.raster=n&&n.raster);null!=l&&(e.functionArguments.raster2=l);null!=h&&(e.functionArguments.rasters=h.map(function(v){"$$"===v&&(v=n&&n.raster);return v}));null!=f&&(e.functionArguments.dem=f);null!=k&&(e.functionArguments.fillRaster=k);
null!=p&&(e.functionArguments[e.variableName]=p);e.renderTexture=a;return e},_parseV2:function(m,n){if(!m)return null;m=g.clone(m);this._bindV2Args(m,n);var e={};this._convertTov1(m,e);return this._parseV1(e,n)},_bindV2Args:function(m,n){(m||n)&&Object.keys(m).forEach(function(e){m[e]["function"]&&m[e].arguments?this._bindV2Args(m[e].arguments,n):null!=n[m[e].name]&&(m[e].value=n[m[e].name])}.bind(this))},_convertV2Types:function(m){if(!m)return null;"ArgumentArray"===m.type?m.elements&&"RasterStatistics"===
m.elements[0].type&&(m=m.elements):m instanceof Array&&0===m.length&&(m=null);return m},_convertTov1:function(m,n){if((m||n)&&m["function"]){var e=m["function"],c=m.arguments;n.rasterFunction=e.type.replace("Function","");n.outputPixelType="UNKNOWN"===e.pixelType?"Unknown":e.pixelType;n.rasterFunctionArguments={};var a;Object.keys(c).forEach(function(b){c[b]["function"]&&c[b].arguments?(n.rasterFunctionArguments[b]={},this._convertTov1(c[b],n.rasterFunctionArguments[b])):(a=c[b].value,n.rasterFunctionArguments[b]=
"object"!==typeof a||a.functionArguments?a:this._convertV2Types(a))}.bind(this))}}}})},"esri/layers/rasterLib/function/rasterFunctionRegistry":function(){define("dojo/_base/declare dojo/_base/lang ../../rasterLib/function/AspectFunction ../../rasterLib/function/BandArithmeticFunction ../../rasterLib/function/ColormapFunction ../../rasterLib/function/CompositeBandFunction ../../rasterLib/function/ContrastBrightnessFunction ../../rasterLib/function/ConvolutionFunction ../../rasterLib/function/ExtractBandFunction ../../rasterLib/function/HillshadeFunction ../../rasterLib/function/LocalFunction ../../rasterLib/function/MaskFunction ../../rasterLib/function/NDVIFunction ../../rasterLib/function/SlopeFunction ../../rasterLib/function/StretchFunction ../../rasterLib/function/RemapFunction ../../rasterLib/function/IdentityFunction ../../rasterLib/function/ResampleFunction".split(" "),
function(H,g,q,m,n,e,c,a,b,l,h,d,f,k,p,v,t,r){return function(){function w(z){z.prototype.supportWebGL&&(y[z.prototype.functionName]=z);z.prototype.support2D&&(u[z.prototype.functionName]=z);x[z.prototype.functionName]=z}var u={},y={},x={};w(q);w(m);w(n);w(e);w(c);w(a);w(b);w(l);w(h);w(d);w(f);w(k);w(p);w(v);w(t);w(r);return{cpu:u,gpu:y,functions:x,register:w,getFunction:function(z){return x[z]},support:function(z,B){return!!("gpu"===B?y:"cpu"===B?u:x)[z]}}}()})},"esri/layers/rasterLib/function/AspectFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../../WKIDUnitConversion ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin ./surfaceUtils".split(" "),
function(H,g,q,m,n,e,c,a){return H([q,c],{declaredClass:"esri.layers.rasterLib.function.AspectFunction",functionName:"Aspect",supportWebGL:!0,support2D:!0,constructor:function(b){this.functionArguments=this.mixinIgnoreCase({raster:null},b)},bind:function(){var b=this.getSourceRasterInfo();if(!b.raster)return Error("The raster input to aspect function is invalid.");this.rasterInfo=g.mixin(b.raster,{bandCount:1,pixelType:this._calculatePixelType(this.pixelType,"F32"),statistics:[{min:0,max:360}],histograms:null});
this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType="Generic";return!0},read2D:function(b){this._performance.start();b=a.aspect(b.raster);this._addPerformanceMetric(this._performance.elapsed());return b},readGL:function(b){this._performance.start();this._initializeProgram({fragment:e.aspect,fragmentName:"Aspect"});var l=this._setupTextureData(b.raster),h=this.bindFrameBuffer(),d=this.gl,f=d.drawingBufferWidth;d=d.drawingBufferHeight;var k=l.extent;
this._setUniforms({u_resolution:b&&b.raster&&b.raster.pixelBlock?[1/b.raster.pixelBlock.width,1/b.raster.pixelBlock.height]:[1/f,1/d],u_cellSize:[(k.xmax-k.xmin)/f,(k.ymax-k.ymin)/d]});this._bindTexture(l.texture,"u_image");this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:l.extent,texture:h.texture}}})})},"esri/layers/rasterLib/function/RasterFunctionX":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/config ../raster/RasterInfo ../../../geometry/Extent ../../PixelBlock".split(" "),
function(H,g,q,m,n,e){return H(null,{functionName:null,functionArguments:null,pixelType:"Unknown",rasterInfo:null,constructor:function(c){c&&(this.pixelType=c.outputPixelType||c.OutputPixelType||this.pixelType,this.renderTexture=c.renderTexture,this._initFunction())},mixinIgnoreCase:function(c,a){var b=Object.keys(c),l=Object.keys(a),h,d,f=b.length;for(h=0;h<l.length;h++){var k=a[l[h]];if(null!=k)for(d=0;d<f;d++)if(b[d].toLowerCase()===l[h].toLowerCase()){c[b[d]]=k;break}}return c},bind:function(c){},
setProcessingContext:function(c){if(!c)throw"cannot bind to layer without options";this.useWebGL=!!c.useWebGL;this._tileMode=!!c.tileMode;this._glSetting=c.glSetting;this._rawRasterInfo=c.rawRasterInfo;this._xformSetting=c.xformSetting||this._xformSetting;if(!this.useWebGL||this._glSetting&&this._glSetting.gl){this.gl=this.useWebGL?this._glSetting.gl:null;this._glSetting&&(this._glSetting.pingpong=null,this._glSetting.branches=null);var a=this.functionArguments.raster,b=this.functionArguments.raster2,
l=this.functionArguments.dem,h=this.functionArguments.fillRaster,d=this.functionArguments.rasters;a&&a.functionArguments&&a.setProcessingContext(c);b&&b.functionArguments&&b.setProcessingContext(c);l&&l.functionArguments&&l.setProcessingContext(c);h&&h.functionArguments&&h.setProcessingContext(c);if(d)for(a=0;a<d.length;a++)d[a]&&d[a].functionArguments&&d[a].setProcessingContext(c);this.bind()}},updateBranchStructure:function(){var c=0,a=this.functionArguments;a.raster&&a.raster.read&&a.raster.functionArguments&&
(c+=a.raster.updateBranchStructure());a.raster2&&a.raster2.read&&a.raster2.functionArguments&&(c+=a.raster2.updateBranchStructure(),a.raster2.isBranch=!0,a.raster&&a.raster.read&&(a.raster.isBranch=!0));a.rasters&&(c=a.rasters.length,a.rasters.forEach(function(b){b.read&&b.functionArguments&&(b.isBranch=!0)}));a.dem&&a.dem.read&&a.dem.functionArguments&&(c+=a.dem.updateBranchStructure());return 1===c?0:c},read:function(c){c=this.processRasterArgument(c);return this.useWebGL?this.readGL(c):this.read2D(c)},
hasTilingEffects:function(){return!1},read2D:function(){},readGL:function(){},getSourceRasterInfo:function(){var c,a={};if(this.functionArguments.raster2)a.functionArguments.raster=this._bindRaster(this.functionArguments.raster),a.functionArguments.raster2=this._bindRaster(this.functionArguments.raster2);else if(this.functionArguments.rasters)for(a.rasters=[],c=0;c<this.functionArguments.rasters.length;c++)a.rasters[c]=this._bindRaster(this.functionArguments.rasters[c]);else a.raster=this._bindRaster(this.functionArguments.raster);
return this.sourceRasterInfo=a},processRasterArgument:function(c){var a=this.bind();if(!0!==a)throw a;var b={};if(this.functionArguments.raster2)b.raster=this._readRaster(this.functionArguments.raster,c),b.raster2=this._readRaster(this.functionArguments.raster2,c);else if(this.functionArguments.rasters)for(b.rasters=[],a=0;a<this.functionArguments.rasters.length;a++)b.rasters[a]=this._readRaster(this.functionArguments.rasters[a],c);else b.raster=this._readRaster(this.functionArguments.raster,c);return b},
toJson:function(){var c=this.functionArguments,a=c.raster,b=c.raster2;c=c.rasters;a=a?a.toJson?a.toJson():a:null;b=b?b.toJson?b.toJson():b:null;var l;c&&0<c.length&&(l=c.map(function(h){return h.toJson?h.toJson():h}));c=g.mixin({},this.functionArguments);c.raster=a;c.raster2=b;c.rasters=l;c=this._fixRasterFunctionJson(c);return{rasterFunction:this.functionName,rasterFunctionArguments:c,outputPixelType:this.pixelType}},_initFunction:function(c){},_getIntegerRange:function(c){switch(c){case "U8":var a=
[0,255];break;case "U16":a=[0,65535];break;case "U32":a=[0,4294967295];break;case "S8":a=[-128,127];break;case "S16":a=[-32768,32767];break;case "S32":a=[-2147483648,2147483647]}return a},_calculatePixelType:function(c,a){return c&&"unknown"!==c.toLowerCase()?c:a},_clonePixelData:function(c){if(null==c)return c;var a={};c.extent&&(a.extent=new n(c.extent.xmin,c.extent.ymin,c.extent.xmax,c.extent.ymax,c.extent.spatialReference));c=c.pixelBlock;if(null==c)return a;a.pixelBlock=c.clone?c.clone():e.prototype.clone(c);
return a},_readRaster:function(c,a){if(null==c||"$$"===c)var b=this._clonePixelData(a.src[Object.keys(a.src)[0]]);else c&&c.rasterInfo&&!c.functionArguments?b=this._clonePixelData(a.src[c._rasterId]):isNaN(c)?c.read&&(b=c.functionArguments?c.read(a):this._clonePixelData(a)):(b=a.src?a.src[Object.keys(a.src)[0]]:a,a=b.pixelBlock,a=new Float32Array(a.width*a.height),a.fill(parseFloat(c)),b=this._clonePixelData(b),b.pixelBlock.pixels=[a],b.isConstant=!0);return b},_bindRaster:function(c){if(c&&"$$"!==
c)isNaN(c)?c.rasterInfo?a=c.rasterInfo:c.bind&&c.bind()&&(a=c.rasterInfo):a={};else var a=this._rawRasterInfo;a&&(a=a.clone?a.clone():new m(a),a.bandCount=a.bandCount||3);return a},_getOutputBand:function(c,a){switch(c){case "U8":c=new Uint8Array(a);break;case "U16":c=new Uint16Array(a);break;case "U32":c=new Uint32Array(a);break;case "S8":c=new Int8Array(a);break;case "S16":c=new Int16Array(a);break;case "S32":c=new Int32Array(a);break;case "U32":c=new Uint32Array(a);break;case "F32":c=new Float32Array(a);
break;case "F64":c=new Float64Array(a);break;default:c=new Float32Array(a)}return c},_clampBand:function(c,a,b){if(("F64"===a||"F32"===a)&&!b)return c;var l,h=this._getIntegerRange(a),d=c.length;if(h)for(b=h[1],h=h[0],a=this._getOutputBand(a,d),l=0;l<d;l++){var f=c[l];a[l]=f>b?b:f<h?h:f}else a=c;return a},_performance:{start:function(){return this._start=self.performance&&self.performance.now()||new Date}.bind(this),elapsed:function(){return(self.performance&&self.performance.now()||new Date)-this._start}.bind(this)},
_addPerformanceMetric:function(c){q.isDebug&&(self.rasterFunctionPerformance||(self.rasterFunctionPerformance=[]),self.rasterFunctionPerformance.push(c),50<self.rasterFunctionPerformance.length&&self.rasterFunctionPerformance.shift())},_fixRasterFunctionJson:function(c){for(var a in c)c.hasOwnProperty(a)&&(null==c[a]?delete c[a]:c[a]instanceof Object&&!c[a].sourceType&&this._fixRasterFunctionJson(c[a],!0));return c}})})},"esri/layers/rasterLib/function/pixelShaders":function(){define(["dojo/_base/declare",
"dojo/_base/lang","./pixelShaderScripts"],function(H,g,q){H={shaderType:"fragment",getShader:function(m,n){var e=m.createShader(m.FRAGMENT_SHADER);m.shaderSource(e,n);m.compileShader(e);m.getShaderParameter(e,m.COMPILE_STATUS)||(e=null);return e}};g.mixin(H,q);return H})},"esri/layers/rasterLib/function/pixelShaderScripts":function(){define([],function(){return{aspect:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform vec2 u_resolution;\nuniform vec2 u_cellSize;\nfloat getNeighborHoodAlpha(float a, float b, float c, float d, float e, float f, float g, float h, float i){\nif (a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0 || a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0 || a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0) {\nreturn 0.0;\n}\nelse {\nreturn e;\n}\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\nfloat pi \x3d 3.141592653589793238;\nfloat dz_dx \x3d 0.0;\nfloat dz_dy \x3d 0.0;\nvec4 va, vb, vc,vd,ve,vf,vg,vh,vi;\nvec2 axy \x3d vec2(-1.0,-1.0);\nvec2 bxy \x3d vec2(0.0, -1.0);\nvec2 cxy \x3d vec2(1.0, -1.0);\nvec2 dxy \x3d vec2(-1.0, 0.0);\nvec2 fxy \x3d vec2(1.0, 0.0);\nvec2 gxy \x3d vec2(-1.0, 1.0);\nvec2 hxy \x3d vec2(0.0, 1.0);\nvec2 ixy \x3d vec2(1.0, 1.0);\nif (v_texCoord.s \x3c u_resolution.s)\n{\naxy[0] \x3d 1.0;\ndxy[0] \x3d 1.0;\ngxy[0] \x3d 1.0;\n}\nif (v_texCoord.t \x3c u_resolution.t)\n{\naxy[1] \x3d 1.0;\nbxy[1] \x3d 1.0;\ncxy[1] \x3d 1.0;\n}\nif (v_texCoord.s \x3e1.0-u_resolution.s)\n{\ncxy[0] \x3d -1.0;\nfxy[0] \x3d -1.0;\nixy[0] \x3d -1.0;\n}\nif (v_texCoord.t \x3e 1.0- u_resolution.t)\n{\ngxy[1] \x3d -1.0;\nhxy[1] \x3d -1.0;\nixy[1] \x3d -1.0;\n}\nif (v_texCoord.s \x3e\x3d u_resolution.s \x26\x26 (1.0-u_resolution.s)\x3e\x3dv_texCoord.s \x26\x26 v_texCoord.t \x3e\x3d u_resolution.t \x26\x26 (1.0-u_resolution.t)\x3e\x3dv_texCoord.t)\n{\nva \x3d texture2D(u_image, v_texCoord + u_resolution* axy);\nvb \x3d texture2D(u_image, v_texCoord + u_resolution* bxy);\nvc \x3d texture2D(u_image, v_texCoord + u_resolution* cxy);\nvd \x3d texture2D(u_image, v_texCoord + u_resolution* dxy);\nve \x3d texture2D(u_image, v_texCoord + u_resolution* vec2(0, 0));\nvf \x3d texture2D(u_image, v_texCoord + u_resolution* fxy);\nvg \x3d texture2D(u_image, v_texCoord + u_resolution* gxy);\nvh \x3d texture2D(u_image, v_texCoord + u_resolution* hxy);\nvi \x3d texture2D(u_image, v_texCoord + u_resolution* ixy);\n}\ndz_dx \x3d (vc+2.0*vf+vi - va - 2.0*vd - vg).r/(8.0*u_cellSize[0]);\ndz_dy \x3d -(vg+2.0*vh+vi - va - 2.0*vb - vc).r/(8.0*u_cellSize[1]);\nfloat alpha \x3d getNeighborHoodAlpha(va.a, vb.a, vc.a, vd.a, ve.a, vf.a, vg.a, vh.a, vi.a);\nfloat aspect_rad \x3d 0.0;\nif (dz_dx \x3d\x3d 0.0)\n{\nif (dz_dy \x3e 0.0)\naspect_rad \x3d 0.5 * pi;\nelse if (dz_dy \x3c 0.0)\naspect_rad \x3d 1.5 * pi;\nelse\nalpha \x3d 0.0;//undefined make it nodata\n}\nelse\n{\naspect_rad \x3d 0.5*pi + atan(dz_dy, -dz_dx);\nif (aspect_rad \x3c 0.0)\naspect_rad \x3d 2.0*pi + aspect_rad;\n}\nfloat aspect \x3d aspect_rad * 180.0 / pi;\ngl_FragColor \x3d vec4(aspect, aspect, aspect, alpha);\n}",
bandArithmetic:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform int u_bandId_nir;\nuniform int u_bandId_red;\nuniform bool u_scaled;\nuniform int u_bandCount;\nuniform int u_method;\nuniform float u_constants[6];\nvec4 calculateNDVI() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat red \x3d float(u_bandId_red \x3d\x3d 0 ? currentPixel.r : (u_bandId_red \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat nir \x3d float(u_bandId_nir \x3d\x3d 0 ? currentPixel.r : (u_bandId_nir \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat ndvi_denom \x3d nir + red;\nfloat ndvi;\nif (ndvi_denom \x3d\x3d 0.0) {\nndvi \x3d 0.0;\n} else {\nndvi \x3d (nir - red) / ndvi_denom;\nif (u_scaled) {\nndvi \x3d float(floor(ndvi * 100.0 + 100.5));\n}\n}\nreturn vec4(ndvi, ndvi, ndvi, currentPixel.a);\n}\nvec4 calculateSAVI() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat red \x3d float(u_bandId_red \x3d\x3d 0 ? currentPixel.r : (u_bandId_red \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat nir \x3d float(u_bandId_nir \x3d\x3d 0 ? currentPixel.r : (u_bandId_nir \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat savi_denom \x3d nir + red + u_constants[0];\nfloat savi;\nif (savi_denom \x3d\x3d 0.0) {\nsavi \x3d 0.0;\n} else {\nsavi \x3d (nir - red) / savi_denom * (1.0 + u_constants[0]);\n}\nreturn vec4(savi, savi, savi, currentPixel.a);\n}\nvec4 calculateMSAVI() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat red \x3d float(u_bandId_red \x3d\x3d 0 ? currentPixel.r : (u_bandId_red \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat nir \x3d float(u_bandId_nir \x3d\x3d 0 ? currentPixel.r : (u_bandId_nir \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat msavi \x3d 0.5 * (2.0 * (nir + 1.0) - sqrt(pow((2.0 * nir + 1.0), 2.0) - 8.0 * (nir - red)));\nreturn vec4(msavi, msavi, msavi, currentPixel.a);\n}\nvec4 calculateTSAVI() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat red \x3d float(u_bandId_red \x3d\x3d 0 ? currentPixel.r : (u_bandId_red \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat nir \x3d float(u_bandId_nir \x3d\x3d 0 ? currentPixel.r : (u_bandId_nir \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat s \x3d u_constants[0];\nfloat a \x3d u_constants[1];\nfloat x \x3d u_constants[2];\nfloat tsavi_denom \x3d a * nir + red - a * s + x * (1.0 + s * s);\nfloat tsavi;\nif (tsavi_denom \x3d\x3d 0.0) {\ntsavi \x3d 0.0;\n} else {\ntsavi \x3d s * (nir - s * red - a) / tsavi_denom;\n}\nreturn vec4(tsavi, tsavi, tsavi, currentPixel.a);\n}\nvec4 calculatePVI() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat red \x3d float(u_bandId_red \x3d\x3d 0 ? currentPixel.r : (u_bandId_red \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat nir \x3d float(u_bandId_nir \x3d\x3d 0 ? currentPixel.r : (u_bandId_nir \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat a \x3d u_constants[0];\nfloat b \x3d u_constants[1];\nfloat pvi \x3d (nir - a * red - b) / sqrt(1.0 + a * 2.0);\nreturn vec4(pvi, pvi, pvi, currentPixel.a);\n}\nvec4 calculateGEMI() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat red \x3d float(u_bandId_red \x3d\x3d 0 ? currentPixel.r : (u_bandId_red \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat nir \x3d float(u_bandId_nir \x3d\x3d 0 ? currentPixel.r : (u_bandId_nir \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat gemi;\nif (red \x3d\x3d 1.0) {\ngemi \x3d 0.0;\n} else {\nfloat eta \x3d (2.0 * (nir * nir - red * red) + 1.5 * nir + 0.5 * red) / (nir + red + 0.5);\nfloat gemi \x3d eta * (1.0 - 0.25*eta) - (red - 0.125) / (1.0 - red);\n}\nreturn vec4(gemi, gemi, gemi, currentPixel.a);\n}\nvec4 calculateVARI() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat red \x3d float(currentPixel.r);\nfloat green \x3d float(currentPixel.g);\nfloat blue \x3d float(currentPixel.b);\nfloat vari \x3d (green - red) /(green + red - blue);\nreturn vec4(vari, vari, vari, currentPixel.a);\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\nvec4 pv;\nif (u_method \x3c 4) {\nif (u_method \x3d\x3d 1) {\npv \x3d calculateNDVI();\n} else if (u_method \x3d\x3d 2) {\npv \x3d calculateSAVI();\n} else if (u_method \x3d\x3d 3) {\npv \x3d calculateTSAVI();\n} else if (u_method \x3d\x3d 4) {\npv \x3d calculateMSAVI();\n}\n} else {\nif (u_method \x3d\x3d 5) {\npv \x3d calculateGEMI();\n} else if (u_method \x3d\x3d 6) {\npv \x3d calculatePVI();\n} else if (u_method \x3d\x3d 7) {\npv \x3d calculateGEMI();\n} else if (u_method \x3d\x3d 9) {\npv \x3d calculateVARI();\n}\n}\ngl_FragColor \x3d pv;\n}",
colormap:"precision mediump float;\nuniform sampler2D u_image;\nuniform sampler2D u_image1;\nvarying vec2 v_texCoord;\nuniform float u_indexedColormapOffset;\nuniform float u_indexedColormapMaxIndex;\nvec4 colorize() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat clrIndex \x3d currentPixel.r - u_indexedColormapOffset;\nvec4 result;\nif (currentPixel.a \x3d\x3d 0.0 || clrIndex \x3e u_indexedColormapMaxIndex) {\nresult \x3d vec4(0.0, 0.0, 0.0, 0.0);\n}\nelse {\nvec2 clrPosition \x3d vec2(clrIndex / u_indexedColormapMaxIndex, 0.0);\nvec4 color \x3d texture2D(u_image1, clrPosition);\nresult \x3d vec4(color.r, color.g, color.b, color.a);\n}\nreturn result;\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d colorize();\n}",
compositeBand:"precision mediump float;\nuniform sampler2D u_image;\nuniform sampler2D u_image1;\nuniform sampler2D u_image2;\nvarying vec2 v_texCoord;\nuniform int u_rasterCount;\nvec4 composite() {\nvec4 p0, p1, p2;\np0 \x3d texture2D(u_image, v_texCoord);\nvec4 result;\nif (u_rasterCount \x3d\x3d 1){\nresult \x3d p0;\n}\nelse if (u_rasterCount \x3d\x3d 2){\np1 \x3d texture2D(u_image1, v_texCoord);\nresult \x3d vec4(p0.r,p1.r,0.0,min(p0.a,p1.a));\n}\nelse if (u_rasterCount \x3d\x3d 3){\np1 \x3d texture2D(u_image1, v_texCoord);\np2 \x3d texture2D(u_image2, v_texCoord);\nresult \x3d vec4(p0.r,p1.r,p2.r,min(min(p0.a,p1.a),p2.a));\n}\nreturn result;\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d composite();\n}",
constant:"precision mediump float;\nuniform vec4 u_color;\nvoid main() {\ngl_FragColor \x3d u_color;\n}",contrastBrightness:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform float u_contrastOffset;\nuniform float u_brightnessOffset;\nuniform float u_scaleFactor;\nvec4 adjustContrastBrightness() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat c \x3d u_contrastOffset;\nfloat b \x3d u_brightnessOffset;\nfloat maxI \x3d 255.0;\nfloat mid \x3d 128.0;\nvec4 v;\nif (c \x3e 0.0 \x26\x26 c \x3c 100.0) {\nv \x3d (200.0 * currentPixel - 100.0 * maxI + 2.0 * maxI * b) / (2.0 * (100.0 - c)) + mid;\n} else if (c \x3c\x3d 0.0 \x26\x26 c \x3e -100.0) {\nv \x3d (200.0 * currentPixel - 100.0 * maxI + 2.0 * maxI * b) * (100.0 + c) / 20000.0 + mid;\n} else if (c \x3d\x3d 100.0) {\nv \x3d (200.0 * currentPixel - 100.0 * maxI + (maxI + 1.0) * (100.0 - c) + 2.0 * maxI * b);\nv \x3d (sign(v) + 1.0) / 2.0; //binary contrast with extra mid tone at 0.5\n} else if (c \x3d\x3d -100.0) {\nv \x3d vec4(mid, mid, mid, currentPixel.a); //no contrast\n}\nreturn vec4(v.r / u_scaleFactor, v.g / u_scaleFactor, v.b / u_scaleFactor, currentPixel.a);\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d adjustContrastBrightness();\n}",
convolution:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform vec2 u_resolution;\nuniform float u_kernel[25];\nuniform int u_kernelSize;\nvec4 convolve33(){\nvec4 vp11, vp12, vp13, vp21, vp22, vp23, vp31, vp32, vp33;\nvec2 xy11 \x3d vec2(-1.0, -1.0);\nvec2 xy12 \x3d vec2(0.0, -1.0);\nvec2 xy13 \x3d vec2(1.0, -1.0);\nvec2 xy21 \x3d vec2(-1.0, 0.0);\nvec2 xy23 \x3d vec2(1.0, 0.0);\nvec2 xy31 \x3d vec2(-1.0, 1.0);\nvec2 xy32 \x3d vec2(0.0, 1.0);\nvec2 xy33 \x3d vec2(1.0, 1.0);\nif (v_texCoord.s \x3c u_resolution.s) {\nxy11[0] \x3d 1.0;\nxy21[0] \x3d 1.0;\nxy31[0] \x3d 1.0;\n}\nif (v_texCoord.t \x3c u_resolution.t) {\nxy11[1] \x3d 1.0;\nxy12[1] \x3d 1.0;\nxy13[1] \x3d 1.0;\n}\nif (v_texCoord.s \x3e 1.0 - u_resolution.s) {\nxy13[0] \x3d -1.0;\nxy23[0] \x3d -1.0;\nxy33[0] \x3d -1.0;\n}\nif (v_texCoord.t \x3e 1.0 - u_resolution.t) {\nxy31[1] \x3d -1.0;\nxy32[1] \x3d -1.0;\nxy33[1] \x3d -1.0;\n}\nvec4 convolResult \x3d\ntexture2D(u_image, v_texCoord + u_resolution * xy11) * u_kernel[0] +\ntexture2D(u_image, v_texCoord + u_resolution * xy12) * u_kernel[1] +\ntexture2D(u_image, v_texCoord + u_resolution * xy13) * u_kernel[2] +\ntexture2D(u_image, v_texCoord + u_resolution * xy21) * u_kernel[3] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(0, 0)) * u_kernel[4] +\ntexture2D(u_image, v_texCoord + u_resolution * xy23) * u_kernel[5] +\ntexture2D(u_image, v_texCoord + u_resolution * xy31) * u_kernel[6] +\ntexture2D(u_image, v_texCoord + u_resolution * xy32) * u_kernel[7] +\ntexture2D(u_image, v_texCoord + u_resolution * xy33) * u_kernel[8];\nreturn vec4(convolResult.rgb, texture2D(u_image, v_texCoord).a);\n}\nvec4 convolve55(){\nvec4 vp11, vp12, vp13, vp21, vp22, vp23, vp31, vp32, vp33;\nfloat xdif[5];//https://www.opengl.org/wiki/Data_Type_(GLSL) array constructor ES3.0\nfloat ydif[5];\nfloat a \x3d -2.0;\nfor (int i\x3d0; i\x3c5; i++){\nxdif[i] \x3d a;\nydif[i] \x3d a;\na++;\n}\nif (v_texCoord.s \x3c u_resolution.s *2.0) { //2 pixel\nxdif[0] \x3d 2.0;\nif (v_texCoord.s \x3c u_resolution.s) { //1 pixel\nxdif[1] \x3d 1.0;\n}\n}\nelse if (v_texCoord.s \x3e 1.0 - u_resolution.s *2.0) {\nxdif[0] \x3d -2.0;\nif (v_texCoord.s \x3e 1.0 - u_resolution.s) {\nxdif[1] \x3d -1.0;\n}\n}\nif (v_texCoord.t \x3c u_resolution.t *2.0) {\nydif[0] \x3d 2.0;\nif (v_texCoord.t \x3c u_resolution.t) {\nydif[1] \x3d 1.0;\n}\n}\nelse if (v_texCoord.t \x3e 1.0 - u_resolution.t*2.0) {\nydif[0] \x3d -2.0;\nif (v_texCoord.t \x3e 1.0 - u_resolution.t) {\nydif[1] \x3d -1.0;\n}\n}\nvec4 convolResult \x3d\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[0], ydif[0])) * u_kernel[0] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[1], ydif[0])) * u_kernel[1] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[2], ydif[0])) * u_kernel[2] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[3], ydif[0])) * u_kernel[3] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[4], ydif[0])) * u_kernel[4] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[0], ydif[1])) * u_kernel[5] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[1], ydif[1])) * u_kernel[6] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[2], ydif[1])) * u_kernel[7] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[3], ydif[1])) * u_kernel[8] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[4], ydif[1])) * u_kernel[9] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[0], ydif[2])) * u_kernel[10] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[1], ydif[2])) * u_kernel[11] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[2], ydif[2])) * u_kernel[12] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[3], ydif[2])) * u_kernel[13] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[4], ydif[2])) * u_kernel[14] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[0], ydif[3])) * u_kernel[15] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[1], ydif[3])) * u_kernel[16] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[2], ydif[3])) * u_kernel[17] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[3], ydif[3])) * u_kernel[18] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[4], ydif[3])) * u_kernel[19] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[0], ydif[4])) * u_kernel[20] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[1], ydif[4])) * u_kernel[21] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[2], ydif[4])) * u_kernel[22] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[3], ydif[4])) * u_kernel[23] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[4], ydif[4])) * u_kernel[24];\nreturn vec4(convolResult.rgb, texture2D(u_image, v_texCoord).a);\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\nif (u_kernelSize \x3d\x3d 9){\ngl_FragColor \x3d convolve33();\n}\nelse {\ngl_FragColor \x3d convolve55();\n}\n}",
extractBand:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform int u_bandIDs[3];\nuniform bool u_alterBand;\nvec4 extractBand() {\nvec4 p \x3d texture2D(u_image, v_texCoord);\nif (!u_alterBand){\nreturn p;\n}\nfloat r, g, b;\nif (u_bandIDs[0] \x3d\x3d0){\nr \x3d p.r;\n}\nelse if (u_bandIDs[0] \x3d\x3d1){\nr \x3d p.g;\n}\nelse if (u_bandIDs[0] \x3d\x3d2){\nr \x3d p.b;\n}\nif (u_bandIDs[1] \x3d\x3d0){\ng \x3d p.r;\n}\nelse if (u_bandIDs[1] \x3d\x3d1){\ng \x3d p.g;\n}\nelse if (u_bandIDs[1] \x3d\x3d2){\ng \x3d p.b;\n}\nif (u_bandIDs[2] \x3d\x3d0){\nb \x3d p.r;\n}\nelse if (u_bandIDs[2] \x3d\x3d1){\nb \x3d p.g;\n}\nelse if (u_bandIDs[2] \x3d\x3d2){\nb \x3d p.b;\n}\nreturn vec4(r, g, b, p.a);\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d extractBand();\n}",
hillshade:"precision mediump float;\nuniform sampler2D u_image;\nuniform sampler2D u_image1;\nvarying vec2 v_texCoord;\nuniform vec2 u_resolution;\nuniform int u_slopeType;\nuniform int u_hillshadeType;\nuniform int u_lightSourceCount;\nuniform float u_sinZcosA;\nuniform float u_sinZsinA;\nuniform float u_cosZ;\nuniform float u_sinZcosAs[6];\nuniform float u_sinZsinAs[6];\nuniform float u_cosZs[6];\nuniform float u_weights[6];\nuniform float u_xFactor;\nuniform float u_yFactor;\nuniform bool u_scaled;\nuniform float u_minValue;\nuniform float u_maxValue;\nuniform bool u_applyColorramp;\nuniform float u_indexedColormapOffset;\nuniform float u_indexedColormapMaxIndex;\nuniform vec2 u_rawResolution;\nuniform int u_resampling;\nvec4 getPixelValue(vec2 coords) {\nif (u_resampling \x3d\x3d 0) {\nreturn texture2D(u_image, coords);\n}\nvec2 pos_ul \x3d floor(coords / u_rawResolution) * u_rawResolution;\nvec2 pos_ur \x3d pos_ul + vec2(1.0, 0.0) * u_rawResolution;\nvec2 pos_ll \x3d pos_ul + vec2(0.0, 1.0) * u_rawResolution;\nvec2 pos_lr \x3d pos_ul + vec2(1.0, 1.0) * u_rawResolution;\nvec2 weight \x3d fract(coords / u_rawResolution);\nvec4 vp_ul \x3d texture2D(u_image, pos_ul);\nvec4 vp_ur \x3d texture2D(u_image, pos_ur);\nvec4 vp_ll \x3d texture2D(u_image, pos_ll);\nvec4 vp_lr \x3d texture2D(u_image, pos_lr);\nvec4 vp \x3d mix(mix(vp_ul, vp_ur, weight.x), mix(vp_ll, vp_lr, weight.x), weight.y);\nreturn vp;\n}\nfloat getNeighborHoodAlpha(float a, float b, float c, float d, float e, float f, float g, float h, float i){\nif (a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0 || a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0 || a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0) {\nreturn 0.0;\n}\nelse {\nreturn e;\n}\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvec3 rgb2hsv(vec3 c) {\nvec4 K \x3d vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec4 p \x3d c.g \x3c c.b ? vec4(c.bg, K.wz) : vec4(c.gb, K.xy);\nvec4 q \x3d c.r \x3c p.x ? vec4(p.xyw, c.r) : vec4(c.r, p.yzx);\nfloat d \x3d q.x - min(q.w, q.y);\nfloat e \x3d 1.0e-10;\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), min(d / (q.x + e), 1.0), q.x);\n}\nvec3 hsv2rgb(vec3 c) {\nvec4 K \x3d vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 p \x3d abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\nreturn c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\nvec4 overlay(float val, float minValue, float maxValue, float hillshade, float alpha) {\nfloat clrIndex \x3d clamp((val - minValue) / (maxValue - minValue), 0.0, 1.0);\nvec4 rgb \x3d texture2D(u_image1, vec2(clrIndex, 0.0));\nvec3 hsv \x3d rgb2hsv(rgb.xyz);\nhsv.z \x3d hillshade;\nreturn vec4(hsv2rgb(hsv) * alpha, alpha);\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\nvec4 va, vb, vc, vd, ve, vf, vg, vh, vi;\nvec2 axy \x3d vec2(-1.0, -1.0);\nvec2 bxy \x3d vec2(0.0, -1.0);\nvec2 cxy \x3d vec2(1.0, -1.0);\nvec2 dxy \x3d vec2(-1.0, 0.0);\nvec2 fxy \x3d vec2(1.0, 0.0);\nvec2 gxy \x3d vec2(-1.0, 1.0);\nvec2 hxy \x3d vec2(0.0, 1.0);\nvec2 ixy \x3d vec2(1.0, 1.0);\nif (v_texCoord.s \x3c u_resolution.s) {\naxy[0] \x3d 1.0;\ndxy[0] \x3d 1.0;\ngxy[0] \x3d 1.0;\n}\nif (v_texCoord.t \x3c u_resolution.t) {\naxy[1] \x3d 1.0;\nbxy[1] \x3d 1.0;\ncxy[1] \x3d 1.0;\n}\nif (v_texCoord.s \x3e 1.0 - u_resolution.s) {\ncxy[0] \x3d -1.0;\nfxy[0] \x3d -1.0;\nixy[0] \x3d -1.0;\n}\nif (v_texCoord.t \x3e 1.0 - u_resolution.t) {\ngxy[1] \x3d -1.0;\nhxy[1] \x3d -1.0;\nixy[1] \x3d -1.0;\n}\nva \x3d texture2D(u_image, v_texCoord + u_resolution * axy);\nvb \x3d texture2D(u_image, v_texCoord + u_resolution * bxy);\nvc \x3d texture2D(u_image, v_texCoord + u_resolution * cxy);\nvd \x3d texture2D(u_image, v_texCoord + u_resolution * dxy);\nve \x3d texture2D(u_image, v_texCoord + u_resolution * vec2(0, 0));\nvf \x3d texture2D(u_image, v_texCoord + u_resolution * fxy);\nvg \x3d texture2D(u_image, v_texCoord + u_resolution * gxy);\nvh \x3d texture2D(u_image, v_texCoord + u_resolution * hxy);\nvi \x3d texture2D(u_image, v_texCoord + u_resolution * ixy);\nfloat alpha \x3d getNeighborHoodAlpha(va.a, vb.a, vc.a, vd.a, ve.a, vf.a, vg.a, vh.a, vi.a);\nfloat dzx \x3d (vc + 2.0 * vf + vi - va - 2.0 * vd - vg).r * u_xFactor;\nfloat dzy \x3d (vg + 2.0 * vh + vi - va - 2.0 * vb - vc).r * u_yFactor; //flip\nfloat s2 \x3d sqrt(1.0 + dzx * dzx + dzy * dzy);\nfloat hillshade \x3d 0.0;\nif (u_hillshadeType \x3d\x3d 0){\nfloat cosDelta \x3d u_sinZsinA * dzy - u_sinZcosA * dzx;\nfloat z \x3d (u_cosZ + cosDelta) / s2;\nif (z \x3c 0.0)  z \x3d 0.0;\nhillshade \x3d z;\n}\nelse if (u_hillshadeType \x3d\x3d 1){\nfor (int k \x3d 0; k \x3c 6; k++) {\nfloat cosDelta \x3d u_sinZsinAs[k] * dzy - u_sinZcosAs[k] * dzx;\nfloat z \x3d (u_cosZs[k] + cosDelta) / s2;\nif (z \x3c 0.0) z \x3d 0.0;\nhillshade \x3d hillshade + z * u_weights[k];\nif (k \x3d\x3d u_lightSourceCount-1) break;\n}\n}\nif (u_applyColorramp) {\nvec4 result \x3d overlay(ve.r, u_minValue, u_maxValue, hillshade, alpha);\nif (u_scaled) {\nresult \x3d vec4(result.rgb * 255.0, result.a);\n}\ngl_FragColor \x3d result;\n} else {\nif (u_scaled) {\nhillshade \x3d hillshade * 255.0;\nif (hillshade\x3e 255.0) {\nhillshade \x3d 255.0;\n}\n}\ngl_FragColor \x3d vec4(hillshade, hillshade, hillshade, alpha);\n}\n}",
identity:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform int u_bandCount;\nfloat shift_right(float v, float amt) {\nv \x3d floor(v) + 0.5;\nreturn floor(v / exp2(amt));\n}\nfloat shift_left(float v, float amt) {\nreturn floor(v * exp2(amt) + 0.5);\n}\nfloat mask_last(float v, float bits) {\nreturn mod(v, shift_left(1.0, bits));\n}\nfloat extract_bits(float num, float from, float to) {\nfrom \x3d floor(from + 0.5);\nto \x3d floor(to + 0.5);\nreturn mask_last(shift_right(num, from), to - from);\n}\nvec4 encode_float(float val) {\nif (val \x3d\x3d 0.0)\nreturn vec4(0, 0, 0, 0);\nfloat sign \x3d val \x3e 0.0 ? 0.0 : 1.0;\nval \x3d abs(val);\nfloat exponent \x3d floor(log2(val));\nfloat biased_exponent \x3d exponent + 127.0;\nfloat fraction \x3d ((val / exp2(exponent)) - 1.0) * 8388608.0;\nfloat t \x3d biased_exponent / 2.0;\nfloat last_bit_of_biased_exponent \x3d fract(t) * 2.0;\nfloat remaining_bits_of_biased_exponent \x3d floor(t);\nfloat byte4 \x3d extract_bits(fraction, 0.0, 8.0) / 255.0;\nfloat byte3 \x3d extract_bits(fraction, 8.0, 16.0) / 255.0;\nfloat byte2 \x3d (last_bit_of_biased_exponent * 128.0 + extract_bits(fraction, 16.0, 23.0)) / 255.0;\nfloat byte1 \x3d (sign * 128.0 + remaining_bits_of_biased_exponent) / 255.0;\nreturn vec4(byte4, byte3, byte2, byte1);\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\nvec4 currentPixel \x3d  texture2D(u_image, v_texCoord);\ngl_FragColor \x3d vec4( currentPixel.rgb, currentPixel.a); //encode_float(currentPixel.r);\n}",
local:"precision mediump float;\nuniform sampler2D u_image;\nuniform sampler2D u_image1;\nuniform sampler2D u_image2;\nvarying vec2 v_texCoord;\nuniform int u_rasterCount;\nvec4 polyfill;\nvec4 localOp1() {\nvec4 a \x3d texture2D(u_image, v_texCoord);\nvec4 result;\nvec4 replaceme1;\nreturn result;\n}\nvec4 localOp2() {\nvec4 a \x3d texture2D(u_image, v_texCoord);\nvec4 b \x3d texture2D(u_image1, v_texCoord);\nvec4 result;\nvec4 replaceme2;\nreturn result;\n}\nvec4 localOp3() {\nvec4 a \x3d texture2D(u_image, v_texCoord);\nvec4 b \x3d texture2D(u_image1, v_texCoord);\nvec4 c \x3d texture2D(u_image2, v_texCoord);\nvec4 result;\nvec4 replaceme3;\nreturn result;\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d localOp1();\n}",
local0:"precision mediump float;\nuniform sampler2D u_image0;\nuniform sampler2D u_image1;\nvarying vec2 v_texCoord;\nuniform float u_minCutOff[3];\nuniform float u_maxCutOff[3];\nuniform float u_minOutput[3];\nuniform float u_maxOutput[3];\nuniform float u_factor[3];\nuniform int u_operation;\nuniform int u_constant[3];\nuniform vec4 gamma;\nfloat localOperate1(float a, float b, float c){\nfloat result;\nif (u_operation \x3d\x3d 1){\nresult \x3d a + b;\n}\nelse if (u_operation \x3d\x3d 2){\nresult \x3d a - b;\n}\nelse if (u_operation \x3d\x3d3){\nresult \x3d a * b;\n}\nelse if (u_operation \x3d\x3d4){\nresult \x3d sqrt(a);\n}\nelse if (u_operation \x3d\x3d5){\nresult \x3d pow(a, b);\n}\nelse if (u_operation \x3d\x3d6){\nresult \x3d acos(a);\n}\nelse if (u_operation \x3d\x3d7){\nresult \x3d asin(a);\n}\nelse if (u_operation \x3d\x3d8){\nresult \x3d atan(a);\n}\nelse if (u_operation \x3d\x3d9){\nresult \x3d 999.0; //atanh not available\n}\nelse if (u_operation \x3d\x3d10){\nresult \x3d abs(a);\n}\nelse if (u_operation \x3d\x3d13){\nresult \x3d 999.0; //bitwise not available\n}\nelse if (u_operation \x3d\x3d17){\nresult \x3d a !\x3d 0.0 \x26\x26 b !\x3d0.0;\n}\nelse if (u_operation \x3d\x3d18){\nresult \x3d a \x3d\x3d0.0? 1.0:0.0;\n}\nelse if (u_operation \x3d\x3d19){\nresult \x3d a !\x3d 0.0 || b !\x3d0.0;\n}\nelse if (u_operation \x3d\x3d20){\nresult \x3d a !\x3d 0.0 ^^ b !\x3d0.0; //exclusive or\n}\nelse if (u_operation \x3d\x3d21){\nresult \x3d cos(a);\n}\nelse if (u_operation \x3d\x3d23){\nresult \x3d a / b;\n}\nelse if (u_operation \x3d\x3d24){\nresult \x3d a \x3d\x3d b ? 1.0:0.0;\n}\nelse if (u_operation \x3d\x3d25){\nresult \x3d exp(a);\n}\nelse if (u_operation \x3d\x3d26){\nresult \x3d pow(10.0, a);\n}\nelse if (u_operation \x3d\x3d27){\nresult \x3d exp2(a);\n}\nelse if (u_operation \x3d\x3d28){\nresult \x3d a \x3e b? 1.0 : 0.0;\n}\nelse if (u_operation \x3d\x3d29){\nresult \x3d  a \x3e\x3d b? 1.0 : 0.0;\n}\nelse if (u_operation \x3d\x3d30){\nresult \x3d floor(a); //int\n}\nelse if (u_operation \x3d\x3d31){\nresult \x3d a \x3d\x3d0? 1.0:0.0; //null pass mask\n}\nelse if (u_operation \x3d\x3d32){\nresult \x3d a; //float\n}\nelse if (u_operation \x3d\x3d33){\nresult \x3d a \x3c b? 1.0 : 0.0;\n}\nelse if (u_operation \x3d\x3d34){\nresult \x3d a \x3c\x3d b? 1.0 : 0.0;\n}\nelse if (u_operation \x3d\x3d35){\nresult \x3d log(a);\n}\nelse if (u_operation \x3d\x3d36){\nresult \x3d log2(a) / log2(10.0);\n}\nelse if (u_operation \x3d\x3d37){\nresult \x3d log2(a);\n}\nelse if (u_operation \x3d\x3d44){\nresult \x3d mod(a, b);\n}\nelse if (u_operation \x3d\x3d45){\nresult \x3d -a;\n}\nelse if (u_operation \x3d\x3d46){\nresult \x3d a !\x3d b? 1.0 : 0.0;\n}\nelse if (u_operation \x3d\x3d48){\nresult \x3d ceil(a);\n}\nelse if (u_operation \x3d\x3d49){\nresult \x3d floor(a);\n}\nelse if (u_operation \x3d\x3d51){\nresult \x3d sin(a);\n}\nelse if (u_operation \x3d\x3d53){\nresult \x3d a * a;\n}\nelse if (u_operation \x3d\x3d56){\nresult \x3d tan(a);\n}\nelse if (u_operation \x3d\x3d57){\nresult \x3d 999.0; //tanh not available\n}\nelse if (u_operation \x3d\x3d59){\nresult \x3d 999.0; //acosh not available\n}\nelse if (u_operation \x3d\x3d60){\nresult \x3d 999.0; //asinh not available\n}\nelse if (u_operation \x3d\x3d61){\nresult \x3d atan(a, b);\n}\nelse if (u_operation \x3d\x3d64){\nresult \x3d a / b;\n}\nelse if (u_operation \x3d\x3d65){\nresult \x3d floor(a/b);\n}\nelse if (u_operation \x3d\x3d76){\nresult \x3d a !\x3d0? b:c;\n}\n}\nvoid main() {\nvec4 currentPixel0 \x3d  texture2D(u_image0, v_texCoord);\nfloat graya, reda, greena, bluea;\nif (u_bandCount \x3d\x3d 1) {\ngraya \x3d stretchOneaue(float(currentPixel.r), u_minCutOff[0], u_maxCutOff[0], u_minOutput[0], u_maxOutput[0], u_factor[0]);\ngl_FragColor \x3d vec4(graya, graya, graya, currentPixel.a);\n}\nelse if (u_bandCount \x3d\x3d 3) {\nreda \x3d stretchOneaue(float(currentPixel.r), u_minCutOff[0], u_maxCutOff[0], u_minOutput[0], u_maxOutput[0], u_factor[0]);\ngreena \x3d stretchOneaue(float(currentPixel.g), u_minCutOff[1], u_maxCutOff[1], u_minOutput[1], u_maxOutput[1], u_factor[1]);\nbluea \x3d stretchOneaue(float(currentPixel.b), u_minCutOff[2], u_maxCutOff[2], u_minOutput[2], u_maxOutput[2], u_factor[2]);\ngl_FragColor \x3d vec4(reda, greena, bluea, currentPixel.a);\n}\n}",
mask:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform float u_includedRanges[6];\nuniform bool u_includedRanges_specified;\nuniform float u_noDataValues[6];\nuniform bool u_noDataValues_specified;\nuniform int u_noDataInterpretation;\nuniform int u_bandCount;\nvec4 mask() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nvec4 processedPixel \x3d currentPixel;\nif (u_includedRanges_specified) {\nif (u_bandCount \x3d\x3d 1) {\nif (currentPixel.r \x3e u_includedRanges[0] \x26\x26 currentPixel.r \x3c u_includedRanges[1])\nprocessedPixel \x3d vec4(currentPixel.rgb, currentPixel.a);\nelse\nprocessedPixel \x3d vec4(currentPixel.rgb, 0);\n} else if (u_bandCount \x3d\x3d 3) {\nif (currentPixel.r \x3e u_includedRanges[0] \x26\x26 currentPixel.r \x3c u_includedRanges[1] \x26\x26 currentPixel.g \x3e u_includedRanges[2] \x26\x26 currentPixel.g \x3c u_includedRanges[3] \x26\x26 currentPixel.b \x3e u_includedRanges[4] \x26\x26 currentPixel.b \x3c u_includedRanges[5])\nprocessedPixel \x3d vec4(currentPixel.rgb, currentPixel.a);\nelse\nprocessedPixel \x3d vec4(currentPixel.rgb, 0);\n}\n}\nif (u_noDataValues_specified) {\nif (u_bandCount \x3d\x3d 1) {\nif (processedPixel.r \x3d\x3d u_noDataValues[0])\nprocessedPixel \x3d vec4(processedPixel.rgb, 0);\nelse\nprocessedPixel \x3d vec4(processedPixel.rgb, processedPixel.a);\n} else if (u_bandCount \x3d\x3d 3) {\nif (u_noDataInterpretation \x3d\x3d1 \x26\x26 processedPixel.r \x3d\x3d u_noDataValues[0] \x26\x26 processedPixel.g \x3d\x3d u_noDataValues[1] \x26\x26 processedPixel.b \x3d\x3d u_noDataValues[2])\nprocessedPixel \x3d vec4(processedPixel.rgb, 0);\nelse if (processedPixel.r \x3d\x3d u_noDataValues[0] || processedPixel.g \x3d\x3d u_noDataValues[1] || processedPixel.b \x3d\x3d u_noDataValues[2])\nprocessedPixel \x3d vec4(processedPixel.rgb, 0);\nelse\nprocessedPixel \x3d vec4(processedPixel.rgb, processedPixel.a);\n}\n}\nreturn processedPixel;\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d mask();\n}",
ndvi:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform int u_bandId_red;\nuniform int u_bandId_nir;\nuniform bool u_scaled;\nuniform int u_bandCount;\nvec4 calculateNDVI(){\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat red \x3d float(u_bandId_red \x3d\x3d 0 ? currentPixel.r : (u_bandId_red \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat nir \x3d float(u_bandId_nir \x3d\x3d 0 ? currentPixel.r : (u_bandId_nir \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat ndvi_denom \x3d nir + red;\nfloat ndvi;\nif (ndvi_denom \x3d\x3d 0.0) {\nndvi \x3d 0.0;\n}\nelse {\nndvi \x3d (nir - red) / ndvi_denom;\nif (u_scaled) {\nndvi \x3d float(floor(ndvi * 100.0 + 100.5));\n}\n}\nreturn vec4(ndvi, ndvi, ndvi, currentPixel.a);\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d calculateNDVI();\n}",
remap:"precision mediump float;\nuniform sampler2D u_image;\nuniform sampler2D u_image1;\nvarying vec2 v_texCoord;\nuniform float u_indexedColormapOffset;\nuniform float u_indexedColormapMaxIndex;\nuniform float u_breaks[16];\nuniform vec2 u_rawResolution;\nuniform int u_resampling;\nvec4 getPixelValue(vec2 coords) {\nif (u_resampling \x3d\x3d 0) {\nreturn texture2D(u_image, coords);\n}\nvec2 pos_ul \x3d floor(coords / u_rawResolution) * u_rawResolution;\nvec2 pos_ur \x3d pos_ul + vec2(1.0, 0.0) * u_rawResolution;\nvec2 pos_ll \x3d pos_ul + vec2(0.0, 1.0) * u_rawResolution;\nvec2 pos_lr \x3d pos_ul + vec2(1.0, 1.0) * u_rawResolution;\nvec2 weight \x3d fract(coords / u_rawResolution);\nvec4 vp_ul \x3d texture2D(u_image, pos_ul);\nvec4 vp_ur \x3d texture2D(u_image, pos_ur);\nvec4 vp_ll \x3d texture2D(u_image, pos_ll);\nvec4 vp_lr \x3d texture2D(u_image, pos_lr);\nvec4 vp \x3d mix(mix(vp_ul, vp_ur, weight.x), mix(vp_ll, vp_lr, weight.x), weight.y);\nreturn vp;\n}\nfloat getRemapIndex(float pixelValue) {\nif (pixelValue \x3c u_breaks[0] || pixelValue \x3e u_breaks[15]) {\nreturn -1.0;\n}\nfor (int i \x3d 0; i \x3c 16; i++) {\nif (pixelValue \x3c u_breaks[i]) {\nreturn float(i - 1);\n}\n}\nif (pixelValue \x3d\x3d u_breaks[15]) {\nreturn 15.0;\n}\nreturn 0.0;\n}\nvec4 colorize(float pv) {\nfloat clrIndex \x3d pv - u_indexedColormapOffset;\nvec4 result;\nif (clrIndex \x3e u_indexedColormapMaxIndex) {\nresult \x3d vec4(0.0, 0.0, 0.0, 0.0);\n}\nelse {\nvec2 clrPosition \x3d vec2(clrIndex / u_indexedColormapMaxIndex, 0.0);\nvec4 color \x3d texture2D(u_image1, clrPosition);\nresult \x3d vec4(color.r, color.g, color.b, color.a);\n}\nreturn result;\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nif (currentPixel.a \x3d\x3d 0.0) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn;\n}\nfloat remappedIndex \x3d getRemapIndex(currentPixel.r);\nif (remappedIndex \x3c 0.0) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn;\n}\ngl_FragColor \x3d colorize(remappedIndex);\n}",
resample:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform vec2 u_resamplingRatio;\nuniform int u_resamplingType;\nuniform vec2 u_anchor;\nuniform vec2 u_resolution;\nvec4 resample(){\nvec2 pos_nn, pos_ul, pos_ur, pos_ll, pos_lr, pos_offset;\nfloat weight,weight_total, weight_ul, weight_ur, weight_ll, weight_lr;\nvec4 vp;  //v_texCoord is canvas space 0-1\nvec2 originalResolution \x3d vec2(u_resolution.s*u_resamplingRatio.s, u_resolution.t*u_resamplingRatio.t);\nvec2 pos \x3d vec2(u_anchor.s+(v_texCoord.s-u_anchor.s),(u_anchor.t+(v_texCoord.t-u_anchor.t)));\nif (u_resamplingType \x3d\x3d 0)\n{//shift and scaling, y \x3d ax+b so x \x3d (y-b)/a\npos_nn \x3d vec2(floor(pos.s/originalResolution.s+0.5)*originalResolution.s,floor(pos.t/originalResolution.t+0.5)*originalResolution.t);\nif (pos_nn.s \x3c0.0 || pos_nn.s \x3e 1.0 || pos_nn.t \x3c0.0 || pos_nn.t \x3e 1.0){\nvp \x3d vec4(1.0, 0.0, 0.0, 1.0);//vec4(0.0, 1.0, 0.0, vp.a);\n}\nelse {\nvp \x3d texture2D(u_image, vec2(pos_nn.s, pos_nn.t));\n}\n}\nelse if (u_resamplingType \x3d\x3d 1)\n{//shift and scaling, 4 neighbors y \x3d ax+b so x \x3d (y-b)/a\npos_ul \x3d vec2(floor(pos.s/originalResolution.s)*originalResolution.s,floor(pos.t/originalResolution.t)*originalResolution.t);\npos_ur \x3d vec2(pos_ul.s+originalResolution.s, pos_ul.t);\npos_ll \x3d vec2(pos_ul.s, pos_ul.t+originalResolution.t);\npos_lr \x3d vec2(pos_ul.s+originalResolution.s, pos_ul.t+originalResolution.t);\npos_offset \x3d vec2(pos.s - floor(pos_ul.s),pos.t - floor(pos_ul.t));\nweight_lr \x3d sqrt(pow(pos_offset.s,2.0) + pow(pos_offset.t,2.0));\nweight_ul \x3d sqrt(pow( originalResolution.s- pos_offset.s,2.0)+ pow(originalResolution.t- pos_offset.t,2.0));\nweight_ur \x3d sqrt(pow( pos_offset.s,2.0)+ 1.0- pow(originalResolution.t - pos_offset.t,2.0));\nweight_ll \x3d sqrt(pow( originalResolution.s- pos_offset.s,2.0)+ pow(pos_offset.t,2.0));\nvp \x3d (texture2D(u_image, pos_ul) * weight_ul + texture2D(u_image, pos_ur) * weight_ur + texture2D(u_image, pos_ll) * weight_ll + texture2D(u_image, pos_lr) * weight_lr)/(weight_ul+weight_ur+weight_ll+weight_lr);\n}\nelse if (u_resamplingType \x3d\x3d 2)\n{//shift and scaling, 16 neighbors\nweight_total \x3d 0.0;\nvp \x3d vec4(0.0,0.0,0.0,0.0);\npos_ul \x3d vec2(floor(pos.s/originalResolution.s)*originalResolution.s-originalResolution.s,floor(pos.t/originalResolution.t)*originalResolution.t-originalResolution.t);\npos_offset \x3d vec2(pos.s - floor(pos_ul.s),pos.t - floor(pos_ul.t));\nfor (int i\x3d0; i\x3c4; i++){//row\nfor (int j\x3d0; j\x3c4; j++){//col\nweight \x3d sqrt(pow(pos_offset.s-float(j),2.0)+ pow(pos_offset.t-float(i),2.0));\nvp +\x3dtexture2D(u_image, vec2(pos_ul.s+float(i)*originalResolution.s,pos_ul.t+float(j)*originalResolution.t)) * weight;\nweight_total +\x3d weight;\n}\n}\nvp \x3d vp/weight_total;\n}\nreturn vp;\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d resample();\n}",
slope:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform vec2 u_resolution;\nuniform vec2 u_cellSize;\nuniform float u_zfactor;\nuniform float u_altitude;\nuniform float u_azimuth;\nfloat shift_right(float v, float amt) {\nv \x3d floor(v) + 0.5;\nreturn floor(v / exp2(amt));\n}\nfloat shift_left(float v, float amt) {\nreturn floor(v * exp2(amt) + 0.5);\n}\nfloat mask_last(float v, float bits) {\nreturn mod(v, shift_left(1.0, bits));\n}\nfloat extract_bits(float num, float from, float to) {\nfrom \x3d floor(from + 0.5);\nto \x3d floor(to + 0.5);\nreturn mask_last(shift_right(num, from), to - from);\n}\nvec4 encode_float(float val) {\nif (val \x3d\x3d 0.0)\nreturn vec4(0, 0, 0, 0);\nfloat sign \x3d val \x3e 0.0 ? 0.0 : 1.0;\nval \x3d abs(val);\nfloat exponent \x3d floor(log2(val));\nfloat biased_exponent \x3d exponent + 127.0;\nfloat fraction \x3d ((val / exp2(exponent)) - 1.0) * 8388608.0;\nfloat t \x3d biased_exponent / 2.0;\nfloat last_bit_of_biased_exponent \x3d fract(t) * 2.0;\nfloat remaining_bits_of_biased_exponent \x3d floor(t);\nfloat byte4 \x3d extract_bits(fraction, 0.0, 8.0) / 255.0;\nfloat byte3 \x3d extract_bits(fraction, 8.0, 16.0) / 255.0;\nfloat byte2 \x3d (last_bit_of_biased_exponent * 128.0 + extract_bits(fraction, 16.0, 23.0)) / 255.0;\nfloat byte1 \x3d (sign * 128.0 + remaining_bits_of_biased_exponent) / 255.0;\nreturn vec4(byte4, byte3, byte2, byte1);\n}\nfloat getNeighborHoodAlpha(float a, float b, float c, float d, float e, float f, float g, float h, float i){\nif (a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0 || a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0 || a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0) {\nreturn 0.0;\n}\nelse {\nreturn e;\n}\n}\nvec4 calculateSlope() {\nfloat pi \x3d 3.141592653589793238;\nfloat dzx \x3d 0.0;\nfloat dzy \x3d 0.0;\nvec4 va,  vb,  vc,  vd,  ve,  vf,  vg,  vh,  vi;\nvec2 axy \x3d vec2(-1.0, -1.0);\nvec2 bxy \x3d vec2(0.0, -1.0);\nvec2 cxy \x3d vec2(1.0, -1.0);\nvec2 dxy \x3d vec2(-1.0, 0.0);\nvec2 fxy \x3d vec2(1.0, 0.0);\nvec2 gxy \x3d vec2(-1.0, 1.0);\nvec2 hxy \x3d vec2(0.0, 1.0);\nvec2 ixy \x3d vec2(1.0, 1.0);\nif (v_texCoord.s \x3c u_resolution.s) {\naxy[0] \x3d 1.0;\ndxy[0] \x3d 1.0;\ngxy[0] \x3d 1.0;\n}\nif (v_texCoord.t \x3c u_resolution.t) {\naxy[1] \x3d 1.0;\nbxy[1] \x3d 1.0;\ncxy[1] \x3d 1.0;\n}\nif (v_texCoord.s \x3e 1.0 - u_resolution.s) {\ncxy[0] \x3d -1.0;\nfxy[0] \x3d -1.0;\nixy[0] \x3d -1.0;\n}\nif (v_texCoord.t \x3e 1.0 - u_resolution.t) {\ngxy[1] \x3d -1.0;\nhxy[1] \x3d -1.0;\nixy[1] \x3d -1.0;\n}\nif (v_texCoord.s \x3e\x3d u_resolution.s \x26\x26 (1.0 - u_resolution.s) \x3e\x3d v_texCoord.s \x26\x26 v_texCoord.t \x3e\x3d u_resolution.t \x26\x26 (1.0 - u_resolution.t) \x3e\x3d v_texCoord.t) {\nva \x3d texture2D(u_image, v_texCoord + u_resolution * axy);\nvb \x3d texture2D(u_image, v_texCoord + u_resolution * bxy);\nvc \x3d texture2D(u_image, v_texCoord + u_resolution * cxy);\nvd \x3d texture2D(u_image, v_texCoord + u_resolution * dxy);\nve \x3d texture2D(u_image, v_texCoord + u_resolution * vec2(0, 0));\nvf \x3d texture2D(u_image, v_texCoord + u_resolution * fxy);\nvg \x3d texture2D(u_image, v_texCoord + u_resolution * gxy);\nvh \x3d texture2D(u_image, v_texCoord + u_resolution * hxy);\nvi \x3d texture2D(u_image, v_texCoord + u_resolution * ixy);\n}\ndzx \x3d (vc + 2.0 * vf + vi - va - 2.0 * vd - vg).r / (8.0 * u_cellSize[0]);\ndzy \x3d -(vg + 2.0 * vh + vi - va - 2.0 * vb - vc).r / (8.0 * u_cellSize[1]);\nfloat alpha \x3d getNeighborHoodAlpha(va.a, vb.a, vc.a, vd.a, ve.a, vf.a, vg.a, vh.a, vi.a);\nfloat slope \x3d atan(u_zfactor * sqrt(dzx * dzx + dzy * dzy)) * 57.2957795;\nreturn vec4(slope, slope, slope, alpha);\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d calculateSlope();\n}",
stretch:"precision mediump float;\nuniform sampler2D u_image;\nuniform sampler2D u_image1;\nuniform sampler2D u_image2;\nvarying vec2 v_texCoord;\nuniform float u_minCutOff[3];\nuniform float u_maxCutOff[3];\nuniform float u_minOutput[3];\nuniform float u_maxOutput[3];\nuniform float u_factor[3];\nuniform int u_bandCount;\nuniform vec2 u_sourceDim;\nuniform vec2 u_targetDim;\nuniform int u_state;\nuniform bool u_minMaxTexture;\nuniform bool u_useGamma;\nuniform float u_gamma[4];\nuniform float u_gammaCorrection[4];\nuniform bool u_scaled;\nuniform vec2 u_rawResolution;\nuniform int u_resampling;\nvec4 getPixelValue(vec2 coords) {\nif (u_resampling \x3d\x3d 0) {\nreturn texture2D(u_image, coords);\n}\nvec2 pos_ul \x3d floor(coords / u_rawResolution) * u_rawResolution;\nvec2 pos_ur \x3d pos_ul + vec2(1.0, 0.0) * u_rawResolution;\nvec2 pos_ll \x3d pos_ul + vec2(0.0, 1.0) * u_rawResolution;\nvec2 pos_lr \x3d pos_ul + vec2(1.0, 1.0) * u_rawResolution;\nvec2 weight \x3d fract(coords / u_rawResolution);\nvec4 vp_ul \x3d texture2D(u_image, pos_ul);\nvec4 vp_ur \x3d texture2D(u_image, pos_ur);\nvec4 vp_ll \x3d texture2D(u_image, pos_ll);\nvec4 vp_lr \x3d texture2D(u_image, pos_lr);\nvec4 vp \x3d mix(mix(vp_ul, vp_ur, weight.x), mix(vp_ll, vp_lr, weight.x), weight.y);\nif (u_bandCount \x3d\x3d 1) {\nfloat alpha \x3d vp_ul.a * vp_ur.a * vp_ll.a * vp_lr.a;\nvec4 vp_nn \x3d texture2D(u_image, coords);\nreturn alpha \x3d\x3d 0.0 ? vp_nn : vec4(vp.rgb, alpha);\n}\nreturn vp;\n}\nvec4 findMin(vec4 p1, vec4 p2) {\nif (p1.a \x3d\x3d 0.0) {\nreturn p2;\n} else if (p2.a \x3d\x3d 0.0) {\nreturn p1;\n} else {\nreturn vec4(min(p1.r, p2.r),min(p1.g, p2.g),min(p1.b, p2.b),p1.a);\n}\n}\nvec4 findMax(vec4 p1, vec4 p2) {\nif (p1.a \x3d\x3d 0.0) {\nreturn p2;\n} else if (p2.a \x3d\x3d 0.0) {\nreturn p1;\n} else {\nreturn vec4(max(p1.r, p2.r),max(p1.g, p2.g),max(p1.b, p2.b),p1.a);\n}\n}\nvec4 findMinMax(vec4 p1, vec4 p2) {\nif (p1.a \x3d\x3d 0.0) {\nreturn p2;\n} else if (p2.a \x3d\x3d 0.0) {\nreturn p1;\n} else {\nreturn vec4(min(p1.r, p2.r), max(p1.g, p2.g), 0.0, p1.a);\n}\n}\nvec4 minMax(int state) {\nvec2 pixelFract \x3d fract(v_texCoord * u_sourceDim);\nfloat xshift \x3d ((pixelFract.s \x3e\x3d 0.5 || pixelFract.s \x3d\x3d 0.0) ? -1.0 : 1.0) / u_sourceDim.s; //take left pixel if \x3e 0.5\nfloat yshift \x3d ((pixelFract.s \x3e\x3d 0.5 || pixelFract.s \x3d\x3d 0.0) ? -1.0 : 1.0) / u_sourceDim.t; //take bottom pixel if \x3e 0.5\nif (u_sourceDim.s \x3d\x3d 1.0) {\nxshift \x3d 0.0;\n}\nif (u_sourceDim.t \x3d\x3d 1.0) {\nyshift \x3d 0.0;\n}\nvec4 p1 \x3d texture2D(u_image, v_texCoord);\nvec4 p2 \x3d texture2D(u_image, v_texCoord + vec2(xshift, 0.0));\nvec4 p3 \x3d texture2D(u_image, v_texCoord + vec2(0.0, yshift));\nvec4 p4 \x3d texture2D(u_image, v_texCoord + vec2(xshift, yshift));\nvec4 pval;\nif (state \x3d\x3d 2) {\npval \x3d findMinMax(findMinMax(p1, p2), findMinMax(p3, p4));\n} else if (state \x3d\x3d 1) {\npval \x3d findMax(findMax(p1, p2), findMax(p3, p4));\n} else if (state \x3d\x3d 0) {\npval \x3d findMin(findMin(p1, p2), findMin(p3, p4));\n}\nreturn pval;\n}\nfloat stretchOneValue(float val, float minCutOff, float maxCutOff, float minOutput, float maxOutput, float factor, bool scaled) {\nfloat stretchedVal;\nif (val \x3e minCutOff \x26\x26 val \x3c maxCutOff) {\nstretchedVal \x3d minOutput + (val - minCutOff) * factor;\n} else if (val \x3e\x3d maxCutOff) {\nstretchedVal \x3d maxOutput;\n} else {\nstretchedVal \x3d minOutput;\n}\nif (scaled) {\nreturn stretchedVal;\n}\nelse {\nreturn stretchedVal / maxOutput; //0-1\n}\n}\nfloat stretchOneValueGamma(float val, float minCutOff, float maxCutOff, float minOutput, float maxOutput, float factor, float gamma, float gammaCorrection, bool scaled) {\nfloat stretchedVal;\nfloat tempf \x3d 1.0;\nfloat outRange \x3d maxOutput - minOutput;\nfloat relativeVal \x3d (val - minCutOff) / (maxCutOff - minCutOff);\nif (val \x3e minCutOff \x26\x26 val \x3c maxCutOff) {\nif (gamma \x3e 1.0) {\ntempf -\x3d pow(1.0 / outRange, relativeVal * gammaCorrection);\n}\nstretchedVal \x3d floor(tempf * outRange * pow(relativeVal, 1.0 / gamma)) + minOutput;\n}\nelse if (val \x3e\x3d maxCutOff) {\nstretchedVal \x3d maxOutput;\n} else {\nstretchedVal \x3d minOutput;\n}\nif (scaled) {\nreturn stretchedVal;\n}\nelse {\nreturn stretchedVal / maxOutput; //0-1\n}\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\nif (u_state \x3d\x3d 100) {\nvec4 currentPixel \x3d getPixelValue(v_texCoord);\nfloat grayVal,\nredVal,\ngreenVal,\nblueVal;\nfloat min0,\nmax0,\nmin1,\nmax1,\nmin2,\nmax2,\nfactor0,\nfactor1,\nfactor2;\nvec4 minV, maxV;\nif (u_minMaxTexture) {\nif (u_bandCount \x3d\x3d 1) {\nminV \x3d texture2D(u_image1, v_texCoord);\nmin0 \x3d minV.r;\nmax0 \x3d minV.g;\nfactor0 \x3d (u_maxOutput[0] - u_minOutput[0]) / (max0 - min0);\n} else {\nminV \x3d texture2D(u_image1, v_texCoord);\nmaxV \x3d texture2D(u_image2, v_texCoord);\nmin0 \x3d minV.r;\nmax0 \x3d maxV.r;\nmin1 \x3d minV.g;\nmax1 \x3d maxV.g;\nmin2 \x3d minV.b;\nmax2 \x3d maxV.b;\nfactor0 \x3d (u_maxOutput[0] - u_minOutput[0]) / (max0 - min0);\nfactor1 \x3d (u_maxOutput[1] - u_minOutput[1]) / (max1 - min1);\nfactor2 \x3d (u_maxOutput[2] - u_minOutput[2]) / (max2 - min2);\n}\n} else {\nmin0 \x3d u_minCutOff[0];\nmax0 \x3d u_maxCutOff[0];\nmin1 \x3d u_minCutOff[1];\nmax1 \x3d u_maxCutOff[1];\nmin2 \x3d u_minCutOff[2];\nmax2 \x3d u_maxCutOff[2];\nfactor0 \x3d u_factor[0];\nfactor1 \x3d u_factor[1];\nfactor2 \x3d u_factor[2];\n}\nif (u_useGamma){\nif (u_bandCount \x3d\x3d 1) {\ngrayVal \x3d stretchOneValueGamma(float(currentPixel.r), min0, max0, u_minOutput[0], u_maxOutput[0], factor0, u_gamma[0], u_gammaCorrection[0], u_scaled);\ngl_FragColor \x3d vec4(grayVal, grayVal, grayVal, currentPixel.a);\n} else {\nredVal \x3d stretchOneValueGamma(float(currentPixel.r), min0, max0, u_minOutput[0], u_maxOutput[0], factor0, u_gamma[0], u_gammaCorrection[0], u_scaled);\ngreenVal \x3d stretchOneValueGamma(float(currentPixel.g), min1, max1, u_minOutput[1], u_maxOutput[1], factor1, u_gamma[1], u_gammaCorrection[1], u_scaled);\nblueVal \x3d stretchOneValueGamma(float(currentPixel.b), min2, max2, u_minOutput[2], u_maxOutput[2], factor2, u_gamma[1], u_gammaCorrection[2], u_scaled);\ngl_FragColor \x3d vec4(redVal, greenVal, blueVal, currentPixel.a);\n}\n}\nelse {\nif (u_bandCount \x3d\x3d 1) {\ngrayVal \x3d stretchOneValue(float(currentPixel.r), min0, max0, u_minOutput[0], u_maxOutput[0], factor0, u_scaled);\ngl_FragColor \x3d vec4(grayVal, grayVal, grayVal, currentPixel.a);\n} else {\nredVal \x3d stretchOneValue(float(currentPixel.r), min0, max0, u_minOutput[0], u_maxOutput[0], factor0, u_scaled);\ngreenVal \x3d stretchOneValue(float(currentPixel.g), min1, max1, u_minOutput[1], u_maxOutput[1], factor1, u_scaled);\nblueVal \x3d stretchOneValue(float(currentPixel.b), min2, max2, u_minOutput[2], u_maxOutput[2], factor2, u_scaled);\ngl_FragColor \x3d vec4(redVal, greenVal, blueVal, currentPixel.a);\n}\n}\n} else {\nvec4 currentPixel \x3d minMax(u_state);\ngl_FragColor \x3d currentPixel;\n}\n}"}})},
"esri/layers/rasterLib/function/RasterFunctionWebGLMixin":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ./pixelShaders ./vertexShaders ./webglHelper ./convolutionKernel".split(" "),function(H,g,q,m,n,e,c){return H(null,{gl:null,rgbaFloatData:null,originalTexture:null,lastTexture:null,renderTexture:!1,constructor:function(a){this._isProgramInitialized=!1;this.gl=a&&a.gl;a&&a.renderTexture&&(this.renderTexture=a.renderTexture);this._xformSetting=a&&a._xformSetting||{requireProjection:!1,
meshSize:[20,20]}},bindFrameBuffer:function(){var a=this.gl;this._setupPingPongTextures();this._setupBranchingTextures();var b=this._glSetting;this.isBranch?(b.branchIndex=(b.branchIndex+1)%b.branchCount,b=b.branches[b.branchIndex]):(b.pingpongIndex=(b.pingpongIndex+1)%b.pingpong.length,b=b.pingpong[b.pingpongIndex]);a.bindFramebuffer(a.FRAMEBUFFER,b.frameBuffer);a.viewport(0,0,a.drawingBufferWidth,a.drawingBufferHeight);return b},_initializeProgram:function(a){if(this.gl)try{var b=this.gl;b.viewport(0,
0,b.drawingBufferWidth,b.drawingBufferHeight);var l=this._glSetting.programUniforms,h="local"===this.functionName?"local"+this.functionArguments.operation:this.functionName,d=l[h];if(d)this._uniforms=d.uniforms,this.rasterProgram=d.program;else{var f=(this._useMesh=this._tileMode&&this._xformSetting.requireProjection)?n.mesh:n.basic,k=n.getShader(b,a.vertex||f),p=m.getShader(b,a.fragment),v=this._loadProgram(k,p),t={rasterProgram:e.getUniforms(b,v)};l[h]={uniforms:t,program:v};this.rasterProgram=
v;this._uniforms=t}b.useProgram(this.rasterProgram);var r=b.getAttribLocation(this.rasterProgram,"a_texCoord"),w=b.createBuffer();b.bindBuffer(b.ARRAY_BUFFER,w);var u=e.createMesh(this._xformSetting.meshSize);b.bufferData(b.ARRAY_BUFFER,u,b.STATIC_DRAW);b.enableVertexAttribArray(r);b.vertexAttribPointer(r,2,b.FLOAT,!1,0,0);b.disable(b.DEPTH_TEST);b.blendFunc(b.SRC_ALPHA,b.ZERO);b.disable(b.BLEND);b.pixelStorei(b.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1);b.pixelStorei(b.UNPACK_FLIP_Y_WEBGL,!1);this._shaderInfo=
{fragment:a.fragmentName}}catch(y){console.error("webgl exception: "+y.message)}else console.error("WebGL is required.")},_setUniform:function(a,b,l){null!=b&&(l&&!this._uniforms[l]&&(this._uniforms[l]=e.getUniforms(this.gl,this[l])),l=l?this._uniforms[l]:this._uniforms.rasterProgram,(a=l[a]||l[a+"[0]"])&&e.setUniform(this.gl,a,b))},_setUniforms:function(a,b){var l=Object.keys(a),h,d=l.length;for(h=0;h<d;h++)this._setUniform(l[h],a[l[h]],b);this.rawInput?this._setUniform("u_flipY",!0,b):this._setUniform("u_flipY",
!1,b);this._tileMode?(this.rawInput?(a=this._xformSetting.offset,l=this._xformSetting.scale):(a=[0,0],l=[1,1]),this._setUniform("u_xformOffset",a,b),this._setUniform("u_xformScale",l,b),this._xformSetting.requireProjection&&(this.rawInput?(this._setupXformTexture(),this._setUniform("u_projection",!0,b),this._setUniform("u_transformGridSize",this._xformSetting.gridConfig.size,b),this._setUniform("u_transformSpacing",this._xformSetting.gridConfig.spacing,b),this._setUniform("u_targetImageSize",new Float32Array([this.gl.drawingBufferWidth,
this.gl.drawingBufferHeight]),b)):this._setUniform("u_projection",!1,b))):(a=[0,0],l=[1,1],this._setUniform("u_xformOffset",a,b),this._setUniform("u_xformScale",l,b));this.rawInput&&this._rawResolution&&("RSP_BilinearInterpolation"===this.interpolation||"RSP_CubicConvolution"===this.interpolation)?(this._setUniform("u_resampling",1),this._setUniform("u_rawResolution",this._rawResolution)):this._setUniform("u_resampling",0)},_setupTextureData:function(a,b){if(a.texture)return a;a.raster&&a.raster.pixelBlock&&
(a=a.raster);this.rawInput=!0;var l=b&&b.notOriginal,h=b&&b.bandIDs;b&&b.reCreate?b=!1:(b=this._tileMode?!this._xformSetting.hasNewTexture:!this._glSetting.hasNewTexture)&&this._originalBandIDs&&(b=h?this._originalBandIDs.join("")===h.join(""):!1);0<this._glSetting.branchCount&&(b=!1);if(b&&this.originalTexture)return{extent:a.extent,texture:this.originalTexture};b=this._createTexture();l||(this.originalTexture=b,this._originalBandIDs=h);l=this.gl;var d=a.pixelBlock;this._rawResolution=d?[1/a.pixelBlock.width,
1/a.pixelBlock.height]:[1/this.gl.drawingBufferWidth,1/this.gl.drawingBufferHeight];var f=0;h&&0<h.length&&d&&(f=Math.max.apply(null,h),d.pixels.length>f&&h&&(d.pixels=h.map(function(p){return d.pixels[p]}),d.statistics&&(d.statistics=h.map(function(p){return d.statistics[p]}))));h=d.width;f=d.height;l.getExtension("OES_texture_float");var k=d.getAsRGBAFloat();l.texImage2D(l.TEXTURE_2D,0,l.RGBA,h,f,0,l.RGBA,l.FLOAT,k);return{extent:a.extent,texture:b}},_setupPingPongTextures:function(){var a=this._glSetting;
if(!a||!a.pingpong){a.pingpong=[];var b=e.createBufferTexture(this.gl,!1);a.pingpong.push(b);b=e.createBufferTexture(this.gl,!1);a.pingpong.push(b);a.pingpongIndex=1}},_setupBranchingTextures:function(){var a=this._glSetting;if(!a||!a.branches){a.branches=[];var b=0,l=a.branchCount;if(0<l){for(b=0;b<l;b++){var h=e.createBufferTexture(this.gl,!1);a.branches.push(h)}a.branchIndex=l-1}}},_setupXformTexture:function(a){for(var b=this._createTexture(),l=this.gl,h=4*this._xformSetting.gridConfig.size[0],
d=this._xformSetting.gridConfig.size[1],f=new Float32Array(h*d*4),k=0,p=0;p<this._xformSetting.gridConfig.coefficients.length;p++)f[k++]=this._xformSetting.gridConfig.coefficients[p],2===p%3&&(f[k++]=1);l.getExtension("OES_texture_float");l.texImage2D(l.TEXTURE_2D,0,l.RGBA,h,d,0,l.RGBA,l.FLOAT,f);this._bindTexture(b,"u_transformGrid",a)},_createTexture:function(a){return e.createTexture(this.gl,a)},_bindTexture:function(a,b,l){b=b||"u_image";l=this._uniforms[l||"rasterProgram"];var h=this._getTextureIndex(b);
if(-1!==h){var d=this.gl;d.uniform1i(l[b].location,h);d.activeTexture(d.TEXTURE0+h);d.bindTexture(d.TEXTURE_2D,a)}},_getTextureIndex:function(a,b){b=this._uniforms[b||"rasterProgram"];if(!b||!b[a]||b[a].info.type!==this.gl.SAMPLER_2D)return-1;if("u_transformGrid"===a)return 0;a="u_image"===a?0:parseInt(a.replace("u_image",""));return this._xformSetting.requireProjection?a+1:a},_drawGL:function(a){var b=this.gl;this.renderTexture?(b.enable(b.BLEND),b.bindFramebuffer(b.FRAMEBUFFER,null)):b.disable(b.BLEND);
a||b.viewport(0,0,b.drawingBufferWidth,b.drawingBufferHeight);a=this._xformSetting.meshSize||[1,1];b.drawArrays(b.TRIANGLES,0,a[0]*a[1]*6);this._drawMesh()},_drawMesh:function(){if(this.renderTexture&&this._glSetting.drawMesh){this.meshProgram=this.meshProgram||this._setupMeshProgram();var a=this.gl;a.useProgram(this.meshProgram);a.bindFramebuffer(a.FRAMEBUFFER,null);var b=a.getAttribLocation(this.meshProgram,"a_texCoord"),l=a.createBuffer();a.bindBuffer(a.ARRAY_BUFFER,l);l=this._xformSetting.meshSize||
[1,1];var h=e.createMesh(l,!0);a.bufferData(a.ARRAY_BUFFER,h,a.STATIC_DRAW);a.enableVertexAttribArray(b);a.vertexAttribPointer(b,2,a.FLOAT,!1,0,0);a.disable(a.DEPTH_TEST);a.blendFunc(a.ONE,a.ZERO);this._setUniforms({u_color:[0,0,1,1],u_drawMeshLines:!0},"meshProgram");a.drawArrays(a.LINES,0,l[0]*l[1]*10)}},_setupMeshProgram:function(){var a=n.getShader(this.gl,n.mesh),b=m.getShader(this.gl,m.constant);return this._loadProgram(a,b)},_loadProgram:function(a,b){return e.loadProgram(this.gl,a,b)},_getShaderScript:function(a,
b){b=document.getElementById(b);if(!b)return null;a="";for(b=b.firstChild;b;)3==b.nodeType&&(a+=b.textContent),b=b.nextSibling;return a}})})},"esri/layers/rasterLib/function/vertexShaders":function(){define(["dojo/_base/declare","dojo/_base/lang","./vertexShaderScripts"],function(H,g,q){H={shaderType:"vertex",getShader:function(m,n){var e=m.createShader(m.VERTEX_SHADER);m.shaderSource(e,n);m.compileShader(e);m.getShaderParameter(e,m.COMPILE_STATUS)||(e=null);return e}};g.mixin(H,q);return H})},"esri/layers/rasterLib/function/vertexShaderScripts":function(){define([],
function(){return{basic:"varying vec2 v_texCoord;\nattribute vec2 a_texCoord;\nuniform vec2 u_xformOffset;\nuniform vec2 u_xformScale;\nuniform bool u_flipY;\nvoid main() {\nv_texCoord \x3d u_xformOffset + a_texCoord * u_xformScale;\nif (u_flipY) {\nv_texCoord.t \x3d 1.0 - v_texCoord.t;\n}\nvec2 position \x3d a_texCoord * 2.0 - 1.0;\ngl_Position \x3d vec4(position, 0.0, 1.0);\n}",histogram:"attribute float a_pixelIndex;\nuniform sampler2D u_image;\nuniform sampler2D u_image1;\nuniform sampler2D u_image2;\nuniform vec2 u_sourceDim;\nuniform vec2 u_halfPixel;\nuniform vec4 u_bandSelection;\nuniform vec4 u_mins;\nuniform vec4 u_factors;\nuniform float u_size;\nuniform int u_bandCount;\nuniform bool u_minMaxTexture;\nvoid main() {\nfloat row \x3d a_pixelIndex/u_sourceDim.s;\nvec2 coord \x3d vec2(fract(row), floor(row)/u_sourceDim.t);\nvec4 pv \x3d texture2D(u_image, coord + u_halfPixel);\nvec4 minVal, maxVal, pvm;\nif (u_minMaxTexture){\nif (u_bandCount \x3d\x3d1){ //min \x3d red, max \x3d green\nvec4 minmax \x3d texture2D(u_image1, vec2(0.5,0.5));\nminVal \x3d vec4(minmax.r, minmax.r, minmax.r, 0.0);\nmaxVal \x3d vec4(minmax.g, minmax.g, minmax.g, 0.0);\n}\nelse if (u_bandCount \x3d\x3d3){ //min \x3d red, max \x3d green\nminVal \x3d texture2D(u_image1, vec2(0.5,0.5));\nmaxVal \x3d texture2D(u_image2, vec2(0.5,0.5));\n}\nvec4 factors \x3d u_size/(maxVal-minVal+vec4(0.0,0.0,0.0,1.0)) * u_factors;\npvm \x3d (pv - minVal) * factors;\n}\nelse {\npvm \x3d (pv - u_mins) * u_factors;\n}\nfloat histVal \x3d min(floor(pvm.r+pvm.g+pvm.b), u_size-1.0);\nhistVal \x3d pv.a \x3d\x3d 1.0? histVal: u_size;\ngl_Position \x3d vec4((histVal+0.1) / (u_size+1.0) * 2.0 - 1.0, 0.5, 0, 1);\ngl_PointSize \x3d 1.0;\n}",
mesh:"varying vec2 v_texCoord;\nattribute vec2 a_texCoord;\nuniform bool u_drawMeshLines;\nuniform bool u_flipY;\nuniform vec2 u_xformOffset;\nuniform vec2 u_xformScale;\nuniform sampler2D u_transformGrid;\nuniform vec2 u_transformSpacing;\nuniform vec2 u_transformGridSize;\nuniform vec2 u_targetImageSize;\nuniform vec2 u_srcImageSize;\nuniform bool u_projection;\nvec2 projectPixelLocation(vec2 coords) {\nvec2 index_image \x3d floor(coords * u_targetImageSize);\nvec2 oneTransformPixel \x3d vec2(0.25 / u_transformGridSize.s, 1.0 / u_transformGridSize.t);\nvec2 index_transform \x3d floor(index_image / u_transformSpacing) / u_transformGridSize;\nvec2 pos \x3d fract((index_image + vec2(0.5, 0.5)) / u_transformSpacing);\nvec2 srcLocation;\nvec2 transform_location \x3d index_transform + oneTransformPixel * 0.5;\nif (pos.s \x3c\x3d pos.t) {\nvec4 ll_abc \x3d texture2D(u_transformGrid, vec2(transform_location.s, transform_location.t));\nvec4 ll_def \x3d texture2D(u_transformGrid, vec2(transform_location.s + oneTransformPixel.s, transform_location.t));\nsrcLocation.s \x3d dot(ll_abc.rgb, vec3(pos, 1.0));\nsrcLocation.t \x3d dot(ll_def.rgb, vec3(pos, 1.0));\n} else {\nvec4 ur_abc \x3d texture2D(u_transformGrid, vec2(transform_location.s + 2.0 * oneTransformPixel.s, transform_location.t));\nvec4 ur_def \x3d texture2D(u_transformGrid, vec2(transform_location.s + 3.0 * oneTransformPixel.s, transform_location.t));\nsrcLocation.s \x3d dot(ur_abc.rgb, vec3(pos, 1.0));\nsrcLocation.t \x3d dot(ur_def.rgb, vec3(pos, 1.0));\n}\nreturn srcLocation;// + halfPixel;\n}\nvoid main() {\nif (u_projection) {\nv_texCoord \x3d projectPixelLocation(a_texCoord);\n} else {\nv_texCoord \x3d u_xformOffset + a_texCoord * u_xformScale;\n}\nif (u_flipY) {\nv_texCoord.t \x3d 1.0 - v_texCoord.t;\n}\nvec2 position \x3d a_texCoord * 2.0 - 1.0;\nif (u_drawMeshLines){\nvec2 adjustedPos \x3d (v_texCoord - u_xformOffset) / u_xformScale;\ngl_Position \x3d vec4( adjustedPos * 2.0 - 1.0, 0.0, 1.0);\n}\nelse {\ngl_Position \x3d vec4(position, 0.0, 1.0);\n}\n}"}})},
"esri/layers/rasterLib/function/webglHelper":function(){define([],function(){var H={getUniforms:function(g,q){var m=g.getProgramParameter(q,g.ACTIVE_UNIFORMS),n,e,c={};for(n=0;n<m;n++)(e=g.getActiveUniform(q,n))&&(c[e.name]={location:g.getUniformLocation(q,e.name),info:e});return c},setUniform:function(g,q,m){var n=q.info,e=q.location,c=n.type;if(null==m)console.log("uniform "+q.info.name+" has null or undefined value");else switch(c){case g.FLOAT:1<n.size?0===m.length?console.log("uniform "+q.info.name+
" has length 0"):g.uniform1fv(e,m):g.uniform1f(e,m);break;case g.FLOAT_VEC2:if(0===m.length){console.log("uniform "+q.info.name+" has length 0");break}g.uniform2fv(e,m);break;case g.FLOAT_VEC3:if(0===m.length){console.log("uniform "+q.info.name+" has length 0");break}g.uniform3fv(e,m);break;case g.FLOAT_VEC4:if(0===m.length){console.log("uniform "+q.info.name+" has length 0");break}g.uniform4fv(e,m);break;case g.INT:case g.BOOL:1<n.size?0===m.length?console.log("uniform "+q.info.name+" has length 0"):
g.uniform1iv(e,m):g.uniform1i(e,m);break;case g.INT_VEC2:case g.BOOL_VEC2:if(0===m.length){console.log("uniform "+q.info.name+" has length 0");break}g.uniform2iv(e,m);break;case g.INT_VEC3:case g.BOOL_VEC3:if(0===m.length){console.log("uniform "+q.info.name+" has length 0");break}g.uniform3iv(e,m);break;case g.INT_VEC4:case g.BOOL_VEC4:0===m.length?console.log("uniform "+q.info.name+" has length 0"):g.uniform4iv(e,m)}},createTexture:function(g,q){var m=g.createTexture();g.bindTexture(g.TEXTURE_2D,
m);g.texParameteri(g.TEXTURE_2D,g.TEXTURE_WRAP_S,g.CLAMP_TO_EDGE);g.texParameteri(g.TEXTURE_2D,g.TEXTURE_WRAP_T,g.CLAMP_TO_EDGE);g.texParameteri(g.TEXTURE_2D,g.TEXTURE_MIN_FILTER,q?g.LINEAR:g.NEAREST);g.texParameteri(g.TEXTURE_2D,g.TEXTURE_MAG_FILTER,q?g.LINEAR:g.NEAREST);return m},createBufferTexture:function(g,q,m){q=H.createTexture(g,q);g.getExtension("OES_texture_float");m=m||[g.drawingBufferWidth,g.drawingBufferHeight];g.texImage2D(g.TEXTURE_2D,0,g.RGBA,m[0],m[1],0,g.RGBA,g.FLOAT,null);m=g.createFramebuffer();
g.bindFramebuffer(g.FRAMEBUFFER,m);g.framebufferTexture2D(g.FRAMEBUFFER,g.COLOR_ATTACHMENT0,g.TEXTURE_2D,q,0);return{texture:q,frameBuffer:m}},getShader:function(g,q,m){m=m?g.createShader(g.VERTEX_SHADER):g.createShader(g.FRAGMENT_SHADER);g.shaderSource(m,q);g.compileShader(m);g.getShaderParameter(m,g.COMPILE_STATUS)||(console.log(g.getShaderInfoLog(m)),m=null);return m},loadProgram:function(g,q,m){var n=g.createProgram();g.attachShader(n,q);g.attachShader(n,m);g.linkProgram(n);g.getProgramParameter(n,
g.LINK_STATUS)||(console.warn("failed to load webgl program: "+g.getProgramInfoLog(n)),g.deleteProgram(n),n=null);return n},createMesh:function(g,q){if(!g||1===g[0]&&1===g[1])return new Float32Array([0,0,1,0,0,1,0,1,1,0,1,1]);var m=g&&q?new Float32Array(g[0]*g[1]*20):new Float32Array(g[0]*g[1]*12);var n=.9998/g[1],e=.9998/g[0],c,a,b=0;for(c=0;c<g[1];c++)for(a=0;a<g[0];a++){var l=1E-4+n*c;var h=1E-4+e*a;g&&!q?(m[b++]=l,m[b++]=h,m[b++]=l+n,m[b++]=h,m[b++]=l,m[b++]=h+e,m[b++]=l,m[b++]=h+e,m[b++]=l+n,
m[b++]=h,m[b++]=l+n,m[b++]=h+e):(m[b++]=l,m[b++]=h,m[b++]=l,m[b++]=h+e,m[b++]=l,m[b++]=h+e,m[b++]=l+n,m[b++]=h+e,m[b++]=l+n,m[b++]=h+e,m[b++]=l+n,m[b++]=h,m[b++]=l,m[b++]=h,m[b++]=l+n,m[b++]=h,m[b++]=l,m[b++]=h+e,m[b++]=l+n,m[b++]=h)}return m}};return H})},"esri/layers/rasterLib/function/convolutionKernel":function(){define([],function(){var H={Default:[0,0,0,0,1,0,0,0,0],LineDetectionHorizontal:[-1,-1,-1,2,2,2,-1,-1,-1],LineDetectionVertical:[-1,2,-1,-1,2,-1,-1,2,-1],LineDetectionLeftDiagonal:[2,
-1,-1,-1,2,-1,-1,-1,2],LineDetectionRightDiagonal:[-1,-1,2,-1,2,-1,2,-1,-1],GradientNorth:[-1,-2,-1,0,0,0,1,2,1],GradientWest:[-1,0,1,-2,0,2,-1,0,1],GradientEast:[1,0,-1,2,0,-2,1,0,-1],GradientSouth:[1,2,1,0,0,0,-1,-2,-1],GradientNorthEast:[0,-1,-2,1,0,-1,2,1,0],GradientNorthWest:[-2,-1,0,-1,0,1,0,1,2],SmoothArithmeticMean:[.111111111111,.111111111111,.111111111111,.111111111111,.111111111111,.111111111111,.111111111111,.111111111111,.111111111111],Smoothing3x3:[.0625,.125,.0625,.125,.25,.125,.0625,
.125,.0625],Smoothing5x5:[1,1,1,1,1,1,4,4,4,1,1,4,12,4,1,1,4,4,4,1,1,1,1,1,1],Sharpening3x3:[-1,-1,-1,-1,9,-1,-1,-1,-1],Sharpening5x5:[-1,-3,-4,-3,-1,-3,0,6,0,-3,-4,6,21,6,-4,-3,0,6,0,-3,-1,-3,-4,-3,-1],Laplacian3x3:[0,-1,0,-1,4,-1,0,-1,0],Laplacian5x5:[0,0,-1,0,0,0,-1,-2,-1,0,-1,-2,17,-2,-1,0,-1,-2,-1,0,0,0,-1,0,0],SobelHorizontal:[-1,-2,-1,0,0,0,1,2,1],SobelVertical:[-1,0,1,-2,0,2,-1,0,1],Sharpen:[0,-.25,0,-.25,2,-.25,0,-.25,0],Sharpen2:[-.25,-.25,-.25,-.25,3,-.25,-.25,-.25,-.25],PointSpread:[-.627,
.352,-.627,.352,2.923,.352,-.627,.352,-.627],getKernel:function(g){switch(g){case 0:return H.LineDetectionHorizontal;case 1:return H.LineDetectionVertical;case 2:return H.LineDetectionLeftDiagonal;case 3:return H.LineDetectionRightDiagonal;case 4:return H.GradientNorth;case 5:return H.GradientWest;case 6:return H.GradientEast;case 7:return H.GradientSouth;case 8:return H.GradientNorthEast;case 9:return H.GradientNorthWest;case 10:return H.SmoothArithmeticMean;case 11:return H.Smoothing3x3;case 12:return H.Smoothing5x5;
case 13:return H.Sharpening3x3;case 14:return H.Sharpening5x5;case 15:return H.Laplacian3x3;case 16:return H.Laplacian5x5;case 17:return H.SobelHorizontal;case 18:return H.SobelVertical;case 19:return H.Sharpen;case 20:return H.Sharpen2;case 21:return H.PointSpread;default:return H.Default}}};return H})},"esri/layers/rasterLib/function/surfaceUtils":function(){define(["dojo/_base/lang"],function(H){return{hillshade:function(g,q){if(null!==g&&null!==g.pixelBlock&&null!==g.pixelBlock.pixels){var m=
this._clonePixelBlock(g.pixelBlock),n=q.altitude,e=q.azimuth,c=q.zFactor,a=q.psPower,b=q.psFactor,l=q.hillshadeType,h=q.slopeType,d=q.isGCS;1===l&&(c*=2);q=m.width;var f=m.height,k=m.pixels[0],p=m.mask,v=new Uint8Array(q*f);p&&v.set(p);var t=new Uint8Array(q*f),r=(g.extent.xmax-g.extent.xmin)/q,w=(g.extent.ymax-g.extent.ymin)/f,u=c/(8*r),y=c/(8*w);.001<c&&d&&(u/=111E3,y/=111E3);3===h&&(d?(u=111E3*r,y=111E3*w,u=(c+Math.pow(u,a)*b)/(8*u),y=(c+Math.pow(y,a)*b)/(8*y)):(u=(c+Math.pow(r,a)*b)/(8*r),y=(c+
Math.pow(w,a)*b)/(8*w)));d=(90-n)*Math.PI/180;n=Math.cos(d);var x=(360-e+90)*Math.PI/180;e=Math.sin(d)*Math.cos(x);d=Math.sin(d)*Math.sin(x);c=[];a=[];b=[];r=[315,270,225,360,180,0];var z=[60,60,60,60,60,90];h=[3,5,3,2,1,4];var B=h.reduce(function(R,T){return R+T});w=h.map(function(R){return R/B});if(1===l){var E=r.length;for(h=0;h<E;h++)n=z[h],e=r[h],d=(90-n)*Math.PI/180,n=Math.cos(d),x=(360-e+90)*Math.PI/180,e=Math.sin(d)*Math.cos(x),d=Math.sin(d)*Math.sin(x),c.push(n),a.push(e),b.push(d)}var I=
0;for(h=1;h<f-1;h++)for(z=h*q,r=1;r<q-1;r++)if(p&&!p[z+r])t[z+r]=0;else{x=0;if(p&&(x=p[z-q+r-1]+p[z-q+r]+p[z-q+r+1]+p[z+r-1]+p[z+r+1]+p[z+q+r-1]+p[z+q+r]+p[z+q+r+1],7>x)){t[z+r]=0;v[z+r]=0;continue}if(7===x){var C=p[z-q+r-1]?k[z-q+r-1]:k[z+r];var A=p[z-q+r]?k[z-q+r]:k[z+r];var F=p[z-q+r+1]?k[z-q+r+1]:k[z+r];x=p[z+r-1]?k[z+r-1]:k[z+r];var G=p[z+r+1]?k[z+r+1]:k[z+r];I=p[z+q+r-1]?k[z+q+r-1]:k[z+r];var O=p[z+q+r]?k[z+q+r]:k[z+r];var N=p[z+q+r+1]?k[z+q+r+1]:k[z+r]}else C=k[z-q+r-1],A=k[z-q+r],F=k[z-q+
r+1],x=k[z+r-1],G=k[z+r+1],I=k[z+q+r-1],O=k[z+q+r],N=k[z+q+r+1];x=(F+G+G+N-(C+x+x+I))*u;A=(I+O+O+N-(C+A+A+F))*y;F=Math.sqrt(1+x*x+A*A);I=0;if(0===l)O=d*A-e*x,O=255*(n+O)/F,0>O&&(O=0),I=O;else if(1===l)for(C=0;C<E;C++)O=b[C]*A-a[C]*x,O=255*(c[C]+O)/F,0>O&&(O=0),I+=O*w[C];t[z+r]=I}for(h=0;h<f;h++)t[h*q]=t[h*q+1],t[(h+1)*q-1]=t[(h+1)*q-2];for(h=1;h<q-1;h++)t[h]=t[h+q],t[h+(f-1)*q]=t[h+(f-2)*q];m.pixelType="U8";m.pixels=[t];m.statistics=[{minValue:0,maxValue:255}];p&&(m.mask=v);return{extent:g.extent,
pixelBlock:m}}},slope:function(g,q){if(null!==g&&null!==g.pixelBlock&&null!==g.pixelBlock.pixels){var m=this._clonePixelBlock(g.pixelBlock),n=q.zFactor,e=q.psPower,c=q.psFactor,a=q.slopeType,b=q.isGCS;q=m.width;var l=m.height,h=m.pixels[0],d=m.mask,f=new Uint8Array(q*l);d&&f.set(d);var k=new Float32Array(q*l),p=(g.extent.xmax-g.extent.xmin)/q,v=(g.extent.ymax-g.extent.ymin)/l,t=n/(8*p),r=n/(8*v);1E-4>Math.abs(n-1)&&b&&(t/=111E3,r/=111E3);3===a&&(b?(t=111E3*p,r=111E3*v,t=(n+Math.pow(t,e)*c)/(8*t),
r=(n+Math.pow(r,e)*c)/(8*r)):(t=(n+Math.pow(p,e)*c)/(8*p),r=(n+Math.pow(v,e)*c)/(8*v)));for(n=1;n<l-1;n++)for(c=n*q,e=1;e<q-1;e++)if(d&&!d[c+e])k[c+e]=0;else{v=0;if(d&&(v=d[c-q+e-1]+d[c-q+e]+d[c-q+e+1]+d[c+e-1]+d[c+e+1]+d[c+q+e-1]+d[c+q+e]+d[c+q+e+1],7>v)){k[c+e]=0;f[c+e]=0;continue}if(7===v){v=d[c-q+e-1]?h[c-q+e-1]:h[c+e];b=d[c-q+e]?h[c-q+e]:h[c+e];p=d[c-q+e+1]?h[c-q+e+1]:h[c+e];var w=d[c+e-1]?h[c+e-1]:h[c+e];var u=d[c+e+1]?h[c+e+1]:h[c+e];var y=d[c+q+e-1]?h[c+q+e-1]:h[c+e];var x=d[c+q+e]?h[c+q+
e]:h[c+e];var z=d[c+q+e+1]?h[c+q+e+1]:h[c+e]}else v=h[c-q+e-1],b=h[c-q+e],p=h[c-q+e+1],w=h[c+e-1],u=h[c+e+1],y=h[c+q+e-1],x=h[c+q+e],z=h[c+q+e+1];w=(p+u+u+z-(v+w+w+y))*t;v=(y+x+x+z-(v+b+b+p))*r;v=Math.sqrt(w*w+v*v);k[c+e]=1===a||3===a?57.2957795*Math.atan(v):100*v}for(n=0;n<l;n++)k[n*q]=k[n*q+1],k[(n+1)*q-1]=k[(n+1)*q-2];for(n=1;n<q-1;n++)k[n]=k[n+q],k[n+(l-1)*q]=k[n+(l-2)*q];m.pixelType="F32";m.pixels=[k];m.statistics=[{minValue:0,maxValue:255}];d&&(m.mask=f);return{extent:g.extent,pixelBlock:m}}},
aspect:function(g){if(null!==g&&null!==g.pixelBlock&&null!==g.pixelBlock.pixels){var q=this._clonePixelBlock(g.pixelBlock),m=q.width,n=q.height,e=q.pixels[0],c=q.mask,a=new Uint8Array(m*n);c&&a.set(c);var b=new Float32Array(m*n),l=1/((g.extent.xmax-g.extent.xmin)/m),h=1/((g.extent.ymax-g.extent.ymin)/n),d,f;for(d=1;d<n-1;d++){var k=d*m;for(f=1;f<m-1;f++)if(c&&!c[k+f])b[k+f]=0;else{var p=0;if(c&&(p=c[k-m+f-1]+c[k-m+f]+c[k-m+f+1]+c[k+f-1]+c[k+f+1]+c[k+m+f-1]+c[k+m+f]+c[k+m+f+1],7>p)){b[k+f]=0;a[k+f]=
0;continue}if(7===p){p=c[k-m+f-1]?e[k-m+f-1]:e[k+f];var v=c[k-m+f]?e[k-m+f]:e[k+f];var t=c[k-m+f+1]?e[k-m+f+1]:e[k+f];var r=c[k+f-1]?e[k+f-1]:e[k+f];var w=c[k+f+1]?e[k+f+1]:e[k+f];var u=c[k+m+f-1]?e[k+m+f-1]:e[k+f];var y=c[k+m+f]?e[k+m+f]:e[k+f];var x=c[k+m+f+1]?e[k+m+f+1]:e[k+f]}else p=e[k-m+f-1],v=e[k-m+f],t=e[k-m+f+1],r=e[k+f-1],w=e[k+f+1],u=e[k+m+f-1],y=e[k+m+f],x=e[k+m+f+1];r=(t+w+w+x-(p+r+r+u))*l;p=(u+y+y+x-(p+v+v+t))*h;0===r&&0===p?p=-1:(p=90-57.29578*Math.atan2(p,-r),0>p&&(p+=360),360===p?
p=0:360<p&&(p%=360));b[k+f]=p}}for(d=0;d<n;d++)b[d*m]=b[d*m+1],b[(d+1)*m-1]=b[(d+1)*m-2];for(d=1;d<m-1;d++)b[d]=b[d+m],b[d+(n-1)*m]=b[d+(n-2)*m];q.pixelType="F32";q.pixels=[b];q.statistics={minValue:0,maxValue:360};c&&(q.mask=a);return{extent:g.extent,pixelBlock:q}}},_clonePixelBlock:function(g){return g.clone?g.clone():H.clone(g)}}})},"esri/layers/rasterLib/function/BandArithmeticFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin ./rasterIndex".split(" "),
function(H,g,q,m,n,e,c){return H([q,e],{declaredClass:"esri.layers.rasterLib.function.BandArithmeticFunction",functionName:"BandArithmetic",supportWebGL:!0,support2D:!0,constructor:function(a){this.functionArguments=this.mixinIgnoreCase({method:1,bandIndexes:"",raster:null},a)},bind:function(a){a=this.getSourceRasterInfo(a);if(!a.raster)return Error("The raster input to band arithmetic function is invalid.");this.rasterInfo=g.mixin(a.raster,{bandCount:8===this.functionArguments.method?a.raster.bandCount:
1,pixelType:this._calculatePixelType(this.pixelType,"F32"),statistics:null,histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType="Generic";return!0},read2D:function(a){this._performance.start();a=a.raster;var b=c.calculate(a.pixelBlock,{bandIndexes:this.functionArguments.bandIndexes,method:this.functionArguments.method});this._addPerformanceMetric(this._performance.elapsed());"Unknown"!==this.pixelType&&(b.pixelType=this.pixelType);
return{extent:a.extent,pixelBlock:b}},readGL:function(a){this._performance.start();this._initializeProgram({fragment:n.bandArithmetic,fragmentName:"bandArithmetic"});var b=this.functionArguments.bandIndexes.trim().split(" ").map(function(f){return parseInt(f,10)});this._infraredBandID=b[0]-1;this._visibleBandID=b[1]-1;this._alterBand=2<Math.max(this._infraredBandID,this._visibleBandID)?!0:!1;a=this._setupTextureData(a.raster,this._alterBand&&2==b.length?{bandIDs:[this._infraredBandID,this._visibleBandID,
this._infraredBandID]}:{bandIDs:[b[0]-1,b[1]-1,b[2]-1]});var l=this.bindFrameBuffer(),h=this.functionArguments.method,d=2<b.length?b.slice(2):null;this._alterBand?this._setUniforms({u_method:h,u_bandId_nir:0,u_bandId_red:1,u_constants:d}):this._setUniforms({u_method:h,u_bandId_nir:b[0]-1,u_bandId_red:b[1]-1,u_constants:d});this._bindTexture(a.texture,"u_image");this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:a.extent,texture:l.texture}}})})},"esri/layers/rasterLib/function/rasterIndex":function(){define(["dojo/_base/lang"],
function(H){return{calculate:function(g,q){if(g&&g.pixels&&g.pixels.length){var m=q&&q.bandIndexes;q=q&&q.method;var n=m.trim().split(" ").map(function(a){return parseInt(a,10)}).filter(function(a){return null!=a});g=this._clonePixelBlock(g);var e=g.pixels,c=g.mask;switch(q){case 1:e=this._calculateNDVI(c,e[n[0]-1],e[n[1]-1]);break;case 2:e=this._calculateSAVI(c,e[n[0]-1],e[n[1]-1],n[2]);break;case 3:e=this._calculateTSAVI(c,e[n[0]-1],e[n[1]-1],n[2],n[3],n[4]);break;case 4:e=this._calculateMSAVI(c,
e[n[0]-1],e[n[1]-1]);break;case 5:e=this._calculateGEMI(c,e[n[0]-1],e[n[1]-1]);break;case 6:e=this._calculatePVI(c,e[n[0]-1],e[n[1]-1],n[2],n[3]);break;case 7:e=this._calculateGVITM(c,e[n[0]-1],e[n[1]-1],e[n[2]-1],e[n[3]-1],e[n[4]-1],e[n[5]-1]);break;case 8:e=this._calculateSultan(c,e[n[0]-1],e[n[1]-1],e[n[2]-1],e[n[3]-1],e[n[4]-1],e[n[5]-1]);break;case 9:e=this._calculateVARI(c,e[n[0]-1],e[n[1]-1],e[n[2]-1]);break;case 0:e=this._calculateUserDefined(c,e,m)}g.pixels=e;g.pixelType="F32";g.calculateStatistics();
return g}},_clonePixelBlock:function(g){return g.clone?g.clone():H.clone(g)},_parseUserDefined:function(g,q){g=g.replace(" ","");0===g.indexOf("-")&&(g="0"+g);0===g.indexOf("+")&&(g=g.slice(1,g.length));g=g.split("");var m=[],n=[],e="+-*/()".split(""),c,a="";for(c=0;c<g.length;c++){var b=g[c];e.some(function(l){return l===b})?(""!==a&&n.push(parseFloat(a)),m.push(b),a=""):"b"===b.toLowerCase()?(c++,a=b.concat(g[c]),n.push(q[parseInt(a[1],10)-1]),a=""):(a=a.concat(b),c===g.length-1&&n.push(parseFloat(a)))}return{ops:m,
nums:n}},_op:function(g,q,m,n){if(m.constructor===Number&&n.constructor===Number)return m+n;var e;if(m.constructor===Number){var c=n.length;var a=m;m=new Float32Array(c);for(e=0;e<c;e++)m[e]=a}else if(c=m.length,n.constructor===Number)for(a=n,n=new Float32Array(c),e=0;e<c;e++)n[e]=a;a=new Float32Array(c);if(null==g)if("+"===q)for(e=0;e<c;e++)a[e]=m[e]+n[e];else if("-"===q)for(e=0;e<c;e++)a[e]=m[e]-n[e];else if("*"===q)for(e=0;e<c;e++)a[e]=m[e]*n[e];else{if("/"===q)for(e=0;e<c;e++)a[e]=m[e]/n[e]}else if("+"===
q)for(e=0;e<c;e++)g[e]&&(a[e]=m[e]+n[e]);else if("-"===q)for(e=0;e<c;e++)g[e]&&(a[e]=m[e]-n[e]);else if("*"===q)for(e=0;e<c;e++)g[e]&&(a[e]=m[e]*n[e]);else if("/"===q)for(e=0;e<c;e++)g[e]&&(a[e]=m[e]/n[e]);return a},_shrinkOp:function(g,q){g.splice(q,1);var m=q=0,n=0;do{for(q=n=m=0;q<g.length;q++)if("("===g[q])m=q;else if(")"===g[q]){n=q;break}n===m+1&&g.splice(m,2)}while(n===m+1);return g},_getPriorityOpIndex:function(g,q){if(1===g.length)return{opIndex:0,numIndex:0};var m=q=0,n=0,e=-1,c=0;for(q=
0;q<g.length;q++)if("("===g[q])m=q;else if(")"===g[q]){n=q;break}var a=0===n?g:g.slice(m+1,n);for(q=0;q<a.length;q++)if("*"===a[q]||"/"===a[q]){e=q;break}if(!(-1<e))for(q=0;q<a.length;q++)if("+"===a[q]||"-"===a[q]){e=q;break}0<n&&(e+=m+1);for(q=0;q<e;q++)"("===g[q]&&c++;return{opIndex:e,numIndex:e-c}},_calculateUserDefined:function(g,q,m){q=this._parseUserDefined(m,q);m=q.ops;for(var n=q.nums,e,c,a;0<m.length&&(q=this._getPriorityOpIndex(m,n),e=m[q.opIndex],c=n[q.numIndex],a=n[q.numIndex+1],e=this._op(g,
e,c,a),1!==m.length);)m=this._shrinkOp(m,q.opIndex),n.splice(q.numIndex,2,e);return[e]},_calculateNDVI:function(g,q,m){var n=m.length,e=new Float32Array(n),c;if(null==g)for(c=0;c<n;c++){var a=m[c];var b=q[c];e[c]=(b-a)/(b+a)}else for(c=0;c<n;c++)g[c]&&(a=m[c],b=q[c],e[c]=(b-a)/(b+a));return[e]},_calculateSAVI:function(g,q,m,n){var e=m.length,c=new Float32Array(e),a;if(null==g)for(a=0;a<e;a++){var b=m[a];var l=q[a];c[a]=(l-b)/(l+b+n)*(1+n)}else for(a=0;a<e;a++)g[a]&&(b=m[a],l=q[a],c[a]=(l-b)/(l+b+
n)*(1+n));return[c]},_calculateTSAVI:function(g,q,m,n,e,c){var a=m.length,b=new Float32Array(a),l=-e*n+c*(1+n*n);if(null==g)for(c=0;c<a;c++){var h=m[c];var d=q[c];b[c]=n*(d-n*h-e)/(e*d+h+l)}else for(c=0;c<a;c++)g[c]&&(h=m[c],d=q[c],b[c]=n*(d-n*h-e)/(e*d+h+l));return[b]},_calculateMSAVI:function(g,q,m){var n=m.length,e=new Float32Array(n),c;if(null==g)for(c=0;c<n;c++){var a=m[c];var b=q[c];e[c]=.5*(2*(b+1)-Math.sqrt(Math.pow(2*b+1,2)-8*(b-a)))}else for(c=0;c<n;c++)g[c]&&(e[c]=.5*(2*(b+1)-Math.sqrt(Math.pow(2*
b+1,2)-8*(b-a))));return[e]},_calculateGEMI:function(g,q,m){var n=m.length,e=new Float32Array(n),c;if(null==g)for(c=0;c<n;c++){var a=m[c];var b=q[c];b=(2*(b*b-a*a)+1.5*b+.5*a)/(b+a+.5);e[c]=b*(1-.25*b)-(a-.125)/(1-a)}else for(c=0;c<n;c++)g[c]&&(a=m[c],b=q[c],b=(2*(b*b-a*a)+1.5*b+.5*a)/(b+a+.5),e[c]=b*(1-.25*b)-(a-.125)/(1-a));return[e]},_calculatePVI:function(g,q,m,n,e){var c=m.length,a=new Float32Array(c),b,l=Math.sqrt(1+n*n);if(null==g)for(b=0;b<c;b++){var h=m[b];var d=q[b];a[b]=(d-n*h-e)/l}else for(b=
0;b<c;b++)g[b]&&(h=m[b],d=q[b],a[b]=(d-n*h-e)/l);return[a]},_calculateGVITM:function(g,q,m,n,e,c,a){var b=q.length,l=new Float32Array(b),h;if(null==g)for(h=0;h<b;h++)l[h]=-.2848*q[h]-.2435*m[h]-.5436*n[h]+.7243*e[h]+.084*c[h]-1.18*a[h];else for(h=0;h<b;h++)g[h]&&(l[h]=-.2848*q[h]-.2435*m[h]-.5436*n[h]+.7243*e[h]+.084*c[h]-1.18*a[h]);return[l]},_calculateSultan:function(g,q,m,n,e,c,a){m=q.length;var b=new Float32Array(m),l=new Float32Array(m),h=new Float32Array(m),d;if(null==g)for(d=0;d<m;d++)b[d]=
c[d]/a[d]*100,l[d]=c[d]/q[d]*100,h[d]=n[d]/e[d]*(c[d]/e[d])*100;else for(d=0;d<m;d++)g[d]&&(b[d]=c[d]/a[d]*100,l[d]=c[d]/q[d]*100,h[d]=n[d]/e[d]*(c[d]/e[d])*100);return[b,l,h]},_calculateVARI:function(g,q,m,n){var e=q.length,c=new Float32Array(e),a;if(null==g)for(a=0;a<e;a++){var b=q[a];var l=m[a];var h=n[a];c[a]=(l-b)/(l+b-h)}else for(a=0;a<e;a++)if(g[a])for(a=0;a<e;a++)b=q[a],l=m[a],h=n[a],c[a]=(l-b)/(l+b-h);return[c]}}})},"esri/layers/rasterLib/function/ColormapFunction":function(){define("dojo/_base/declare dojo/_base/lang ../../../renderers/colorRampGenerator ./RasterFunctionX ./pixelShaders ./RasterFunctionWebGLMixin ./rasterUtils".split(" "),
function(H,g,q,m,n,e,c){return H([m,e],{declaredClass:"esri.layers.rasterLib.function.ColormapFunction",functionName:"Colormap",pixelType:"U8",renderTexture:!1,supportWebGL:!0,support2D:!0,constructor:function(a){this.functionArguments=this.mixinIgnoreCase({colormap:null,colorRampName:null,colorRamp:null,colorMapName:null,raster:null},a);this.invert=a&&a.invert;a=a.colormap||a.Colormap;if(a){if(a.features||a[0].attributes){a=a.features||a;var b=Object.keys(a[0].attributes);var l=b.filter(function(v){return"alpha"===
v.toLowerCase()})[0];var h=b.filter(function(v){return"value"===v.toLowerCase()})[0];var d=b.filter(function(v){return"red"===v.toLowerCase()})[0];var f=b.filter(function(v){return"green"===v.toLowerCase()})[0];var k=b.filter(function(v){return"blue"===v.toLowerCase()})[0];if(!(h&&d&&f&&k))throw"invalid colormap";a=a.map(function(v){return l?[v.attributes[h],v.attributes[d],v.attributes[f],v.attributes[k],v.attributes[l]]:[v.attributes[h],v.attributes[d],v.attributes[f],v.attributes[k]]});var p=1.1>
Math.max.apply(null,a.map(function(v){return v[1]}));b=l&&1.1>Math.max.apply(null,a.map(function(v){return v[4]}));if(p)for(p=0;p<a.length;p++)a[p][1]=Math.round(255*a[p][1]),a[p][2]=Math.round(255*a[p][2]),a[p][3]=Math.round(255*a[p][3]),b&&(a[p][4]=Math.round(255*a[p][4]))}this.functionArguments.colormap=this._sortClr(a)}this._initialize()},bind:function(a){this._initialize();a=this.getSourceRasterInfo(a);if(!a.raster||"F32"===a.raster.pixelType)return Error("The raster input to colormap function is invalid. It must be integer type.");
this.rasterInfo=g.mixin(a.raster,{bandCount:3,pixelType:this._calculatePixelType(this.pixelType,"U8"),statistics:null,histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType="Processed";return!0},read2D:function(a){return this._colorize(a.raster)},readGL:function(a){return this._colorizeGL(a.raster)},_colorize:function(a){this._performance.start();var b=c.colorize(a.pixelBlock,{indexedColormap:this._indexedColormap,indexedColormapOffset:this._indexedColormapOffset,
indexed2DColormap:this._indexed2DColormap,alphaSpecified:this._alphaSpecified});this._addPerformanceMetric(this._performance.elapsed());return{extent:a.extent,pixelBlock:b}},_binarySearchClr:function(a,b){for(var l=0,h=a.length-1,d=0,f=0;l<h;)if(d=Math.floor((l+h)/2),f=a[d],f[0]<b)l=d;else if(f[0]>b)h=d;else return f.slice(1);return null},_sortClr:function(a,b){var l,h=[];for(l=0;l<a.length;l++)h.push(a[l]);for(l=0;l<h.length-1;l++){var d=h[l];for(a=l+1;a<h.length;a++)d[0]>h[a][0]&&(d=h[a],h[a]=h[l],
h[l]=d)}if(b)for(l=0;l<h.length/2;l++)d=h[l],h[h.length-1-l]=h[l],h[l]=d;return h},_invertColorRamp:function(a){if(!a)return a;var b={type:a.type};"random"===a.type?b=a:"multipart"===a.type?b.colorRamps=a.colorRamps.map(function(l){return{fromColor:l.toColor,toColor:l.fromColor}}).reverse():(b.fromColor=a.toColor,b.toColor=a.fromColor);return b},_initialize:function(){this._indexedColormapOffset=0;if(this.functionArguments.colormap){var a=c.buildIndexedColormap(this.functionArguments.colormap);this._alphaSpecified=
a&&a.alphaSpecified;this._indexedColormap=a&&a.indexedColormap;this._indexedColormapOffset=a&&a.offset;this._indexedColormap||(this._indexed2DColormap=this._getIndexed2DColormap())}else this.functionArguments.colorRamp?this._indexedColormap="multipart"===this.functionArguments.colorRamp.type?this.invert?q.createMultiPartColorRamp(this._invertColorRamp(this.functionArguments.colorRamp)):q.createMultiPartColorRamp(this.functionArguments.colorRamp):this.invert?q.createAlgorithmicColorRamp(this._invertColorRamp(this.functionArguments.colorRamp)):
q.createAlgorithmicColorRamp(this.functionArguments.colorRamp):this.functionArguments.colormapName&&"random"===this.functionArguments.colormapName.toLowerCase()&&(this._indexedColormap=q.createRandomColorRamp())},_getIndexed2DColormap:function(){var a=this.functionArguments.colormap;if(!a)return null;var b=0;0>a[0][0]&&(b=a[0][0]);var l=[],h=5===a[0].length,d;for(d=0;d<a.length;d++)l[a[d][0]-b]=h?a[d].slice(1):a[d].slice(1).concat([255]);return l},_colorizeGL:function(a){this._performance.start();
this._initializeProgram({fragment:n.colormap,fragmentName:"Colormap"});var b=this._indexedColormap,l=this._indexedColormapOffset;this._clrTexture||(this._clrTexture=this._setupColormapTexture(b));var h=this._clrTexture,d=this.bindFrameBuffer();a=this._setupTextureData(a);this._setUniforms({u_indexedColormapOffset:l,u_indexedColormapMaxIndex:b.length/4-1});this._bindTexture(h,"u_image1");this._bindTexture(a.texture,"u_image");this._drawGL();return{extent:a.extent,texture:d.texture}},_setupColormapTexture:function(a){var b=
this._createTexture(),l=this.gl,h=a.length/4,d=new Float32Array(a.length),f,k=this.renderTexture?255:1;for(f=0;f<a.length;f++)d[f]=a[f]/k;l.getExtension("OES_texture_float");l.texImage2D(l.TEXTURE_2D,0,l.RGBA,h,1,0,l.RGBA,l.FLOAT,d);return b}})})},"esri/renderers/colorRampGenerator":function(){define(["dojo/_base/declare","dojo/_base/lang","../renderers/colorUtils"],function(H,g,q){return{createAlgorithmicColorRamp:function(m,n){if(!m)return null;var e=m.fromColor,c=m.toColor;if(!e||!c)return null;
void 0===e.r&&3<=e.length&&(e={r:e[0],g:e[1],b:e[2]});void 0===c.r&&3<=c.length&&(c={r:c[0],g:c[1],b:c[2]});var a=m.size||256;m=m.algorithm||"cie-lab";if(1===a)var b=[e.r,e.g,e.b,255];else if(2===a)b=[e.r,e.g,e.b,255,c.r,c.g,e.b,255];else if(-1<m.toLowerCase().indexOf("hsv")){b=q.toHSV(e);c=q.toHSV(c);a=a||256;var l=0===b.s,h=0===c.s;e=b.h;m=c.h;l&&!h?e=b.h=m:h&&!l&&(m=c.h=e);l=Math.abs(m-e);180>l?m=(m-e)/(a-1):(l=360-l,m=e>m?l/(a-1):-l/(a-1));l=(c.s-b.s)/(a-1);h=(c.v-b.v)/(a-1);var d=b.s;b=b.v;var f,
k=new Uint8Array(4*a);for(f=0;f<a-1;f++){var p=q.toRGB({h:e,s:d,v:b});k[4*f]=p.r;k[4*f+1]=p.g;k[4*f+2]=p.b;k[4*f+3]=255;e+=m;d+=l;b+=h;360<e?e-=360:0>e&&(e+=360)}p=q.toRGB(c);k[4*(a-1)]=p.r;k[4*(a-1)+1]=p.g;k[4*(a-1)+2]=p.b;k[4*(a-1)+3]=255;b=k}else if(-1<m.toLowerCase().indexOf("lch")){d=q.toLCH(e);c=q.toLCH(c);a=a||256;b=(c.l-d.l)/(a-1);e=(c.c-d.c)/(a-1);m=(c.h-d.h)/(a-1);l=d.l;h=d.c;d=d.h;k=new Uint8Array(4*a);for(f=0;f<a-1;f++)p=q.toRGB({l:l,c:h,h:d}),k[4*f]=p.r,k[4*f+1]=p.g,k[4*f+2]=p.b,k[4*
f+3]=255,l+=b,h+=e,d+=m;p=q.toRGB(c);k[4*(a-1)]=p.r;k[4*(a-1)+1]=p.g;k[4*(a-1)+2]=p.b;k[4*(a-1)+3]=255;b=k}else if(-1<m.toLowerCase().indexOf("lab")){d=q.toLAB(e);c=q.toLAB(c);a=a||256;b=(c.l-d.l)/(a-1);e=(c.a-d.a)/(a-1);m=(c.b-d.b)/(a-1);l=d.l;h=d.a;d=d.b;k=new Uint8Array(4*a);for(f=0;f<a-1;f++)p=q.toRGB({l:l,a:h,b:d}),k[4*f]=p.r,k[4*f+1]=p.g,k[4*f+2]=p.b,k[4*f+3]=255,l+=b,h+=e,d+=m;p=q.toRGB(c);k[4*(a-1)]=p.r;k[4*(a-1)+1]=p.g;k[4*(a-1)+2]=p.b;k[4*(a-1)+3]=255;b=k}if(n&&!1===n.flattened)for(n=b,
b=[],c=0;c<b/4;c++)b[c]=n.slice(4*c,4*c+4);return b},createMultiPartColorRamp:function(m,n){if(!m)return null;n=n&&g.clone(n)||{flattened:!0};var e=m.colorRamps;if(!e||0===e.length)return null;var c=m.size||256;m=Math.max(Math.floor(c/e.length),1);var a=Math.max(m,c-(e.length-1)*m),b=!1!==n.flattened;n.flattened=!0;c=(e.length-1)*m+a;var l=new Uint8Array(4*c);for(c=0;c<e.length;c++){var h={fromColor:e[c].fromColor,toColor:e[c].toColor,size:c===e.length-1?a:m};l instanceof Array?l.concat(this.createAlgorithmicColorRamp(h,
n)):l.set(this.createAlgorithmicColorRamp(h,n),m*c*4)}if(!b)for(n=l,l=[],c=0;c<l/4;c++)l[c]=n.slice(4*c,4*c+4);return l},createRandomColorRamp:function(m){m=m||{};var n=m.size||256,e=!1===m.flattened;var c=e?new Uint8Array(4*n):[];for(m=0;m<n;m++)e?(c[4*m]=Math.round(255*Math.random()),c[4*m+1]=Math.round(255*Math.random()),c[4*m+2]=Math.round(255*Math.random()),c[4*m+3]=255):c[m]=[Math.round(255*Math.random()),Math.round(255*Math.random()),Math.round(255*Math.random()),255];return c}}})},"esri/layers/rasterLib/function/rasterUtils":function(){define(["dojo/_base/lang"],
function(H){return{mask:function(g,q){if(g&&g.pixels&&g.pixels.length){g=this._clonePixelBlock(g);var m=q.includedRanges,n=q.noDataInterpretation;q=q.noDataValues;if(null===m&&null===q)return g;var e=g.pixels,c=g.mask,a=g.width*g.height,b=e.length,l;if(null!==q&&q.length!==b)throw"expect "+b+" elements in noDataValues";if(null!==m&&m.length!==2*b)throw"expect "+2*b+" elements in IncludeRanges";if(null==c){c=new Uint8Array(a);for(l=0;l<a;l++)c[l]=1;g.mask=c}if(0===n)for(n=0;n<b;n++){var h=e[n];var d=
null===m?null:m[2*n];var f=null===m?null:m[2*n+1];var k=null===q?null:parseFloat(q[n]);if(null===d||null===f)for(l=0;l<a;l++){if(c[l]){var p=h[l];p===k&&(c[l]=0)}}else if(null===k)for(l=0;l<a;l++)c[l]&&(p=h[l],p<d||p>f)&&(c[l]=0);else for(l=0;l<a;l++)c[l]&&(p=h[l],p<d||p>f||p===k)&&(c[l]=0)}else{var v=new Uint8Array(a);for(l=0;l<a;l++)v[l]=c[l];for(n=0;n<b;n++)if(h=e[n],d=null===m?null:m[2*n],f=null===m?null:m[2*n+1],k=null===q?null:parseFloat(q[n]),null===d||null===f)for(l=0;l<a;l++)v[l]&&(p=h[l],
p!==k&&(v=0));else if(null===k)for(l=0;l<a;l++)v[l]&&(p=h[l],p<=d&&p<=f&&(v=0));else for(l=0;l<a;l++)v[l]&&(p=h[l],p<=d&&p<=f&&p!==k&&(v=0));for(l=0;l<a;l++)c[l]&&v[l]&&(c[l]=0)}return g}},calculateStatisticsHistograms:function(g,q){g=this._clonePixelBlock(g);q=g.pixelType;var m=g.pixels,n=g.mask,e=m.length,c,a,b=[],l;for(c=0;c<e;c++){var h={min:-.5,max:255.5,size:256,counts:new Uint32Array(256)};var d=h.counts;var f=m[c];if("U8"===q)if(n)for(a=0;a<g.width*g.height;a++)n[a]&&d[f[a]]++;else for(a=
0;a<g.width*g.height;a++)d[f[a]]++;else{var k=g.statistics[c].minValue;var p=g.statistics[c].maxValue;h.min=k;h.max=p;p=(p-k)/256;var v=new Uint32Array(257);if(n)for(a=0;a<g.width*g.height;a++)n[a]&&v[Math.floor((f[a]-k)/p)]++;else for(a=0;a<g.width*g.height;a++)v[Math.floor((f[a]-k)/p)]++;for(a=0;255>a;a++)d[a]=v[a];d[255]=v[255]+v[256]}b.push(h);k=g.statistics[c].minValue;p=g.statistics[c].maxValue;for(a=v=l=f=0;a<h.size;a++)f+=d[a],l+=a*d[a];l/=f;for(a=0;a<h.size;a++)v+=d[a]*Math.pow(a-l,2);d=
Math.sqrt(v/(f-1));a=(l+.5)*(h.max-h.min)/h.size+h.min;h=d*(h.max-h.min)/h.size;g.statistics[c]={min:k,minValue:k,max:p,maxValue:p,mean:a,stddev:h}}g.histograms=b;return g},buildIndexedColormap:function(g,q){if(!g)return null;var m=0;0>g[0][0]&&(m=g[0][0]);var n=Math.max(256,g[g.length-1][0]-m);if(65536<n)return null;var e=new Uint8Array(4*n),c=[],a=0,b=5===g[0].length;if(q)for(c=g[a],q=c[0]-m;q<n;q++)e[4*q]=c[1],e[4*q+1]=c[2],e[4*q+2]=c[3],e[4*q+3]=b?c[4]:255,q===c[0]-m&&(c=a===g.length-1?c:g[++a]);
else for(q=0;q<g.length;q++)c=g[q],a=4*(c[0]-m),e[a]=c[1],e[a+1]=c[2],e[a+2]=c[3],e[a+3]=b?c[4]:255;return{indexedColormap:e,offset:m,alphaSpecified:b}},colorize:function(g,q){if(null!==g&&null!==g.pixels){g=this._clonePixelBlock(g);var m=g.pixels,n=g.width*g.height,e=g.mask,c=q.indexedColormap,a=q.indexedColormapOffset,b=c&&c.length-1,l=q.indexed2DColormap;q=q.alphaSpecified;if(3<=m.length)throw"colormap only works on single band image";var h=m[0],d=new Uint8Array(h.length),f=new Uint8Array(h.length),
k=new Uint8Array(h.length),p=0;if(c)if(e)for(m=0;m<n;m++)e[m]&&(p=4*(h[m]-a),p<a||p>b?e[m]=0:(d[m]=c[p],f[m]=c[p+1],k[m]=c[p+2],e[m]=c[p+3]));else{e=new Uint8Array(n);for(m=0;m<n;m++)p=4*(h[m]-a),p<a||p>b?e[m]=0:(d[m]=c[p],f[m]=c[p+1],k[m]=c[p+2],e[m]=c[p+3]);g.mask=e}else if(e)for(m=0;m<n;m++)e[m]&&(c=l[h[m]],d[m]=c[0],f[m]=c[1],k[m]=c[2],e[m]=c[3]);else{e=new Uint8Array(n);for(m=0;m<n;m++)c=l[h[m]],d[m]=c[0],f[m]=c[1],k[m]=c[2],e[m]=c[3];g.mask=e}g.pixels=[d,f,k];g.statistics=null;g.pixelType="U8";
g.maskIsAlpha=q;return g}},convolute:function(g,q){g=this._clonePixelBlock(g);var m=g.pixels,n=g.width,e=g.height,c=n*e,a=m.length,b,l,h,d,f=[],k=[],p=q.normalizedKernel,v=q.kernelRows,t=q.kernelCols;for(q=0;q<a;q++){var r=m[q];var w=new Float32Array(c);w.set(r);for(h=1;h<e-1;h++){var u=h*n;for(d=1;d<n-1;d++){for(b=k=0;b<v;b++)for(l=0;l<t;l++)k+=r[u+d+(b-1)*n+l-1]*p[b*t+l];w[u+d]=k}}f.push(w)}g.pixels=f;return g},contrastBrightnessStretch:function(g,q){if(null!==g&&null!==g.pixels){g=this._clonePixelBlock(g);
var m=g.pixels,n=g.mask,e=g.width*g.height,c=m.length;var a=q&&q.contrastOffset;q=q&&q.brightnessOffset;if("U8"!==g.pixelType)throw"the contrast and brightness function only supports 8 bit unsigned integer data";var b=this._createContrastBrightnessLUT(a,q);if(null==n)for(a=0;a<e;a++)for(q=0;q<c;q++)m[q][a]=b[m[q][a]];else for(a=0;a<e;a++)if(n[a])for(q=0;q<c;q++)m[q][a]=b[m[q][a]];g.pixelType="U8";return g}},isNull:function(g,q){if(null!==g&&null!==g.pixels){g=this._clonePixelBlock(g);q=g.mask;var m=
g.pixels[0],n=m.length,e;if(q){for(e=0;e<n;e++)m[e]=q[e]?0:1;g.mask=null}else if(m.fill)m.fill(0);else for(e=0;e<n;e++)m[e]=0;return g}},setNull:function(g){if(null!==q&&null!==q.pixels){var q=this._clonePixelBlock(g);g=q.mask;var m=q.pixels[0],n=m.length,e;g=g||new Uint8Array(n);for(e=0;e<n;e++)g[e]=m[e]?0:1;q.mask=g;return q}},local:function(g,q){if(!q)return g[0];var m=q.rasterCountNeeded;q=q.functor;var n=this._clonePixelBlock(g[0]);if(null!==n&&null!==n.pixels){var e=n.width*n.height,c;g=(c=
g[1])&&c.pixels[0];var a=c&&c.mask,b=n.mask,l=n.pixels[0];if(2===m)if(!b&&a)b=a;else if(b&&a)for(c=0;c<e;c++)b[c]=b[c]&&a[c]?1:0;n.mask=b;if(1===m)if(null==b)for(c=0;c<e;c++)l[c]=q(l[c]);else for(c=0;c<e;c++)b[c]&&(l[c]=q(l[c]));else if(2===m)if(null==b)for(c=0;c<e;c++)l[c]=q(l[c],g[c]);else for(c=0;c<e;c++)b[c]&&(l[c]=q(l[c],g[c]));n.mask=b;n.calculateStatistics();return n}},remapColor:function(g,q){g=this._clonePixelBlock(g);var m=g.width*g.height,n=q.length,e=Math.floor(n/2),c=q[Math.floor(e)],
a=q[0].value,b=q[q.length-1].value,l=g.pixels[0],h,d,f=!1,k=new Uint8Array(m),p=new Uint8Array(m),v=new Uint8Array(m),t=g.mask,r=4===q[0].mappedColor.length;t&&0!==t.length||(t=new Uint8Array(m),t.fill(r?255:1),g.mask=t);for(d=0;d<m;d++)if(t[d]){var w=l[d];if(w<a||w>b)k[d]=p[d]=v[d]=t[d]=0;else{f=!1;var u=e;var y=c;var x=0;for(h=n-1;1<h-x;){if(w===y.value){f=!0;break}w>y.value?x=u:h=u;u=Math.floor((x+h)/2);y=q[Math.floor(u)]}f||(y=w===q[h].value?q[h]:q[x]);k[d]=y.mappedColor[0];p[d]=y.mappedColor[1];
v[d]=y.mappedColor[2];t[d]=y.mappedColor[3]}}g.pixels=[k,p,v];g.mask=t;g.pixelType="u8";g.maskIsAlpha=r;return g},_clonePixelBlock:function(g){if(g.clone)return g.clone();var q=H.clone(g),m;if(g.pixels&&g.pixels[0]&&0<g.pixels[0].length&&!(q.pixels&&q.pixels[0]&&0<q.pixels[0].length)){q.pixels=[];var n=g.pixels.length;for(m=0;m<n;m++)q.pixels[m]=new g.pixels[m].constructor(g.pixels[m])}if(g.statistics)for(q.statistics=[],n=g.statistics.length,m=0;m<n;m++)q.statistics[m]=H.clone(g.statistics[m]);g.mask&&
(q.mask=new Uint8Array(g.mask));return q},_createContrastBrightnessLUT:function(g,q){if(this._contrastCache&&this._contrastCache.contrastOffset===g&&this._contrastCache.brightnessOffset===q)return this._contrastCache.lut;var m=Math.min(Math.max(g,-100),100),n=Math.min(Math.max(q,-100),100),e,c=new Uint8Array(256);for(e=0;256>e;e++){if(0<m&&100>m)var a=(200*e-25500+510*n)/(2*(100-m))+128;else 0>=m&&-100<m?a=(200*e-25500+510*n)*(100+m)/2E4+128:100===m?(a=200*e-25500+256*(100-m)+510*n,a=0<a?255:0):-100===
m&&(a=128);c[e]=255<a?255:0>a?0:a}this._contrastCache={contrastOffset:g,brightnessOffset:q,lut:c};return c}}})},"esri/layers/rasterLib/function/CompositeBandFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin".split(" "),function(H,g,q,m,n,e){return H([q,e],{declaredClass:"esri.layers.rasterLib.function.CompositeBandFunction",functionName:"CompositeBand",supportWebGL:!0,support2D:!0,constructor:function(c){this.functionArguments=
this.mixinIgnoreCase({rasters:null},c)},bind:function(c){c=this.getSourceRasterInfo(c);if(!c.rasters)return Error("The rasters input to composite band function is invalid.");var a=[],b=[],l=c.rasters.length,h;if(c.rasters[0].statistics)for(h=0;h<l;h++)a.push(c.rasters[h].statistics[0]);if(c.rasters[0].histograms)for(h=0;h<l;h++)b.push(c.rasters[h].histograms[0]);this.rasterInfo=g.mixin(c.rasters[0],{bandCount:l,pixelType:this._calculatePixelType(this.pixelType,c.rasters[0].pixelType),statistics:a,
histograms:b});return!0},read2D:function(c){c=c.rasters;if(null!=c&&0!==c.length){var a=this._clonePixelData(c[0]),b=a.pixelBlock,l=[],h=[];for(d=0;d<c.length;d++)l.push(c[d].pixelBlock.pixels[0]),h.push(c[d].pixelBlock.statistics[0]);b.pixels=l;b.stackedStatistics=h;b.planes=c.length;var d;h=b.width*b.height;for(d=0;d<c.length;d++)if(b=c[d].pixelBlock.mask,f&&b)for(l=0;l<h;l++)f[l]&=b[l];else var f=f||b;a.maks=f;return a}},readGL:function(c){this._performance.start();this._initializeProgram({fragment:n.compositeBand,
fragmentName:"CompositeBand"});var a=c.rasters;if(null!=a&&0!==a.length){a=a.length;var b,l=this.bindFrameBuffer();for(b=0;b<a;b++){var h=this._setupTextureData(c.rasters[b],{notOriginal:0<b});var d=0<b?b.toString():"";this._bindTexture(h.texture,"u_image"+d)}this._setUniforms({u_rasterCount:a});this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:h.extent,texture:l.texture}}}})})},"esri/layers/rasterLib/function/ContrastBrightnessFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin ./rasterUtils".split(" "),
function(H,g,q,m,n,e,c){return H([q,e],{declaredClass:"esri.layers.rasterLib.function.ContrastBrightnessFunction",renderTexture:!0,functionName:"ContrastBrightness",supportWebGL:!0,support2D:!0,pixelType:"U8",constructor:function(a){this.functionArguments=this.mixinIgnoreCase({contrastOffset:0,brightnessOffset:0,raster:null},a)},bind:function(a){a=this.getSourceRasterInfo(a);if(!a.raster)return Error("The raster input to contrast and brightness function is invalid.");this.rasterInfo=g.mixin(a.raster,
{bandCount:a.raster.bandCount,pixelType:this._calculatePixelType(this.pixelType,"U8"),statistics:null,histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType="Processed";return!0},read2D:function(a){a=a.raster;if(null!==a&&null!==a.pixelBlock&&null!==a.pixelBlock.pixels){var b=c.contrastBrightnessStretch(a.pixelBlock,{contrastOffset:this.functionArguments.contrastOffset,brightnessOffset:this.functionArguments.brightnessOffset});"Unknown"!==
this.pixelType&&(b.pixelType=this.pixelType,b.pixels=b.pixels.map(g.hitch(this,function(l){return this._clampBand(l,b.pixelType)})));return{extent:a.extent,pixelBlock:b}}},readGL:function(a){return this._cbGL(a.raster)},_cbGL:function(a){this._performance.start();this._initializeProgram({fragment:n.contrastBrightness,fragmentName:"ContrastBrightness"});a=this._setupTextureData(a);this._setUniforms({u_contrastOffset:Math.min(Math.max(this.functionArguments.contrastOffset,-100),100),u_brightnessOffset:Math.min(Math.max(this.functionArguments.brightnessOffset,
-100),100),u_scaleFactor:this.renderTexture?255:1});this._bindTexture(a.texture,"u_image");var b=this.bindFrameBuffer();this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:a.extent,texture:b.texture}}})})},"esri/layers/rasterLib/function/ConvolutionFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./convolutionKernel ./pixelShaders ./RasterFunctionWebGLMixin ./rasterUtils".split(" "),function(H,g,q,m,n,e,c,a){return H([q,
c],{declaredClass:"esri.layers.rasterLib.function.ConvolutionFunction",functionName:"Convolution",supportWebGL:!0,support2D:!0,constructor:function(b){this.functionArguments=this.mixinIgnoreCase({columns:3,rows:3,type:0,kernel:null,raster:null},b)},bind:function(b){b=this.getSourceRasterInfo(b);if(!b.raster)return Error("The raster input to convolution function is invalid.");this.rasterInfo=g.mixin(b.raster,{bandCount:b.raster.bandCount,pixelType:this._calculatePixelType(this.pixelType,b.raster.pixelType),
statistics:b.raster.statistics,histograms:b.raster.histograms});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType="Generic";return!0},read2D:function(b){this._performance.start();b=b.raster;var l=this._analyzeKernel(),h=a.convolute(b.pixelBlock,{normalizedKernel:l.normalizedKernel,kernelCols:this.functionArguments.columns,kernelRows:this.functionArguments.rows});this._addPerformanceMetric(this._performance.elapsed());"Unknown"!==this.pixelType&&
(h.pixelType=this.pixelType);h.pixels=h.pixels.map(g.hitch(this,function(d){return this._clampBand(d,h.pixelType)}));return{extent:b.extent,pixelBlock:h}},readGL:function(b){this._performance.start();this._initializeProgram({fragment:e.convolution,fragmentName:"Convolution"});var l=this._setupTextureData(b.raster),h=this.bindFrameBuffer(),d=this.gl,f=d.drawingBufferWidth;d=d.drawingBufferHeight;var k=this.functionArguments.kernel;this._setUniforms({u_resolution:b&&b.raster&&b.raster.pixelBlock?[1/
b.raster.pixelBlock.width,1/b.raster.pixelBlock.height]:[1/f,1/d],u_kernel:k,u_kernelSize:k.length});this._bindTexture(l.texture,"u_image");this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:l.extent,texture:h.texture}},_analyzeKernel:function(){var b=this.functionArguments.kernel,l=b.reduce(function(f,k){return f+k});0!==l&&1!==l&&(b=b.map(function(f){return f/l}));var h,d=[];for(h=0;h<b.length;h++)d.some(function(f){return f===b[h]})||d.push(b[h]);return{normalizedKernel:b,
distinctValues:d}},_analyzeKernelPattern:function(){var b=this.functionArguments.rows,l=this.functionArguments.columns,h=this.functionArguments.kernel,d=[],f,k;for(f=0;f<b;f++)d.push({weights:h.slice(f*l,(f+1)*l)});var p;for(f=1;f<b;f++){var v=d[f].weights;for(h=0;h<f;h++)if(p=d[h].weights){var t=v[0]/p[0];for(k=1;k<l;k++)v[k]/p[k]!==t&&(t=null);null!==t&&(d[f]={row:h,factor:t})}}return d}})})},"esri/layers/rasterLib/function/ExtractBandFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin".split(" "),
function(H,g,q,m,n,e){return H([q,e],{declaredClass:"esri.layers.rasterLib.function.ExtractBandFunction",functionName:"ExtractBand",supportWebGL:!0,support2D:!0,constructor:function(c){this.functionArguments=this.mixinIgnoreCase({bandIDs:[],missingBandAction:0,raster:null},c)},bind:function(c){c=this.getSourceRasterInfo(c);if(!c.raster)return Error("The raster input to extract band function is invalid.");var a=[],b=c.raster.statistics,l=[],h=c.raster.histograms,d=this.functionArguments.bandIDs.length||
c.raster.bandCount;this.functionArguments.bandIDs.forEach(g.hitch(this,function(f){if(f>=d-1){if(1===this.functionArguments.missingBandAction)return Error("missing band "+f);f=d-1}if(0>f)return Error("missing band "+f);void 0!==b&&null!==b&&0<b.length&&a.push(b[f]);void 0!==h&&null!==h&&0<h.length&&l.push(h[f])}));this.rasterInfo=g.mixin(c.raster,{bandCount:d,pixelType:this._calculatePixelType(this.pixelType,c.raster.pixelType),statistics:a,histograms:l});return!0},read2D:function(c){c=this._clonePixelData(c.raster);
if(null!==c&&null!==c.pixelBlock&&null!==c.pixelBlock.pixels){this._performance.start();var a=c.pixelBlock,b=a.statistics,l=a.pixels,h=l.length;if(null==this.functionArguments.bandIDs)throw"missing bandIDs parameter";if(0===this.functionArguments.bandIDs.length)return c;var d=[],f=[];this.functionArguments.bandIDs.forEach(function(k){if(k>=h-1){if(1===this.functionArguments.missingBandAction)throw"missing band "+k;k=h-1}if(0>k)throw"missing band "+k;d.push(l[k]);void 0!==b&&null!==b&&0<b.length&&
f.push(b[k])});a.pixels=d;a.statistics=f;a.planes=this.functionArguments.bandIDs.length;return c}},readGL:function(c){this._performance.start();if(null==this.functionArguments.bandIDs)throw"missing bandIDs parameter";if(3<this.functionArguments.bandIDs.length)throw"this version does not support more than 3 bands yet";this._initializeProgram({fragment:n.extractBand,fragmentName:"ExtractBand"});var a=this.functionArguments.bandIDs;1===a.length&&(a=[a[0],a[0],a[0]]);this._bandIDs=a;this._alterBand=!(0===
this.functionArguments.bandIDs.length||0===a[0]&&1===a[1]&&2===a[2]);var b=!!(this._alterBand&&c.raster&&c.raster.texture);c=this._setupTextureData(c.raster,{bandIDs:a});var l=this.bindFrameBuffer();b?this._setUniforms({u_bandIDs:a,u_alterBand:this._alterBand}):this._setUniforms({u_bandIDs:a,u_alterBand:!1});this._bindTexture(c.texture,"u_image");this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:c.extent,texture:l.texture}}})})},"esri/layers/rasterLib/function/HillshadeFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../../renderers/colorRampGenerator ../../../WKIDUnitConversion ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin ./surfaceUtils ./rasterUtils".split(" "),
function(H,g,q,m,n,e,c,a,b,l){return H([q,a],{declaredClass:"esri.layers.rasterLib.function.HillshadeFunction",functionName:"Hillshade",supportWebGL:!0,support2D:!0,renderTexture:!0,constructor:function(h){this.functionArguments=this.mixinIgnoreCase({hillshadeType:0,altitude:45,azimuth:315,zFactor:1,slopeType:1,psPower:.664,psFactor:.024,colorRamp:null,raster:null},h);this._azimuths=[315,270,225,360,180,0];this._altitudes=[60,60,60,60,60,90];this._weights=[3,5,3,2,1,4];var d=this._weights.reduce(function(f,
k){return f+k});this._weights=this._weights.map(function(f){return f/d})},bind:function(h){h=this.getSourceRasterInfo(h);if(!h.raster)return Error("The raster input to hillshade function is invalid.");h.raster.statistics&&(this.srcStatistics=h.raster.statistics);this.rasterInfo=g.mixin(h.raster,{bandCount:1,pixelType:this._calculatePixelType(this.pixelType,"U8"),statistics:[{min:0,max:255}],histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType=
"Generic";this._initializeColormap();return!0},read2D:function(h){this._performance.start();h=h.raster;h=b.hillshade(h,{altitude:this.functionArguments.altitude,azimuth:this.functionArguments.azimuth,zFactor:this.functionArguments.zFactor,psPower:this.functionArguments.psPower,psFactor:this.functionArguments.psFactor,hillshadeType:this.functionArguments.hillshadeType,slopeType:this.functionArguments.slopeType,isGCS:h.extent.spatialReference.wkid&&null==n[h.extent.spatialReference.wkid]});this._addPerformanceMetric(this._performance.elapsed());
return h},readGL:function(h){this._performance.start();this._initializeProgram({fragment:c.hillshade,fragmentName:"Hillshade"});this.functionArguments.colorRamp&&this._indexedColormap&&!this._clrTexture&&(this._clrTexture=this._setupColormapTexture(this._indexedColormap));var d=this._setupTextureData(h.raster),f=this.bindFrameBuffer(),k=this.gl,p=k.drawingBufferWidth;k=k.drawingBufferHeight;var v=d.extent,t=(v.xmax-v.xmin)/p,r=(v.ymax-v.ymin)/k,w=this.functionArguments.altitude,u=this.functionArguments.azimuth,
y=this.functionArguments.zFactor;1===this.functionArguments.hillshadeType&&(y*=2);var x=y/(8*t),z=y/(8*r);.001<y&&v.spatialReference.wkid&&null==n[v.spatialReference.wkid]&&(x/=111E3,z/=111E3);var B=this.functionArguments.psPower,E=this.functionArguments.psFactor;3===this.functionArguments.slopeType&&((x=v.spatialReference.wkid&&null==n[v.spatialReference.wkid])?(x=111E3*t,z=111E3*r,x=(y+Math.pow(x,B)*E)/(8*x),z=(y+Math.pow(z,B)*E)/(8*z)):(x=(y+Math.pow(t,B)*E)/(8*t),z=(y+Math.pow(r,B)*E)/(8*r)));
var I=(90-w)*Math.PI/180;w=Math.cos(I);var C=(360-u+90)*Math.PI/180;u=Math.sin(I)*Math.cos(C);I=Math.sin(I)*Math.sin(C);B=Array(6);E=Array(6);v=Array(6);var A=this._weights,F;if(1===this.functionArguments.hillshadeType){var G=this._azimuths.length;for(F=0;F<G;F++)w=this._altitudes[F],u=this._azimuths[F],I=(90-w)*Math.PI/180,w=Math.cos(I),C=(360-u+90)*Math.PI/180,u=Math.sin(I)*Math.cos(C),I=Math.sin(I)*Math.sin(C),B[F]=w,E[F]=u,v[F]=I}else B[0]=w,E[0]=u,v[0]=I;B=B.map(function(O){return parseFloat(O)});
E=E.map(function(O){return parseFloat(O)});v=v.map(function(O){return parseFloat(O)});this._setUniforms({u_cellSize:[t,r],u_zfactor:y,u_xFactor:x,u_yFactor:z,u_sinZcosA:u,u_sinZsinA:I,u_cosZ:w,u_sinZcosAs:E,u_sinZsinAs:v,u_cosZs:B,u_weights:A,u_hillshadeType:this.functionArguments.hillshadeType,u_resolution:h&&h.raster&&h.raster.pixelBlock?[1/h.raster.pixelBlock.width,1/h.raster.pixelBlock.height]:[1/p,1/k],u_scaled:!this.renderTexture,u_applyColorramp:this._clrTexture?!0:!1,u_minValue:this.srcStatistics[0].min,
u_maxValue:this.srcStatistics[0].max,u_indexedColormapOffset:this._indexedColormapOffset||0,u_indexedColormapMaxIndex:this._indexedColormap?this._indexedColormap.length/4-1:0});this._clrTexture&&this._bindTexture(this._clrTexture,"u_image1");this._bindTexture(d.texture,"u_image");this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:d.extent,texture:f.texture}},_initializeColormap:function(){this._indexedColormapOffset=0;var h=this._indexedColormap,d=this.functionArguments.colorRamp;
this.functionArguments.colormap?(this._alphaSpecified=(d=l.buildIndexedColormap(this.functionArguments.colormap))&&d.alphaSpecified,this._indexedColormap=d&&d.indexedColormap,this._indexedColormapOffset=d&&d.offset):d?(this._indexedColormap="multipart"===d.type?this.invert?m.createMultiPartColorRamp(this._invertColorRamp(d)):m.createMultiPartColorRamp(d):this.invert?m.createAlgorithmicColorRamp(this._invertColorRamp(d)):m.createAlgorithmicColorRamp(d),d.fromColor&&d.toColor&&"000"===d.fromColor.slice(0,
3).join("")&&"255255255"===d.toColor.slice(0,3).join("")&&(this._clrTexture=this._indexedColormap=null)):this.functionArguments.colormapName?"random"===this.functionArguments.colormapName.toLowerCase()&&(this._indexedColormap=m.createRandomColorRamp()):this._clrTexture=this._indexedColormap=null;if(h&&this._indexedColormap){d=!0;for(var f=0;f<h.length;f++)if(h[f]!==this._indexedColormap[f]){d=!1;break}d||(this._clrTexture=null)}},_setupColormapTexture:function(h){var d=this._createTexture(),f=this.gl,
k=h.length/4,p=new Float32Array(h.length),v;for(v=0;v<h.length;v++)p[v]=h[v]/255;f.getExtension("OES_texture_float");f.texImage2D(f.TEXTURE_2D,0,f.RGBA,k,1,0,f.RGBA,f.FLOAT,p);return d}})})},"esri/layers/rasterLib/function/LocalFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin ./rasterUtils".split(" "),function(H,g,q,m,n,e,c){return H([q,e],{declaredClass:"esri.layers.rasterLib.function.LocalFunction",functionName:"Local",
supportWebGL:!0,support2D:!0,constructor:function(a){this.functionArguments=this.mixinIgnoreCase({operation:null,rasters:null},a)},bind:function(a){a=this.getSourceRasterInfo(a);var b=0;a.raster?b=a.raster.bandCount:a.rasters&&(b=Math.max.apply(null,a.rasters.map(function(l){return l.bandCount})));if(0===b)return Error("The raster input to local function is invalid. It only takes single band input.");a=a.raster||a.rasters.filter(function(l){return!!l.extent})[0];this.rasterInfo=g.mixin(a,{bandCount:1,
pixelType:this._calculatePixelType(this.pixelType,"F32"),statistics:null,histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType="Generic";return!0},read2D:function(a){var b=[];b=a.raster?a.raster2?[a.raster,a.raster2]:[a.raster]:a.rasters;a=b.map(function(k){return k.pixelBlock});var l=this.functionArguments.operation;if(null===l)return b[0];this._performance.start();var h=this._getOperations(),d=h.operators[l-1];h=h.functors[l-1];
if(!this.functionArguments.rasters){if(1!==d)throw"no sufficient rasters, require "+d;}else if(999!==d&&this.functionArguments.rasters.length!==d)throw"number of rasters does not meet (short or exceed) the operation requirment, require "+d;var f=31===l?c.isNull(a[0]):50===l?c.setNull(a[0]):c.local(a,{rasterCountNeeded:d,functor:h});"Unknown"!==this.pixelType&&(f.pixelType=this.pixelType,f.pixels=f.pixels.map(g.hitch(this,function(k){return this._clampBand(k,f.pixelType)})));f.statistics||f.calculateStatistics();
return{extent:b[0].extent,pixelBlock:f}},readGL:function(a){this._performance.start();var b=this.functionArguments.operation,l=this._getWebGLOperations(),h=l.operators[b-1],d=n.local;l="result\x3d"+l.functors[b-1]+";";31!==b&&50!==b&&(l+="result \x3d vec4(result.rgb, a.a);");d=d.replace("vec4 replaceme"+h+";",l);l=this.gl.getParameter(this.gl.VERSION);var f="";if(-1<l.toLowerCase().indexOf("webgl 1.0")||-1<l.toLowerCase().indexOf("webgl 0."))f=this._getPolyfill(b);d=d.replace("vec4 polyfill;",f);
1<h&&(d=d.replace("gl_FragColor \x3d localOp1();","gl_FragColor \x3d localOp1();".replace("1",h.toString())));this._initializeProgram({fragment:d,fragmentName:"Local"});b=a.rasters;if(null!=b&&0!==b.length){b=b.length;l=this.bindFrameBuffer();for(h=0;h<b;h++){d=0<h?h.toString():"";var k=this._setupTextureData(a.rasters[h],{reCreate:!0});this._bindTexture(k.texture,"u_image"+d)}this._setUniforms({});this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:k.extent,texture:l.texture}}},
_getOperations:function(){return{operators:[2,2,2,1,2,1,1,1,1,1,2,2,1,2,2,2,2,1,2,2,1,1,2,2,1,1,1,2,2,1,1,1,2,2,1,1,1,999,999,999,999,999,999,2,1,2,999,1,1,1,1,1,1,999,999,1,1,999,1,1,2,2,2,999,999,999,999,999,999,999,999,999,999,3],functors:[function(a,b){return a+b},function(a,b){return a-b},function(a,b){return a*b},function(a){return Math.sqrt(a)},function(a,b){return Math.pow(a,b)},function(a){return Math.acos(a)},function(a){return Math.asin(a)},function(a){return Math.atan(a)},function(a){return Math.atanh(a)},
function(a){return Math.abs(a)},function(a,b){return a&b},function(a,b){return a<<b},function(a){return~a},function(a,b){return a|b},function(a,b){return a>>b},function(a,b){return a^b},function(a,b){return a&&b},function(a){return!a},function(a,b){return a||b},function(a,b){return a!=b},function(a){return Math.cos(a)},function(a,b){return Math.cosh(a)},function(a,b){return a/b},function(a,b){return a==b},function(a){return Math.exp(a)},function(a){return Math.pow(10,a)},function(a){return Math.pow(2,
a)},function(a,b){return a>b?1:0},function(a,b){return a>=b?1:0},function(a,b){return Math.floor(a)},function(a){return!a},function(a){return a},function(a,b){return a<b?1:0},function(a,b){return a<=b?1:0},function(a){return Math.log(a)},function(a,b){return Math.log10(a)},function(a,b){return Math.log2(a)},999,999,999,999,999,999,function(a,b){return a%b},function(a){return-a},function(a,b){return a!=b?1:0},999,function(a,b){return Math.floor(a)},function(a,b){return Math.ceil(a)},function(a,b){return b?
0:a},function(a,b){return Math.sin(a)},function(a,b){return Math.sinh(a)},function(a,b){return a*a},999,999,function(a){return Math.tan(a)},function(a){return Math.tanh(a)},999,function(a){return Math.acosh(a)},function(a){return Math.asinh(a)},function(a,b){return Math.atan2(a,b)},function(a,b){return a/b},function(a,b){return Math.floor(a/b)},999,999,999,999,999,999,999,999,999,999,function(a,b,l){return a?b:l}]}},_polyfill:{sinh:"vec4 sinh(vec4 x) {\nvec4 halfexp \x3d exp(x)/2.0;\nreturn halfexp - 1.0/halfexp;\n}",
asinh:"vec4 asinh(vec4 x) {\nvec4 halfexp \x3d exp(x)/2.0;\nreturn 1.0/(halfexp - 1.0/halfexp);\n}",cosh:"vec4 cosh(vec4 x) {\nvec4 halfexp \x3d exp(x)/2.0;\nreturn halfexp + 1.0/halfexp;\n}",acosh:"vec4 acosh(vec4 x) {\nvec4 halfexp \x3d exp(x)/2.0;\nreturn 1.0/(halfexp + 1.0/halfexp);\n}",tanh:"vec4 tanh(vec4 x) {\nvec4 expx \x3d exp(x);\nreturn (expx - 1.0/expx)/(expx + 1.0/expx);\n}",atanh:"vec4 atanh(vec4 x) {\nvec4 expx \x3d exp(x);\nreturn (expx + 1.0/expx)/(expx - 1.0/expx);\n}"},_getPolyfill:function(a){var b=
"";switch(a){case 9:b=this._polyfill.atanh;break;case 22:b=this._polyfill.cosh;break;case 52:b=this._polyfill.sinh;break;case 57:b=this._polyfill.tanh;break;case 59:b=this._polyfill.acosh;break;case 60:b=this._polyfill.asinh}return b},_getWebGLOperations:function(){return{operators:[2,2,2,1,2,1,1,1,1,1,2,2,1,2,2,2,2,1,2,2,1,1,2,2,1,1,1,2,2,1,1,1,2,2,1,1,1,999,999,999,999,999,999,2,1,2,999,1,1,1,1,1,1,999,999,1,1,999,1,1,2,2,2,999,999,999,999,999,999,999,999,999,999,3],functors:["(a + b)","(a - b)",
"(a * b)","sqrt(a)","pow(a, b)","acos(a)","asin(a)","atan(a)","atanh(a)","abs(a)","a","a","a","a","a","a","(a.r\x3d\x3d0.0 || b.r\x3d\x3d0.0) ? vec4(0.0,0.0,0.0,a.a) : vec4(1.0,1.0,1.0,a.a)","a.r\x3d\x3d0.0?vec4(1.0,1.0,1.0,a.a) : vec4(0.0,0.0,0.0,a.a)","(a.r\x3d\x3d0.0 \x26\x26 b.r\x3d\x3d0.0) ? vec4(0.0,0.0,0.0,a.a) : vec4(1.0,1.0,1.0,a.a)","(a.r\x3d\x3d0.0 ^^ b.r\x3d\x3d0.0) ? vec4(1.0,1.0,1.0,a.a) : vec4(0.0,0.0,0.0,a.a)","cos(a)","cosh(a)","a / b","a.r \x3d\x3d b.r? vec4(1.0,1.0,1.0,a.a) : vec4(0.0,0.0,0.0,a.a)",
"exp(a)","pow(10.0, a)","pow(2.0, a)","a.r \x3e b.r ? vec4(1.0,1.0,1.0,a.a) : vec4(0.0,0.0,0.0,a.a)","a.r \x3e\x3d b.r ? vec4(1.0,1.0,1.0,a.a) : vec4(0.0,0.0,0.0,a.a)","floor(a)","a.a \x3d\x3d 0.0? vec4(1.0,1.0,1.0,1.0) : vec4(0.0,0.0,0.0,1.0)","a","a.r \x3c b.r ? vec4(1.0,1.0,1.0,a.a) : vec4(0.0,0.0,0.0,a.a)","a.r \x3c\x3d b.r ? vec4(1.0,1.0,1.0,a.a) : vec4(0.0,0.0,0.0,a.a)","log(a)","log2(a) / log2(10.0)","log2(a)",999,999,999,999,999,999,"mod(a, b)","-a","a.r !\x3d b.r ? vec4(1.0,1.0,1.0,a.a) : vec4(0.0,0.0,0.0,a.a)",
999,"floor(a)","ceil(a)","a.r !\x3d 0.0 ? vec4(0.0,0.0,0.0,0.0) : a","sin(a)","sinh(a)","a * a",999,999,"tan(a)","tanh(a)",999,"acosh(a)","asinh(a)","atan(a, b)","a / b","floor(a / b)",999,999,999,999,999,999,999,999,999,999,"a.r!\x3d0 ? b : c"]}}})})},"esri/layers/rasterLib/function/MaskFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin ./rasterUtils".split(" "),function(H,g,q,m,n,e,c){return H([q,e],{declaredClass:"esri.layers.rasterLib.function.MaskFunction",
functionName:"Mask",supportWebGL:!0,support2D:!0,constructor:function(a){this.functionArguments=this.mixinIgnoreCase({includedRanges:null,noDataInterpretation:0,noDataValues:null,raster:null},a)},bind:function(a){a=this.getSourceRasterInfo(a);if(!a.raster)return Error("The raster input to mask function is invalid.");this.rasterInfo=g.mixin(a.raster,{bandCount:a.raster.bandCount,pixelType:this._calculatePixelType(this.pixelType,a.raster.pixelType),statistics:a.raster.statistics,histograms:a.raster.histograms});
return!0},read2D:function(a){this._performance.start();a=a.raster;var b=c.mask(a.pixelBlock,{includedRanges:this.functionArguments.includedRanges,noDataInterpretation:this.functionArguments.noDataInterpretation,noDataValues:this.functionArguments.noDataValues});this._addPerformanceMetric(this._performance.elapsed());"Unknown"!==this.pixelType&&(b.pixelType=this.pixelType);return{extent:a.extent,pixelBlock:b}},readGL:function(a){this._performance.start();this._initializeProgram({fragment:n.mask,fragmentName:"Mask"});
a=this._setupTextureData(a.raster);var b=this.bindFrameBuffer(),l=this.functionArguments.includedRanges,h=this.functionArguments.noDataValues?this.functionArguments.noDataValues.map(function(d){return parseFloat(d,10)}):null;this._setUniforms({u_includedRanges:l,u_includedRanges_specified:l?!0:!1,u_noDataValues:h,u_noDataValues_specified:h?!0:!1,u_noDataInterpretation:this.functionArguments.noDataInterpretation,u_bandCount:Math.min(this.sourceRasterInfo.raster.bandCount,3)});this._bindTexture(a.texture,
"u_image");this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:a.extent,texture:b.texture}}})})},"esri/layers/rasterLib/function/NDVIFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin ./rasterIndex".split(" "),function(H,g,q,m,n,e,c){return H([q,e],{declaredClass:"esri.layers.rasterLib.function.NDVIFunction",functionName:"NDVI",supportWebGL:!0,support2D:!0,constructor:function(a){this.functionArguments=
this.mixinIgnoreCase({visibleBandID:1,infraredBandID:2,scaled:!0,raster:null},a)},bind:function(a){a=this.getSourceRasterInfo(a);if(!(a.raster&&1<a.raster.bandCount))return Error("The raster input to ndvi function is invalid. It requires more than 1 band.");this.rasterInfo=g.mixin(a.raster,{bandCount:1,pixelType:this._calculatePixelType(this.pixelType,this.scaled?"U8":"F32"),statistics:this.scaled?[{min:0,max:200}]:[{min:-1,max:1}],histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||
{};this.rasterInfo.keyProperties.DataType="Generic";return!0},read2D:function(a){this._performance.start();a=a.raster;var b=c.calculate(a.pixelBlock,{bandIndexes:[this.functionArguments.infraredBandID+1,this.functionArguments.visibleBandID+1].join(" "),method:1}),l;if(this.functionArguments.scaled){var h=b.pixels[0];var d=b.mask;var f=h.length;var k=new Uint8Array(f);if(null==d)for(l=0;l<f;l++)k[l]=100*h[l]+100&255;else for(l=0;l<f;l++)d[l]&&(k[l]=100*h[l]+100&255);b.pixels[0]=k;b.pixelType="U8"}this._addPerformanceMetric(this._performance.elapsed());
"Unknown"!==this.pixelType&&(b.pixelType=this.pixelType);return{extent:a.extent,pixelBlock:b}},readGL:function(a){this._performance.start();this._initializeProgram({fragment:n.ndvi,fragmentName:"NDVI"});var b=this.functionArguments.visibleBandID,l=this.functionArguments.infraredBandID,h=this.functionArguments.scaled||!1;this._alterBand=2<Math.max(l,b)?!0:!1;a=this._setupTextureData(a.raster,{bandIDs:this._alterBand?{bandIDs:[l,b,l]}:null});var d=this.bindFrameBuffer();this._alterBand?this._setUniforms({u_bandId_nir:0,
u_bandId_red:1,u_scaled:h}):this._setUniforms({u_bandId_nir:l,u_bandId_red:b,u_scaled:h});this._bindTexture(a.texture,"u_image");this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:a.extent,texture:d.texture}}})})},"esri/layers/rasterLib/function/SlopeFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../../WKIDUnitConversion ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin ./surfaceUtils".split(" "),function(H,g,q,m,n,e,
c,a){return H([q,c],{declaredClass:"esri.layers.rasterLib.function.SlopeFunction",functionName:"Slope",supportWebGL:!0,support2D:!0,constructor:function(b){this.functionArguments=this.mixinIgnoreCase({zFactor:1,slopeType:1,psPower:.664,psFactor:.024,raster:null},b)},bind:function(b){b=this.getSourceRasterInfo(b);if(!b.raster)return Error("The raster input to slope function is invalid.");this.rasterInfo=g.mixin(b.raster,{bandCount:1,pixelType:this._calculatePixelType(this.outputPixelType,"F32"),statistics:1===
this.slopeType||3===this.slopeType?[{min:0,max:90}]:null,histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType="Generic";return!0},read2D:function(b){this._performance.start();b=b.raster;b=a.slope(b,{zFactor:this.functionArguments.zFactor,psPower:this.functionArguments.psPower,psFactor:this.functionArguments.psFactor,slopeType:this.functionArguments.slopeType,isGCS:b.extent.spatialReference.wkid&&null==m[b.extent.spatialReference.wkid]});
this._addPerformanceMetric(this._performance.elapsed());return b},readGL:function(b){this._performance.start();this._initializeProgram({fragment:e.slope,fragmentName:"Slope"});var l=this._setupTextureData(b.raster),h=this.bindFrameBuffer(),d=this.gl,f=d.drawingBufferWidth;d=d.drawingBufferHeight;var k=l.extent;this._setUniforms({u_resolution:b&&b.raster&&b.raster.pixelBlock?[1/b.raster.pixelBlock.width,1/b.raster.pixelBlock.height]:[1/f,1/d],u_cellSize:[(k.xmax-k.xmin)/f,(k.ymax-k.ymin)/d],u_zfactor:this.functionArguments.zFactor});
this._bindTexture(l.texture,"u_image");this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:l.extent,texture:h.texture}}})})},"esri/layers/rasterLib/function/StretchFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./vertexShaders ./pixelShaders ./RasterFunctionWebGLMixin".split(" "),function(H,g,q,m,n,e,c){return H([q,c],{declaredClass:"esri.layers.rasterLib.function.StretchFunction",functionName:"Stretch",supportWebGL:!0,
support2D:!0,constructor:function(a){this.functionArguments=this.mixinIgnoreCase({stretchType:0,min:0,max:255,numberOfStandardDeviations:2,statistics:null,histograms:null,dra:!1,minPercent:.25,maxPercent:.5,useGamma:!1,gamma:null,raster:null,computeGamma:!1},a);this.functionArguments.statistics=this._convertStats(this.functionArguments.statistics);-1===[0,3,5,6].indexOf(this.functionArguments.stretchType)&&(console.error("The specific stretch type has not been implemented: "+this.functionArguments.stretchType),
this.functionArguments.stretchType=5);this.min=null==this.min?0:this.min;this.max=null==this.max?255:this.max},bind:function(a){a=this.getSourceRasterInfo(a);if(!a.raster)return Error("The raster input to stretch function is invalid.");a.raster.statistics&&(this.srcStatistics=this._convertStats(a.raster.statistics));a.raster.histograms&&(this.srcHistograms=a.raster.histograms);this.rasterInfo=g.mixin({},a.raster,{bandCount:a.raster.bandCount,pixelType:this._calculatePixelType(this.pixelType,"U8"),
statistics:null,histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType="Generic";return!0},read2D:function(a){a=a.raster;this._stretch(a);return a},hasTilingEffects:function(a){a=a||this.functionArguments;return!!(a.dra||a.raster&&"object"===typeof a.raster&&a.raster.dra)},_convertStats:function(a){return a?a.map(function(b){return b&&null!=b.min?[b.min,b.max,b.mean,b.stddev]:b}):null},_updateStatistisHistograms:function(a){var b=this.functionArguments,
l=b.histograms||this.srcHistograms;if(a&&a.pixelBlock&&a.pixelBlock.pixels){if(0===b.stretchType)this._statistics=b.statistics&&0<b.statistics.length?b.statistics:this.srcStatistics,this._histograms=l;else{var h=a.pixelBlock,d=h.pixels.length,f=6===b.stretchType&&(b.dra||!l)||3===b.stretchType&&b.dra;f&&(h.statistics||h.calculateStatistics(),this._calculateStatisticsHistograms(a));if(b.dra)if(h.statistics||h.calculateStatistics(),f)this._statistics=h.statistics,this._histograms=h.histograms;else for(b=
h.statistics,this._statistics=[],a=0;a<d;a++)this._statistics[a]=[b[a].minValue,b[a].maxValue,0,0];else this._statistics=b.statistics&&0<b.statistics.length?b.statistics:this.srcStatistics,this._histograms=l}this._statistics=this._convertStats(this._statistics);this._gammaCorrection=this._getGammaCorrection()}else this._statistics=b.statistics&&0<b.statistics.length?b.statistics:this.srcStatistics,this._histograms=l,this._gammaCorrection=this._getGammaCorrection(),this._statistics=this._convertStats(this._statistics)},
_getGammaCorrection:function(){var a=this.functionArguments.gamma;if(a){var b=[],l;for(l=0;l<a.length;l++)b[l]=1<a[l]?2<a[l]?6.5+Math.pow(a[l]-2,2.5):6.5+100*Math.pow(2-a[l],4):1;return b}},_stretch:function(a){if(null!==a&&null!==a.pixelBlock&&null!==a.pixelBlock.pixels&&0!==this.functionArguments.stretchType){this._updateStatistisHistograms(a);var b=a.pixelBlock,l=b.pixels;b=b.width*b.height;var h=l.length,d,f;this._createLUT(a);if(null==this.LUT)return this._filterNoLUT(a);var k=this.LUT,p=this.LUTOffset;
for(d=0;d<h;d++){var v=k[d];for(f=0;f<b;f++){var t=l[d][f];l[d][f]=v[t-p]}}a.pixelBlock.pixelType="U8"}},_calculateStatisticsHistograms:function(a){a=a.pixelBlock;var b=a.pixelType,l=a.pixels,h=a.mask,d=l.length,f,k,p=function(E){this.min=-.5;this.max=255.5;this.size=256;g.mixin(this,E);this.counts=this.counts||new Uint32Array(this.size)},v=[],t,r;for(f=0;f<d;f++){var w=new p;var u=w.counts;var y=l[f];if("U8"===b)if(h)for(k=0;k<a.width*a.height;k++)h[k]&&u[y[k]]++;else for(k=0;k<a.width*a.height;k++)u[y[k]]++;
else{var x=a.statistics[f].minValue;var z=a.statistics[f].maxValue;w.min=x;w.max=z;z=(z-x)/256;var B=new Uint32Array(257);if(h)for(k=0;k<a.width*a.height;k++)h[k]&&B[Math.floor((y[k]-x)/z)]++;else for(k=0;k<a.width*a.height;k++)B[Math.floor((y[k]-x)/z)]++;for(k=0;255>k;k++)u[k]=B[k];u[255]=B[255]+B[256]}v.push(w);y=[];x=a.statistics[f].minValue;z=a.statistics[f].maxValue;for(k=r=t=B=0;k<w.size;k++)B+=u[k],t+=k*u[k];t/=B;for(k=0;k<w.size;k++)r+=u[k]*Math.pow(k-t,2);u=Math.sqrt(r/(B-1));k=(t+.5)*(w.max-
w.min)/w.size+w.min;w=u*(w.max-w.min)/w.size;y.push(x);y.push(z);y.push(k);y.push(w);a.statistics[f]={min:x,minValue:x,max:z,maxValue:z,mean:k,stddev:w}}a.histograms=v},_getCutOffPoints:function(a){var b=this.functionArguments,l=999;a&&a.pixelBlock?l=a.pixelBlock.pixels.length:a&&a.texture&&(l=3);a=Math.min(l,this._statistics.length);var h=[],d=[],f,k;switch(b.stretchType){case 5:for(f=0;f<a;f++)h[f]=this._statistics[f][0],d[f]=this._statistics[f][1];break;case 3:for(f=0;f<a;f++)h[f]=this._statistics[f][2]-
b.numberOfStandardDeviations*this._statistics[f][3],d[f]=this._statistics[f][2]+b.numberOfStandardDeviations*this._statistics[f][3],h[f]<this._statistics[f][0]&&(h[f]=this._statistics[f][0]),d[f]>this._statistics[f][1]&&(d[f]=this._statistics[f][1]);break;case 6:for(f=0;f<a;f++){l=this._histograms[f];var p=new Uint32Array(l.size);var v=l.counts;var t=0;var r=-.5===l.min&&1===(l.max-l.min)/v?.5:0;for(k=0;k<l.size;k++)t+=v[k],p[k]=t;v=b.minPercent*t/100;for(k=0;k<l.size;k++)if(p[k]>v){h[f]=l.min+(l.max-
l.min)/l.size*(k+r);break}v=(1-b.maxPercent/100)*t;for(k=l.size-2;0<=k;k--)if(p[k]<v){d[f]=l.min+(l.max-l.min)/l.size*(k+2-r);break}}break;default:for(f=0;f<l;f++)h[f]=0,d[f]=255}return{minCutOff:h,maxCutOff:d}},_createLUT:function(a){var b=this.functionArguments,l=a.pixelBlock,h=l.pixelType;if("U8"===h||"U16"===h||"S8"===h||"S16"===h){if(this._LUTSignature&&(h=this._computeLutSignature(),h.length===this._LUTSignature.length&&!h.some(function(I,C){return I!==this._LUTSignature[C]}.bind(this))))return;
h=l.pixels.length;var d=[],f=[],k=b.max,p=b.min,v=b.gamma,t=k-p,r=this._getCutOffPoints(a);a=r.minCutOff;r=r.maxCutOff;var w=0,u=256;"S8"===l.pixelType?w=-127:"S16"===l.pixelType&&(w=-32767);if("U16"===l.pixelType||"S16"===l.pixelType)u=65536;for(l=0;l<h;l++)d[l]=r[l]-a[l];var y=this._gammaCorrection;if(b.useGamma)for(l=0;l<h;l++){var x=[];for(b=0;b<u;b++){var z=b+w;var B=(z-a[l])/d[l];var E=1;1<v[l]&&(E-=Math.pow(1/t,B*y[l]));z<r[l]&&z>a[l]?x[b]=Math.floor(E*t*Math.pow(B,1/v[l]))+p:z>r[l]?x[b]=k:
z<a[l]&&(x[b]=p)}f[l]=x}else for(l=0;l<h;l++){x=[];for(b=0;b<u;b++)z=b+w,x[b]=z<a[l]?p:z>r[l]?k:Math.floor((z-a[l])/d[l]*t)+p;f[l]=x}this.LUT=f;this.LUTOffset=w;this._LUTSignature=this._computeLutSignature()}},_computeLutSignature:function(){var a=this.functionArguments,b=[],l,h;b.push(a.stretchType);b.push(a.min);b.push(a.max);b.push(a.numberOfStandardDeviations);if(this._statistics)for(l=0;l<this._statistics.length;l++)for(h=0;h<this._statistics[l].length;h++)b.push(this._statistics[l][h]);b.push(a.dra?
1:0);b.push(a.minPercent);b.push(a.maxPercent);if(a.gamma)for(l=0;l<this._statistics.length;l++)b.push(a.gamma[l]);b.push(a.useGamma?1:0);return b},_filterNoLUT:function(a){if(null!==a&&null!==a.pixelBlock&&null!==a.pixelBlock.pixels){var b=this.functionArguments,l=a.pixelBlock,h=l.pixels,d=l.mask;l=l.width*l.height;var f=h.length,k=[],p=[],v=b.max,t=b.min,r=b.gamma,w=v-t;var u=this._getCutOffPoints(a);var y=u.minCutOff,x=u.maxCutOff;for(u=0;u<f;u++)k[u]=x[u]-y[u];if(b.useGamma&&null!==r&&r.length>=
f)for(u=0;u<f;u++)p[u]=1<r[u]?2<r[u]?6.5+Math.pow(r[u]-2,2.5):6.5+100*Math.pow(2-r[u],4):1;if(b.useGamma)if(void 0!==d&&null!==d)for(b=0;b<l;b++){if(d[b])for(u=0;u<f;u++){var z=h[u][b];var B=(z-y[u])/k[u];var E=1;1<r[u]&&(E-=Math.pow(1/w,B*p[u]));z<x[u]&&z>y[u]?h[u][b]=Math.floor(E*w*Math.pow(B,1/r[u]))+t:z>x[u]?h[u][b]=v:z<y[u]&&(h[u][b]=t)}}else for(b=0;b<l;b++)for(u=0;u<f;u++)z=h[u][b],B=(z-y[u])/k[u],E=1,1<r[u]&&(E-=Math.pow(1/w,B*p[u])),z<x[u]&&z>y[u]?h[u][b]=Math.floor(E*w*Math.pow(B,1/r[u]))+
t:z>x[u]?h[u][b]=v:z<y[u]&&(h[u][b]=t);else if(void 0!==d&&null!==d)for(b=0;b<l;b++){if(d[b])for(u=0;u<f;u++)z=h[u][b],z<x[u]&&z>y[u]?h[u][b]=Math.floor((z-y[u])/k[u]*w)+t:z>x[u]?h[u][b]=v:z<y[u]&&(h[u][b]=t)}else for(b=0;b<l;b++)for(u=0;u<f;u++)z=h[u][b],z<x[u]&&z>y[u]?h[u][b]=Math.floor((z-y[u])/k[u]*w)+t:z>x[u]?h[u][b]=v:z<y[u]&&(h[u][b]=t);a.pixelBlock.pixelType="U8";return a}},_computeGammaValues:function(a){var b=this._statistics.length,l,h=[];for(l=0;l<b;l++){var d=this._statistics[l][2];"U8"!==
a&&(d=255*(d-this._statistics[l][0])/(this._statistics[l][1]-this._statistics[l][0]));h.push(this._computeGammaValue(d))}return h},_computeGammaValue:function(a){if(0!==a&&!(255<a||0>a)){var b=0;0<a&&150!=a&&255>a&&(b=150>=a?45*Math.cos(.01047*a):17*Math.sin(.021*a));b=Math.log((a+b)/255);if(0!==b&&(a=Math.log(a/255)/b,!isNaN(a)))return Math.min(9.9,Math.max(.01,a))}},readGL:function(a){return this._stretchGL(a.raster)},_stretchGL:function(a){this._performance.start();var b=this.renderTexture,l,h=
a.pixelBlock&&a.pixelBlock.pixels&&a.pixelBlock.pixels.length||this.sourceRasterInfo.raster.bandCount,d=a.pixelBlock,f=this.gl,k=f.drawingBufferWidth,p=f.drawingBufferHeight;if(!d&&this.functionArguments.dra){var v=new Float32Array(k*p*4),t=new Uint8Array(k*p);var r=new Float32Array(k*p);var w=new Float32Array(k*p);var u=new Float32Array(k*p);f.checkFramebufferStatus(f.FRAMEBUFFER)==f.FRAMEBUFFER_COMPLETE&&f.readPixels(0,0,k,p,f.RGBA,f.FLOAT,v);for(l=0;l<k*p;l++)r[l]=v[4*l],w[l]=v[4*l+1],u[l]=v[4*
l+2],t[l]=v[4*l+3];a.pixelBlock=new m({width:k,height:p,pixels:[r,w,u],mask:t});a.pixelBlock.calculateStatistics()}!d&&this.functionArguments.dra&&this._useGPUStats?(r=new Float32Array(h),w=new Float32Array(h)):(this._updateStatistisHistograms(a),v=this._getCutOffPoints(a),r=new Float32Array(h),w=new Float32Array(h),r.set(v.minCutOff.slice(0,h)),w.set(v.maxCutOff.slice(0,h)));this._initializeProgram({fragment:e.stretch,fragmentName:"Stretch"});v=this._setupTextureData(a);t=this.bindFrameBuffer();
this.renderTexture=!1;this._performance.start();if(!d&&this.functionArguments.dra&&this._useGPUStats){this._setUniforms({u_sourceDim:[k,p],u_bandCount:h});if(1===h)var y=this._readMinMax(v,2);else{y=this._readMinMax(v,0);var x=this._readMinMax(v,1)}if(6===this.functionArguments.stretchType||3===this.functionArguments.stretchType&&this.functionArguments.dra)l=this._readHistogram(y,x,a),r=l.minCutOff||r,w=l.minCutOff||w}u=this.functionArguments.max-this.functionArguments.min;a=new Float32Array(h);for(l=
0;l<h;l++)a[l]=u/(w[l]-r[l]);this._useGPUStats&&this._initializeProgram({fragment:e.stretch,fragmentName:"Stretch"});f.blendFunc(f.SRC_ALPHA,f.ZERO);u=new Float32Array(3);var z=new Float32Array(3);for(l=0;3>l;l++)u[l]=this.functionArguments.min,z[l]=this.functionArguments.max;l=this.functionArguments.useGamma;var B=this.functionArguments.gamma,E=this._gammaCorrection;Array.isArray(B)&&B.length>=h||(l=!1);this._setUniforms({u_sourceDim:[k,p],u_bandCount:h,u_minOutput:u,u_maxOutput:z,u_minCutOff:r,
u_maxCutOff:w,u_factor:a,u_state:100,u_useGamma:l,u_gamma:B,u_scaled:!b,u_gammaCorrection:E,u_minMaxTexture:!d&&this.functionArguments.dra&&this._useGPUStats?!0:!1});this.renderTexture=b;f.viewport(0,0,k,p);this._bindTexture(v.texture,"u_image");!d&&this.functionArguments.dra&&this._useGPUStats&&(b=f.getUniformLocation(this.rasterProgram,"u_image1"),f.uniform1i(b,1),f.activeTexture(f.TEXTURE1),f.bindTexture(f.TEXTURE_2D,y.texture),1<h&&(h=f.getUniformLocation(this.rasterProgram,"u_image2"),f.uniform1i(h,
2),f.activeTexture(f.TEXTURE2),f.bindTexture(f.TEXTURE_2D,x.texture)));this._drawGL();return{extent:v.extent,texture:t.texture}},_readMinMax:function(a,b){var l=this.gl,h=a.width||l.drawingBufferWidth,d=a.height||l.drawingBufferHeight;this._setUniforms({u_state:b});this.renderTexture=!1;var f=a.texture;for(l.activeTexture(l.TEXTURE0);1<h||1<d;){var k=this._createTexture();b=Math.max(Math.ceil(h/2),1);var p=Math.max(Math.ceil(d/2),1);l.getExtension("OES_texture_float");l.texImage2D(l.TEXTURE_2D,0,
l.RGBA,b,p,0,l.RGBA,l.FLOAT,null);a=l.createFramebuffer();l.bindFramebuffer(l.FRAMEBUFFER,a);l.framebufferTexture2D(l.FRAMEBUFFER,l.COLOR_ATTACHMENT0,l.TEXTURE_2D,k,0);l.viewport(0,0,b,p);l.bindTexture(l.TEXTURE_2D,f);this._setUniforms({u_sourceDim:[h,d]});h=b;d=p;this._drawGL(!0);f=k}a=new Float32Array(h*d*4);l.checkFramebufferStatus(l.FRAMEBUFFER)==l.FRAMEBUFFER_COMPLETE&&l.readPixels(0,0,h,d,l.RGBA,l.FLOAT,a);return{texture:k,minmax:a}},_readHistogram:function(a,b,l){if(a)try{var h=this.gl,d=h.drawingBufferWidth,
f=h.drawingBufferHeight,k,p,v;if(a.texture instanceof WebGLTexture){var t=!0;var r=[1,0,0,1];if(b){var w=a.minmax;var u=b.minmax}else w=[a.minmax[0]],u=[a.minmax[1]]}else for(u=b,w=a,r=new Float32Array(u.length),k=0;k<u.length;k++)r[k]=256/(u[k]-w[k]);var y=new Float32Array(d*f);for(v=0;v<y.length;v++)y[v]=v;if(!this.histogramProgram){var x=n.getShader(h,n.histogram),z=e.getShader(h,e.constant);this.histogramProgram=this._loadProgram(x,z)}h.blendFunc(h.ONE,h.ONE);h.enable(h.BLEND);h.useProgram(this.histogramProgram);
var B=h.getAttribLocation(this.histogramProgram,"a_pixelIndex"),E=h.createBuffer();h.bindBuffer(h.ARRAY_BUFFER,E);h.bufferData(h.ARRAY_BUFFER,y,h.STATIC_DRAW);h.enableVertexAttribArray(B);h.vertexAttribPointer(B,1,h.FLOAT,!1,0,0);var I=this._setupHistTexture(l),C=this._createTexture();h.getExtension("OES_texture_float");h.texImage2D(h.TEXTURE_2D,0,h.RGBA,257,1,0,h.RGBA,h.FLOAT,null);var A=h.createFramebuffer();h.bindFramebuffer(h.FRAMEBUFFER,A);h.framebufferTexture2D(h.FRAMEBUFFER,h.COLOR_ATTACHMENT0,
h.TEXTURE_2D,C,0);h.viewport(0,0,257,1);var F=h.getUniformLocation(this.histogramProgram,"u_image");h.uniform1i(F,0);h.activeTexture(h.TEXTURE0);h.bindTexture(h.TEXTURE_2D,I);var G=h.getUniformLocation(this.histogramProgram,"u_sourceDim");h.uniform2f(G,d,f);var O=h.getUniformLocation(this.histogramProgram,"u_bandCount");h.uniform1i(O,3);var N=h.getUniformLocation(this.histogramProgram,"u_halfPixel");h.uniform2f(N,.5/d,.5/f);var R=h.getUniformLocation(this.histogramProgram,"u_minMaxTexture");if(t){h.uniform1i(R,
1);var T=h.getUniformLocation(this.histogramProgram,"u_image1");h.uniform1i(T,1);h.activeTexture(h.TEXTURE1);h.bindTexture(h.TEXTURE_2D,a.texture);if(b){var W=h.getUniformLocation(this.histogramProgram,"u_image2");h.uniform1i(W,2);h.activeTexture(h.TEXTURE2);h.bindTexture(h.TEXTURE_2D,b.texture)}}else{var Y=h.getUniformLocation(this.histogramProgram,"u_mins");h.uniform4f(Y,w[0],w[0],w[0],w[0]);h.uniform1i(R,0)}var Z=h.getUniformLocation(this.histogramProgram,"u_color"),J=h.getUniformLocation(this.histogramProgram,
"u_factors"),P=h.getUniformLocation(this.histogramProgram,"u_size");h.uniform1f(P,256);a=[];b=[];h.uniform4fv(Z,[1,0,0,1]);h.uniform4fv(J,[r[0],0,0,1]);h.drawArrays(h.POINTS,0,y.length);var U=this.sourceRasterInfo.raster.bandCount;1<U&&(h.uniform4fv(Z,[0,1,0,1]),h.uniform4fv(J,[0,r[0],0,1]),h.drawArrays(h.POINTS,0,y.length),h.uniform4fv(Z,[0,0,1,1]),h.uniform4fv(J,[0,0,r[0],1]),h.drawArrays(h.POINTS,0,y.length));if(h.checkFramebufferStatus(h.FRAMEBUFFER)==h.FRAMEBUFFER_COMPLETE){var V=new Float32Array(1028);
h.readPixels(0,0,257,1,h.RGBA,h.FLOAT,V);h=0;var D=-.5===w[0]&&1===(u[0]-w[0])/256?.5:0;for(k=0;k<U;k++){var K=new Float32Array(257);var L=new Float32Array(257);for(v=h=0;256>v;v++)h+=V[4*v+k],K[v]=h,L[v]=V[4*v+k];L[256]=V[1024+k];K[256]=h+V[1024+k];var M=this.functionArguments.minPercent*h/100;if(u){for(p=0;256>p;p++)if(K[p]>M){a[k]=w[0]+(u[0]-w[0])/256*(p+D);break}M=(1-this.functionArguments.maxPercent/100)*h;for(p=254;0<=p;p--)if(K[p]<M){b[k]=w[0]+(u[0]-w[0])/256*(p+2-D);break}}}}return{histogram:V,
minCutOff:a,maxCutOff:b}}catch(Q){console.debug("webgl filter exception: "+Q.message)}},_setupHistTexture:function(a){if(a instanceof WebGLTexture)return a;var b=this.originalHistTexture=this._createTexture(),l=this.gl;a=a.pixelBlock;var h=a.width,d=a.height;l.getExtension("OES_texture_float");this.rgbaFloatData=a.getAsRGBAFloat();l.texImage2D(l.TEXTURE_2D,0,l.RGBA,h,d,0,l.RGBA,l.FLOAT,this.rgbaFloatData);return b}})})},"esri/layers/rasterLib/function/RemapFunction":function(){define("dojo/_base/declare dojo/_base/lang ../../../renderers/colorRampGenerator ./RasterFunctionX ./pixelShaders ./RasterFunctionWebGLMixin ./rasterUtils".split(" "),
function(H,g,q,m,n,e,c){return H([m,e],{declaredClass:"esri.layers.rasterLib.function.RemapFunction",functionName:"Remap",pixelType:"U8",renderTexture:!1,supportWebGL:!0,support2D:!0,constructor:function(a){this.functionArguments=this.mixinIgnoreCase({inputRanges:null,outputValues:null,outputColors:null,colorBreaks:null,raster:null},a)},bind:function(a){a=this.getSourceRasterInfo(a);if(!a.raster)return Error("The raster input is not available.");var b=!(!this.functionArguments.outputColors&&!this.functionArguments.colorBreaks);
this.rasterInfo=g.mixin(a.raster,{bandCount:b?3:1,pixelType:this._calculatePixelType(this.pixelType,"U8"),statistics:null,histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType=b?"Processed":"Thematic";return!0},read2D:function(a){return this._remap(a.raster)},readGL:function(a){return this._remapGL(a.raster)},_remap:function(a){this._performance.start();var b=c.remapColor(a.pixelBlock,this.functionArguments.colorBreaks);this._addPerformanceMetric(this._performance.elapsed());
return{extent:a.extent,pixelBlock:b}},_remapGL:function(a){this._performance.start();this._initializeProgram({fragment:n.remap,fragmentName:"Remap"});var b=new Uint8Array(64),l=this.functionArguments.colorBreaks;l.forEach(function(k,p){b[4*p]=k.mappedColor[0];b[4*p+1]=k.mappedColor[1];b[4*p+2]=k.mappedColor[2];b[4*p+3]=1>=k.mappedColor[3]?255*k.mappedColor[3]:k.mappedColor[3]});var h=l[l.length-1],d=h.mappedColor;b[60]=d[0];b[61]=d[1];b[62]=d[2];b[63]=1>=d[3]?255*d[3]:d[3];var f=new Float32Array(16);
l.forEach(function(k,p){f[p]=k.value});f[15]=h.value;this._clrTexture||(this._clrTexture=this._setupColormapTexture(b));l=this._clrTexture;h=this.bindFrameBuffer();a=this._setupTextureData(a);this._setUniforms({u_indexedColormapOffset:0,u_indexedColormapMaxIndex:b.length/4-1,u_breaks:f});this._bindTexture(l,"u_image1");this._bindTexture(a.texture,"u_image");this._drawGL();return{extent:a.extent,texture:h.texture}},_setupColormapTexture:function(a){var b=this._createTexture(),l=a.length/4,h=new Float32Array(a.length),
d=this.renderTexture?255:1,f,k=this.gl;for(f=0;f<a.length;f++)h[f]=a[f]/d;k.getExtension("OES_texture_float");k.texImage2D(k.TEXTURE_2D,0,k.RGBA,l,1,0,k.RGBA,k.FLOAT,h);return b}})})},"esri/layers/rasterLib/function/IdentityFunction":function(){define(["dojo/_base/declare","dojo/_base/lang","./pixelShaders","./RasterFunctionX","./RasterFunctionWebGLMixin"],function(H,g,q,m,n){return H([m,n],{declaredClass:"esri.layers.rasterLib.function.IdentityFunction",functionName:"Identity",supportWebGL:!0,support2D:!0,
constructor:function(e){this.functionArguments={raster:null}},bind:function(e){e=this.getSourceRasterInfo(e);if(!e.raster)return Error("The raster input to identity function is invalid.");this.rasterInfo=g.mixin(e.raster,{});return!0},read2D:function(e){return e.raster},readGL:function(e){this._initializeProgram({fragment:q.identity,fragmentName:"identity"});e=this._setupTextureData(e.raster);var c=this.bindFrameBuffer();this._bindTexture(e.texture,"u_image");this._drawGL();return{extent:e.extent,
texture:c.texture}}})})},"esri/layers/rasterLib/function/ResampleFunction":function(){define(["dojo/_base/declare","dojo/_base/lang","./pixelShaders","./RasterFunctionX","./RasterFunctionWebGLMixin"],function(H,g,q,m,n){return H([m,n],{declaredClass:"esri.layers.rasterLib.function.ResampleFunction",renderTexture:!0,resamplingOrigin:null,resamplingRatio:null,zFactor:1,functionName:"Resample",supportWebGL:!0,support2D:!1,constructor:function(e){this.functionArguments=this.mixinIgnoreCase({resamplingType:0},
e)},bind:function(e){e=this.getSourceRasterInfo(e);if(!e.raster)return Error("The raster input to convolution function is invalid.");this.rasterInfo=g.mixin(e.raster,{bandCount:e.raster.bandCount,pixelType:this._calculatePixelType(this.pixelType,e.raster.pixelType),statistics:e.raster.statistics,histograms:e.raster.histograms});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};return!0},readGL:function(e){this._performance.start();this._initializeProgram({fragment:q.resample,fragmentName:"Resample"});
var c=this._setupTextureData(e.raster),a=this.bindFrameBuffer(),b=this.gl,l=b.drawingBufferWidth;b=b.drawingBufferHeight;var h=e.raster;void 0!==h.pixelBlock?(c=c||this._setupTextureData(h),e=h.pixelBlock.width,h=h.pixelBlock.height):(c=c||h,e=l,h=b);this._setUniforms({u_resamplingRatio:this.resamplingRatio||[e/l,h/b],u_anchor:this.resamplingOrigin||[0,1],u_resamplingType:this.functionArguments.resamplingType,u_resolution:[1/l,1/b]});this._drawGL();this._addPerformanceMetric(this._performance.elapsed());
return{extent:c.extent,texture:a.texture}}})})},"esri/layers/rasterLib/renderer/rasterRendererHelper":function(){define("dojo/_base/declare dojo/_base/lang ../../PixelBlock ./RasterColormapRenderer ./RasterUniqueValueRenderer ./RasterRGBRenderer ./RasterStretchColorRampRenderer ./RasterClassBreaksRenderer ./RasterShadedReliefRenderer".split(" "),function(H,g,q,m,n,e,c,a,b){var l=function(){function h(f){d[f.prototype.rendererName]=f}var d={};h(m);h(e);h(c);h(n);h(a);h(b);return d}();return{wellKnownRenderers:l,
isSupported:function(h){if(!h)return!1;var d=!0;l[h.rendererName]||(d=!1);return d},create:function(h){if(!h)return null;if(h.rendererName){var d=h.rendererName;h=h.rendererArguments}else d="uniqueValue rasterStretch rasterShadedRelief rgb rasterColormap classBreaks".split(" ").indexOf(h.type),d="UniqueValue Stretch ShadedRelief RGB Colormap ClassBreaks".split(" ")[d],"rasterStretch"===h.type&&h.bandIndex&&1<h.bandIndex.length&&(d="RGB");return(d=l[d])?new d(h):null},createDefaultRenderer:function(h){if(h&&
h.raster){var d=h.raster.rasterInfo,f=h.raster.dataType;if(d){var k=h.raster.rasterFunction,p=["Stretch","Colormap","ContrastAndBrightness"];if(k&&"U8"===d.pixelType&&-1<p.indexOf(k.functionName))k.renderTexture=!0;else if("Processed"!==f||!(h.useWebGL&&k&&k.renderTexture||!h.useWebGL&&"U8"===d.pixelType)){k&&(d=k.rasterInfo);k=d.bandCount;var v=d.colormap,t=d.vat;p=d.histograms;p&&0===p.length&&(p=null);var r=d.statistics&&d.statistics.map(function(y){return[y.min,y.max,y.mean,y.stddev]});if(1===
k&&v&&0<v.length)var w=this._getDefaultColormapRenderer(t,v);else if(1===k&&t&&t.features&&0<t.features.length)w=new n({});else{v=0;t=!1;f||!h.raster||!h.raster.tileInfo||void 0!==h.raster.tileInfo.tileType&&"Map"!==h.raster.tileInfo.tileType?"U8"===d.pixelType&&"Processed"===f?(v=5,r=r||[[0,255,0,0],[0,255,0,0],[0,255,0,0]],t=!1):"U8"===d.pixelType||"Elevation"===f?(v=5,t=r?!1:!0):"Scientific"===f||"StdTime"===f?(v=5,t=r?!1:!0,w=this._getDefaultScientificColorRamp()):p&&0<p.length?(v=6,t=!1):r?(v=
5,t=!1):(v=6,t=!0):(r=[[0,255,0,0],[0,255,0,0],[0,255,0,0]],v=5,t=!1);r||(v=5,t=!0);var u;3<=k&&!(h.bandIds||h.raster&&h.raster.imageServiceParams&&h.raster.imageServiceParams.bandIds)&&(u=this.getDefaultBandCombination(d));u&&(r=u.map(function(y){return r[y]}));h={stretchType:v,min:0,max:255,dra:t,minPercent:.25,maxPercent:.25,useGamma:!1,computeGamma:!1,statistics:r,histograms:p,numberOfStandardDeviations:2.5,bandIndex:u};1===k||u&&1===u.length?(w&&(h.colorRamp=w,h.invert=!1),w=new c(h)):w=new e(h)}return w}}}},
getDefaultBandCombination:function(h){var d=h.bandCount;if(1===d)return null;if(2===d)return[0];var f=(h=h.keyProperties)&&h.ChangeAnalysisParameters&&h.ChangeAnalysisParameters.AnalysisType;if(f&&("ccdc"===f.toLowerCase()||"landtrendr"===f.toLowerCase()))return[0];h=h&&h.BandProperties;var k;if(h&&h.length===d){var p=this.getWellKnownBandIndexes(h);h=p.red;f=p.green;var v=p.blue;p=p.nir;null!=h&&null!=f&&null!=v?k=[h,f,v]:null!=p&&null!=h&&null!=f&&(k=[p,h,f])}!k&&3<=d&&(k=[0,1,2]);return k},getWellKnownBandIndexes:function(h){for(var d=
{},f=0;f<h.length;f++){var k=h[f],p=k.BandName&&k.BandName.toLowerCase();"red"===p?d.red=f:"green"===p?d.green=f:"blue"===p?d.blue=f:"nearinfrared"===p||"nearinfrared_1"===p||"nir"===p?d.nir=f:k.WavelengthMax&&k.WavelengthMin&&(p=k.WavelengthMin,k=k.WavelengthMax,null==d.blue&&410<=p&&480>=p&&480<=k&&540>=k?d.blue=f:null==d.green&&490<=p&&560>=p&&560<=k&&610>=k?d.green=f:null==d.red&&595<=p&&670>=p&&660<=k&&730>=k?d.red=f:null==d.nir&&700<=p&&860>=p&&800<=k&&950>=k&&(d.nir=f))}return d},_getDefaultColormapRenderer:function(h,
d){if(d||d.length){var f=[],k=this._ratContainsColormap(h);if(k)var p=this._getRATValueClassNameMap(h);d.forEach(function(v){var t=p?p[v[0]]:v[0];f.push({color:[v[1],v[2],v[3]],value:v[0],label:k?null!=t?t:"":v[0]})});return new m({colormapInfos:f})}},_ratContainsColormap:function(h){if(!h||!h.fields)return!1;var d,f,k;return h.fields.some(function(p){p&&p.name&&(p=p.name.toLowerCase(),"red"===p&&(d=!0),"green"===p&&(f=!0),"blue"===p&&(k=!0));return d&&f&&k})},_getRATValueClassNameMap:function(h){if(!h||
!h.fields)return null;var d={},f,k;h.fields.forEach(function(p){if("classname"===p.name.toLowerCase()||"class_name"===p.name.toLowerCase())f=p.name;"value"===p.name.toLowerCase()&&(k=p.name)});h.features.forEach(function(p){p=p.attributes;d[p[k]]=f?p[f]:p[k]});return d},_getDefaultScientificColorRamp:function(){return{type:"multipart",colorRamps:[{fromColor:[255,0,0],toColor:[255,255,0]},{fromColor:[255,255,0],toColor:[0,255,255]},{fromColor:[0,255,255],toColor:[0,0,255]}].map(function(h){return{fromColor:h.toColor,
toColor:h.fromColor}}).reverse()}}}})},"esri/layers/rasterLib/renderer/RasterColormapRenderer":function(){define(["dojo/_base/declare","dojo/_base/lang","./RasterRenderer","../function/ColormapFunction"],function(H,g,q,m){return H([q],{declaredClass:"esri.layers.rasterLib.renderer.RasterColormapRenderer",rendererName:"Colormap",renderTexture:!0,constructor:function(n){n&&n.colormapInfos&&(n.colormap=n.colormapInfos.map(function(e){return[e.value].concat(e.color)}));this._function=new m(n);this._function.outputPixelType=
"U8";this._function.renderTexture=!0},draw2D:function(n){this._updateColormapParameters();n=this._clonePixelData(n);return n=this._function._colorize(n)},drawGL:function(n){this._updateColormapParameters();this._function._colorizeGL(n)},toJson:function(){var n=this._function.toJson().rasterFunctionArguments;return{rendererName:this.rendererName,rendererArguments:n}},toCommonRendererJson:function(){return{type:"rasterColormap",colormapInfos:this.colormapInfos||this.colormap.map(function(n){return{value:n[0],
color:n.slice(1),label:n[0]}})}},_updateColormapParameters:function(){var n=this._function.functionArguments;n.colormap=this.colormap;n.colormapName=this.colormapName;n.colorRamp=this.colorRamp;n.colorRampName=this.colorRampName}})})},"esri/layers/rasterLib/renderer/RasterRenderer":function(){define(["dojo/_base/declare","dojo/_base/lang","../../../geometry/Extent","../../PixelBlock"],function(H,g,q,m){return H(null,{declaredClass:"esri.layers.rasterLib.renderer.RasterRenderer",raster:null,constructor:function(n){n=
n||{};this.raster=n.raster||n.Raster||this.raster;this.draw=g.hitch(this,this.draw);this.bind=g.hitch(this,this.bind);n=g.clone(n);Object.keys(n).forEach(function(e){null==n[e]&&delete n[e]});g.mixin(this,n)},bind:function(n){if(!n)throw"failed to bind without options";var e=n;n.layer&&(n=n.layer,e={id:n.id,rawRasterInfo:n.raster.rasterInfo,glSetting:n._glSetting,xformSetting:n.tileManager&&n.tileManager.xformSetting,useWebGL:n.useWebGL,resampling:n.tileMode&&n.tileManager&&n.tileManager.xformSetting.requireProjection&&
!n._hasTilingEffects&&"Thematic"!==n.raster.dataType?1:0,tileMode:n.tileMode});this._rawRasterInfo=e.rawRasterInfo;this.useWebGL=e.useWebGL;this._function&&this._function.setProcessingContext(g.mixin({useProcessedData:!0},e));this._processingContext=e},hasTilingEffects:function(){},draw:function(n){return this.useWebGL?this.drawGL(n):this.draw2D(n)},toJson:function(){},_clonePixelData:function(n){if(null==n)return n;var e={};n.extent&&(e.extent=new q(n.extent.xmin,n.extent.ymin,n.extent.xmax,n.extent.ymax,
n.extent.spatialReference));n=n.processedPixelBlock||n.pixelBlock;if(null==n)return e;e.pixelBlock=n.clone?n.clone():m.prototype.clone(n);return e}})})},"esri/layers/rasterLib/renderer/RasterUniqueValueRenderer":function(){define(["dojo/_base/declare","dojo/_base/lang","./RasterRenderer","../function/ColormapFunction","../../../renderers/colorRampGenerator"],function(H,g,q,m,n){return H([q],{declaredClass:"esri.layers.rasterLib.renderer.RasterUniqueValueRenderer",rendererName:"UniqueValue",field:"",
alias:"",uniqueValueInfos:null,constructor:function(e){e&&e.colormap&&(this.colormap=e.colormap,this._function=new m(e),this._function.outputPixelType="U8",this._function.renderTexture=!0)},bind:function(e){this.inherited(arguments);if(!this._function){var c=(this.raster&&this.raster.rasterInfo||this._rawRasterInfo).vat;if(!c)throw"uv renderer requires data source to have raster attribute table";var a=this.attributeField||this.field1||this.field,b=this.infos||this.uniqueValueInfos;this.defaultColor=
this.defaultColor||this.defaultSymbol&&this.defaultSymbol.color;var l=c.fields.filter(function(w){return"value"===w.name.toLowerCase()})[0];if(l)var h=l.name;a||((a=c.fields.filter(function(w){return-1<["classname","category"].indexOf(w.name.toLowerCase())})[0])||(a=c.fields.filter(function(w){return"esriFieldTypeString"===w.type})[0]),this.alias=(this.field=a=a&&a.name||h)&&a.alias||h);var d=[],f;if(!b){b=[];var k=c.fields.filter(function(w){return"alpha"===w.name.toLowerCase()})[0];var p=c.fields.filter(function(w){return"red"===
w.name.toLowerCase()})[0];var v=c.fields.filter(function(w){return"green"===w.name.toLowerCase()})[0];var t=c.fields.filter(function(w){return"blue"===w.name.toLowerCase()})[0];for(l=0;l<c.features.length;l++){var r=c.features[l].attributes;(f=b.some(function(w){w.value===r[a]}))||(k&&p&&v&&t?b.push({value:r[a],alias:r[a],color:[r[p.name],r[v.name],r[t.name],r[k.name]]}):p&&v&&t?b.push({value:r[a],alias:r[a],color:[r[p.name],r[v.name],r[t.name]]}):b.push({value:r[a],alias:r[a]}))}if(!(p&&v&&t))for(f=
n.createRandomColorRamp({size:b.length}),l=0;l<b.length;l++)b[l].color=f[l];this.uniqueValueInfos=b}if(b)b.forEach(function(w){d=d.concat(c.features.filter(function(u){return w.value==u.attributes[a]}).map(function(u){return[u.attributes[h]].concat(w.color||w.symbol&&w.symbol.color)}))}),this.defaultColor&&c.features.filter(function(w){d.some(function(u){return u[0]===w.attributes[h]})||d.push([w.attributes[h]].concat(this.defaultColor))});else throw"missing uniqueValueInfos property";this._function=
new m({colormap:d});this.colormap=d;this._function.outputPixelType="U8";this._function.renderTexture=!0;this._function.setProcessingContext(this._processingContext)}},draw2D:function(e){e=this._clonePixelData(e);return e=this._function._colorize(e)},drawGL:function(e){this._function._colorizeGL(e)},toJson:function(e){var c={field:this.field,uniqueValueInfos:this.uniqueValueInfos,defaultColor:this.defaultColor};e&&(c.colormap=this.colormap);return{rendererName:this.rendererName,rendererArguments:c}},
toCommonRendererJson:function(){var e=this.attributeField||this.field1||this.field,c=(this.infos||this.uniqueValueInfos).map(function(a){return{value:a.value,label:a.alias+"",symbol:{color:3===a.color.length?a.color.concat([255]):a.color,type:"esriSFS",style:"esriSFSSolid"}}});return{type:"uniqueValue",field1:e,uniqueValueInfos:c}}})})},"esri/layers/rasterLib/renderer/RasterRGBRenderer":function(){define("dojo/_base/declare dojo/_base/lang ./RasterRenderer ../function/StretchFunction ../function/ContrastBrightnessFunction ../function/rasterUtils".split(" "),
function(H,g,q,m,n,e){return H([q],{declaredClass:"esri.layers.rasterLib.renderer.RasterRGBRenderer",rendererName:"RGB",bandIndex:null,stretchType:0,min:0,max:255,numberOfStandardDeviations:2,statistics:null,histograms:null,dra:!1,minPercent:.25,maxPercent:.5,useGamma:!1,gamma:null,computeGamma:!1,sigmoidStrengthLevel:1,constructor:function(c){this.stretchType="number"===typeof this.stretchType?this.stretchType:"none   standardDeviation histogramEqualization minMax percentClip   sigmoid".split(" ").indexOf(this.stretchType);
c=g.mixin({},c,{stretchType:this.stretchType});this._stretchFunction=new m(c);this._stretchFunction.outputPixelType="U8";this._stretchFunction.renderTexture=!1;this.bandIndex=c.bandIndex||c.BandIndex;this._function=new n(c);this._function.functionArguments.raster=this._stretchFunction;this._function.renderTexture=!0},hasTilingEffects:function(){return this._stretchFunction.hasTilingEffects()},draw2D:function(c){this._updateStretchParameters();c=this._clonePixelData(c);if("U8"===c.pixelBlock.pixelType&&
!this.contrastOffset&&!this.brightnessOffset)return c;this._stretchFunction._stretch(c);var a=c.pixelBlock,b=this.bandIndex,l=Math.max.apply(null,b);a&&a.pixels.length>l&&b&&(a.pixels=b.map(function(h){return a.pixels[h]}),a.statistics&&(a.statistics=b.map(function(h){return a.statistics[h]})));if(this.contrastOffset||this.brightnessOffset)c.pixelBlock=e.contrastBrightnessStretch(c.pixelBlock,{contrastOffset:this.contrastOffset,brightnessOffset:this.brightnessOffset});return c},drawGL:function(c){this._updateStretchParameters();
c.pixelBlock&&(c=this._clonePixelData(c));var a=c.pixelBlock,b=this.bandIndex,l=Math.max.apply(null,b),h=this.statistics&&0<this.statistics.length?this.statistics:this._stretchFunction&&this._stretchFunction.srcStatistics,d=this.histograms&&0<this.histograms.length?this.histograms:this._stretchFunction&&this._stretchFunction.srcHistograms,f,k;a&&a.pixels.length>l&&b&&(a.pixels=b.map(function(p){return a.pixels[p]}),a.statistics&&(a.statistics=b.map(function(p){return a.statistics[p]})),h&&0<h.length&&
h.length!==b.length&&(f=b.map(function(p){return h[p]})),d&&0<d.length&&d.length!==b.length&&(k=b.map(function(p){return d[p]})));this._stretchFunction.functionArguments.statistics=f||h;this._stretchFunction.functionArguments.histograms=k||d;this.contrastOffset||this.brightnessOffset?(this._stretchFunction.renderTexture=!1,this._function.renderTexture=!0,c=this._stretchFunction._stretchGL(c),this._function._cbGL(c)):(this._stretchFunction.renderTexture=!0,this._stretchFunction._stretchGL(c))},toJson:function(){var c=
this._stretchFunction.toJson().rasterFunctionArguments;c.bandIndex=this.bandIndex;c.contrastOffset=this.contrastOffset;c.brightnessOffset=this.brightnessOffset;return{rendererName:this.rendererName,rendererArguments:c}},toCommonRendererJson:function(){return{type:"rasterStretch",stretchType:"none   standardDeviation histogramEqualization minMax percentClip   sigmoid".split(" ")[this.stretchType]||"minMax",min:this.min,max:this.max,numberOfStandardDeviations:this.numberOfStandardDeviations,statistics:g.clone(this.statistics),
dra:this.dra,minPercent:this.minPercent,maxPercent:this.maxPercent,useGamma:this.useGamma,gamma:g.clone(this.gamma),computeGamma:this.computeGamma,sigmoidStrengthLevel:this.sigmoidStrengthLevel}},_updateStretchParameters:function(){var c=this._stretchFunction.functionArguments;c.stretchType=this.stretchType;c.min=this.min;c.max=this.max;c.numberOfStandardDeviations=this.numberOfStandardDeviations;c.statistics=this.statistics;c.histograms=this.histograms;c.dra=this.dra;c.minPercent=this.minPercent;
c.maxPercent=this.maxPercent;c.useGamma=this.useGamma;c.gamma=this.gamma;c.computeGamma=this.computeGamma;this._stretchFunction.interpolation=this.interpolation}})})},"esri/layers/rasterLib/renderer/RasterStretchColorRampRenderer":function(){define("dojo/_base/declare dojo/_base/lang ./RasterRenderer ../function/ResampleFunction ../function/StretchFunction ../function/ContrastBrightnessFunction ../function/ColormapFunction ../function/rasterUtils".split(" "),function(H,g,q,m,n,e,c,a){return H([q],
{declaredClass:"esri.layers.rasterLib.renderer.RasterStretchColorRampRenderer",rendererName:"Stretch",bandIndex:[0],colorRamp:null,invert:!1,stretchType:0,min:0,max:255,numberOfStandardDeviations:2,statistics:null,histograms:null,dra:!1,minPercent:.25,maxPercent:.5,useGamma:!1,gamma:null,computeGamma:!1,sigmoidStrengthLevel:1,constructor:function(b){this.stretchType="number"===typeof this.stretchType?this.stretchType:"none   standardDeviation histogramEqualization minMax percentClip   sigmoid".split(" ").indexOf(this.stretchType);
b=g.mixin({},b,{stretchType:this.stretchType});Object.keys(b).forEach(function(l){null==b[l]&&delete b[l]});this._function=new e(b);this._stretchFunction=new n(b);this._stretchFunction.outputPixelType="U8";this._stretchFunction.renderTexture=!1;this._clrFunction=new c(b);this._clrFunction.functionArguments.raster=this._stretchFunction;this._clrFunction.renderTexture=!1;this._function.functionArguments.raster=this._clrFunction},hasTilingEffects:function(){return this._stretchFunction.hasTilingEffects()},
draw2D:function(b){this._updateStretchParameters();b=this._clonePixelData(b);if("U8"===b.pixelBlock.pixelType&&!(this.contrastOffset||this.brightnessOffset||this.colorRamp))return b;this._stretchFunction._stretch(b);var l=b.pixelBlock,h=this.bandIndex?this.bandIndex[0]:0;l&&1<l.pixels.length&&l.pixels.length>h&&(l.pixels=[l.pixels[h]],l.statistics&&(l.statistics=[l.statistics[h]]));this.colorRamp&&(b=this._clrFunction._colorize(b));if(this.contrastOffset||this.brightnessOffset)b.pixelBlock=a.contrastBrightnessStretch(b.pixelBlock,
{contrastOffset:this.contrastOffset,brightnessOffset:this.brightnessOffset});return b},drawGL:function(b){this._updateStretchParameters();b.pixelBlock&&(b=this._clonePixelData(b));var l=b.pixelBlock,h=this.bandIndex?this.bandIndex[0]||0:0,d=this.statistics&&0<this.statistics.length?this.statistics:this._stretchFunction&&this._stretchFunction.srcStatistics,f=this.histograms&&0<this.histograms.length?this.histograms:this._stretchFunction&&this._stretchFunction.srcHistograms,k,p;l&&1<l.pixels.length&&
l.pixels.length>h&&(l.pixels=[l.pixels[h]],l.statistics&&(l.statistics=[l.statistics[h]]),d&&d.length>h&&(k=[d[h]]),f&&f.length>h&&(p=[f[h]]));this._stretchFunction.functionArguments.statistics=k||d;this._stretchFunction.functionArguments.histograms=p||f;l=!!this.colorRamp;this.contrastOffset||this.brightnessOffset?(this._stretchFunction.renderTexture=!1,this._clrFunction.renderTexture=!1,this._function.renderTexture=!0,b=this._stretchFunction._stretchGL(b),l&&(b=this._clrFunction._colorizeGL(b)),
this._function._cbGL(b)):l?(this._stretchFunction.renderTexture=!1,this._clrFunction.renderTexture=!0,b=this._stretchFunction._stretchGL(b),this._clrFunction._colorizeGL(b)):(this._stretchFunction.renderTexture=!0,this._stretchFunction._stretchGL(b))},toJson:function(){var b=this._stretchFunction.toJson().rasterFunctionArguments;b.colorRamp=this.colorRamp||"";this.invert&&(b.invert=!0);b.contrastOffset=this.contrastOffset;b.brightnessOffset=this.brightnessOffset;return{rendererName:this.rendererName,
rendererArguments:b}},toCommonRendererJson:function(){return{type:"rasterStretch",stretchType:"none   standardDeviation histogramEqualization minMax percentClip   sigmoid".split(" ")[this.stretchType]||"minMax",colorRamp:this.colorRamp&&this.colorRamp.toJson?this.colorRamp.toJson():this.colorRamp,min:this.min,max:this.max,numberOfStandardDeviations:this.numberOfStandardDeviations,statistics:g.clone(this.statistics),dra:this.dra,minPercent:this.minPercent,maxPercent:this.maxPercent,useGamma:this.useGamma,
gamma:g.clone(this.gamma),computeGamma:this.computeGamma,sigmoidStrengthLevel:this.sigmoidStrengthLevel}},_updateStretchParameters:function(){var b=this._stretchFunction.functionArguments;b.stretchType=this.stretchType;b.min=this.min;b.max=this.max;b.numberOfStandardDeviations=this.numberOfStandardDeviations;b.statistics=this.statistics;b.histograms=this.histograms;b.dra=this.dra;b.minPercent=this.minPercent;b.maxPercent=this.maxPercent;b.useGamma=this.useGamma;b.gamma=this.gamma;b.computeGamma=this.computeGamma;
this._stretchFunction.interpolation=this.interpolation}})})},"esri/layers/rasterLib/renderer/RasterClassBreaksRenderer":function(){define(["dojo/_base/declare","dojo/_base/lang","./RasterRenderer","../function/ColormapFunction","../function/RemapFunction"],function(H,g,q,m,n){return H([q],{declaredClass:"esri.layers.rasterLib.renderer.RasterClassBreaksRenderer",rendererName:"ClassBreaks",renderTexture:!0,constructor:function(e){e=e||{};this._function=new n(e);this._function.outputPixelType="U8";var c=
e.classBreakInfos;e=e.minValue;null!=e&&c&&(this._function.functionArguments.colorBreaks=this._getSortedColorBreaks(e,c))},bind:function(e){this.inherited(arguments);this.isColormapFunction=!1;var c=this.raster&&this.raster.rasterInfo||this._rawRasterInfo,a=c&&c.vat;if(a&&"u8"===c.pixelType.toLowerCase()&&this.classBreakInfos){var b=this.field;if(c=a.fields.filter(function(p){return"value"===p.name.toLowerCase()})[0])var l=c.name;var h=a.features.sort(function(p,v){return parseFloat(p.attributes[b])-
parseFloat(v.attributes[b])})[0].attributes[b];this.isColormapFunction=!0;var d=[],f=this.field,k=this.classBreakInfos;k.forEach(function(p,v){a.features.forEach(function(t){var r=k[v-1]&&k[v-1].classMaxValue||h;t.attributes[f]<=p.classMaxValue&&(t.attributes[f]>r||t.attributes[f]===h)&&(r=p.symbol.color,d.some(function(w){return w[0]===t.attributes[l]})||d.push([t.attributes[l]].concat(r)))})});this._function=new m({colormap:d});this.colormap=d;this._function.outputPixelType="U8";this._function.renderTexture=
!0}this._function&&this._function.setProcessingContext(g.mixin({useProcessedData:!0},this._processingContext))},draw2D:function(e){if(this.isColormapFunction)return this._updateColormapParameters(),e=this._clonePixelData(e),e=this._function._colorize(e);this._updateRemapParameters();return this._function._remap(e)},drawGL:function(e){this.isColormapFunction?(this._updateColormapParameters(),this._function._colorizeGL(e)):(this._function.renderTexture=!0,this._updateRemapParameters(),this._function._remapGL(e))},
toJson:function(){var e=this._function.toJson().rasterFunctionArguments;return{rendererName:this.rendererName,rendererArguments:e}},toCommonRendererJson:function(){var e,c=this.classBreakInfos,a=this.colorBreaks;if(null==c&&a)for(c=[],e=0;e<a.length-1;e++)c.push({classMaxValue:a[e+1].value,symbol:{color:a[e].mappedColor,type:"esriSFS",style:"esriSFSSolid"},label:a[e].value+" - "+a[e+1].value});return{type:"classBreaks",field:"Value",minValue:null!=this.minValue?this.minValue:a[0].value,classBreakInfos:c}},
_updateRemapParameters:function(){var e=this.classBreakInfos,c=this.minValue;null!=c&&e&&(this._function.functionArguments.colorBreaks=this._getSortedColorBreaks(c,e))},_getSortedColorBreaks:function(e,c){c=c.map(function(b){return{maxValue:b.classMaxValue,color:b.symbol.color}}).sort(function(b,l){return b.maxValue-l.maxValue});var a=[{value:e,mappedColor:c[0].color}];for(e=0;e<c.length;e++)a.push({value:c[e].maxValue,mappedColor:e===c.length-1?c[e].color:c[e+1].color});return a},_updateColormapParameters:function(){this._function.functionArguments.colormap=
this.colormap;this._function.interpolation=this.interpolation}})})},"esri/layers/rasterLib/renderer/RasterShadedReliefRenderer":function(){define("dojo/_base/declare dojo/_base/lang ./RasterRenderer ../function/HillshadeFunction ../function/ContrastBrightnessFunction ../function/ColormapFunction ../function/rasterUtils".split(" "),function(H,g,q,m,n,e,c){return H([q],{declaredClass:"esri.layers.rasterLib.renderer.RasterShadedReliefRenderer",rendererName:"ShadedRelief",hillshadeType:null,azimuth:315,
altitude:45,zFactor:1,slopeType:null,psPower:.664,psFactor:.024,raster:null,constructor:function(a){this.hillshadeType="number"===typeof this.hillshadeType?this.hillshadeType:["traditional","multi-directional"].indexOf(this.hillshadeType);a&&a.scalingType&&(this.slopeType="adjusted"===a.scalingType?3:1);a&&a.pixelSizePower&&(this.psPower=a.pixelSizePower);a&&a.pixelSizeFactor&&(this.psFactor=a.pixelSizeFactor);a=g.mixin({},a,{hillshadeType:this.hillshadeType,psPower:this.psPower,psFactor:this.psFactor,
slopeType:this.slopeType});Object.keys(a).forEach(function(b){null==a[b]&&delete a[b]});this._function=new n(a);this._hillshadeFunction=new m(a);this._hillshadeFunction.outputPixelType="U8";this._hillshadeFunction.renderTexture=!1;this._function.functionArguments.raster=this._hillshadeFunction},hasTilingEffects:function(){return this._hillshadeFunction.hasTilingEffects()},draw2D:function(a){this._updateHillshadeParameters();a=this._clonePixelData(a);a=this._hillshadeFunction.read2D({raster:a});if(this.contrastOffset||
this.brightnessOffset)a.pixelBlock=c.contrastBrightnessStretch(a.pixelBlock,{contrastOffset:this.contrastOffset,brightnessOffset:this.brightnessOffset});return a},drawGL:function(a){this._updateHillshadeParameters();this.contrastOffset||this.brightnessOffset?(this._hillshadeFunction.renderTexture=!1,this._function.renderTexture=!0,a=this._hillshadeFunction.readGL({raster:a}),this._function._cbGL(a)):(this._hillshadeFunction.renderTexture=!0,this._hillshadeFunction.readGL({raster:a}))},toJson:function(){var a=
this._hillshadeFunction.toJson().rasterFunctionArguments;a.colorRamp=this.colorRamp||"";this.invert&&(a.invert=!0);a.contrastOffset=this.contrastOffset;a.brightnessOffset=this.brightnessOffset;return{rendererName:this.rendererName,rendererArguments:a}},toCommonRendererJson:function(){return{type:"rasterShadedRelief",hillshadeType:["traditional","multi-directional"][this.hillshadeType]||"traditional",azimuth:this.azimuth,altitude:this.altitude,zFactor:this.zFactor,scalingType:3===this.slopeType?"adjusted":
"none",pixelSizePower:this.psPower,pixelSizeFactor:this.psFactor,colorRamp:this.colorRamp&&this.colorRamp.toJson?this.colorRamp.toJson():this.colorRamp}},_updateHillshadeParameters:function(){var a=this._hillshadeFunction.functionArguments;a.hillshadeType=this.hillshadeType;a.azimuth=this.azimuth;a.altitude=this.altitude;a.zFactor=this.zFactor;a.slopeType=this.slopeType;a.psPower=this.psPower;a.psFactor=this.psFactor}})})},"esri/layers/rasterLib/raster/rasterProjectionHelper":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/Deferred dojo/sniff ../../../kernel ../../../WKIDUnitConversion ../../../geometry/Extent ../../../geometry/projection ../../../geometry/webMercatorUtils ../../../SpatialReference ../../../geometry/Point".split(" "),
function(H,g,q,m,n,e,c,a,b,l,h){H={requirePE:function(f,k){return!(f.equals(k)||f._canProject(k))},load:function(){var f=new q;if(!this._loadPromise)if(a.isSupported())this._loadPromise=a.load();else{var k=new q;k.reject("projection engine is not supported on this version of the browser, please try with a modern browser");this._loadPromise=k.promise}this._loadPromise.isFulfilled()?this._loadPromise.isResolved()?f.resolve():this._loadPromise.isRejected()&&f.resolve():(this._pendingdfds=this._pendingdfds||
[],this._pendingdfds.push(f),this._loadPromise.then(g.hitch(this,function(){this._pendingdfds.forEach(function(p){p.isFulfilled()||p.resolve()})}),g.hitch(this,function(){this._pendingdfds.forEach(function(p){p.isFulfilled()||p.reject()})})));return f.promise},computeError:function(f,k){return[Math.abs((f[0]+f[4]+f[4*k.rows]+f[4*k.rows+4])/4-f[2*k.rows+2]),Math.abs((f[1]+f[5]+f[4*k.rows+1]+f[4*k.rows+5])/4-f[2*k.rows+3])]},getDefaultDatumTransformationForDataset:function(f,k,p){if(!(k&&f.spatialReference&&
this.requirePE(f.spatialReference,k)&&a.isLoaded()))return null;f=new c(f.toJson());k=new l(k.toJson());return p?a.getTransformation(k,f.spatialReference,f):a.getTransformation(f.spatialReference,k,f)},project:function(f,k,p){if(!k||f.spatialReference.equals(k))return f;var v=a.isLoaded()?a:b;"esri.geometry.Extent"===f.declaredClass?f=new c(f.toJson()):"esri.geometry.Point"===f.declaredClass&&(f=new h(f.toJson()));k=new l(k.toJson());(f=v.project(f,k))&&"esri.geometry.Extent"===f.declaredClass?(f=
new c(f.toJson()),p&&(1E-5>Math.abs(f.xmin+180)&&1E-5>Math.abs(f.xmax-180)?(f.xmin=0,f.xmax=360):(0>f.xmin&&(f.xmin+=360,f.xmax+=360),0>f.xmax&&(f.xmax+=360)))):f&&"esri.geometry.Point"===f.declaredClass&&(f=new h(f.toJson()),p&&0>f.x&&(f.x+=360));return f},projectResolution:function(f,k,p){var v=p.xmin+(p.xmax-p.xmin)/2;p=p.ymin+(p.ymax-p.ymin)/2;f=new c(v,p,v+f.x,p+f.y,f.spatialReference);f=this.project(f,k);return new h(f.xmax-f.xmin,f.ymax-f.ymin,k)},getProjectionOffsetGrid:function(f,k,p,v,t,
r,w){null==w&&(w=[32,32]);var u=f.xmin,y=f.ymin,x=f.xmax,z=f.ymax,B=f.spatialReference,E=k.spatialReference,I=a.isLoaded()?a:b,C=t?-t:null,A=w[0]*p.x,F=w[1]*p.y;x={cols:Math.ceil((x-u)/A)+1,rows:Math.ceil((z-y)/F)+1};f=[];for(z=0;z<x.cols;z++){var G=O;var O=[];for(p=0;p<x.rows;p++){var N=new h({x:u+A*z,y:y+F*p,spatialReference:B});N=I.project(N,E,r);if(!N)return null;v&&0>N.x&&(N.x+=360);O.push(N);0<z&&null!=C&&N.x<G[p].x&&(N.x+=t-C,N.x<G[p].x&&(N.x+=t-C));f.push((N.x-k.xmin)/(k.xmax-k.xmin));f.push((N.y-
k.ymin)/(k.ymax-k.ymin))}}k=this.computeError(f,x);v=new Float32Array((x.cols-1)*(x.rows-1)*12);t=new Float32Array([-0,-1,1,-1,1,-0,1,-0,-0]);r=new Float32Array([-1,1,0,0,-1,1,1,0,0]);for(z=0;z<x.cols-1;z++)for(p=0;p<x.rows-1;p++){A=z*x.rows*2+2*p;u=f[A];y=f[A+1];O=f[A+2];B=f[A+3];A+=2*x.rows;E=f[A];I=f[A+1];C=f[A+2];F=f[A+3];G=0;N=12*(p*(x.cols-1)+z);for(A=0;3>A;A++)v[N++]=t[G++]*u+t[G++]*O+t[G++]*C;for(A=G=0;3>A;A++)v[N++]=t[G++]*y+t[G++]*B+t[G++]*F;for(A=G=0;3>A;A++)v[N++]=r[G++]*u+r[G++]*E+r[G++]*
C;for(A=G=0;3>A;A++)v[N++]=r[G++]*y+r[G++]*I+r[G++]*F}return{offsets:f,error:k,coefficients:v,spacing:w,size:[x.cols-1,x.rows-1]}},getHalfWorldWidth:function(f){var k=f&&f.wkid;if(null!=k)return f.isWebMercator()&&(k=3857),null==e[k]?180:d[k]}};m("extend-esri")&&g.setObject("layers.rasterLib.raster.rasterProjectionHelper",H,n);var d={3395:2.0037508342789244E7,3410:1.7334193943686873E7,3832:3339584.723798206,3857:2.0037508342788905E7,3975:1.7367530445161372E7,4087:2.0037508342789244E7,4088:2.0015108787169147E7,
6933:1.7367530445161372E7,8858:7396237.374497803,8859:2465412.4581659334,32662:2.0037508342789244E7,53001:2.001508679602057E7,53002:1.000754339801029E7,53003:2.001508679602057E7,53004:2.001508679602057E7,53016:1.4152803599503474E7,53017:1.7333573624304302E7,53025:7276828.3848298555,53031:1.0384677558821043E7,53034:2.001508679602057E7,53036:7389443.187332862,53037:2463147.729110953,53079:2.0015114352186374E7,53080:2.0015114352186374E7,54001:2.0037508342789244E7,54002:1.0018754171394624E7,54003:2.0037508342789244E7,
54004:2.0037508342789244E7,54016:1.4168658027268292E7,54017:1.736753044516137E7,54025:7311399.09166516,54031:1.0396310810074743E7,54034:2.0037508342789244E7,54050:808820.9223376509,54053:1920897.3915568967,54079:2.0037508342789244E7,54080:2.0037508342789244E7,54099:1.3524439768288724E7,54100:2.0037508342789244E7,54101:2.0037508342789244E7,102038:4297258.582585486,102299:5013965.117483125};return H})},"esri/geometry/projection":function(){define("require exports dojo/Deferred ./pe ../SpatialReference ./GeographicTransformation".split(" "),
function(H,g,q,m,n,e){function c(d,f,k,p,v){void 0===p&&(p=null);void 0===v&&(v=!1);if(null===p){var t=e.cacheKey(f,k);void 0!==h[t]?p=h[t]:(p=a(f,k,null),null===p&&(p=new e),h[t]=p)}return b._project(d,f,k instanceof n||!1===v?k:new n(k),p,v)}function a(d,f,k){void 0===k&&(k=null);d=b._getTransformation(d,f,k);return null!==d?e.fromGE(d):null}Object.defineProperty(g,"__esModule",{value:!0});var b=null;g.isLoaded=function(){return!!b&&m.isLoaded()};g.isSupported=function(){return m.isSupported()};
var l=null;g.load=function(){if(l)return l.promise;l=new q;var d=m.load();H(["./geometryEngine"],function(f){b=f;d.then(function(){b._enableProjection(m);l.resolve()},function(k){l.reject(k)})});return l.promise};g.project=function(d,f,k){void 0===k&&(k=null);return d instanceof Array?0===d.length?[]:c(d,d[0].spatialReference,f,k):c([d],d.spatialReference,f,k)[0]};var h={};g.projectMany=c;g.getTransformation=a;g.getTransformations=function(d,f,k){void 0===k&&(k=null);d=b._getTransformationBySuitability(d,
f,k);if(null!==d){f=[];for(k=0;k<d.length;k++)f.push(e.fromGE(d[k]));return f}return[]}})},"esri/geometry/pe":function(){define(["require","exports","../core/tsSupport/extendsHelper","dojo/Deferred","../core/sniff"],function(H,g,q,m,n){function e(t){function r(x,z,B){x[z]=B(x[z])}g._pe=t;d.init();f.init();k.init();p.init();v.init();g.PeGCSExtent=function(x){function z(){return null!==x&&x.apply(this,arguments)||this}q(z,x);z.prototype.destroy=function(){g._pe.destroy(this)};return z}(g._pe.PeGCSExtent);
for(var w=0,u=[g._pe.PeDatum,g._pe.PeGeogcs,g._pe.PeGeogtran,g._pe.PeObject,g._pe.PeParameter,g._pe.PePrimem,g._pe.PeProjcs,g._pe.PeSpheroid,g._pe.PeUnit];w<u.length;w++)t=u[w],r(t.prototype,"getName",function(x){return function(){return x.call(this,Array(d.PE_NAME_MAX))}});w=0;for(u=[g._pe.PeGeogtran,g._pe.PeProjcs];w<u.length;w++)t=u[w],r(t.prototype,"getParameters",function(x){return function(){for(var z=Array(d.PE_PARM_MAX),B=x.call(this),E=0;E<z.length;E++){var I=g._pe.getValue(B,"*");z[E]=I?
g._pe.wrapPointer(I,g._pe.PeParameter):null;B+=Int32Array.BYTES_PER_ELEMENT}return z}});r(g._pe.PeHorizon.prototype,"getCoord",function(x){return function(){var z=this.getSize();if(!z)return null;var B=[],E=x.call(this);l(B,z,E);return B}});r(g._pe.PeGTlistExtendedEntry.prototype,"getEntries",function(x){var z=g._pe._pe_getPeGTlistExtendedGTsSize();return function(){var B=null,E=x.call(this);if(!g._pe.compare(E,g._pe.NULL)){B=[E];var I=this.getSteps();if(1<I){E=g._pe.getPointer(E);for(var C=1;C<I;C++)B.push(g._pe.wrapPointer(E+
z*C,g._pe.PeGTlistExtendedGTs))}}return B}});var y=g._pe._pe_getPeHorizonSize();t=function(x){return function(){var z=this._cache;z||(this._cache=z=new Map);if(z.has(x))return z.get(x);var B=null,E=x.call(this);if(!g._pe.compare(E,g._pe.NULL)){B=[E];var I=E.getNump();if(1<I){E=g._pe.getPointer(E);for(var C=1;C<I;C++)B.push(g._pe.wrapPointer(E+y*C,g._pe.PeHorizon))}}z.set(x,B);return B}};r(g._pe.PeProjcs.prototype,"horizonGcsGenerate",t);r(g._pe.PeProjcs.prototype,"horizonPcsGenerate",t);g._pe.PeObject.prototype.toString=
function(x){void 0===x&&(x=d.PE_STR_OPTS_NONE);g._pe.ensureCache.prepare();var z=g._pe.getPointer(this),B=g._pe.ensureInt8(Array(d.PE_BUFFER_MAX));return g._pe.UTF8ToString(g._pe._pe_object_to_string_ext(z,x,B))}}function c(t){if(t){var r=g._pe.getClass(t);r&&(r=g._pe.getCache(r))&&(t=g._pe.getPointer(t))&&delete r[t]}}function a(t,r){var w=[];r=Array(r);for(var u=0;u<t;u++)w.push(g._pe.ensureInt8(r));return w}function b(t){if(Array.isArray(t[0])){var r=[];t.forEach(function(w){r.push(w[0],w[1])})}else r=
t;return r}function l(t,r,w,u){void 0===u&&(u=!1);if(u)for(u=0;u<2*r;u++)t[u]=g._pe.getValue(w+u*Float64Array.BYTES_PER_ELEMENT,"double");else{var y=0===t.length;for(u=0;u<r;u++)y&&(t[u]=Array(2)),t[u][0]=g._pe.getValue(w,"double"),t[u][1]=g._pe.getValue(w+Float64Array.BYTES_PER_ELEMENT,"double"),w+=2*Float64Array.BYTES_PER_ELEMENT}}Object.defineProperty(g,"__esModule",{value:!0});var h;g._pe=null;g.isLoaded=function(){return!!g._pe};g.isSupported=function(){return!!n("esri-wasm")};g.load=function(){if(h)return h.promise;
h=new m;H(["./support/pe-wasm"],function(t){t({locateFile:function(r){return H.toUrl("./support/"+r)},onAbort:function(r){h.reject(Error(r))}}).then(function(r){e(r);h.resolve()})});return h.promise};(function(t){function r(y,x,z){g._pe.ensureCache.prepare();var B=b(z),E=z===B;B=g._pe.ensureFloat64(B);(y=g._pe._pe_geog_to_proj(g._pe.getPointer(y),x,B))&&l(z,x,B,E);return y}function w(y,x,z){return u(y,x,z,0)}function u(y,x,z,B){g._pe.ensureCache.prepare();var E=b(z),I=z===E;E=g._pe.ensureFloat64(E);
(y=g._pe._pe_proj_to_geog_center(g._pe.getPointer(y),x,E,B))&&l(z,x,E,I);return y}t.geogToProj=r;t.projGeog=function(y,x,z,B){switch(B){case d.PE_TRANSFORM_P_TO_G:return w(y,x,z);case d.PE_TRANSFORM_G_TO_P:return r(y,x,z)}return 0};t.projToGeog=w;t.projToGeogCenter=u})(g.PeCSTransformations||(g.PeCSTransformations={}));var d;(function(t){t.init=function(){t.PE_BUFFER_MAX=g._pe.PeDefs.prototype.PE_BUFFER_MAX;t.PE_NAME_MAX=g._pe.PeDefs.prototype.PE_NAME_MAX;t.PE_MGRS_MAX=g._pe.PeDefs.prototype.PE_MGRS_MAX;
t.PE_USNG_MAX=g._pe.PeDefs.prototype.PE_USNG_MAX;t.PE_DD_MAX=g._pe.PeDefs.prototype.PE_DD_MAX;t.PE_DDM_MAX=g._pe.PeDefs.prototype.PE_DDM_MAX;t.PE_DMS_MAX=g._pe.PeDefs.prototype.PE_DMS_MAX;t.PE_UTM_MAX=g._pe.PeDefs.prototype.PE_UTM_MAX;t.PE_PARM_MAX=g._pe.PeDefs.prototype.PE_PARM_MAX;t.PE_TYPE_NONE=g._pe.PeDefs.prototype.PE_TYPE_NONE;t.PE_TYPE_GEOGCS=g._pe.PeDefs.prototype.PE_TYPE_GEOGCS;t.PE_TYPE_PROJCS=g._pe.PeDefs.prototype.PE_TYPE_PROJCS;t.PE_TYPE_GEOGTRAN=g._pe.PeDefs.prototype.PE_TYPE_GEOGTRAN;
t.PE_TYPE_COORDSYS=g._pe.PeDefs.prototype.PE_TYPE_COORDSYS;t.PE_TYPE_UNIT=g._pe.PeDefs.prototype.PE_TYPE_UNIT;t.PE_STR_OPTS_NONE=g._pe.PeDefs.prototype.PE_STR_OPTS_NONE;t.PE_STR_AUTH_NONE=g._pe.PeDefs.prototype.PE_STR_AUTH_NONE;t.PE_STR_AUTH_TOP=g._pe.PeDefs.prototype.PE_STR_AUTH_TOP;t.PE_STR_NAME_CANON=g._pe.PeDefs.prototype.PE_STR_NAME_CANON;t.PE_PARM_X0=g._pe.PeDefs.prototype.PE_PARM_X0;t.PE_PARM_ND=g._pe.PeDefs.prototype.PE_PARM_ND;t.PE_TRANSFORM_1_TO_2=g._pe.PeDefs.prototype.PE_TRANSFORM_1_TO_2;
t.PE_TRANSFORM_2_TO_1=g._pe.PeDefs.prototype.PE_TRANSFORM_2_TO_1;t.PE_TRANSFORM_P_TO_G=g._pe.PeDefs.prototype.PE_TRANSFORM_P_TO_G;t.PE_TRANSFORM_G_TO_P=g._pe.PeDefs.prototype.PE_TRANSFORM_G_TO_P;t.PE_HORIZON_RECT=g._pe.PeDefs.prototype.PE_HORIZON_RECT;t.PE_HORIZON_POLY=g._pe.PeDefs.prototype.PE_HORIZON_POLY;t.PE_HORIZON_LINE=g._pe.PeDefs.prototype.PE_HORIZON_LINE;t.PE_HORIZON_DELTA=g._pe.PeDefs.prototype.PE_HORIZON_DELTA}})(d=g.PeDefs||(g.PeDefs={}));(function(t){function r(x,z){var B=null,E=u[x];
E||(E={},u[x]=E);E.hasOwnProperty(String(z))?B=E[z]:(x=g._pe.PeFactory.prototype.factoryByType(x,z),g._pe.compare(x,g._pe.NULL)||(B=x,E[z]=B));return B=w(B)}function w(x){if(x){var z=x.getType();switch(z){case d.PE_TYPE_GEOGCS:x=g._pe.castObject(x,g._pe.PeGeogcs);break;case d.PE_TYPE_PROJCS:x=g._pe.castObject(x,g._pe.PeProjcs);break;case d.PE_TYPE_GEOGTRAN:x=g._pe.castObject(x,g._pe.PeGeogtran);break;default:z&d.PE_TYPE_UNIT&&(x=g._pe.castObject(x,g._pe.PeUnit))}}return x}var u={},y={};t.initialize=
function(){g._pe.PeFactory.prototype.initialize(null)};t.coordsys=function(x){return r(d.PE_TYPE_COORDSYS,x)};t.factoryByType=r;t.fromString=function(x,z){var B=null,E=y[x];E||(E={},y[x]=E);E.hasOwnProperty(z)?B=E[z]:(x=g._pe.PeFactory.prototype.fromString(x,z),g._pe.compare(x,g._pe.NULL)||(B=x,E[z]=B));return B=w(B)};t.geogcs=function(x){return r(d.PE_TYPE_GEOGCS,x)};t.geogtran=function(x){return r(d.PE_TYPE_GEOGTRAN,x)};t.getCode=function(x){return g._pe.PeFactory.prototype.getCode(x)};t.projcs=
function(x){return r(d.PE_TYPE_PROJCS,x)};t.unit=function(x){return r(d.PE_TYPE_UNIT,x)}})(g.PeFactory||(g.PeFactory={}));g.PeGCSExtent=null;var f;(function(t){var r;t.init=function(){t.PE_GTLIST_OPTS_COMMON=g._pe.PeGTlistExtended.prototype.PE_GTLIST_OPTS_COMMON;r=g._pe._pe_getPeGTlistExtendedEntrySize()};t.getGTlist=function(w,u,y,x,z,B){var E=null,I=new g._pe.PeInteger(B);try{var C=g._pe.PeGTlistExtended.prototype.getGTlist(w,u,y,x,z,I);if(B=I.val)if(E=[C],1<B){var A=g._pe.getPointer(C);for(w=1;w<
B;w++)E.push(g._pe.wrapPointer(A+r*w,g._pe.PeGTlistExtendedEntry))}}finally{g._pe.destroy(I)}return E}})(f=g.PeGTlistExtended||(g.PeGTlistExtended={}));(function(t){t.destroy=function(r){if(r&&r.length){for(var w=0;w<r.length;w++){var u=r[w];c(u);u.getEntries().forEach(function(y){c(y);y=y.getGeogtran();c(y);y.getParameters().forEach(c);[y.getGeogcs1(),y.getGeogcs2()].forEach(function(x){c(x);var z=x.getDatum();c(z);c(z.getSpheroid());c(x.getPrimem());c(x.getUnit())})})}g._pe.PeGTlistExtendedEntry.prototype.Delete(r[0])}}})(g.PeGTlistExtendedEntry||
(g.PeGTlistExtendedEntry={}));(function(t){t.geogToGeog=function(r,w,u,y,x){g._pe.ensureCache.prepare();var z=b(u),B=u===z;z=g._pe.ensureFloat64(z);var E=0;y&&(E=g._pe.ensureFloat64(y));(r=g._pe._pe_geog_to_geog(g._pe.getPointer(r),w,z,E,x))&&l(u,w,z,B);return r}})(g.PeGTTransformations||(g.PeGTTransformations={}));(function(t){function r(u,y,x,z,B,E){g._pe.ensureCache.prepare();switch(u){case "dd":var I=g._pe._pe_geog_to_dd;var C=d.PE_DD_MAX;break;case "ddm":I=g._pe._pe_geog_to_ddm;C=d.PE_DDM_MAX;
break;case "dms":I=g._pe._pe_geog_to_dms,C=d.PE_DMS_MAX}u=0;y&&(u=g._pe.getPointer(y));y=b(z);y=g._pe.ensureFloat64(y);C=a(x,C);z=g._pe.ensureInt32(C);if(B=I(u,x,y,B,z))for(I=0;I<x;I++)E[I]=g._pe.UTF8ToString(C[I]);return B}function w(u,y,x,z,B){g._pe.ensureCache.prepare();switch(u){case "dd":var E=g._pe._pe_dd_to_geog;break;case "ddm":E=g._pe._pe_ddm_to_geog;break;case "dms":E=g._pe._pe_dms_to_geog}u=0;y&&(u=g._pe.getPointer(y));y=z.map(function(I){return g._pe.ensureString(I)});z=g._pe.ensureInt32(y);
y=g._pe.ensureFloat64(Array(2*x));(E=E(u,x,z,y))&&l(B,x,y);return E}t.geog_to_dms=function(u,y,x,z,B){return r("dms",u,y,x,z,B)};t.dms_to_geog=function(u,y,x,z){return w("dms",u,y,x,z)};t.geog_to_ddm=function(u,y,x,z,B){return r("ddm",u,y,x,z,B)};t.ddm_to_geog=function(u,y,x,z){return w("ddm",u,y,x,z)};t.geog_to_dd=function(u,y,x,z,B){return r("dd",u,y,x,z,B)};t.dd_to_geog=function(u,y,x,z){return w("dd",u,y,x,z)}})(g.PeNotationDms||(g.PeNotationDms={}));var k;(function(t){t.init=function(){t.PE_MGRS_STYLE_NEW=
g._pe.PeNotationMgrs.prototype.PE_MGRS_STYLE_NEW;t.PE_MGRS_STYLE_OLD=g._pe.PeNotationMgrs.prototype.PE_MGRS_STYLE_OLD;t.PE_MGRS_STYLE_AUTO=g._pe.PeNotationMgrs.prototype.PE_MGRS_STYLE_AUTO;t.PE_MGRS_180_ZONE_1_PLUS=g._pe.PeNotationMgrs.prototype.PE_MGRS_180_ZONE_1_PLUS;t.PE_MGRS_ADD_SPACES=g._pe.PeNotationMgrs.prototype.PE_MGRS_ADD_SPACES};t.geog_to_mgrs_extended=function(r,w,u,y,x,z,B){g._pe.ensureCache.prepare();var E=0;r&&(E=g._pe.getPointer(r));r=b(u);u=g._pe.ensureFloat64(r);r=a(w,d.PE_MGRS_MAX);
var I=g._pe.ensureInt32(r);if(y=g._pe._pe_geog_to_mgrs_extended(E,w,u,y,x,z,I))for(x=0;x<w;x++)B[x]=g._pe.UTF8ToString(r[x]);return y};t.mgrs_to_geog_extended=function(r,w,u,y,x){g._pe.ensureCache.prepare();var z=0;r&&(z=g._pe.getPointer(r));r=u.map(function(B){return g._pe.ensureString(B)});u=g._pe.ensureInt32(r);r=g._pe.ensureFloat64(Array(2*w));(y=g._pe._pe_mgrs_to_geog_extended(z,w,u,y,r))&&l(x,w,r);return y}})(k=g.PeNotationMgrs||(g.PeNotationMgrs={}));(function(t){t.geog_to_usng=function(r,
w,u,y,x,z,B){g._pe.ensureCache.prepare();var E=0;r&&(E=g._pe.getPointer(r));r=b(u);u=g._pe.ensureFloat64(r);r=a(w,d.PE_MGRS_MAX);var I=g._pe.ensureInt32(r);if(y=g._pe._pe_geog_to_usng(E,w,u,y,x,z,I))for(x=0;x<w;x++)B[x]=g._pe.UTF8ToString(r[x]);return y};t.usng_to_geog=function(r,w,u,y){g._pe.ensureCache.prepare();var x=0;r&&(x=g._pe.getPointer(r));r=u.map(function(z){return g._pe.ensureString(z)});u=g._pe.ensureInt32(r);r=g._pe.ensureFloat64(Array(2*w));(x=g._pe._pe_usng_to_geog(x,w,u,r))&&l(y,w,
r);return x}})(g.PeNotationUsng||(g.PeNotationUsng={}));var p;(function(t){t.init=function(){t.PE_UTM_OPTS_NONE=g._pe.PeNotationUtm.prototype.PE_UTM_OPTS_NONE;t.PE_UTM_OPTS_ADD_SPACES=g._pe.PeNotationUtm.prototype.PE_UTM_OPTS_ADD_SPACES;t.PE_UTM_OPTS_NS=g._pe.PeNotationUtm.prototype.PE_UTM_OPTS_NS};t.geog_to_utm=function(r,w,u,y,x){g._pe.ensureCache.prepare();var z=0;r&&(z=g._pe.getPointer(r));r=b(u);u=g._pe.ensureFloat64(r);r=a(w,d.PE_UTM_MAX);var B=g._pe.ensureInt32(r);if(y=g._pe._pe_geog_to_utm(z,
w,u,y,B))for(z=0;z<w;z++)x[z]=g._pe.UTF8ToString(r[z]);return y};t.utm_to_geog=function(r,w,u,y,x){g._pe.ensureCache.prepare();var z=0;r&&(z=g._pe.getPointer(r));r=u.map(function(B){return g._pe.ensureString(B)});u=g._pe.ensureInt32(r);r=g._pe.ensureFloat64(Array(2*w));(y=g._pe._pe_utm_to_geog(z,w,u,y,r))&&l(x,w,r);return y}})(p=g.PeNotationUtm||(g.PeNotationUtm={}));var v;(function(t){var r=new Map;t.init=function(){t.PE_PCSINFO_OPTION_NONE=g._pe.PePCSInfo.prototype.PE_PCSINFO_OPTION_NONE;t.PE_PCSINFO_OPTION_DOMAIN=
g._pe.PePCSInfo.prototype.PE_PCSINFO_OPTION_DOMAIN;t.PE_POLE_OUTSIDE_BOUNDARY=g._pe.PePCSInfo.prototype.PE_POLE_OUTSIDE_BOUNDARY;t.PE_POLE_POINT=g._pe.PePCSInfo.prototype.PE_POLE_POINT};t.generate=function(w,u){void 0===u&&(u=t.PE_PCSINFO_OPTION_DOMAIN);var y;if(r.has(w)){var x=r.get(w);x[u]&&(y=x[u])}y||(y=g._pe.PePCSInfo.prototype.generate(w,u),x||(x=[],r.set(w,x)),x[u]=y);return y}})(v=g.PePCSInfo||(g.PePCSInfo={}));(function(t){t.version_string=function(){return g._pe.PeVersion.prototype.version_string()}})(g.PeVersion||
(g.PeVersion={}));g._init=e})},"esri/core/tsSupport/extendsHelper":function(){define([],function(){return function(){var H=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(g,q){g.__proto__=q}||function(g,q){for(var m in q)q.hasOwnProperty(m)&&(g[m]=q[m])};return function(g,q){function m(){this.constructor=g}H(g,q);g.prototype=null===q?Object.create(q):(m.prototype=q.prototype,new m)}}()})},"esri/geometry/GeographicTransformation":function(){define(["require","exports","./GeographicTransformationStep"],
function(H,g,q){return function(){function m(n){this.steps=[];this._cached_projection={};this._chain="";this._gtlistentry=null;if(n&&n.steps){var e=0;for(n=n.steps;e<n.length;e++){var c=n[e];c instanceof q?this.steps.push(c):this.steps.push(new q({wkid:c.wkid,wkt:c.wkt,isInverse:c.isInverse}))}}}m.cacheKey=function(n,e){return[void 0!==n.wkid&&null!==n.wkid?n.wkid.toString():"-1",void 0!==n.wkt&&null!==n.wkt?n.wkt.toString():"",void 0!==e.wkid&&null!==e.wkid?e.wkid.toString():"-1",void 0!==e.wkt&&
null!==e.wkt?e.wkt.toString():""].join()};m.fromGE=function(n){var e=new m,c="",a=0;for(n=n.steps;a<n.length;a++){var b=q.fromGE(n[a]);e.steps.push(b);c+=b.uid.toString()+","}e._cached_projection={};e._gtlistentry=null;e._chain=c;return e};m.prototype.getInverse=function(){var n=new m;n.steps=[];for(var e=this.steps.length-1;0<=e;e--)n.steps.push(this.steps[e].getInverse());return n};m.prototype.getGTListEntry=function(){for(var n="",e=0,c=this.steps;e<c.length;e++)n+=c[e].uid.toString()+",";n!==
this._chain&&(this._gtlistentry=null,this._cached_projection={},this._chain=n);return this._gtlistentry};m.prototype.assignCachedGe=function(n,e,c){this._cached_projection[m.cacheKey(n,e)]=c};m.prototype.getCachedGeTransformation=function(n,e){for(var c="",a=0,b=this.steps;a<b.length;a++)c+=b[a].uid.toString()+",";c!==this._chain&&(this._gtlistentry=null,this._cached_projection={},this._chain=c);n=this._cached_projection[m.cacheKey(n,e)];return void 0===n?null:n};return m}()})},"esri/geometry/GeographicTransformationStep":function(){define(["require",
"exports"],function(H,g){var q=0;return function(){function m(n){void 0===n&&(n=null);this.uid=q++;n?(this._wkt=void 0!==n.wkt?n.wkt:null,this._wkid=void 0!==n.wkid?n.wkid:-1,this._isInverse=void 0!==n.isInverse?!0===n.isInverse:!1):(this._wkt=null,this._wkid=-1,this._isInverse=!1)}m.fromGE=function(n){var e=new m;e._wkt=n.wkt;e._wkid=n.wkid;e._isInverse=n.isInverse;return e};Object.defineProperty(m.prototype,"wkt",{get:function(){return this._wkt},set:function(n){this._wkt=n;this.uid=q++},enumerable:!0,
configurable:!0});Object.defineProperty(m.prototype,"wkid",{get:function(){return this._wkid},set:function(n){this._wkid=n;this.uid=q++},enumerable:!0,configurable:!0});Object.defineProperty(m.prototype,"isInverse",{get:function(){return this._isInverse},set:function(n){this._isInverse=n;this.uid=q++},enumerable:!0,configurable:!0});m.prototype.getInverse=function(){var n=new m;n._wkt=this.wkt;n._wkid=this._wkid;n._isInverse=!this.isInverse;return n};return m}()})},"esri/layers/rasterLib/raster/TileServiceRaster":function(){define("require dojo/_base/declare dojo/_base/lang dojo/_base/Deferred dojo/_base/array dojo/_base/config dojo/_base/json dojo/sniff dojo/DeferredList dojo/when ../../../kernel ../../../Evented ../../../request ../../../geometry/Extent ../../../geometry/Point ../../../SpatialReference ../../../deferredUtils ../../../urlUtils ../../PixelBlock ../../rasterFormats/rasterCodec ../tile/RasterTileInfo ./RasterInfo ./BasicRaster".split(" "),
function(H,g,q,m,n,e,c,a,b,l,h,d,f,k,p,v,t,r,w,u,y,x,z){H=g([z],{declaredClass:"esri.layers.rasterLib.raster.TileServiceRaster",constructor:function(B){},open:function(){var B=new m,E=this.serviceInfo||this._getServiceInfo(null),I=q.hitch(this,function(A){this.serviceInfo=A;this.version=A.currentVersion;this.rasterInfo=this._parseRasterInfo(A);this.loaded=!0;this._getRasterIdentifier();B.resolve(this)}),C=q.hitch(this,function(A){this.loaded=!0;this._getRasterIdentifier();B.reject(A)});l(E,I,C);return B.promise},
read:function(B){var E=this.url+"/tile/"+B.level+"/"+B.row+"/"+B.col,I={width:this.tileInfo.cols,height:this.tileInfo.rows,planes:null,pixelType:null,format:null,decodeFunc:null,isPoint:"elevation"===this.tileType.toLowerCase()?!0:!1};return this._requestPixels({url:E+(this.disableClientCaching?"?_ts\x3d "+(new Date).getTime():""),payload:{},decodeParams:I,tileOptions:B})},identify:function(B,E){null==E&&(E=this.tileInfo.lods[this.tileInfo.lods.length-1].level);var I=(B.x-this.tileInfo.origin.x)/
this.tileInfo.lods[E].resolution/this.tileInfo.cols;B=(this.tileInfo.origin.y-B.y)/this.tileInfo.lods[E].resolution/this.tileInfo.rows;var C=Math.floor(I),A=Math.floor(B),F=Math.floor((I-C)*this.tileInfo.cols);F=Math.min(F,this.tileInfo.cols-1);var G=Math.floor((B-A)*this.tileInfo.rows);G=Math.min(G,this.tileInfo.rows-1);var O=new m;this.read({level:E,row:A,col:C}).then(function(N){var R=G*N.width+F;N&&N.pixels&&0<N.pixels.length?(N=N.mask?N.mask[R]?N.pixels.map(function(T){return T[R]}):null:N.pixels.map(function(T){return T[R]}),
O.resolve(N)):O.reject("no valid data")},function(N){O.reject(N)});return O.promise},setFetchParameters:function(B,E){},_getRasterIdentifier:function(){this._rasterId||(this._rasterId=this.url.replace("http:","").replace("https:",""));return this._rasterId},_getServiceInfo:function(){var B=this.url,E=new m(t._dfdCanceller);E._pendingDfd=f({url:B,content:{f:"json"},handleAs:"json",callbackParamName:"callback"});E._pendingDfd.then(function(I){E.callback(I)},function(I){E.errback(I)});return E},_parseRasterInfo:function(B){var E=
new x;E.extent=new k(B.fullExtent);E.spatialReference=new v(B.spatialReference);this.tileType=B.cacheType||"Map";switch(this.tileType){case "Map":E.bandCount=3;E.pixelType="U8";this.dataType="Processed";break;case "Elevation":E.bandCount=1;E.pixelType=B.pixelType||"F32";this.dataType="Elevation";break;case "Raster":E.bandCount=null,E.pixelType=null,this.dataType=B.serviceDataType&&B.serviceDataType.replace("esriImageServiceDataType","")||"Generic"}var I=B.tileInfo;E.width=Math.floor((B.fullExtent.xmax-
B.fullExtent.xmin)/I.lods[I.lods.length-1].resolution+.5);E.height=Math.floor((B.fullExtent.ymax-B.fullExtent.ymin)/I.lods[I.lods.length-1].resolution+.5);E.cellSize=new p({x:I.lods[I.lods.length-1].resolution,y:I.lods[I.lods.length-1].resolution,spatialReference:B.spatialReference});this.tileInfo=new y(I);this.tileInfo.tileType=this.tileType;return E}});a("extend-esri")&&q.setObject("layers.rasterLib.raster.TileServiceRaster",H,h);return H})},"esri/layers/rasterLib/raster/TileRaster":function(){define("require dojo/_base/declare dojo/_base/lang dojo/_base/Deferred dojo/_base/array dojo/_base/config dojo/_base/json dojo/sniff dojo/DeferredList dojo/when ../../../kernel ../../../Evented ../../../request ../../../geometry/Extent ../../../geometry/Point ../../../SpatialReference ../../../deferredUtils ../../../urlUtils ../../PixelBlock ../../rasterFormats/rasterCodec ../tile/RasterTileInfo ./RasterInfo ./BasicRaster".split(" "),
function(H,g,q,m,n,e,c,a,b,l,h,d,f,k,p,v,t,r,w,u,y,x,z){H=g([z],{declaredClass:"esri.layers.rasterLib.raster.TileRaster",sourceType:"TileCache",_RECORD_SIZE:8,constructor:function(B){this._cloudBlobStorage=B&&B._cloudBlobStorage},open:function(){var B=new m,E=this.datasetInfo||this._getDatasetInfo(null),I=q.hitch(this,function(A){this.datasetInfo=A;this.rasterInfo=A=this._parseRasterInfo(A);this.tileType="Cache/LERC"===A.format?"Elevation":"Cache/MIXED"===A.format||"Cache/JPEG"===A.format||"Cache/PNG"===
A.format?"Map":"Raster";this.tileInfo=A.tileInfo;this.dataType=["Generic","Elevation","Processed"][["Raster","Elevation","Map"].indexOf(this.tileType)];this._HEADER_SIZE=A.packetSize*A.packetSize*this._RECORD_SIZE+64;this.loaded=!0;this._cloudBlobStorage=this._cloudBlobStorage||-1<this.url.toLowerCase().indexOf("s3.amazonaws.com")||-1<this.url.toLowerCase().indexOf("windows.net")||-1<this.url.toLowerCase().indexOf("googleapis.com");this._getRasterIdentifier();B.resolve(this)}),C=q.hitch(this,function(A){this.loaded=
!0;this._getRasterIdentifier();B.reject(A)});l(E,I,C);return B.promise},read:function(B){var E=new m,I=B.level,C=B.row,A=B.col,F=this._buildCacheFilePath(this.url,I,C,A),G=this._getIndexRecordFromBundle(I,C,A);f({url:F,content:{},headers:{Range:"bytes\x3d0-"+(this._HEADER_SIZE-1).toString()},handleAs:"arraybuffer"}).then(q.hitch(this,function(O,N){if(!E.isCanceled()){console.log("time in ms request "+(new Date-R));var R=new Date;O=new Uint8Array(O);O=this._getTileEndAndContentType(O,G);N={width:this.tileInfo.cols,
height:this.tileInfo.rows,planes:null,pixelType:null,format:null,decodeFunc:null,isPoint:"elevation"===this.tileType.toLowerCase()?!0:!1};this._requestPixels({url:F+(this.disableClientCaching?"?_ts\x3d "+(new Date).getTime():""),payload:{},headers:{Range:"bytes\x3d"+O.position.toString()+"-"+(O.position+O.recordSize).toString()},decodeParams:N,tileOptions:B}).then(function(T){E.isCanceled()||E.resolve(T)},function(T){E.isCanceled()||E.reject(T)})}}));return E.promise},identify:function(){return null},
setFetchParameters:function(B,E){},toJson:function(){return{url:this.url,tileInfo:this.tileInfo.toJson(),rasterInfo:this.rasterInfo.toJson(),datasetInfo:this.datasetInfo,sourceType:this.sourceType,tileType:this.tileType,_rasterId:this._rasterId}},_getDatasetInfo:function(){return f({url:this.url+"/conf.json",handleAs:"json",content:{}})},_parseRasterInfo:function(B){var E=new x;switch(B.pixelType){case 1:var I="U1";break;case 1:I="U2";break;case 2:I="U4";break;case 3:I="U8";break;case 4:I="S8";break;
case 5:I="U16";break;case 6:I="S16";break;case 7:I="U32";break;case 8:I="S32";break;case 9:I="F32";break;default:I="F32"}var C,A=[],F=B.LODInfos;for(C=0;C<F.levels.length;C++)A.push({level:F.levels[C],resolution:F.resolutions[C],scale:96/.0254*F.resolutions[C]});C=new v(B.extent.spatialReference||B.geodataXform.spatialReference);A=new y({rows:B.blockHeight,cols:B.blockWidth,dpi:96,format:B.format,compressionQuality:0,origin:B.origin,spatialReference:C,lods:A});E.pixelType=I;E.bandCount=B.bandCount;
E.spatialReference=C;E.extent=new k({xmin:B.extent.xmin,ymin:B.extent.ymin,xmax:B.extent.xmax,ymax:B.extent.ymax,spatialReference:C});E.cellSize=new p({x:B.pixelSizeX,y:B.pixelSizeY,spatialReference:C});E.width=Math.floor((E.extent.xmax-E.extent.xmin)/E.cellSize.x+.5);E.height=Math.floor((E.extent.ymax-E.extent.ymin)/E.cellSize.y+.5);E.statistics=B.statistics.map(function(G){Object.keys(G).forEach(function(O){isNaN(G[O])&&(G[O]=null)});return G});E.histograms=B.histograms;E.geodataXform=B.geodataXform;
E.packetSize=B.packetSize;E.format=B.format;E.compressionQuality=B.compressionQuality;E.tileInfo=A;return E},_getRasterIdentifier:function(){this._rasterId||(this._rasterId=this.url.replace("http:","").replace("https:",""));return this._rasterId},_buildCacheFilePath:function(B,E,I,C){var A=this.rasterInfo.packetSize;C=Math.floor(C/A)*A;I="R"+this._toHexString4(Math.floor(I/A)*A)+"C"+this._toHexString4(C);A="L";A=10<=E?A+E.toString():A+("0"+E.toString());return this._cloudBlobStorage?B+"/_alllayers/"+
A+"/"+I+".bundle":B+"/"+A+"_"+I+"/bundle"},_getIndexRecordFromBundle:function(B,E,I){B=this.rasterInfo.packetSize;E=E%B*B+I%B;if(0>E)throw"Invalid level / row / col";return E*this._RECORD_SIZE+64},_getTileEndAndContentType:function(B,E){B=B.subarray(E,E+8);E=0;var I;for(I=0;5>I;I++)E|=(B[I]&255)<<8*I;var C=E&0xffffffffff;E=0;for(I=5;8>I;I++)E|=(B[I]&255)<<8*(I-5);return{position:C,recordSize:E&0xffffffffff}},_toHexString4:function(B){B=B.toString(16);if(4!=B.length)for(var E=4-B.length;0<E--;)B="0"+
B;return B}});a("extend-esri")&&q.setObject("layers.rasterLib.raster.TileRaster",H,h);return H})},"esri/layers/rasterLib/raster/FunctionRaster":function(){define("require dojo/_base/declare dojo/_base/lang dojo/_base/Deferred dojo/_base/array dojo/_base/config dojo/_base/json dojo/sniff ../DeferredList2 dojo/when ../../../kernel ../../../Evented ../../../request ../../../deferredUtils ../../../geometry/Extent ../../../geometry/Point ../../../SpatialReference ../../../deferredUtils ../../../urlUtils ../../rasterFormats/rasterCodec ./RasterInfo ./BasicRaster ../../rasterLib/function/rasterFunctionHelper".split(" "),
function(H,g,q,m,n,e,c,a,b,l,h,d,f,k,p,v,t,r,w,u,y,x,z){H=g([x],{declaredClass:"esri.layers.rasterLib.raster.FunctionRaster",rasterFunction:null,sourceType:"Function",constructor:function(B){B&&B.rasterFx&&this._init(B.rasterFx,B.rasterFxArgs)},open:function(){var B=this.getMemberRasters().map(function(I){return I.open()});this.identifiers=this.getMemberRasters().map(function(I){return I._rasterId});var E=new m;(new b(B,null,null,!0)).then(function(I){I.some(function(C){return!C[0]})?E.reject(I):
(this.rasterFunction.bind(),this.rasterInfo=this.rasterFunction.rasterInfo,this.dataType=this.rasterInfo.keyProperties&&this.rasterInfo.keyProperties.DataType||"Generic",this.tileInfo=I[0][1].tileInfo,E.resolve(this))}.bind(this));return E.promise},getProjectedFullExtent:function(B){var E=new m;this.getMemberRasters()[0].getProjectedFullExtent(B).then(q.hitch(this,function(I){this.projectedFullExtent=I;E.resolve(I)}));return E.promise},setProcessingContext:function(B){var E=B;B.layer&&(B=B.layer,
E={id:B.id,rawRasterInfo:B.raster.rasterInfo,glSetting:B._glSetting,xformSetting:B.tileManager&&B.tileManager.xformSetting,useWebGL:B.useWebGL,resampling:B.tileMode&&B.tileManager&&B.tileManager.xformSetting.requireProjection&&!B._hasTilingEffects&&"Thematic"!==B.raster.dataType?1:0,tileMode:B.tileMode});this.rasterFunction.setProcessingContext(E);this._layerOptions=E},alterDefinition:function(B){if(B=B||this.rasterFunction)1===this.memberRasters.length&&!B._bindComplete&&(this.rasterFunction=z.create(B,
{raster:this.memberRasters[0]}))&&(this.rasterFunction.bind(),this.rasterInfo=this.rasterFunction.rasterInfo,this.dataType=this.rasterInfo.keyProperties&&this.rasterInfo.keyProperties.DataType||"Generic",this.rasterFunction.setProcessingContext(this._layerOptions)),this._rasterHandler&&this._rasterHandler._connected&&this.rasterFunction&&this._rasterHandler.setRasterFunction({layerId:this._layerOptions.id,data:this.rasterFunction.toJson(!0)})},setFetchParameters:function(B,E){var I=this.getMemberRasters();
I&&1===I.length&&I[0].setFetchParameters(B,E)},getMemberRasters:function(){this.memberRasters||(this.memberRasters=[],this._getMemberRasters(this.rasterFunction.functionArguments,this.memberRasters));return this.memberRasters},read:function(B){var E=new m(k._dfdCanceller);if(B.src){var I=this.rasterFunction.read(B);E.resolve(I);return E.promise}var C=this.getMemberRasters().map(function(O){return O.read(B)});C=new b(C);var A,F,G=this.identifiers;E._pendingDfd=C;C.then(q.hitch(this,function(O){if(A=
O.some(function(N){return N[0]}))F={},O.forEach(function(N,R){F[G[R]]=N[0]?N[1]:null});I=F?this.rasterFunction.read({extent:B.extent,src:F}):null;I.srcData=F;E.resolve(I)}));return E},_init:function(B,E){if(this.rasterFunction=z.create(B,E))this.rasterFunction._bindComplete=!0;else throw"Cannot initialize a function raster without a raster function";},_getMemberRasters:function(B,E){var I=Object.keys(B),C,A,F;for(C=0;C<I.length;C++)if(F=B[I[C]]){var G=F instanceof Array?F:[F];for(A=0;A<G.length;A++)(F=
G[A])&&("function"===typeof F||"object"===typeof F)&&F.read&&(F.functionArguments?this._getMemberRasters(F.functionArguments,E):F.sourceType&&"Function"!==F.sourceType&&(F._identifier=F._getRasterIdentifier(),E.some(function(O){return O._identifier===F._identifier})||E.push(F)))}return E}});a("extend-esri")&&q.setObject("layers.rasterLib.raster.FunctionRaster",H,h);return H})},"esri/layers/rasterLib/DeferredList2":function(){define(["dojo/DeferredList"],function(H){return function(g,q,m,n,e){this.list=
g;q=new H(g,q,m,n,e);var c=q.resolve.bind(q),a=q.cancel.bind(q);q.cancel=function(){g&&g.forEach(function(b){b.cancel&&b.cancel()});a.apply(this,arguments)}.bind(q);q.resolve=function(){this.isFulfilled()||c.apply(this,arguments)}.bind(q);return q}})},"esri/layers/rasterLib/tile/RasterTileManager":function(){define("dojo/_base/declare dojo/_base/lang dojo/Deferred dojo/when ../DeferredList2 ../../../geometry/Extent ../../../SpatialReference ../../../geometry/Point ../../PixelBlock ./RasterTileInfo ../raster/rasterProjectionHelper".split(" "),
function(H,g,q,m,n,e,c,a,b,l,h){var d=function(f,k){var p;for(p=0;p<f.length;p++)if(k(f[p]))return p;return-1};return H(null,{declaredClass:"esri.layers.rasterLib.tile.RasterTileManager",count:null,fullBoundary:null,tileBoundary:null,tiles:null,resolution:null,virtual:!0,prefetchBufferSize:0,_progressiveGlobal:!1,_MAX_TILES:128,_defaultMatrixResolution:20,constructor:function(f){this.tiles=[];this.xformSetting={};this.mapSpatialReference=f&&f.mapSR;this.layer=f&&f.layer;this.identifiers=this.layer.raster.rasterFunction?
this.layer.raster.getMemberRasters().map(function(k){return k._rasterId}):[this.layer.raster._rasterId];(f=f&&f.tileInfo)&&this.setTileInfo(f)},setTileInfo:function(f){this.tileInfo=f;this.virtual=f.virtual;this.mapResolution=null;this.tiles.length=0;this.xformSetting.requireProjection=!this.virtual&&!this.mapSpatialReference.equals(this.tileInfo.spatialReference);this.xformSetting.requirePE=h.requirePE(this.mapSpatialReference,this.tileInfo.spatialReference);this.xformSetting.meshSize=this.xformSetting.requireProjection?
[this._defaultMatrixResolution,this._defaultMatrixResolution]:[1,1];this.halfWorldWidth=h.getHalfWorldWidth(f.spatialReference)},updateResolution:function(f,k){if(!(this.mapResolution&&f&&this._resolutionEqual(this.mapResolution.x,f.x)&&this._resolutionEqual(this.mapResolution.y,f.y))){this.resetTiles();var p=this.xformSetting.requireProjection;this.mapResolution=this.resolution=f;p&&(this.resolution=h.projectResolution(f,this.tileInfo.spatialReference,this.layer.projectedFullExtent||k));this._resolution=
this.resolution;f=this.resolution;if(!this.tileInfo.virtual){p=.75*Math.min(f.x,f.y)+.25*Math.max(f.x,f.y);if(p>=this.tileInfo.lods[0].resolution){var v=this.tileInfo.lods[0];this.ooe=!0}else{if(p<=this.tileInfo.lods[this.tileInfo.lods.length-1].resolution)v=this.tileInfo.lods[this.tileInfo.lods.length-1];else for(f=0;f<this.tileInfo.lods.length-1;f++)if(v=this.tileInfo.lods[f],k=this.tileInfo.lods[f+1],v.resolution>=p&&k.resolution<=p){v.resolution-p>p-k.resolution&&(v=k);break}this.ooe=!1}this.level=
v&&v.level;f=this.resolution=new a({x:v.resolution,y:v.resolution,spatialReference:this.tileInfo.spatialReference})}p=this.layer.raster.rasterInfo.extent;v=this.tileInfo.origin;k=this.tileInfo.cols;var t=this.tileInfo.rows;this.fullBoundary={rowStart:Math.floor((v.y-p.ymax)/f.y/t),rowEnd:Math.floor((v.y-p.ymin-f.y)/f.y/t),colStart:Math.floor((p.xmin-v.x)/f.x/k),colEnd:Math.floor((p.xmax-v.x-f.x)/f.x/k)};if(p=this.halfWorldWidth){t=Math.ceil(p/f.x/(k/2));var r=this.tileInfo.applyGCS360Transform?360:
p,w=Math.round(k-(r-v.x)/f.x%k);w===k&&(w=0);this.fullBoundary.colRange=t;this.fullBoundary.paddingRight=w;this.fullBoundary.paddingLeft=Math.round((t*k*f.x+v.x-r-(this.tileInfo.applyGCS360Transform?0:v.x+p))/f.x)}this.hasNewData=!0}},getXformGrid:function(){var f=this.mapExtent,k=this.layer._hasTilingEffects?this.extent:this.fullExtent,p=this.layer.getCurrentResolution(),v=JSON.stringify(f.toJson())+JSON.stringify(k.toJson());this._datumTransformationInitialized||(this._datumTransformationInitialized=
!0,this._datumTransformation=h.getDefaultDatumTransformationForDataset(this.layer.raster.rasterInfo.extent,f.spatialReference,!0));this._cachedExtentString&&this._cachedExtentString===v||(this._cachedExtentString=v,this._xformGrid=f=h.getProjectionOffsetGrid(f,k,p,this.tileInfo.applyGCS360Transform,this.halfWorldWidth,this._datumTransformation));f=this._xformGrid;this.xformSetting.meshSize=f&&f.size;return f},getWrapTimes:function(f){var k=h.getHalfWorldWidth(f.spatialReference);if(!k)return 0;var p=
2*k;k=this.tileInfo.applyGCS360Transform?0:-k;return Math.floor((f.xmax-k)/p)-Math.floor((f.xmin-k)/p)},normalizeCoordinate:function(f,k){if(!k)return 0;var p=2*k;if(0<f){for(;f>k;)f-=p;return f}for(;f<-k;)f+=p;return f},resetTiles:function(){this.tiles.forEach(g.hitch(this,function(f){f.fetch&&!f.fetch.isCanceled()&&f.fetch.cancel();f.update&&!f.update.isCanceled()&&f.update.cancel()}));this.tiles.length=0},updateExtent:function(f,k){this.mapExtent=this.extent=f;var p=this.xformSetting.requireProjection;
if(p){this.extent=h.project(f,this.tileInfo.spatialReference,this.tileInfo.applyGCS360Transform);if(!this.extent)return;this.extent.spatialReference=new c(this.extent.spatialReference.toJson())}this.updateResolution(k,f);var v=this.extent,t=this.tileInfo,r=t.cols,w=t.rows;k=this.resolution;var u=v;p=p?this.layer.raster.rasterInfo.extent:this.layer.raster.projectedFullExtent;this.ooe&&(u=this._getIntersect(v,p));var y=Math.floor((u.xmin-t.origin.x)/k.x/r)-this.prefetchBufferSize,x=Math.floor((u.xmax-
t.origin.x)/k.x/r)+this.prefetchBufferSize,z=null;f=this.getWrapTimes(f);var B=this.fullBoundary&&this.fullBoundary.colRange;f&&this.halfWorldWidth&&(x===y&&(z=y),x+=f*B);var E=this.halfWorldWidth&&this.tiles.length&&(f!==this.wrapTimes||z!==this._circlularColId);E&&(this._wrapSwitchCount=this._wrapSwitchCount?this._wrapSwitchCount+1:1);this.wrapTimes=f;this._circlularColId=z;var I=Math.floor((t.origin.y-u.ymax)/k.y/w)-this.prefetchBufferSize;z=Math.floor((t.origin.y-u.ymin)/k.y/w)+this.prefetchBufferSize;
this.tileBoundary={rowStart:I,rowEnd:z,colStart:y,colEnd:x};var C,A;((u=(z-I+1)*(x-y+1)>this._MAX_TILES||!this.virtual&&this._resolution.x>8*this.tileInfo.lods[0].resolution)||2<f||E)&&this.resetTiles();if(!(u||2<f)){E=this.tiles;u=!1;for(C=E.length-1;0<=C;C--){var F=E[C].row;var G=E[C].wrapCol;if(F<I||F>z||G<y||G>x)E[C].fetch&&!E[C].fetch.isCanceled()&&E[C].fetch.cancel(),E[C].update&&!E[C].update.isCanceled()&&E[C].update.cancel(),E.splice(C,1),u=!0}for(C=I;C<=z;C++)for(A=y;A<=x;A++){I=new e(t.origin.x+
k.x*r*A,t.origin.y-k.y*w*(C+1),t.origin.x+k.x*r*(A+1),t.origin.y-k.y*w*C,v.spatialReference);var O=f&&B?0<=A?A%B:B- -A%B:A;F=d(E,function(N){return N.row===C&&N.col===O&&N.wrapCol===A});G=p.xmax>=I.xmax?r:Math.round((p.xmax-I.xmin)/k.x);-1===F&&(E.push({row:C,col:O,wrapCol:A,cellsizeX:k.x,cellsizeY:k.y,width:r,height:w,actualWidth:G,extent:I,normalizedExtent:this._wrapExtent(I,O),pixelBlock:null,virtual:this.virtual,level:this.level,tileType:this.tileInfo.tileType||"Raster"}),u=!0)}u&&this._sortTiles();
k=this.tileInfo.rows*(this.tileBoundary.rowEnd-this.tileBoundary.rowStart+1);this.width=this.tileInfo.cols*(this.tileBoundary.colEnd-this.tileBoundary.colStart+1);this.height=k;this.count=E.length;k=Math.min.apply(null,E.map(function(N){return N.extent.xmin}));t=Math.max.apply(null,E.map(function(N){return N.extent.xmax}));r=Math.min.apply(null,E.map(function(N){return N.extent.ymin}));w=Math.max.apply(null,E.map(function(N){return N.extent.ymax}));k=this.fullExtent=new e(k,r,t,w,v.spatialReference);
if(this.layer.roaming||this.layer.useWebGL)this.layer._hasTilingEffects?(this.xformSetting.offset=[0,0],this.xformSetting.scale=[1,1]):(u&&(this._tilesChanged=!0),this.xformSetting.offset=[(v.xmin-k.xmin)/(k.xmax-k.xmin),-(k.ymin-v.ymin)/(k.ymax-k.ymin)],this.xformSetting.scale=[(v.xmax-v.xmin)/(k.xmax-k.xmin),(v.ymax-v.ymin)/(k.ymax-k.ymin)])}},fetchTiles:function(f){(this._tilesChanged||f)&&this._fetchTiles(f)},_fetchTiles:function(f){this._fetchCounter=0;var k=this.extent;this.fetchAllCompleted=
f?new q:null;(this._tilesChanged||f&&this.layer._hasTilingEffects)&&this.tiles.forEach(g.hitch(this,function(v){v.updateCompleted=!1}));var p={};!this.layer.roaming&&this.layer._hasTilingEffects&&f?(this.identifiers.forEach(function(v,t){p[v]={extent:this.extent,pixelBlock:new b({width:this.layer._map.width,height:this.layer._map.height,pixels:[],pixelType:"",mask:null,statistics:[]})}}.bind(this)),this.originalPixelData={extent:this.extent,src:p,isEmpty:!0}):this._tilesChanged&&(this.identifiers.forEach(function(v,
t){p[v]={extent:this.fullExtent,pixelBlock:new b({width:128,height:128,pixels:[],pixelType:"",mask:null,statistics:[]})}}.bind(this)),this.originalPixelData={extent:this.fullExtent,src:p,isEmpty:!0});this.tiles.forEach(g.hitch(this,function(v){if(v.fetch)v.update||(v.update=this.updateTile(v));else{if(this._isTileOutSide(v,k)){v.updateCompleted=!0;return}this._requestTile(v)}this.layer.roaming&&this.layer.useWebGL?this._fillPixelData(v):v.src&&f&&(this.layer._hasTilingEffects||this.layer.useWebGL)&&
(this._fillPixelData(v),this.layer._hasTilingEffects&&(v.updateCompleted=!0),v.processedPixelBlock=null,v.renderedPixelBlock=null)}));0===this._fetchCounter&&(this._fetched=!0);this._tilesChanged=!1;f&&this._updateFetchStatus()},updateTile:function(f,k){var p=new q;if(!f.src&&!f.fetch)return p.resolve(f),p.promise;m(f.src||f._fetched||f.fetch,g.hitch(this,function(){var v=this.layer.tileMode&&this.layer._rasterHandler&&!(this.layer._hasTilingEffects||this.layer.useWebGL),t=this.layer._drawTile,r=
this._validateRawPixelBlocks(f);this.layer._hasTilingEffects&&!this.layer.useWebGL&&(t=t&&(this._progressiveGlobal||k));if((k||!k&&r)&&(v||t||this.layer.roaming)){if(this.xformSetting.requireProjection&&this.layer.useWebGL&&(this.xformSetting.gridConfig=this.getXformGrid(),null==this.xformSetting.gridConfig))return p.cancel(),p.promise;this._processTile(f,k).then(g.hitch(this,function(w){p.isCanceled()||this._renderTile(w,k).then(g.hitch(this,function(u){this.hasNewData=!1;p.isCanceled()||p.resolve(u)}))}))}else k||
r||(f.updateCompleted=!0),this.layer.useWebGL||this.layer._hasTilingEffects?p.resolve(this.originalPixelData):p.resolve()}));return p.promise},setLayer:function(f){this.layer=f},fillupTiles:function(){this.tiles.forEach(g.hitch(this,function(f){f.update&&f.updateCompleted&&!f.filled&&(f.updateCompleted=!1,this._fillPixelData(f),f.updateCompleted=!0)}))},_validateRawPixelBlocks:function(f){return f&&f.src&&!this.identifiers.some(function(k){return!(f.src[k].pixelBlock&&0!==f.src[k].pixelBlock.validPixelCount&&
f.src[k].pixelBlock.pixels&&0<f.src[k].pixelBlock.pixels.length)})},_wrapExtent:function(f,k){if(f){if(this.tileInfo.applyGCS360Transform){var p=this.normalizeCoordinate(f.xmin,180);0>p&&(p+=360);return new e({xmin:p,ymin:f.ymin,xmax:f.xmax-f.xmin+p,ymax:f.ymax,spatialReference:f.spatialReference})}if(this.halfWorldWidth){p=null!=k?new e({xmin:this.tileInfo.origin.x+this.tileInfo.cols*k*this.resolution.x,ymin:f.ymin,xmax:this.tileInfo.origin.x+this.tileInfo.cols*(k+1)*this.resolution.x,ymax:f.ymax,
spatialReference:f.spatialReference}):new e({xmin:f.xmin,ymin:f.ymin,xmax:f.xmax,ymax:f.ymax,spatialReference:f.spatialReference});k=this.normalizeCoordinate(p.xmin,this.halfWorldWidth);var v=k-p.xmin;.01<Math.abs(v)&&(p.xmin=k,p.xmax+=v)}return p||f}},_getIntersect:function(f,k){return new e(Math.max(f.xmin,k.xmin),Math.max(f.ymin,k.ymin),Math.min(f.xmax,k.xmax),Math.min(f.ymax,k.ymax),f.spatialReference)},_isTileOutSide:function(f,k){var p=!1;if(f.virtual){var v=f.normalizedExtent;if(k=k||(this.xformSetting.requireProjection?
this.layer.raster.rasterInfo.extent:this.layer.raster.projectedFullExtent)){f=v.xmin-this.prefetchBufferSize*this.tileInfo.cols*this.resolution.x;p=v.ymin-this.prefetchBufferSize*this.tileInfo.rows*this.resolution.y;var t=v.xmax+this.prefetchBufferSize*this.tileInfo.cols*this.resolution.x;v=v.ymax+this.prefetchBufferSize*this.tileInfo.rows*this.resolution.y;p=t<=k.xmin||f>=k.xmax||v<=k.ymin||p>=k.ymax}else p=!1}else p=0>f.level||f.row<this.fullBoundary.rowStart||f.row>this.fullBoundary.rowEnd||f.col<
this.fullBoundary.colStart||f.col>this.fullBoundary.colEnd;return p},_resolutionEqual:function(f,k){return f===k||f&&k&&Math.abs(f-k)<Math.abs(k/1E4)?!0:!1},_requestTile:function(f){var k=this.identifiers,p;if(this._isTileOutSide(f)){var v=new q;f.updateCompleted=!0;v.resolve(null);v=v.promise}else v=this.layer.raster.rasterFunction?new n(this.layer.raster.getMemberRasters().map(function(t){return t.read(f)})):new n([this.layer.raster.read(f)]);f.fetch=v;this._fetchCounter++;m(f.src||f._fetched||
v,g.hitch(this,function(t){if(p=t&&t.some(function(w){return w[0]})){var r={};t.forEach(function(w,u){r[k[u]]=w[0]&&w[1]?{extent:w[1].extent,pixelBlock:w[1].pixelBlock,width:w[1].width,height:w[1].height}:null});f.src=r}else f.src=null;this._fetchCounter--;0===this._fetchCounter&&(this._fetched=!0);f._fetched=!0;this._updateFetchStatus()}),g.hitch(this,function(){this._fetchCounter--;0===this._fetchCounter&&(this._fetched=!0);f._fetched=!0;this._updateFetchStatus()}));f.update=this.updateTile(f)},
_updateFetchStatus:function(){this.layer._drawTile&&this.fetchAllCompleted&&!this.fetchAllCompleted.isResolved()&&!this.tiles.some(function(f){return!f._fetched})&&(this.tiles.forEach(g.hitch(this,function(f){this._fillPixelData(f)})),this.fetchAllCompleted.resolve())},_fillPixelData:function(f,k){if(f&&!f.updateCompleted)if(Math.abs(f.cellsizeX-this.resolution.x)>f.cellsizeX/10)f.updateCompleted=!0;else if(!1===this._validateRawPixelBlocks(f))f.updateCompleted=!0;else{var p=f.extent;if(this.layer.roaming||
this.layer.useWebGL&&!this.layer._hasTilingEffects){var v=this.fullExtent;var t=this.tileInfo.cols*(this.tileBoundary.colEnd-this.tileBoundary.colStart+1);var r=this.tileInfo.rows*(this.tileBoundary.rowEnd-this.tileBoundary.rowStart+1);k?this.originalPixelData.renderedPixelBlock||(this.originalPixelData.renderedPixelBlock=new b({width:t,height:r,pixels:[],pixelType:"",mask:null,statistics:[]})):this.identifiers.forEach(g.hitch(this,function(u){this.originalPixelData.src[u].pixelBlock.width=t;this.originalPixelData.src[u].pixelBlock.height=
r}))}else v=this.extent,t=this.layer._map.width,r=this.layer._map.height,k?this.originalPixelData.renderedPixelBlock||(this.originalPixelData.renderedPixelBlock=new b({width:t,height:r,pixels:[],pixelType:"",mask:null,statistics:[]})):this.identifiers.forEach(g.hitch(this,function(u){this.originalPixelData.src[u].pixelBlock.width=t;this.originalPixelData.src[u].pixelBlock.height=r}));if(v.xmax<=p.xmin||v.xmin>=p.xmax||v.ymax<=p.ymin||v.ymin>=p.ymax)return null;var w=this.originalPixelData.isEmpty=
!1;this.identifiers.forEach(g.hitch(this,function(u){f.src&&(this._fillPixelBlock(f.src[u],this.originalPixelData.src[u],{extent:v,width:t,height:r,normalizedExtent:f.normalizedExtent},!1),w=!0)}));f.filled=w;this.hasNewData=!0}},_fillPixelBlock:function(f,k,p,v){var t=f.extent,r=p.extent;v=p.width;var w=p.height;if(f.pixelBlock&&f.pixelBlock.pixels&&f.pixelBlock.pixels[0]){var u=(t.xmax-t.xmin)/f.width,y=Math.max(t.xmin,r.xmin),x=Math.min(t.ymax,r.ymax),z=Math.round((y-t.xmin)/u),B=f.width-Math.round(Math.abs(t.xmax-
Math.min(t.xmax,r.xmax))/u),E=Math.round(Math.abs(t.ymax-x)/u),I=f.height-Math.round((Math.max(t.ymin,r.ymin)-t.ymin)/u),C=this.halfWorldWidth;y=Math.round((y-r.xmin)/u);p=p.normalizedExtent;if(!(this.wrapTimes&&C&&t.xmin<-C)){if(this.wrapTimes&&C){if(this.tileInfo.applyGCS360Transform)360<t.xmin&&(y-=this.fullBoundary.paddingLeft);else if(t.xmin>C){y-=this.fullBoundary.paddingLeft;var A=this.normalizeCoordinate(t.xmin,C);var F=this.normalizeCoordinate(t.xmax,C)}else A=t.xmin,F=t.xmax;this.tileInfo.applyGCS360Transform?
p&&360>p.xmin&&360<p.xmax&&(B-=this.fullBoundary.paddingRight):p&&p.xmin<C&&p.xmax>C?B-=this.fullBoundary.paddingRight:A<C&&F>C&&(B-=this.fullBoundary.paddingRight)}A=Math.round(Math.abs(r.ymax-x)/u);F=f.pixelBlock.pixels.length;k=k.pixelBlock;p=f.width;t=k.mask||new Uint8Array(v*w);var G=f.pixelBlock,O=G.mask,N=0;for(u=0;u<F;u++){x=G.pixels[u];C=k.pixels[u]||new x.constructor(v*w);for(f=E;f<I;f++)for(N=(A+f-E)*v+y,r=z;r<B;r++)C[N+r-z]=x[f*p+r];k.pixels[u]=C}if(O)for(f=E;f<I;f++)for(N=(A+f-E)*v+y,
r=z;r<B;r++)t[N+r-z]=O[f*p+r];else for(f=E;f<I;f++)for(N=(A+f-E)*v+y,r=z;r<B;r++)t[N+r-z]=1;k.pixelType=k.pixelType||G.pixelType;k.mask=t;if(!(k.statistics&&0<k.statistics.length))for(k.statistics=[],f=0;f<G.statistics.length;f++)k.statistics[f]={minValue:G.statistics[f].minValue,maxValue:G.statistics[f].maxValue};else if(G.statistics&&k.statistics)for(f=0;f<k.statistics.length;f++)k.statistics[f].minValue=Math.min(G.statistics[f].minValue,k.statistics[f].minValue),k.statistics[f].maxValue=Math.max(G.statistics[f].maxValue,
k.statistics[f].maxValue)}}},_processTile:function(f,k){var p=new q,v=this.layer._hasTilingEffects,t=this.layer.useWebGL,r=v||t,w=this.layer.raster.rasterFunction&&f&&(v||t||!f.processedPixelBlock);if(k)var u=f;else this._fillPixelData(f),u=r?this.originalPixelData:f;this.xformSetting.hasNewTexture=this.hasNewData;var y;w?(this.identifiers.forEach(function(x){if(0===u.src[x].pixelBlock.pixels.length||0===u.src[x].pixelBlock.pixels[0].length)y=!0}),y?p.resolve({extent:u.extent,processedPixelBlock:u.src[this.identifiers[0]],
pixelBlock:u.src[this.identifiers[0]]}):t?(this.processedPixelData=this.layer.raster.rasterFunction.read(u),p.resolve(this.processedPixelData)):this.layer._rasterHandler?this.layer._rasterHandler.process({extent:u.extent,src:u.src}).then(function(x){v?(this.processedPixelData=x,p.resolve(this.processedPixelData)):(f.processedPixelBlock=x.pixelBlock,p.resolve(f))}):(k=this.layer.raster.rasterFunction.read(f),f.processedPixelBlock=k.pixelBlock,p.resolve(f))):r?p.resolve(u.src[this.identifiers[0]]):
(f.pixelBlock=u.src[this.identifiers[0]]&&u.src[this.identifiers[0]].pixelBlock,p.resolve(f));return p.promise},_renderTile:function(f){var k=new q,p=this.layer._hasTilingEffects,v=this.layer.useWebGL,t=Math.abs((f.extent.xmax-f.extent.xmin)/f.width-this.layer.getCurrentResolution().x)>this.resolution.x/10;t=this.layer.useWebGL&&(t||this._isTileOutSide(f,this.layer._map.extent));this.xformSetting.hasNewTexture=this.hasNewData;this.layer._rasterRenderer&&f&&(f.texture||f.src||f.pixelBlock||f.processedPixelBlock)?
(this.layer._rasterRenderer.interpolation=this.layer.interpolation,v&&!t?(this.layer.raster.rasterFunction&&this.layer.raster.rasterFunction.renderTexture||this.layer._rasterRenderer.draw(f),k.resolve(f)):this.layer._rasterHandler?this.layer._rasterHandler.render({extent:f.extent,pixelBlock:f.processedPixelBlock||f.pixelBlock}).then(function(r){p?(r.renderedPixelBlock=r.pixelBlock,k.resolve(r)):(f.renderedPixelBlock=r.pixelBlock,k.resolve(f))}.bind(this)):(f.renderedPixelBlock=this.layer._rasterRenderer.draw(f).pixelBlock,
k.resolve(f))):(f.renderedPixelBlock=f.processedPixelBlock||f.pixelBlock,k.resolve(f));return k.promise},_sortTiles:function(){this.tiles.sort(function(f,k){return f.row<k.row||f.row==k.row&&f.col<k.col?-1:1})}})})},"esri/dijit/Basemap":function(){define("dojo/_base/declare dojo/_base/array dojo/_base/lang dojo/has ../kernel ../request ./BasemapLayer".split(" "),function(H,g,q,m,n,e,c){H=H(null,{declaredClass:"esri.dijit.Basemap",id:null,title:"",thumbnailUrl:null,layers:null,itemId:null,basemapGallery:null,
constructor:function(a,b){a=a||{};a.layers||a.itemId||console.error("esri.dijit.Basemap: unable to find the 'layers' property in parameters");this.id=a.id;this.itemId=a.itemId;this.layers=a.layers;this.title=a.title||"";this.thumbnailUrl=a.thumbnailUrl;this.basemapGallery=b},getLayers:function(a){if(this.layers)return this.layers;if(this.itemId)return a=e({url:(a||n.dijit._arcgisUrl)+"/content/items/"+this.itemId+"/data",content:{f:"json"},callbackParamName:"callback",error:q.hitch(this,function(b,
l){if(this.basemapGallery)this.basemapGallery.onError("esri.dijit.Basemap: could not access basemap item.");else console.error("esri.dijit.Basemap: could not access basemap item.")})}),a.addCallback(q.hitch(this,function(b,l){if(b.baseMap)return this.layers=[],g.forEach(b.baseMap.baseMapLayers,function(h){this.layers.push(new c(h))},this),this.layers;if(this.basemapGallery)this.basemapGallery.onError("esri.dijit.Basemap: could not access basemap item.");else console.error("esri.dijit.Basemap: could not access basemap item.");
return[]})),a}});m("extend-esri")&&q.setObject("dijit.Basemap",H,n);return H})},"esri/dijit/BasemapLayer":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/has","../kernel"],function(H,g,q,m){H=H(null,{declaredClass:"esri.dijit.BasemapLayer",constructor:function(n){n=n||{};n.url||n.type||console.error("esri.dijit.BasemapLayer: unable to find the 'url' or 'type' property in parameters");this.url=n.url;this.type=n.type;this.isReference=!0===n.isReference?!0:!1;this.opacity=n.opacity;this.visibleLayers=
n.visibleLayers;this.displayLevels=n.displayLevels;this.exclusionAreas=n.exclusionAreas;this.bandIds=n.bandIds;this.renderingRule=n.renderingRule;this.templateUrl=n.templateUrl;this.copyright=n.copyright;this.subDomains=n.subDomains;this.fullExtent=n.fullExtent;this.initialExtent=n.initialExtent;this.tileInfo=n.tileInfo;this.tileServers=n.tileServers;this.styleUrl=n.styleUrl}});q("extend-esri")&&g.setObject("dijit.BasemapLayer",H,m);return H})},"widgets/GridOverlay/setting/utils":function(){define("dojo/_base/lang dojo/Deferred dojo/json dojo/_base/array dojo/promise/all esri/SpatialReference jimu/portalUtils jimu/shared/basePortalUrlUtils esri/request dojo/text!./esri_tileinfo.json".split(" "),
function(H,g,q,m,n,e,c,a,b,l){function h(t){if(!t)return null;var r=t.indexOf("?");return 0===t.search(/http|\/\//)&&-1!==r?t.slice(0,r).replace(/\/*$/g,""):t}function d(t){return t?a.removeProtocol(h(t)):""}function f(t){var r=new g;c.getPortalSelfInfo(t).then(H.hitch(this,function(w){var u=w.basemapGalleryGroupQuery;!0===w.useVectorBasemaps&&w.vectorBasemapGalleryGroupQuery&&(u=w.vectorBasemapGalleryGroupQuery);p.getBasemapGalleryGroup(t,u).then(H.hitch(this,function(y){y.queryItems({start:1,num:100,
f:"json",q:c.webMapQueryStr}).then(H.hitch(this,function(x){r.resolve(x)}),H.hitch(this,function(){r.reject()}))}),H.hitch(this,function(){r.reject()}))}));return r}function k(t){return b({url:t,content:{f:"json"},handleAs:"json",callbackParamName:"callback"}).then(function(r){return r},function(){return null})}var p={},v=q.parse(l);p._loadPortalBaseMaps=function(t,r){var w=new g,u=[];f(t).then(function(y){m.forEach(y.results,function(x){var z=new g,B=d(x.thumbnailUrl);u.push(z);x.getItemData().then(function(E){p._getBasemapSpatialReference(x,
E).then(H.hitch(this,function(I){var C=E.baseMap.baseMapLayers;p.isBasemapCompatibleWithMap(I,C,r).then(H.hitch(this,function(A){A?z.resolve({layers:C,title:x.title||E.baseMap.title,thumbnailUrl:B,spatialReference:I}):z.resolve({})}))}))})});n(u).then(function(x){x=m.filter(x,function(z){return z&&z.title?!0:!1},this);w.resolve(x)})},function(y){w.reject(y)});return w};p.isBasemapCompatibleWithMap=function(t,r,w){var u=new g,y=w.spatialReference,x=w.width>w.height?w.width:w.height;if(!y||!r||0>=r.length||
!t||!y.equals(new e(+t.wkid)))return u.resolve(!1),u;0===w.getNumLevels()?"OpenStreetMap"===r[0].layerType||r[0].layerType&&-1<r[0].layerType.indexOf("BingMaps")||"WebTiledLayer"===r[0].layerType||"VectorTileLayer"===r[0].layerType||"ArcGISImageServiceVectorLayer"===r[0].layerType||"ArcGISTiledImageServiceLayer"===r[0].layerType?u.resolve(!1):u.resolve(!0):r[0].layerType&&0===r[0].layerType.indexOf("ArcGIS")&&r[0].url?k(r[0].url).then(function(z){(r[0].serviceInfoResponse=z)&&z.tileInfo?u.resolve(p.tilingSchemeCompatible(w.__tileInfo,
z.tileInfo,x)):z&&z.capabilities&&(0<=z.capabilities.indexOf("Map")||z.capabilities.indexOf("Image"))?u.resolve(!0):u.resolve(!1)}):"WMS"===r[0].layerType?u.resolve(!0):p.isNoUrlLayerMap(r)||"VectorTileLayer"===r[0].layerType?u.resolve(p.tilingSchemeCompatible(w.__tileInfo,v,x)):u.resolve(p.tilingSchemeCompatible(w.__tileInfo,r[0].tileInfo,x));return u};p.tilingSchemeCompatible=function(t,r,w){if(t&&r){var u=!1,y=!1,x,z;for(x=0;x<t.lods.length;x++){var B=t.lods[x].scale;t.dpi!==r.dpi&&(B=t.lods[x].scale/
t.dpi);for(z=0;z<r.lods.length;z++){var E=r.lods[z].scale;t.dpi!==r.dpi&&(E=r.lods[z].scale/r.dpi);if(Math.abs(E-B)/E<1/w)if(u){y=!0;break}else u=!0;if(E<B)break}if(y)break}t=y?!0:!u||1!==t.lods.length&&1!==r.lods.length?!1:!0;return t}return!0};p.isSameBasemapLayer=function(t,r){if(t.layerType&&r.layerType){if(t.layerType!==r.layerType)return!1;if("ArcGISImageServiceVectorLayer"===t.layerType||"ArcGISTiledImageServiceLayer"===t.layerType||"ArcGISTiledMapServiceLayer"===t.layerType||"ArcGISMapServiceLayer"===
t.layerType||"ArcGISImageServiceLayer"===t.layerType)return t=d(t.url||""),r=d(r.url||""),t.toLowerCase()===r.toLowerCase();if("BingMapsAerial"===t.layerType||"BingMapsRoad"===t.layerType||"BingMapsHybrid"===t.layerType||"OpenStreetMap"===t.layerType)return!0;if("VectorTileLayer"===t.layerType)return t=d(t.styleUrl||""),r=d(r.styleUrl||""),t.toLowerCase()===r.toLowerCase();if("WMS"===t.layerType)return t=d(t.mapUrl||""),r=d(r.mapUrl||""),t.toLowerCase()===r.toLowerCase();if("WebTiledLayer"===t.layerType){if(t.templateUrl&&
r.templateUrl)return t=d(t.templateUrl||""),r=d(r.templateUrl||""),t.toLowerCase()===r.toLowerCase();if(t.wmtsInfo&&r.wmtsInfo)return t=d(t.wmtsInfo.url||""),r=d(r.wmtsInfo.url||""),t.toLowerCase()===r.toLowerCase()}}else return t=d(t.url||""),r=d(r.url||""),t.toLowerCase()===r.toLowerCase();return!1};p.compareSameBasemapByOrder=function(t,r){t=t.layers;r=r.layers;if(t.length!==r.length)return!1;for(var w=0;w<t.length;w++)if(!p.isSameBasemapLayer(t[w],r[w]))return!1;return!0};p.isBingMap=function(t){if(!t||
!t.layers)return!1;for(var r=0;r<t.layers.length;r++)if("BingMapsAerial"===t.layers[r].type||"BingMapsRoad"===t.layers[r].type||"BingMapsHybrid"===t.layers[r].type)return!0;return!1};p.isNoUrlLayerMap=function(t){for(var r=0;r<t.length;r++)if("BingMapsAerial"===t[r].type||"BingMapsRoad"===t[r].type||"BingMapsHybrid"===t[r].type||"OpenStreetMap"===t[r].type)return!0;return!1};p.getToken=function(t){t=c.getPortal(t);t.updateCredential();return t.credential?"?token\x3d"+t.credential.token:""};p.removeUrlQuery=
function(t){return h(t)};p.getStanderdUrl=function(t){return d(t)};p.getUniqueTitle=function(t,r){if(!r||0===r.length)return t;r=m.filter(r,function(w){return w===t?!0:0===w.indexOf(t)?(w=w.substr(t.length+1),!isNaN(+w)):!1});if(0===r.length)return t;r=m.map(r,function(w){return w===t?0:+w.substr(t.length+1)});r=r.sort();return t+" "+(r[r.length-1]+1)};p.getBasemapInfo=function(t,r){var w,u;return c.getPortal(t).getItemById(r).then(function(y){w=y;return y.getItemData()}).then(function(y){u=y;return p._getBasemapSpatialReference(w,
y)}).then(function(y){return{thumbnailUrl:w.thumbnailUrl,title:w.title||u.baseMap.title,layers:u.baseMap.baseMapLayers,spatialReference:new e(y)}})};p.getBasemapGalleryGroup=function(t,r){var w=new g;t=c.getPortal(t);var u=r.indexOf("esri_");if(0<=u){u=r.slice(u,u+7);var y="esri_"+dojoConfig.locale.slice(0,2);r=r.replace(u,y)}t.queryGroups({f:"json",q:r}).then(H.hitch(this,function(x){0<x.results.length?w.resolve(x.results[0]):w.reject()}),H.hitch(this,function(){w.reject()}));return w};p._getBasemapSpatialReference=
function(t,r){var w=null,u=!1,y=new g;if(t.owner&&0===t.owner.indexOf("esri_")||p.isNoUrlLayerMap(r.baseMap.baseMapLayers))w={wkid:"102100"};else if(r.spatialReference||t.spatialReference)w=r.spatialReference||t.spatialReference;else if(r.baseMap.baseMapLayers&&r.baseMap.baseMapLayers[0])if(t=r.baseMap.baseMapLayers[0],t.url&&0<t.url.indexOf("rest/services"))u=!0,k(r.baseMap.baseMapLayers[0].url).then(H.hitch(this,function(x){x&&x.spatialReference&&(w=x.spatialReference);y.resolve(w)}),function(x){console.error(x);
y.resolve(null)});else if("VectorTileLayer"===t.layerType)w={wkid:"102100"};else if(r=t.fullExtent||t.initialExtent)w=r.spatialReference;u||y.resolve(w);return y};return p})},"dijit/TitlePane":function(){define("dojo/_base/array dojo/_base/declare dojo/dom dojo/dom-attr dojo/dom-class dojo/dom-geometry dojo/fx dojo/has dojo/_base/kernel dojo/keys ./_CssStateMixin ./_TemplatedMixin ./layout/ContentPane dojo/text!./templates/TitlePane.html ./_base/manager ./a11yclick".split(" "),function(H,g,q,m,n,
e,c,a,b,l,h,d,f,k,p){g=g("dijit.TitlePane",[f,d,h],{title:"",_setTitleAttr:{node:"titleNode",type:"innerHTML"},open:!0,toggleable:!0,tabIndex:"0",duration:p.defaultDuration,baseClass:"dijitTitlePane",templateString:k,doLayout:!1,_setTooltipAttr:{node:"focusNode",type:"attribute",attribute:"title"},buildRendering:function(){this.inherited(arguments);q.setSelectable(this.titleNode,!1)},postCreate:function(){this.inherited(arguments);this.toggleable&&this._trackMouseState(this.titleBarNode,this.baseClass+
"Title");var v=this.hideNode,t=this.wipeNode;this._wipeIn=c.wipeIn({node:t,duration:this.duration,beforeBegin:function(){v.style.display=""}});this._wipeOut=c.wipeOut({node:t,duration:this.duration,onEnd:function(){v.style.display="none"}})},_setOpenAttr:function(v,t){H.forEach([this._wipeIn,this._wipeOut],function(r){r&&"playing"==r.status()&&r.stop()});t?this[v?"_wipeIn":"_wipeOut"].play():this.hideNode.style.display=this.wipeNode.style.display=v?"":"none";if(this._started)if(v)this._onShow();else this.onHide();
this.containerNode.setAttribute("aria-hidden",v?"false":"true");this.focusNode.setAttribute("aria-pressed",v?"true":"false");this._set("open",v);this._setCss()},_setToggleableAttr:function(v){this.focusNode.setAttribute("role",v?"button":"heading");v?(this.focusNode.setAttribute("aria-controls",this.id+"_pane"),this.focusNode.setAttribute("tabIndex",this.tabIndex),this.focusNode.setAttribute("aria-pressed",this.open)):(m.remove(this.focusNode,"aria-controls"),m.remove(this.focusNode,"tabIndex"),m.remove(this.focusNode,
"aria-pressed"));this._set("toggleable",v);this._setCss()},_setContentAttr:function(v){this.open&&this._wipeOut&&"playing"!=this._wipeOut.status()?(this._wipeIn&&"playing"==this._wipeIn.status()&&this._wipeIn.stop(),e.setMarginBox(this.wipeNode,{h:e.getMarginBox(this.wipeNode).h}),this.inherited(arguments),this._wipeIn?this._wipeIn.play():this.hideNode.style.display=""):this.inherited(arguments)},toggle:function(){this._setOpenAttr(!this.open,!0)},_setCss:function(){var v=this.titleBarNode||this.focusNode,
t=this._titleBarClass;this._titleBarClass=this.baseClass+"Title"+(this.toggleable?"":"Fixed")+(this.open?"Open":"Closed");n.replace(v,this._titleBarClass,t||"");n.replace(v,this._titleBarClass.replace("TitlePaneTitle",""),(t||"").replace("TitlePaneTitle",""));this.arrowNodeInner.innerHTML=this.open?"-":"+"},_onTitleKey:function(v){v.keyCode==l.DOWN_ARROW&&this.open&&(this.containerNode.focus(),v.preventDefault())},_onTitleClick:function(){this.toggleable&&this.toggle()},setTitle:function(v){b.deprecated("dijit.TitlePane.setTitle() is deprecated.  Use set('title', ...) instead.",
"","2.0");this.set("title",v)}});a("dojo-bidi")&&g.extend({_setTitleAttr:function(v){this._set("title",v);this.titleNode.innerHTML=v;this.applyTextDir(this.titleNode)},_setTooltipAttr:function(v){this._set("tooltip",v);this.textDir&&(v=this.enforceTextDirWithUcc(null,v));m.set(this.focusNode,"title",v)},_setTextDirAttr:function(v){this._created&&this.textDir!=v&&(this._set("textDir",v),this.set("title",this.title),this.set("tooltip",this.tooltip))}});return g})},"widgets/GridOverlay/setting/_build-generate_module":function(){define(["dojo/text!./Setting.html",
"dojo/text!./css/style.css","dojo/i18n!./nls/strings"],function(){})},"url:esri/dijit/templates/BasemapGallery.html":'\x3cdiv class\x3d"esriBasemapGallery"\x3e\r\n  \x3cdiv dojoAttachPoint\x3d"flowContainer"\x3e\r\n  \x3c/div\x3e\r\n\x3c/div\x3e',"url:widgets/GridOverlay/setting/esri_tileinfo.json":'{\r\n  "rows": 256,\r\n  "cols": 256,\r\n  "dpi": 96,\r\n  "compressionQuality": 75,\r\n  "origin": {\r\n   "x": -2.0037508342787E7,\r\n   "y": 2.0037508342787E7\r\n  },\r\n  "spatialReference": {\r\n   "wkid": 102100,\r\n   "latestWkid": 3857\r\n  },\r\n  "lods": [\r\n   {\r\n    "level": 0,\r\n    "resolution": 156543.03392800014,\r\n    "scale": 5.91657527591555E8\r\n   },\r\n   {\r\n    "level": 1,\r\n    "resolution": 78271.51696399994,\r\n    "scale": 2.95828763795777E8\r\n   },\r\n   {\r\n    "level": 2,\r\n    "resolution": 39135.75848200009,\r\n    "scale": 1.47914381897889E8\r\n   },\r\n   {\r\n    "level": 3,\r\n    "resolution": 19567.87924099992,\r\n    "scale": 7.3957190948944E7\r\n   },\r\n   {\r\n    "level": 4,\r\n    "resolution": 9783.93962049996,\r\n    "scale": 3.6978595474472E7\r\n   },\r\n   {\r\n    "level": 5,\r\n    "resolution": 4891.96981024998,\r\n    "scale": 1.8489297737236E7\r\n   },\r\n   {\r\n    "level": 6,\r\n    "resolution": 2445.98490512499,\r\n    "scale": 9244648.868618\r\n   },\r\n   {\r\n    "level": 7,\r\n    "resolution": 1222.992452562495,\r\n    "scale": 4622324.434309\r\n   },\r\n   {\r\n    "level": 8,\r\n    "resolution": 611.4962262813797,\r\n    "scale": 2311162.217155\r\n   },\r\n   {\r\n    "level": 9,\r\n    "resolution": 305.74811314055756,\r\n    "scale": 1155581.108577\r\n   },\r\n   {\r\n    "level": 10,\r\n    "resolution": 152.87405657041106,\r\n    "scale": 577790.554289\r\n   },\r\n   {\r\n    "level": 11,\r\n    "resolution": 76.43702828507324,\r\n    "scale": 288895.277144\r\n   },\r\n   {\r\n    "level": 12,\r\n    "resolution": 38.21851414253662,\r\n    "scale": 144447.638572\r\n   },\r\n   {\r\n    "level": 13,\r\n    "resolution": 19.10925707126831,\r\n    "scale": 72223.819286\r\n   },\r\n   {\r\n    "level": 14,\r\n    "resolution": 9.554628535634155,\r\n    "scale": 36111.909643\r\n   },\r\n   {\r\n    "level": 15,\r\n    "resolution": 4.77731426794937,\r\n    "scale": 18055.954822\r\n   },\r\n   {\r\n    "level": 16,\r\n    "resolution": 2.388657133974685,\r\n    "scale": 9027.977411\r\n   },\r\n   {\r\n    "level": 17,\r\n    "resolution": 1.1943285668550503,\r\n    "scale": 4513.988705\r\n   },\r\n   {\r\n    "level": 18,\r\n    "resolution": 0.5971642835598172,\r\n    "scale": 2256.994353\r\n   },\r\n   {\r\n    "level": 19,\r\n    "resolution": 0.29858214164761665,\r\n    "scale": 1128.497176\r\n   },\r\n   {\r\n    "level": 20,\r\n    "resolution": 0.14929107082380833,\r\n    "scale": 564.248588\r\n   },\r\n   {\r\n    "level": 21,\r\n    "resolution": 0.07464553541190416,\r\n    "scale": 282.124294\r\n   },\r\n   {\r\n    "level": 22,\r\n    "resolution": 0.03732276770595208,\r\n    "scale": 141.062147\r\n   },\r\n   {\r\n    "level": 23,\r\n    "resolution": 0.01866138385297604,\r\n    "scale": 70.5310735\r\n   }\r\n  ]\r\n }',
"url:dijit/templates/TitlePane.html":'\x3cdiv\x3e\r\n\t\x3cdiv data-dojo-attach-event\x3d"ondijitclick:_onTitleClick, onkeydown:_onTitleKey"\r\n\t\t\tclass\x3d"dijitTitlePaneTitle" data-dojo-attach-point\x3d"titleBarNode" id\x3d"${id}_titleBarNode"\x3e\r\n\t\t\x3cdiv class\x3d"dijitTitlePaneTitleFocus" data-dojo-attach-point\x3d"focusNode"\x3e\r\n\t\t\t\x3cspan data-dojo-attach-point\x3d"arrowNode" class\x3d"dijitInline dijitArrowNode" role\x3d"presentation"\x3e\x3c/span\r\n\t\t\t\x3e\x3cspan data-dojo-attach-point\x3d"arrowNodeInner" class\x3d"dijitArrowNodeInner"\x3e\x3c/span\r\n\t\t\t\x3e\x3cspan data-dojo-attach-point\x3d"titleNode" class\x3d"dijitTitlePaneTextNode"\x3e\x3c/span\x3e\r\n\t\t\x3c/div\x3e\r\n\t\x3c/div\x3e\r\n\t\x3cdiv class\x3d"dijitTitlePaneContentOuter" data-dojo-attach-point\x3d"hideNode" role\x3d"presentation"\x3e\r\n\t\t\x3cdiv class\x3d"dijitReset" data-dojo-attach-point\x3d"wipeNode" role\x3d"presentation"\x3e\r\n\t\t\t\x3cdiv class\x3d"dijitTitlePaneContentInner" data-dojo-attach-point\x3d"containerNode" role\x3d"region" id\x3d"${id}_pane" aria-labelledby\x3d"${id}_titleBarNode"\x3e\r\n\t\t\t\t\x3c!-- nested divs because wipeIn()/wipeOut() doesn\'t work right on node w/padding etc.  Put padding on inner div. --\x3e\r\n\t\t\t\x3c/div\x3e\r\n\t\t\x3c/div\x3e\r\n\t\x3c/div\x3e\r\n\x3c/div\x3e\r\n',
"url:widgets/GridOverlay/setting/Setting.html":'\x3cdiv style\x3d"width:100%;height:100%;overflow:hidden;" class\x3d"nihilo"\x3e\r\n  \x3cdiv class\x3d\'neo\'\x3e\r\n    \x3ctable class\x3d"settings-section"\x3e\r\n      \x3ctbody\x3e\r\n        \x3ctr\x3e\r\n          \x3ctd class\x3d\'sectionTitle\' colspan\x3d"2"\x3e${nls.minIntSpacingLabel}\x3c/td\x3e\r\n        \x3c/tr\x3e\r\n        \x3ctr\x3e\r\n          \x3ctd\x3e\r\n            \x3cdiv class\x3d\'grid-overlay-setting-slider\' data-dojo-attach-point\x3d"minIntervalSpacing"\r\n              data-dojo-type\x3d"dijit/form/HorizontalSlider"\r\n              data-dojo-props\x3d"value:100, minimum: 50, maximum:250, discreteValues:41, intermediateChanges:true, showButtons:false"\x3e\r\n            \x3c/div\x3e\r\n          \x3c/td\x3e\r\n          \x3ctd\x3e\r\n            \x3cdiv class\x3d"grid-overlay-setting-slider-value"\x3e\x3cspan class\x3d\'sliderValue\'\r\n                data-dojo-attach-point\x3d"minIntervalSpacingVal"\x3epx\x3c/span\x3e\r\n            \x3c/div\x3e\r\n          \x3c/td\x3e\r\n        \x3c/tr\x3e\r\n        \x3ctr\x3e\r\n          \x3ctd class\x3d\'sectionTitle\' colspan\x3d"2"\x3e${nls.lineOpacityLabel}\x3c/td\x3e\r\n        \x3c/tr\x3e\r\n        \x3ctr\x3e\r\n          \x3ctd\x3e\r\n            \x3cdiv class\x3d\'grid-overlay-setting-slider\' data-dojo-attach-point\x3d"lineOpacity"\r\n              data-dojo-type\x3d"dijit/form/HorizontalSlider"\r\n              data-dojo-props\x3d"value:100, minimum: 0.05, maximum:1, discreteValues:20, intermediateChanges:true, showButtons:false"\x3e\r\n            \x3c/div\x3e\r\n          \x3c/td\x3e\r\n          \x3ctd\x3e\r\n            \x3cdiv class\x3d"grid-overlay-setting-slider-value"\x3e\x3cspan class\x3d\'sliderValue\'\r\n                data-dojo-attach-point\x3d"lineOpacityVal"\x3e%\x3c/span\x3e\x3c/div\x3e\r\n          \x3c/td\x3e\r\n        \x3c/tr\x3e\r\n        \x3ctr\x3e\r\n          \x3ctd class\x3d\'sectionTitle\'\x3e${nls.labelOpacityLabel}\x3c/td\x3e\r\n        \x3c/tr\x3e\r\n        \x3ctr\x3e\r\n          \x3ctd\x3e\r\n            \x3cdiv class\x3d\'grid-overlay-setting-slider\' data-dojo-attach-point\x3d"labelOpacity"\r\n              data-dojo-type\x3d"dijit/form/HorizontalSlider"\r\n              data-dojo-props\x3d"value:100, minimum: 0.05, maximum:1, discreteValues:20, intermediateChanges:true, showButtons:false"\x3e\r\n            \x3c/div\x3e\r\n          \x3c/td\x3e\r\n          \x3ctd\x3e\r\n            \x3cdiv class\x3d"grid-overlay-setting-slider-value"\x3e\x3cspan class\x3d\'sliderValue\'\r\n                data-dojo-attach-point\x3d"labelOpacityVal"\x3e%\x3c/span\x3e\x3c/div\x3e\r\n          \x3c/td\x3e\r\n        \x3c/tr\x3e\r\n        \x3ctr\x3e\r\n          \x3ctd class\x3d\'sectionTitle\'\x3e${nls.verticalLineLabels}\x3c/td\x3e\r\n        \x3c/tr\x3e\r\n        \x3ctr\x3e\r\n          \x3ctd class\x3d\'verticalLineSection\'\x3e\r\n            \x3cdiv class\x3d\'image-labels horizontalLabel\' title\x3d\'${nls.horizontalLabel}\'\r\n              data-dojo-attach-point\x3d"horizontalLabels"\x3e\x3c/div\x3e\r\n            \x3cdiv class\x3d\'image-labels verticalLabel\' title\x3d\'${nls.verticalLabel}\'\r\n              data-dojo-attach-point\x3d"verticalLabels"\x3e\x3c/div\x3e\r\n          \x3c/td\x3e\r\n        \x3c/tr\x3e\r\n      \x3c/tbody\x3e\r\n    \x3c/table\x3e\r\n    \x3cdiv class\x3d"grid-overlay-setting-style"\x3e\r\n      \x3cdiv class\x3d\'sectionTitle\'\x3e${nls.styleHeaderLabel}\x3c/div\x3e\r\n      \x3cdiv style\x3d"clear: both;" class\x3d"esriCTFullWidth esriCTPaddingRight"\x3e\r\n        \x3c!-- 1. --\x3e\r\n        \x3cdiv class\x3d"esriCTFullWidth esriCTBorder"\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTTitle"\x3e${nls.gzd}\x3c/div\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTPadding"\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.colorHeaderLabel}\x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.fontSizeHeaderLabel}\x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.lineWidthHeaderLabel}\x3c/div\x3e\r\n          \x3c/div\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTPadding"\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv data-dojo-attach-point\x3d"colorPicker0" class\x3d"grid-overlay-setting-color-picker"\r\n                  data-dojo-type\x3d"jimu/dijit/ColorPicker"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv class\x3d"font-size" data-dojo-attach-point\x3d"fontSize0" data-dojo-type\x3d"dijit/form/NumberSpinner"\r\n                  data-dojo-props\x3d"intermediateChanges:true, constraints:{min:5,max:72}, value:15"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv class\x3d"font-size" data-dojo-attach-point\x3d"lineSize0" data-dojo-type\x3d"dijit/form/NumberSpinner"\r\n                  data-dojo-props\x3d"intermediateChanges:true, constraints:{min:1,max:10}, value:2"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n          \x3c/div\x3e\r\n        \x3c/div\x3e\r\n\r\n\r\n        \x3c!-- 2. --\x3e\r\n        \x3cdiv class\x3d"esriCTFullWidth esriCTBorder"\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTTitle" data-dojo-attach-point\x3d"gsidNode"\x3e\x3c/div\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTPadding"\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.colorHeaderLabel}\x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.fontSizeHeaderLabel}\x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.lineWidthHeaderLabel}\x3c/div\x3e\r\n          \x3c/div\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTPadding"\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv data-dojo-attach-point\x3d"colorPicker1" class\x3d"grid-overlay-setting-color-picker"\r\n                  data-dojo-type\x3d"jimu/dijit/ColorPicker"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv class\x3d"font-size" data-dojo-attach-point\x3d"fontSize1" data-dojo-type\x3d"dijit/form/NumberSpinner"\r\n                  data-dojo-props\x3d"intermediateChanges:true, constraints:{min:5,max:72}, value:15"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv class\x3d"font-size" data-dojo-attach-point\x3d"lineSize1" data-dojo-type\x3d"dijit/form/NumberSpinner"\r\n                  data-dojo-props\x3d"intermediateChanges:true, constraints:{min:1,max:10}, value:2"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n          \x3c/div\x3e\r\n        \x3c/div\x3e\r\n\r\n\r\n        \x3c!-- 3. --\x3e\r\n        \x3cdiv class\x3d"esriCTFullWidth esriCTBorder"\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTTitle" data-dojo-attach-point\x3d"grid10kNode"\x3e\x3c/div\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTPadding"\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.colorHeaderLabel}\x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.fontSizeHeaderLabel}\x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.lineWidthHeaderLabel}\x3c/div\x3e\r\n          \x3c/div\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTPadding"\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv data-dojo-attach-point\x3d"colorPicker2" class\x3d"grid-overlay-setting-color-picker"\r\n                  data-dojo-type\x3d"jimu/dijit/ColorPicker"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv class\x3d"font-size" data-dojo-attach-point\x3d"fontSize2" data-dojo-type\x3d"dijit/form/NumberSpinner"\r\n                  data-dojo-props\x3d"intermediateChanges:true, constraints:{min:5,max:72}, value:15"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv class\x3d"font-size" data-dojo-attach-point\x3d"lineSize2" data-dojo-type\x3d"dijit/form/NumberSpinner"\r\n                  data-dojo-props\x3d"intermediateChanges:true, constraints:{min:1,max:10}, value:2"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n          \x3c/div\x3e\r\n        \x3c/div\x3e\r\n\r\n\r\n        \x3c!-- 4. --\x3e\r\n        \x3cdiv class\x3d"esriCTFullWidth esriCTBorder"\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTTitle" data-dojo-attach-point\x3d"grid1kNode"\x3e\x3c/div\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTPadding"\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.colorHeaderLabel}\x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.fontSizeHeaderLabel}\x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.lineWidthHeaderLabel}\x3c/div\x3e\r\n          \x3c/div\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTPadding"\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv data-dojo-attach-point\x3d"colorPicker3" class\x3d"grid-overlay-setting-color-picker"\r\n                  data-dojo-type\x3d"jimu/dijit/ColorPicker"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv class\x3d"font-size" data-dojo-attach-point\x3d"fontSize3" data-dojo-type\x3d"dijit/form/NumberSpinner"\r\n                  data-dojo-props\x3d"intermediateChanges:true, constraints:{min:5,max:72}, value:15"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv class\x3d"font-size" data-dojo-attach-point\x3d"lineSize3" data-dojo-type\x3d"dijit/form/NumberSpinner"\r\n                  data-dojo-props\x3d"intermediateChanges:true, constraints:{min:1,max:10}, value:2"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n          \x3c/div\x3e\r\n        \x3c/div\x3e\r\n\r\n\r\n        \x3c!-- 5. --\x3e\r\n        \x3cdiv class\x3d"esriCTFullWidth esriCTBorder"\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTTitle"\x3e${nls.grid100m}\x3c/div\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTPadding"\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.colorHeaderLabel}\x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.fontSizeHeaderLabel}\x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.lineWidthHeaderLabel}\x3c/div\x3e\r\n          \x3c/div\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTPadding"\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv data-dojo-attach-point\x3d"colorPicker4" class\x3d"grid-overlay-setting-color-picker"\r\n                  data-dojo-type\x3d"jimu/dijit/ColorPicker"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv class\x3d"font-size" data-dojo-attach-point\x3d"fontSize4" data-dojo-type\x3d"dijit/form/NumberSpinner"\r\n                  data-dojo-props\x3d"intermediateChanges:true, constraints:{min:5,max:72}, value:15"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv class\x3d"font-size" data-dojo-attach-point\x3d"lineSize4" data-dojo-type\x3d"dijit/form/NumberSpinner"\r\n                  data-dojo-props\x3d"intermediateChanges:true, constraints:{min:1,max:10}, value:2"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n          \x3c/div\x3e\r\n        \x3c/div\x3e\r\n\r\n\r\n        \x3c!-- 6. --\x3e\r\n        \x3cdiv class\x3d"esriCTFullWidth esriCTBorder"\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTTitle"\x3e${nls.grid10m}\x3c/div\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTPadding"\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.colorHeaderLabel}\x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.fontSizeHeaderLabel}\x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width esriCTColumnTitle"\x3e${nls.lineWidthHeaderLabel}\x3c/div\x3e\r\n          \x3c/div\x3e\r\n          \x3cdiv class\x3d"esriCTFullWidth esriCTPadding"\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv data-dojo-attach-point\x3d"colorPicker5" class\x3d"grid-overlay-setting-color-picker"\r\n                  data-dojo-type\x3d"jimu/dijit/ColorPicker"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv class\x3d"font-size" data-dojo-attach-point\x3d"fontSize5" data-dojo-type\x3d"dijit/form/NumberSpinner"\r\n                  data-dojo-props\x3d"intermediateChanges:true, constraints:{min:5,max:72}, value:15"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n            \x3cdiv class\x3d"esriCT33Width"\x3e\r\n              \x3cdiv\x3e\r\n                \x3cdiv class\x3d"font-size" data-dojo-attach-point\x3d"lineSize5" data-dojo-type\x3d"dijit/form/NumberSpinner"\r\n                  data-dojo-props\x3d"intermediateChanges:true, constraints:{min:1,max:10}, value:2"\x3e\x3c/div\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n          \x3c/div\x3e\r\n        \x3c/div\x3e\r\n      \x3c/div\x3e\r\n    \x3c/div\x3e\r\n  \x3c/div\x3e\r\n  \x3cdiv data-dojo-attach-point\x3d"sampleMap" class\x3d"grid-overlay-setting-style-map"\x3e\r\n    \x3cdiv class\x3d"basemapButton"\x3e\r\n      \x3cdiv data-dojo-attach-point\x3d"switchBasemapBtn" data-dojo-type\x3d"dijit/TitlePane" data-dojo-props\x3d"open:false"\x3e\r\n        \x3cdiv data-dojo-type\x3d"dijit/layout/ContentPane" style\x3d"width:400px; height:280px; overflow:auto;"\x3e\r\n          \x3cdiv data-dojo-attach-point\x3d"basemapGalleryWidget"\x3e\x3c/div\x3e\r\n        \x3c/div\x3e\r\n      \x3c/div\x3e\r\n    \x3c/div\x3e\r\n  \x3c/div\x3e\r\n\x3c/div\x3e',
"url:widgets/GridOverlay/setting/css/style.css":'.grid-overlay-setting .grid-overlay-setting-style {padding-top: 10px;}.grid-overlay-setting .grid-overlay-setting-style table {color: #333333; width: 100%; border-collapse: collapse; table-layout: fixed; font-size: 13px;}.grid-overlay-setting .esriCTColumnTitle {font-size: 13.5px; color: #000000; word-break: break-all; padding: 0 2px 0 2px;}.grid-overlay-setting .grid-overlay-setting-style tr {background-color: #ffffff;}.grid-overlay-setting .grid-overlay-setting-style td {padding: 5px;}.grid-overlay-setting .settings-section {padding-bottom: 0px;}.grid-overlay-setting .label-section {padding-bottom: 0px;}.grid-overlay-setting .labelHeaderGridCompCol {width: 40%;}.grid-overlay-setting .labelHeaderColorCol {width: 20%;}.grid-overlay-setting .labelHeaderFontSizeCol {width: 20%;}.grid-overlay-setting .labelHeaderLineWidthCol {width: 20%;}.grid-overlay-setting .settings-section tr {vertical-align: middle;}.grid-overlay-setting .settings-section\x3etbody\x3etr\x3etd:first-child {width: 100%;}.grid-overlay-setting .settings-section\x3etbody\x3etr:nth-child(2n) {padding-left: 5px; font-size: 12px; letter-spacing: 0.33px;}.grid-overlay-setting .settings-section\x3etbody\x3etr:nth-child(2n+1) {width: 100px; font-size: 14px; letter-spacing: 0.39px;}.grid-overlay-setting .font-size,.line-size {width: 70%; font-style: normal;}.grid-overlay-setting .grid-overlay-setting-color-picker {width: 70%; height: 30px;}.grid-overlay-setting .grid-overlay-setting-color-picker-text {text-align: center; position: relative; top: 50%; transform: translateY(-50%); font-size: 14px;}.grid-overlay-setting .grid-overlay-setting-interval-width {border-color: #000; border-style: hidden solid solid solid; border-width: 1px; height: 10px; margin: auto;}.grid-overlay-setting .grid-overlay-setting-style-map {width: 60%; height: 100%; float: left; padding: 0 5px;}.jimu-rtl .grid-overlay-setting .grid-overlay-setting-style-map {float: right; width: 60%;}.grid-overlay-setting .grid-overlay-setting-slider {width: 100%;}.grid-overlay-setting .grid-overlay-setting-slider-value {width: 50px;}.grid-overlay-setting .neo {float: left; height: 100%; overflow: hidden;}.jimu-rtl .grid-overlay-setting .neo {float: right;}.grid-overlay-setting .sectionTitle {color: #353535; letter-spacing: 0.39px; padding-bottom: 7px; font-size: 14px;}.grid-overlay-setting .sliderValue {font-size: 13px; color: #353535; letter-spacing: 0.39px;}.grid-overlay-setting .gridPlacementSection {width: 80%; margin: auto; display: inline-flex;}.grid-overlay-setting .verticalLineSection {width: 80%; margin: auto; display: inline-flex;}.grid-overlay-setting .image-labels {background-repeat: no-repeat; background-color: transparent; width: 24px; height: 24px; margin-right: 10px; border: 1px solid #CCCCCC;}.grid-overlay-setting .horizontalLabel {background: url("../../images/Horizontal.png");}.grid-overlay-setting .horizontalLabelClicked {background: url("../../images/Horizontal_selected.png"); border: 1px solid #008B9C;}.grid-overlay-setting .horizontalLabel:hover {background: url("../../images/Horizontal_selected.png"); border: 1px solid #008B9C; cursor: pointer;}.grid-overlay-setting .verticalLabel {background: url("../../images/Vertical.png");}.grid-overlay-setting .verticalLabelClicked {background: url("../../images/Vertical_selected.png"); border: 1px solid #008B9C;}.grid-overlay-setting .verticalLabel:hover {background: url("../../images/Vertical_selected.png"); border: 1px solid #008B9C; cursor: pointer;}.grid-overlay-setting .upperLeftLabel {background: url("../../images/Upper_Left.png");}.grid-overlay-setting .upperLeftLabelClicked,.upperLeftLabel:hover {background: url("../../images/Upper_Left_selected.png"); border: 1px solid #008B9C; cursor: pointer;}.grid-overlay-setting .upperRightLabel {background: url("../../images/Upper_Right.png");}.grid-overlay-setting .upperRightLabelClicked,.upperRightLabel:hover {background: url("../../images/Upper_Right_selected.png"); border: 1px solid #008B9C; cursor: pointer;}.grid-overlay-setting .lowerLeftLabel {background: url("../../images/Lower_Left.png");}.grid-overlay-setting .lowerLeftLabelClicked,.lowerLeftLabel:hover {background: url("../../images/Lower_Left_selected.png"); border: 1px solid #008B9C; cursor: pointer;}.grid-overlay-setting .lowerRightLabel {background: url("../../images/Lower_Right.png");}.grid-overlay-setting .lowerRightLabelClicked,.lowerRightLabel:hover {background: url("../../images/Lower_Right_selected.png"); border: 1px solid #008B9C; cursor: pointer;}.grid-overlay-setting .centerLabel {background: url("../../images/Center.png");}.grid-overlay-setting .centerLabelClicked,.centerLabel:hover {background: url("../../images/Center_selected.png"); border: 1px solid #008B9C; cursor: pointer;}.grid-overlay-setting .table-options ul {list-style-type: none; padding: 0;}.grid-overlay-setting .jimu-checkbox {margin-right: 20px; width: 100%;}.grid-overlay-setting .switch-toggle-group {padding: 5px;}.grid-overlay-setting .switch-toggle-group .checkbox-inline {padding-left: 36px; vertical-align: top;}.grid-overlay-setting .switch-toggle-group .switch-toggle.dijitCheckBox {margin-left: -36px;}.grid-overlay-setting .switch-toggle.dijitCheckBox {height: 16px; width: 28px; border: 0 none; background: #adadad; position: relative; display: inline-block; cursor: pointer; -moz-border-radius: 10px; -webkit-border-radius: 10px; border-radius: 10px; margin-left: 2px;}.grid-overlay-setting .switch-toggle.dijitCheckBox:before {content: ""; background: #f8f8f8; position: absolute; padding: 0; height: 12px; width: 12px; left: auto; right: 14px; top: 2px; z-index: 1; -webkit-transition: right 0.3s; -moz-transition: right 0.3s; -o-transition: right 0.3s; transition: right 0.3s; -moz-border-radius: 50%; -webkit-border-radius: 50%; border-radius: 50%;}.grid-overlay-setting .switch-toggle.dijitCheckBox input {width: 100%; height: 100%; position: absolute; left: 0; z-index: 2;}.grid-overlay-setting .switch-toggle.dijitCheckBox.dijitCheckBoxChecked {background: #50ad4e;}.grid-overlay-setting .switch-toggle.dijitCheckBox.dijitCheckBoxChecked:before {right: 2px;}.grid-overlay-setting .basemapButton {position: absolute; right: 22px; top: 2px; z-Index: 999;}.jimu-rtl .grid-overlay-setting .basemapButton {left: 10px; right: auto;}.grid-overlay-setting .mapContentPane {width: 400px; height: 280px; overflow: auto;}.grid-overlay-setting .esriCTFullWidth {width: 100%; overflow: hidden;}.grid-overlay-setting .esriCT33Width {width: 33.33%; float: left;}.jimu-rtl .esriCT33Width {float: right;}.grid-overlay-setting .esriCTBorder {border: 1px solid black; padding: 10px; margin-bottom: 10px;}.grid-overlay-setting .esriCTTitle {margin-bottom: 10px; text-align: center;}.grid-overlay-setting .esriCTPadding {padding-left: 20px;}.jimu-rtl .grid-overlay-setting .esriCTPadding {padding-right: 20px; padding-left: 0px;}.jimu-rtl .grid-overlay-setting .esriCTPaddingRight {padding-left: 10px;} .grid-overlay-setting .esriCTPaddingRight {padding-right: 10px;}.grid-overlay-setting .neo {width: 40%;}.grid-overlay-setting img.esriBasemapGalleryThumbnail {margin: 0px !important;}',
"*now":function(H){H(['dojo/i18n!*preload*widgets/GridOverlay/setting/nls/Setting*["ar","bs","ca","cs","da","de","en","el","es","et","fi","fr","he","hr","hu","id","it","ja","ko","lt","lv","nb","nl","pl","pt-br","pt-pt","ro","ru","sk","sl","sr","sv","th","tr","zh-cn","uk","vi","zh-hk","zh-tw","ROOT"]'])},"*noref":1}});
define("dojo/_base/declare dojo/dom-class dojo/dom-style dojo/query dojo/_base/array dojo/promise/all dojo/Deferred jimu/BaseWidgetSetting dojo/_base/lang dijit/_WidgetsInTemplateMixin dijit/registry dojo/_base/Color ../lib/GridOverlay esri/map esri/dijit/BasemapGallery esri/dijit/BasemapLayer esri/dijit/Basemap jimu/dijit/Message jimu/portalUtils jimu/portalUrlUtils jimu/utils ./utils dojo/string dojo/dom-attr dijit/form/HorizontalSlider dijit/ColorPalette dijit/form/NumberSpinner jimu/dijit/ColorPicker dijit/TitlePane dijit/layout/ContentPane".split(" "),function(H,
g,q,m,n,e,c,a,b,l,h,d,f,k,p,v,t,r,w,u,y,x,z,B){var E=function(A,F){F instanceof d||(F=new d(F));var G=F.toHex();F=128<.2126*F.r+.7152*F.g+.0722*F.b?new d([0,0,0]):new d([255,255,255]);A.innerHTML=y.sanitizeHTML("\x3cdiv class\x3d'grid-overlay-setting-color-picker-text' style\x3d'color:"+(F+";'\x3e")+G+"\x3c/div\x3e")},I=function(A,F,G,O){isNaN(O)?(A.value=5,A.setDisplayedValue(5)):4<O&&73>O&&F.setFontSize(G,O)},C=function(A,F,G,O){isNaN(O)?(A.value=1,A.setDisplayedValue(1)):0<O&&11>O&&F.setLineWidth(G,
O)};return H([a,l],{baseClass:"grid-overlay-setting",verticalLabelsClicked:!1,horizontalLabelsClicked:!1,basemapDict:null,sampmap:null,postCreate:function(){this.setConfig(this.config);this.switchBasemapBtn.set("title",this.nls.switchBasemap);this.sampmap=new k(this.sampleMap,{center:this.map.extent.getCenter(),basemap:"topo",zoom:this.map.getLevel()});this._getBasemapsConfig().then(b.hitch(this,function(G){G.map=this.sampmap;G=new p(G,this.basemapGalleryWidget);G.startup();G.on("selection-change",
b.hitch(this,this._basemapGalleryOnSelectionChanged))}));var A=this,F=new f(b.mixin({map:this.sampmap,enabled:!0},this.config));this.sampleGrid=F;this.minIntervalSpacing.onChange=b.hitch(this,function(G){this.minIntervalSpacingVal.innerHTML=y.sanitizeHTML(window.isRTL?"px"+G:G+"px");F.setMinIntervalSpacing(G)});this.lineOpacity.onChange=b.hitch(this,function(G){this.lineOpacityVal.innerHTML=window.isRTL?y.sanitizeHTML("%"+Math.round(100*G)):y.sanitizeHTML(Math.round(100*G)+"%");F.setLineOpacity(G)});
this.labelOpacity.onChange=b.hitch(this,function(G){this.labelOpacityVal.innerHTML=window.isRTL?y.sanitizeHTML("%"+Math.round(100*G)):y.sanitizeHTML(Math.round(100*G)+"%");F.setLabelOpacity(G)});this.colorPicker0.onChange=function(G){E(this.domNode,G);F.setColor(0,G.toHex())};this.colorPicker1.onChange=function(G){E(this.domNode,G);F.setColor(1,G.toHex())};this.colorPicker2.onChange=function(G){E(this.domNode,G);F.setColor(2,G.toHex())};this.colorPicker3.onChange=function(G){E(this.domNode,G);F.setColor(3,
G.toHex())};this.colorPicker4.onChange=function(G){E(this.domNode,G);F.setColor(4,G.toHex())};this.colorPicker5.onChange=function(G){E(this.domNode,G);F.setColor(5,G.toHex())};this.fontSize0.onChange=function(G){I(this,F,0,G)};this.fontSize1.onChange=function(G){I(this,F,1,G)};this.fontSize2.onChange=function(G){I(this,F,2,G)};this.fontSize3.onChange=function(G){I(this,F,3,G)};this.fontSize4.onChange=function(G){I(this,F,4,G)};this.fontSize5.onChange=function(G){I(this,F,5,G)};this.lineSize0.onChange=
function(G){C(this,F,0,G)};this.lineSize1.onChange=function(G){C(this,F,1,G)};this.lineSize2.onChange=function(G){C(this,F,2,G)};this.lineSize3.onChange=function(G){C(this,F,3,G)};this.lineSize4.onChange=function(G){C(this,F,4,G)};this.lineSize5.onChange=function(G){C(this,F,5,G)};this.verticalLabels.onclick=function(){A.verticalLabelsClicked=!0;A.horizontalLabelsClicked=!1;A._toggleHorzVertOptions(!1);F.setVerticalLabels(A.verticalLabelsClicked)};this.horizontalLabels.onclick=function(){A.verticalLabelsClicked=
!1;A.horizontalLabelsClicked=!0;A._toggleHorzVertOptions(!0);F.setVerticalLabels(!A.horizontalLabelsClicked)};this._addOverflow();this._formatNumberTolocale(1E5,this.nls.gsid,this.gsidNode);this._formatNumberTolocale(1E4,this.nls.grid10k,this.grid10kNode);this._formatNumberTolocale(1E3,this.nls.grid1k,this.grid1kNode)},setConfig:function(){this.minIntervalSpacing.set("value",this.config.minIntervalSpacing);this.minIntervalSpacingVal.innerHTML=window.isRTL?y.sanitizeHTML("px"+this.config.minIntervalSpacing):
y.sanitizeHTML(this.config.minIntervalSpacing+"px");this.lineOpacity.set("value",this.config.lineOpacity);this.lineOpacityVal.innerHTML=window.isRTL?y.sanitizeHTML("%"+Math.round(100*this.config.lineOpacity)):y.sanitizeHTML(Math.round(100*this.config.lineOpacity)+"%");this.labelOpacity.set("value",this.config.labelOpacity);this.labelOpacityVal.innerHTML=window.isRTL?y.sanitizeHTML("%"+Math.round(100*this.config.labelOpacity)):y.sanitizeHTML(Math.round(100*this.config.labelOpacity)+"%");for(var A=
0;6>A;A++)this["colorPicker"+A].setColor(new d(this.config.colors[A])),this["colorPicker"+A].picker.setColor(this.config.colors[A]),E(this["colorPicker"+A].domNode,this.config.colors[A]);this.fontSize0.setValue(this.config.fontSizes[0]);this.fontSize1.setValue(this.config.fontSizes[1]);this.fontSize2.setValue(this.config.fontSizes[2]);this.fontSize3.setValue(this.config.fontSizes[3]);this.fontSize4.setValue(this.config.fontSizes[4]);this.fontSize5.setValue(this.config.fontSizes[5]);this.lineSize0.setValue(this.config.lineWidths[0]);
this.lineSize1.setValue(this.config.lineWidths[1]);this.lineSize2.setValue(this.config.lineWidths[2]);this.lineSize3.setValue(this.config.lineWidths[3]);this.lineSize4.setValue(this.config.lineWidths[4]);this.lineSize5.setValue(this.config.lineWidths[5]);this._toggleHorzVertOptions(!this.config.verticalLabels)},getConfig:function(){return this._checkValidValues()?(new r({message:this.nls.errorMessage}),!1):this.config=this.sampleGrid.getSettings()},_addOverflow:function(){var A=m(".neo",this.domNode);
A&&n.forEach(A,function(F){q.set(F,"overflow-y","scroll")},this)},_checkValidValues:function(){return n.some([this.fontSize0,this.fontSize1,this.fontSize2,this.fontSize3,this.fontSize4,this.fontSize5,this.lineSize0,this.lineSize1,this.lineSize2,this.lineSize3,this.lineSize4,this.lineSize5],function(A){if((A=h.byId(A))&&(A.value<A.constraints.min||A.value>A.constraints.max))return!0},this)},_toggleHorzVertOptions:function(A){A?(g.remove(this.horizontalLabels,"image-labels horizontalLabel"),g.add(this.horizontalLabels,
"image-labels horizontalLabelClicked"),g.remove(this.verticalLabels,"image-labels verticalLabelClicked"),g.add(this.verticalLabels,"image-labels verticalLabel")):(g.remove(this.horizontalLabels,"image-labels horizontalLabelClicked"),g.add(this.horizontalLabels,"image-labels horizontalLabel"),g.remove(this.verticalLabels,"image-labels verticalLabel"),g.add(this.verticalLabels,"image-labels verticalLabelClicked"))},_toggleLabelPlacement:function(A,F){if(A){var G=A.className.replace("image-labels","").trim();
F?(g.remove(A,"image-labels "+G),g.add(A,"image-labels "+G+"Clicked")):(F=G.substring(0,G.indexOf("Clicked")),g.remove(A,"image-labels "+G),g.add(A,"image-labels "+F))}},_basemapGalleryOnSelectionChanged:function(A){A=A.target._selectedBasemap.layers[0].initialExtent;void 0!==A&&this.sampmap.centerAt(A.getCenter())},_getWebmapBasemap:function(){var A=this.map.itemInfo.item.thumbnail?u.getItemUrl(this.appConfig.portalUrl,this.map.itemInfo.item.id)+"/info/"+this.map.itemInfo.item.thumbnail:null;return{title:this.map.itemInfo.itemData.baseMap.title,
thumbnailUrl:A,layers:this.map.itemInfo.itemData.baseMap.baseMapLayers,spatialReference:this.map.spatialReference}},_getBasemapsConfig:function(){var A=new c,F=x._loadPortalBaseMaps(this.appConfig.portalUrl,this.map),G=w.getPortal(this.appConfig.portalUrl).loadSelfInfo();e({portalSelf:G,basemaps:F}).then(b.hitch(this,function(O){var N=O.basemaps,R=[],T=0,W=this._getWebmapBasemap();N=n.filter(N,function(J){if(!J||!J.title)return!1;var P=x.isBingMap(J)?O.portalSelf.bingKey?!0:!1:!0;return J.title&&
P},this);for(T=0;T<N.length&&!x.compareSameBasemapByOrder(N[T],W);T++);T===N.length&&N.push(W);for(T=0;T<N.length;T++){"OpenStreetMap"===N[T].title&&(N[T].title="Open Street Map");W=N[T].layers.length;for(var Y=[],Z=0;Z<W;Z++)Y.push(new v(N[T].layers[Z]));N[T].layers=Y;N[T].thumbnailUrl?/^(https?:)?\/\//.test(N[T].thumbnailUrl)?N[T].thumbnailUrl+=x.getToken(this.appConfig.portalUrl):N[T].thumbnailUrl=y.processUrlInWidgetConfig(N[T].thumbnailUrl,this.folderUrl):N[T].thumbnailUrl=this.folderUrl+"images/default.jpg";
R.push(new t(N[T]))}A.resolve({portalUrl:this.appConfig.portalUrl?this.appConfig.portalUrl:"",basemaps:R,showArcGISBasemaps:!1,bingMapsKey:O.portalSelf.bingKey})}));return A.promise},_formatNumberTolocale:function(A,F,G){A=z.substitute(F,{number:y.localizeNumber(A)});B.set(G,"innerHTML",A)}})});