// All material copyright ESRI, All Rights Reserved, unless otherwise specified.
// See http://@sbaseurl@/jsapi/jsapi/esri/copyright.txt and http://www.arcgis.com/apps/webappbuilder/copyright.txt for details.

//>>built
require({cache:{"esri/dijit/ObliqueViewer":function(){define("dojo/_base/declare dojo/_base/lang dojo/has ../kernel ../tasks/QueryTask ../tasks/query ./_EventedWidget dijit/_Widget ./_ObliqueRotationWidget dojo/_base/array ../ImageSpatialReference ../tasks/ImageServiceProjectTask ../tasks/ProjectParameters ../layers/MosaicRule ../geometry/Extent ../geometry/Polygon ../lang ../config ./RasterList dojo/store/Observable dojo/store/Memory dojo/date/locale dojo/json dojo/number esri/geometry/geometryEngine dojo/Deferred".split(" "),
function(p,q,E,w,b,d,h,n,r,f,z,c,x,A,B,u,k,y,I,J,L,M,C,l,G,D){p=p([h,n],{declaredClass:"esri.dijit.ObliqueViewer",azimuthField:"SensorAzimuth",elevationThreshold:70,elevationField:"SensorElevation",snap:!0,_refreshOK:!0,isNadir:!1,showThumbnail:!0,noQueryOnExtentChange:!1,azimuthTolerance:10,rasterListRefresh:!0,extents:[],center:null,searchRadius:0,searchUnit:"meters",maxExtentIdx:5,currentExtentIdx:null,esriDataType:{decimal:{esriFieldTypeDouble:1,esriFieldTypeSingle:1},integer:{esriFieldTypeInteger:1,
esriFieldTypeSmallInteger:1},date:{esriFieldTypeDate:1},string:{esriFieldTypeString:1},notRequired:{esriFieldTypeGeometry:1,esriFieldTypeBlob:1}},_dateFormats:{shortDate:{datePattern:"M/d/y",selector:"date"},shortDateLE:{datePattern:"d/M/y",selector:"date"},longMonthDayYear:{datePattern:"MMMM d, y",selector:"date"},dayShortMonthYear:{datePattern:"d MMM y",selector:"date"},longDate:{datePattern:"EEEE, MMMM d, y",selector:"date"},shortDateShortTime:{datePattern:"M/d/y",timePattern:"h:mm a",selector:"date and time"},
shortDateLEShortTime:{datePattern:"d/M/y",timePattern:"h:mm a",selector:"date and time"},shortDateShortTime24:{datePattern:"M/d/y",timePattern:"H:mm",selector:"date and time"},shortDateLEShortTime24:{datePattern:"d/M/y",timePattern:"H:mm",selector:"date and time"},shortDateLongTime:{datePattern:"M/d/y",timePattern:"h:mm:ss a",selector:"date and time"},shortDateLELongTime:{datePattern:"d/M/y",timePattern:"h:mm:ss a",selector:"date and time"},shortDateLongTime24:{datePattern:"M/d/y",timePattern:"H:mm:ss",
selector:"date and time"},shortDateLELongTime24:{datePattern:"d/M/y",timePattern:"H:mm:ss",selector:"date and time"},longMonthYear:{datePattern:"MMMM y",selector:"date"},shortMonthYear:{datePattern:"MMM y",selector:"date"},year:{datePattern:"y",selector:"date"}},setNextExtent:function(){if(!(this.currentExtentIdx>=this.maxExtentIdx||this.currentExtentIdx>=this.extents.length-1)){var a=this;this.currentExtentIdx++;var m=new A;m.method=A.METHOD_LOCKRASTER;m.lockRasterIds=[this.extents[this.currentExtentIdx].spatialReference.icsid];
a.imageServiceLayer.setMosaicRule(m,!0);a._refreshOK=!1;a.map.spatialReference=this.extents[this.currentExtentIdx].spatialReference;var e=y.defaults.map.zoomDuration;y.defaults.map.zoomDuration=0;a.map.setExtent(this.extents[this.currentExtentIdx]).then(function(){a._refreshOK=!0;y.defaults.map.zoomDuration=e})}},setPreviousExtent:function(){if(!(0>=this.currentExtentIdx)){var a=this;this.currentExtentIdx--;var m=new A;m.method=A.METHOD_LOCKRASTER;m.lockRasterIds=[this.extents[this.currentExtentIdx].spatialReference.icsid];
a.imageServiceLayer.setMosaicRule(m,!0);a._refreshOK=!1;a.map.spatialReference=this.extents[this.currentExtentIdx].spatialReference;var e=y.defaults.map.zoomDuration;y.defaults.map.zoomDuration=0;a.map.setExtent(this.extents[this.currentExtentIdx]).then(function(){a._refreshOK=!0;y.defaults.map.zoomDuration=e})}},isPreviousAvailable:function(){},isNextAvailable:function(){},_isICS:function(a){return!(!a.ics&&!a.icsid)},resizeRotationGauge:function(a){this._rotationWidget&&this._rotationWidget.resize(a)},
_initializeTasks:function(){this.obliqueRecordsQueryTask=new b(this.imageServiceUrl);this.projectTask=new c},_verifyRasterInfoFields:function(){return this.rasterInfoFields&&this.rasterInfoFields.length},_setupRasterList:function(){var a=this,m=[{name:this.imageServiceLayer.objectIdField,alias:"Object ID",display:!0},{name:this.azimuthField,alias:"Azimuth",display:!0},{name:this.elevationField,alias:this.elevationField,display:!0}];this.rasterInfoFields=this._verifyRasterInfoFields()?this.rasterInfoFields:
m;this.rasterList=new I({data:new J(new L),showThumbnail:this.showThumbnail,imageServiceUrl:this.imageServiceLayer.url,fields:this.rasterInfoFields},this.rasterListDiv);this.rasterList.on("raster-select",function(e){a.selectedRasterId=e[a.imageServiceLayer.objectIdField];a.emit("raster-select",{selectedRasterId:a.selectedRasterId});a.setImage(a.selectedRasterId,a.map.extent);f.forEach(a.filteredRecords,function(v){delete v.attributes.selected;v.attributes[a.imageServiceLayer.objectIdField]===a.selectedRasterId&&
(v.attributes.selected=!0)});a._rotationWidget&&a._rotationWidget.setAzimuth(e[a.azimuthField])});this.rasterList.startup()},_setupRotationWidget:function(){var a=this;this._rotationWidget=new r({snap:this.snap,azimuthAngle:this.azimuthAngle},this.rotationDiv);this._rotationWidget.startup();this.own(this._rotationWidget.on("azimuth-change",function(m){var e=m.azimuth;a.currentExtentIdx=0;a.extents=[];a.emit("azimuth-change",m);e?(a.azimuthAngle=e,a._checkExtentOrientation(),a._filterByAzimuth(),a._refreshRotationWidget({features:a.records}),
a._refreshListDijit(a.filteredRecords),a._refreshImage(a.map.extent),a._oldAzimuth=e,a.isNadir=!1):a._switchToNadir()}))},_refreshRotationWidget:function(a){this._rotationWidget&&this._rotationWidget.refresh(a)},_checkExtentOrientation:function(){var a=Math.abs((this._oldAzimuth-this.azimuthAngle)/90%2);this._azimuthExtentChanged=.25>a||1.75<a?!1:!0},_refreshListDijit:function(a){a=this._prepareListData(a);this.rasterList&&this.rasterListRefresh&&this.rasterList.setData(a);this.emit("records-refresh",
{records:this.records,filteredRecords:this.filteredRecords})},_prepareListData:function(a){var m=[],e,v=this.imageServiceLayer.objectIdField,K=this.imageServiceLayer.credential;f.forEach(a,function(N){e=this._fomatAttributes(q.clone(N.attributes));e.thumbnailUrl=this.imageServiceUrl+"/"+e[v]+"/thumbnail";K&&K.token&&(e.thumbnailUrl+="?token\x3d"+K.token);m.push(e)},this);return new J(new L({data:m,idProperty:this.imageServiceLayer.objectIdField}))},_fomatAttributes:function(a){this.rasterInfoFields.forEach(function(m){a[m.name]=
this._getFormattedValue(m,a[m.name])},this);return a},_getFormattedValue:function(a,m){if(a.format&&k.isDefined(m)){var e=C.parse(a.format);a=a.type;if(a in this.esriDataType.date)return M.format(new Date(m),this._dateFormats[e.dateFormat]);if(a in this.esriDataType.integer||a in this.esriDataType.decimal)return m=l.format(m,{places:e.places}),e.digitSeparator||this._i18n.group&&(m=m.replace(new RegExp("\\"+this._i18n.group,"g"),"")),m}else return m},clearSelection:function(){this.rasterList&&this.rasterList.clearSelection();
f.forEach(this.records,function(a){delete a.attributes.selected});this._refreshListDijit(this.records)},_switchToNadir:function(){var a=!!this.map.extent.spatialReference.icsid,m=this.defaultNadirMosaicRule||this.imageServiceLayer.mosaicRule||new A;this._oldAzimuth=this.azimuthAngle=null;this._azimuthExtentChanged=!1;m.method=m.method||A.METHOD_NONE;m.where=this.elevationField+"\x3e"+this.elevationThreshold;this.defaultNadirMosaicRule=m;this.imageServiceLayer.setMosaicRule(m,a);this.clearSelection();
if(a){var e=this,v;this.projectGeometry(this.map.extent,this.nadirSpatialReference).then(function(K){e._verifyExtent(K[0])&&(e._refreshOK=!1,e.map.spatialReference=K[0].spatialReference,e.spatialReferenceChanged(),v=y.defaults.map.zoomDuration,y.defaults.map.zoomDuration=0,e.map.setExtent((new B(K[0])).setSpatialReference(K[0].spatialReference)).then(function(){e._refreshOK=!0;e.isNadir=!0;y.defaults.map.zoomDuration=v;e.selectedRasterId=null;e.selectedRaster=null;e.filteredRecords=null}))})}},projectGeometry:function(a,
m){var e=new x;m=m||this.map.spatialReference;e.geometries=[a];e.outSR=m;return this.projectTask.execute(e)},_verifyExtent:function(a){return!isNaN(a.xmin)&&!isNaN(a.xmax)&&!isNaN(a.ymin)&&!isNaN(a.ymax)},_verifyPoint:function(a){return!isNaN(a.x)&&!isNaN(a.y)},_refreshRecords:function(a){function m(v){e._verifyExtent(v[0].getExtent())?(e.nadirExtent=v[0].getExtent(),e.search(e._trimExtent(e.nadirExtent,.15)).then(function(K){if(!K||!K.features)return e.emit("no-records",{message:"records not provided.",
extent:e.nadirExtent}),e._refreshRotationWidget({features:[]}),e._refreshListDijit(e.filteredRecords),console.log("Oblique viewer: no records returned");e.records=K.features;e._refreshRotationWidget({features:e.records});e.isNadir?e._refreshListDijit(e.records):(e._filterByAzimuth(),e._refreshListDijit(e.filteredRecords),a&&e.filteredRecords&&e.filteredRecords.length&&e._refreshImage(e.map.extent));e.emit("extent-change",{geometry:e.filteredRecords?e._getIntersectGeometry(v[0]):v[0]})})):(console.error("Oblique viewer: Project Operation returned invalid extent"),
e.search(e._trimExtent(e.map.extent,.15)).then(function(K){if(!K||!K.features)return e.emit("no-records",{message:"records not provided.",extent:e.map.extent}),e._refreshRotationWidget({features:[]}),e._refreshListDijit(e.filteredRecords),console.log("Oblique viewer: no records returned");e.records=K.features;e._refreshRotationWidget({features:e.records});e.isNadir?e._refreshListDijit(e.records):(e._filterByAzimuth(),e._refreshListDijit(e.filteredRecords),a&&e.filteredRecords&&e.filteredRecords.length&&
e._refreshImage((new u(e.filteredRecords[0].geometry)).getExtent()))}))}var e=this;this.nadirSpatialReference.equals(this.map.extent.spatialReference)?m([this.map.extent]):this.projectGeometry(this._convertExtentToPolygon(this.map.extent),this.nadirSpatialReference).then(m)},_convertExtentToPolygon:function(a){var m=new u(a.spatialReference);m.addRing([[a.xmax,a.ymin],[a.xmax,a.ymax],[a.xmin,a.ymax],[a.xmin,a.ymin],[a.xmax,a.ymin]]);return m},postCreate:function(){this.inherited(arguments);this.map&&
this.imageServiceLayer||console.error("ObliqueViewer: Map or Image service layer not provided.");this.imageServiceUrl=this.imageServiceLayer.url;this.nadirSpatialReference=this.map.extent.spatialReference;this._initializeTasks();(this.isNadir=!k.isDefined(this.azimuthAngle))&&this._switchToNadir();this.rotationDiv&&this._setupRotationWidget();if(this.rasterListDiv)if(this.imageServiceLayer.loaded)this._setupRasterList();else this.imageServiceLayer.on("load",q.hitch(this,this._setupRasterList));this.sorter||
(this.sorter=this._sortSpatially);this.own(this.map.on("extent-change",q.hitch(this,function(a){this._refreshOK&&!this.noQueryOnExtentChange&&(this._isICS(this.map.extent.spatialReference)||(this.nadirExtent=this.map.extent,this._switchToNadir(),this.emit("extent-change",{geometry:this.filteredRecords?this._getIntersectGeometry(this._convertExtentToPolygon(this.nadirExtent)):this._convertExtentToPolygon(this.nadirExtent)})),this._refreshRecords(!0),this._azimuthExtentChanged=!1)})));k.isDefined(this.azimuthAngle)&&
!this.noQueryOnExtentChange&&this._refreshRecords()},_refreshImage:function(a){this.filteredRecords&&this.filteredRecords.length&&this.selectedRasterId!==this.filteredRecords[0].attributes[this.imageServiceLayer.objectIdField]?this._setSelectedRaster(a):this._refreshSavedExtents()},_refreshSavedExtents:function(){this._isICS(this.map.extent.spatialReference)&&(this.extents&&this.extents.length?(this.extents.length>this.maxExtentIdx&&(this.extents.shift(),this.currentExtentIdx--),this.currentExtentIdx<
this.extents.length-1?this.currentExtentIdx=this.extents.length-1:this.currentExtentIdx++):(this.currentExtentIdx=0,this.extents=[]),this.extents.push(this.map.extent))},_createExtent:function(a,m,e){var v=e.getWidth()/2*1.00001;e=e.getHeight()/2;return new B(a.x-v,a.y-e,a.x+v,a.y+e,m)},spatialReferenceChanged:function(){this.imageServiceLayer.handleSpatialReferenceChange()},setImage:function(a,m){function e(F){if(g)if(v._verifyPoint(F[0]))t=v._createExtent(F[0],v.imageSpatialReference,g);else return console.log("Project operation returned invalid result.");
else if(g||v._verifyExtent(F[0]))t=F[0];else return console.log("Project operation returned invalid extent.");K=new A;K.method=A.METHOD_LOCKRASTER;K.lockRasterIds=[a];v.imageServiceLayer.setMosaicRule(K,!0);v._refreshOK=!1;v.map.spatialReference=t.spatialReference;v.spatialReferenceChanged();N=y.defaults.map.zoomDuration;O=y.defaults.map.panDuration=0;y.defaults.map.zoomDuration=0;y.defaults.map.panDuration=0;v.map.setExtent((new B(t)).setSpatialReference(t.spatialReference)).then(function(){v._refreshOK=
!0;y.defaults.map.zoomDuration=N;y.defaults.map.panDuration=O;v._refreshSavedExtents();v.projectGeometry(v._convertExtentToPolygon(t),v.nadirSpatialReference).then(function(H){v.emit("extent-change",{geometry:v.filteredRecords?v._getIntersectGeometry(H[0]):H[0]})})});v.center&&v.projectGeometry(v.center,v.imageSpatialReference).then(function(H){v.emit("add-point",{point:H[0]})})}if(!a)return console.error("Object ID of raster to be displayed not provided");var v=this,K,N,O,g=m&&(m.spatialReference.icsid||
m.spatialReference.ics)?m:null,t;this.imageSpatialReference=new z({icsid:a,url:this.imageServiceUrl});m&&m.spatialReference&&!m.spatialReference.ics&&!m.spatialReference.icsid?(v.nadirExtent=m.getExtent(),v.projectGeometry(v.nadirExtent,v.imageSpatialReference).then(e)):this.projectGeometry(this._convertExtentToPolygon(m),this.nadirSpatialReference).then(function(F){v.nadirExtent=F[0].getExtent().setSpatialReference(v.nadirSpatialReference);v.projectGeometry(m.getCenter(),v.imageSpatialReference).then(e)})},
locate:function(a){if(!a)return console.error("Geometry not specified.");var m=this,e;if((e=a.type)&&"extent"===e)var v=a;else e=e&&"point"===e?G.buffer(a,100,"meters"):G.buffer(a.getExtent().getCenter(),100,"meters"),v=e.getExtent();this.center=v.getCenter();this.search(a).then(function(K){m.setData(K.features,v)})},search:function(a){if(!a)return console.error("Oblique viewer: no geometry provided for search.");var m=new D,e=this;var v=new d;v.geometry=a;v.outFields=this._getQueryFields()||[this.imageServiceLayer.objectIdField,
this.azimuthField];v.returnGeometry=!0;v.where=this.elevationField+"\x3c"+this.elevationThreshold;v.outSpatialReference=a.spatialReference;this.obliqueRecordsQueryTask.execute(v).then(function(K){m.resolve({features:e.sorter(e._processRecords(K.features),a)})});return m.promise},_sortSpatially:function(a,m){if(a&&a.length&&this.map.loaded){var e=0,v=0,K=a[0];e=0;v=this.nadirExtent||this.map.extent;m&&"extent"===m.type&&m.spatialReference.equals(a[0].geometry.spatialReference)&&(v=m);m=v.getCenter();
this.selectedRaster&&this._extentContained(this.selectedRaster,v)&&(f.some(a,function(F,H){if(F.attributes[this.imageServiceLayer.objectIdField]===this.selectedRasterId)return t=a[H],a[H]=K,a[0]=t,!0},this),e=1);for(;e<a.length;e++){var N=Math.sqrt((a[e].center.x-m.x)*(a[e].center.x-m.x)+(a[e].center.y-m.y)*(a[e].center.y-m.y));var O=e;for(v=e+1;v<a.length;v++){var g=Math.sqrt((a[v].center.x-m.x)*(a[v].center.x-m.x)+(a[v].center.y-m.y)*(a[v].center.y-m.y));N>g&&(K=a[v],N=g,O=v)}if(e!==O){var t=a[e];
a[e]=K;a[O]=t}}}return a},_filterByAzimuth:function(){this.filteredRecords=[];f.forEach(this.records,function(a){Math.min(Math.abs(a.attributes[this.azimuthField]-this.azimuthAngle),Math.abs(a.attributes[this.azimuthField]-this.azimuthAngle-360))<=this.azimuthTolerance&&this.filteredRecords.push(a)},this);this.filteredRecords&&this.filteredRecords.length&&!this.isNadir&&(this.filteredRecords[0].attributes.selected=!0)},_processRecords:function(a){var m;f.forEach(a,function(e){m=(new u(e.geometry)).setSpatialReference(this.nadirSpatialReference).getCentroid();
e.center=m},this);0===a.length?a=this.selectedRasterId=this.filteredRecords=null:this.emit("records-found",{message:"records are found."});return a},_computeAzimuthFilter:function(){var a=(this.azimuthAngle+350)%360,m=(this.azimuthAngle+10)%360;return a<m?this.azimuthField+" BETWEEN "+a+" AND "+m:"("+this.azimuthField+" BETWEEN 0 AND "+m+" OR "+this.azimuthField+" BETWEEN "+a+" AND 360)"},_getIds:function(a){var m=[],e=this;f.forEach(a,function(v){m.push(v.attributes[e.imageServiceLayer.objectIdField])});
return m},_setRasterListRefreshAttr:function(a){this._set("rasterListRefresh",a);a&&this._refreshListDijit(this.isNadir?this.records:this.filteredRecords)},_extentContained:function(a,m){if(!a||!m)return!1;a=(new u(a.geometry)).getExtent();return this._trimExtent(a,.2).contains(m)},setData:function(a,m){if(!a)return this.emit("no-records",{message:"records not provided.",extent:m}),this._refreshRotationWidget({features:[]}),this._refreshListDijit(this.filteredRecords),console.error("Oblique viewer: records not provided.");
m=m||this.map.extent;this._set("records",a);this._refreshRotationWidget({features:a});this._filterByAzimuth();if(this.filteredRecords&&this.filteredRecords.length)if(this._refreshListDijit(this.filteredRecords),this.imageServiceLayer.loaded)this._setSelectedRaster(m);else this.imageServiceLayer.on("load",q.hitch(this,function(){this._setSelectedRaster(m)}));else this.selectedRasterId=this.selectedRaster=null,this.emit("raster-select",{selectedRasterId:null})},_setSelectedRaster:function(a){this.selectedRaster=
this.filteredRecords[0];this.selectedRasterId=this.selectedRaster.attributes[this.imageServiceLayer.objectIdField];this.setImage(this.selectedRaster.attributes[this.imageServiceLayer.objectIdField],a);this.emit("raster-select",{selectedRasterId:this.selectedRasterId})},setExtent:function(a){var m=new D,e=this;this.projectGeometry(a,this.map.spatialReference).then(function(v){e._verifyExtent(v[0])&&e.map.setExtent(v[0]).then(function(){m.resolve()})});return m.promise},zoomToSelectedImage:function(){if(!k.isDefined(this.selectedRasterId))return console.error("Oblique viewer: no selected raster.");
if(this.isNadir)return console.log("Viewer in nadir mode, no selected raster.");this._getImageGeometry(this.selectedRasterId).then(q.hitch(this,function(a){this.map.setExtent(a.getExtent())}))},_getImageGeometry:function(a){var m=new d,e,v,K=new D;m.objectIds=[a];m.returnGeometry=!0;this.obliqueRecordsQueryTask.execute(m).then(q.hitch(this,function(N){N.features&&N.features.length&&(v=N.features[0])&&v.geometry&&(e=new u(v.geometry),this.projectGeometry(e,this.map.spatialReference).then(q.hitch(this,
function(O){O&&O.length&&(e=(new u(O[0])).setSpatialReference(this.map.spatialReference),K.resolve(e))})))}));return K.promise},_getQueryFields:function(){var a=[];f.forEach(this.rasterInfoFields,function(m){m.name&&a.push(m.name)});0>f.indexOf(a,this.azimuthField)&&a.push(this.azimuthField);0>f.indexOf(a,this.imageServiceLayer.objectIdField)&&a.push(this.imageServiceLayer.objectIdField);return a},_trimExtent:function(a,m){m=m||.15;var e=a.ymax-a.ymin;var v=e*(1-m);m=e*(1-m);e=a.getCenter();return new B({xmin:e.x-
m/2,ymin:e.y-v/2,xmax:e.x+m/2,ymax:e.y+v/2,spatialReference:a.spatialReference})},_getIntersectGeometry:function(a){var m=this,e;if(!k.isDefined(this.selectedRasterId))return a;if(f.some(this.filteredRecords,function(v){if(v.attributes[m.imageServiceLayer.objectIdField]==m.selectedRasterId)return e=v.geometry,!0}))return G.intersect(a,e)}});E("extend-esri")&&q.setObject("dijit.ObliqueViewer",p,w);return p})},"esri/dijit/_ObliqueRotationWidget":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/array dojo/has ../kernel ../lang ./_EventedWidget dijit/_Widget dijit/_TemplatedMixin dojo/text!./templates/_ObliqueRotationWidget.html dojo/_base/html dojo/on dojox/dgauges/CircularGauge ./ObliqueViewer/OVCircularScale dojox/dgauges/CircularRangeIndicator ./ObliqueViewer/OVCircularValueIndicator dojox/dgauges/LinearScaler dojo/dom-geometry dojo/dom-construct dojo/i18n!../nls/jsapi dojo/dom-style dojo/query dojo/dom-attr".split(" "),
function(p,q,E,w,b,d,h,n,r,f,z,c,x,A,B,u,k,y,I,J,L,M,C){p=p([h,n,r],{baseClass:"esriObliqueRotationWidget",declaredClass:"esri.dijit._ObliqueRotationWidget",templateString:f,azimuthAngle:0,azimuthChangeThreshold:10,azimuthField:"SensorAzimuth",isNadir:!1,_rangeIndicatorWidth:8,constructor:function(l,G){q.mixin(this,l);this._i18n=J;this.isNadir=!d.isDefined(this.azimuthAngle)},postCreate:function(){this.inherited(arguments);this._coords=this.domNode.getBoundingClientRect();this._computeCircleRadius();
this._getCenter();this.refresh()},startup:function(){this.inherited(arguments);this._setupGauge();this._addTooltips()},_getFontWeight:function(l){return 120<=l?"bold":"normal"},_getFontSize:function(l){return 120<=l?10:7},labelGap:5,resize:function(l){l=l||Math.min(this.domNode.getBoundingClientRect().height,this.domNode.getBoundingClientRect().width);this._getFontSize(l);var G=this._getFontWeight(l);this._gauge.resize(l,l);this._gauge.set("font",{family:"Helvetica",style:"normal",size:"10pt",color:"black",
weight:G});this._scale.set("labelGap",this.labelGap);this._addTooltips()},_setupGauge:function(){var l=this,G=Math.min(this._coords.height,this._coords.width);this._gauge=new x({value:0,font:{family:"Helvetica",style:"normal",size:this._getFontSize(G)+"pt",color:"black",weight:this._getFontWeight(G)},style:"margin: -2px;"},this.gaugeNode);this._addGaugeBackground();this._addGaugeScale();this._addGaugeIndicators();this._gauge.startup();this.own(c(this._gauge.domNode,"mouseup",function(D){l._getCenter();
var a=D.pageX-l._centerLocnInPage[0];D=D.pageY-l._centerLocnInPage[1];10>=Math.abs(a)&&10>=Math.abs(D)?(l._scale.azimuthAngle=null,l._switchToNadir()):(l.azimuthAngle=l._convertAngleToAzimuthNotation(l._calculateAngleFromXY(a,D)),l._switchToOblique())}));this.own(this._gauge.on("endEditing",q.hitch(this,function(D){l.isNadir||(this.snap&&this._snap(),l.azimuthAngle=this._convertAngleToAzimuthNotation(D.indicator.value),l.emit("azimuth-change",{azimuth:l.azimuthAngle}))})));this.on("azimuth-change",
function(){l.rotateGauge();l._azimuthIndicator.azimuthAngle=l.azimuthAngle;l.textNodes=l.gaugeNode.querySelectorAll("text")})},rotateGauge:function(){this.gaugeNode&&(this.isNadir?(this.rotateAngle=0,this._scale.azimuthAngle=null,L.set(this.gaugeNode,"transform","none")):(this.rotateAngle=this.rotateAngle||0,this.rotateAngle=Math.abs(this.rotateAngle+this.azimuthAngle)>Math.abs(this.rotateAngle-(360-this.azimuthAngle))?360-this.azimuthAngle:0-this.azimuthAngle,L.set(this.gaugeNode,"transform","rotate("+
this.rotateAngle+"deg)"),this._scale.azimuthAngle=this.azimuthAngle))},_addGaugeBackground:function(){var l="M "+this._center.join(",")+"m "+(0-this._radius)+",0 a "+this._radius+","+this._radius+" 0 1,0 "+2*this._radius+",0 a "+this._radius+","+this._radius+" 0 1,0 "+-(2*this._radius)+",0";this._gauge.addElement("background",function(G){G.createPath({path:l}).setFill("rgba(255,255,255,0.8)").setStroke("rgba(89, 106, 114, 1)")});this._addNadirDataIndicator()},_addNadirDataIndicator:function(){var l=
"M "+this._center.join(",")+"m -7,0 a 7,7 0 1,0 14,0 a 7,7 0 1,0 -14,0";this._gauge.addElement("nadirDataIndicator",function(G){G.createPath({path:l}).setFill("#00BDFF").setStroke("rgba(0,0,0, 0)")})},_addGaugeScale:function(){this._scale=new A({originX:this._center[0],originY:this._center[1],radius:this._radius,startAngle:0,endAngle:359.999,orientation:"clockwise",scaler:new k({minimum:0,maximum:360,majorTickInterval:90,minorTickInterval:45}),tickShapeFunc:function(l,G,D){if(!D.isMinor)return l.createLine({x1:0,
y1:0,x2:D.isMinor?15:8,y2:0}).setStroke({color:"black",width:1})},labelGap:this.labelGap,tickLabelFunc:function(l){var G=["E","S","W","N"];return l.isMinor?" ":0===l.value%90?G[l.value/90]:l.value}});this._gauge.addElement("scale",this._scale)},_addGaugeIndicators:function(){var l=new B({value:359.9999,radius:this._radius,startThickness:8,endThickness:8,fill:"rgba(0,0,0,0.6)"});this._scale.addIndicator("indicatorBg",l);this.isNadir?(this._nadirIndicator=this._createNadirIndicator(),this._scale.addIndicator("nadir_indicator",
this._nadirIndicator)):(this._azimuthIndicator=this._createObliqueIndicator(),this._scale.addIndicator("azimuth_indicator",this._azimuthIndicator))},_convertAngleToAzimuthNotation:function(l){if(d.isDefined(l))return(l+90)%360},_convertAngleToGaugeNotation:function(l){if(d.isDefined(l))return(l+270)%360},_computeCircleRadius:function(){var l=Math.min(this._coords.width/2,this._coords.height/2);return this._radius=l=Math.floor(l-2)},showAvailableData:function(l){var G=this,D=this.azimuthAngle;this._snap();
Math.min(Math.abs(this.azimuthAngle-D),Math.abs(Math.abs(this.azimuthAngle-D)-360))>=this.azimuthChangeThreshold&&!this.isNadir&&this.emit("azimuth-change",{azimuth:this.azimuthAngle,noDataSwitch:!0});if(l=l||this.features)for(E.forEach(this._availableDataIndicators,function(m){G._scale.removeIndicator(m)}),this._availableDataIndicators=[],this.features=l,D=0,D=0;D<l.length;D++){var a=new B({start:this._convertAngleToGaugeNotation(l[D].attributes[this.azimuthField]-5),value:this._convertAngleToGaugeNotation(l[D].attributes[this.azimuthField]+
5),radius:this._radius,startThickness:7,endThickness:7,fill:"#00BDFF",stroke:"#00BDFF"});this._scale.addIndicator("indicator_"+D,a);this._availableDataIndicators.push("indicator_"+D)}},refresh:function(l){q.mixin(this,l);this.showAvailableData()},_getCenter:function(){var l=[],G=[];this._coords=this.gaugeNode.getBoundingClientRect();l.push(Math.ceil(this._coords.width/2));l.push(Math.ceil(this._coords.height/2));var D=y.position(this.gaugeNode);G.push(D.x+l[0]);G.push(D.y+l[1]);this._centerLocnInPage=
G;return this._center=l},_snap:function(){if(this._azimuthIndicator&&this.features&&this.features.length){var l=this._convertAngleToAzimuthNotation(this._azimuthIndicator.value),G,D,a=1E3;E.forEach(this.features,function(m){D=Math.min(Math.abs(m.attributes[this.azimuthField]-l),Math.abs(Math.abs(m.attributes[this.azimuthField]-l)-360));D<=a&&(G=m.attributes[this.azimuthField],a=D)},this);this.azimuthAngle=G;this._azimuthIndicator.set("value",this._convertAngleToGaugeNotation(this.azimuthAngle))}},
_switchToNadir:function(){this.isNadir||(this._scale.azimuthAngle=null,this._nadirIndicator=this._createNadirIndicator(),this._scale.removeIndicator("azimuth_indicator"),this._scale.addIndicator("nadir_indicator",this._nadirIndicator),this.isNadir=!0,this.emit("azimuth-change",{azimuth:null}))},_switchToOblique:function(){this.isNadir&&(this._azimuthIndicator=this._createObliqueIndicator(),this._scale.removeIndicator("nadir_indicator"),this._scale.addIndicator("azimuth_indicator",this._azimuthIndicator),
this._snap(),this.isNadir=!1,this.emit("azimuth-change",{azimuth:this.azimuthAngle}))},_createNadirIndicator:function(){return new u({interactionArea:"gauge",title:"Nadir",interactionMode:"none",indicatorShapeFunc:function(l){return l.createPolyline([-7,0,7,0,0,0,0,7,0,-7]).setStroke({color:"#000000",width:1})},value:0})},_createObliqueIndicator:function(){var l=this;return new u({interactionArea:"gauge",title:"Change Azimuth",indicatorShapeFunc:function(G){return G.createPolyline([0,-1,l._radius-
1,-10,l._radius-1,10,0,1,0,-1]).setFill("rgba(0, 189, 255, 0.5)").setStroke("rgba(0, 189, 255, 0.5)")},value:this._convertAngleToGaugeNotation(this.azimuthAngle),azimuthAngle:this._convertAngleToGaugeNotation(this.azimuthAngle)})},_calculateAngleFromXY:function(l,G){l=Math.atan2(G,l);return l/Math.PI*180+(0<l?0:360)},_addTooltips:function(){var l=this,G,D=this.domNode.getBoundingClientRect();D=Math.min(D.width/2,D.height/2);E.forEach(this._tooltipNodes,function(a){this.gaugeNode.removeChild(a.node)},
this);this._tooltipNodes=[{top:0,left:D-5,direction:"north",angle:0},{top:D-5,left:2*(D-5),direction:"east",angle:90},{top:2*(D-5),left:D,direction:"south",angle:180},{top:D-5,left:0,direction:"west",angle:270},{top:D-5,left:D-5,direction:"nadir",angle:null}];E.forEach(this._tooltipNodes,function(a){G=I.create("div");G.style.top=a.top+"px";G.style.left=a.left+"px";G.style.position="absolute";G.style.height="10px";G.style.width="10px";G.style.cursor="pointer";G.style.zIndex=999;G.id=this.domNode.id+
"_tooltip_"+a.direction;I.place(G,this.gaugeNode);G.title=this._i18n.widgets.obliqueViewer[a.direction+"Tooltip"];G.onclick=function(){d.isDefined(a.angle)&&(l.azimuthAngle=a.angle,l._azimuthIndicator.set("value",l._convertAngleToGaugeNotation(a.angle)),l.snap&&l._snap(),l.emit("azimuth-change",{azimuth:l.azimuthAngle}))};a.node=G},this)},setAzimuth:function(l){d.isDefined(l)&&(this.azimuthAngle=l,this.isNadir?this._switchToOblique():this._azimuthIndicator.set("value",this._convertAngleToGaugeNotation(this.azimuthAngle)))}});
w("extend-esri")&&q.setObject("dijit._ObliqueRotationWidget",p,b);return p})},"dojox/dgauges/CircularGauge":function(){define(["dojo/_base/declare","dojo/dom-geometry","dojox/gfx","./GaugeBase"],function(p,q,E,w){return p("dojox.dgauges.CircularGauge",w,{_transformProperties:null,refreshRendering:function(){if(!(0>=this._widgetBox.w||0>=this._widgetBox.h)){for(var b in this._elementsIndex)this._elementsRenderers[b]=this._elementsIndex[b].refreshRendering();var d=this._computeBoundingBox(this._gfxGroup),
h=(d.x+d.width)/(d.y+d.height),n=this._widgetBox.w,r=this._widgetBox.h,f=b=0,z=0,c=0;h>this._widgetBox.w/this._widgetBox.h?(c=n,z=c/h,f=(r-z)/2):(z=r,c=z*h,b=(n-c)/2);d=Math.max(c/(d.x+d.width),z/(d.y+d.height));this._transformProperties={scale:d,tx:b,ty:f};this._gfxGroup.setTransform([E.matrix.scale(d),E.matrix.translate(b/d,f/d)])}},_gaugeToPage:function(b,d){if(this._transformProperties){var h=q.position(this.domNode,!0);return{x:h.x+b*this._transformProperties.scale+this._transformProperties.tx,
y:h.y+d*this._transformProperties.scale+this._transformProperties.ty}}return null}})})},"dojox/dgauges/GaugeBase":function(){define("dojo/_base/lang dojo/_base/declare dojo/dom-geometry dijit/registry dijit/_WidgetBase dojo/_base/html dojo/_base/event dojox/gfx dojox/widget/_Invalidating ./ScaleBase dojox/gfx/matrix".split(" "),function(p,q,E,w,b,d,h,n,r,f,z){return q("dojox.dgauges.GaugeBase",[b,r],{_elements:null,_scales:null,_elementsIndex:null,_elementsRenderers:null,_gfxGroup:null,_mouseShield:null,
_widgetBox:null,_node:null,value:0,_mainIndicator:null,_getValueAttr:function(){if(this._mainIndicator)return this._mainIndicator.get("value");this._setMainIndicator();return this._mainIndicator?this._mainIndicator.get("value"):this.value},_setValueAttr:function(c){this._set("value",c);this._mainIndicator?this._mainIndicator.set("value",c):(this._setMainIndicator(),this._mainIndicator&&this._mainIndicator.set("value",c))},_setMainIndicator:function(){for(var c,x=0;x<this._scales.length;x++)if(c=this._scales[x].getIndicator("indicator"))this._mainIndicator=
c},_resetMainIndicator:function(){this._mainIndicator=null},font:null,constructor:function(c,x){this.font={family:"Helvetica",style:"normal",variant:"small-caps",weight:"bold",size:"10pt",color:"black"};this._elements=[];this._scales=[];this._elementsIndex={};this._elementsRenderers={};this._node=w.byId(x);c=d.getMarginBox(x);this.surface=n.createSurface(this._node,c.w||1,c.h||1);this._widgetBox=c;this._baseGroup=this.surface.createGroup();this._mouseShield=this._baseGroup.createGroup();this._gfxGroup=
this._baseGroup.createGroup()},_setCursor:function(c){this._node&&(this._node.style.cursor=c)},_computeBoundingBox:function(c){return c?c.getBoundingBox():{x:0,y:0,width:0,height:0}},destroy:function(){this.surface.destroy();this.inherited(arguments)},resize:function(c,x){switch(arguments.length){case 1:E.setMarginBox(this._node,c);break;case 2:E.setMarginBox(this._node,{w:c,h:x})}var A=E.getMarginBox(this._node);this._widgetBox=A;var B=this.surface.getDimensions();return B.width!=A.w||B.height!=
A.h?(this.surface.setDimensions(A.w,A.h),this._mouseShield.clear(),this._mouseShield.createRect({x:0,y:0,width:A.w,height:A.h}).setFill([0,0,0,0]),this.invalidateRendering()):this},addElement:function(c,x){this._elementsIndex[c]&&this._elementsIndex[c]!=x&&this.removeElement(c);if(p.isFunction(x)){var A={};p.mixin(A,new r);A._name=c;A._gfxGroup=this._gfxGroup.createGroup();A.width=0;A.height=0;A._isGFX=!0;A.refreshRendering=function(){A._gfxGroup.clear();return x(A._gfxGroup,A.width,A.height)};this._elements.push(A);
this._elementsIndex[c]=A}else x._name=c,x._gfxGroup=this._gfxGroup.createGroup(),x._gauge=this,this._elements.push(x),this._elementsIndex[c]=x,x instanceof f&&this._scales.push(x);return this.invalidateRendering()},removeElement:function(c){var x=this._elementsIndex[c];if(x){x._gfxGroup.removeShape();var A=this._elements.indexOf(x);this._elements.splice(A,1);x instanceof f&&(A=this._scales.indexOf(x),this._scales.splice(A,1),this._resetMainIndicator());delete this._elementsIndex[c];delete this._elementsRenderers[c]}this.invalidateRendering();
return x},getElement:function(c){return this._elementsIndex[c]},getElementRenderer:function(c){return this._elementsRenderers[c]},onStartEditing:function(c){},onEndEditing:function(c){}})})},"dojox/widget/_Invalidating":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/Stateful"],function(p,q,E){return p("dojox.widget._Invalidating",E,{invalidatingProperties:null,invalidRendering:!1,postscript:function(w){this.inherited(arguments);if(this.invalidatingProperties)for(var b=this.invalidatingProperties,
d=0;d<b.length;d++)this.watch(b[d],q.hitch(this,this.invalidateRendering)),w&&b[d]in w&&this.invalidateRendering()},addInvalidatingProperties:function(w){this.invalidatingProperties=this.invalidatingProperties?this.invalidatingProperties.concat(w):w},invalidateRendering:function(){this.invalidRendering||(this.invalidRendering=!0,setTimeout(q.hitch(this,this.validateRendering),0))},validateRendering:function(){this.invalidRendering&&(this.refreshRendering(),this.invalidRendering=!1)},refreshRendering:function(){}})})},
"dojox/dgauges/ScaleBase":function(){define("dojo/_base/lang dojo/_base/declare dojox/gfx dojo/_base/array dojox/widget/_Invalidating dojo/_base/sniff".split(" "),function(p,q,E,w,b,d){return q("dojox.dgauges.ScaleBase",b,{scaler:null,font:null,labelPosition:null,labelGap:1,tickStroke:null,_gauge:null,_gfxGroup:null,_bgGroup:null,_fgGroup:null,_indicators:null,_indicatorsIndex:null,_indicatorsRenderers:null,constructor:function(){this._indicators=[];this._indicatorsIndex={};this._indicatorsRenderers=
{};this._gfxGroup=this._gauge=null;this.tickStroke={color:"black",width:8>=d("ie")?1:.5};this.addInvalidatingProperties("scaler font labelGap labelPosition tickShapeFunc tickLabelFunc tickStroke".split(" "));this.watch("scaler",p.hitch(this,this._watchScaler))},postscript:function(h){this.inherited(arguments);h&&h.scaler&&this._watchScaler("scaler",null,h.scaler)},_watchers:null,_watchScaler:function(h,n,r){w.forEach(this._watchers,p.hitch(this,function(f){f.unwatch()}));h=r.watchedProperties;this._watchers=
[];w.forEach(h,p.hitch(this,function(f){this._watchers.push(r.watch(f,p.hitch(this,this.invalidateRendering)))}))},_getFont:function(){var h=this.font;h||(h=this._gauge.font);h||(h=E.defaultFont);return h},positionForValue:function(h){return 0},valueForPosition:function(h){},tickLabelFunc:function(h){return h.isMinor?null:String(h.value)},tickShapeFunc:function(h,n,r){return h.createLine({x1:0,y1:0,x2:r.isMinor?6:10,y2:0}).setStroke(this.tickStroke)},getIndicatorRenderer:function(h){return this._indicatorsRenderers[h]},
removeIndicator:function(h){var n=this._indicatorsIndex[h];if(n){n._gfxGroup.removeShape();var r=this._indicators.indexOf(n);this._indicators.splice(r,1);n._disconnectListeners();delete this._indicatorsIndex[h];delete this._indicatorsRenderers[h]}this._gauge&&this._gauge._resetMainIndicator();this.invalidateRendering();return n},getIndicator:function(h){return this._indicatorsIndex[h]},addIndicator:function(h,n,r){this._indicatorsIndex[h]&&this._indicatorsIndex[h]!=n&&this.removeIndicator(h);this._indicators.push(n);
this._indicatorsIndex[h]=n;this._ticksGroup||this._createSubGroups();n._gfxGroup=(r?this._bgGroup:this._fgGroup).createGroup();n.scale=this;return this.invalidateRendering()},_createSubGroups:function(){this._gfxGroup&&!this._ticksGroup&&(this._bgGroup=this._gfxGroup.createGroup(),this._ticksGroup=this._gfxGroup.createGroup(),this._fgGroup=this._gfxGroup.createGroup())},refreshRendering:function(){this._ticksGroup||this._createSubGroups()}})})},"esri/dijit/ObliqueViewer/OVCircularScale":function(){define(["dojo/_base/declare",
"dojox/dgauges/CircularScale","dojox/gfx"],function(p,q,E){var w=Math.PI/180;return p([q],{_layoutLabel:function(b,d,h,n,r,f,z){var c=this._getFont();d=E._base._getTextBox(d,{font:E.makeFontString(E.makeParameters(E.defaultFont,c))}).w;c=E.normalizedLength(c.size);this.azimuthAngle=this.azimuthAngle||0;var x=this.azimuthAngle*w,A=h+Math.cos(f)*r-d/2,B=n-Math.sin(f)*r-c/2,u=[];var k=A;var y=-Math.tan(f)*k+n+Math.tan(f)*h;y>=B&&y<=B+c&&u.push({x:k,y:y});k=A+d;y=-Math.tan(f)*k+n+Math.tan(f)*h;y>=B&&
y<=B+c&&u.push({x:k,y:y});k=B;y=-1/Math.tan(f)*k+h+1/Math.tan(f)*n;y>=A&&y<=A+d&&u.push({x:y,y:k});k=B+c;y=-1/Math.tan(f)*k+h+1/Math.tan(f)*n;y>=A&&y<=A+d&&u.push({x:y,y:k});if("inside"==z)for(z=0;z<u.length;z++){if(k=u[z],k=this._distance(k.x,k.y,h,n)-r,0<=k){A=h+Math.cos(f)*(r-k)-d/2;B=n-Math.sin(f)*(r-k)-c/2;break}}else for(z=0;z<u.length;z++)if(k=u[z],k=this._distance(k.x,k.y,h,n)-r,0>=k){A=h+Math.cos(f)*(r-k)-d/2;B=n-Math.sin(f)*(r-k)-c/2;break}315<this.azimuthAngle&&360>=this.azimuthAngle||
0<=this.azimuthAngle&&45>=this.azimuthAngle?d/=2:45<this.azimuthAngle&&135>=this.azimuthAngle?(d=0,c/=2):135<this.azimuthAngle&&225>=this.azimuthAngle?(d/=2,c=0):c/=2;b&&b.setTransform([{dx:A+d,dy:B+c,xx:Math.cos(x),xy:-Math.sin(x),yx:Math.sin(x),yy:Math.cos(x)}])}})})},"dojox/dgauges/CircularScale":function(){define(["dojo/_base/declare","dojox/gfx","./ScaleBase","./_circularUtils"],function(p,q,E,w){return p("dojox.dgauges.CircularScale",E,{originX:50,originY:50,radius:50,startAngle:0,endAngle:180,
orientation:"clockwise",constructor:function(){this.labelPosition="inside";this.addInvalidatingProperties("originX originY radius startAngle endAngle orientation".split(" "))},_getOrientationNum:function(){return"cclockwise"==this.orientation?-1:1},positionForValue:function(b){var d=w.computeTotalAngle(this.startAngle,this.endAngle,this.orientation);b=this.scaler.positionForValue(b);return w.modAngle(this.startAngle+this._getOrientationNum()*d*b,360)},_positionForTickItem:function(b){var d=w.computeTotalAngle(this.startAngle,
this.endAngle,this.orientation);return w.modAngle(this.startAngle+this._getOrientationNum()*d*b.position,360)},valueForPosition:function(b){if(this.positionInRange(b)){var d=w.modAngle(this._getOrientationNum()*(b-this.startAngle),360),h=w.computeTotalAngle(this.startAngle,this.endAngle,this.orientation);d/=h}else d=w.modAngle(this.startAngle-b,360),h=360-d,b=w.modAngle(this.endAngle-b,360),d=Math.min(d,h)<Math.min(b,360-b)?0:1;return this.scaler.valueForPosition(d)},positionInRange:function(b){if(this.startAngle==
this.endAngle)return!0;b=w.modAngle(b,360);return 1==this._getOrientationNum()?this.startAngle<this.endAngle?b>=this.startAngle&&b<=this.endAngle:!(b>this.endAngle&&b<this.startAngle):this.startAngle<this.endAngle?!(b>this.startAngle&&b<this.endAngle):b>=this.endAngle&&b<=this.startAngle},_distance:function(b,d,h,n){return Math.sqrt((h-b)*(h-b)+(n-d)*(n-d))},_layoutLabel:function(b,d,h,n,r,f,z){var c=this._getFont();d=q._base._getTextBox(d,{font:q.makeFontString(q.makeParameters(q.defaultFont,c))}).w;
c=q.normalizedLength(c.size);var x=h+Math.cos(f)*r-d/2,A=n-Math.sin(f)*r-c/2,B=[];var u=x;var k=-Math.tan(f)*u+n+Math.tan(f)*h;k>=A&&k<=A+c&&B.push({x:u,y:k});u=x+d;k=-Math.tan(f)*u+n+Math.tan(f)*h;k>=A&&k<=A+c&&B.push({x:u,y:k});u=A;k=-1/Math.tan(f)*u+h+1/Math.tan(f)*n;k>=x&&k<=x+d&&B.push({x:k,y:u});u=A+c;k=-1/Math.tan(f)*u+h+1/Math.tan(f)*n;k>=x&&k<=x+d&&B.push({x:k,y:u});if("inside"==z)for(z=0;z<B.length;z++){if(u=B[z],u=this._distance(u.x,u.y,h,n)-r,0<=u){x=h+Math.cos(f)*(r-u)-d/2;A=n-Math.sin(f)*
(r-u)-c/2;break}}else for(z=0;z<B.length;z++)if(u=B[z],u=this._distance(u.x,u.y,h,n)-r,0>=u){x=h+Math.cos(f)*(r-u)-d/2;A=n-Math.sin(f)*(r-u)-c/2;break}b&&b.setTransform([{dx:x+d/2,dy:A+c}])},refreshRendering:function(){this.inherited(arguments);if(this._gfxGroup&&this.scaler){this.startAngle=w.modAngle(this.startAngle,360);this.endAngle=w.modAngle(this.endAngle,360);this._ticksGroup.clear();for(var b,d,h=this.scaler.computeTicks(),n,r=0;r<h.length;r++){d=h[r];b=this.tickShapeFunc(this._ticksGroup,
this,d);n=this._gauge._computeBoundingBox(b);var f=d.position?this._positionForTickItem(d):this.positionForValue(d.value);b&&b.setTransform([{dx:this.originX,dy:this.originY},q.matrix.rotateg(f),{dx:this.radius-n.width-2*n.x,dy:0}]);if(d=this.tickLabelFunc(d)){b=this._ticksGroup.createText({x:0,y:0,text:d,align:"middle"}).setFont(this._getFont()).setFill(this._getFont().color?this._getFont().color:"black");var z=this.radius;z="inside"==this.labelPosition?z-(n.width+this.labelGap):z+this.labelGap;
this._layoutLabel(b,d,this.originX,this.originY,z,w.toRadians(360-f),this.labelPosition)}}for(var c in this._indicatorsIndex)this._indicatorsRenderers[c]=this._indicatorsIndex[c].invalidateRendering()}}})})},"dojox/dgauges/_circularUtils":function(){define(function(){return{computeTotalAngle:function(p,q,E){return p==q?360:this.computeAngle(p,q,E,360)},modAngle:function(p,q){void 0==q&&(q=6.28318530718);if(p>=q){do p-=q;while(p>=q)}else for(;0>p;)p+=q;return p},computeAngle:function(p,q,E,w){void 0==
w&&(w=6.28318530718);return q==p?w:this.modAngle("clockwise"==E?q<p?w-(p-q):q-p:q<p?p-q:w-(q-p),w)},toRadians:function(p){return p*Math.PI/180},toDegrees:function(p){return 180*p/Math.PI}}})},"dojox/dgauges/CircularRangeIndicator":function(){define(["dojo/_base/declare","./ScaleIndicatorBase","./_circularUtils","dojo/_base/event"],function(p,q,E,w){return p("dojox.dgauges.CircularRangeIndicator",q,{start:0,radius:NaN,startThickness:6,endThickness:6,fill:null,stroke:null,constructor:function(){this.indicatorShapeFunc=
null;this.fill=[255,120,0];this.stroke={color:"black",width:.2};this.interactionMode="none";this.addInvalidatingProperties("start radius startThickness endThickness fill stroke".split(" "))},_interpolateColor:function(b,d,h){return((1-h)*(b>>16&255)+h*(d>>16&255)&255)<<16|((1-h)*(b>>8&255)+h*(d>>8&255)&255)<<8|(1-h)*(b&255)+h*(d&255)&255},_colorsInterpolation:function(b,d,h){for(var n=[],r=0,f=0;f<b.length-1;f++)r=(d[f+1]-d[f])*h,r=Math.round(r),n=n.concat(_colorInterpolation(b[f],b[f+1],r));return n},
_alphasInterpolation:function(b,d,h){for(var n=[],r=0,f=0;f<b.length-1;f++)r=(d[f+1]-d[f])*h,r=Math.round(r),n=n.concat(_alphaInterpolation(b[f],b[f+1],r));return n},_alphaInterpolation:function(b,d,h){d=(d-b)/(h-1);for(var n=[],r=0;r<h;r++)n.push(b+r*d);return n},_colorInterpolation:function(b,d,h){for(var n=[],r=0;r<h;r++)n.push(_interpolateColor(b,d,r/(h-1)));return n},_getEntriesFor:function(b,d){for(var h=[],n,r=0;r<b.length;r++)n=b[r],n=null==n[d]||isNaN(n[d])?r/(b.length-1):n[d],h.push(n);
return h},_drawColorTrack:function(b,d,h,n,r,f,z,c,x,A,B,u){var k=.05;z=6.28318530718-E.computeAngle(f,z,r);isNaN(u)||(u=E.computeAngle(f,u,r),x*=u/z,z=u);u=Math.max(2,Math.floor(z/k));k=z/u;var y=0;z=-c;y=(c-x)/u;"clockwise"==r&&(k=-k);var I=[];r=d+Math.cos(f)*(n+z);c=h-Math.sin(f)*(n+z);I.push(r,c);for(x=0;x<u;x++){var J=f+x*k;r=d+Math.cos(J+k)*(n+z+x*y);c=h-Math.sin(J+k)*(n+z+x*y);I.push(r,c)}isNaN(J)&&(J=f);r=d+Math.cos(J+k)*(n+0+0*(u-1));c=h-Math.sin(J+k)*(n+0+0*(u-1));I.push(r,c);for(x=u-1;0<=
x;x--)J=f+x*k,r=d+Math.cos(J+k)*(n+0+0*x),c=h-Math.sin(J+k)*(n+0+0*x),I.push(r,c);r=d+Math.cos(f)*(n+0);c=h-Math.sin(f)*(n+0);I.push(r,c);r=d+Math.cos(f)*(n+z);c=h-Math.sin(f)*(n+z);I.push(r,c);b.createPolyline(I).setFill(A).setStroke(B)},refreshRendering:function(){this.inherited(arguments);var b=this._gfxGroup;b.clear();var d=this.scale.originX,h=this.scale.originY,n=isNaN(this.radius)?this.scale.radius:this.radius,r=this.scale.orientation,f=E.toRadians(360-this.scale.positionForValue(this.start)),
z=isNaN(this._transitionValue)?this.value:this._transitionValue;z=E.toRadians(360-this.scale.positionForValue(z));this._drawColorTrack(b,d,h,n,r,f,z,this.startThickness,this.endThickness,this.fill,this.stroke,NaN)},_onMouseDown:function(b){this.inherited(arguments);var d=this.scale._gauge._gaugeToPage(this.scale.originX,this.scale.originY);this.set("value",this.scale.valueForPosition(180*Math.atan2(b.pageY-d.y,b.pageX-d.x)/Math.PI));w.stop(b)},_onMouseMove:function(b){this.inherited(arguments);var d=
this.scale._gauge._gaugeToPage(this.scale.originX,this.scale.originY);this.set("value",this.scale.valueForPosition(180*Math.atan2(b.pageY-d.y,b.pageX-d.x)/Math.PI))}})})},"dojox/dgauges/ScaleIndicatorBase":function(){define("dojo/_base/lang dojo/_base/declare dojo/_base/window dojo/on dojo/touch dojo/_base/fx dojox/gfx dojox/widget/_Invalidating ./IndicatorBase".split(" "),function(p,q,E,w,b,d,h,n,r){return q("dojox.dgauges.ScaleIndicatorBase",r,{scale:null,value:0,interactionArea:"gauge",interactionMode:"mouse",
animationDuration:0,animationEaser:null,_indicatorShapeFuncFlag:!0,_interactionAreaFlag:!0,_downListeners:null,_cursorListeners:null,_moveAndUpListeners:null,_transitionValue:NaN,_preventAnimation:!1,_animation:null,constructor:function(){this.watch("value",p.hitch(this,function(){this.valueChanged(this)}));this.watch("value",p.hitch(this,this._startAnimation));this.watch("interactionArea",p.hitch(this,function(){this._interactionAreaFlag=!0}));this.watch("interactionMode",p.hitch(this,function(){this._interactionAreaFlag=
!0}));this.watch("indicatorShapeFunc",p.hitch(this,function(){this._indicatorShapeFuncFlag=!0}));this.addInvalidatingProperties(["scale","value","indicatorShapeFunc","interactionArea","interactionMode"]);this._downListeners=[];this._moveAndUpListeners=[];this._cursorListeners=[]},_startAnimation:function(f,z,c){0!==this.animationDuration&&(this._animation&&(this._preventAnimation||z==c)?this._animation.stop():(this._animation=new d.Animation({curve:[z,c],duration:this.animationDuration,easing:this.animationEaser?
this.animationEaser:d._defaultEasing,onAnimate:p.hitch(this,this._updateAnimation),onEnd:p.hitch(this,this._endAnimation),onStop:p.hitch(this,this._endAnimation)}),this._animation.play()))},_updateAnimation:function(f){this._transitionValue=f;this.invalidateRendering()},_endAnimation:function(){this._transitionValue=NaN;this.invalidateRendering()},refreshRendering:function(){null!==this._gfxGroup&&null!==this.scale&&(this._indicatorShapeFuncFlag&&p.isFunction(this.indicatorShapeFunc)&&(this._gfxGroup.clear(),
this.indicatorShapeFunc(this._gfxGroup,this),this._indicatorShapeFuncFlag=!1),this._interactionAreaFlag&&(this._interactionAreaFlag=this._connectDownListeners()))},valueChanged:function(f){w.emit(this,"valueChanged",{target:this,bubbles:!0,cancelable:!0})},_disconnectDownListeners:function(){for(var f=0;f<this._downListeners.length;f++)this._downListeners[f].remove();this._downListeners=[]},_disconnectMoveAndUpListeners:function(){for(var f=0;f<this._moveAndUpListeners.length;f++)this._moveAndUpListeners[f].remove();
this._moveAndUpListeners=[]},_disconnectListeners:function(){this._disconnectDownListeners();this._disconnectMoveAndUpListeners();this._disconnectCursorListeners()},_connectCursorListeners:function(f){var z=f.on(b.over,p.hitch(this,function(){this.scale._gauge._setCursor("pointer")}));this._cursorListeners.push(z);z=f.on(b.out,p.hitch(this,function(c){this.scale._gauge._setCursor("")}));this._cursorListeners.push(z)},_disconnectCursorListeners:function(){for(var f=0;f<this._cursorListeners.length;f++)this._cursorListeners[f].remove();
this._cursorListeners=[]},_connectDownListeners:function(){this._disconnectDownListeners();this._disconnectCursorListeners();var f=null;if("mouse"==this.interactionMode||"touch"==this.interactionMode)if("indicator"==this.interactionArea)f=this._gfxGroup.on(b.press,p.hitch(this,this._onMouseDown)),this._downListeners.push(f),this._connectCursorListeners(this._gfxGroup);else if("gauge"==this.interactionArea){if(!this.scale||!this.scale._gauge||!this.scale._gauge._gfxGroup)return!0;f=this.scale._gauge._gfxGroup.on(b.press,
p.hitch(this,this._onMouseDown));this._downListeners.push(f);f=this._gfxGroup.on(b.press,p.hitch(this,this._onMouseDown));this._downListeners.push(f);this._connectCursorListeners(this.scale._gauge._gfxGroup)}else if("area"==this.interactionArea){if(!this.scale||!this.scale._gauge||!this.scale._gauge._baseGroup)return!0;f=this.scale._gauge._baseGroup.on(b.press,p.hitch(this,this._onMouseDown));this._downListeners.push(f);f=this._gfxGroup.on(b.press,p.hitch(this,this._onMouseDown));this._downListeners.push(f);
this._connectCursorListeners(this.scale._gauge._baseGroup)}return!1},_connectMoveAndUpListeners:function(){var f=null;f=w(E.doc,b.move,p.hitch(this,this._onMouseMove));this._moveAndUpListeners.push(f);f=w(E.doc,b.release,p.hitch(this,this._onMouseUp));this._moveAndUpListeners.push(f)},_onMouseDown:function(f){this._connectMoveAndUpListeners();this._startEditing()},_onMouseMove:function(f){this._preventAnimation=!0;this._animation&&this._animation.stop()},_onMouseUp:function(f){this._disconnectMoveAndUpListeners();
this._preventAnimation=!1;this._endEditing()},_startEditing:function(){if(this.scale&&this.scale._gauge)this.scale._gauge.onStartEditing({indicator:this})},_endEditing:function(){if(this.scale&&this.scale._gauge)this.scale._gauge.onEndEditing({indicator:this})}})})},"dojox/dgauges/IndicatorBase":function(){define(["dojo/_base/declare","dojox/widget/_Invalidating"],function(p,q){return p("dojox.dgauges.IndicatorBase",q,{value:null})})},"esri/dijit/ObliqueViewer/OVCircularValueIndicator":function(){define(["dojo/_base/declare",
"dojox/gfx","dojox/dgauges/ScaleIndicatorBase","dojo/_base/event"],function(p,q,E,w){return p("esri.dijit.ObliqueViewer.OVCircularValueIndicator",E,{indicatorShapeFunc:function(b,d){return b.createLine({x1:0,y1:0,x2:40,y2:0}).setStroke({color:"black",width:1})},refreshRendering:function(){this.inherited(arguments);var b=isNaN(this._transitionValue)?this.value:this._transitionValue;b=this.scale.positionForValue(b);this._gfxGroup.setTransform([{dx:this.scale.originX,dy:this.scale.originY},q.matrix.rotateg(b)])},
_onMouseDown:function(b){this.inherited(arguments);var d=this.scale._gauge._gaugeToPage(this.scale.originX,this.scale.originY);this.set("value",this.scale.valueForPosition(180*Math.atan2(b.pageY-d.y,b.pageX-d.x)/Math.PI+this.azimuthAngle));w.stop(b)},_onMouseMove:function(b){this.inherited(arguments);var d=this.scale._gauge._gaugeToPage(this.scale.originX,this.scale.originY);this.set("value",this.scale.valueForPosition(180*Math.atan2(b.pageY-d.y,b.pageX-d.x)/Math.PI+this.azimuthAngle))}})})},"dojox/dgauges/LinearScaler":function(){define(["dojo/_base/lang",
"dojo/_base/declare","dojo/Stateful"],function(p,q,E){return q("dojox.dgauges.LinearScaler",E,{minimum:0,maximum:100,snapInterval:1,majorTickInterval:NaN,minorTickInterval:NaN,minorTicksEnabled:!0,majorTicks:null,minorTicks:null,_computedMajorTickInterval:NaN,_computedMinorTickInterval:NaN,constructor:function(){this.watchedProperties="minimum maximum majorTickInterval minorTickInterval snapInterval minorTicksEnabled".split(" ")},_buildMinorTickItems:function(){var w=this.majorTicks,b=[];if(this.maximum>
this.minimum)for(var d=Math.floor((this.maximum-this.minimum)/this.getComputedMajorTickInterval())+1,h=Math.floor(this.getComputedMajorTickInterval()/this.getComputedMinorTickInterval()),n,r=0;r<d-1;r++)for(var f=1;f<h;f++)n={scaler:this,isMinor:!0},n.value=w[r].value+f*this.getComputedMinorTickInterval(),n.position=(Number(n.value)-this.minimum)/(this.maximum-this.minimum),b.push(n);return b},_buildMajorTickItems:function(){var w=[];if(this.maximum>this.minimum)for(var b=Math.floor((this.maximum-
this.minimum)/this.getComputedMajorTickInterval())+1,d,h=0;h<b;h++)d={scaler:this,isMinor:!1},d.value=this.minimum+h*this.getComputedMajorTickInterval(),d.position=(Number(d.value)-this.minimum)/(this.maximum-this.minimum),w.push(d);return w},getComputedMajorTickInterval:function(){if(!isNaN(this.majorTickInterval))return this.majorTickInterval;isNaN(this._computedMajorTickInterval)&&(this._computedMajorTickInterval=(this.maximum-this.minimum)/10);return this._computedMajorTickInterval},getComputedMinorTickInterval:function(){if(!isNaN(this.minorTickInterval))return this.minorTickInterval;
isNaN(this._computedMinorTickInterval)&&(this._computedMinorTickInterval=this.getComputedMajorTickInterval()/5);return this._computedMinorTickInterval},computeTicks:function(){this.majorTicks=this._buildMajorTickItems();this.minorTicks=this.minorTicksEnabled?this._buildMinorTickItems():[];return this.majorTicks.concat(this.minorTicks)},positionForValue:function(w){if(null==w||isNaN(w)||w<=this.minimum)var b=0;w>=this.maximum&&(b=1);isNaN(b)&&(b=(w-this.minimum)/(this.maximum-this.minimum));return b},
valueForPosition:function(w){w=this.minimum+Math.abs(this.minimum-this.maximum)*w;!isNaN(this.snapInterval)&&0<this.snapInterval&&(w=Math.round((w-this.minimum)/this.snapInterval)*this.snapInterval+this.minimum);return w}})})},"esri/tasks/ImageServiceProjectTask":function(){define("dojo/_base/declare dojo/_base/lang dojo/has dojo/_base/Deferred dojo/_base/array ../kernel ../request ../deferredUtils ./Task ../urlUtils ../geometry/jsonUtils".split(" "),function(p,q,E,w,b,d,h,n,r,f,z){p=p(r,{constructor:function(c){this._handler=
q.hitch(this,this._handler)},execute:function(c,x,A){var B=new w(n._dfdCanceller),u=this._url||this._getImageServiceUrl(c);if(u){var k=this._encode(q.mixin({},u.query,{f:"json"},c.toJson())),y=this._handler,I=this._errorHandler,J=z.getJsonType(c.geometries[0]),L=c.outSR;B._pendingDfd=h({url:u.path+"/project",content:k,callbackParamName:"callback",load:function(M){y(M,J,L,x,A,B)},error:function(M){I(M,A,B)}})}else B.reject("Input arguments do not contain image service URL.");return B},_handler:function(c,
x,A,B,u,k){try{var y=this._decodeGeometries(c,x,A);this._successHandler([y],"onComplete",B,k)}catch(I){this._errorHandler(I,u,k)}},_encodeGeometries:function(c){var x=[],A,B=c.length;for(A=0;A<B;A++)x.push(c[A].toJson());return{geometryType:z.getJsonType(c[0]),geometries:x}},_decodeGeometries:function(c,x,A){var B=z.getGeometryType(x),u=[],k={spatialReference:A},y=q.mixin;b.forEach(c.geometries,function(I,J){u[J]=new B(y(I,k))});return u},onComplete:function(){},_getImageServiceUrl:function(c){if(c&&
c.geometries&&c.geometries.length&&c.outSR)if(c.geometries[0].spatialReference||c.geometries[0].spatialReference.url||c.outSR.url)if(c.geometries[0].spatialReference.url&&c.outSR.url&&c.geometries[0].spatialReference.url!==c.outSR.url)this.onError(Error("Input and output spatial reference must be from one image service"));else var x=c.geometries[0].spatialReference&&c.geometries[0].spatialReference.url?c.geometries[0].spatialReference.url:c.outSR.url;else this.onError(Error("Spatial reference doesn't contain Image Service URL"));
x&&(x=f.urlToObject(x));return x}});E("extend-esri")&&q.setObject("tasks.ImageServiceProjectTask",p,d);return p})},"esri/dijit/RasterList":function(){define("dojo/_base/declare dijit/_WidgetBase dijit/_TemplatedMixin dijit/_WidgetsInTemplateMixin dijit/form/CheckBox dojo/_base/array dgrid/OnDemandGrid dgrid/extensions/DijitRegistry dgrid/Selection dojo/_base/lang dojo/dom-class dojo/dom-construct ../lang".split(" "),function(p,q,E,w,b,d,h,n,r,f,z,c,x){var A=p([h,n,r],{selectionMode:"single",selection:!0,
maxRowsPerPage:2,minRowsPerPage:2,farOffRemoval:500});return p([q,E,w],{templateString:'\x3cdiv class\x3d"esriRasterListDiv"\x3e \x3cdiv data-dojo-attach-point \x3d "listDiv" style\x3d"height: 100%; width: 100%;" class\x3d"obliqueRasterList"\x3e\x3c/div\x3e\x3c/div\x3e',showThumbnail:!1,setData:function(B){this.rasterList.set("store",B)},clearSelection:function(){this.rasterList.clearSelection()},refresh:function(B){this.rasterList.refresh({keepScrollPosition:B})},startup:function(){this.inherited(arguments);
var B=this;this.rasterList=new A({store:this.store,minRowsPerPage:5,maxRowsPerPage:6,bufferRows:3,selectionMode:this.selectionMode?this.selectionMode:"single",renderRow:function(u){u=u.attributes||u;var k,y=c.create("div");B.showThumbnail?z.add(y,"esriRasterListThumbnailRow"):z.add(y,"esriRasterListNoThumbnailRow");var I=c.create("div");z.add(I,"esriRasterListInfoTag");d.forEach(B.fields,function(l){x.isDefined(u[l.name])&&l.display&&(k=u[l.name].toFixed&&0<u[l.name].toString().indexOf(".")?u[l.name].toFixed(2):
u[l.name],I.innerHTML+="\x3cstrong\x3e"+l.alias+": \x3c/strong\x3e"+k+"\x3cbr/\x3e")});var J=c.create("table"),L=c.create("tr");z.add(J,"esriRasterListRowTable");if(B.showThumbnail){var M=c.create("img",{className:"esriRasterListThumbnail",src:u.thumbnailUrl}),C=c.create("td");z.add(C,"esriRasterListThumbnailCol");c.place(M,C);c.place(C,L)}M=c.create("td");c.place(I,M);c.place(M,L);B.showCheckbox&&(M=c.create("td"),z.add(M,"esriRasterListCheckboxCol"),C=new b({checked:u.selected}),c.place(C.domNode,
M),c.place(M,L));c.place(L,J);c.place(J,y);u.selected&&B.rasterList.select(B.rasterList.row(u));return y}},this.listDiv);this.rasterList.startup();this.own(this.rasterList.on(".dgrid-row:click",function(u){u=B.rasterList.row(u).data;B.emit("raster-select",u)}),this.rasterList.on(".dgrid-row:mouseover",function(u){u=B.rasterList.row(u).data;B.emit("raster-mouseover",u)}),this.rasterList.on(".dgrid-row:mouseout",function(u){B.emit("raster-mouseout")}),this.rasterList.on("dgrid-select",function(u){B.emit("raster-row-select",
{rasters:u.rows})}))}})})},"dgrid/extensions/DijitRegistry":function(){define(["dojo/_base/declare","dojo/dom-geometry","dijit/registry"],function(p,q,E){return p("dgrid.extensions.DijitRegistry",null,{minSize:0,maxSize:Infinity,layoutPriority:0,showTitle:!0,buildRendering:function(){E.add(this);this.inherited(arguments);this.domNode.setAttribute("widgetId",this.id)},startup:function(){if(!this._started){this.inherited(arguments);var w=E.getEnclosingWidget(this.domNode.parentNode);w&&w.isLayoutContainer&&
this._resizeHandle.remove()}},destroyRecursive:function(){this.destroy()},destroy:function(){this.inherited(arguments);E.remove(this.id)},getChildren:function(){return[]},isLeftToRight:function(){return!this.isRTL},resize:function(w){w&&q.setMarginBox(this.domNode,w);this.inherited(arguments)},_set:function(w,b){this[w]=b},watch:function(){},getParent:function(){return E.getEnclosingWidget(this.domNode.parentNode)}})})},"esri/dijit/ImageServiceMeasure":function(){define("dojo/_base/declare dojo/_base/lang dojo/i18n!../nls/jsapi dojo/text!./templates/ImageServiceMeasure.html dojo/has dojo/on ../kernel dijit/_WidgetBase dijit/_TemplatedMixin dijit/_WidgetsInTemplateMixin ../toolbars/ImageServiceMeasureTool dijit/form/DropDownButton dijit/DropDownMenu dijit/MenuItem dijit/MenuSeparator dijit/PopupMenuItem dijit/RadioMenuItem dijit/CheckedMenuItem ../symbols/SimpleMarkerSymbol ../symbols/SimpleLineSymbol ../symbols/SimpleFillSymbol ../graphic ../InfoTemplate ../geometry/Point dojo/_base/Color dojo/dom-class dojo/_base/array ../tasks/ImageServiceMeasureParameters ../units dojo/dom-construct dijit/form/ToggleButton dojo/html dojo/number".split(" "),
function(p,q,E,w,b,d,h,n,r,f,z,c,x,A,B,u,k,y,I,J,L,M,C,l,G,D,a,m,e,v,K,N,O){w=p([n,r,f],{declaredClass:"esri.dijit.ImageServiceMeasure",templateString:w,widgetsInTemplate:!0,layer:null,map:null,layout:"dropDown",displayOperations:null,markerSymbol:null,lineSymbol:null,fillSymbol:null,displayMeasureResultInPopup:null,angularUnit:null,linearUnit:null,areaUnit:null,_supportedMeasureOperations:[],_supportedUnits:{},_currentGraphic:null,_defaultUnits:{angularUnit:"DECIMAL_DEGREES",linearUnit:"METERS",
areaUnit:"SQUARE_METERS"},_desiredDropDownOrder:"OPERATION_POINT OPERATION_DISTANCE_ANGLE OPERATION_AREA_PERIMETER OPERATION_CENTROID OPERATION_BASE_TOP OPERATION_TOP_TOP_SHADOW OPERATION_BASE_TOP_SHADOW".split(" "),_map3DOperations:{OPERATION_POINT:"OPERATION_POINT_3D",OPERATION_DISTANCE_ANGLE:"OPERATION_DISTANCE_ANGLE_3D",OPERATION_AREA_PERIMETER:"OPERATION_AREA_PERIMETER_3D",OPERATION_CENTROID:"OPERATION_CENTROID_3D",OPERATION_BASE_TOP:"OPERATION_BASE_TOP",OPERATION_TOP_TOP_SHADOW:"OPERATION_TOP_TOP_SHADOW",
OPERATION_BASE_TOP_SHADOW:"OPERATION_BASE_TOP_SHADOW"},_menu:null,_dropDownButton:null,_currentOperation:null,_activeMeasureOpMenuItem:null,_has3DOperations:!1,_enabled3DCheckbox:!1,_dropDownMenuItemMap:{},_toggleButtonMenuItemMap:{},_decimalDegreesConstantValue:"esriDUDecimalDegrees",_decimalDegreesConstantKeyword:"DECIMAL_DEGREES",constructor:function(g){p.safeMixin(this,g);this._setDefaultSymbols();this._i18n=E},startup:function(){this.inherited(arguments)},postCreate:function(){this.map&&this.layer&&
(this.measureToolbar=new z({map:this.map,layer:this.layer}),this.measureToolbar.on("draw-end",q.hitch(this,this._addGraphic)),this.measureToolbar.on("draw-start",q.hitch(this,this._onDrawStart)),this.measureToolbar.on("measure-end",q.hitch(this,this._addInfoWindow)),this.measureToolbar.on("unit-change",q.hitch(this,this._onUnitChange)),d(this.layer,"spatial-reference-change",q.hitch(this,this._removeDraws)),this._supportedMeasureOperations=this._getSupportedMeasureOperations(),this._has3DOperations=
this._check3DSupported(),this._reorderMeasureOperations(),this._supportedUnits=this._getSupportedUnits(),this._setDefaultUnits());this._checkValidLayoutValue();0<this._supportedMeasureOperations.length?"dropDown"===this.layout?this._populateMeasureDropdown():"toolbar"===this.layout&&this._populateMeasureButtons():N.set(this.esriImageServiceMeasure,this._i18n.widgets.imageServiceMeasure.mensurationCapabilitiesAbsentText)},_checkValidLayoutValue:function(){"dropdown"===this.layout.toLowerCase()?this.layout=
"dropDown":"toolbar"===this.layout.toLowerCase()?this.layout="toolbar":(this.layout="dropDown",console.log("Invalid value for layout"))},_getUnitKeyword:function(g){var t=null,F;if(g===this._decimalDegreesConstantValue)t=this._decimalDegreesConstantKeyword;else for(F in e)e.hasOwnProperty(F)&&e[F]===g&&(t=F);return t||null},_setUnitKeyword:function(g,t){var F;this[g]?(F=this._getUnitKeyword(this[g]))?g=F:(g=this._defaultUnits[g],console.log("Incorrect "+t+" supplied. "+t+" set to default.")):g=this._defaultUnits[g];
return g},_setDefaultUnits:function(){this.linearUnit=this._setUnitKeyword("linearUnit","Linear Unit");this.areaUnit=this._setUnitKeyword("areaUnit","Area Unit");this.angularUnit=this._setUnitKeyword("angularUnit","Angular Unit");this.measureToolbar.setLinearUnit(e[this.linearUnit]);this.measureToolbar.setAreaUnit(e[this.areaUnit]);this.measureToolbar.setAngularUnit(e[this.angularUnit])},_getSupportedMeasureOperations:function(){var g=[],t=this.displayOperations||this.measureToolbar.getSupportedMeasureOperations(),
F=this.measureToolbar.getSupportedMeasureOperations(),H;a.forEach(t,function(P){for(H in m)m.hasOwnProperty(H)&&m[H]===P&&(-1<a.indexOf(F,P)?g.push(H):console.log(P+" is not supported by the service."))},this);return g},_getSupportedUnits:function(){var g={},t=[],F=[],H=this.measureToolbar.getSupportedUnits(),P;for(P in H)H.hasOwnProperty(P)&&(F=H[P],t=[],a.forEach(F,function(Q){t.push(this._getUnitString(Q))},this),g[P]=t);return g},_check3DSupported:function(){return this._isSupportedMeasureOperation("OPERATION_POINT_3D")||
this._isSupportedMeasureOperation("OPERATION_DISTANCE_ANGLE_3D")||this._isSupportedMeasureOperation("OPERATION_AREA_PERIMETER_3D")||this._isSupportedMeasureOperation("OPERATION_CENTROID_3D")},_isSupportedMeasureOperation:function(g){return-1<this._supportedMeasureOperations.indexOf(g)},_reorderMeasureOperations:function(){var g=[];a.forEach(this._desiredDropDownOrder,function(t){-1<this._supportedMeasureOperations.indexOf(t)&&g.push(t)},this);this._supportedMeasureOperations=g},_setDefaultSymbols:function(){this.markerSymbol||
(this.markerSymbol=new I,this.markerSymbol.setPath("M16,4.938c-7.732,0-14,4.701-14,10.5c0,1.981,0.741,3.833,2.016,5.414L2,25.272l5.613-1.44c2.339,1.316,5.237,2.106,8.387,2.106c7.732,0,14-4.701,14-10.5S23.732,4.938,16,4.938zM16.868,21.375h-1.969v-1.889h1.969V21.375zM16.772,18.094h-1.777l-0.176-8.083h2.113L16.772,18.094z"),this.markerSymbol.setColor(new G("#00FFFF")));this.lineSymbol||(this.lineSymbol=new J(J.STYLE_SOLID,new G([255,0,0]),1.5));this.fillSymbol||(this.fillSymbol=new L(L.STYLE_SOLID,new J(J.STYLE_DASHDOT,
new G([255,0,0]),2),new G([255,255,0,.25])))},_populateMeasureDropdown:function(){var g;this._menu=new x;a.forEach(this._supportedMeasureOperations,function(F){g=new A({label:this._i18n.widgets.imageServiceMeasure.operationLabel[F],iconClass:m[F]});g.on("click",q.hitch(this,this._onDropDownMenuItemClick,F,g));this._menu.addChild(g);this._dropDownMenuItemMap[F]=g},this);var t=new B;this._menu.addChild(t);this._has3DOperations&&(t=new y({label:this._i18n.widgets.imageServiceMeasure.measure3DLabel,checked:!1}),
t.on("change",q.hitch(this,this._on3DCheckBoxChange)),this._menu.addChild(t),t=new B,this._menu.addChild(t));this._addUnitsMenu();this._dropDownButton=new c({dropDown:this._menu,"class":"esriImageServiceMeasureDropdownContainer"},this.measureDropDownContainer);this._dropDownButton.startup();this._currentOperation=this._defaultOperation=this._supportedMeasureOperations[0];this._toggleButton=new c({label:this._i18n.widgets.imageServiceMeasure.operationLabel[this._defaultOperation],iconClass:m[this._defaultOperation],
"class":"esriImageServiceMeasureToggleButton",dropDown:new x({"class":"esriHiddenDropDownMenu"})},this.toggleButtonDiv);this._toggleButton._buttonNode.title=this._i18n.widgets.imageServiceMeasure.operationLabel[this._defaultOperation];this._toggleButton.startup();this._toggleButton.on("click",q.hitch(this,this._toggle))},_populateMeasureButtons:function(){var g;D.add(this.esriImageServiceMeasure,"esriImageServiceMeasureToolbarLayout");D.add(this.measureButtonContainer,"esriImageServiceMeasureButtonContainer");
this._menu=new x;a.forEach(this._supportedMeasureOperations,function(H){F=v.create("div",{innerHTML:this._i18n.widgets.imageServiceMeasure.operationLabel[H]},this.measureButtonContainer);g=new K({showLabel:!1,checked:!1,label:this._i18n.widgets.imageServiceMeasure.operationLabel[H],iconClass:m[H],baseClass:"esriMeasureButton"},F);g.on("click",q.hitch(this,this._onButtonMenuItemClick,H));this._toggleButtonMenuItemMap[H]=g},this);if(this._has3DOperations){var t=new y({label:this._i18n.widgets.imageServiceMeasure.measure3DLabel,
checked:!1});t.on("change",q.hitch(this,this._on3DCheckBoxToolbarLayoutChange));this._menu.addChild(t);t=new B;this._menu.addChild(t)}this._addUnitsMenu();t=v.create("span",{innerHTML:"|"},this.measureButtonContainer);var F=v.create("div",null,this.measureButtonContainer);this._dropDownButton=new c({dropDown:this._menu,label:this._i18n.widgets.imageServiceMeasure.settings,showLabel:!1,iconClass:"esriMensurationSettingsIcon","class":"esriMeasureSettingsButton"},F);this._dropDownButton.startup();"false"!==
this.displayMeasureResultInPopup&&!1!==this.displayMeasureResultInPopup&&this.displayMeasureResultInPopup||(this.measureResultContainer=v.create("div",{"class":"measureResultContainer"},this.esriImageServiceMeasure),this.esriMeasurementResultLabel=v.create("div",{innerHTML:this._i18n.widgets.imageServiceMeasure.infoWindowTitle,"class":"esriMeasurementResultLabel"},this.measureResultContainer),this.measureResultStringDiv=v.create("div",{"class":"esriMeasurementResultString"},this.measureResultContainer))},
_angularUnitsReqd:function(){if(a.some(this._supportedMeasureOperations,function(g){if("OPERATION_DISTANCE_ANGLE_3D"===g||"OPERATION_DISTANCE_ANGLE"===g)return!0}))return!0},_linearUnitsReqd:function(){if(a.some(this._supportedMeasureOperations,function(g){if(0>g.indexOf("OPERATION_POINT")&&0>g.indexOf("OPERATION_CENTROID"))return!0}))return!0},_areaUnitsReqd:function(){if(a.some(this._supportedMeasureOperations,function(g){if("OPERATION_AREA_PERIMETER_3D"===g||"OPERATION_AREA_PERIMETER"===g)return!0}))return!0},
_addUnitsMenu:function(){var g,t;if(this._angularUnitsReqd()){this.angularUnitMenu=new x;a.forEach(this._supportedUnits.angularUnits,function(H){t=this._isCurrentAngularUnit(H);g=new k({group:"angularUnit",checked:t,label:this._i18n.widgets.imageServiceMeasure.unitLabel[H],"class":t?"esriSelectedOption":""});t&&(this._currentAngularUnitMenuItem=g);g.on("click",q.hitch(this,this._onAngularUnitClick,H,g));this.angularUnitMenu.addChild(g)},this);var F=new u({label:this._i18n.widgets.imageServiceMeasure.angularUnits,
popup:this.angularUnitMenu});this._menu.addChild(F)}this._linearUnitsReqd()&&(this.linearUnitMenu=new x,a.forEach(this._supportedUnits.linearUnits,function(H){t=this._isCurrentLinearUnit(H);g=new k({group:"linearUnit",checked:t,label:this._i18n.widgets.imageServiceMeasure.unitLabel[H],"class":t?"esriSelectedOption":""});t&&(this._currentLinearUnitMenuItem=g);g.on("click",q.hitch(this,this._onLinearUnitClick,H,g));this.linearUnitMenu.addChild(g)},this),F=new u({label:this._i18n.widgets.imageServiceMeasure.linearUnits,
popup:this.linearUnitMenu}),this._menu.addChild(F));this._areaUnitsReqd()&&(this.areaUnitMenu=new x,a.forEach(this._supportedUnits.areaUnits,function(H){t=this._isCurrentAreaUnit(H);g=new k({group:"areaUnit",checked:t,label:this._i18n.widgets.imageServiceMeasure.unitLabel[H],"class":t?"esriSelectedOption":""});t&&(this._currentAreaUnitMenuItem=g);g.on("click",q.hitch(this,this._onAreaUnitClick,H,g));this.areaUnitMenu.addChild(g)},this),F=new u({label:this._i18n.widgets.imageServiceMeasure.areaUnits,
popup:this.areaUnitMenu}),this._menu.addChild(F))},_on3DCheckBoxChange:function(g){var t=this._currentOperation.replace("_3D","");this._enabled3DCheckbox=g;this._dropDownButton.openDropDown();this._activeMeasureOpMenuItem&&(this._activeMeasureOpMenuItem=null,this._onDropDownMenuItemClick(t,this._dropDownMenuItemMap[t]))},_on3DCheckBoxToolbarLayoutChange:function(g){this._enabled3DCheckbox=g;this._dropDownButton.openDropDown();this._enabled3DCheckbox||(this._currentOperation=this._currentOperation.replace("_3D",
""));this._currentOperation&&this._onButtonMenuItemClick(this._currentOperation)},_onDropDownMenuItemClick:function(g,t){var F=t.domNode;this._enabled3DCheckbox&&(g=this._map3DOperations[g]);this._disableMapNavigation();this._removeDraws();this._activeMeasureOpMenuItem?(D.remove(this._activeMeasureOpMenuItem.domNode,"esriSelectedOption"),D.add(F,"esriSelectedOption"),this._activeMeasureOpMenuItem=t,this._currentOperation=g,this._toggleButton.set({label:this._i18n.widgets.imageServiceMeasure.operationLabel[g],
iconClass:m[g.replace("_3D","")]})):(this._activeMeasureOpMenuItem=t,D.add(F,"esriSelectedOption"),this._currentOperation=g,this._toggleButton.set({label:this._i18n.widgets.imageServiceMeasure.operationLabel[g],iconClass:m[g.replace("_3D","")]}),D.add(this._toggleButton._buttonNode,"esriCheckedMeasureButton"));this._toggleButton._buttonNode.title=this._i18n.widgets.imageServiceMeasure.operationLabel[g];this.measureToolbar.activate(m[g]);this.measureToolbar.showDrawTooltip()},_uncheckOtherButtons:function(g){for(var t in this._toggleButtonMenuItemMap)this._toggleButtonMenuItemMap.hasOwnProperty(t)&&
t!==g&&(0<=a.indexOf(this._supportedMeasureOperations,t)?this._toggleButtonMenuItemMap[t].set("checked",!1):delete this._toggleButtonMenuItemMap[t])},_onButtonMenuItemClick:function(g){this._removeDraws();this._enabled3DCheckbox&&(g=this._map3DOperations[g]);this._uncheckOtherButtons(g.replace("_3D",""));this._currentOperation=g;this._toggleButtonMenuItemMap[g.replace("_3D","")].checked?(this._disableMapNavigation(),this.measureToolbar.activate(m[g]),this.measureToolbar.showDrawTooltip()):(this.measureToolbar.deactivate(),
this._enableMapNavigation());this.measureResultStringDiv&&N.set(this.measureResultStringDiv,"")},_isCurrentAngularUnit:function(g){return g===this.angularUnit?!0:!1},_isCurrentLinearUnit:function(g){return g===this.linearUnit?!0:!1},_isCurrentAreaUnit:function(g){return g===this.areaUnit?!0:!1},_onLinearUnitClick:function(g,t){D.remove(this._currentLinearUnitMenuItem.domNode,"esriSelectedOption");D.add(t.domNode,"esriSelectedOption");this._currentLinearUnitMenuItem=t;this.linearUnit=g;this.measureToolbar.setLinearUnit(e[g]);
this._dropDownButton.openDropDown()},_onAngularUnitClick:function(g,t){D.remove(this._currentAngularUnitMenuItem.domNode,"esriSelectedOption");D.add(t.domNode,"esriSelectedOption");this._currentAngularUnitMenuItem=t;this.angularUnit=g;this.measureToolbar.setAngularUnit(e[g]);this._dropDownButton.openDropDown()},_onAreaUnitClick:function(g,t){D.remove(this._currentAreaUnitMenuItem.domNode,"esriSelectedOption");D.add(t.domNode,"esriSelectedOption");this._currentAreaUnitMenuItem=t;this.areaUnit=g;this.measureToolbar.setAreaUnit(e[g]);
this._dropDownButton.openDropDown()},_onDrawStart:function(){this._removeDraws()},_addGraphic:function(g){var t=g.geometry;this.measureToolbar.hideDrawTooltip();g="point"===t.type?this.markerSymbol:"line"===t.type||"polyline"===t.type?this.lineSymbol:this.fillSymbol;this._removeDraws();this._currentGraphic=g=new M(t,g);this.map.graphics.add(g)},_addInfoWindow:function(g){g=this._measureResultString(g.measureResult,g.error);"dropDown"===this.layout||"toolbar"===this.layout&&("true"===this.displayMeasureResultInPopup||
!0===this.displayMeasureResultInPopup)?this._displayInfoWindowMeasureResult(g):"toolbar"===this.layout&&this._displayToolbarMeasureResult(g)},_measureResultString:function(g,t){t="";var F;if(g)for(F in g){if(g.hasOwnProperty(F)&&g[F]&&"name"!==F&&"sensorName"!==F){var H="point"===F&&0<=this._currentOperation.toLowerCase().indexOf("centroid")?this._i18n.widgets.imageServiceMeasure.measureDialog.Centroid:this._i18n.widgets.imageServiceMeasure.measureDialog[F.charAt(0).toUpperCase()+F.slice(1)];if("point"!=
F){var P=this._i18n.widgets.imageServiceMeasure.unitLabel[this._getUnitString(g[F].unit)];var Q=Math.abs(g[F].uncertainty).toFixed(2);var R=this._getDisplayValue(g[F]);t+="\x3cstrong\x3e"+H+"\x3c/strong\x3e: "+O.format(R)+" (\x26plusmn"+O.format(Q)+") "+P+"\x3cbr/\x3e"}else P=g[F].value.x.toFixed(2),R=g[F].value.y.toFixed(2),t+="\x3cstrong\x3e"+H+"\x3c/strong\x3e\x3cbr/\x3e"+this._i18n.widgets.imageServiceMeasure.measureDialog.X+" : "+O.format(P)+"\x3cbr/\x3e"+this._i18n.widgets.imageServiceMeasure.measureDialog.Y+
" : "+O.format(R)+"\x3cbr/\x3e",0<=this._currentOperation.toLowerCase().indexOf("3d")&&void 0!==g[F].value.z&&(H=g[F].value.z.toFixed(2),t+=this._i18n.widgets.imageServiceMeasure.measureDialog.Z+" : "+O.format(H)+"\x3cbr/\x3e")}}else t=this._i18n.widgets.imageServiceMeasure.measurementErrorGeneric;return t},_getDisplayValue:function(g){return this.layer.currentVersion&&10.3<=this.layer.currentVersion?0>g.uncertainty?g.value.toFixed(2):Number(g.displayValue).toString():g.value.toFixed(2)},_getUnitString:function(g){var t;
for(t in e)if(e.hasOwnProperty(t))if(e[t]===g)var F=t;else g===this._decimalDegreesConstantValue&&(F=this._decimalDegreesConstantKeyword);return F},_displayInfoWindowMeasureResult:function(g){if(this._currentGraphic){var t=this._currentGraphic.geometry,F=[this._currentGraphic];if(this._currentGraphic){if("point"===t.type)this._currentInfowindow=t;else if("polyline"===t.type){var H=(t.paths[0][0][0]+t.paths[0][1][0])/2;t=(t.paths[0][0][1]+t.paths[0][1][1])/2;this._currentInfowindow=new l(H,t,this.map.spatialReference)}else"polygon"===
t.type&&(this._currentInfowindow=t.getCentroid());F[0].setInfoTemplate(new C({title:this._i18n.widgets.imageServiceMeasure.infoWindowTitle,content:g}));this.map.infoWindow.setFeatures(F);this.map.infoWindow.show(this._currentInfowindow)}}},_displayToolbarMeasureResult:function(g){N.set(this.measureResultStringDiv,g)},_removeAssociatedGeometry:function(){this._currentGraphic&&(this.map.graphics.remove(this._currentGraphic),this._currentGraphic=null)},_removeDraws:function(){this._removeAssociatedGeometry();
this._currentInfowindow&&(this.map.infoWindow.hide(this._currentInfowindow),this._currentInfowindow=null)},_onUnitChange:function(g){this._addInfoWindow(g)},_toggle:function(){this._activeMeasureOpMenuItem?(this._removeDraws(),D.remove(this._activeMeasureOpMenuItem.domNode,"esriSelectedOption"),this._activeMeasureOpMenuItem=null,this.measureToolbar.deactivate(),D.remove(this._toggleButton._buttonNode,"esriCheckedMeasureButton"),this._enableMapNavigation()):(this._menuItem=this._dropDownMenuItemMap[this._currentOperation.replace("_3D",
"")],this._onDropDownMenuItemClick(this._currentOperation.replace("_3D",""),this._menuItem))},deactivate:function(){this._removeDraws();this._activeMeasureOpMenuItem&&(D.remove(this._activeMeasureOpMenuItem.domNode,"esriSelectedOption"),this._activeMeasureOpMenuItem=null);this._toggleButton&&D.remove(this._toggleButton._buttonNode,"esriCheckedMeasureButton");this.measureResultStringDiv&&N.set(this.measureResultStringDiv,"");"toolbar"===this.layout&&this._currentOperation&&this._toggleButtonMenuItemMap[this._currentOperation.replace("_3D",
"")].set("checked",!1);this.measureToolbar&&this.measureToolbar.deactivate();this._enableMapNavigation()},_disableMapNavigation:function(){this.map.disableMapNavigation();this.map.setInfoWindowOnClick(!1)},_enableMapNavigation:function(){this.map.enableMapNavigation();this.map.setInfoWindowOnClick(!0)},destroy:function(){this.inherited(arguments)}});b("extend-esri")&&q.setObject("dijit.ImageServiceMeasure",w,h);return w})},"esri/toolbars/ImageServiceMeasureTool":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/Color dojo/has ../kernel ./_toolbar ../symbols/SimpleMarkerSymbol ../symbols/SimpleLineSymbol ../symbols/SimpleFillSymbol ./draw ../tasks/ImageServiceMeasureParameters ../tasks/ImageServiceMeasureTask ../geometry/Point dojo/_base/array ../units".split(" "),
function(p,q,E,w,b,d,h,n,r,f,z,c,x,A,B){var u=p("CustomDraw",[f],{returnCurrentPoint:function(){return this._points},hideTooltip:function(){this._options.showTooltips=!1},showTooltip:function(){this._options.showTooltips=!0}});d=p(d,{declaredClass:"esri.toolbars.imageServiceMeasure",_eventMap:{"draw-end":["geometry"],"draw-start":[],"measure-end":["measureResult","error","geometry"],"unit-change":["measureResult","error","geometry"]},_mensurationCapabilitiesMap:{Basic:["OPERATION_POINT","OPERATION_DISTANCE_ANGLE",
"OPERATION_AREA_PERIMETER","OPERATION_CENTROID"],"3D":["OPERATION_POINT_3D","OPERATION_DISTANCE_ANGLE_3D","OPERATION_AREA_PERIMETER_3D","OPERATION_CENTROID_3D"],"Base-Top Height":["OPERATION_BASE_TOP"],"Top-Top Shadow Height":["OPERATION_TOP_TOP_SHADOW"],"Base-Top Shadow Height":["OPERATION_BASE_TOP_SHADOW"]},_supportedMeasureOperations:[],_operationsMap:{OPERATION_POINT:{geometryType:"POINT"},OPERATION_DISTANCE_ANGLE:{geometryType:"LINE"},OPERATION_AREA_PERIMETER:{geometryType:"POLYGON"},OPERATION_BASE_TOP:{geometryType:"LINE"},
OPERATION_BASE_TOP_SHADOW:{geometryType:"LINE"},OPERATION_TOP_TOP_SHADOW:{geometryType:"LINE"},OPERATION_CENTROID:{geometryType:"POLYGON"},OPERATION_POINT_3D:{geometryType:"POINT"},OPERATION_DISTANCE_ANGLE_3D:{geometryType:"LINE"},OPERATION_AREA_PERIMETER_3D:{geometryType:"POLYGON"},OPERATION_CENTROID_3D:{geometryType:"POLYGON"}},_supportedUnits:{linearUnits:"INCHES FEET YARDS MILES NAUTICAL_MILES MILLIMETERS CENTIMETERS DECIMETERS METERS KILOMETERS".split(" "),angularUnits:["RADIANS","DECIMAL_DEGREES"],
areaUnits:"SQUARE_INCHES SQUARE_FEET SQUARE_YARDS ACRES SQUARE_MILES SQUARE_MILLIMETERS SQUARE_CENTIMETERS SQUARE_DECIMETERS SQUARE_METERS ARES HECTARES SQUARE_KILOMETERS".split(" ")},markerSymbol:null,lineSymbol:null,fillSymbol:null,_drawToolbar:null,_currentGeometry:null,_currentOperation:null,linearUnit:null,angularUnit:null,areaUnit:null,_decimalDegreesConstantValue:"esriDUDecimalDegrees",_decimalDegreesConstantKeyword:"DECIMAL_DEGREES",constructor:function(k){p.safeMixin(this,k);this._checkMensurationSupport();
this._setDefaultSymbols()},_checkMensurationSupport:function(){this.layer.mensurationCapabilities?this._setSupportedMeasureOperations():console.log("Mensuration Capabilities not supported.")},_setDefaultSymbols:function(){this.markerSymbol||(this.markerSymbol=new h,this.markerSymbol.setPath("M16,4.938c-7.732,0-14,4.701-14,10.5c0,1.981,0.741,3.833,2.016,5.414L2,25.272l5.613-1.44c2.339,1.316,5.237,2.106,8.387,2.106c7.732,0,14-4.701,14-10.5S23.732,4.938,16,4.938zM16.868,21.375h-1.969v-1.889h1.969V21.375zM16.772,18.094h-1.777l-0.176-8.083h2.113L16.772,18.094z"),
this.markerSymbol.setColor(new E("#00FFFF")));this.lineSymbol||(this.lineSymbol=new n(n.STYLE_SOLID,new E([255,0,0]),1.5));this.fillSymbol||(this.fillSymbol=new r(r.STYLE_SOLID,new n(n.STYLE_DASHDOT,new E([255,0,0]),2),new E([255,255,0,.25])))},_setSupportedMeasureOperations:function(){var k;this._supportedMeasureOperations=[];this.mensurationCapabilities=this.layer.mensurationCapabilities.split(",");A.forEach(this.mensurationCapabilities,function(y){k=this._mensurationCapabilitiesMap[y];A.forEach(k,
function(I){this._supportedMeasureOperations.push(I)},this)},this)},getSupportedMeasureOperations:function(){var k=[];A.forEach(this._supportedMeasureOperations,function(y){k.push(z[y])},this);return k},getSupportedUnits:function(){var k={},y=[],I=[],J;for(J in this._supportedUnits)this._supportedUnits.hasOwnProperty(J)&&(y=this._supportedUnits[J],I=[],A.forEach(y,function(L){L===this._decimalDegreesConstantKeyword?I.push(this._decimalDegreesConstantValue):I.push(B[L])},this),k[J]=I);return k},setLinearUnit:function(k){for(var y in B)B.hasOwnProperty(y)&&
B[y]===k&&(this.linearUnit=y);this._currentGeometry&&this._getUnitChangeResults(this._currentGeometry)},setAngularUnit:function(k){for(var y in B)B.hasOwnProperty(y)&&(B[y]===k?this.angularUnit=y:k===this._decimalDegreesConstantValue&&(this.angularUnit=this._decimalDegreesConstantKeyword));this._currentGeometry&&this._getUnitChangeResults(this._currentGeometry)},setAreaUnit:function(k){for(var y in B)B.hasOwnProperty(y)&&B[y]===k&&(this.areaUnit=y);this._currentGeometry&&this._getUnitChangeResults(this._currentGeometry)},
setMarkerSymbol:function(k){this.markerSymbol=k},setLineSymbol:function(k){this.lineSymbol=k},setFillSymbol:function(k){this.fillSymbol=k},activate:function(k){A.forEach(this._supportedMeasureOperations,function(y){z[y]===k&&(this._currentOperation=y)},this);this.map.setMapCursor("crosshair");this._mapClickHandle=this.map.on("click",q.hitch(this,this._onMapClick));this._mapMouseDownHandle=this.map.on("mouse-down",q.hitch(this,this._onMapMouseDown));this._drawToolbar||(this._drawToolbar=new u(this.map,
{fillSymbol:this.fillSymbol,markerSymbol:this.markerSymbol,lineSymbol:this.lineSymbol}),this._drawToolbar.on("draw-end",q.hitch(this,this._setGeometry)));this._drawToolbar.activate(f[this._operationsMap[this._currentOperation].geometryType])},_onMapClick:function(){if(0===this._drawToolbar.returnCurrentPoint().length)this.onDrawStart()},_onMapMouseDown:function(){if(0===this._drawToolbar.returnCurrentPoint().length)this.onDrawStart()},deactivate:function(){this._drawToolbar&&this._drawToolbar.deactivate();
this.map.setMapCursor("default");this._currentOperation=this._currentGeometry=null;this._mapClickHandle&&(this._mapClickHandle.remove(),this._mapClickHandle=null);this._mapMouseDownHandle&&(this._mapMouseDownHandle.remove(),this._mapMouseDownHandle=null)},hideDrawTooltip:function(){this._drawToolbar.deactivate();this._drawToolbar.hideTooltip();this._drawToolbar.activate(f[this._operationsMap[this._currentOperation].geometryType])},showDrawTooltip:function(){this._drawToolbar.deactivate();this._drawToolbar.showTooltip();
this._drawToolbar.activate(f[this._operationsMap[this._currentOperation].geometryType])},_setGeometry:function(k){k=k.geometry;this.onDrawEnd(k);this._getMensurationResults(k);this._currentGeometry=k},_getImageServiceMeasureParameters:function(k){var y=new z;y.operation=z[this._currentOperation];y.mosaicRule=this.layer.mosaicRule;y.linearUnit=B[this.linearUnit];y.angularUnit=this.angularUnit===this._decimalDegreesConstantKeyword?this._decimalDegreesConstantValue:B[this.angularUnit];y.areaUnit=B[this.areaUnit];
"line"===k.type||"polyline"===k.type?(y.fromGeometry=new x(k.paths[0][0][0],k.paths[0][0][1],this.map.spatialReference),y.toGeometry=new x(k.paths[0][1][0],k.paths[0][1][1],this.map.spatialReference)):y.fromGeometry=k;return y},_getMensurationResults:function(k){k=this._getImageServiceMeasureParameters(k);(new c(this.layer.url)).execute(k,q.hitch(this,this._measureTaskSuccess),q.hitch(this,this._measureTaskError))},_measureTaskSuccess:function(k){this.onMeasureEnd(k,null,this._currentGeometry)},_measureTaskError:function(k){this.onMeasureEnd(null,
k,this._currentGeometry)},_getUnitChangeResults:function(k){k=this._getImageServiceMeasureParameters(k);(new c(this.layer.url)).execute(k,q.hitch(this,this._unitChangeSuccess),q.hitch(this,this._unitChangeError))},_unitChangeSuccess:function(k){this.onUnitChange(k,null,this._currentGeometry)},_unitChangeError:function(k){this.onUnitChange(null,k,this._currentGeometry)},onDrawStart:function(){},onDrawEnd:function(){},onMeasureEnd:function(){},onUnitChange:function(){}});w("extend-esri")&&q.setObject("toolbars.imageServiceMeasure",
d,b);return d})},"esri/tasks/ImageServiceMeasureParameters":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/json dojo/has ../kernel ../geometry/jsonUtils".split(" "),function(p,q,E,w,b,d){p=p(null,{declaredClass:"esri.tasks.ImageServiceMeasureParameters",fromGeometry:null,toGeometry:null,operation:null,pixelSize:null,mosaicRule:!1,linearUnit:null,angularUnit:null,areaUnit:null,toJson:function(h){var n=h&&h.fromGeometry||this.fromGeometry;h={fromGeometry:n,toGeometry:h&&h.toGeometry||
this.toGeometry,measureOperation:this.operation,mosaicRule:this.mosaicRule?E.toJson(this.mosaicRule.toJson()):null,linearUnit:this.linearUnit,angularUnit:this.angularUnit,areaUnit:this.areaUnit};n&&(h.geometryType=d.getJsonType(n));this.pixelSize&&(h.pixelSize=this.pixelSize?E.toJson(this.pixelSize.toJson()):null);return h}});q.mixin(p,{OPERATION_POINT:"esriMensurationPoint",OPERATION_DISTANCE_ANGLE:"esriMensurationDistanceAndAngle",OPERATION_AREA_PERIMETER:"esriMensurationAreaAndPerimeter",OPERATION_BASE_TOP:"esriMensurationHeightFromBaseAndTop",
OPERATION_BASE_TOP_SHADOW:"esriMensurationHeightFromBaseAndTopShadow",OPERATION_TOP_TOP_SHADOW:"esriMensurationHeightFromTopAndTopShadow",OPERATION_CENTROID:"esriMensurationCentroid",OPERATION_POINT_3D:"esriMensurationPoint3D",OPERATION_DISTANCE_ANGLE_3D:"esriMensurationDistanceAndAngle3D",OPERATION_AREA_PERIMETER_3D:"esriMensurationAreaAndPerimeter3D",OPERATION_CENTROID_3D:"esriMensurationCentroid3D"});w("extend-esri")&&q.setObject("tasks.ImageServiceMeasureParameters",p,b);return p})},"esri/tasks/ImageServiceMeasureTask":function(){define("dojo/_base/declare dojo/_base/lang dojo/has ../kernel ../request ../geometry/normalizeUtils ./Task".split(" "),
function(p,q,E,w,b,d,h){p=p(h,{declaredClass:"esri.tasks.ImageServiceMeasureTask",constructor:function(n){this._url.path+="/measure";this._handler=q.hitch(this,this._handler)},__msigns:[{n:"execute",c:3,a:[{i:0,p:["fromGeometry","toGeometry"]}],e:2}],_handler:function(n,r,f,z,c){try{this._successHandler([n],"onComplete",f,c)}catch(x){this._errorHandler(x,z,c)}},execute:function(n,r,f,z){var c=z.assembly;n=this._encode(q.mixin({},this._url.query,{f:"json"},n.toJson(c&&c[0])));var x=this._handler,A=
this._errorHandler;return b({url:this._url.path,content:n,callbackParamName:"callback",load:function(B,u){x(B,u,r,f,z.dfd)},error:function(B){A(B,f,z.dfd)}})},onComplete:function(){}});d._createWrappers(p);E("extend-esri")&&q.setObject("tasks.ImageServiceMeasureTask",p,w);return p})},"dijit/PopupMenuItem":function(){define("dojo/_base/declare dojo/dom-style dojo/_base/lang dojo/query ./popup ./registry ./MenuItem ./hccss".split(" "),function(p,q,E,w,b,d,h){return p("dijit.PopupMenuItem",h,{baseClass:"dijitMenuItem dijitPopupMenuItem",
_fillContent:function(){if(this.srcNodeRef){var n=w("*",this.srcNodeRef);this.inherited(arguments,[n[0]]);this.dropDownContainer=this.srcNodeRef}},_openPopup:function(n,r){var f=this.popup;b.open(E.delegate(n,{popup:this.popup,around:this.domNode}));r&&f.focus&&f.focus()},_closePopup:function(){b.close(this.popup);this.popup.parentMenu=null},startup:function(){if(!this._started){this.inherited(arguments);if(!this.popup){var n=w("[widgetId]",this.dropDownContainer)[0];this.popup=d.byNode(n)}this.ownerDocumentBody.appendChild(this.popup.domNode);
this.popup.domNode.setAttribute("aria-labelledby",this.containerNode.id);this.popup.startup();this.popup.domNode.style.display="none";this.arrowWrapper&&q.set(this.arrowWrapper,"visibility","");this.focusNode.setAttribute("aria-haspopup","true")}},destroyDescendants:function(n){this.popup&&(this.popup._destroyed||this.popup.destroyRecursive(n),delete this.popup);this.inherited(arguments)}})})},"dijit/RadioMenuItem":function(){define("dojo/_base/array dojo/_base/declare dojo/dom-class dojo/query!css2 ./CheckedMenuItem ./registry".split(" "),
function(p,q,E,w,b,d){return q("dijit.RadioButtonMenuItem",b,{baseClass:"dijitMenuItem dijitRadioMenuItem",role:"menuitemradio",checkedChar:"*",group:"",_setGroupAttr:"domNode",_setCheckedAttr:function(h){this.inherited(arguments);this._created&&h&&this.group&&p.forEach(this._getRelatedWidgets(),function(n){n!=this&&n.checked&&n.set("checked",!1)},this)},_onClick:function(h){this.disabled||this.checked||(this.set("checked",!0),this.onChange(!0));this.onClick(h)},_getRelatedWidgets:function(){var h=
[];w("[group\x3d"+this.group+"][role\x3d"+this.role+"]").forEach(function(n){(n=d.getEnclosingWidget(n))&&h.push(n)});return h}})})},"widgets/ObliqueViewer/_build-generate_module":function(){define(["dojo/text!./Widget.html","dojo/text!./css/style.css","dojo/i18n!./nls/strings"],function(){})},"url:esri/dijit/templates/_ObliqueRotationWidget.html":'\x3cdiv\x3e\r\n  \x3cdiv data-dojo-attach-point\x3d"gaugeNode" class\x3d"esriObliqueRotationWidgetGauge"\x3e\r\n  \x3c/div\x3e\r\n\x3c/div\x3e',"url:esri/dijit/templates/ImageServiceMeasure.html":'\x3cdiv data-dojo-attach-point\x3d"esriImageServiceMeasure" class\x3d"esriImageServiceMeasure"\x3e\r\n  \x3cdiv class\x3d"esriImageServiceMeasureToggleButton" data-dojo-attach-point\x3d"toggleButtonDiv"\x3e\r\n  \x3c/div\x3e\r\n  \x3cdiv class\x3d"esriImageServiceMeasureDropdownContainer" data-dojo-attach-point\x3d"measureDropDownContainer"\x3e\r\n  \x3c/div\x3e\r\n  \x3cdiv data-dojo-attach-point\x3d"measureButtonContainer"\x3e\r\n  \x3c/div\x3e\r\n\x3c/div\x3e\r\n',
"url:widgets/ObliqueViewer/Widget.html":'\x3cdiv class\x3d"obliqueViewerWidget"\x3e\r\n  \x3cdiv class\x3d"obliqueViewerWidgetDiv"\x3e\r\n      \x3cdiv id\x3d"ovMap" class\x3d"ovMap"\x3e\r\n        \x3c!-- added or the overlay to show error message  --\x3e\r\n        \x3cdiv id\x3d"info" class\x3d"info" data-dojo-attach-point\x3d"infoDiv"\x3e\r\n          \x3cdiv id\x3d"infoText" data-dojo-attach-point\x3d"infoDivText" \x3e${nls.noImageNotification}\x3c/div\x3e\r\n        \x3c/div\x3e\r\n        \x3cdiv class\x3d"obliqueRotationDivPassive" data-dojo-attach-point\x3d"rotationDivContainer"\x3e\r\n          \x3cdiv data-dojo-attach-point\x3d"obliqueRotationDiv"\x3e\x3c/div\x3e\r\n        \x3c/div\x3e\r\n        \x3cdiv data-dojo-attach-point\x3d"toolbar" class\x3d"toolbar"\x3e\r\n          \x3cdiv data-dojo-attach-point\x3d"locateButtonContainer"\x3e\r\n          \x3c/div\x3e   \r\n          \x3cdiv data-dojo-attach-point\x3d"clearButtonContainer"\x3e\r\n          \x3c/div\x3e \r\n          \x3cdiv data-dojo-attach-point\x3d"zoomButtonContainer"\x3e\r\n          \x3c/div\x3e   \r\n          \x3cdiv data-dojo-attach-point\x3d"syncButtonContainer"\x3e\r\n          \x3c/div\x3e    \r\n          \x3cdiv data-dojo-attach-point\x3d"listTitlePaneDiv" class\x3d"listDivTitlePane"\x3e     \r\n          \x3c/div\x3e\r\n          \x3cdiv data-dojo-attach-point\x3d\'measureWidget\' title\x3d"{nls.measureWidgetLabel}"\x3e\x3c/div\x3e\r\n        \x3c/div\x3e\r\n        \x3cdiv class\x3d"azimuthChangeNotification" data-dojo-attach-point\x3d"notificationDiv"\x3e${nls.azimuthChangeNotification}\x3c/div\x3e\r\n      \x3c/div\x3e\r\n  \x3c/div\x3e\r\n\x3c/div\x3e',
"url:widgets/ObliqueViewer/css/style.css":'.obliqueViewerWidgetDiv {height: 100%; width:100%;}.obliqueViewerWidget, .obliqueViewerWidgetDiv{height: 100%; width: 100%;}.ovMap{height: 100%; width: 100%;}.info {position: absolute; height: 15%; width: 80%; left: 10%; top: 30%; display: none; background-color: rgba(0,0,0,0.5); z-index: 2; cursor: pointer;}#infoText {position: absolute; top: 10%; left: 2%; padding: 2%; font-size: 12px; color: white;}.obliqueViewerWidgetDiv .dijitReset.dijitInline.dijitArrowButtonInner{background-image: url(../images/arrow-drop-down.png) !important; background-position: center;}.esriMensurationHeightFromBaseAndTop{background-image: url(../images/measure_base_top.png) !important; background-position: center; background-size: 17px;}.esriMensurationHeightFromTopAndTopShadow {background-image: url(../images/measure_top_top_shadow.png) !important; background-position: center; background-size: 17px;}.esriMensurationHeightFromBaseAndTopShadow{background-image: url(../images/measure_base_top_shadow.png) !important; background-position: center; background-size: 17px;}.obliqueViewerWidgetDiv .dijitButtonNode,.obliqueViewerWidgetDiv .dijitDropDownButton.dijitButtonNode{background-color: rgba(0,0,0,0)!important; background-image: none!important;}.obliqueViewerWidgetDiv .obliqueRotationDivPassive {display: block; position: absolute; background-color: rgba(255, 255, 255, 0); bottom: 15px; right: 10px; border-radius: 10px; height:90px; width:90px; z-index: 10;}.obliqueViewerWidgetDiv .toolbar {position: absolute; display: block; top: 5px; left: 5px; height: 40px; overflow: visible; background-color: rgba(255,255,255, 0.8); filter: progid:DXImageTransform.Microsoft.gradient( startColorstr\x3d\'#ffffff\', endColorstr\x3d\'#dddddd\',GradientType\x3d0 ); -webkit-box-shadow: 3px 2px 3px 0px rgba(50, 50, 50, 0.69); -moz-box-shadow: 3px 2px 3px 0px rgba(50, 50, 50, 0.69); box-shadow: 3px 2px 3px 0px rgba(50, 50, 50, 0.69); z-index: 10;}.obliqueViewerWidgetDiv .listDivTitlePane {display: inline;}.obliqueViewerWidgetDiv .esriSimpleSliderTL {display: none;}.obliqueViewerWidgetDiv .zoomButtonContainer {display: inline; padding-left: 3px;}.obliqueViewerWidgetDiv .zoomIcon {height: 16px; width: 16px; background: url(../images/zoom.png); -webkit-background-size: 16px; -moz-background-size: 16px; background-size: 16px; background-position: center;}.obliqueViewerWidgetDiv .measureWidget {display: inline;}.obliqueViewerWidgetDiv .measureWidget .dijitButtonText{display: none;}.obliqueViewerWidgetDiv .rastersListIcon {background-image: url("../images/rasters_list.png"); width: 16px; height: 16px; -webkit-background-size: 16px; -moz-background-size: 16px; background-size: 16px; background-position: center; background-repeat: no-repeat;}.dgrid-row-odd {background: #E6EBFA;}.dgrid-scroller {margin-top: 0 !important; margin-bottom: 0 !important; height: 100% !important; overflow: auto!important;}.esriRasterListThumbnail {height:70px; width:70px;}.dgrid-header {z-index: 1;}.dgrid-header-scroll {display: none;}.dgrid-header-row th {height: 25px;}th.dgrid-cell {text-align: center;}.dgrid-content {margin-top: 27px; height: auto;}.dgrid-content .dgrid-cell {border-collapse: collapse !important;}td.dgrid-cell {padding-left: 5px;}.dgrid-row {font-size:10px;}.field-id {width: 30px;}.obliqueRasterList .dgrid-content {margin-top: 0!important;}.obliqueRasterList .dgrid-row {padding: 3px; border-bottom: 1px solid slategray;}.esriRasterListThumbnailRow.dgrid-row {height:80px;}.obliqueViewerWidgetDiv .dijitDialogUnderlay {background: #000000; opacity: 0.4;}.obliqueViewerWidgetDiv .dijitIcon{display: inline-block!important;}.obliqueViewerWidgetDiv .dijitButton .dijitButtonNode,.obliqueViewerWidgetDiv .dijitToggleButton .dijitButtonNode,.obliqueViewerWidgetDiv .dijitButtonHover .dijitButtonNode,.obliqueViewerWidgetDiv .dijitToggleButtonHover .dijitButtonNode{padding-left: 6px!important; padding-right: 6px!important; border-width: 1px!important; border-radius: 0px!important; margin-top: -7px; padding-top: 11px!important; height: 100%; border-color: rgba(0,0,0,0)!important; border-width: 1px!important; box-shadow: none!important; min-width: 0!important;}.obliqueViewerWidgetDiv .dijitDropDownButton .dijitButtonNode,.obliqueViewerWidgetDiv .dijitComboButton .dijitButtonNode,.obliqueViewerWidgetDiv .dijitDropDownButtonHover .dijitButtonNode,.obliqueViewerWidgetDiv .dijitComboButtonHover .dijitButtonNode{padding-left: 6px!important; padding-right: 6px!important; border-radius: 0px!important; z-index: 1; border-color: rgba(0,0,0,0)!important; border-width: 1px!important; margin-top: -2px; padding-top: 11px!important; height: 100%; box-shadow: none!important; min-width: 0!important;}.obliqueViewerWidgetDiv .dijitButtonHover .dijitButtonNode,.obliqueViewerWidgetDiv .dijitToggleButtonHover .dijitButtonNode,.obliqueViewerWidgetDiv .dijitDropDownButtonHover .dijitButtonNode,.obliqueViewerWidgetDiv .dijitComboButtonHover .dijitButtonNode{background-color: rgba(255,255,255,0.9)!important; background-image: none!important;}.obliqueViewerWidgetDiv .dijit.dijitReset.dijitInline.dijitDropDownButton{height: 100%;}.obliqueViewerWidgetDiv .dijitToggleButtonChecked .dijitButtonNode,.obliqueViewerWidgetDiv .esriCheckedMeasureButton{border-width: 1px; background-color: rgba(255,255,255,0.9)!important; box-shadow: none!important; border-color: rgba(0,0,0,0)!important; border-radius: 0px!important; min-width: 0;}.obliqueViewerWidgetDiv .locateIcon {background-image: url("../images/locate.png"); width: 16px; height: 16px; -webkit-background-size: 16px; -moz-background-size: 16px; background-position: center; background-repeat: no-repeat; filter: grayscale(50%);}.obliqueViewerWidgetDiv .syncIcon {background-image: url("../images/sync.png"); width: 16px; height: 16px; -webkit-background-size: 16px; -moz-background-size: 16px; background-size: 16px; background-position: center; background-repeat: no-repeat; filter: grayscale(50%);}.obliqueViewerWidgetDiv .clearIcon {background-image: url("../images/clear.png"); width: 16px; height: 16px; -webkit-background-size: 16px; -moz-background-size: 16px; background-size: 16px; background-position: center; background-repeat: no-repeat;}.obliqueViewerWidgetDiv .clearButtonContainer {display: inline;}.obliqueViewerWidgetDiv .locateButtonContainer {display: inline;}.obliqueViewerWidgetDiv .syncButtonContainer {display: inline;}.obliqueViewerWidgetDiv .esriImageServiceMeasureToggleButton{margin-right: 4px!important; padding-left: 2px!important;}.obliqueViewerWidgetDiv .dijitMenuItem td{background-color: transparent!important; border-color: transparent!important; border-width: 1px 0 1px 0!important; padding: 2px!important; color: #000000!important;}.obliqueViewerWidgetDiv.dijitMenuTable{background-color: rgba(255,255,255,0.8)!important; border: none!important; color: #000000!important;}.obliqueViewerWidgetDiv .dijitMenuItemHover,.obliqueViewerWidgetDiv .dijitMenuItemChecked,.obliqueViewerWidgetDiv .dijitMenuItemFocused,.obliqueViewerWidgetDiv .dijitMenuItemSelected{background-color: rgba(255,255,255,0.8)!important; background-image: none!important; border-color: rgba(255,255,255,0.8)!important; border-width: 1px 0 1px 0!important; padding: 2px!important; color: #000000!important;}.obliqueViewerWidgetDiv.dijitTooltipDialog{padding:0!important;}.obliqueViewerWidgetDiv .dijitTooltipConnector{display: none;}.obliqueViewerWidgetDiv .dijitTooltipContainer{padding: 0px!important; background-color: transparent!important; background-image: none!important; border: none!important; box-shadow: none!important;}#rasterListDiv{background-color: rgba(255,255,255,0.8)!important; border: none;}.obliqueRasterList .dgrid-row{border-bottom: 1px solid slategray; background: transparent!important;}.obliqueViewerWidgetDiv .dgrid-selected{background: #C7E4FF!important;}.azimuthChangeNotification{background: rgba(255,255,255,0.8); transition: opacity 1s; -webkit-transition: opacity 1s ease-out; display: none; position: absolute; bottom: 20px; left: 20px; width: 50%; color: #000000; padding: 5px;}.noImageNotification{background: rgba(255,255,255,0.8); display: none; position: absolute; bottom: 20px; left: 20px; width: 50%; color: #000000; padding: 5px;}.jimu-rtl .obliqueViewerWidgetDiv .toolbar {right: 5px; left: auto;}.jimu-rtl .obliqueViewerWidgetDiv .obliqueRotationDivPassive {left: 5px; right: auto;}',
"*now":function(p){p(['dojo/i18n!*preload*widgets/ObliqueViewer/nls/Widget*["ar","bs","ca","cs","da","de","en","el","es","et","fi","fr","he","hr","hu","id","it","ja","ko","lt","lv","nb","nl","pl","pt-br","pt-pt","ro","ru","sk","sl","sr","sv","th","tr","zh-cn","uk","vi","zh-hk","zh-tw","ROOT"]'])},"*noref":1}});
define("dojo/_base/declare jimu/BaseWidget esri/map esri/dijit/ObliqueViewer dojo/_base/lang dojo/dom dijit/form/Button esri/dijit/ImageServiceMeasure dijit/form/DropDownButton dijit/TooltipDialog dijit/form/ToggleButton esri/layers/ArcGISImageServiceLayer esri/symbols/PictureMarkerSymbol esri/symbols/SimpleFillSymbol esri/symbols/SimpleLineSymbol esri/symbols/CartographicLineSymbol esri/Color esri/graphic esri/geometry/geometryEngine esri/geometry/Point dojo/dom-style dojo/dom-class esri/IdentityManager".split(" "),function(p,
q,E,w,b,d,h,n,r,f,z,c,x,A,B,u,k,y,I,J,L,M){return p([q],{baseClass:"jimu-widget-ObliqueViewer",name:"ObliqueViewer",imageServiceMeasureWidget:null,imageLayer:"",ovMap:null,startAzimuthAngle:0,startup:function(){this.inherited(arguments);var C=this._getLayerUrl(this.config.ObliqueViewer.layerTitle);this.imageLayer=new c(C);this.setImageLayerProperties();this.ovMap=new E("ovMap");this.own(this.imageLayer.on("load",b.hitch(this,this._addObliqueViewerWidget)));this.ovMap.addLayer(this.imageLayer);this.nativePointSymbol=
new x({angle:0,xoffset:2,yoffset:4,type:"esriPMS",url:"./widgets/ObliqueViewer/images/BlueShinyPin.png",contentType:"image/png",width:24,height:24});this.noImageExtentSymbol=(new A).setOutline((new u(u.STYLE_LONGDASH)).setColor(new k("green")).setWidth(2)).setColor(new k([0,0,0,0]));this.obliqueExtentSymbol=(new A).setOutline((new B).setColor(new k("red")).setWidth(2)).setColor(new k([0,0,0,0]))},setImageLayerProperties:function(){this.renderingRule&&this.imageLayer.setRenderingRule(this.renderingRule,
!0);this.mosaicRule&&this.imageLayer.setMosaicRule(this.mosaicRule,!0);this.imageFormat&&this.imageLayer.setImageFormat(this.imageFormat,!0);this.compressionQuality&&this.imageLayer.setCompressionQuality(this.compressionQuality,!0);this.imageLayer.refresh()},onOpen:function(){if(this.oblique){var C=I.buffer(this.map.extent.getCenter(),100,"meters").getExtent();this.oblique.locate(C)}else this._setInitialExtent()},_setInitialExtent:function(){var C=this.map.extent;C=new J((C.xmax+C.xmin)/2,(C.ymax+
C.ymin)/2,C.spatialReference);C=I.buffer(C,100,"meters").getExtent();this.oblique?this.oblique.setExtent(C):this.ovMap.setExtent(C)},_addObliqueViewerWidget:function(){this._addLocateButton();this._addClearButton();this._addZoomButton();this._addSyncButton();this._addTitlePane();this.oblique=new w({map:this.ovMap,imageServiceLayer:this.imageLayer,azimuthField:this.config.ObliqueViewer.azimuthField,elevationField:this.config.ObliqueViewer.elevationField,showThumbnail:this.config.ObliqueViewer.showThumbnail,
searchRadius:this.config.ObliqueViewer.searchRadius,searchUnit:this.config.ObliqueViewer.searchUnit,rasterInfoFields:this.config.ObliqueViewer.rasterInfoFields,rotationDiv:this.obliqueRotationDiv,azimuthAngle:this.startAzimuthAngle,rasterListDiv:d.byId("rasterListDiv"),rasterListRefresh:this.dropDown.dropDown.open});var C=["esriMensurationHeightFromBaseAndTop","esriMensurationHeightFromTopAndTopShadow","esriMensurationHeightFromBaseAndTopShadow"];this.config.ObliqueViewer.showDistanceTools&&C.push("esriMensurationDistanceAndAngle",
"esriMensurationAreaAndPerimeter");this.measureWidget=new n({layer:this.imageLayer,map:this.ovMap,"class":"measureWidget",title:this.nls.measureWidgetLabel,displayOperations:C},this.measureWidget);this.measureWidget.startup();this.own(this.measureWidget.measureToolbar.on("measure-end",b.hitch(this,this.publishMeasureResult)),this.measureWidget.measureToolbar.on("unit-change",b.hitch(this,this.publishMeasureResult)),this.zoomButton.on("click",b.hitch(this,function(){this.oblique.zoomToSelectedImage()})),
this.locateButton.on("change",b.hitch(this,this._locateClick)),this.clearButton.on("click",b.hitch(this,this._clearAll)),this.oblique.on("raster-select",b.hitch(this,this._closeDropDown)),this.oblique.on("azimuth-change",b.hitch(this,this._handleZoomButton)),this.oblique.on("azimuth-change",b.hitch(this,this._showAzimuthChangeNotification)),this.oblique.on("extent-change",b.hitch(this,this._updateExtentOnNadirMap)),this.oblique.on("no-records",b.hitch(this,this._showNoImageNotification)),this.oblique.on("records-found",
b.hitch(this,this._hideNoImageNotification)),this.oblique.on("add-point",b.hitch(this,this._showPoint)));this._addClassesToMenus();this.syncButton&&this.own(this.syncButton.on("click",b.hitch(this,this._updateNadirExtent,!0)))},_showAzimuthChangeNotification:function(C){C.noDataSwitch?(L.set(this.notificationDiv,"display","block"),L.set(this.notificationDiv,"opacity",1),setTimeout(b.hitch(this,function(){this._hideAzimuthChangeNotification()}),3E3)):this._hideAzimuthChangeNotification()},_hideAzimuthChangeNotification:function(){L.set(this.notificationDiv,
"opacity","0")},_addClassesToMenus:function(){this.measureWidget&&(this.measureWidget._menu&&M.add(this.measureWidget._menu.domNode,"obliqueViewerWidgetDiv"),this.measureWidget.linearUnitMenu&&M.add(this.measureWidget.linearUnitMenu.domNode,"obliqueViewerWidgetDiv"))},publishMeasureResult:function(C){this.publishData({measureResult:C.measureResult})},_updateExtentOnNadirMap:function(C){var l=null!==C.geometry?I.simplify(C.geometry):C.geometry;this.noImageExtentGraphic&&this.noImageExtentGraphic.hide();
this.obliqueExtentGraphic?(this.obliqueExtentGraphic.setGeometry(l),this.obliqueExtentGraphic.show()):this.obliqueExtentGraphic=this.map.graphics.add(new y(l,this.obliqueExtentSymbol));this.locatePoint&&l?(this.ovMap.graphics.show(),I.within(this.locatePoint,l)||this.ovMap.graphics.clear()):this.ovMap.graphics.clear();!this.map.extent.contains(l)&&this.config.ObliqueViewer.autoSync&&C.geometry&&this._updateNadirExtent(!1,C.geometry.getExtent())},_updateNadirExtent:function(C,l){C?this.map.setExtent(this.map.extent.centerAt(this.oblique.nadirExtent.getCenter())):
l&&this.map.setExtent(this._getAdjustedExtent(this.map.extent,l))},_getAdjustedExtent:function(C,l){if(C&&l){var G=0,D=0;C=b.clone(C);l.xmax>C.xmax?G=l.xmax-C.xmax:l.xmin<C.xmin&&(G=l.xmin-C.xmin);l.ymax>C.ymax?D=l.ymax-C.ymax:l.ymin<C.ymin&&(D=l.ymin-C.ymin);return C.offset(G,D)}},_handleZoomButton:function(C){C=C.azimuth;null===C||"undefined"===typeof C?this.zoomButton.set("disabled",!0):this.zoomButton.set("disabled",!1)},_closeDropDown:function(){this.dropDown.closeDropDown()},_showNoImageNotification:function(){this.ovMap.graphics.clear();
L.set(this.infoDiv,"display","block");this.imageLayer.hide();this.obliqueExtentGraphic&&this.obliqueExtentGraphic.hide()},_hideNoImageNotification:function(){L.set(this.infoDiv,"display","none");this.imageLayer.show()},_locateClick:function(C){var l;C?(this.map.setMapCursor("crosshair"),this.map.disableMapNavigation(),this.map.setInfoWindowOnClick(!1),this.own(l=this.map.on("click",b.hitch(this,function(G){l.remove();this.map.enableMapNavigation();this.map.setInfoWindowOnClick(!0);this.locateButton.set("checked",
!1);this.map.setMapCursor("default");this._clearAll();this._addPoint(G.mapPoint)})))):(this.map.setMapCursor("default"),this.map.enableMapNavigation(),this.map.setInfoWindowOnClick(!0),l&&l.remove())},_clearAll:function(){this.map.graphics.clear();this.ovMap.graphics.clear();delete this.obliqueExtentGraphic;delete this.noImageExtentGraphic},_addPoint:function(C){var l=0<this.config.ObliqueViewer.searchRadius?I.buffer(C,this.config.ObliqueViewer.searchRadius,this.config.ObliqueViewer.searchUnit):C;
this.locatePoint=C;this.oblique.locate(l);this.map.graphics.add(new y(C,this.nativePointSymbol))},_showPoint:function(C){this.ovMap.graphics.clear();this.ovMap.graphics.add(new y(C.point,this.nativePointSymbol))},_addTitlePane:function(){var C=new f({content:'\x3cdiv id\x3d"rasterListDiv"\x3e\x3c/div\x3e'});this.dropDown=new r({label:this.nls.rasterListLabel,showLabel:!1,iconClass:"rastersListIcon",dropDown:C},this.listTitlePaneDiv);this.own(C.on("open",b.hitch(this,this._enableRasterList)),C.on("close",
b.hitch(this,this._disableRasterList)));this.dropDown.startup();M.add(C.domNode,"obliqueViewerWidgetDiv")},_disableRasterList:function(){this.oblique.set("rasterListRefresh",!1)},_enableRasterList:function(){this.oblique.set("rasterListRefresh",!0)},_addZoomButton:function(){this.zoomButton=new h({showLabel:!1,iconClass:"zoomIcon",label:this.nls.zoomButtonLabel,disabled:!1,"class":"zoomButtonContainer"},this.zoomButtonContainer)},_addLocateButton:function(){this.locateButton=new z({showLabel:!1,iconClass:"locateIcon",
label:this.nls.locateButtonLabel,"class":"locateButtonContainer"},this.locateButtonContainer)},_addClearButton:function(){this.clearButton=new h({showLabel:!1,iconClass:"clearIcon",label:this.nls.clearButtonLabel,"class":"clearButtonContainer"},this.clearButtonContainer)},_addSyncButton:function(){this.config.ObliqueViewer.autoSync?L.set(this.syncButtonContainer,"display","none"):this.syncButton=new h({showLabel:!1,iconClass:"syncIcon",label:this.nls.syncButtonLabel,"class":"syncButtonContainer"},
this.syncButtonContainer)},onClose:function(){this._clearAll()},_getLayerUrl:function(C){var l=this.map.itemInfo.itemData.operationalLayers,G;for(G in l)if(l.hasOwnProperty(G)&&l[G].title===C){var D=l[G];var a=D.layerObject;D=D.url;this.renderingRule=a.renderingRule;this.mosaicRule=a.mosaicRule;this.imageFormat=a.format;this.compressionQuality=a.compressionQuality}return D}})});