// All material copyright ESRI, All Rights Reserved, unless otherwise specified.
// See http://@sbaseurl@/jsapi/jsapi/esri/copyright.txt and http://www.arcgis.com/apps/webappbuilder/copyright.txt for details.

//>>built
define("dojo/_base/declare dojo/_base/connect dojo/_base/lang dojo/topic esri/graphic esri/toolbars/draw esri/geometry/Point esri/geometry/Polyline esri/geometry/Polygon esri/geometry/Circle esri/geometry/geometryEngine esri/geometry/webMercatorUtils esri/geometry/geodesicUtils esri/SpatialReference esri/units jimu/utils ./Feedback dojo/has dojo/touch dojo/on".split(" "),function(r,p,f,k,e,t,w,m,u,x,g,q,y,z,A,v,l,B,C,D){l=r([l],{orientationAngle:0,majorAxisLength:[],minorAxisLength:[],signal:null,
constructor:function(a){r.safeMixin(this,a);this.initGeometryService();this.syncEvents();this._majGraphic=new e;this._majGraphicB=new e;this._minGraphic=new e;this._minGraphicB=new e},syncEvents:function(){k.subscribe("create-manual-ellipse",f.hitch(this,this.onCreateManualEllipse));k.subscribe("manual-ellipse-center-point-input",f.hitch(this,this.onCenterPointManualInputHandler));k.subscribe("clear-points",f.hitch(this,this.clearPoints))},clearPoints:function(){this._points=[];this.map.graphics.clear()},
onCreateManualEllipse:function(a,b,d,c){this._points=[];this._points.push(c);this.majorAxisLength=a=this.coordTool.convertToMeters(a,this.lengthUnit);a=this.getEndPoint(c,0,a);this._points.push(a);a=new m({paths:[[[c.x,c.y],[a.x,a.y]]],spatialReference:c.spatialReference});this._majGraphic=new e(a,this.lineSymbol);this._majGraphicB=new e(a,this.lineSymbol);this._majGraphicB.geometry=g.rotate(a,180,c);this.minorAxisLength=a=this.coordTool.convertToMeters(b,this.lengthUnit);a=this.getEndPoint(c,90,
a);this._points.push(a);b=new m({paths:[[[c.x,c.y],[a.x,a.y]]],spatialReference:this.map.spatialReference});this._minGraphic=new e(b,this.lineSymbol);this._minGraphicB=new e(b,this.lineSymbol);this._minGraphicB.geometry=g.rotate(b,180,c);this.orientationAngle=Number(d);this._onDoubleClickHandler()},onCenterPointManualInputHandler:function(a){this._points=[];this._points.push(a.offset(0,0));this.set("startPoint",this._points[0]);this.map.centerAt(a)},getEndPoint:function(a,b,d){b=b?b:0;d=new x(a,{radius:d,
geodesic:!0,numberOfPoints:60});return g.rotate(d,b,a).getPoint(0,0)},_onClickHandler:function(a){if(this.map.snappingManager)var b=this.map.snappingManager._snappingPoint;var d=b||a.mapPoint;this._points.push(d.offset(0,0));this._processAfterMapClick(d).then(f.hitch(this,function(c){switch(this._geometryType){case t.POINT:this.set("startPoint",d.offset(0,0));this.set("startPointDD",c);this._drawEnd(d.offset(0,0));this._setTooltipMessage(0);break;case t.POLYLINE:switch(this._points.length){case 1:this.set("startPoint",
this._points[0]);this.set("startPointDD",c);c=new m({paths:[[[d.x,d.y],[d.x,d.y]]],spatialReference:this.map.spatialReference});var h=new m({paths:[[[d.x,d.y],[d.x,d.y]]],spatialReference:this.map.spatialReference});this._majGraphic=new e(c,this.lineSymbol);this._majGraphicB=new e(c,this.lineSymbol);this._minGraphic=new e(h,this.lineSymbol);this._minGraphicB=new e(h,this.lineSymbol);this.map.graphics.add(this._majGraphic);this.map.graphics.add(this._majGraphicB);this.map.graphics.add(this._minGraphic);
this.map.graphics.add(this._minGraphicB);B("esri-touch")&&this.parentWidget.own(D(this.map.root,C.move,f.hitch(this,this._onMouseMoveHandler)));this._onMouseMoveHandlerConnect=p.connect(this.map,"onMouseMove",this._onMouseMoveHandler);this._onDoubleClickHandler_connect=p.connect(this.map,"onDblClick",f.hitch(this,this._onDoubleClickHandler));if(c=this._tooltip)c.innerHTML=v.sanitizeHTML(this.nls.majorAxisTooltipMessage);break;case 2:this._setMajorAxisInfo();this._tooltip&&(this._tooltip.innerHTML=
v.sanitizeHTML(this.nls.minorAxisTooltipMessage));break;case 3:this._setMinorAxisInfo(),this._onDoubleClickHandler()}}}),function(c){console.log(c)})},_setMajorAxisInfo:function(){this.getProjectedGeometry(this._majGraphic.geometry,new z(4326)).then(f.hitch(this,f.hitch(this,function(b){this.majorAxisLength=g.geodesicLength(b,9001);b=this.coordTool.convertMetersToUnits(this.majorAxisLength,this.lengthUnit);k.publish("DD_ELLIPSE_MAJOR_LENGTH_CHANGE",b)})));var a=this.getAngle(q.webMercatorToGeographic(this._points[0]),
q.webMercatorToGeographic(this._majGraphic.geometry.getPoint(0,1)));"mils"===this.angleUnit&&(a*=17.777777778);k.publish("DD_ELLIPSE_ANGLE_CHANGE",a)},_setMinorAxisInfo:function(){var a=f.clone(this._minGraphic.geometry),b=q.webMercatorToGeographic(this._minGraphic.geometry);this.minorAxisLength=y.geodesicLengths([b],A.METERS);b=this.coordTool.convertMetersToUnits(this.minorAxisLength[0],this.lengthUnit);this.minorAxisLength[0]>this.majorAxisLength||0===this.minorAxisLength[0]?this._minGraphic.setGeometry(a):
k.publish("DD_ELLIPSE_MINOR_LENGTH_CHANGE",b)},_onMouseMoveHandler:function(a){if(this.map.snappingManager)var b=this.map.snappingManager._snappingPoint;a=b||a.mapPoint;1===this._points.length?(this._majGraphic.geometry.setPoint(0,1,a),this._majGraphicB.geometry=g.rotate(this._majGraphic.geometry,180,this._points[0]),this._majGraphic.setGeometry(this._majGraphic.geometry).setSymbol(this.lineSymbol),this._majGraphicB.setGeometry(this._majGraphicB.geometry).setSymbol(this.lineSymbol),this.canProjectLocally&&
this._setMajorAxisInfo()):null!==this._minGraphic&&(a=g.nearestCoordinate(this._majGraphic.geometry,a),a=new w(a.coordinate.x,a.coordinate.y,102100),this._minGraphic.geometry.setPoint(0,1,a),this._minGraphicB.geometry.setPoint(0,1,a),this._minGraphic.geometry=g.rotate(this._minGraphic.geometry,-90,this._points[0]),this._minGraphicB.geometry=g.rotate(this._minGraphicB.geometry,90,this._points[0]),this._minGraphic.setGeometry(this._minGraphic.geometry).setSymbol(this.lineSymbol),this._minGraphicB.setGeometry(this._minGraphicB.geometry).setSymbol(this.lineSymbol),
this.canProjectLocally&&this._setMinorAxisInfo())},getLineLength:function(a,b,d,c){return Math.sqrt((a-=d)*a+(b-=c)*b)},getAngle:function(a,b){return(180*Math.atan2(b.x-a.x,b.y-a.y)/Math.PI+360)%360},convertAngle:function(a){return 0<=a&&90>a||180<=a&&270>a?90-a:90<=a&&180>a||270<=a&&360>a?180-a+270:a},_onDoubleClickHandler:function(){if(3<=this._points.length){var a=new u(this._points[0].spatialReference),b=[];b.push(this._majGraphic.geometry.getPoint(0,0));b.push(this._majGraphic.geometry.getPoint(0,
1));b.push(this._minGraphic.geometry.getPoint(0,1));this.geomService.project(b,this.map.spatialReference,f.hitch(this,function(d){var c=this.map.toScreen(d[0]),h=this.map.toScreen(d[1]),n=this.map.toScreen(d[2]);h=this.getLineLength(c.x,c.y,h.x,h.y);n=this.getLineLength(c.x,c.y,n.x,n.y);c=u.createEllipse({center:c,longAxis:h,shortAxis:n,numberOfPoints:60,map:this.map});this.orientationAngle=this.angle;"mils"===this.angleUnit&&(this.orientationAngle/=17.777777778);a.geometry=g.rotate(c,this.convertAngle(this.orientationAngle),
d[0]);a=f.mixin(a,{majorAxisLength:this.coordTool.convertMetersToUnits(this.majorAxisLength,this.lengthUnit),minorAxisLength:this.coordTool.convertMetersToUnits(this.minorAxisLength,this.lengthUnit),angle:this.angle,drawType:"ellipse",center:this._points[0]});this.disconnectOnMouseMoveHandler();this._setTooltipMessage(0);this._drawEnd(a);this.cleanup();this.orientationAngle=0}))}},cleanup:function(){this.map.graphics.clear();this._minGraphic=this._majGraphic=null;this.majorAxisLength=[];this.minorAxisLength=
[]},disconnectOnMouseMoveHandler:function(){this._onMouseMoveHandlerConnect&&p.disconnect(this._onMouseMoveHandlerConnect)}});l.DD_ELLIPSE_MAJOR_LENGTH_CHANGE="DD_ELLIPSE_MAJOR_LENGTH_CHANGE";l.DD_ELLIPSE_MINOR_LENGTH_CHANGE="DD_ELLIPSE_MINOR_LENGTH_CHANGE";l.DD_ELLIPSE_ANGLE_CHANGE="DD_ELLIPSE_ANGLE_CHANGE";return l});