// All material copyright ESRI, All Rights Reserved, unless otherwise specified.
// See http://@sbaseurl@/jsapi/jsapi/esri/copyright.txt and http://www.arcgis.com/apps/webappbuilder/copyright.txt for details.

//>>built
require({cache:{"esri/dijit/Basemap":function(){define("dojo/_base/declare dojo/_base/array dojo/_base/lang dojo/has ../kernel ../request ./BasemapLayer".split(" "),function(G,e,t,n,p,h,c){G=G(null,{declaredClass:"esri.dijit.Basemap",id:null,title:"",thumbnailUrl:null,layers:null,itemId:null,basemapGallery:null,constructor:function(a,b){a=a||{};a.layers||a.itemId||console.error("esri.dijit.Basemap: unable to find the 'layers' property in parameters");this.id=a.id;this.itemId=a.itemId;this.layers=
a.layers;this.title=a.title||"";this.thumbnailUrl=a.thumbnailUrl;this.basemapGallery=b},getLayers:function(a){if(this.layers)return this.layers;if(this.itemId)return a=h({url:(a||p.dijit._arcgisUrl)+"/content/items/"+this.itemId+"/data",content:{f:"json"},callbackParamName:"callback",error:t.hitch(this,function(b,l){if(this.basemapGallery)this.basemapGallery.onError("esri.dijit.Basemap: could not access basemap item.");else console.error("esri.dijit.Basemap: could not access basemap item.")})}),a.addCallback(t.hitch(this,
function(b,l){if(b.baseMap)return this.layers=[],e.forEach(b.baseMap.baseMapLayers,function(g){this.layers.push(new c(g))},this),this.layers;if(this.basemapGallery)this.basemapGallery.onError("esri.dijit.Basemap: could not access basemap item.");else console.error("esri.dijit.Basemap: could not access basemap item.");return[]})),a}});n("extend-esri")&&t.setObject("dijit.Basemap",G,p);return G})},"esri/dijit/BasemapLayer":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/has","../kernel"],
function(G,e,t,n){G=G(null,{declaredClass:"esri.dijit.BasemapLayer",constructor:function(p){p=p||{};p.url||p.type||console.error("esri.dijit.BasemapLayer: unable to find the 'url' or 'type' property in parameters");this.url=p.url;this.type=p.type;this.isReference=!0===p.isReference?!0:!1;this.opacity=p.opacity;this.visibleLayers=p.visibleLayers;this.displayLevels=p.displayLevels;this.exclusionAreas=p.exclusionAreas;this.bandIds=p.bandIds;this.renderingRule=p.renderingRule;this.templateUrl=p.templateUrl;
this.copyright=p.copyright;this.subDomains=p.subDomains;this.fullExtent=p.fullExtent;this.initialExtent=p.initialExtent;this.tileInfo=p.tileInfo;this.tileServers=p.tileServers;this.styleUrl=p.styleUrl}});t("extend-esri")&&e.setObject("dijit.BasemapLayer",G,n);return G})},"esri/dijit/BasemapGallery":function(){define("require dojo/_base/declare dojo/_base/array dojo/_base/connect dojo/_base/lang dojo/_base/kernel dojo/_base/sniff dojo/has dojo/query dojo/Deferred dojo/DeferredList dojo/dom dojo/dom-construct dojo/dom-class dijit/_Widget dijit/_Templated ../kernel ../lang ../urlUtils ../request ../geometry/Extent ../SpatialReference ../virtualearth/VETiledLayer ../layers/OpenStreetMapLayer ../layers/ArcGISTiledMapServiceLayer ../layers/ArcGISDynamicMapServiceLayer ../layers/WebTiledLayer ../layers/VectorTileLayer ../layers/TileInfo ../layers/ArcGISImageServiceLayer ../layers/ImageServiceParameters ../layers/ImageParameters ../layers/RasterFunction ../layers/RasterXLayer ./Basemap ./_EventedWidget dojo/text!./templates/BasemapGallery.html".split(" "),
function(G,e,t,n,p,h,c,a,b,l,g,f,d,k,m,v,q,r,w,u,y,x,z,A,E,F,B,D,I,M,N,Q,V,X,W,Z,aa){e=e([Z,m,v],{declaredClass:"esri.dijit.BasemapGallery",widgetsInTemplate:!0,templateString:aa,loaded:!1,basemaps:[],bingMapsKey:null,flowContainer:null,_hasUI:!1,_supportsVTL:null,_selectedBasemap:null,_selectBasemapInProgress:!1,_eventMap:{load:!0,"selection-change":!0,add:["basemap"],remove:["basemap"],error:["message"]},constructor:function(J,O){J=J||{};J.map||console.error("esri.dijit.BasemapGallery: Unable to find the 'map' property in parameters");
this.map=J.map;this._hasUI=O?!0:!1;this.bingMapsKey=J.bingMapsKey&&0<J.bingMapsKey.length?J.bingMapsKey:null;this.showArcGISBasemaps=!1!==J.showArcGISBasemaps;this.basemaps=J.basemaps||[];this.basemapIds=J.basemapIds;this.referenceIds=J.referenceIds;this.basemapsGroup=J.basemapsGroup;this.arcgisUrl=q.dijit._arcgisUrl;J.portalUrl&&(this.arcgisUrl=J.portalUrl+"/sharing/rest");0>this.arcgisUrl.indexOf("://")?this.arcgisUrl=w.getProtocolForWebResource()+"//"+this.arcgisUrl:"https:"===window.location.protocol&&
(this.arcgisUrl=this.arcgisUrl.replace("http:","https:"));this.init()},init:function(){this.inherited(arguments);this._checkVTLSupport().then(p.hitch(this,function(J){this._supportsVTL=J}));t.forEach(this.basemaps,function(J){J.id&&0!==J.id.length||(J.id=this._getUniqueId());t.forEach(J.layers,function(O){O.opacity=0<=O.opacity?O.opacity:1;O.visibility=!0},this)},this);this.basemapIds&&0<this.basemapIds.length&&t.forEach(this.basemapIds,function(J){this.map.getLayer(J)._basemapGalleryLayerType="basemap"},
this);this.referenceIds&&0<this.referenceIds.length&&t.forEach(this.referenceIds,function(J){J=this.map.getLayer(J);J._basemapGalleryLayerType="reference";J.attr("data-reference",!0)},this);this.basemapsGroup&&(this.basemapsGroup.owner&&this.basemapsGroup.title||this.basemapsGroup.id)?this._findCustomBasemapsGroup(p.hitch(this,"_handleArcGISBasemapsResponse")):this.showArcGISBasemaps?this._findArcGISBasemapsGroup(p.hitch(this,"_handleArcGISBasemapsResponse")):this._finishStartup()},startup:function(){this.loaded?
this._refreshUI():n.connect(this,"onLoad",p.hitch(this,function(){this._refreshUI()}))},select:function(J){this._select(J)},getSelected:function(){return this._selectedBasemap},get:function(J){var O;for(O=0;O<this.basemaps.length;O++)if(this.basemaps[O].id===J)return this.basemaps[O];return null},add:function(J){return J&&!J.id?(J.id=this._getUniqueId(),this.basemaps.push(J),this._refreshUI(),this.onAdd(J),!0):J&&this._isUniqueId(J.id)?(this.basemaps.push(J),this._refreshUI(),this.onAdd(J),!0):!1},
remove:function(J){var O;for(O=0;O<this.basemaps.length;O++){var S=this.basemaps[O];if(S.id===J)return this._selectedBasemap&&this._selectedBasemap.id===S.id&&(this._selectedBasemap=null),this.basemaps.splice(O,1),this._refreshUI(),this.onRemove(S),S}return null},onLoad:function(){},onSelectionChange:function(){},onAdd:function(J){},onRemove:function(J){},onError:function(J){},_defaultBasemapGalleryGroupQuery:'title:"ArcGIS Online Basemaps" AND owner:esri',_basemapGalleryGroupQuery:null,_finishStartup:function(){this.loaded=
!0;this.onLoad();0===this.map.layerIds.length&&0<this.basemaps.length&&!this._selectBasemapInProgress&&this._select(this.basemaps[0].id)},_findCustomBasemapsGroup:function(J){this.basemapsGroup&&this.basemapsGroup.id?this._findArcGISBasemaps(this.basemapsGroup.id,J):(this._basemapGalleryGroupQuery='title:"'+this.basemapsGroup.title+'" AND owner:'+this.basemapsGroup.owner,this._findArcGISBasemapsGroup(J))},_findArcGISBasemapsGroup:function(J){if(this._basemapGalleryGroupQuery)this._findArcGISBasemapsGroupContent(J);
else{var O=this.arcgisUrl+"/portals/self",S={f:"json"};S.culture=h.locale;u({url:O,content:S,callbackParamName:"callback",load:p.hitch(this,function(T,C){T&&T.useVectorBasemaps&&T.vectorBasemapGalleryGroupQuery?this._checkVTLSupport().then(p.hitch(this,function(H){this._basemapGalleryGroupQuery=H?T.vectorBasemapGalleryGroupQuery:T&&T.basemapGalleryGroupQuery?T.basemapGalleryGroupQuery:this._defaultBasemapGalleryGroupQuery;this._findArcGISBasemapsGroupContent(J)})):(this._basemapGalleryGroupQuery=
T&&T.basemapGalleryGroupQuery?T.basemapGalleryGroupQuery:this._defaultBasemapGalleryGroupQuery,this._findArcGISBasemapsGroupContent(J))}),error:p.hitch(this,function(T,C){this._basemapGalleryGroupQuery=this._defaultBasemapGalleryGroupQuery})})}},_findArcGISBasemapsGroupContent:function(J){var O=p.hitch(this,"_findArcGISBasemaps"),S=this.arcgisUrl+"/community/groups",T={};T.q=this._basemapGalleryGroupQuery;T.f="json";u({url:S,content:T,callbackParamName:"callback",load:p.hitch(this,function(C,H){if(0<
C.results.length)O(C.results[0].id,J,C.results[0].sortField,C.results[0].sortOrder);else this.onError("esri.dijit.BasemapGallery: could not find group for basemaps.")}),error:p.hitch(this,function(C){this.onError("esri.dijit.BasemapGallery: could not find group for basemaps.")})})},_findArcGISBasemaps:function(J,O,S,T){var C=p.hitch(this,function(H,K,L,P){var R=this.arcgisUrl+"/search",U={};U.q="group:"+H+' AND type:"web map" NOT type:"web mapping application"';U.sortField=L;U.sortOrder="asc"===P?
"desc":"asc";U.num=100;U.f="json";u({url:R,content:U,callbackParamName:"callback",load:p.hitch(this,function(Y,ja){if(0<Y.results.length)K(Y.results);else this.onError("esri.dijit.BasemapGallery: could not find group for basemaps.")}),error:p.hitch(this,function(Y,ja){this.onError("esri.dijit.BasemapGallery: could not find group for basemaps.")})})});S&&T?C(J,O,S,T):u({url:this.arcgisUrl+"/community/groups/"+J,content:{f:"json"},callbackParamName:"callback",load:p.hitch(this,function(H,K){H.sortField?
C(J,O,H.sortField,H.sortOrder):C(J,O,"name","desc")}),error:p.hitch(this,function(H,K){C(J,O,"name","desc")})})},_handleArcGISBasemapsResponse:function(J){0<J.length&&(t.forEach(J,function(O,S){if(this.bingMapsKey||!this.bingMapsKey&&O.title&&-1===O.title.indexOf("Bing Maps")){S={};S.id=this._getUniqueId();S.title=O.title;S.thumbnailUrl="";if(O.thumbnail&&O.thumbnail.length&&(S.thumbnailUrl=this.arcgisUrl+"/content/items/"+O.id+"/info/"+O.thumbnail,q.id)){var T=q.id.findCredential(w.urlToObject(this.arcgisUrl).path);
T&&(S.thumbnailUrl+="?token\x3d"+T.token)}S.itemId=O.id;O=new W(S,this);this.basemaps.splice(0,0,O)}},this),this._finishStartup())},_refreshUI:function(){this._hasUI&&(d.empty(this.flowContainer),t.forEach(this.basemaps,function(J,O){J.id||(J.id="basemap_"+O);this.flowContainer.appendChild(this._buildNodeLayout(J))},this),d.create("br",{style:{clear:"both"}},this.flowContainer),this._markSelected(this._selectedBasemap))},_buildNodeLayout:function(J){var O=d.create("div",{id:"galleryNode_"+J.id,"class":"esriBasemapGalleryNode"}),
S=d.create("a",{href:"javascript:void(0);"},O);n.connect(S,"onclick",p.hitch(this,"_onNodeClick",J));var T=J.title||"";J.thumbnailUrl?d.create("img",{"class":"esriBasemapGalleryThumbnail",src:J.thumbnailUrl,title:T,alt:T},S):d.create("img",{"class":"esriBasemapGalleryThumbnail",src:G.toUrl("./images/transparent.gif"),title:T,alt:T},S);J=d.create("div",{"class":"esriBasemapGalleryLabelContainer"},O);d.create("span",{innerHTML:T,alt:T,title:T},J);return O},_onNodeClick:function(J,O){O.preventDefault();
this._markSelected(J);this.select(J.id)},_markSelected:function(J){J&&(t.forEach(h.query(".esriBasemapGallerySelectedNode",this.domNode),function(O){k.remove(O,"esriBasemapGallerySelectedNode")}),(J=f.byId("galleryNode_"+J.id))&&k.add(J,"esriBasemapGallerySelectedNode"))},_select:function(J){this._selectBasemapInProgress=!0;var O=this.get(J);O?(O.layers?this._getServiceInfos(O):(J=O.getLayers(this.arcgisUrl),p.isArray(J)?this._getServiceInfos(O):J.addCallback(p.hitch(this,function(S){this._getServiceInfos(O)}))),
this._markSelected(O)):this._selectBasemapInProgress=!1},_getServiceInfos:function(J){"https:"===location.protocol&&t.forEach(J.layers,function(S){if(this._isAgolService(S.url)||this._isHostedService(S.url))S.url=S.url.replace("http:","https:")},this);this._selectedBasemap=J;var O=[];t.forEach(J.layers,function(S){S.url&&0<S.url.length&&!S.isReference&&!S.type&&(S.deferredsPos=O.length,O.push(this._getServiceInfo(S.url)))},this);0<O.length?(new g(O)).addCallback(p.hitch(this,function(S){var T=null;
t.forEach(J.layers,function(C){if(0===C.deferredsPos||C.deferredsPos){C.serviceInfoResponse=S[C.deferredsPos][1];var H=C.serviceInfoResponse.fullExtent;H||(H=C.serviceInfoResponse.extent);T=T?T.union(new y(H)):new y(H)}},this);this.map.extent&&5>this._getIntersectionPercent(T,this.map.extent)&&this.map.setExtent(T,!0);this._switchBasemapLayers(J);this._updateReferenceLayer(J)})):(this._switchBasemapLayers(J),this._updateReferenceLayer(J))},_checkVTLSupport:function(){var J=new l;c("ie")?J.resolve(!1):
J.resolve(D.supported());return J},_switchBasemapLayers:function(J){var O=J.layers,S=!1,T,C,H;t.forEach(O,function(L){"VectorTileLayer"===L.type&&(S=!0)});if(S&&!0!==this._supportsVTL)this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because layer type is not supported by your current browser version.");else if(0<this.map.layerIds.length&&0===this.map.getNumLevels()&&("OpenStreetMap"===O[0].type||O[0].type&&-1<O[0].type.indexOf("BingMaps")||"WebTiledLayer"===O[0].type||"VectorTileLayer"===
O[0].type))this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap is a tiled service and cannot be loaded as a dynamic layer.");else{t.forEach(O,function(L){if(!L.isReference&&L.type&&-1<L.type.indexOf("BingMaps")&&!this.bingMapsKey)this.onError("esri.dijit.BasemapGallery: Invalid Bing Maps key.")},this);var K=0;t.forEach(O,function(L,P){if(!L.isReference){if("OpenStreetMap"===L.type){if(0<this.map.layerIds.length&&0===this.map.getNumLevels()){this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap is a tiled service and cannot be loaded as a dynamic layer.");
return}var R=new A({id:"layer_osm",opacity:L.opacity})}else if(L.type&&-1<L.type.indexOf("BingMaps")){if(0<this.map.layerIds.length&&0===this.map.getNumLevels()){this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap is a tiled service and cannot be loaded as a dynamic layer.");return}R=z.MAP_STYLE_AERIAL_WITH_LABELS;"BingMapsAerial"===L.type?R=z.MAP_STYLE_AERIAL:"BingMapsRoad"===L.type&&(R=z.MAP_STYLE_ROAD);R=new z({id:"layer_bing",bingMapsKey:this.bingMapsKey,mapStyle:R,
opacity:L.opacity})}else if("WebTiledLayer"===L.type){if(0<this.map.layerIds.length&&0===this.map.getNumLevels()){this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap is a tiled service and cannot be loaded as a dynamic layer.");return}R=L.initialExtent||L.fullExtent;R=new B(L.templateUrl||L.url,{visible:L.visibility,opacity:L.opacity,copyright:L.copyright,fullExtent:L.fullExtent&&new y(L.fullExtent),initialExtent:R&&new y(R),subDomains:L.subDomains,tileInfo:L.tileInfo?
new I(L.tileInfo):null,tileServers:L.tileServers})}else if("VectorTileLayer"===L.type){R=new D(L.styleUrl,{visible:L.visibility,opacity:L.opacity});0===P&&1<O.length&&this._removeBasemapLayers();var U=this;n.connect(R,"onLoad",p.hitch(this,function(Y,ja,oa){var qa=U._sameSpatialReference(oa.spatialReference,U.map.spatialReference);if(U.map.spatialReference&&!qa)U.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap has a different spatial reference.");else{if(0<U.map.getNumLevels()){if(qa=
U._sameTilingScheme(oa.tileInfo,U.map.__tileInfo),!qa){U.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap has a different tiling scheme.");return}}else if(U.map.loaded){U.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap is a vector tile layer and cannot be loaded as a dynamic layer.");return}0===ja&&1===O.length&&U._removeBasemapLayers();oa._basemapGalleryLayerType="basemap";U.map.addLayer(oa,Y)}},K,P))}else if(L.serviceInfoResponse&&
L.serviceInfoResponse.mapName){T=new x(L.serviceInfoResponse.spatialReference);C=this._sameSpatialReference(T,this.map.spatialReference);if(this.map.spatialReference&&!C){this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap has a different spatial reference.");return}if(!0===L.serviceInfoResponse.singleFusedMapCache&&0<this.map.getNumLevels()){if(H=this._sameTilingScheme(L.serviceInfoResponse.tileInfo,this.map.__tileInfo),!H){this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap has a different tiling scheme.");
return}}else if(!0===L.serviceInfoResponse.singleFusedMapCache&&-1<L.serviceInfoResponse.capabilities.toLowerCase().indexOf("tilesonly")&&this.map.loaded&&0===this.map.getNumLevels()){this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap is a tiled service and cannot be loaded as a dynamic layer.");return}R=(0===this.map.layerIds.length||0<this.map.getNumLevels())&&!0===L.serviceInfoResponse.singleFusedMapCache?this._loadAsCached(L):this._loadAsDynamic(L)}else if(L.serviceInfoResponse&&
L.serviceInfoResponse.pixelSizeX){T=new x(L.serviceInfoResponse.spatialReference);C=this._sameSpatialReference(T,this.map.spatialReference);if(this.map.spatialReference&&!C){this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap has a different spatial reference.");return}if(!0===L.serviceInfoResponse.singleFusedMapCache&&0<this.map.getNumLevels()&&(H=this._sameTilingScheme(L.serviceInfoResponse.tileInfo,this.map.__tileInfo),!H)){this.onError("esri.dijit.BasemapGallery: Unable to switch basemap because new basemap has a different tiling scheme.");
return}L.serviceInfoResponse.singleFusedMapCache&&"ArcGISImageServiceLayer"!==L.type?R="Raster"===L.serviceInfoResponse.cacheType?new X(L.url,{serviceInfo:L.serviceInfoResponse,opacity:L.opacity,visible:L.visibility,bandIds:L.bandIds&&0<L.bandIds.length?L.bandIds:null}):new E(L.url,{resourceInfo:L.serviceInfoResponse,opacity:L.opacity,visible:L.visibility}):L.serviceInfoResponse.pixelSizeX?(R=new N,R.bandIds=L.bandIds,L.renderingRule?R.renderingRule=new V(L.renderingRule):!L.bandIds&&L.serviceInfoResponse.bandCount&&
3<parseInt(L.serviceInfoResponse.bandCount,10)&&(R.bandIds=[0,1,2]),R=new M(L.url,{resourceInfo:L.serviceInfoResponse,opacity:L.opacity,visible:L.visibility,imageServiceParameters:R})):(R=new Q,R.format="png24",L.serviceInfoResponse.supportedImageFormatTypes&&-1<L.serviceInfoResponse.supportedImageFormatTypes.indexOf("PNG32")&&(R.format="png32"),R=new F(L.url,{resourceInfo:L.serviceInfoResponse,opacity:L.opacity,visible:L.visibility,imageParameters:R}))}"VectorTileLayer"===L.type?K++:R&&(0===P&&this._removeBasemapLayers(),
R._basemapGalleryLayerType="basemap",this.map.addLayer(R,K),K++)}},this);this._selectBasemapInProgress=!1;this.onSelectionChange()}},_removeBasemapLayers:function(){var J=this.map.layerIds,O=[];t.forEach(J,function(S){S=this.map.getLayer(S);"basemap"===S._basemapGalleryLayerType&&O.push(S)},this);0===O.length&&0<J.length&&O.push(this.map.getLayer(J[0]));0<O.length&&t.forEach(O,function(S){this.map.removeLayer(S)},this)},_updateReferenceLayer:function(J){var O;this._removeReferenceLayer();for(O=0;O<
J.layers.length;O++)!0===J.layers[O].isReference&&this._addReferenceLayer(J.layers[O])},_removeReferenceLayer:function(){var J;for(J=this.map.layerIds.length-1;0<=J;J--){var O=this.map.getLayer(this.map.layerIds[J]);"reference"===O._basemapGalleryLayerType&&this.map.removeLayer(O)}},_addReferenceLayer:function(J){"VectorTileLayer"===J.type?this._handleReferenceServiceInfoResponse(J):this._getServiceInfo(J.url,p.hitch(this,"_handleReferenceServiceInfoResponse",J))},_handleReferenceServiceInfoResponse:function(J,
O,S){J.serviceInfoResponse=O;if("VectorTileLayer"===J.type)var T=new D(J.styleUrl,{visible:J.visibility,opacity:J.opacity});else O&&O.mapName?T=!0===O.singleFusedMapCache?this._loadAsCached(J):this._loadAsDynamic(J):O&&O.pixelSizeX&&(J.serviceInfoResponse.singleFusedMapCache?T=new E(J.url,{resourceInfo:J.serviceInfoResponse,opacity:J.opacity,visible:J.visibility}):J.serviceInfoResponse.pixelSizeX?(S=new N,S.bandIds=J.bandIds,J.renderingRule?S.renderingRule=new V(J.renderingRule):!J.bandIds&&O.bandCount&&
3<parseInt(O.bandCount,10)&&(S.bandIds=[0,1,2]),T=new M(J.url,{resourceInfo:O,opacity:J.opacity,visible:J.visibility,imageServiceParameters:S})):(O=new Q,O.format="png24",J.serviceInfoResponse.supportedImageFormatTypes&&-1<J.serviceInfoResponse.supportedImageFormatTypes.indexOf("PNG32")&&(O.format="png32"),O.transparent=!0,T=new F(J.url,{resourceInfo:J.serviceInfoResponse,opacity:J.opacity,visible:J.visibility,imageParameters:O})));T&&(T._basemapGalleryLayerType="reference",T.attr("data-reference",
!0),this.map.addLayer(T))},_getServiceInfo:function(J,O){return u({url:J,content:{f:"json"},callbackParamName:"callback",load:function(S,T){O&&O(S,T)},error:p.hitch(this,function(S,T){this.onError("esri.dijit.BasemapGallery: service not accessible.")})})},_loadAsCached:function(J){var O=[];J.displayLevels||(O=t.map(J.serviceInfoResponse.tileInfo.lods,function(T){return T.level}));var S=null;J.exclusionAreas&&J.exclusionAreas.length&&(S=[],t.forEach(J.exclusionAreas,function(T){S.push({minZoom:T.minZoom,
maxZoom:T.maxZoom,minScale:T.minScale,maxScale:T.maxScale,geometry:new y(T.geometry)})}));return new E(J.url,{resourceInfo:J.serviceInfoResponse,opacity:J.opacity,visible:J.visibility,exclusionAreas:S,displayLevels:J.displayLevels||O})},_loadAsDynamic:function(J){var O=new F(J.url,{resourceInfo:J.serviceInfoResponse,opacity:J.opacity,visible:J.visibility});J.visibleLayers&&O.setVisibleLayers(J.visibleLayers);return O},_getIntersectionPercent:function(J,O){return(J=O.intersects(J))?(J=J.getWidth()*
J.getHeight(),O=O.getWidth()*O.getHeight(),J/O*100):0},_getIds:function(){var J=[];t.forEach(this.basemaps,function(O){J.push(O.id)},this);return J},_getUniqueId:function(){for(var J=","+this._getIds().toString()+",",O=0;;)if(-1<J.indexOf(",basemap_"+O+","))O++;else return"basemap_"+O},_isUniqueId:function(J){return-1===(","+this._getIds().toString()+",").indexOf(","+J+",")?!0:!1},_isAgolService:function(J){return J?-1!==J.indexOf("/services.arcgisonline.com/")||-1!==J.indexOf("/server.arcgisonline.com/"):
!1},_isHostedService:function(J){return J?-1!==J.indexOf(".arcgis.com/"):!1},_sameSpatialReference:function(J,O){return J&&O&&J.wkt==O.wkt&&(J.wkid===O.wkid||r.isDefined(J.latestWkid)&&J.latestWkid===O.wkid||r.isDefined(O.latestWkid)&&J.wkid===O.latestWkid||r.isDefined(J.latestWkid)&&J.latestWkid===O.latestWkid)||J&&O&&J.isWebMercator()&&O.isWebMercator()?!0:!1},_sameTilingScheme:function(J,O){var S=this.map;S=S.width>S.height?S.width:S.height;var T=!1,C=!1,H,K;for(H=0;H<J.lods.length;H++){var L=
J.lods[H].scale;J.dpi!==O.dpi&&(L=J.lods[H].scale/J.dpi);for(K=0;K<O.lods.length;K++){var P=O.lods[K].scale;J.dpi!==O.dpi&&(P=O.lods[K].scale/O.dpi);if(Math.abs(P-L)/P<1/S)if(T){C=!0;break}else T=!0;if(P<L)break}if(C)break}return C||T&&(1===J.lods.length||1===O.lods.length)?!0:!1}});a("extend-esri")&&p.setObject("dijit.BasemapGallery",e,q);return e})},"esri/virtualearth/VETiledLayer":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/json dojo/_base/array dojo/_base/config dojo/has dojo/string dojo/_base/Deferred ../kernel ../urlUtils ../SpatialReference ../layers/TileInfo ../layers/TiledMapServiceLayer ../geometry/Extent ../request".split(" "),
function(G,e,t,n,p,h,c,a,b,l,g,f,d,k,m){G=G(d,{declaredClass:"esri.virtualearth.VETiledLayer",constructor:function(v){try{if(v=e.mixin({bingMapsKey:null,culture:"en-US"},v||{}),this.url=l.getProtocolForWebResource()+"//dev.virtualearth.net/REST/v1",this._url=l.urlToObject(this.url),this.spatialReference=new g({wkid:102100}),this.tileInfo=new f({rows:256,cols:256,dpi:96,origin:{x:-2.0037508342787E7,y:2.0037508342787E7},spatialReference:{wkid:102100},lods:[{level:1,resolution:78271.5169639999,scale:2.95828763795777E8},
{level:2,resolution:39135.7584820001,scale:1.47914381897889E8},{level:3,resolution:19567.8792409999,scale:7.3957190948944E7},{level:4,resolution:9783.93962049996,scale:3.6978595474472E7},{level:5,resolution:4891.96981024998,scale:1.8489297737236E7},{level:6,resolution:2445.98490512499,scale:9244648.868618},{level:7,resolution:1222.99245256249,scale:4622324.434309},{level:8,resolution:611.49622628138,scale:2311162.217155},{level:9,resolution:305.748113140558,scale:1155581.108577},{level:10,resolution:152.874056570411,
scale:577790.554289},{level:11,resolution:76.4370282850732,scale:288895.277144},{level:12,resolution:38.2185141425366,scale:144447.638572},{level:13,resolution:19.1092570712683,scale:72223.819286},{level:14,resolution:9.55462853563415,scale:36111.909643},{level:15,resolution:4.77731426794937,scale:18055.954822},{level:16,resolution:2.38865713397468,scale:9027.977411},{level:17,resolution:1.19432856685505,scale:4513.988705},{level:18,resolution:.597164283559817,scale:2256.994353},{level:19,resolution:.298582141647617,
scale:1128.497176},{level:20,resolution:.1492910708238085,scale:564.248588}]}),this.initialExtent=this.fullExtent=new k(-2.0037508342787E7,-2.003750834278E7,2.003750834278E7,2.0037508342787E7,new g({wkid:102100})),e.mixin(this,v),this.hasAttributionData=this.showAttribution,this._initLayer=e.hitch(this,this._initLayer),this._errorHandler=e.hitch(this,this._errorHandler),this._getTileInfo=e.hitch(this,this._getTileInfo),this.bingMapsKey)this._getTileInfo();else throw Error("BingMapsKey must be provided.");
}catch(q){throw this.onError(q),q;}},_unsetMap:function(v,q){this.inherited("_unsetMap",arguments)},_getTileInfo:function(){if(this.mapStyle){var v=this._url.path+"/Imagery/Metadata/"+this.mapStyle,q=window.location.protocol;if(this.bingMapsKey){var r=this.resourceInfo;!this.loaded&&r?this._initLayer(r):m({url:v,content:e.mixin({},{uriScheme:"https:"===q?"https":"http",key:this.bingMapsKey,ss:!0,c:this.culture,include:this.hasAttributionData?"imageryProviders":null}),callbackParamName:"jsonp",load:this._initLayer,
error:this._errorHandler})}}},_initLayer:function(v,q){if(200!==v.statusCode)q=Error(),q.code=v.statusCode,q.message=v.statusDescription,q.details=v.errorDetails,q.authenticationResultCode=v.authenticationResultCode,this.onError(q);else try{this.resourceInfo=t.toJson(v);var r=v.resourceSets[0].resources[0],w=r.imageUrl.replace("{","${");this.tileServers=n.map(r.imageUrlSubdomains,function(y){var x=l.getProtocolForWebResource();return c.substitute(w,{subdomain:y}).replace("http:",x)});this._tsLength=
this.tileServers.length;if(this.loaded)this.refresh(),this.onMapStyleChange();else{this.copyright=this.copyright||"\x26copy; 2017 Microsoft Corporation and its data suppliers";this.loaded=!0;this.onLoad(this);var u=this.loadCallback;u&&(delete this.loadCallback,u(this))}}catch(y){this.onError(y)}},getAttributionData:function(){var v=new a,q=t.fromJson(this.resourceInfo),r;this.hasAttributionData&&q&&(r=e.getObject("resourceSets.0.resources.0.imageryProviders",!1,q));r?v.callback({contributors:r}):
(q=Error("Layer does not have attribution data"),q.log=p.isDebug,v.errback(q));return v},getTileUrl:function(v,q,r){return c.substitute(this.tileServers[q%this._tsLength].replace(/\{/g,"${"),{quadkey:this._getQuadKey(v,q,r),culture:this.culture,token:this.bingMapsKey})},_getQuadKey:function(v,q,r){var w="",u;for(u=v;0<u;u--){v="0";var y=1<<u-1;0!=(r&y)&&v++;0!=(q&y)&&(v++,v++);w+=v}return w},setMapStyle:function(v){this.mapStyle=v;this._getTileInfo()},setCulture:function(v){this.culture=v;this._getTileInfo()},
setBingMapsKey:function(v){this.bingMapsKey=v},onMapStyleChange:function(){}});e.mixin(G,{MAP_STYLE_AERIAL:"aerial",MAP_STYLE_AERIAL_WITH_LABELS:"aerialWithLabelsOnDemand",MAP_STYLE_ROAD:"roadOnDemand"});h("extend-esri")&&e.setObject("virtualearth.VETiledLayer",G,b);return G})},"esri/layers/WebTiledLayer":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/array dojo/_base/url dojo/sniff dojo/string ../config ../kernel ../request ../urlUtils ../SpatialReference ../geometry/Extent ./TiledMapServiceLayer ./TileInfo".split(" "),
function(G,e,t,n,p,h,c,a,b,l,g,f,d,k){function m(v,q){var r=[];if(v&&q&&(q.customLayerParameters||q.customParameters)){var w=e.clone(q.customParameters||{});e.mixin(w,q.customLayerParameters||{});v=l.urlToObject(v);for(var u in v.query)w.hasOwnProperty(u)||r.push(u+"\x3d"+v.query[u]);v=v.path+(r.length?"?"+r.join("\x26"):"")}return v}G=G(d,{declaredClass:"esri.layers.WebTiledLayer",constructor:function(v,q){q||(q={});this.urlTemplate=v=m(v,q.wmtsInfo);var r=new f(-2.0037508342787E7,-2.003750834278E7,
2.003750834278E7,2.0037508342787E7,new g({wkid:102100})),w=new f(-2.0037508342787E7,-2.003750834278E7,2.003750834278E7,2.0037508342787E7,new g({wkid:102100}));this.initialExtent=q.initialExtent||r;this.fullExtent=q.fullExtent||w;this.tileInfo=q.tileInfo?q.tileInfo:new k({dpi:96,rows:256,cols:256,origin:{x:-2.0037508342787E7,y:2.0037508342787E7},spatialReference:{wkid:102100},lods:[{level:0,resolution:156543.033928,scale:5.91657527591555E8},{level:1,resolution:78271.5169639999,scale:2.95828763795777E8},
{level:2,resolution:39135.7584820001,scale:1.47914381897889E8},{level:3,resolution:19567.8792409999,scale:7.3957190948944E7},{level:4,resolution:9783.93962049996,scale:3.6978595474472E7},{level:5,resolution:4891.96981024998,scale:1.8489297737236E7},{level:6,resolution:2445.98490512499,scale:9244648.868618},{level:7,resolution:1222.99245256249,scale:4622324.434309},{level:8,resolution:611.49622628138,scale:2311162.217155},{level:9,resolution:305.748113140558,scale:1155581.108577},{level:10,resolution:152.874056570411,
scale:577790.554289},{level:11,resolution:76.4370282850732,scale:288895.277144},{level:12,resolution:38.2185141425366,scale:144447.638572},{level:13,resolution:19.1092570712683,scale:72223.819286},{level:14,resolution:9.55462853563415,scale:36111.909643},{level:15,resolution:4.77731426794937,scale:18055.954822},{level:16,resolution:2.38865713397468,scale:9027.977411},{level:17,resolution:1.19432856685505,scale:4513.988705},{level:18,resolution:.597164283559817,scale:2256.994353},{level:19,resolution:.298582141647617,
scale:1128.497176},{level:20,resolution:.14929107082380833,scale:564.248588},{level:21,resolution:.07464553541190416,scale:282.124294},{level:22,resolution:.03732276770595208,scale:141.062147},{level:23,resolution:.01866138385297604,scale:70.5310735}]});this.spatialReference=new g(this.tileInfo.spatialReference.toJson());this.copyright=q.copyright||"";var u=new n(v);r=u.scheme+"://"+u.authority+"/";this.urlPath=v.substring(r.length);this.tileServers=q.tileServers||[];-1===u.authority.indexOf("{subDomain}")&&
this.tileServers.push(r);if(q.subDomains&&0<q.subDomains.length&&1<u.authority.split(".").length){this.subDomains=q.subDomains;var y;t.forEach(q.subDomains,function(A){-1<u.authority.indexOf("${subDomain}")?y=u.scheme+"://"+h.substitute(u.authority,{subDomain:A})+"/":-1<u.authority.indexOf("{subDomain}")&&(y=u.scheme+"://"+u.authority.replace(/\{subDomain\}/gi,A)+"/");this.tileServers.push(y)},this)}this.tileServers=t.map(this.tileServers,function(A){"/"!==A.charAt(A.length-1)&&(A+="/");return A});
this._levelToLevelValue=[];var x=0;t.forEach(this.tileInfo.lods,function(A,E){this._levelToLevelValue[A.level]=A.levelValue||A.level;0===E&&(x=this._levelToLevelValue[A.level])},this);this._wmtsInfo=q.wmtsInfo;var z=e.hitch(this,function(){this.loaded=!0;this.onLoad(this)});p("chrome")?(v=this.getTileUrl(x,0,0),q=c.defaults.io,r="with-credentials"===q.useCors?l.canUseXhr(v,!0):-1,(q=-1<r?q.corsEnabledServers[r]:null)&&q.withCredentials?b({url:v,handleAs:"arraybuffer"}).addBoth(function(){z()}):z()):
z()},getTileUrl:function(v,q,r){v=this._levelToLevelValue[v];var w=this.tileServers[q%this.tileServers.length]+h.substitute(this.urlPath,{level:v,z:v,col:r,x:r,row:q,y:q});w=w.replace(/\{level\}/gi,v).replace(/\{row\}/gi,q).replace(/\{col\}/gi,r).replace(/\{z\}/gi,v).replace(/\{x\}/gi,r).replace(/\{y\}/gi,q);w=this._appendCustomLayerParameters(w);w=this.addTimestampToURL(w);return l.addProxy(w)},_appendCustomLayerParameters:function(v){var q;if(this._wmtsInfo&&(this._wmtsInfo.customLayerParameters||
this._wmtsInfo.customParameters)){var r=e.clone(this._wmtsInfo.customParameters||{});e.mixin(r,this._wmtsInfo.customLayerParameters||{});for(q in r)v+=(-1===v.indexOf("?")?"?":"\x26")+q+"\x3d"+encodeURIComponent(r[q])}return v}});p("extend-esri")&&e.setObject("layers.WebTiledLayer",G,a);return G})},"esri/layers/VectorTileLayer":function(){(function(){var G=function(){try{var t=window.WebGLRenderingContext}catch(b){t=!1}try{for(var n=document.createElement("canvas"),p=["webgl","experimental-webgl",
"webkit-3d","moz-webgl"],h=null,c=0;c<p.length;++c){try{h=n.getContext(p[c])}catch(b){}if(h)break}var a=h}catch(b){a=!1}return t&&a?!0:!1}(),e=["dojo/_base/lang","dojo/has","dojo/Deferred","../sniff","./layer"];G&&e.push("./VectorTileLayerImpl");define(e,function(t,n,p,h,c,a){c=a?a:c.createSubclass({declaredClass:"esri.layers.VectorTileLayer",constructor:function(){var b=new p;b.reject(Error("esri.layers.VectorTileLayer is not supported"));b.promise.otherwise(t.hitch(this,function(l){this._errorHandler(l)}))}});
c.ACCESS_TOKEN=null;c.supported=function(){return G};n("extend-esri")&&t.setObject("layers.VectorTileLayer",c,h);return c})})()},"esri/layers/ImageServiceParameters":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/json dojo/has ../kernel ../lang".split(" "),function(G,e,t,n,p,h){G=G(null,{declaredClass:"esri.layers.ImageServiceParameters",extent:null,width:null,height:null,imageSpatialReference:null,format:null,interpolation:null,compressionQuality:null,bandIds:null,timeExtent:null,
mosaicRule:null,renderingRule:null,renderer:null,noData:null,compressionTolerance:null,adjustAspectRatio:null,lercVersion:null,toJson:function(c){var a=this.bbox||this.extent;c=(a=a&&c&&a._normalize(!0))?a.spatialReference.wkid||t.toJson(a.spatialReference.toJson()):null;var b=this.imageSpatialReference;a={bbox:a?a.xmin+","+a.ymin+","+a.xmax+","+a.ymax:null,bboxSR:c,size:null!==this.width&&null!==this.height?this.width+","+this.height:null,imageSR:b?b.wkid||t.toJson(b.toJson()):c,format:this.format,
interpolation:this.interpolation,compressionQuality:this.compressionQuality,bandIds:this.bandIds?this.bandIds.join(","):null,mosaicRule:this.mosaicRule?t.toJson(this.mosaicRule.toJson()):null,renderingRule:this.renderingRule?t.toJson(this.renderingRule.toJson()):null,renderer:this.renderer?t.toJson(this.renderer.toJson()):null,noData:this.noData,noDataInterpretation:this.noDataInterpretation,compressionTolerance:this.compressionTolerance,adjustAspectRatio:this.adjustAspectRatio,lercVersion:this.lercVersion};
c=this.timeExtent;a.time=c?c.toJson().join(","):null;return h.filter(a,function(l){if(null!==l&&void 0!==l)return!0})}});e.mixin(G,{INTERPOLATION_BILINEAR:"RSP_BilinearInterpolation",INTERPOLATION_CUBICCONVOLUTION:"RSP_CubicConvolution",INTERPOLATION_MAJORITY:"RSP_Majority",INTERPOLATION_NEARESTNEIGHBOR:"RSP_NearestNeighbor",NODATA_MATCH_ALL:"esriNoDataMatchAll",NODATA_MATCH_ANY:"esriNoDataMatchAny"});n("extend-esri")&&e.setObject("layers.ImageServiceParameters",G,p);return G})},"esri/layers/RasterXLayer":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/connect dojo/_base/array dojo/_base/Deferred dojo/sniff dojo/dom-construct dojo/dom-style dojo/on dojox/gfx/matrix dojo/when dojo/DeferredList ../kernel ../config ../lang ../domUtils ../urlUtils ../graphic ../request ../renderers/ClassBreaksRenderer ../renderers/StretchRenderer ../renderers/UniqueValueRenderer ../renderers/ColormapRenderer ../renderers/ShadedReliefRenderer ../geometry/Extent ../SpatialReference ../geometry/Point ./Field ./TimeInfo ./MosaicRule ./DimensionalDefinition ./PixelBlock ./ImageServiceLayerMixin ./rasterLib/raster/rasterFactory ./rasterLib/raster/rasterProjectionHelper ./rasterLib/renderer/rasterRendererHelper ./rasterLib/tile/RasterTileInfo ./rasterLib/tile/RasterTileManager ./rasterLib/tile/RasterHandler ./layer".split(" "),
function(G,e,t,n,p,h,c,a,b,l,g,f,d,k,m,v,q,r,w,u,y,x,z,A,E,F,B,D,I,M,N,Q,V,X,W,Z,aa,J,O,S){var T=k.defaults.map.zoomDuration;G=G([S],{declaredClass:"esri.layers.RasterXLayer",managedSuspension:!0,opacity:1,tileMode:!0,useWebGL:!0,drawMode:!0,_eventMap:{"raster-change":!0,"renderer-change":!0},_lastPopup:[],_rasterFieldPrefix:"Raster.",_cachedVariableStats:{},_cachedVariableHistogram:{},constructor:function(C,H){H=H||{};this.tileMode=null!=H.tileMode?H.tileMode:this.tileMode;this.useWebGL=null!=H.useWebGL?
H.useWebGL:this.useWebGL;this.roaming=null!=H.roaming?H.roaming:this.roaming;this.drawMode=null!=H.drawMode?H.drawMode:this.drawMode;this.bandIds=H.bandIds&&0<H.bandIds.length?H.bandIds:null;this.renderer=H.renderer;this._customModules=H.customModules;this.useMapTime=H.useMapTime;if(H.multidimensionalDefinition&&0<H.multidimensionalDefinition.length){var K=new M;K.multidimensionalDefinition=H.multidimensionalDefinition.map(function(L){return L.toJson?L:new N(L)});K.method=M.METHOD_NONE;this.mosaicRule=
K}this.infoTemplate=H.infoTemplate;this.drawMode||(this._contextType=H._contextType||H.drawType);this._supportLegacyPropMethods=!1!==H.legacySupport;this._rasterHandler=new O({customModules:this._customModules});this._workInitPromise=this._rasterHandler.start();this.pixelData=null;this._initialize(C,H);b(this,"load",e.hitch(this,function(){g(this._rasterHandler._connected||this._rasterHandler._connectionPromise,e.hitch(this,function(){this._rasterHandler.setLayer({layerId:this.id,raster:{rasterInfo:this.raster.rasterInfo,
rasterFunction:this.raster.rasterFunction&&this.raster.rasterFunction.toJson()},bandCount:this.raster.rasterInfo.bandCount});this.raster.rasterFunction&&this._rasterHandler.setRasterFunction({layerId:this.id,data:this.raster.rasterFunction.toJson(!0)});this._rasterRenderer&&this._rasterHandler.setRasterRenderer({layerId:this.id,data:this._rasterRenderer.toJson(!0)})}))}));this._animatePan2d=e.hitch(this,this._animatePan2d)},setOpacity:function(C){this.opacity!==C&&(this.opacity=C,this.onOpacityChange(C))},
onOpacityChange:function(){},onRendererChange:function(){},refresh:function(){if(this.loaded&&this._map)if(!this._canDraw()||10>h("ie"))this.onError(Error("Unable to refresh. This layer is not supported in the current browser."));else this._map&&this._extentChangeHandler(this._map.extent)},clear:function(C,H,K,L){this._canDraw()&&(this.useWebGL||(K?this._context.clearRect(C,H,K,L):this._context.clearRect(0,0,this._map.width,this._map.height)))},getContext:function(){return this._context},onResume:function(){this.inherited(arguments);
this._toggleTime();v.show(this._div);if("css-transforms"===this._map.navigationMode){var C=this._map.__visibleDelta;this._left=this._tdx=C.x;this._top=this._tdy=C.y;a.set(this._div,d._css.names.transform,d._css.translate(this._left,this._top))}this._displayTimer=this._displayTimer||setTimeout(e.hitch(this,function(){this._extentChangeHandler(this._map.extent,null,!0)}),0)},onSuspend:function(){this.inherited(arguments);this._fireUpdateEnd();this._toggleTime();v.hide(this._div);clearTimeout(this._displayTimer);
this._displayTimer=null},redraw:function(){this.useWebGL&&this._glSetting&&(this._glSetting.hasNewTexture=!1);var C=this.tileMode?this.tileManager.originalPixelData:this.originalPixelData;if(this.tileMode?C&&(C.src||C.texture):C)if(this.tileMode)if(this.useWebGL)this._updateAllTilesOnce(C);else{this.tileManager.tiles.forEach(function(K){K&&(K.update=null,K.completed=!1,K.processedPixelBlock=null,K.renderedPixelBlock=null)});C.processedPixelBlock=null;var H=this.raster.rasterFunction?this.raster.rasterFunction.read(C):
{extent:C.extent,pixelBlock:C.src[this.tileManager.identifiers[0]]&&C.src[this.tileManager.identifiers[0]].pixelBlock};C.renderedPixelBlock=null;C=this._rasterRenderer?this._rasterRenderer.draw(H):H;this._drawOneFrame(C)}else this._supportLegacyPropMethods&&this.pixelFilter?this._setPixelData(this.originalPixelData):(C.processedPixelBlock=null,H=this.raster.rasterFunction?this.raster.rasterFunction.read(C):{extent:C.extent,pixelBlock:C.src?C.src[this.tileManager.identifiers[0]]&&C.src[this.tileManager.identifiers[0]].pixelBlock:
C.pixelBlock},C.renderedPixelBlock=null,C=this._rasterRenderer?this._rasterRenderer.draw(H):H,this._drawOneFrame(C))},getCurrentResolution:function(){var C=this._map.extent;return new B((C.xmax-C.xmin)/this._map.width,(C.ymax-C.ymin)/this._map.height,C.spatialReference)},getCustomRasterFields:function(C){var H=C?C.rasterAttributeTableFieldPrefix:this._rasterFieldPrefix,K={name:this._rasterFieldPrefix+"ServicePixelValue",alias:"Pixel Value",domain:null,editable:!1,length:50,type:10.3<=this.version?
"esriFieldTypeDouble":"esriFieldTypeString"};C=this.fields?e.clone(this.fields):[];C.push(K);(K=this.rasterAttributeTable&&this.rasterAttributeTable.fields)&&0<K.length&&(K=n.filter(K,function(L){return"esriFieldTypeOID"!==L.type&&"value"!==L.name.toLowerCase()}),K=n.map(K,function(L){var P=e.clone(L);P.name=H+L.name;return P}),C=C.concat(K));return C},setRenderer:function(C,H){if(this.loaded&&C){if(C.declaredClass&&-1<C.declaredClass.indexOf("esri.layers.rasterLib")){this._rasterRenderer=C;this._rasterRenderer.bind({layer:this});
var K=this.bandIds=C.bandIndex;this.raster&&this.raster.setFetchParameters({bandIds:K});this._params&&(this._params.bandIds=K&&0<K.length?K.join(","):null);this.renderer=this._getCommonRenderer(C)}else K=e.clone(C.toJson?C.toJson():C),"rasterStretch"===K.type&&(K.bandIndex=this.bandIds,K.bandIndex&&1<K.bandIndex.length||!K.bandIndex&&this.raster&&1<this.raster.rasterInfo.bandCount)&&(K.type="rgb"),this._rasterRenderer=Z.create(K),this.renderer=C.declaredClass?C:this._getCommonRenderer(this._rasterRenderer),
this._rasterRenderer.bind({layer:this});if(this._map){if(this.loaded&&this._rasterHandler._connected){var L=this._rasterHandler.setRasterRenderer({layerId:this.id,data:this._rasterRenderer.toJson(!0)});this._updateTilingEffects()}H||(L?L.then(e.hitch(this,function(){this.redraw()})):this.redraw());this.onRendererChange()}}},setBandIds:function(C,H){this.bandIds=C;this.raster&&this.raster.setFetchParameters({bandIds:C});this._params&&(this._params.bandIds=C&&0<C.length?C.join(","):null);this.setRenderer(this.renderer,
H)},_setTime:function(C){C=C?C.toJson():null;this._params&&(this._params.time=C);this.raster.setFetchParameters({time:C});this.tileManager&&this.tileManager.tiles&&this.tileManager.resetTiles()},setInfoTemplate:function(C){this.infoTemplate=C;this._updateInfoTemplateFields(this.fields)},setMultiDimensionalDefinition:function(C,H){var K=C&&C.multidimensionalDefinition;if(K&&this.loaded){var L=K&&K[0].variableName;""===L&&(L=this._multidimensionalInfo.variables[0].name,K.forEach(function(R){R.variableName=
L}));if("ImageService"===this.raster.sourceType){var P=this.raster._getAllDimensionDefinition(K,L);P.defChanged&&(C.multidimensionalDefinition=P.definition,this.setMosaicRule(C,!0))}this.raster.setFetchParameters({multidimensionalDefinition:K});this.tileManager&&this.tileManager.tiles&&this.tileManager.resetTiles();L&&this._updateRasterInfo(L);H||this.refresh()}},_updateRasterInfo:function(C){var H=this.raster.rasterInfo,K=this.getHistograms(C);C=this.getStatistics(C);(new f([K,C])).then(e.hitch(this,
function(L){L[0][0]&&(H.histograms=L[0][1].histograms);L[1][0]&&(H.statistics=L[1][1]);this.refresh()}))},_updateInfoTemplateFields:function(C){if(C&&!(1>C.length)&&this.infoTemplate&&this.infoTemplate.info&&this.infoTemplate.info.fieldInfos&&!(1>this.infoTemplate.info.fieldInfos.length)){var H,K;var L=this.infoTemplate.info.fieldInfos;for(H=0;H<C.length;H++){var P=C[H];for(K=0;K<L.length;K++)if(L[K].fieldName.toLowerCase()===P.name.toLowerCase()&&L[K].fieldName!==P.name){L[K].fieldName=P.name;break}}}},
getPixelData:function(C){return this.tileMode?C?this.tileManager.originalPixelData.src&&this.tileManager.originalPixelData.src[this.tileManager.identifiers[0]]:null:this.inherited(arguments)},fetchPopupFromTiles:function(C){var H=new p;this.identify(C.geometry).then(function(K){var L=K.pixelValue;this.hasStdTime()&&L&&L.length&&null!=L[0]&&(L=L.map(function(U){return this.getStdTimeValue(U)}.bind(this)).join(", "));if(L){K={ObjectId:0,"Raster.ServicePixelValue":L};var P=this.rasterAttributeTable&&
this.rasterAttributeTable.features;if(P&&0<P.length&&(P=n.filter(P,function(U){if(U&&U.attributes)return U.attributes.hasOwnProperty("Value")?U.attributes.Value==L:U.attributes.VALUE==L}),0<P.length&&(P=e.clone(P[0]))))for(var R in P.attributes)P.attributes.hasOwnProperty(R)&&(K[this._rasterFieldPrefix+R]=P.attributes[R]);R=new r(new E(this.projectedFullExtent||this.fullExtent),null,K);R.setInfoTemplate(this.infoTemplate);R._layer=this;this._lastPopup=[R];H.resolve([R])}else this._lastPopup=[],H.resolve()}.bind(this),
function(K){this._lastPopup=[];H.resolve(K)});return H},getPopupFromTiles:function(){return this._lastPopup},identify:function(C,H){return this.raster?this.raster.identify(C):(C=new p,C.reject("layer must be initialized to identify"),C.promise)},_getCommonRenderer:function(C){switch(C.rendererName){case "RGB":case "Stretch":return new y(C.toCommonRendererJson());case "UniqueValue":return new x(C.toCommonRendererJson());case "ClassBreaks":return new u(C.toCommonRendererJson());case "Colormap":return new z(C.toCommonRendererJson());
case "ShadedRelief":return new A(C.toCommonRendererJson())}},_getProjectedFullExtent:function(C){return this.raster.getProjectedFullExtent(C).then(e.hitch(this,function(H){this.projectedFullExtent=H}))},_initialize:function(C,H){H=H||{};this._supportLegacyPropMethods&&this.constructor._onMap&&(this.constructor._onMap["rendering-change"]={method:"onRenderingChange"},this.constructor._onMap["mosaic-rule-change"]={method:"onMosaicRuleChange"},this.constructor._onMap["spatial-reference-change"]={method:"onSpatialReferenceChange"});
this.raster={};var K=H.raster?H.raster.url:C;K&&-1<K.toLowerCase().indexOf("/imageserver")&&this._supportLegacyPropMethods&&this._addLegacySupport(K,H);var L=e.hitch(this,function(){this.loaded=!0;this.mosaicRule&&this.mosaicRule.multidimensionalDefinition&&0<this.mosaicRule.multidimensionalDefinition.length&&this.setMultiDimensionalDefinition(this.mosaicRule,!0);this.raster._setRasterHandler(this._rasterHandler);this.onLoad(this);var P=this._loadCallback;P&&(delete this._loadCallback,P(this))});
(C?X.create(e.mixin({url:C},H)):H.raster&&H.raster.open()).then(e.hitch(this,function(P){if(P){this.raster=P;var R=this._getSourceImageServiceRaster();this.url||(this.url=R&&R.url);this.url&&(this._url=q.urlToObject(C));var U=H.minScale,Y=H.maxScale,ja=P.tileInfo&&"Raster"===P.tileInfo.tileType;null==Y&&(Y=ja&&H.zoomFactor?P.tileInfo.lods[P.tileInfo.lods.length-1].scale/H.zoomFactor:this.maxScale);null==U&&(U=ja&&H.zoomFactor?P.tileInfo.lods[0].scale*H.zoomFactor:this.minScale);R&&"ImageService"===
R.sourceType&&this._supportLegacyPropMethods&&this._addGeneralProperties(C,H);this.initialExtent=this.fullExtent=this.extent=this.raster.rasterInfo.extent;this.spatialReference=this.extent.spatialReference;this.timeInfo=this.raster.rasterInfo.timeInfo?new I(this.raster.rasterInfo.timeInfo):null;this.rasterAttributeTable=this.raster.rasterInfo.vat;this._multidimensionalInfo=this.raster.rasterInfo.multidimensionalInfo;this.rasterAttributeTable&&(this._rasterAttributeTableFields=this.rasterAttributeTable.fields);
this.mosaicRule&&this.raster.setFetchParameters({multidimensionalDefinition:this.mosaicRule.multidimensionalDefinition});this._multidimensionalInfo&&(this._getDefaultMultidimensionalDefinition(this._multidimensionalInfo,!0,!0),this.mosaicRule||(this.mosaicRule=this.defaultMosaicRule,this.raster.setFetchParameters({multidimensionalDefinition:this._defaultMultidimensionalDefinition})),this.raster.defaultMultidimensionalDefinition=this._defaultMultidimensionalDefinition);null==U||this._hasMin||this.setMinScale(U);
null==Y||this._hasMax||this.setMaxScale(Y);this._workInitPromise?this._workInitPromise.then(L,L):L()}else console.error("cannot create rasterx layer as the raster data source cannot be opened")}),this._errorHandler)},_getSourceImageServiceRaster:function(){var C=this.raster&&"Function"===this.raster.sourceType?1===this.raster.getMemberRasters().length?this.raster.getMemberRasters()[0]:null:this.raster;if(C&&"ImageService"===C.sourceType)return C},_addLegacySupport:function(C,H){this._url=q.urlToObject(C);
H=H||{};this.format=(C=H.imageServiceParameters)&&C.format;this.compressionTolerance=C&&C.compressionTolerance?C.compressionTolerance:.01;this.interpolation=C?C.interpolation:null;this.compressionQuality=C?C.compressionQuality:null;this.bandIds=C&&C.bandIds||H&&H.bandIds||null;this.mosaicRule||(this.mosaicRule=C?C.mosaicRule:null);this.renderingRule||(this.renderingRule=C?C.renderingRule:null);this.useMapDimensionValue=H.hasOwnProperty("useMapDimensionValue")?!!H.useMapDimensionValue:!0;this.hasImageFilter=
H.hasImageFilter;this.activeMapDimensions=H.activeMapDimensions;this._params=e.mixin({},this._url.query,{f:"image",interpolation:this.interpolation,format:this.format,compressionQuality:this.compressionQuality,bandIds:this.bandIds?this.bandIds.join(","):null},C?C.toJson():{});this.pixelFilter=H.pixelFilter;this.originalPixelData=this.pixelData=null;this._queryVisibleRastersHandler=e.hitch(this,this._queryVisibleRastersHandler);this._useRenderingRuleAttributeTable=!1;this._rasterFunctionTemplateInfos=
{};this._customRenderingRuleId={};this._setDefaultFilter=function(){};var K={setInterpolation:"interpolation",setCompressionQuality:"compressionQuality",setCompressionTolerance:"compressionTolerance",setBandIds:"bandIds",setDefaultBandIds:"bandIds",setMosaicRule:"mosaicRule",setRenderingRule:"renderingRule",setImageFormat:"format"},L,P=new V;Object.keys(K).forEach(e.hitch(this,function(R){this[R]=e.hitch(this,function(U,Y){L={};L[K[R]]=U;this.raster&&(this.raster.setFetchParameters(L),P[R].bind(this)(U,
Y))})}));this.setDisableClientCaching=function(R){P.setDisableClientCaching.bind(this)(R);var U=this._getSourceImageServiceRaster();U?U.disableClientCaching=R:null}.bind(this);this.setDefinitionExpression=P.setDefinitionExpression.bind(this);this.setUseMapTime=P.setUseMapTime.bind(this);this._toggleTime=P._toggleTime.bind(this);this._onTimeExtentChangeHandler=P._onTimeExtentChangeHandler.bind(this);this.setPixelFilter=P.setPixelFilter.bind(this);this.getHistograms=P.getHistograms.bind(this);this.getRasterFunctionInfos=
P.getRasterFunctionInfos.bind(this);this.getKeyProperties=P.getKeyProperties.bind(this);this.getRasterAttributeTable=P.getRasterAttributeTable.bind(this);this.getRenderingRuleServiceInfo=P.getRenderingRuleServiceInfo.bind(this);this._getRenderingRuleId=P._getRenderingRuleId.bind(this);this._isRenderingRuleAProcessingTemplate=P._isRenderingRuleAProcessingTemplate.bind(this);this.handleSpatialReferenceChange=P.handleSpatialReferenceChange.bind(this);this.onRenderingChange=this.onRenderingChange||function(){};
this.onSpatialReferenceChange=this.onSpatialReferenceChange||function(){};this.onMosaicRuleChange=this.onMosaicRuleChange||function(R){};this.setRasterRenderer=this.setRenderer;this.getMultidimensionalInfo=P.getMultidimensionalInfo.bind(this);this.getColormap=P.getColormap.bind(this);this.getRenderingRuleColormap=P.getRenderingRuleColormap.bind(this);this.getDefaultMultidimensionalDefinition=P.getDefaultMultidimensionalDefinition.bind(this);this._getDefaultMultidimensionalDefinition=P._getDefaultMultidimensionalDefinition.bind(this);
this._getDefaultDimensionValue=P._getDefaultDimensionValue.bind(this);this.getStatistics=P.getStatistics.bind(this)},_addGeneralProperties:function(){var C=this._getSourceImageServiceRaster();if(C){var H=["minScale","maxScale","tileInfo"];Object.keys(C.serviceInfo).forEach(function(P){null==this[P]&&-1===H.indexOf(P)&&(this[P]=C.serviceInfo[P])}.bind(this));this.pixelSizeX=parseFloat(this.pixelSizeX);this.pixelSizeY=parseFloat(this.pixelSizeY);this.bands=C.rasterInfo.statistics;var K,L=[];this.fields=
this.fields||[];for(K=0;K<this.fields.length;K++)L.push(new D(this.fields[K]));this.fields=L;this.version=this.currentVersion;this.defaultMosaicRule=C.serviceInfo.defaultMosaicRule}},setDefaultRenderer:function(){if(this.loaded&&this._canvas&&!this.pixelFilter){var C=Z.createDefaultRenderer(this);if(null!=C){var H=this.mosaicRule&&this.mosaicRule.multidimensionalDefinition&&0<this.mosaicRule.multidimensionalDefinition.length;if(this._multidimensionalInfo&&H&&"Stretch"===C.rendererName){var K=this.mosaicRule.multidimensionalDefinition[0].variableName;
(H=this._multidimensionalInfo.variables.filter(function(L){return L.name===K})[0])&&H.histograms&&H.histograms.length&&(C.histograms=H.histograms,6===C.stretchType&&(C.dra=!1));H&&H.statistics&&H.statistics.length&&(C.statistics=H.statistics.map(function(L){return[L.min,L.max,L.mean,L.stddev||L.standardDeviation]}),6!==C.stretchType&&(C.dra=!1))}this.setRenderer(C,!0)}}},setDefaultInterpolation:function(){if(this.loaded&&this._canvas){var C=this.raster.serviceInfo&&this.raster.serviceInfo.defaultResamplingMethod;
if(C)switch(C.toLowerCase()){case "bilinear":this.interpolation="RSP_BilinearInterpolation";break;case "cubic":this.interpolation="RSP_CubicConvolution";break;case "majority":this.interpolation="RSP_Majority";break;case "nearest":this.interpolation="RSP_NearestNeighbor"}else{C=this.raster.dataType&&this.raster.dataType.toLowerCase();var H=!!this.raster.rasterInfo.colormap;this.raster.rasterInfo.vat||H||"thematic"===C||"StdTime"===C?"RSP_NearestNeighbor":"RSP_BilinearInterpolation"}}},_toggleTime:function(){},
_updateTilingEffects:function(){(this._hasTilingEffects=this._rasterRenderer&&this._rasterRenderer.hasTilingEffects()||this.raster&&this.raster.rasterFunction&&this.raster.rasterFunction.hasTilingEffects())&&this._map&&this.tileMode&&this.useWebGL&&this.tileManager&&(this._hasTilingEffects=!1)},_setMap:function(C,H){this.inherited(arguments);C.spatialReference&&(C.spatialReference.ics||C.spatialReference.icsId)&&(this.roaming=this.useWebGL=this.tileMode=!1);if(this.tileMode){this.virtualTileInfo=
new aa(null,{refTileInfo:C.tileInfo,spatialReference:C.spatialReference,extent:this.raster.rasterInfo.extent});var K=this.raster.tileInfo&&(-1<["Elevation","Raster"].indexOf(this.raster.tileInfo.tileType)||3===this.raster.rasterInfo.bandCount&&"U8"===this.raster.rasterInfo.pixelType)?this.raster.tileInfo:this.virtualTileInfo;this._tileParams=this._tileParams||{};this._tileParams.size=K.cols+","+K.rows;this.tileManager=new J({tileInfo:K,layer:this,mapSR:C.spatialReference})}this._dragOrigin={x:0,y:0};
K=this._div=c.create("div",null,H);var L={width:C.width+"px",height:C.height+"px",position:"absolute"};"css-transforms"===C.navigationMode?this.roaming&&this.tileMode&&this.useWebGL||(L[d._css.names.transform]=d._css.translate(C.__visibleDelta.x,C.__visibleDelta.y),this._left=C.__visibleDelta.x,this._top=C.__visibleDelta.y):this._left=this._top=0;a.set(K,L);this._canvas=c.create("canvas",{width:C.width+"px",height:C.height+"px",style:"position: absolute;"},K);m.isDefined(this.opacity)&&a.set(K,"opacity",
this.opacity);this._contextType?(this._context=this._canvas.getContext(this._contextType,null),this.useWebGL=this._context instanceof WebGLRenderingContext):this.useWebGL?(this._context=this._canvas.getContext("webgl",null)||this._canvas.getContext("experimental-webgl",null),this.drawMode=!1):(this._context=this._canvas.getContext("2d"),this.drawMode=!0);this._context||console.error("Unable to create the context. This browser might not support \x3ccanvas\x3e elements.");this.useWebGL&&(C.acquireWebGLContext(this),
this._glSetting={gl:this._context,branchCount:this.raster.rasterFunction?this.raster.rasterFunction.branchCount:0,pingpong:null,branches:null,drawMesh:this._drawMesh,programUniforms:{}});this.raster.rasterFunction&&(this._updateTilingEffects(),this.raster.setProcessingContext({layer:this}));this.setRenderer(this.renderer,!0);this._rasterRenderer||this.setDefaultRenderer();this.interpolation||this.setDefaultInterpolation();this._mapWidth=C.width;this._mapHeight=C.height;this._connects=[];this._connects.push(t.connect(C,
"onPan",this,this._panHandler));this._connects.push(t.connect(C,"onPanEnd",this,this._panEndHandler));"css-transforms"===C.navigationMode?this._connects.push(t.connect(C,"onScale",this,this._onScaleHandler)):(this._connects.push(t.connect(C,"onZoom",this,this._onZoomHandler)),this._connects.push(t.connect(C,"onZoomEnd",this,this._onZoomEndHandler)));this._connects.push(t.connect(C,"onResize",this,this._onResizeHandler));this._connects.push(t.connect(C,"onExtentChange",this,this._extentChangeHandler));
this._connects.push(t.connect(this,"onVisibilityChange",this,this._visibilityChangeHandler));this._connects.push(t.connect(this,"onOpacityChange",this,this._opacityChangeHandler));this._startRect={left:0,top:0,width:C.width,height:C.height};this.evaluateSuspension();if(this.suspended&&!C.loaded)var P=t.connect(C,"onLoad",this,function(){t.disconnect(P);P=null;this.evaluateSuspension()});return K},_unsetMap:function(C,H){this.useWebGL&&C.releaseWebGLContext(this);n.forEach(this._connects,t.disconnect,
this);var K=this._div;K&&(H.removeChild(K),c.destroy(K));this._map=this._canvas=this._context=this.data=this._connects=null;clearTimeout(this._displayTimer);this._displayTimer=null;this.inherited(arguments)},_canDraw:function(){return!!(this._map&&this._canvas&&this._context)},_requestDataErrorHandler:function(C){"CancelError"!==C.name&&(this.clear(),this.onError(C))},_clonePixelData:function(C){if(null===C||C.texture)return C;var H={};C.extent&&(H.extent=e.clone(C.extent));var K=C.pixelBlock;null!=
K&&(H.pixelBlock=K.clone());H.texture=C.texture;return H},_setPixelData:function(C){if(C){C=this._clonePixelData(C);this.pixelFilter&&(this.pixelFilter.filter?(this.pixelFilter.renderTexture=!0,this.pixelFilter.filter(C)):this.pixelFilter(C));this.pixelData=C;if(this._rasterReadPromise&&this._rasterReadPromise.isCanceled())return;this._drawPixelData()}this._rasterReadPromise=null},_requestData:function(C,H,K){this._rasterReadPromise&&this._rasterReadPromise.cancel();C=e.clone(C)._normalize(!0);this._rasterReadPromise=
this.raster.read({extent:C,width:this._map.width,height:this._map.height});this._rasterReadPromise.then(e.hitch(this,function(L){this._rasterReadPromise&&this._rasterReadPromise.isCanceled()||(this.originalPixelData=L&&L.srcData?{extent:L.extent,src:L.srcData}:L,this.useWebGL&&this._glSetting&&(this._glSetting.hasNewTexture=!0),this._setPixelData(L))}),e.hitch(this,this._requestDataErrorHandler));return this._rasterReadPromise},_drawPixelData:function(C){a.set(this._canvas,{left:"0px",top:"0px",width:this._map.width+
"px",height:this._map.height+"px"});this._startRect={left:0,top:0,width:this._map.width,height:this._map.height};this.drawMode||"css-transforms"!==this._map.navigationMode||(this._tdx=this._left,this._tdy=this._top,this._multiply=null,a.set(this._div,d._css.names.transform,d._css.translate(this._left,this._top)),a.set(this._canvas,d._css.names.transform,d._css.translate(-this._left,-this._top)),this._dragOrigin={x:0,y:0});this.useWebGL&&this._rasterRenderer&&this._rasterRenderer.draw(this.pixelData);
if(this._canDraw()&&this.drawMode&&this.drawMode&&(C=C||this.pixelData)&&C.pixelBlock){var H=this.pixelFilter?this.pixelData:this._rasterRenderer?this._rasterRenderer.draw(C):C;C=H.pixelBlock;var K=this._context,L=K.createImageData(C.width,C.height);L.data.set(C.getAsRGBA());H=H.extent;var P=this._map.extent,R=this.getCurrentResolution(),U=0,Y=0;Math.abs(H.xmin-P.xmin)>R.x&&(U=Math.round((H.xmin-P.xmin)/R.x));Math.abs(P.ymax-H.ymax)>R.y&&(Y=Math.round((P.ymax-H.ymax)/R.y));"css-transforms"===this._map.navigationMode?
(this._tdx=this._left,this._tdy=this._top,this._multiply=null,a.set(this._div,d._css.names.transform,d._css.translate(this._left,this._top)),a.set(this._canvas,d._css.names.transform,d._css.translate(-this._left,-this._top))):(a.set(this._div,{left:"0px",top:"0px",width:this._map.width+"px",height:this._map.height+"px"}),a.set(this._canvas,{left:"0px",top:"0px",width:this._map.width+"px",height:this._map.height+"px"}));this._dragOrigin={x:0,y:0};this.tileMode?this.clear(U,Y,C.width,C.height):this.clear();
K.putImageData(L,U,Y,0,0,C.width,C.height);this._fireUpdateEnd()}},hasStdTime:function(){if(!this.hasMultidimensions||"StdTime"!==this.raster.dataType)return!1;var C=this.mosaicRule&&this.mosaicRule.multidimensionalDefinition,H=C&&C.length?C[0].variableName:this._defaultMultidimensionalDefinition[0].variableName;return this.raster.rasterInfo.multidimensionalInfo.variables.some(function(K){if(K.name===H)return K.dimensions.some(function(L){return"StdTime"===L.name})})},getStdTimeValue:function(C){return(new Date(864E5*
(C-25569))).toString()},_animatePan2d:function(){this._oldDelta&&this._delta.x===this._oldDelta.x&&this._delta.y===this._oldDelta.y||(this.tileManager.updateTile(this.tileManager.originalPixelData,!0),this._oldDelta={x:this._delta.x,y:this._delta.y});this._roamingAnimation&&this.tileMode&&this.useWebGL&&(this._roamingAnimation=requestAnimationFrame(this._animatePan2d))},_cancelAnimation:function(){this._animation&&(cancelAnimationFrame(this._animation),this._animation=null)},_updateAllTilesOnce:function(C,
H){return this.tileManager.updateTile(C,!0).then(e.hitch(this,function(K){(this._hasTilingEffects||this.useWebGL||H)&&this._drawOneFrame(K)}))},_drawOneFrame:function(C,H){if(!(this.suspended||!this._map||this.tileMode&&!this._drawTile||(this.tileMode&&this.useWebGL&&this.tileManager.originalPixelData.isEmpty&&this._context.clear(this._context.COLOR_BUFFER_BIT),this.tileMode&&this.useWebGL&&this.tileManager.xformSetting&&this.tileManager.xformSetting.requireProjection&&!this.tileManager.xformSetting.gridConfig))){if(!this._resetCss||
this._levelChange)this._levelChange=!1,this._resetDrawing();if(C&&(C.renderedPixelBlock||C.pixelBlock)&&this._canDraw()&&this.drawMode){H=C.extent;var K=this._map.extent;if(!this._isExtentOutSide(H,K)){var L=C.pixelBlock||C.renderedPixelBlock,P=this._context,R=P.createImageData(L.width,L.height);R.data.set((C.renderedPixelBlock||C.pixelBlock).getAsRGBA());C=this.getCurrentResolution();var U=0,Y=0;Math.abs(H.xmin-K.xmin)>C.x&&(U=Math.round((H.xmin-K.xmin)/C.x));Math.abs(K.ymax-H.ymax)>C.y&&(Y=Math.round((K.ymax-
H.ymax)/C.y));P.putImageData(R,U,Y,0,0,L.width,L.height)}}else this._fireUpdateEnd()}},_isExtentOutSide:function(C,H){return C.xmax<=H.xmin||C.xmin>=H.xmax||C.ymax<=H.ymin||C.ymin>=H.ymax},_resetDrawing:function(){this._resetCss=!0;if(!this.useWebGL)if(this._multiply||this._startRect.width!==this._map.width||this._startRect.height!==this._map.height)this.clear();else{var C=this._context.getImageData(0,0,this._map.width,this._map.height);this.clear();this._context.putImageData(C,this._startRect.left,
this._startRect.top)}this._dragOrigin={x:0,y:0};this._startRect={left:0,top:0,width:this._map.width,height:this._map.height};a.set(this._canvas,{left:"0px",top:"0px",width:this._map.width+"px",height:this._map.height+"px"});"css-transforms"===this._map.navigationMode?(this.roaming&&this.tileMode&&this.useWebGL&&(this._delta=null),this._tdx=this._left,this._tdy=this._top,this._multiply=null,a.set(this._div,d._css.names.transform,d._css.translate(this._left,this._top)),a.set(this._canvas,d._css.names.transform,
d._css.translate(-this._left,-this._top))):(a.set(this._div,{left:"0px",top:"0px",width:this._map.width+"px",height:this._map.height+"px"}),a.set(this._canvas,{left:"0px",top:"0px",width:this._map.width+"px",height:this._map.height+"px"}))},_drawAllFrames:function(){if(!this.suspended&&this._map&&(!this.tileMode||this._drawTile))if(this._resetCss){var C=this._frames,H=0,K;for(K=0;K<C.length;K++)if(C[K].completed)H++;else if(C[K].tileData.renderedPixelBlock){C[K].completed=!0;var L=C[K].tileData;break}else if(C[K].tileData._fetched&&
!C[K].tileData.src){C[K].completed=!0;break}else if(C[K].tileData.update&&C[K].tileData.update.isFulfilled()&&!C[K].tileData.renderedPixelBlock){C[K].completed=!0;break}else C[K].tileData.fetch&&(!0===C[K].tileData.fetch||C[K].tileData.fetch.isCanceled()||C[K].tileData.fetch.isRejected())?(C[K].completed=!0,H++):this._isExtentOutSide(C[K].tileData.extent,this._map.extent)&&(C[K].completed=!0,H++);if(L){H++;var P=L.extent,R=this._map.extent,U=this.getCurrentResolution(),Y=K=0;Math.abs(P.xmin-R.xmin)>
U.x&&(K=Math.round((P.xmin-R.xmin)/U.x));Math.abs(R.ymax-P.ymax)>U.y&&(Y=Math.round((R.ymax-P.ymax)/U.y));L.renderedPixelBlock?(P=L.renderedPixelBlock,R=this._context.createImageData(P.width,P.height),R.data.set(L.renderedPixelBlock.getAsRGBA()),this._context.putImageData(R,K,Y,0,0,P.width,P.height)):this.clear(K,Y,L.width,L.height)}H===C.length?(this._animation=null,this._fireUpdateEnd()):this._animation=requestAnimationFrame(e.hitch(this,this._drawAllFrames))}else this._resetDrawing(),this._animation=
requestAnimationFrame(e.hitch(this,this._drawAllFrames))},_fetchTiles:function(C,H){if(!this.suspended&&this.loaded){this._cancelAnimation();var K=this.tileManager,L=!(K.xformSetting.requireProjection&&K.xformSetting.requirePE)||W.load();g(L,e.hitch(this,function(){K.updateExtent(C,this.getCurrentResolution());this._resetCss=!1;K.fetchTiles(H);H&&(this._hasTilingEffects||this.useWebGL?this.useWebGL&&0<K.tiles.length?(K.fillupTiles(),K._validateRawPixelBlocks(K.originalPixelData)?this._updateAllTilesOnce(K.originalPixelData):
K.originalPixelData&&K.originalPixelData.src&&K.tiles.some(function(P){return P.updateCompleted})&&this._context.clear(this._context.COLOR_BUFFER_BIT),K.tiles.forEach(e.hitch(this,function(P){P.update&&!P.updateCompleted&&P.update.then(function(R){P.updateCompleted||(P.updateCompleted=!0);(this._hasTilingEffects||this.useWebGL)&&this._drawOneFrame(R)}.bind(this))}))):this._hasTilingEffects&&g(K.fetchAllCompleted.isResolved()||K.fetchAllCompleted,e.hitch(this,function(){this._updateAllTilesOnce(K.originalPixelData)})):
(this._frames=K.tiles.map(function(P){return{completed:!1,tileData:P}}),this._drawAllFrames()))}))}},_redrawTiles:function(){this._fetchTiles(this._map.extent,!0)},_panHandler:function(C,H){this._drawTile=!1;"css-transforms"===this._map.navigationMode?this.roaming&&this.tileMode&&this.useWebGL?(this._delta=H,!this._roamingAnimation&&this.tileMode&&(this._roamingAnimation=requestAnimationFrame(this._animatePan2d))):(this._left=this._map.__visibleDelta.x+H.x,this._top=this._map.__visibleDelta.y+H.y,
a.set(this._div,d._css.names.transform,d._css.translate(this._left,this._top))):a.set(this._div,{left:this._startRect.left+H.x+"px",top:this._startRect.top+H.y+"px"});this.tileMode&&this._fetchTiles(C)},_panEndHandler:function(C,H){H&&(this._startRect.left+=H.x,this._startRect.top+=H.y);this.oldData=null;this._roamingAnimation&&(cancelAnimationFrame(this._roamingAnimation),this._oldDelta=this._roamingAnimation=null)},_onScaleHandler:function(C,H){var K={},L=d._css.names;a.set(this._canvas,L.transition,
H?"none":L.transformName+" "+T+"ms ease");this._matrix=C;C=this._multiply?l.multiply(C,this._multiply):C;if(this._tdx||this._tdy)C=l.multiply(C,{xx:1,xy:0,yx:0,yy:1,dx:-this._tdx,dy:-this._tdy});K[L.transform]=d._css.matrix(C);a.set(this._canvas,K)},_onZoomHandler:function(C,H,K){var L=this._startRect;C=L.width*H;H*=L.height;var P=L.left-(C-L.width)*(K.x-L.left)/L.width;K=L.top-(H-L.height)*(K.y-L.top)/L.height;a.set(this._canvas,{left:P+"px",top:K+"px",width:C+"px",height:H+"px"});this._endRect=
{left:P,top:K,width:C,height:H}},_onZoomEndHandler:function(){this._endRect&&(this._startRect=this._endRect)},_onResizeHandler:function(C,H,K){a.set(this._div,{width:H+"px",height:K+"px"});a.set(this._canvas,{width:H+"px",height:K+"px"});this._startRect.width=this._canvas.width=H;this._startRect.height=this._canvas.height=K;this.useWebGL&&this._glSetting&&(this._glSetting.pingpong=null,this._glSetting.branches=null)},_extentChangeHandler:function(C,H,K,L){if(this.loaded&&!this.suspended&&(!H||0!==
H.x||0!==H.y||K)){this._drawTile=!0;"css-transforms"===this._map.navigationMode&&(H&&(this._dragOrigin.x+=H.x,this._dragOrigin.y+=H.y),this._left=this._map.__visibleDelta.x,this._top=this._map.__visibleDelta.y,this.roaming&&this.tileMode&&this.useWebGL||K||a.set(this._div,d._css.names.transform,d._css.translate(this._left,this._top)),K&&(a.set(this._canvas,d._css.names.transition,"none"),this._multiply=this._multiply?l.multiply(this._matrix,this._multiply):this._matrix,this._levelChange=!0));this._fireUpdateStart();
var P=this._map;H=this.raster.rasterFunction?this.raster.getMemberRasters().map(function(U){return U._rasterId}):[this.raster._rasterId];var R={};this.tileMode?((this.roaming||this.useWebGL)&&this.tileMode||(H.forEach(function(U,Y){R[U]={extent:P.extent,pixelBlock:new Q({width:P.width,height:P.height,pixels:[],pixelType:"",mask:null,statistics:[]})}}),this.tileManager.originalPixelData={extent:P.extent,src:R}),this.projectedFullExtent?this._fetchTiles(C,!0):this._getProjectedFullExtent(P.spatialReference).then(e.hitch(this,
function(){this._fetchTiles(C,!0)}))):this._requestData(P.extent,P.width,P.height)}},_visibilityChangeHandler:function(C){C?v.show(this._div):v.hide(this._div)},_opacityChangeHandler:function(C){a.set(this._div,"opacity",C)}});h("extend-esri")&&e.setObject("layers.RasterXLayer",G,d);return G})},"esri/layers/rasterLib/raster/rasterFactory":function(){define("require dojo/_base/declare dojo/_base/lang dojo/_base/Deferred dojo/_base/array dojo/_base/config dojo/sniff dojo/when ../../../kernel ../../../Evented ../../../request ../../../deferredUtils ../../../urlUtils ./ImageServiceRaster ./TileServiceRaster ./TileRaster ./FunctionRaster".split(" "),
function(G,e,t,n,p,h,c,a,b,l,g,f,d,k,m,v,q){G={customDrivers:[],create:function(r){if(r){if(r.url){var w=d.urlToObject(r.url);var u=w.path;var y=w.query}w=r.serviceInfo;var x=r.rasterFxArgs||{},z=new n,A=t.hitch(this,function(D){console.error(D);this._trycustomDrivers(t.mixin({url:u},r),0,z)});if(u)if(-1===u.toLowerCase().indexOf("imageserver")&&-1===u.toLowerCase().indexOf("mapserver")){var E=new v(t.mixin({},r,{url:u}));r.rasterFx&&(E=new q({rasterFx:r.rasterFx,rasterFxArgs:t.mixin({},x,{raster:E})}));
var F=E}else{F=new n;w=w||this._getServiceInfo(u,y);var B=t.hitch(this,function(D){D.bandCount?E=D.capabilities&&-1<D.capabilities.toLowerCase().indexOf("tileonly")?new m(t.mixin({},{serviceInfo:D},y,r,{url:u})):new k(t.mixin({},{serviceInfo:D},y,r,{url:u})):D.tileInfo&&(E=new m(t.mixin({},{serviceInfo:D},y,this._options,{url:u})));r.rasterFx&&(E=new q({rasterFx:r.rasterFx,rasterFxArgs:t.mixin({},x,{raster:E})}));F.resolve(E)});a(w,B,A)}else F=E=new q({rasterFx:r.rasterFx,rasterFxArgs:t.mixin({},
x,{raster:E})});a(F,t.hitch(this,function(D){D?D.open().then(t.hitch(this,function(I){z.resolve(D)}),A):A(Error("There is no raster to open"))}),A);return z.promise}},register:function(r){this.customDrivers=this.customDrivers||[];0<this.customDrivers.filter(function(w){return w.sourceType===r.prototype.sourceType}).length||this.customDrivers.push(r)},_trycustomDrivers:function(r,w,u){u=u||new n;var y=this.customDrivers[w];if(y){var x=new y(r);x.open().then(t.hitch(this,function(z){u.resolve(x)}),
t.hitch(this,function(z){this._trycustomDrivers(r,w+1,u)}))}else u.reject("cannot load layer "+(r&&r.url||""));return u.promise},_getServiceInfo:function(r,w){w=w||{};var u=w.bandIds;w=w.renderingRule;var y=new n(f._dfdCanceller),x={f:"json"};u&&(x.bandIds=u);w&&(x.renderingRule=w.toJson?JSON.stringify(w.toJson()):JSON.stringify(w));y._pendingDfd=g({url:r,content:x,handleAs:"json",callbackParamName:"callback"});y._pendingDfd.then(function(z){y.callback(z)},function(z){y.errback(z)});return y.promise}};
c("extend-esri")&&t.setObject("layers.rasterLib.raster.rasterFactory",G,b);return G})},"esri/layers/rasterLib/raster/ImageServiceRaster":function(){define("require dojo/_base/declare dojo/_base/lang dojo/_base/Deferred dojo/_base/array dojo/_base/config dojo/_base/json dojo/sniff dojo/DeferredList dojo/when ../../../kernel ../../../Evented ../../../request ../../../geometry/Extent ../../../geometry/Point ../../../SpatialReference ../../../WKIDUnitConversion ../../../deferredUtils ../../../urlUtils ../../MosaicRule ../../ImageServiceParameters ../../PixelBlock ./RasterInfo ./BasicRaster ../../rasterFormats/rasterCodec ../tile/RasterTileInfo".split(" "),
function(G,e,t,n,p,h,c,a,b,l,g,f,d,k,m,v,q,r,w,u,y,x,z,A,E,F){G=e([A],{declaredClass:"esri.layers.rasterLib.raster.ImageServiceRaster",sourceType:"ImageService",constructor:function(B){B&&(this._imageServiceParams=B.imageServiceParameters,this._commonReqParams=B._commonReqParams,this._imageServiceParams||(this._imageServiceParams={interpolation:B.interpolation,pixelType:B.pixelType,format:B.format||"lerc",compressionQuality:B.compressionQuality,bandIds:B.bandIds,noDataInterpretation:B.noDataInterpretation,
adjustAspectRatio:B.adjustAspectRatio,mosaicRule:B.mosaicRule,renderingRule:B.interpolation}))},open:function(){var B=new n;if(this.serviceInfo&&this.rasterInfo)return this.loaded=!0,this._findCredential(),this.setFetchParameters(this._imageServiceParams),B.resolve(this),B.promise;var D=this.serviceInfo||this._generateServiceInfo(this._imageServiceParams&&this._imageServiceParams.renderingRule),I=t.hitch(this,function(N){this._fixServiceInfo(N);this.serviceInfo=N;this._findCredential();var Q=this._parseRasterInfo(N),
V={};N.defaultMosaicMethod?(V.method=N.defaultMosaicMethod,V.operation=N.mosaicOperator,V.sortField=N.sortField,V.sortValue=N.sortValue):V.method=u.METHOD_NONE;this.serviceInfo.defaultMosaicRule=new u(V);this.serviceInfo.defaultMosaicRule.ascending=!0;N=this._getColormap(this);V=this._getHistograms(this);var X=this._getRasterAttributeTable(this),W=this._getKeyProperties(this),Z=this._getMultidimensionalInfo(),aa=this._getSlices();(new b([N,V,X,W,Z,aa])).then(t.hitch(this,function(J){J[0][0]&&(Q.colormap=
J[0][1]);J[1][0]&&(Q.histograms=J[1][1]);J[2][0]&&(Q.vat=J[2][1]);J[3][0]&&(Q.keyProperties=J[3][1]);J[4][0]&&(Q.multidimensionalInfo=J[4][1]);this._slices=J[5][0]?J[5][1]:null;Q.keyProperties&&Q.keyProperties.DataType&&(this.dataType=Q.keyProperties.DataType);this.loaded=!0;this.rasterInfo=Q;this.setFetchParameters(this._imageServiceParams);B.resolve(this)}))}),M=t.hitch(this,function(N){this.loaded=!0;B.reject(N)});l(D,I,M);return B.promise},setFetchParameters:function(B,D){if(D)this.imageServiceParams=
B;else{var I=this.imageServiceParams;I&&B?Object.keys(B).forEach(function(M){I[M]=B[M]}):this.imageServiceParams=B}this._constructGetImageParams();this._getRasterIdentifier(!0)},read:function(B){if(B.pixelBlock||B.texture){var D=new n;D.resolve(B);return D.promise}if(!1===B.virtual&&this.tileInfo&&!this.tileInfo.virtual)return this.readTile(B);if(this._slices){var I=this._getSliceId();if(null==I)return D=new n,D.resolve(B),D.promise}var M=B.extent,N=M.spatialReference.wkid||c.toJson(M.spatialReference.toJson(!1)),
Q=B.timeExtent?B.timeExtent.toJson().join(","):null;D=this.url+"/exportImage";var V={};this._slices&&(V.sliceid=I);this.disableClientCaching&&(V._ts=(new Date).getTime());I=t.mixin({},this._commonReqParams,{bbox:M.xmin+","+M.ymin+","+M.xmax+","+M.ymax,imageSR:N,bboxSR:N,size:B.width+","+B.height,time:Q},V);return this._requestPixels({url:D,payload:I,decodeParams:{width:B.width,height:B.height,planes:null,pixelType:null,format:null,decodeFunc:null,isPoint:!1},tileOptions:B})},readTile:function(B){var D=
this.tileBoundary&&this.tileBoundary[B.level];if(D&&(D.minRow>B.row||D.maxRow<B.row||D.minCol>B.col||D.maxCol<B.col)){var I=new n;I.resolve(B);return I.promise}if(this._slices&&(I=this._getSliceId(),null==I))return I=new n,I.resolve(B),I.promise;D=this.url+"/tile/"+B.level+"/"+B.row+"/"+B.col;var M={width:this.tileInfo.cols,height:this.tileInfo.rows,planes:null,pixelType:null,format:null,decodeFunc:null,isPoint:"elevation"===B.tileType.toLowerCase()?!0:!1};I=this._slices?"sliceid\x3d"+I+"\x26":"";
I=this.disableClientCaching?"_ts\x3d "+(new Date).getTime():I.replace(/&$/,"");return this._requestPixels({url:D+(0<I.length?"?"+I:""),payload:{},decodeParams:M,tileOptions:B})},toJson:function(){return{url:this.url,tileInfo:this.tileInfo,rasterInfo:this.rasterInfo,serviceInfo:this.serviceInfo,sourceType:this.sourceType,_commonReqParams:this._commonReqParams,_rasterId:this._rasterId}},_getSliceId:function(){var B=t.clone(this._imageServiceParams.multidimensionalDefinition),D=t.clone(this._imageServiceParams.time);
if(null==this._slices||null==D&&(null==B||0===B.length))return 0;var I=B||this.defaultMultidimensionalDefinition,M=I[0].variableName;I=this._getAllDimensionDefinition(I,M).definition;B=null;if(null==I||0===I.length)return null;if(D&&this.serviceInfo.timeInfo){if(null==D[1]||D[1]===D[0])var N=D[0];else{var Q=this.serviceInfo.timeInfo.startTimeField;N=this.rasterInfo.multidimensionalInfo.variables.find(function(W){return W.name===M}).dimensions.find(function(W){return W.name===Q}).values.filter(function(W){return Array.isArray(W)?
Math.max(W[0],D[0])<Math.min(W[1],D[1]):W>=D[0]&&W<=D[1]}).sort(function(W,Z){W=Array.isArray(W)?W[1]:W;Z=Array.isArray(Z)?W[1]:Z;return Math.abs(D[1]-W)-Math.abs(D[1]-Z)})[0]||[D[1]]}I.some(function(W){if(W.dimensionName===Q)return W.values[0]=N,!0;if(!W.dimensionName)return W.dimensionName=Q,W.isSlice=!0,W.values=[N],!0})||I.push({variableName:M,dimensionName:Q,isSlice:!0,values:[N]})}for(var V=0;V<this._slices.length;V++){var X=this._slices[V].multidimensionalDefinition;if(X.length===I.length&&
!X.some(function(W){var Z=I.filter(function(J){return W.variableName===J.variableName&&J.dimensionName===W.dimensionName})[0];if(!Z)return!0;var aa=Array.isArray(W.values[0])?W.values[0][0]:W.values[0];Z=Array.isArray(Z.values[0])?Z.values[0][0]:Z.values[0];return aa!==Z})){B=V;break}}return B},_getAllDimensionDefinition:function(B,D){var I=B.map(function(N){return N.dimensionName}),M=!1;this.rasterInfo.multidimensionalInfo.variables.forEach(function(N){N.name!==D||N.dimensions.length===B.length&&
I[0]||(N.dimensions.forEach(function(Q){0>I.indexOf(Q.name)&&(I[0]?B.push({variableName:D,dimensionName:Q.name,values:[Q.values[0]]}):(B[0].dimensionName=Q.name,B[0].values=[Q.values[0]],Q[0]=Q.name))}),M=!0)},this);return{defChanged:M,definition:B}},_generateServiceInfo:function(B){var D=this.url,I=new n(r._dfdCanceller);I._pendingDfd=d({url:D,content:{f:"json",renderingRule:B?c.toJson(B.toJson()):null},handleAs:"json",callbackParamName:"callback"});I._pendingDfd.then(function(M){I.callback(M)},
function(M){I.errback(M)});return I},_fixServiceInfo:function(B){var D=B.spatialReference.wkid;B.tileInfo&&0===B.extent.xmin&&360===B.extent.xmax&&D&&null==q[D]&&(B.tileInfo.applyGCS360Transform=!0)},_parseRasterInfo:function(B){var D=new z;D.bandCount=B.bandCount;D.extent=new k(B.fullExtent);D.spatialReference=B.spatialReference;D.pixelType=B.pixelType;D.width=Math.floor((B.fullExtent.xmax-B.fullExtent.xmin)/B.pixelSizeX+.5);D.height=Math.floor((B.fullExtent.ymax-B.fullExtent.ymin)/B.pixelSizeY+
.5);D.cellSize=new m({x:B.pixelSizeX,y:B.pixelSizeY,spatialReference:B.spatialReference});var I;if(B.minValues&&0<B.minValues.length&&B.maxValues&&B.stdvValues&&B.meanValues){var M=[];for(I=0;I<B.minValues.length;I++)M.push({min:B.minValues[I],max:B.maxValues[I],mean:B.meanValues[I],stddev:B.stdvValues[I]});B.bandCount!==M.length&&(M=null)}this.dataType=B.serviceDataType?B.serviceDataType.replace("esriImageServiceDataType",""):"Generic";D.statistics=M;B.objectIdField&&B.fields&&(D.catalogInfo={objectIdField:B.objectIdField,
fields:B.fields});D.timeInfo=B.timeInfo;if(B.tileInfo){this.tileInfo=new F(B.tileInfo);this.tileInfo.tileType=B.cacheType||"Map";D.tileInfo=this.tileInfo;var N=D.extent,Q=this.tileInfo.origin,V=this.tileInfo.cols,X=this.tileInfo.rows;this.tileBoundary=this.tileInfo.lods.map(function(W){return{minCol:Math.floor((N.xmin-Q.x+.1*W.resolution)/V/W.resolution),maxCol:Math.floor((N.xmax-Q.x-.1*W.resolution)/V/W.resolution),minRow:Math.floor((Q.y-N.ymax+.1*W.resolution)/X/W.resolution),maxRow:Math.floor((Q.y-
N.ymin-.1*W.resolution)/X/W.resolution)}})}return D},_getColormap:function(B){B=this.url+"/colormap";var D=new n(r._dfdCanceller),I={f:"json"},M=this.serviceInfo.hasColormap||this.rasterInfo&&this.rasterInfo.hasColormap;10<this.serviceInfo.currentVersion&&M?(D._pendingDfd=d({url:B,content:I,handleAs:"json",callbackParamName:"callback"}),D._pendingDfd.then(function(N){D.callback(N.colormap)},function(N){D.errback(N)})):D.callback(null);return D},_getHistograms:function(B){var D=this.url+"/histograms",
I=new n(r._dfdCanceller),M={f:"json"},N=this.serviceInfo.hasHistograms||this.rasterInfo&&this.rasterInfo.hasHistograms;B&&B.renderingRule&&(M.renderingRule=c.toJson(B.renderingRule.toJson()),N=!0);10<this.serviceInfo.currentVersion&&N?(I._pendingDfd=d({url:D,content:M,handleAs:"json",callbackParamName:"callback"}),I._pendingDfd.then(function(Q){I.callback(Q.histograms)},function(Q){I.errback(Q)})):I.callback(null);return I},_getRasterAttributeTable:function(B){var D=this.url+"/rasterAttributeTable",
I=new n(r._dfdCanceller),M={f:"json"},N=this.serviceInfo.hasRasterAttributeTable;B&&B.renderingRule&&(M.renderingRule=c.toJson(B.renderingRule.toJson()),N=!0);10<this.serviceInfo.currentVersion&&N?(I._pendingDfd=d({url:D,content:M,handleAs:"json",callbackParamName:"callback"}),I._pendingDfd.then(function(Q){I.callback(Q)},function(Q){I.errback(Q)})):I.callback(null);return I},_getKeyProperties:function(B){var D=this.url+"/keyProperties",I=new n(r._dfdCanceller),M={f:"json"};B&&B.renderingRule&&(M.renderingRule=
c.toJson(B.renderingRule.toJson()));10<this.serviceInfo.currentVersion?(I._pendingDfd=d({url:D,content:M,handleAs:"json",callbackParamName:"callback"}),I._pendingDfd.then(function(N){I.callback(N)},function(N){I.errback(N)})):I.callback(null);return I},_getMultidimensionalInfo:function(){var B=this.url+"/multidimensionalInfo",D=new n(r._dfdCanceller);10.3<=this.serviceInfo.currentVersion&&this.serviceInfo.hasMultidimensions?(D._pendingDfd=d({url:B,content:{f:"json"},handleAs:"json",callbackParamName:"callback"}),
D._pendingDfd.then(t.hitch(this,function(I){D.callback(I.multidimensionalInfo)}),function(I){D.errback(I)})):D.callback(null);return D},_getSlices:function(){var B=this.url+"/slices",D=new n(r._dfdCanceller);this.serviceInfo.hasMultidimensions?(D._pendingDfd=d({url:B,content:{f:"json"},handleAs:"json",callbackParamName:"callback"}),D._pendingDfd.then(t.hitch(this,function(I){D.callback(I.slices)}),function(I){D.errback(I)})):D.callback(null);return D},_initializationFailed:function(){},_constructGetImageParams:function(){var B=
this.imageServiceParams||{},D=t.mixin({},this._query,{f:"image",interpolation:B.interpolation,pixelType:B.pixelType,format:B.format||"lerc",compressionQuality:B.compressionQuality,bandIds:B.bandIds?B.bandIds.join(","):null,noData:null!=B.noData?B.noData.join(","):null,noDataInterpretation:B.noDataInterpretation,adjustAspectRatio:null==B.adjustAspectRatio?null:B.adjustAspectRatio,mosaicRule:B.mosaicRule?c.toJson(B.mosaicRule.toJson()):null,renderingRule:B.renderingRule?c.toJson(B.renderingRule.toJson()):
null,token:this.credential&&this.credential.token||null});"lerc"===D.format.toLowerCase()?(D.compressionTolerance=B.compressionTolerance,10.5<=this.serviceInfo.currentVersion&&(D.lercVersion=B.lercVersion||2)):"tiff"===D.format.toLowerCase()?D.compression=B.compression:-1<["jpg","jpeg","jpg","jpgpng"].indexOf(D.format.toLowerCase())&&(D.compression=B.compression);this._commonReqParams=D},_getRasterIdentifier:function(B){if(this._rasterId)return this._rasterId;B=this.url.replace("http:","").replace("https:",
"");var D=[],I=this.imageServiceParams||{};D.push(B);D.push(I.interpolation);D.push(I.pixelType);D.push(I.compressionQuality);D.push(I.bandIds?I.bandIds.join(","):"");D.push(I.mosaicRule?c.toJson(I.mosaicRule.toJson()):"");D.push(I.renderingRule?c.toJson(I.renderingRule.toJson()):"");B=D.join("|");return this._rasterId=this._computeSignature(B)},_wrapExtent:function(B){var D=B.spatialReference._getInfo();if(D){var I=D.valid[0];D=D.valid[1];if(B.xmin<I-this.resolution.x||B.xmax>D+this.resolution.y){var M=
new k((B.xmin-I)%(D-I),B.ymin,(B.xmax-D)%(D-I),B.ymax,B.spatialReference);M.xmax<M.xmin&&(M=null)}}return M||B}});a("extend-esri")&&t.setObject("layers.rasterLib.raster.ImageServiceRaster",G,g);return G})},"esri/layers/rasterLib/raster/RasterInfo":function(){define(["dojo/_base/declare","dojo/_base/lang","../../../geometry/Extent","../../../SpatialReference","../tile/RasterTileInfo"],function(G,e,t,n,p){return G(null,{declaredClass:"esri.layers.rasterLib.raster.RasterInfo",bandCount:null,pixelType:null,
extent:null,spatialReference:null,width:null,height:null,colormap:null,attributeTable:null,multiDimensionalInfo:null,statistics:null,histograms:null,catalogInfo:null,keyProperties:null,cellSize:null,format:null,compression:null,compressionQuality:null,packetSize:null,geodataXform:null,constructor:function(h){e.mixin(this,h);this.extent=this.extent?this.extent.toJson?this.extent:new t(this.extent):null;this.spatialReference=this.spatialReference?this.spatialReference.toJson?this.spatialReference:new n(this.spatialReference):
null;this.tileInfo=this.tileInfo?this.tileInfo.toJson?this.tileInfo:new p(this.tileInfo):null},toJson:function(){return{bandCount:this.bandCount,pixelType:this.pixelType,extent:this.extent&&this.extent.toJson?this.extent.toJson():this.extent,spatialReference:this.spatialReference&&this.spatialReference.toJson?this.spatialReference.toJson():this.spatialReference,width:this.width,height:this.height,colormap:this.colormap?e.clone(this.colormap):null,attributeTable:this.attributeTable?e.clone(this.attributeTable):
null,multiDimensionalInfo:this.multiDimensionalInfo?e.clone(this.multiDimensionalInfo):null,statistics:this.statistics?e.clone(this.statistics):null,histograms:this.histograms?e.clone(this.histograms):null,catalogInfo:this.catalogInfo?e.clone(this.catalogInfo):null,keyProperties:this.keyProperties?e.clone(this.keyProperties):null,cellSize:this.cellSize&&this.cellSize.toJson?this.cellSize.toJson():this.cellSize,tileInfo:this.tileInfo&&this.tileInfo.toJson?this.tileInfo.toJson():this.tileInfo,format:this.format,
compression:this.compression,compressionQuality:this.compressionQuality,packetSize:this.packetSize,geodataXform:this.geodataXform?e.clone(this.geodataXform):null}},clone:function(){return new this.constructor(this.toJson())}})})},"esri/layers/rasterLib/tile/RasterTileInfo":function(){define("dojo/_base/declare dojo/_base/lang ../../../geometry/Extent ../../../SpatialReference ../../../geometry/Point ../../../lang ../../TileInfo".split(" "),function(G,e,t,n,p,h,c){return G([c],{declaredClass:"esri.layers.rasterLib.tile.RasterTileInfo",
rows:512,cols:512,compressionQuality:95,lercError:.01,spatialReference:null,origin:null,virtual:!0,tileType:"Raster",constructor:function(a,b){if(a||b){var l=b&&b.refTileInfo;a?this.virtual=!1:(this.virtual=!0,e.mixin(this,{rows:b.rows||this.rows,cols:b.cols||this.cols,compressionQuality:b.compressionQuality||95,lercError:b.compressionTolerance||.01,spatialReference:b.spatialReference,origin:b.origin}),this.width=this.cols,this.height=this.rows,this.origin||(l?this.origin=l.origin:b.spatialReference.isWebMercator()||
b.extent&&360<=Math.max(Math.abs(b.extent.xmin),Math.abs(b.extent.xmax))?this.origin={x:-2.0037508342787E7,y:2.0037508342787E7}:-1<[4326,4269].indexOf(b.spatialReference.wkid)||360>Math.max(Math.abs(b.extent.xmin),Math.abs(b.extent.xmax))?this.origin={x:-180,y:90}:this.origin={x:b.extent.xmin,y:b.extent.ymax}))}},toJson:function(){var a=c.prototype.toJson.apply(this);a.tileType=this.tileType;a.virtual=this.virtual;a.lercError=this.lercError;return a},clone:function(){return new this.prototype(this.toJson())}})})},
"esri/layers/rasterLib/raster/BasicRaster":function(){define("require dojo/_base/declare dojo/_base/lang dojo/_base/Deferred dojo/_base/array dojo/_base/config dojo/_base/json dojo/sniff dojo/DeferredList dojo/when ../../../kernel ../../../Evented ../../../request ../../../geometry/Extent ../../../geometry/Point ../../../SpatialReference ../../../deferredUtils ../../../urlUtils ../../MosaicRule ../../ImageServiceParameters ../../PixelBlock ../../rasterFormats/rasterCodec ../tile/RasterHandler ./rasterProjectionHelper ./RasterInfo".split(" "),
function(G,e,t,n,p,h,c,a,b,l,g,f,d,k,m,v,q,r,w,u,y,x,z,A,E){return e([f],{url:null,dataType:null,rasterInfo:null,tileInfo:null,serviceInfo:null,loaded:null,constructor:function(F){if(F){var B=F.url;B&&(B=r.urlToObject(B),this.url=B.path,this._query=B.query);this.dataType=F.dataType;this.serviceInfo=F.serviceInfo;this.rasterInfo=F.rasterInfo;this.tileInfo=F.tileInfo;this.serviceInfo=F.serviceInfo}},open:function(){},read:function(F){},identify:function(F){var B=new n,D=this.rasterInfo.extent;if(A.requirePE(D.spatialReference,
F.spatialReference))A.load().then(t.hitch(this,function(){I=A.project(F,D.spatialReference);B.resolve(I)}),function(){B.reject(Error("cannot project into this spatial reference"))});else{var I=A.project(F,D.spatialReference);B.resolve(I)}return B.then(t.hitch(this,function(M){var N=this.tileInfo,Q=N.origin,V=N.lods[N.lods.length-1],X=(M.x-Q.x)/N.cols/V.resolution;M=(Q.y-M.y)/N.rows/V.resolution;var W=Math.round((M-Math.floor(M))*N.rows)*N.cols+Math.round((X-Math.floor(X))*N.cols);Q=new k(Q.x+V.resolution*
N.cols*X,Q.y-V.resolution*N.rows*(M+1),Q.x+V.resolution*N.cols*(X+1),Q.y-V.resolution*N.rows*M,D.spatialReference);var Z=this.getMemberRasters?this.getMemberRasters()[0]:this;return Z.read({level:V.level,row:Math.floor(M),col:Math.floor(X),extent:Q,width:N.cols,height:N.rows,virtual:Z.tileInfo.virtual,tileType:Z.tileInfo.tileType}).then(function(aa){return(aa=aa&&aa.pixelBlock)&&aa.pixels&&0<aa.pixels.length&&(!aa.mask||aa.mask[W])?{pixelValue:aa.pixels.map(function(J){return J[W]})}:{pixelValue:null}})}))},
getProjectedFullExtent:function(F,B){var D=new n;if(this.projectedFullExtent&&!B)return D.resolve(this.projectedFullExtent),D.promise;var I=this.rasterInfo.extent;if(A.requirePE(this.rasterInfo.extent.spatialReference,F))A.load().then(t.hitch(this,function(){M=A.project(I,F);this.projectedFullExtent=M=new k(M.toJson());D.resolve(M)}),function(){D.reject(Error("cannot project into this spatial reference"))});else{var M=A.project(I,F);this.projectedFullExtent=M=new k(M.toJson());D.resolve(M)}return D.promise},
setFetchParameters:function(F,B){},_setRasterHandler:function(F){this._rasterHandler=F;this.getMemberRasters&&this.getMemberRasters().forEach(t.hitch(this,function(B){B._rasterHandler=F}))},_findCredential:function(){this.url&&((this._credential=g.id&&g.id.findCredential(this.url))&&this._credential.ssl||this.serviceInfo&&this.serviceInfo._ssl)&&(this.url=this.url.replace(/^http:/i,"https:"))},_initWorker:function(){this._rasterHandler=new z;this._rasterHandler.start().then(function(){this._rasterHandlerInitialized=
!0}.bind(this))},_requestPixels:function(F){var B=F.url,D=F.payload,I=F.decodeParams,M=F.tileOptions,N=new n(q._dfdCanceller);this._rasterHandler||this._initWorker();var Q=this._rasterHandler,V={};B={url:B,handleAs:"arraybuffer",content:D};F.headers&&(B.headers=F.headers);N._pendingDfd=d(B).then(t.hitch(this,function(X){(Q&&this._rasterHandlerInitialized?Q.decode({encodedData:X,decodeParams:I}):x.decode(X,I)).then(function(W){V.pixelBlock=new y(W);V.extent=M.extent;V.level=M.level;V.row=M.row;V.col=
M.col;V.width=M.width;V.height=M.height;q._resDfd(N,[V])},function(W){q._resDfd(N,[W],!0)})}),function(X){q._resDfd(N,[X],!0)});return N},_computeSignature:function(F){if("string"===typeof F){for(var B=new Uint8Array(F.length),D=0;D<F.length;D++)B[D]=F.charCodeAt(D);F=B}D=B=65535;for(var I=F.length,M=Math.floor(I/2),N=0;M;){var Q=359<=M?359:M;M-=Q;do B+=F[N++]<<8,D+=B+=F[N++];while(--Q);B=(B&65535)+(B>>>16);D=(D&65535)+(D>>>16)}I&1&&(D+=B+=F[N]<<8);return((D&65535)+(D>>>16)<<16|(B&65535)+(B>>>16))>>>
0}})})},"esri/layers/rasterFormats/rasterCodec":function(){define("require dojo/_base/declare dojo/_base/lang dojo/_base/Deferred ../PixelBlock ./LercCodec ./Lerc2Codec ./JpgPlus ./Png ./Raw ./TiffDecoder".split(" "),function(G,e,t,n,p,h,c,a,b,l,g){return{validPixelTypes:"U1 U2 U4 U8 U16 U32 S8 S16 S32 F32".split(" "),supportedFormats:"lerc jpeg jpg jpgpng png png8 png24 png32 bip bsq tiff".split(" "),_isPlatformLittleEndian:function(){var f=new ArrayBuffer(4),d=new Uint8Array(f);(new Uint32Array(f))[0]=
1;return 1===d[0]}(),decode:function(f,d){if(void 0===d||null===d)throw"missing decode options";var k;d.format&&(k=d.format.toUpperCase());"BSQ"!==k&&"BIP"!==k&&(k=this._getFormat(f));var m=d.decodeFunc;if(void 0===m||null===m)m=this._getFormatDecoderDfd(k);return m(f,d)},_getFormatDecoderDfd:function(f){var d=null;switch(f){case "LERC":d=this._decodeLerc;break;case "LERC2":d=this._decodeLerc2;break;case "JPEG":d=this._decodeJpeg;break;case "PNG":d=this._decodePng;break;case "BSQ":d=this._decodeBsq;
break;case "BIP":d=this._decodeBip;break;case "TIFF":d=this._decodeTiff;break;default:d=function(k,m){throw"The raster format is not supported";}}d=t.hitch(this,d);return function(k,m){var v=new n;m.isPoint&&m.width&&(m.width++,m.height++);k=d(k,m);m.isPoint&&m.width&&(this._interpolatePointGrid(k),m.width--,m.height--);v.resolve(k);return v}.bind(this)},_getFormat:function(f){f=new Uint8Array(f,0,10);var d="";if(255===f[0]&&216===f[1])d="JPEG";else if(137===f[0]&&80===f[1]&&78===f[2]&&71===f[3])d=
"PNG";else if(67===f[0]&&110===f[1]&&116===f[2]&&90===f[3]&&73===f[4]&&109===f[5]&&97===f[6]&&103===f[7]&&101===f[8]&&32===f[9])d="LERC";else if(76===f[0]&&101===f[1]&&114===f[2]&&99===f[3]&&50===f[4]&&32===f[5])d="LERC2";else if(-1<String.fromCharCode.apply(null,f).toLowerCase().indexOf("error"))d="ERROR";else if(73===f[0]&&73===f[1]&&42===f[2]&&0===f[3]||77===f[0]&&77===f[1]&&0===f[2]&&42===f[3])d="TIFF";return d},_validateDecodeParams:function(f){if(!f.height||Math.floor(f.height)!==f.height)throw"Height not provided.";
if(!f.width||Math.floor(f.width)!==f.width)throw"Width not provided.";},_decodeJpeg:function(f,d){if(!a)throw"The jpeg decoder module is not loaded.";this._validateDecodeParams(d);f=(new a).decode(f);if(!this._verifyResult(f,d))throw"The decoded image dimensions are incorrect.";d=new p({width:f.width,height:f.height,pixels:f.pixels,pixelType:"U8",mask:f.mask,statistics:null});d.calculateStatistics();return d},_decodePng:function(f,d){if(!b)throw"The png decoder module is not loaded.";this._validateDecodeParams(d);
f=new Uint8Array(f);var k=new b(f);f=new Uint8Array(d.width*d.height*4);k.copyToImageData(f,k.decodePixels());var m=k=0;m=new Uint8Array(d.width*d.height);for(k=0;k<d.width*d.height;k++)m[k]=f[4*k+3];var v=new p({width:d.width,height:d.height,pixels:[],pixelType:"U8",mask:m,statistics:[]});for(k=0;3>k;k++){var q=new Uint8Array(d.width*d.height);for(m=0;m<d.width*d.height;m++)q[m]=f[4*m+k];v.addData({pixels:q})}v.calculateStatistics();return v},_decodeBsq:function(f,d){if(!l)throw"The bsq decoder module is not loaded.";
this._validateDecodeParams(d);var k=d.noDataValue;d.pixelType=this._getpixelTypeAndNoData(d.pixelType);f=l.decodeBSQ(f,{bandCount:d.planes,width:d.width,height:d.height,pixelType:d.pixelType,noDataValue:k});d=new p({width:d.width,height:d.height,pixels:f.pixels,pixelType:d.pixelType,mask:f.maskData,statistics:null});d.calculateStatistics();return d},_decodeBip:function(f,d){this._validateDecodeParams(d);var k=d.noDataValue;d.pixelType=this._getpixelTypeAndNoData(d.pixelType);f=l.decodeBIP(f,{bandCount:d.planes,
width:d.width,height:d.height,pixelType:d.pixelType,noDataValue:k});d=new p({width:d.width,height:d.height,pixels:f.pixels,pixelType:d.pixelType,mask:f.maskData,statistics:null});d.calculateStatistics();return d},_decodeTiff:function(f,d){this._validateDecodeParams(d);d.pixelType=this._getpixelTypeAndNoData(d.pixelType);f=g.decode(f);f=new p({width:f.width,height:f.height,pixels:f.pixels,pixelType:f.pixelType,mask:f.maskData,statistics:null});f.calculateStatistics();return f},_decodeLerc:function(f,
d){if(!this._isPlatformLittleEndian)throw"lerc decoder is not supported on big endian platform";this._validateDecodeParams(d);var k=d.noDataValue;d.pixelType=this._getpixelTypeAndNoData(d.pixelType);for(var m=0,v,q=0,r,w=f.byteLength-10;q<w;){var u=h.decode(f,{inputOffset:q,encodedMaskData:v,returnMask:0===m?!0:!1,returnEncodedMask:0===m?!0:!1,returnFileInfo:!0,pixelType:d.pixelType,noDataValue:k});q=u.fileInfo.eofOffset;0===m&&(v=u.encodedMaskData,r=new p({width:d.width,height:d.height,pixels:[],
pixelType:d.pixelType,mask:u.maskData,statistics:[]}));m++;if(!this._verifyResult(u,d))throw"The decoded image dimensions are incorrect";r.addData({pixels:u.pixelData,statistics:{minValue:u.minValue,maxValue:u.maxValue,noDataValue:u.noDataValue}})}return r},_decodeLerc2:function(f,d){if(!this._isPlatformLittleEndian)throw"lerc2 decoder is not supported on big endian platform";this._validateDecodeParams(d);d.pixelType=this._getpixelTypeAndNoData(d.pixelType);for(var k=0,m,v,q,r=0,w,u=f.byteLength-
10,y=[],x,z=0;r<u;){v=c.decode(f,{inputOffset:r,maskData:m,returnFileInfo:!0});r=v.fileInfo.eofOffset;m=v.maskData;0===k&&(q=v.fileInfo.numValidPixel,w=new p({width:d.width,height:d.height,pixels:[],dimCount:v.dimCount||1,pixelType:v.fileInfo.pixelType,mask:m,statistics:[]}));v.fileInfo.mask&&0<v.fileInfo.mask.numBytes&&z++;m&&y.push(m);k++;if(!this._verifyResult(v,d))throw"The decoded image dimensions are incorrect";w.addData({pixels:v.pixelData,statistics:{minValue:v.minValue,maxValue:v.maxValue,
noDataValue:v.noDataValue,dimStats:v.dimStats}})}if(1<z){d=w.width*w.height;w.bandMasks=y;m=new Uint8Array(d);m.set(y[0]);for(q=1;q<y.length;q++)for(x=y[q],f=0;f<d;f++)m[f]&=x[f];for(f=q=0;f<d;f++)q+=x[f];w.mask=m}w.validPixelCount=q;return w},_interpolatePointGrid:function(f,d){var k=f.pixels;if(k&&0!==k.length){var m=k.length,v=f.width,q=f.mask,r=v-1,w=f.height-1,u=[],y,x;if(0===(null==d?1:d)){for(d=0;d<m;d++){var z=k[d];var A=new z.constructor(r*w);for(y=0;y<w;y++){var E=y*v;for(x=0;x<r;x++)A[y*
r+x]=z[E+x]}u.push(A)}if(q){var F=new Uint8Array(r*w);for(y=0;y<w;y++)for(E=y*v,x=0;x<r;x++)F[y*r+x]=q[E+x]}}else{for(d=0;d<m;d++){z=k[d];A=new z.constructor(r*w);for(y=0;y<w;y++)for(E=y*v,x=0;x<r;x++)A[y*r+x]=(z[E+x]+z[E+x+1]+z[E+v+x]+z[E+v+x+1])/4;u.push(A)}if(q)for(F=new Uint8Array(r*w),y=0;y<w;y++)for(E=y*v,x=0;x<r;x++)F[y*r+x]=Math.min.apply(null,[q[E+x],q[E+x+1],q[E+v+x],q[E+v+x+1]])}f.width=r;f.height=w;f.mask=F;f.pixels=u;return f}},_getpixelTypeAndNoData:function(f){return"U1"===f||"U2"===
f||"U4"===f||"U8"===f?"U8":f},_verifyResult:function(f,d){return f.height!==d.height||f.width!==d.width?!1:!0}}})},"esri/layers/rasterFormats/JpgPlus":function(){define(["dojo/_base/declare","./Zlib","./Jpg"],function(G,e,t){return G(null,{constructor:function(){},decode:function(n){var p=new Uint8Array(n);n=new t;n.parse(p);var h=n.numComponents,c=n.getData(n.width,n.height,!0),a=n.width*n.height,b=n.eof,l=0,g=0,f=0;if(b<p.length-1){g=(new e(p.subarray(b))).getBytes();var d=new Uint8Array(a);for(l=
p=0;l<g.length;l++)for(f=7;0<=f;f--)d[p++]=g[l]>>f&1}p=[];if(1===h)p=[c,c,c];else{for(l=0;3>l;l++)h=new Uint8Array(a),p.push(h);for(g=f=0;g<a;g++)for(l=0;3>l;l++)p[l][g]=c[f++]}return{width:n.width,height:n.height,pixels:p,mask:d}}})})},"esri/layers/rasterFormats/Zlib":function(){define([],function(){var G=function(){function e(){this.bufferLength=this.pos=0;this.eof=!1;this.buffer=null}e.prototype={ensureBuffer:function(t){var n=this.buffer,p=n?n.byteLength:0;if(t<p)return n;for(var h=512;h<t;)h<<=
1;t=new Uint8Array(h);for(h=0;h<p;++h)t[h]=n[h];return this.buffer=t},getByte:function(){for(var t=this.pos;this.bufferLength<=t;){if(this.eof)return null;this.readBlock()}return this.buffer[this.pos++]},getBytes:function(t){var n=this.pos;if(t){this.ensureBuffer(n+t);for(t=n+t;!this.eof&&this.bufferLength<t;)this.readBlock();var p=this.bufferLength;t>p&&(t=p)}else{for(;!this.eof;)this.readBlock();t=this.bufferLength}this.pos=t;return this.buffer.subarray(n,t)},lookChar:function(){for(var t=this.pos;this.bufferLength<=
t;){if(this.eof)return null;this.readBlock()}return String.fromCharCode(this.buffer[this.pos])},getChar:function(){for(var t=this.pos;this.bufferLength<=t;){if(this.eof)return null;this.readBlock()}return String.fromCharCode(this.buffer[this.pos++])},makeSubStream:function(t,n,p){for(var h=t+n;this.bufferLength<=h&&!this.eof;)this.readBlock();return new Stream(this.buffer,t,n,p)},skip:function(t){t||(t=1);this.pos+=t},reset:function(){this.pos=0}};return e}();return function(){function e(b){throw Error(b);
}function t(b){var l=0,g=b[l++],f=b[l++];-1!=g&&-1!=f||e("Invalid header in flate stream");8!=(g&15)&&e("Unknown compression method in flate stream");0!=((g<<8)+f)%31&&e("Bad FCHECK in flate stream");f&32&&e("FDICT bit set in flate stream");this.bytes=b;this.bytesPos=l;this.codeBuf=this.codeSize=0;G.call(this)}if(!self||!self.Uint32Array)return null;var n=new Uint32Array([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),p=new Uint32Array([3,4,5,6,7,8,9,10,65547,65549,65551,65553,131091,131095,131099,
131103,196643,196651,196659,196667,262211,262227,262243,262259,327811,327843,327875,327907,258,258,258]),h=new Uint32Array([1,2,3,4,65541,65543,131081,131085,196625,196633,262177,262193,327745,327777,393345,393409,459009,459137,524801,525057,590849,591361,657409,658433,724993,727041,794625,798721,868353,876545]),c=[new Uint32Array([459008,524368,524304,524568,459024,524400,524336,590016,459016,524384,524320,589984,524288,524416,524352,590048,459012,524376,524312,589968,459028,524408,524344,590032,
459020,524392,524328,59E4,524296,524424,524360,590064,459010,524372,524308,524572,459026,524404,524340,590024,459018,524388,524324,589992,524292,524420,524356,590056,459014,524380,524316,589976,459030,524412,524348,590040,459022,524396,524332,590008,524300,524428,524364,590072,459009,524370,524306,524570,459025,524402,524338,590020,459017,524386,524322,589988,524290,524418,524354,590052,459013,524378,524314,589972,459029,524410,524346,590036,459021,524394,524330,590004,524298,524426,524362,590068,
459011,524374,524310,524574,459027,524406,524342,590028,459019,524390,524326,589996,524294,524422,524358,590060,459015,524382,524318,589980,459031,524414,524350,590044,459023,524398,524334,590012,524302,524430,524366,590076,459008,524369,524305,524569,459024,524401,524337,590018,459016,524385,524321,589986,524289,524417,524353,590050,459012,524377,524313,589970,459028,524409,524345,590034,459020,524393,524329,590002,524297,524425,524361,590066,459010,524373,524309,524573,459026,524405,524341,590026,
459018,524389,524325,589994,524293,524421,524357,590058,459014,524381,524317,589978,459030,524413,524349,590042,459022,524397,524333,590010,524301,524429,524365,590074,459009,524371,524307,524571,459025,524403,524339,590022,459017,524387,524323,589990,524291,524419,524355,590054,459013,524379,524315,589974,459029,524411,524347,590038,459021,524395,524331,590006,524299,524427,524363,590070,459011,524375,524311,524575,459027,524407,524343,590030,459019,524391,524327,589998,524295,524423,524359,590062,
459015,524383,524319,589982,459031,524415,524351,590046,459023,524399,524335,590014,524303,524431,524367,590078,459008,524368,524304,524568,459024,524400,524336,590017,459016,524384,524320,589985,524288,524416,524352,590049,459012,524376,524312,589969,459028,524408,524344,590033,459020,524392,524328,590001,524296,524424,524360,590065,459010,524372,524308,524572,459026,524404,524340,590025,459018,524388,524324,589993,524292,524420,524356,590057,459014,524380,524316,589977,459030,524412,524348,590041,
459022,524396,524332,590009,524300,524428,524364,590073,459009,524370,524306,524570,459025,524402,524338,590021,459017,524386,524322,589989,524290,524418,524354,590053,459013,524378,524314,589973,459029,524410,524346,590037,459021,524394,524330,590005,524298,524426,524362,590069,459011,524374,524310,524574,459027,524406,524342,590029,459019,524390,524326,589997,524294,524422,524358,590061,459015,524382,524318,589981,459031,524414,524350,590045,459023,524398,524334,590013,524302,524430,524366,590077,
459008,524369,524305,524569,459024,524401,524337,590019,459016,524385,524321,589987,524289,524417,524353,590051,459012,524377,524313,589971,459028,524409,524345,590035,459020,524393,524329,590003,524297,524425,524361,590067,459010,524373,524309,524573,459026,524405,524341,590027,459018,524389,524325,589995,524293,524421,524357,590059,459014,524381,524317,589979,459030,524413,524349,590043,459022,524397,524333,590011,524301,524429,524365,590075,459009,524371,524307,524571,459025,524403,524339,590023,
459017,524387,524323,589991,524291,524419,524355,590055,459013,524379,524315,589975,459029,524411,524347,590039,459021,524395,524331,590007,524299,524427,524363,590071,459011,524375,524311,524575,459027,524407,524343,590031,459019,524391,524327,589999,524295,524423,524359,590063,459015,524383,524319,589983,459031,524415,524351,590047,459023,524399,524335,590015,524303,524431,524367,590079]),9],a=[new Uint32Array([327680,327696,327688,327704,327684,327700,327692,327708,327682,327698,327690,327706,
327686,327702,327694,0,327681,327697,327689,327705,327685,327701,327693,327709,327683,327699,327691,327707,327687,327703,327695,0]),5];t.prototype=Object.create(G.prototype);t.prototype.getBits=function(b){for(var l=this.codeSize,g=this.codeBuf,f=this.bytes,d=this.bytesPos,k;l<b;)"undefined"==typeof(k=f[d++])&&e("Bad encoding in flate stream"),g|=k<<l,l+=8;this.codeBuf=g>>b;this.codeSize=l-=b;this.bytesPos=d;return g&(1<<b)-1};t.prototype.getCode=function(b){var l=b[0],g=b[1];b=this.codeSize;for(var f=
this.codeBuf,d=this.bytes,k=this.bytesPos;b<g;){var m;"undefined"==typeof(m=d[k++])&&e("Bad encoding in flate stream");f|=m<<b;b+=8}g=l[f&(1<<g)-1];l=g>>16;g&=65535;(0==b||b<l||0==l)&&e("Bad encoding in flate stream");this.codeBuf=f>>l;this.codeSize=b-l;this.bytesPos=k;return g};t.prototype.generateHuffmanTable=function(b){for(var l=b.length,g=0,f=0;f<l;++f)b[f]>g&&(g=b[f]);for(var d=1<<g,k=new Uint32Array(d),m=1,v=0,q=2;m<=g;++m,v<<=1,q<<=1)for(var r=0;r<l;++r)if(b[r]==m){var w=0,u=v;for(f=0;f<m;++f)w=
w<<1|u&1,u>>=1;for(f=w;f<d;f+=q)k[f]=m<<16|r;++v}return[k,g]};t.prototype.readBlock=function(){function b(w,u,y,x,z){for(w=w.getBits(y)+x;0<w--;)u[v++]=z}var l=this.getBits(3);l&1&&(this.eof=!0);l>>=1;if(0==l){var g=this.bytes,f=this.bytesPos,d;"undefined"==typeof(d=g[f++])&&e("Bad block header in flate stream");var k=d;"undefined"==typeof(d=g[f++])&&e("Bad block header in flate stream");k|=d<<8;"undefined"==typeof(d=g[f++])&&e("Bad block header in flate stream");l=d;"undefined"==typeof(d=g[f++])&&
e("Bad block header in flate stream");(l|d<<8)!=(~k&65535)&&e("Bad uncompressed block length in flate stream");this.codeSize=this.codeBuf=0;d=this.bufferLength;l=this.ensureBuffer(d+k);this.bufferLength=k=d+k;for(var m=d;m<k;++m){if("undefined"==typeof(d=g[f++])){this.eof=!0;break}l[m]=d}this.bytesPos=f}else{if(1==l)f=c,d=a;else if(2==l){l=this.getBits(5)+257;d=this.getBits(5)+1;g=this.getBits(4)+4;f=Array(n.length);for(var v=0;v<g;)f[n[v++]]=this.getBits(3);f=this.generateHuffmanTable(f);v=g=0;d=
l+d;for(k=Array(d);v<d;)m=this.getCode(f),16==m?b(this,k,2,3,g):17==m?b(this,k,3,3,g=0):18==m?b(this,k,7,11,g=0):k[v++]=g=m;f=this.generateHuffmanTable(k.slice(0,l));d=this.generateHuffmanTable(k.slice(l,d))}else e("Unknown block type in flate stream");k=(l=this.buffer)?l.length:0;for(m=this.bufferLength;;){var q=this.getCode(f);if(256>q)m+1>=k&&(l=this.ensureBuffer(m+1),k=l.length),l[m++]=q;else{if(256==q){this.bufferLength=m;break}q-=257;q=p[q];var r=q>>16;0<r&&(r=this.getBits(r));g=(q&65535)+r;
q=this.getCode(d);q=h[q];r=q>>16;0<r&&(r=this.getBits(r));q=(q&65535)+r;m+g>=k&&(l=this.ensureBuffer(m+g),k=l.length);for(r=0;r<g;++r,++m)l[m]=l[m-q]}}}};return t}()})},"esri/layers/rasterFormats/Jpg":function(){define([],function(){var G=function(){function e(t){this.message="JPEG error: "+t}e.prototype=Error();e.prototype.name="JpegError";return e.constructor=e}();return function(){function e(){this.decodeTransform=null;this.colorTransform=-1}function t(a,b){for(var l=0,g=[],f,d,k=16;0<k&&!a[k-
1];)k--;g.push({children:[],index:0});var m=g[0],v;for(f=0;f<k;f++){for(d=0;d<a[f];d++){m=g.pop();for(m.children[m.index]=b[l];0<m.index;)m=g.pop();m.index++;for(g.push(m);g.length<=f;)g.push(v={children:[],index:0}),m.children[m.index]=v.children,m=v;l++}f+1<k&&(g.push(v={children:[],index:0}),m.children[m.index]=v.children,m=v)}return g[0].children}function n(a,b,l,g,f,d,k,m,v){function q(){if(0<I)return I--,D>>I&1;D=a[b++];if(255===D){var H=a[b++];if(H)throw new G("unexpected marker "+(D<<8|H).toString(16));
}I=7;return D>>>7}function r(H){for(;;){H=H[q()];if("number"===typeof H)return H;if("object"!==typeof H)throw new G("invalid huffman sequence");}}function w(H){for(var K=0;0<H;)K=K<<1|q(),H--;return K}function u(H){if(1===H)return 1===q()?1:-1;var K=w(H);return K>=1<<H-1?K:K+(-1<<H)+1}function y(H,K){var L=r(H.huffmanTableDC);L=0===L?0:u(L);H.blockData[K]=H.pred+=L;for(L=1;64>L;){var P=r(H.huffmanTableAC),R=P&15;P>>=4;if(0===R){if(15>P)break;L+=16}else L+=P,H.blockData[K+c[L]]=u(R),L++}}function x(H,
K){var L=r(H.huffmanTableDC);L=0===L?0:u(L)<<v;H.blockData[K]=H.pred+=L}function z(H,K){H.blockData[K]|=q()<<v}function A(H,K){if(0<M)M--;else for(var L=d;L<=k;){var P=r(H.huffmanTableAC),R=P&15;P>>=4;if(0===R){if(15>P){M=w(P)+(1<<P)-1;break}L+=16}else L+=P,H.blockData[K+c[L]]=u(R)*(1<<v),L++}}function E(H,K){for(var L=d,P=0,R;L<=k;){R=c[L];switch(N){case 0:P=r(H.huffmanTableAC);R=P&15;P>>=4;if(0===R)15>P?(M=w(P)+(1<<P),N=4):(P=16,N=1);else{if(1!==R)throw new G("invalid ACn encoding");Q=u(R);N=P?
2:3}continue;case 1:case 2:H.blockData[K+R]?H.blockData[K+R]+=q()<<v:(P--,0===P&&(N=2===N?3:0));break;case 3:H.blockData[K+R]?H.blockData[K+R]+=q()<<v:(H.blockData[K+R]=Q<<v,N=0);break;case 4:H.blockData[K+R]&&(H.blockData[K+R]+=q()<<v)}L++}4===N&&(M--,0===M&&(N=0))}var F=l.mcusPerLine,B=b,D=0,I=0,M=0,N=0,Q,V=g.length,X,W,Z,aa;m=l.progressive?0===d?0===m?x:z:0===m?A:E:y;var J=0;l=1===V?g[0].blocksPerLine*g[0].blocksPerColumn:F*l.mcusPerColumn;for(var O,S;J<l;){var T=f?Math.min(l-J,f):l;for(X=0;X<
V;X++)g[X].pred=0;M=0;if(1===V){var C=g[0];for(aa=0;aa<T;aa++)m(C,64*((C.blocksPerLine+1)*(J/C.blocksPerLine|0)+J%C.blocksPerLine)),J++}else for(aa=0;aa<T;aa++){for(X=0;X<V;X++)for(C=g[X],O=C.h,S=C.v,W=0;W<S;W++)for(Z=0;Z<O;Z++)m(C,64*((C.blocksPerLine+1)*((J/F|0)*C.v+W)+(J%F*C.h+Z)));J++}I=0;(C=h(a,b))&&C.invalid&&(console.log("decodeScan - unexpected MCU data, next marker is: "+C.invalid),b=C.offset);C=C&&C.marker;if(!C||65280>=C)throw new G("marker was not found");if(65488<=C&&65495>=C)b+=2;else break}(C=
h(a,b))&&C.invalid&&(console.log("decodeScan - unexpected Scan data, next marker is: "+C.invalid),b=C.offset);return b-B}function p(a,b){a=b.blocksPerLine;for(var l=b.blocksPerColumn,g=new Int16Array(64),f=0;f<l;f++)for(var d=0;d<a;d++){var k=void 0,m=void 0,v=void 0,q=void 0,r=void 0,w=void 0,u=void 0,y=void 0,x=r=w=q=m=k=void 0,z=void 0,A=void 0,E=void 0,F=64*((b.blocksPerLine+1)*f+d),B=g,D=b.quantizationTable,I=b.blockData;if(!D)throw new G("missing required Quantization Table.");for(var M=0;64>
M;M+=8)k=I[F+M],y=I[F+M+1],u=I[F+M+2],w=I[F+M+3],r=I[F+M+4],q=I[F+M+5],v=I[F+M+6],m=I[F+M+7],k*=D[M],0===(y|u|w|r|q|v|m)?(k=5793*k+512>>10,B[M]=k,B[M+1]=k,B[M+2]=k,B[M+3]=k,B[M+4]=k,B[M+5]=k,B[M+6]=k,B[M+7]=k):(y*=D[M+1],u*=D[M+2],w*=D[M+3],r*=D[M+4],q*=D[M+5],v*=D[M+6],m*=D[M+7],E=5793*k+128>>8,A=5793*r+128>>8,z=u,x=v,r=2896*(y-m)+128>>8,m=2896*(y+m)+128>>8,w<<=4,q<<=4,E=E+A+1>>1,A=E-A,k=3784*z+1567*x+128>>8,z=1567*z-3784*x+128>>8,x=k,r=r+q+1>>1,q=r-q,m=m+w+1>>1,w=m-w,E=E+x+1>>1,x=E-x,A=A+z+1>>1,
z=A-z,k=2276*r+3406*m+2048>>12,r=3406*r-2276*m+2048>>12,m=k,k=799*w+4017*q+2048>>12,w=4017*w-799*q+2048>>12,q=k,B[M]=E+m,B[M+7]=E-m,B[M+1]=A+q,B[M+6]=A-q,B[M+2]=z+w,B[M+5]=z-w,B[M+3]=x+r,B[M+4]=x-r);for(D=0;8>D;++D)k=B[D],y=B[D+8],u=B[D+16],w=B[D+24],r=B[D+32],q=B[D+40],v=B[D+48],m=B[D+56],0===(y|u|w|r|q|v|m)?(k=5793*k+8192>>14,k=-2040>k?0:2024<=k?255:k+2056>>4,I[F+D]=k,I[F+D+8]=k,I[F+D+16]=k,I[F+D+24]=k,I[F+D+32]=k,I[F+D+40]=k,I[F+D+48]=k,I[F+D+56]=k):(E=5793*k+2048>>12,A=5793*r+2048>>12,z=u,x=v,
r=2896*(y-m)+2048>>12,m=2896*(y+m)+2048>>12,E=(E+A+1>>1)+4112,A=E-A,k=3784*z+1567*x+2048>>12,z=1567*z-3784*x+2048>>12,x=k,r=r+q+1>>1,q=r-q,m=m+w+1>>1,w=m-w,E=E+x+1>>1,x=E-x,A=A+z+1>>1,z=A-z,k=2276*r+3406*m+2048>>12,r=3406*r-2276*m+2048>>12,m=k,k=799*w+4017*q+2048>>12,w=4017*w-799*q+2048>>12,q=k,k=E+m,m=E-m,y=A+q,v=A-q,u=z+w,q=z-w,w=x+r,r=x-r,k=16>k?0:4080<=k?255:k>>4,y=16>y?0:4080<=y?255:y>>4,u=16>u?0:4080<=u?255:u>>4,w=16>w?0:4080<=w?255:w>>4,r=16>r?0:4080<=r?255:r>>4,q=16>q?0:4080<=q?255:q>>4,v=
16>v?0:4080<=v?255:v>>4,m=16>m?0:4080<=m?255:m>>4,I[F+D]=k,I[F+D+8]=y,I[F+D+16]=u,I[F+D+24]=w,I[F+D+32]=r,I[F+D+40]=q,I[F+D+48]=v,I[F+D+56]=m)}return b.blockData}function h(a,b,l){var g=a.length-1;l=l<b?l:b;if(b>=g)return null;var f=a[b]<<8|a[b+1];if(65472<=f&&65534>=f)return{invalid:null,marker:f,offset:b};for(b=a[l]<<8|a[l+1];!(65472<=b&&65534>=b);){if(++l>=g)return null;b=a[l]<<8|a[l+1]}return{invalid:f.toString(16),marker:b,offset:l}}if(!self||!self.Uint8ClampedArray)return null;var c=new Uint8Array([0,
1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,29,22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,61,54,47,55,62,63]);e.prototype={parse:function(a){function b(){var D=a[f]<<8|a[f+1];f+=2;return D}function l(){var D=b();D=f+D-2;var I=h(a,D,f);I&&I.invalid&&(console.log("readDataBlock - incorrect length, next marker is: "+I.invalid),D=I.offset);D=a.subarray(f,D);f+=D.length;return D}function g(D){for(var I=Math.ceil(D.samplesPerLine/8/
D.maxH),M=Math.ceil(D.scanLines/8/D.maxV),N=0;N<D.components.length;N++){B=D.components[N];var Q=Math.ceil(Math.ceil(D.samplesPerLine/8)*B.h/D.maxH),V=Math.ceil(Math.ceil(D.scanLines/8)*B.v/D.maxV);B.blockData=new Int16Array(64*M*B.v*(I*B.h+1));B.blocksPerLine=Q;B.blocksPerColumn=V}D.mcusPerLine=I;D.mcusPerColumn=M}var f=0,d=null,k=null,m=[],v=[],q=[],r=b();if(65496!==r)throw new G("SOI not found");for(r=b();65497!==r;){switch(r){case 65504:case 65505:case 65506:case 65507:case 65508:case 65509:case 65510:case 65511:case 65512:case 65513:case 65514:case 65515:case 65516:case 65517:case 65518:case 65519:case 65534:var w=
l();65504===r&&74===w[0]&&70===w[1]&&73===w[2]&&70===w[3]&&0===w[4]&&(d={version:{major:w[5],minor:w[6]},densityUnits:w[7],xDensity:w[8]<<8|w[9],yDensity:w[10]<<8|w[11],thumbWidth:w[12],thumbHeight:w[13],thumbData:w.subarray(14,14+3*w[12]*w[13])});65518===r&&65===w[0]&&100===w[1]&&111===w[2]&&98===w[3]&&101===w[4]&&(k={version:w[5]<<8|w[6],flags0:w[7]<<8|w[8],flags1:w[9]<<8|w[10],transformCode:w[11]});break;case 65499:r=b()+f-2;for(var u;f<r;){var y=a[f++],x=new Uint16Array(64);if(0===y>>4)for(w=
0;64>w;w++)u=c[w],x[u]=a[f++];else if(1===y>>4)for(w=0;64>w;w++)u=c[w],x[u]=b();else throw new G("DQT - invalid table spec");m[y&15]=x}break;case 65472:case 65473:case 65474:if(z)throw new G("Only single frame JPEGs supported");b();var z={};z.extended=65473===r;z.progressive=65474===r;z.precision=a[f++];z.scanLines=b();z.samplesPerLine=b();z.components=[];z.componentIds={};w=a[f++];for(r=x=y=0;r<w;r++){u=a[f];var A=a[f+1]>>4;var E=a[f+1]&15;y<A&&(y=A);x<E&&(x=E);A=z.components.push({h:A,v:E,quantizationId:a[f+
2],quantizationTable:null});z.componentIds[u]=A-1;f+=3}z.maxH=y;z.maxV=x;g(z);break;case 65476:u=b();for(r=2;r<u;){y=a[f++];x=new Uint8Array(16);for(w=A=0;16>w;w++,f++)A+=x[w]=a[f];E=new Uint8Array(A);for(w=0;w<A;w++,f++)E[w]=a[f];r+=17+A;(0===y>>4?q:v)[y&15]=t(x,E)}break;case 65501:b();var F=b();break;case 65498:b();u=a[f++];w=[];for(r=0;r<u;r++){y=z.componentIds[a[f++]];var B=z.components[y];y=a[f++];B.huffmanTableDC=q[y>>4];B.huffmanTableAC=v[y&15];w.push(B)}r=a[f++];u=a[f++];y=a[f++];r=n(a,f,
z,w,F,r,u,y>>4,y&15);f+=r;break;case 65535:255!==a[f]&&f--;break;default:if(255===a[f-3]&&192<=a[f-2]&&254>=a[f-2])f-=3;else throw new G("unknown marker "+r.toString(16));}r=b()}this.width=z.samplesPerLine;this.height=z.scanLines;this.jfif=d;this.eof=f;this.adobe=k;this.components=[];for(r=0;r<z.components.length;r++){B=z.components[r];if(d=m[B.quantizationId])B.quantizationTable=d;this.components.push({output:p(z,B),scaleX:B.h/z.maxH,scaleY:B.v/z.maxV,blocksPerLine:B.blocksPerLine,blocksPerColumn:B.blocksPerColumn})}this.numComponents=
this.components.length},_getLinearizedBlockData:function(a,b){var l=this.width/a,g=this.height/b,f,d,k=0,m=this.components.length,v=a*b*m,q=new Uint8ClampedArray(v),r=new Uint32Array(a);for(d=0;d<m;d++){var w=this.components[d];var u=w.scaleX*l;var y=w.scaleY*g;k=d;var x=w.output;var z=w.blocksPerLine+1<<3;for(f=0;f<a;f++)w=0|f*u,r[f]=(w&4294967288)<<3|w&7;for(u=0;u<b;u++)for(w=0|u*y,w=z*(w&4294967288)|(w&7)<<3,f=0;f<a;f++)q[k]=x[w+r[f]],k+=m}if(b=this.decodeTransform)for(d=0;d<v;)for(a=w=0;w<m;w++,
d++,a+=2)q[d]=(q[d]*b[a]>>8)+b[a+1];return q},_isColorConversionNeeded:function(){return this.adobe?!!this.adobe.transformCode:3===this.numComponents?0===this.colorTransform?!1:!0:1===this.colorTransform?!0:!1},_convertYccToRgb:function(a){for(var b,l,g,f=0,d=a.length;f<d;f+=3)b=a[f],l=a[f+1],g=a[f+2],a[f]=b-179.456+1.402*g,a[f+1]=b+135.459-.344*l-.714*g,a[f+2]=b-226.816+1.772*l;return a},_convertYcckToRgb:function(a){for(var b,l,g,f,d=0,k=0,m=a.length;k<m;k+=4)b=a[k],l=a[k+1],g=a[k+2],f=a[k+3],a[d++]=
-122.67195406894+l*(-6.60635669420364E-5*l+4.37130475926232E-4*g-5.4080610064599E-5*b+4.8449797120281E-4*f-.154362151871126)+g*(-9.57964378445773E-4*g+8.17076911346625E-4*b-.00477271405408747*f+1.53380253221734)+b*(9.61250184130688E-4*b-.00266257332283933*f+.48357088451265)+f*(-3.36197177618394E-4*f+.484791561490776),a[d++]=107.268039397724+l*(2.19927104525741E-5*l-6.40992018297945E-4*g+6.59397001245577E-4*b+4.26105652938837E-4*f-.176491792462875)+g*(-7.78269941513683E-4*g+.00130872261408275*b+7.70482631801132E-4*
f-.151051492775562)+b*(.00126935368114843*b-.00265090189010898*f+.25802910206845)+f*(-3.18913117588328E-4*f-.213742400323665),a[d++]=-20.810012546947+l*(-5.70115196973677E-4*l-2.63409051004589E-5*g+.0020741088115012*b-.00288260236853442*f+.814272968359295)+g*(-1.53496057440975E-5*g-1.32689043961446E-4*b+5.60833691242812E-4*f-.195152027534049)+b*(.00174418132927582*b-.00255243321439347*f+.116935020465145)+f*(-3.43531996510555E-4*f+.24165260232407);return a},_convertYcckToCmyk:function(a){for(var b,
l,g,f=0,d=a.length;f<d;f+=4)b=a[f],l=a[f+1],g=a[f+2],a[f]=434.456-b-1.402*g,a[f+1]=119.541-b+.344*l+.714*g,a[f+2]=481.816-b-1.772*l;return a},_convertCmykToRgb:function(a){for(var b,l,g,f,d=0,k=1/255,m=0,v=a.length;m<v;m+=4)b=a[m]*k,l=a[m+1]*k,g=a[m+2]*k,f=a[m+3]*k,a[d++]=255+b*(-4.387332384609988*b+54.48615194189176*l+18.82290502165302*g+212.25662451639585*f-285.2331026137004)+l*(1.7149763477362134*l-5.6096736904047315*g-17.873870861415444*f-5.497006427196366)+g*(-2.5217340131683033*g-21.248923337353073*
f+17.5119270841813)-f*(21.86122147463605*f+189.48180835922747),a[d++]=255+b*(8.841041422036149*b+60.118027045597366*l+6.871425592049007*g+31.159100130055922*f-79.2970844816548)+l*(-15.310361306967817*l+17.575251261109482*g+131.35250912493976*f-190.9453302588951)+g*(4.444339102852739*g+9.8632861493405*f-24.86741582555878)-f*(20.737325471181034*f+187.80453709719578),a[d++]=255+b*(.8842522430003296*b+8.078677503112928*l+30.89978309703729*g-.23883238689178934*f-14.183576799673286)+l*(10.49593273432072*
l+63.02378494754052*g+50.606957656360734*f-112.23884253719248)+g*(.03296041114873217*g+115.60384449646641*f-193.58209356861505)-f*(22.33816807309886*f+180.12613974708367);return a},getData:function(a,b,l){if(4<this.numComponents)throw new G("Unsupported color mode");a=this._getLinearizedBlockData(a,b);if(1===this.numComponents&&l){l=a.length;b=new Uint8ClampedArray(3*l);for(var g=0,f=0;f<l;f++){var d=a[f];b[g++]=d;b[g++]=d;b[g++]=d}return b}if(3===this.numComponents&&this._isColorConversionNeeded())return this._convertYccToRgb(a);
if(4===this.numComponents){if(this._isColorConversionNeeded())return l?this._convertYcckToRgb(a):this._convertYcckToCmyk(a);if(l)return this._convertCmykToRgb(a)}return a}};return e}()})},"esri/layers/rasterFormats/Png":function(){define(["./Zlib"],function(G){return function(){function e(n){var p,h;this.data=n;this.pos=8;this.palette=[];this.imgData=[];this.transparency={};this.animation=null;this.text={};for(h=null;;){var c=this.readUInt32();var a=n=void 0;n=[];for(a=0;4>a;++a)n.push(String.fromCharCode(this.data[this.pos++]));
n=n.join("");switch(n){case "IHDR":this.width=this.readUInt32();this.height=this.readUInt32();this.bits=this.data[this.pos++];this.colorType=this.data[this.pos++];this.compressionMethod=this.data[this.pos++];this.filterMethod=this.data[this.pos++];this.interlaceMethod=this.data[this.pos++];break;case "acTL":this.animation={numFrames:this.readUInt32(),numPlays:this.readUInt32()||Infinity,frames:[]};break;case "PLTE":this.palette=this.read(c);break;case "fcTL":h&&this.animation.frames.push(h);this.pos+=
4;h={width:this.readUInt32(),height:this.readUInt32(),xOffset:this.readUInt32(),yOffset:this.readUInt32()};n=this.readUInt16();c=this.readUInt16()||100;h.delay=1E3*n/c;h.disposeOp=this.data[this.pos++];h.blendOp=this.data[this.pos++];h.data=[];break;case "IDAT":case "fdAT":"fdAT"===n&&(this.pos+=4,c-=4);n=(null!=h?h.data:void 0)||this.imgData;for(a=0;0<=c?a<c:a>c;0<=c?++a:--a)n.push(this.data[this.pos++]);break;case "tRNS":this.transparency={};switch(this.colorType){case 3:this.transparency.indexed=
this.read(c);c=255-this.transparency.indexed.length;if(0<c)for(n=0;0<=c?n<c:n>c;0<=c?++n:--n)this.transparency.indexed.push(255);break;case 0:this.transparency.grayscale=this.read(c)[0];break;case 2:this.transparency.rgb=this.read(c)}break;case "tEXt":a=this.read(c);c=a.indexOf(0);n=String.fromCharCode.apply(String,a.slice(0,c));this.text[n]=String.fromCharCode.apply(String,a.slice(c+1));break;case "IEND":h&&this.animation.frames.push(h);a:{switch(this.colorType){case 0:case 3:case 4:h=1;break a;
case 2:case 6:h=3;break a}h=void 0}this.colors=h;this.hasAlphaChannel=4===(p=this.colorType)||6===p;p=this.colors+(this.hasAlphaChannel?1:0);this.pixelBitlength=this.bits*p;a:{switch(this.colors){case 1:p="DeviceGray";break a;case 3:p="DeviceRGB";break a}p=void 0}this.colorSpace=p;this.imgData=new Uint8Array(this.imgData);return;default:this.pos+=c}this.pos+=4;if(this.pos>this.data.length)throw Error("Incomplete or corrupt PNG file");}}e.load=function(n,p,h){"function"===typeof p&&(h=p);var c=new XMLHttpRequest;
c.open("GET",n,!0);c.responseType="arraybuffer";c.onload=function(){var a=new Uint8Array(c.response||c.mozResponseArrayBuffer);a=new e(a);"function"===typeof(null!=p?p.getContext:void 0)&&a.render(p);return"function"===typeof h?h(a):void 0};return c.send(null)};e.prototype.read=function(n){var p;var h=[];for(p=0;0<=n?p<n:p>n;0<=n?++p:--p)h.push(this.data[this.pos++]);return h};e.prototype.readUInt32=function(){var n=this.data[this.pos++]<<24;var p=this.data[this.pos++]<<16;var h=this.data[this.pos++]<<
8;var c=this.data[this.pos++];return n|p|h|c};e.prototype.readUInt16=function(){var n=this.data[this.pos++]<<8;var p=this.data[this.pos++];return n|p};e.prototype.decodePixels=function(n){var p,h,c,a,b,l,g,f;null==n&&(n=this.imgData);if(0===n.length)return new Uint8Array(0);n=new G(n);n=n.getBytes();var d=this.pixelBitlength/8;var k=d*this.width;var m=new Uint8Array(k*this.height);var v=n.length;for(h=a=b=0;a<v;){switch(n[a++]){case 0:for(c=p=0;p<k;c=p+=1)m[h++]=n[a++];break;case 1:for(c=l=0;l<k;c=
l+=1){p=n[a++];var q=c<d?0:m[h-d];m[h++]=(p+q)%256}break;case 2:for(c=q=0;q<k;c=q+=1){p=n[a++];var r=(c-c%d)/d;l=b&&m[(b-1)*k+r*d+c%d];m[h++]=(l+p)%256}break;case 3:for(c=f=0;f<k;c=f+=1)p=n[a++],r=(c-c%d)/d,q=c<d?0:m[h-d],l=b&&m[(b-1)*k+r*d+c%d],m[h++]=(p+Math.floor((q+l)/2))%256;break;case 4:for(c=f=0;f<k;c=f+=1){p=n[a++];r=(c-c%d)/d;q=c<d?0:m[h-d];0===b?l=g=0:(l=m[(b-1)*k+r*d+c%d],g=r&&m[(b-1)*k+(r-1)*d+c%d]);var w=q+l-g;c=Math.abs(w-q);r=Math.abs(w-l);w=Math.abs(w-g);q=c<=r&&c<=w?q:r<=w?l:g;m[h++]=
(p+q)%256}break;default:throw Error("Invalid filter algorithm: "+n[a-1]);}b++}return m};e.prototype.decodePalette=function(){var n,p,h,c,a;var b=this.palette;var l=this.transparency.indexed||[];var g=new Uint8Array((l.length||0)+b.length);var f=h=n=p=0;for(c=b.length;h<c;f=h+=3)g[p++]=b[f],g[p++]=b[f+1],g[p++]=b[f+2],g[p++]=null!=(a=l[n++])?a:255;return g};e.prototype.copyToImageData=function(n,p){var h,c;var a=this.colors;var b=null;var l=this.hasAlphaChannel;this.palette.length&&(b=null!=(h=this._decodedPalette)?
h:this._decodedPalette=this.decodePalette(),a=4,l=!0);n=n.data||n;var g=n.length;var f=b||p;h=c=0;if(1===a)for(;h<g;)a=b?4*p[h/4]:c,c=f[a++],n[h++]=c,n[h++]=c,n[h++]=c,n[h++]=l?f[a++]:this.transparency.grayscale&&this.transparency.grayscale===c?0:255,c=a;else for(;h<g;)a=b?4*p[h/4]:c,n[h++]=f[a++],n[h++]=f[a++],n[h++]=f[a++],n[h++]=l?f[a++]:this.transparency.rgb&&this.transparency.rgb[1]===f[a-3]&&this.transparency.rgb[3]===f[a-2]&&this.transparency.rgb[5]===f[a-1]?0:255,c=a};e.prototype.decode=function(){var n=
new Uint8Array(this.width*this.height*4);this.copyToImageData(n,this.decodePixels());return n};var t=function(n){(void 0).clearRect(0,0,n.width,n.height);(void 0).putImageData(n,0,0);n=new Image;n.src=(void 0).toDataURL();return n};e.prototype.decodeFrames=function(n){var p,h;if(this.animation){var c=this.animation.frames;var a=[];var b=p=0;for(h=c.length;p<h;b=++p){b=c[b];var l=n.createImageData(b.width,b.height);var g=this.decodePixels(new Uint8Array(b.data));this.copyToImageData(l,g);b.imageData=
l;a.push(b.image=t(l))}return a}};e.prototype.renderFrame=function(n,p){var h=this.animation.frames;var c=h[p];h=h[p-1];0===p&&n.clearRect(0,0,this.width,this.height);1===(null!=h?h.disposeOp:void 0)?n.clearRect(h.xOffset,h.yOffset,h.width,h.height):2===(null!=h?h.disposeOp:void 0)&&n.putImageData(h.imageData,h.xOffset,h.yOffset);0===c.blendOp&&n.clearRect(c.xOffset,c.yOffset,c.width,c.height);return n.drawImage(c.image,c.xOffset,c.yOffset)};e.prototype.animate=function(n){var p,h=this;var c=0;var a=
this.animation;var b=a.numFrames;var l=a.frames;var g=a.numPlays;return(p=function(){var f=c++%b;var d=l[f];h.renderFrame(n,f);if(1<b&&c/b<g)return h.animation._timeout=setTimeout(p,d.delay)})()};e.prototype.stopAnimation=function(){var n;return clearTimeout(null!=(n=this.animation)?n._timeout:void 0)};e.prototype.render=function(n){n._png&&n._png.stopAnimation();n._png=this;n.width=this.width;n.height=this.height;n=n.getContext("2d");if(this.animation)return this.decodeFrames(n),this.animate(n);
var p=n.createImageData(this.width,this.height);this.copyToImageData(p,this.decodePixels());return n.putImageData(p,0,0)};return e}()})},"esri/layers/rasterFormats/Raw":function(){define([],function(){return{decodeBIP:function(G,e){var t=e.pixelType,n=e.bandCount,p=[],h=e.width*e.height,c=this.getBandCount(G,e);n=n||c;var a=G.byteLength-G.byteLength%(h*this._getPixelLength(t)),b=new t(G,0,h*c),l,g,f;for(l=0;l<n;l++){var d=new t(h);for(g=0;g<h;g++)d[g]=b[g*c+l];p.push(d)}a<G.byteLength-1&&(f=this._decodeMask(G.slice(a),
e));return{pixels:p,maskData:f}},decodeBSQ:function(G,e){var t=e.pixelType,n=e.bandCount;if(void 0===n||null===n)n=this.getBandCount(G,e);var p=[],h=e.width*e.height,c=h*n,a=G.byteLength-G.byteLength%(h*this._getPixelLength(t));t=new t(G,0,c);var b;for(c=0;c<n;c++)p.push(t.subarray(c*h,(c+1)*h));a<G.byteLength-1&&(b=this._decodeMask(G.slice(a),e));return{pixels:p,maskData:b}},getBandCount:function(G,e){return Math.floor(G.byteLength/(e.width*e.height*this._getPixelLength(e.pixelType)))},_getPixelLength:function(G){var e=
1;switch(G){case Uint8Array:case Int8Array:case Uint8ClampedArray:e=1;break;case Uint16Array:case Int16Array:e=2;break;case Uint32Array:case Int32Array:case Float32Array:e=4;break;case Float64Array:e=8}return e},_decodeMask:function(G,e){var t=e.width*e.height;if(8*G.byteLength<t)return null;G=new Uint8Array(G,0,Math.ceil(t/8));e=new Uint8Array(e.width*e.height);var n=0,p=0,h=0,c=0;for(h=0;h<G.length-1;h++)for(p=G[h],c=7;0<=c;c--)e[n++]=p>>c&1;for(c=7;n<t-1;)p=G[G.length-1],e[n++]=p>>c&1,c--;return e}}})},
"esri/layers/rasterFormats/TiffDecoder":function(){define(["./Jpg","./Zlib"],function(G,e){var t=function(){var c=new ArrayBuffer(4),a=new Uint8Array(c);c=new Uint32Array(c);a[0]=1;a[1]=2;a[2]=3;a[3]=4;return 67305985===c[0]},n=function(){var c=[];c[254]="NEWSUBFILETYPE";c[255]="SUBFILETYPE";c[256]="IMAGEWIDTH";c[257]="IMAGELENGTH";c[258]="BITSPERSAMPLE";c[259]="COMPRESSION";c[262]="PHOTOMETRICINTERPRETATION";c[263]="THRESHHOLDING";c[264]="CELLWIDTH";c[265]="CELLLENGTH";c[266]="FILLORDER";c[269]=
"DOCUMENTNAME";c[270]="IMAGEDESCRIPTION";c[271]="MAKE";c[272]="MODEL";c[273]="STRIPOFFSETS";c[274]="ORIENTATION";c[277]="SAMPLESPERPIXEL";c[278]="ROWSPERSTRIP";c[279]="STRIPBYTECOUNTS";c[280]="MINSAMPLEVALUE";c[281]="MAXSAMPLEVALUE";c[282]="XRESOLUTION";c[283]="YRESOLUTION";c[284]="PLANARCONFIGURATION";c[285]="PAGENAME";c[286]="XPOSITION";c[287]="YPOSITION";c[288]="FREEOFFSETS";c[289]="FREEBYTECOUNTS";c[290]="GRAYRESPONSEUNIT";c[291]="GRAYRESPONSECURVE";c[292]="T4OPTIONS";c[293]="T6OPTIONS";c[296]=
"RESOLUTIONUNIT";c[297]="PAGENUMBER";c[300]="COLORRESPONSEUNIT";c[301]="TRANSFERFUNCTION";c[305]="SOFTWARE";c[306]="DATETIME";c[315]="ARTIST";c[316]="HOSTCOMPUTER";c[317]="PREDICTOR";c[318]="WHITEPOINT";c[319]="PRIMARYCHROMATICITIES";c[320]="COLORMAP";c[321]="HALFTONEHINTS";c[322]="TILEWIDTH";c[323]="TILELENGTH";c[324]="TILEOFFSETS";c[325]="TILEBYTECOUNTS";c[326]="BADFAXLINES";c[327]="CLEANFAXDATA";c[328]="CONSECUTIVEBADFAXLINES";c[330]="SUBIFD";c[332]="INKSET";c[333]="INKNAMES";c[334]="NUMBEROFINKS";
c[336]="DOTRANGE";c[337]="TARGETPRINTER";c[338]="EXTRASAMPLES";c[339]="SAMPLEFORMAT";c[340]="SMINSAMPLEVALUE";c[341]="SMAXSAMPLEVALUE";c[342]="TRANSFERRANGE";c[347]="JPEGTABLES";c[512]="JPEGPROC";c[513]="JPEGIFOFFSET";c[514]="JPEGIFBYTECOUNT";c[515]="JPEGRESTARTINTERVAL";c[517]="JPEGLOSSLESSPREDICTORS";c[518]="JPEGPOINTTRANSFORM";c[519]="JPEGQTABLES";c[520]="JPEGDCTABLES";c[521]="JPEGACTABLES";c[529]="YCBCRCOEFFICIENTS";c[530]="YCBCRSUBSAMPLING";c[531]="YCBCRPOSITIONING";c[532]="REFERENCEBLACKWHITE";
c[33550]="GEOPIXELSCALE";c[33922]="GEOTIEPOINTS";c[33432]="COPYRIGHT";c[42112]="GDAL_METADATA";c[42113]="GDAL_NODATA";c[50844]="RPCCOEFFICIENT";c[34735]="GEOKEYDIRECTORY";c[34736]="GEODOUBLEPARAMS";c[34737]="GEOASCIIPARAMS";return c}(),p=[0,1,1,2,4,8,1,1,2,4,8,4,8],h=function(c,a){var b="UNKNOWN";3===c?b="F32":1===c?8>=a?b="U8":16>=a?b="U16":32>=a&&(b="U32"):2===c&&(8>=a?b="S8":16>=a?b="S16":32>=a&&(b="S32"));return b};return{decode:function(c){var a=new DataView(c,0,8),b=a.getUint16(0,!1);if(18761===
b)var l=!0;else if(19789===b)l=!1;else throw"unexpected endianess byte";if(42!==a.getUint16(2,l))throw"unexpected tiff identifier";var g=a.getUint32(4,l);var f=l;var d,k;var m=g;for(var v=[];m;){var q=(new DataView(c,m,2)).getUint16(0,f);var r=m+2;m=(new DataView(c,r+12*q,4)).getUint32(0,f);var w={};for(d=0;d<q;d++){var u=new DataView(c,r,12);var y=u.getUint16(0,f);var x=u.getUint16(2,f);var z=u.getUint32(4,f);var A=u.getUint32(8,f);r+=12;if(!(7===x||12<x)){var E=k={fieldTag:y,fieldType:x,fieldValueCount:z,
fieldValueOffset:A},F=void 0,B=void 0,D=c,I=f,M=[],N=k.fieldType,Q=k.fieldValueCount,V=k.fieldValueOffset,X=V,W=p[N],Z=8*W,aa=Q*W,J=Q*p[N]*8;if(32>=J)if(I||(V>>>=32-J),1===Q)M=[V];else for(F=0;F<Q;F++)M.push(V<<Z*F>>>32-Z);else for(X=V;X<V+aa;X+=W){switch(N){case 1:B=(new DataView(D,X,1)).getUint8(0);break;case 2:B=(new DataView(D,X,1)).getUint8(0);break;case 3:B=(new DataView(D,X,2)).getUint16(0,I);break;case 4:B=(new DataView(D,X,4)).getUint32(0,I);break;case 5:B=(new DataView(D,X,4)).getUint32(0,
I)/(new DataView(D,X+4,4)).getUint32(0,I);break;case 6:B=(new DataView(D,X,1)).getInt8(0);break;case 8:B=(new DataView(D,X,2)).getInt16(0,I);break;case 9:B=(new DataView(D,X,4)).getInt32(0,I);break;case 10:B=(new DataView(D,X,4)).getInt32(0,I)/(new DataView(D,X+4,4)).getInt32(0,I);break;case 11:B=(new DataView(D,X,4)).getFloat32(0,I);break;case 12:B=(new DataView(D,X,8)).getFloat64(0,I);break;case 7:B=null;break;default:B=null}M.push(B)}if(2===N){var O="",S=M;M=[];for(F=0;F<S.length;F++)0===S[F]&&
""!==O?(M.push(O),O=""):O+=String.fromCharCode(S[F]);""===O&&0!==M.length||M.push(O)}E.fieldValues=M;var T=w,C=n[y];void 0===C&&(C="unknown"+y);T[C]={type:x,values:k.fieldValues}}}v.push(w)}if(0===v.length)throw"no valid image file directory";var H,K=v[0],L=void 0===K.GDAL_NODATA||null===K.GDAL_NODATA?null:parseFloat(K.GDAL_NODATA.values[0]);if(K.TILEOFFSETS){var P=t()===f,R=K.TILEOFFSETS?K.TILEOFFSETS.values:void 0;if(void 0===R)var U=void 0;else{var Y=K.TILEBYTECOUNTS.values,ja=K.TILEWIDTH.values[0],
oa=K.TILELENGTH.values[0],qa=K.IMAGEWIDTH.values[0],Sa=K.IMAGELENGTH.values[0],ra=qa*Sa,la=K.BITSPERSAMPLE.values[0],fa=K.SAMPLESPERPIXEL.values[0],Ea=K.SAMPLEFORMAT?K.SAMPLEFORMAT.values[0]:1,Ma=h(Ea,la);if(1!==(K.PLANARCONFIGURATION?K.PLANARCONFIGURATION.values[0]:1))throw console.log("can only handle PLANARCONFIGURATION\x3d1"),"can only handle PLANARCONFIGURATION\x3d1";var pa=K.COMPRESSION?K.COMPRESSION.values[0]:1;if(1!==pa&&6!==pa&&8!==pa&&32946!==pa)throw console.log("this compression is not supported at this moment"),
"this compression is not supported at this moment";if(3<Ea)U=void 0;else{if(3===Ea){var sa=new Float32Array(ra*fa);var wa=Float32Array}else 1===Ea?8>=la?(sa=new Uint8Array(ra*fa),wa=Uint8Array):16>=la?(sa=new Uint16Array(ra*fa),wa=Uint16Array):32>=la&&(sa=new Uint32Array(ra*fa),wa=Uint32Array):2===Ea&&(8>=la?(sa=new Int8Array(ra*fa),wa=Int8Array):16>=la?(sa=new Int16Array(ra*fa),wa=Int16Array):32>=la&&(sa=new Int32Array(ra*fa),wa=Int32Array));var ca,Fa,ha,Ga,Ta,Ya=Math.ceil(qa/ja);if(0===la%8)for(ca=
0;ca<R.length;ca++){var Za=Math.floor(ca/Ya)*oa;var $a=ca%Ya*ja;var ab=(Za*qa+$a)*fa;if("U8"===Ma||"S8"===Ma||P)if(8===pa||32946===pa){var da=new Uint8Array(c,R[ca],Y[ca]);var Ua=new e(da);var bb=Ua.getBytes();var ta=new ArrayBuffer(bb.length);da=new Uint8Array(ta);da.set(bb);da.length!==ja*oa*fa*la/8&&console.log("tile byte counts is different than expected")}else if(6===pa){da=new Uint8Array(c,R[ca],Y[ca]);var Na=new G;Na.parse(da);var cb=Na.getData(Na.width,Na.height);ta=new ArrayBuffer(cb.length);
da=new Uint8Array(ta);da.set(cb)}else 1===pa&&(Y[ca]!==ja*oa*fa*la/8&&console.log("tile byte counts is different than expected"),ta=c.slice(R[ca],R[ca]+Y[ca]));else{if(8===pa||32946===pa){da=new Uint8Array(c,R[ca],Y[ca]);Ua=new e(da);da=Ua.getBytes();ta=new ArrayBuffer(da.length);var Ca=new Uint8Array(ta);da.length!==ja*oa*fa*la/8&&console.log("tile byte counts is different than expected")}else 1===pa&&(Y[ca]!==ja*oa*fa*la/8&&console.log("tile byte counts is different than expected"),ta=new ArrayBuffer(Y[ca]),
da=new Uint8Array(c,R[ca],Y[ca]),Ca=new Uint8Array(ta));switch(Ma){case "U16":case "S16":for(ha=0;ha<da.length;ha+=2)Ca[ha]=da[ha+1],Ca[ha+1]=da[ha];break;case "U32":case "S32":case "F32":for(ha=0;ha<da.length;ha+=4)Ca[ha]=da[ha+3],Ca[ha+1]=da[ha+2],Ca[ha+2]=da[ha+1],Ca[ha+3]=da[ha]}}var hb=new wa(ta);var Va=0;var Wa=ab;var ib=Math.min(ja,qa-$a);var jb=Math.min(oa,Sa-Za);for(Ga=0;Ga<jb;Ga++)for(Wa=ab+Ga*qa*fa,Va=Ga*ja*fa,Ta=0;Ta<ib*fa;Ta++,Wa++,Va++)sa[Wa]=hb[Va]}var Oa={width:qa,height:Sa,pixelType:Ma};
if(1===fa)Oa.pixels=[sa];else for(Oa.pixels=[],ca=0;ca<fa;ca++){var db=new wa(ra);for(Fa=0;Fa<ra;Fa++)db[Fa]=sa[Fa*fa+ca];Oa.pixels.push(db)}U=Oa}}}else if(K.STRIPOFFSETS){var kb=t()===f,xa=K.STRIPOFFSETS?K.STRIPOFFSETS.values:void 0;if(void 0===xa)U=void 0;else{var ya=K.STRIPBYTECOUNTS.values,Ha=K.ROWSPERSTRIP.values,za=K.IMAGEWIDTH.values[0],Ia=K.IMAGELENGTH.values[0],Aa=za*Ia,ma=K.BITSPERSAMPLE.values[0],ka=K.SAMPLESPERPIXEL.values[0],Ja=K.SAMPLEFORMAT?K.SAMPLEFORMAT.values[0]:1,Pa=h(Ja,ma);if(1!==
(K.PLANARCONFIGURATION?K.PLANARCONFIGURATION.values[0]:1))throw console.log("can only handle PLANARCONFIGURATION\x3d1"),"can only handle PLANARCONFIGURATION\x3d1";var na=K.COMPRESSION?K.COMPRESSION.values[0]:1;if(1!==na&&6!==na&&8!==na&&32946!==na)throw console.log("compressed tiff is not supported at this moment"),"compressed tiff is not supported at this moment";if(3<Ja)U=void 0;else{if(3===Ja){var ua=new Float32Array(Aa*ka);var Ba=Float32Array}else 1===Ja?8>=ma?(ua=new Uint8Array(Aa*ka),Ba=Uint8Array):
16>=ma?(ua=new Uint16Array(Aa*ka),Ba=Uint16Array):32>=ma&&(ua=new Uint32Array(Aa*ka),Ba=Uint32Array):2===Ja&&(8>=ma?(ua=new Int8Array(Aa*ka),Ba=Int8Array):16>=ma?(ua=new Int16Array(Aa*ka),Ba=Int16Array):32>=ma&&(ua=new Int32Array(za*Ia*ka),Ba=Int32Array));var ba,Ka,ia,La=Ha;if(0===ma%8)for(ba=0;ba<xa.length;ba++){var lb=ba*Ha*za*ka;La=(ba+1)*Ha>Ia?Ia-ba*Ha:Ha;if("U8"===Pa||"S8"===Pa||kb)if(8===na||32946===na){var ea=new Uint8Array(c,xa[ba],ya[ba]);var Xa=new e(ea);var eb=Xa.getBytes();var va=new ArrayBuffer(eb.length);
ea=new Uint8Array(va);ea.set(eb);ea.length!==La*za*ka*ma/8&&console.log("strip byte counts is different than expected")}else if(6===na){ea=new Uint8Array(c,xa[ba],ya[ba]);var Qa=new G;Qa.parse(ea);var fb=Qa.getData(Qa.width,Qa.height);va=new ArrayBuffer(fb.length);ea=new Uint8Array(va);ea.set(fb)}else 1===na&&(ya[ba]!==La*za*ka*ma/8&&console.log("strip byte counts is different than expected"),va=c.slice(xa[ba],xa[ba]+ya[ba]));else{if(6===na||8===na||32946===na){ea=new Uint8Array(c,xa[ba],ya[ba]);
Xa=new e(ea);ea=Xa.getBytes();va=new ArrayBuffer(ea.length);var Da=new Uint8Array(va);ea.length!==La*za*ka*ma/8&&console.log("strip byte counts is different than expected")}else 1===na&&(ya[ba]!==La*za*ka*ma/8&&console.log("strip byte counts is different than expected"),va=new ArrayBuffer(ya[ba]),ea=new Uint8Array(c,xa[ba],ya[ba]),Da=new Uint8Array(va));switch(Pa){case "U16":case "S16":for(ia=0;ia<ea.length;ia+=2)Da[ia]=ea[ia+1],Da[ia+1]=ea[ia];break;case "U32":case "S32":case "F32":for(ia=0;ia<ea.length;ia+=
4)Da[ia]=ea[ia+3],Da[ia+1]=ea[ia+2],Da[ia+2]=ea[ia+1],Da[ia+3]=ea[ia]}}var mb=new Ba(va);ua.set(mb,lb)}var Ra={width:za,height:Ia,pixelType:Pa};if(1===ka)Ra.pixels=[ua];else for(Ra.pixels=[],ba=0;ba<ka;ba++){var gb=new Ba(Aa);for(Ka=0;Ka<Aa;Ka++)gb[Ka]=ua[Ka*ka+ba];Ra.pixels.push(gb)}U=Ra}}}if(null!==L){U.maskData=new Uint8Array(U.width*U.height);if(1E24<Math.abs(L))for(H=0;H<U.width*U.height;H++)U.maskData[H]=1E-6>Math.abs((U.pixels[0][H]-L)/L)?0:1;else for(H=0;H<U.width*U.height;H++)U.maskData[H]=
U.pixels[0][H]===L?0:1;U.noDataValue=L}return U}}})},"esri/layers/rasterLib/tile/RasterHandler":function(){define("require exports module dojo/Deferred dojo/promise/all ../../PixelBlock ../../vectorTiles/core/workers ../../vectorTiles/core/promiseUtils ../../vectorTiles/core/requireUtils ../../vectorTiles/request ../../rasterLib/function/rasterFunctionHelper ../../rasterLib/renderer/rasterRendererHelper".split(" "),function(G,e,t,n,p,h,c,a,b,l,g,f){function d(k){var m=new n;p(k).then(function(v){m.resolve()});
return m.promise}return function(){function k(m){this.customModules=m&&m.customModules}k.prototype.destroy=function(){this.stop();this.customModules=this.rasterLayer=null};k.prototype.start=function(){this.stop();var m=new n,v=0,q=this.customModules?this.customModules.length+1:1,r=b.getAbsMid("esri/layers/rasterLib/tile/RasterWorker",G,t),w=c.open(r,{client:this}).then(function(u){this._connection=u;v++;v===q&&(this._connected=!0,m.resolve())}.bind(this));this._openDL=[w];this.customModules&&this.customModules.forEach(function(u){w=
c.open(u,{client:this}).then(function(y){v++;v===q&&(this._connected=!0,m.resolve())});this._openDL.push(w);console.log(u)}.bind(this));return this._connectionPromise=m.promise};k.prototype.stop=function(){this._openDL?this._openDL.forEach(function(m){m.isFulfilled()||m.cancel()}.bind(this)):this._connectionPromise&&!this._connectionPromise.isFulfilled()&&this._connectionPromise.cancel();this._connection&&(this._connection.close(),this._connection=null)};k.prototype.decode=function(m){if(!this._connectionPromise.isFulfilled()||
!this._connection)return a.reject(Error("no connection"));var v={id:null};return this._connection.invoke("decode",m,[],v).then(function(q){q.targetWorker=v;return q})};k.prototype.process=function(m){if(!this._connectionPromise.isFulfilled()||!this._connection)return a.reject(Error("no connection"));var v={id:null};m.layerId=this.rasterLayer.layerId;var q=new n;this._connection.invoke("process",m,[],v).then(function(r){r.targetWorker=v;r.src?Object.keys(r.src).forEach(function(w){r.src[w].pixelBlock=
new h(r.src[w].pixelBlock)}):r.src=null;r.pixelBlock&&(r.pixelBlock=new h(r.pixelBlock));q.resolve(r)});return q.promise};k.prototype.render=function(m){if(!this._connectionPromise.isFulfilled()||!this._connection)return a.reject(Error("no connection"));var v={id:null};m.layerId=this.rasterLayer.layerId;return this._connection.invoke("render",m,[],v).then(function(q){q.targetWorker=v;q.pixelBlock=q.pixelBlock?new h(q.pixelBlock):null;return q})};k.prototype.setLayer=function(m){if(!this._connectionPromise.isFulfilled()||
!this._connection)return a.reject(Error("no connection"));this.rasterLayer=m;m=this._connection.broadcast("setLayer",m,[],{id:null});return d(m)};k.prototype.setRasterFunction=function(m){if(!this._connectionPromise.isFulfilled()||!this._connection)return a.reject(Error("no connection"));m=this._connection.broadcast("setRasterFunction",m,[],{id:null});return d(m)};k.prototype.setRasterRenderer=function(m){if(!this._connectionPromise.isFulfilled()||!this._connection)return a.reject(Error("no connection"));
m=this._connection.broadcast("setRasterRenderer",m,[],{id:null});return d(m)};return k}()})},"esri/layers/vectorTiles/core/workers":function(){define(["require","exports","./workers/workers"],function(G,e,t){Object.defineProperty(e,"__esModule",{value:!0});for(var n in t)e.hasOwnProperty(n)||(e[n]=t[n])})},"esri/layers/vectorTiles/core/workers/workers":function(){define("require exports dojo/sniff dojo/promise/all ../Logger ../promiseUtils ./Connection ./RemoteClient ./WorkerOwner".split(" "),function(G,
e,t,n,p,h,c,a,b){function l(){if(v)return v;for(var q=g+f,r=[],w=function(y){var x=b.create(y).then(function(z){return m[y]=z});r.push(x)},u=0;u<q;u++)w(u);return v=n(r).then(function(){})}Object.defineProperty(e,"__esModule",{value:!0});e.Connection=c;e.RemoteClient=a;(c=navigator.hardwareConcurrency)||(c=t("safari")&&t("mac")||t("trident")?8:2);var g=t("esri-workers-debug")?1:Math.max(1,Math.ceil(c/2)),f=t("esri-workers-debug")?1:Math.max(1,Math.floor(c/2)),d=p.getLogger("esri.core.workers"),k=
0,m=[];e.initialize=function(){l()};e.open=function(q,r,w){void 0===r&&(r={});if(Array.isArray(q))return new e.Connection(q.map(function(x){return new e.RemoteClient(x,r.client)}));if("string"!==typeof q){d.warn("workers-open:signature-deprecated","DEPRECATED: workers.open() changed signature.");var u=q;q=r;r={client:u,strategy:w?"dedicated":"distributed"}}var y=r.strategy||"distributed";return"local"===y?h.create(function(x){G([q],function(z){x(e.RemoteClient.connect(z))})}).then(function(x){return new e.Connection([new e.RemoteClient(x,
r.client)])}):l().then(function(){if("dedicated"===y){var x=g+k++;k%=f;return m[x].open(q).then(function(z){return new e.Connection([new e.RemoteClient(z,r.client)])})}return h.all(m.map(function(z){return z.open(q)})).then(function(z){return new e.Connection(z.map(function(A){return new e.RemoteClient(A,r.client)}))})})};e.terminate=function(){for(var q=0;q<m.length;q++)m[q]&&m[q].terminate();m.length=0};var v})},"esri/layers/vectorTiles/core/Logger":function(){define(["require","exports","dojo/has"],
function(G,e,t){var n={info:0,warn:1,error:2};G=function(){function p(h){void 0===h&&(h={});this.module=h.module||"";this.writer=h.writer||null;this.level=h.level||null;null!=h.enabled&&(this.enabled=!!h.enabled);p._loggers[this.module]=this;h=this.module.lastIndexOf(".");-1!==h&&(this.parent=p.getLogger(this.module.slice(0,h)))}p.prototype.log=function(h){for(var c=[],a=1;a<arguments.length;a++)c[a-1]=arguments[a];this._isEnabled()&&this._matchLevel(h)&&(a=this._inheritedWriter())&&a.apply(void 0,
[h,this.module].concat(c))};p.prototype.error=function(){for(var h=[],c=0;c<arguments.length;c++)h[c]=arguments[c];this.log.apply(this,["error"].concat(h))};p.prototype.warn=function(){for(var h=[],c=0;c<arguments.length;c++)h[c]=arguments[c];this.log.apply(this,["warn"].concat(h))};p.prototype.info=function(){for(var h=[],c=0;c<arguments.length;c++)h[c]=arguments[c];this.log.apply(this,["info"].concat(h))};p.prototype.getLogger=function(h){return p.getLogger(this.module+"."+h)};p.getLogger=function(h){var c=
p._loggers[h];c||(c=new p({module:h}));return c};p.prototype._parentWithMember=function(h,c){for(var a=this;a&&null==a[h];)a=a.parent;return a?a[h]:c};p.prototype._inheritedWriter=function(){return this._parentWithMember("writer",this._consoleWriter)};p.prototype._consoleWriter=function(h,c){for(var a=[],b=2;b<arguments.length;b++)a[b-2]=arguments[b];console[h].apply(console,["["+c+"]"].concat(a))};p.prototype._matchLevel=function(h){return n[this._parentWithMember("level","error")]<=n[h]};p.prototype._isEnabled=
function(){return this._parentWithMember("enabled",!0)};p._loggers={};return p}();e=G.getLogger("esri");t("dojo-debug-messages")?e.level="info":e.level="warn";return G})},"esri/layers/vectorTiles/core/promiseUtils":function(){define("require exports dojo/Deferred dojo/when dojo/promise/all ./Error".split(" "),function(G,e,t,n,p,h){function c(a){if(a){if("function"!==typeof a.forEach){var b=Object.keys(a),l=b.map(function(k){return a[k]});return c(l).then(function(k){var m={};b.forEach(function(v,
q){return m[v]=k[q]});return m})}var g=new t,f=[],d=a.length;0===d&&g.resolve(f);a.forEach(function(k){var m={promise:k};f.push(m);k.then(function(v){m.value=v}).catch(function(v){m.error=v}).then(function(){--d;0===d&&g.resolve(f)})});return g.promise}}Object.defineProperty(e,"__esModule",{value:!0});e.all=function(a){return p(a)};e.filter=function(a,b){var l=a.slice();return p(a.map(function(g,f){return b(g,f)})).then(function(g){return l.filter(function(f,d){return g[d]})})};e.eachAlways=c;e.create=
function(a,b){var l=new t(b);a(function(g){void 0===g&&(g=null);return n(g).then(l.resolve)},l.reject);return l.promise};e.reject=function(a){var b=new t;b.reject(a);return b.promise};e.resolve=function(a){void 0===a&&(a=null);var b=new t;b.resolve(a);return b.promise};e.after=function(a,b){void 0===b&&(b=null);var l=0,g=new t(function(){l&&(clearTimeout(l),l=0)});l=setTimeout(function(){g.resolve(b)},a);return g.promise};e.timeout=function(a,b,l){var g=0,f=new t(a.cancel);a.then(function(d){f.isFulfilled()||
(f.resolve(d),g&&(clearTimeout(g),g=0))});a.catch(function(d){f.isFulfilled()||(f.reject(d),g&&(clearTimeout(g),g=0))});g=setTimeout(function(){var d=l||new h("promiseUtils:timeout","The wrapped promise did not resolve within "+b+" ms");f.reject(d)},b);return f.promise};e.wrapCallback=function(a){var b=!1,l=new t(function(){return b=!0});a(function(g){b||l.resolve(g)});return l.promise};e.isThenable=function(a){return a&&"function"===typeof a.then};e.when=function(a){return n(a)}})},"esri/layers/vectorTiles/core/Error":function(){define(["require",
"exports","./tsSupport/extendsHelper","./lang","./Message"],function(G,e,t,n,p){G=function(h){function c(a,b,l){var g=h.call(this,a,b,l)||this;return g instanceof c?g:new c(a,b,l)}t(c,h);c.prototype.toJSON=function(){return{name:this.name,message:this.message,details:n.clone(this.details),dojoType:this.dojoType}};c.fromJSON=function(a){var b=new c(a.name,a.message,a.details);null!=a.dojoType&&(b.dojoType=a.dojoType);return b};return c}(p);G.prototype.type="error";return G})},"esri/layers/vectorTiles/core/tsSupport/extendsHelper":function(){define([],
function(){return function(){var G=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])};return function(e,t){function n(){this.constructor=e}G(e,t);e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}}()})},"esri/layers/vectorTiles/core/lang":function(){define("dojo/_base/kernel dojo/_base/lang dojo/date dojo/number dojo/date/locale dojo/i18n!../nls/common".split(" "),function(G,e,t,n,
p,h){function c(k){return void 0!==k&&null!==k}function a(k){return c(k)?k:""}function b(k,m,v){var q=v.match(/([^\(]+)(\([^\)]+\))?/i),r=e.trim(q[1]);v=m[k];q=JSON.parse((q[2]?e.trim(q[2]):"{}").replace(/^\(/,"{").replace(/\)$/,"}").replace(/([{,])\s*([0-9a-zA-Z_]+)\s*:/gi,'$1"$2":').replace(/"\s*:\s*'/gi,'":"').replace(/'\s*(,|\})/gi,'"$1'));var w=q.utcOffset;if(-1===f.indexOf(r))r=e.getObject(r),e.isFunction(r)&&(v=r(v,k,m,q));else if("number"===typeof v||"string"===typeof v&&v&&!isNaN(Number(v)))switch(v=
Number(v),r){case "NumberFormat":k=e.mixin({},q);m=parseFloat(k.places);if(isNaN(m)||0>m)k.places=Infinity;return n.format(v,k);case "DateString":v=new Date(v);if(q.local||q.systemLocale)return q.systemLocale?v.toLocaleDateString()+(q.hideTime?"":" "+v.toLocaleTimeString()):v.toDateString()+(q.hideTime?"":" "+v.toTimeString());v=v.toUTCString();q.hideTime&&(v=v.replace(/\s+\d\d:\d\d:\d\d\s+(utc|gmt)/i,""));return v;case "DateFormat":return v=new Date(v),c(w)&&(v=t.add(v,"minute",v.getTimezoneOffset()-
w)),p.format(v,q)}return a(v)}function l(k,m){var v;if(m)for(v in k)k.hasOwnProperty(v)&&(void 0===k[v]?delete k[v]:k[v]instanceof Object&&l(k[v],!0));else for(v in k)k.hasOwnProperty(v)&&void 0===k[v]&&delete k[v];return k}function g(k){if(!k||"object"!=typeof k||e.isFunction(k))return k;if(k instanceof Int8Array||k instanceof Uint8Array||k instanceof Uint8ClampedArray||k instanceof Int16Array||k instanceof Int32Array||k instanceof Uint16Array||k instanceof Uint32Array||k instanceof Float32Array||
k instanceof Float64Array||k instanceof Date)return new k.constructor(k);if(k instanceof ArrayBuffer)return k.slice(0,k.byteLength);if("function"===typeof k.clone)k=k.clone();else if("function"===typeof k.map&&"function"===typeof k.forEach)k=k.map(g);else if("function"===typeof k.notifyChange&&"function"===typeof k.watch)k=k.clone();else{var m={},v,q={};for(v in k){var r=k[v];var w=!(v in q)||q[v]!==r;if(!(v in m)||m[v]!==r&&w)m[v]=g?g(r):r}k=m}return k}var f=["NumberFormat","DateString","DateFormat"],
d=/<\/?[^>]+>/g;return{equals:function(k,m){return k===m||"number"===typeof k&&isNaN(k)&&"number"===typeof m&&isNaN(m)||e.isFunction((k||{}).getTime)&&e.isFunction((m||{}).getTime)&&k.getTime()==m.getTime()||e.isFunction((k||{}).equals)&&k.equals(m)||e.isFunction((m||{}).equals)&&m.equals(k)||!1},mixin:e.mixin,valueOf:function(k,m){for(var v in k)if(k[v]==m)return v;return null},stripTags:function(k){if(k){var m=typeof k;if("string"===m)k=k.replace(d,"");else if("object"===m)for(var v in k)(m=k[v])&&
"string"===typeof m&&(m=m.replace(d,"")),k[v]=m}return k},substitute:function(k,m,v){if(c(v))if(e.isObject(v)){var q=v.first;var r=v.dateFormat;var w=v.numberFormat}else q=v;if(m&&"{*}"!==m)return e.replace(m,e.hitch({obj:k},function(y,x){y=x.split(":");return 1<y.length?(x=y[0],y.shift(),b(x,this.obj,y.join(":"))):r&&-1!==(r.properties||[]).indexOf(x)?b(x,this.obj,r.formatter||"DateString"):w&&-1!==(w.properties||[]).indexOf(x)?b(x,this.obj,w.formatter||"NumberFormat"):a(this.obj[x])}));m=[];var u;
m.push('\x3ctable class\x3d"esri-widget__table" summary\x3d"'+h.fieldsSummary+'"\x3e\x3ctbody\x3e');for(u in k)if(v=k[u],r&&-1!==(r.properties||[]).indexOf(u)?v=b(u,k,r.formatter||"DateString"):w&&-1!==(w.properties||[]).indexOf(u)&&(v=b(u,k,w.formatter||"NumberFormat")),m.push("\x3ctr\x3e\x3cth\x3e"+u+"\x3c/th\x3e\x3ctd\x3e"+a(v)+"\x3c/td\x3e\x3c/tr\x3e"),q)break;m.push("\x3c/tbody\x3e\x3c/table\x3e");return m.join("")},filter:function(k,m,v){m=[e.isString(k)?k.split(""):k,v||G.global,e.isString(m)?
new Function("item","index","array",m):m];v={};var q;k=m[0];for(q in k)m[2].call(m[q],k[q],q,k)&&(v[q]=k[q]);return v},startsWith:function(k,m,v){v=v||0;return k.indexOf(m,v)===v},endsWith:function(k,m,v){if("number"!==typeof v||!isFinite(v)||Math.floor(v)!==v||v>k.length)v=k.length;v-=m.length;k=k.indexOf(m,v);return-1!==k&&k===v},isDefined:c,fixJson:l,clone:g}})},"esri/layers/vectorTiles/core/Message":function(){define(["require","exports","dojo/string"],function(G,e,t){return function(){function n(p,
h,c){this instanceof n&&(this.name=p,this.message=h&&t.substitute(h,c,function(a){return null==a?"":a})||"",this.details=c)}n.prototype.toString=function(){return"["+this.name+"]: "+this.message};return n}()})},"esri/layers/vectorTiles/core/workers/Connection":function(){define(["require","exports","../promiseUtils"],function(G,e,t){return function(){function n(p){this._clientIdx=0;this._clients=p}n.prototype.broadcast=function(p,h,c){for(var a=[],b=0,l=this._clients;b<l.length;b++)a.push(l[b].invoke(p,
h,c));return a};n.prototype.close=function(){for(var p=0,h=this._clients;p<h.length;p++)h[p].close();this._clients=[]};n.prototype.invoke=function(p,h,c,a){var b=a&&a.client;if(!this._clients||!this._clients.length)return t.reject(Error("Connection closed"));null!=b&&-1!==this._clients.indexOf(b)||this._clients.some(function(l){return l.isBusy()?!1:(b=l,!0)})||(this._clientIdx=(this._clientIdx+1)%this._clients.length,b=this._clients[this._clientIdx]);p=b.invoke(p,h,c);a&&(a.client=b);return p};n.prototype.openPorts=
function(){return t.all(this._clients.map(function(p){return p.openPort()}))};return n}()})},"esri/layers/vectorTiles/core/workers/RemoteClient":function(){define("require exports dojo/Deferred ../Error ../promiseUtils ./utils".split(" "),function(G,e,t,n,p,h){function c(k,m){k["delete"](m)}var a=h.MessageType.CLOSE,b=h.MessageType.CANCEL,l=h.MessageType.INVOKE,g=h.MessageType.RESPONSE,f=h.MessageType.OPEN_PORT,d=function(){function k(m){this._timer=null;this._cancelledJobIds=new Set;this._invokeMessages=
[];this._invoke=m;this._timer=null;this._process=this._process.bind(this)}k.prototype.push=function(m){m.type===h.MessageType.CANCEL?this._cancelledJobIds.add(m.jobId):(this._invokeMessages.push(m),null===this._timer&&(this._timer=setTimeout(this._process,0)))};k.prototype.clear=function(){this._invokeMessages.length=0;this._cancelledJobIds.clear();this._timer=null};k.prototype._process=function(){this._timer=null;for(var m=0,v=this._invokeMessages;m<v.length;m++){var q=v[m];this._cancelledJobIds.has(q.jobId)||
this._invoke(q)}this._cancelledJobIds.clear();this._invokeMessages.length=0};return k}();return function(){function k(m,v,q){this._outJobs=new Map;this._inJobs=new Map;this._queue=new d(this._onInvoke.bind(this));this._onMessage=this._onMessage.bind(this);this._client=v;this._port=m;this._port.addEventListener("message",this._onMessage);this._port.start();this._channel=q}k.connect=function(m){var v=new MessageChannel;m="function"===typeof m?new m:"default"in m&&"function"===typeof m.default?new m.default:
m;m.remoteClient=new k(v.port1,m,v);return v.port2};k.prototype.close=function(){this._post({type:a});this._close()};k.prototype.isBusy=function(){return 0<this._outJobs.size};k.prototype.invoke=function(m,v,q){var r=this;if(!this._port)return p.reject(new n("remote-client:port-closed","Can't invoke(), port is closed"));var w=h.newJobId(),u=new t(function(){c(r._outJobs,w);r._post({type:b,jobId:w})});this._outJobs.set(w,u);this._post({type:l,jobId:w,methodName:m},v,q);return u.promise};k.prototype.openPort=
function(){var m=this,v=h.newJobId(),q=new t(function(){c(m._outJobs,v);m._post({type:b,jobId:v})});this._outJobs.set(v,q);this._post({type:f,jobId:v});return q.promise};k.prototype._close=function(){this._channel&&(this._channel=null);this._port.removeEventListener("message",this._onMessage);this._port.close();this._outJobs.forEach(function(m){m.cancel()});this._inJobs.clear();this._outJobs.clear();this._queue.clear();this._port=this._client=null};k.prototype._onMessage=function(m){if(m=h.receiveMessage(m))switch(m.type){case g:this._onResponse(m);
break;case l:this._queue.push(m);break;case b:this._onCancel(m);break;case a:this._close();break;case f:this._onOpenPort(m)}};k.prototype._onCancel=function(m){var v=this._inJobs,q=m.jobId,r=v.get(q);this._queue.push(m);r&&(c(v,q),r.cancel())};k.prototype._onInvoke=function(m){var v=this,q=m.methodName,r=m.jobId;m=m.data;var w=this._inJobs,u=this._client,y=u[q];try{if(!y&&q&&-1!==q.indexOf("."))for(var x=q.split("."),z=0;z<x.length-1;z++)u=u[x[z]],y=u[x[z+1]];if("function"!==typeof y)throw new TypeError(q+
" is not a function");var A=y.call(u,m,this)}catch(E){this._post({type:g,jobId:r,error:h.toInvokeError(E)});return}p.isThenable(A)?(w.set(r,A),A.then(function(E){w.has(r)&&(c(w,r),v._post({type:g,jobId:r},E))}).catch(function(E){w.has(r)&&(c(w,r),E&&"cancel"===E.dojoType||v._post({type:g,jobId:r,error:h.toInvokeError(E||{message:"Error encountered at method "+q})}))})):this._post({type:g,jobId:r},A)};k.prototype._onOpenPort=function(m){var v=new MessageChannel;new k(v.port1,this._client);this._post({type:g,
jobId:m.jobId},v.port2,[v.port2])};k.prototype._onResponse=function(m){var v=m.jobId,q=m.error;m=m.data;var r=this._outJobs;if(r.has(v)){var w=r.get(v);c(r,v);q?w.reject(n.fromJSON(JSON.parse(q))):w.resolve(m)}};k.prototype._post=function(m,v,q){return h.postMessage(this._port,m,v,q)};return k}()})},"esri/layers/vectorTiles/core/workers/utils":function(){define(["require","exports","dojo/has"],function(G,e,t){function n(h){return h&&"object"===typeof h&&("result"in h||"transferList"in h)}Object.defineProperty(e,
"__esModule",{value:!0});(function(h){h[h.HANDSHAKE=0]="HANDSHAKE";h[h.CONFIGURE=1]="CONFIGURE";h[h.CONFIGURED=2]="CONFIGURED";h[h.OPEN=3]="OPEN";h[h.OPENED=4]="OPENED";h[h.RESPONSE=5]="RESPONSE";h[h.INVOKE=6]="INVOKE";h[h.CANCEL=7]="CANCEL";h[h.CLOSE=8]="CLOSE";h[h.OPEN_PORT=9]="OPEN_PORT"})(e.MessageType||(e.MessageType={}));var p=0;e.newJobId=function(){return p++};e.isTranferableResult=n;e.toInvokeError=function(h){return h?h.toJSON?JSON.stringify(h):JSON.stringify({name:h.name,message:h.message,
details:h.details,stack:h.stack}):null};e.postMessage=function(h,c,a,b){2===arguments.length||void 0===a&&void 0===b?h.postMessage(c):(t("esri-workers-supports-transfer-arraybuffer")||(b?(b=b.filter(function(l){return!(l instanceof ArrayBuffer)}),b.length||(b=null)):n(a)&&a.transferList&&(a.transferList=a.transferList.filter(function(l){return!(l instanceof ArrayBuffer)}),a.transferList.length||(a.transferList=null))),b?(c.data=a,h.postMessage(c,b)):n(a)?(c.data=a.result,a.transferList?h.postMessage(c,
a.transferList):h.postMessage(c)):(c.data=a,h.postMessage(c)))};e.receiveMessage=function(h){return h?(h=h.data)?"string"===typeof h?JSON.parse(h):h:null:null}})},"esri/layers/vectorTiles/core/workers/WorkerOwner":function(){define("require exports dojo/Deferred ../../kernel ../Error ../Logger ../promiseUtils ./utils ./workerFactory".split(" "),function(G,e,t,n,p,h,c,a,b){var l=h.getLogger("esri.core.workers"),g=a.MessageType.CANCEL,f=a.MessageType.INVOKE,d=a.MessageType.OPEN,k=a.MessageType.OPENED,
m=a.MessageType.RESPONSE;return function(){function v(q,r){this._outJobs=new Map;this._inJobs=new Map;this.worker=q;this.id=r;q.addEventListener("message",this._onMessage.bind(this));q.addEventListener("error",function(w){w.preventDefault();l.error(w)})}v.create=function(q){return b.createWorker().then(function(r){return new v(r,q)})};v.prototype.terminate=function(){this.worker.terminate()};v.prototype.open=function(q){var r=this,w=a.newJobId(),u=new t(function(y){r._outJobs["delete"](w);r._post({type:g,
jobId:w})});this._outJobs.set(w,u);this._post({type:d,jobId:w,modulePath:q});return u.promise};v.prototype._onMessage=function(q){if(q=a.receiveMessage(q))switch(q.type){case k:case m:this._onResponse(q);break;case g:this._onCancel(q);break;case f:this._onInvoke(q)}};v.prototype._onCancel=function(q){(q=this._inJobs.get(q.jobId))&&q.cancel()};v.prototype._onInvoke=function(q){var r=this,w=q.methodName,u=q.jobId;q=q.data;var y=this._inJobs,x=n.workerMessages[w];try{if("function"!==typeof x)throw new TypeError(w+
" is not a function");var z=x.call(null,q)}catch(A){this._post({type:m,jobId:u,error:a.toInvokeError(A)});return}c.isThenable(z)?(y.set(u,z),z.then(function(A){y["delete"](u);r._post({type:m,jobId:u},A)}).catch(function(A){y["delete"](u);A||(A={message:"Error encountered at method"+w});A.dojoType&&"cancel"===A.dojoType||r._post({type:m,jobId:u,error:a.toInvokeError(A)})})):this._post({type:m,jobId:u},z)};v.prototype._onResponse=function(q){var r=q.jobId,w=q.error;q=q.data;var u=this._outJobs.get(r);
u&&(this._outJobs["delete"](r),w?u.reject(p.fromJSON(JSON.parse(w))):u.resolve(q))};v.prototype._post=function(q,r,w){return a.postMessage(this.worker,q,r,w)};return v}()})},"esri/layers/vectorTiles/core/workers/workerFactory":function(){define("require exports ../tsSupport/assignHelper dojo/_base/kernel ../../config ../../request ../Logger ../promiseUtils ../sniff ../urlUtils ./loaderConfig ./utils ./WorkerFallback".split(" "),function(G,e,t,n,p,h,c,a,b,l,g,f,d){function k(x){return a.create(function(z){function A(F){if(F=
f.receiveMessage(F))switch(F.type){case y:F=x;var B=p.workers.loaderUrl||g.DEFAULT_LOADER_URL;if(null!=p["default"]){var D=t({},p);delete D["default"];D=JSON.parse(JSON.stringify(D))}else D=JSON.parse(JSON.stringify(p));var I=p.workers.loaderConfig;I=g.default({baseUrl:I.baseUrl,locale:n.locale,has:t({"config-deferredInstrumentation":0,"dojo-test-sniff":0,"esri-cors":1,"esri-secure-context":b("esri-secure-context"),"esri-workers-supports-transfer-arraybuffer":b("esri-workers-supports-transfer-arraybuffer"),
"events-keypress-typed":0,"host-webworker":1},I.has),map:t({},I.map),paths:t({},I.paths),packages:I.packages||[]});F.postMessage({type:u,configure:{esriConfig:D,loaderUrl:B,loaderConfig:I}});break;case w:x.removeEventListener("message",A),x.removeEventListener("error",E),z(x)}}function E(F){F.preventDefault();x.removeEventListener("message",A);x.removeEventListener("error",E);q.warn("Failed to create Worker. Fallback to execute module in main thread",F);x=new d;x.addEventListener("message",A);x.addEventListener("error",
E)}x.addEventListener("message",A);x.addEventListener("error",E)})}Object.defineProperty(e,"__esModule",{value:!0});var m=l.normalize(G.toUrl("./worker.js")),v=!l.hasSameOrigin(m,location.href),q=c.getLogger("esri.core.workers"),r=null,w=f.MessageType.CONFIGURED,u=f.MessageType.CONFIGURE,y=f.MessageType.HANDSHAKE;e.createWorker=function(){if(!b("esri-workers"))return k(new d);if(!v){var x=void 0;try{x=new Worker(m)}catch(z){q.warn("Failed to create Worker. Fallback to execute module in main thread",
event),x=new d}return k(x)}r||(r=h(m,{responseType:"text"}));return r.then(function(z){return new Worker(URL.createObjectURL(new Blob([z.data],{type:"text/javascript"})))}).catch(function(z){q.warn("Failed to create Worker. Fallback to execute module in main thread",z);return new d}).then(function(z){return k(z)})}})},"esri/layers/vectorTiles/core/tsSupport/assignHelper":function(){define([],function(){return Object.assign||function(G){for(var e,t=1,n=arguments.length;t<n;t++){e=arguments[t];for(var p in e)Object.prototype.hasOwnProperty.call(e,
p)&&(G[p]=e[p])}return G}})},"esri/layers/vectorTiles/config":function(){define(["require","exports","esri/config"],function(G,e,t){Object.defineProperty(t,"workers",{get:function(){return t.defaults.workers},set:function(n){return t.defaults.workers=n}});return t})},"esri/layers/vectorTiles/request":function(){define(["require","exports","esri/request","dojo/_base/lang","dojo/Deferred"],function(G,e,t,n,p){return function(h,c){h=n.mixin({},{url:h,failOk:!0},c);"array-buffer"===c.responseType?(h.handleAs=
"arraybuffer",delete h.responseType):c.responseType&&(h.handleAs=c.responseType,delete h.responseType);null!==c.query&&(h.content=h.query,delete h.query);if(c.hasOwnProperty("allowImageDataAccess")){var a={allowImageDataAccess:c.allowImageDataAccess};delete h.allowImageDataAccess}var b=new p(function(){l.isFulfilled()||l.cancel()});var l=t(h,a).then(function(g){b.resolve({data:g})}).catch(function(g){g&&null!=g.httpCode&&(g.details=g.details||{},g.details.httpStatus=g.httpCode);b.reject(g)});return b.promise}})},
"esri/layers/vectorTiles/core/sniff":function(){define(["require","exports","dojo/sniff","./global","../views/webgl/context-util"],function(G,e,t,n,p){function h(){var l={available:!1,version:0,majorPerformanceCaveat:!1,supportsHighPrecisionFragment:!1,supportsVertexShaderSamplers:!1,supportsElementIndexUint:!1,supportsStandardDerivatives:!1},g=document.createElement("canvas");if(!g)return l;var f=p.createContext(g,{failIfMajorPerformanceCaveat:!0},"webgl");!f&&(f=p.createContext(g,{},"webgl"))&&
(l.majorPerformanceCaveat=!0);if(!f)return l;g=f.getParameter(f.VERSION);if(!g)return l;if(g=g.match(/^WebGL\s+([\d.]*)/))l.version=parseFloat(g[1]),l.available=.94<=l.version,g=f.getShaderPrecisionFormat(f.FRAGMENT_SHADER,f.HIGH_FLOAT),l.supportsHighPrecisionFragment=g&&0<g.precision,l.supportsVertexShaderSamplers=0<f.getParameter(f.MAX_VERTEX_TEXTURE_IMAGE_UNITS),l.supportsElementIndexUint=null!==f.getExtension("OES_element_index_uint"),l.supportsStandardDerivatives=null!==f.getExtension("OES_standard_derivatives");
return l}function c(){var l={available:!1,version:0},g=document.createElement("canvas");if(!g)return l;g=p.createContext(g,{},"webgl2");if(!g)return l;l.available=!0;g=g.getParameter(g.VERSION);if(!g)return l;if(g=g.match(/^WebGL\s+([\d.]*)/))l.version=parseFloat(g[1]);return l}(function(){var l=navigator.userAgent,g=l.match(/Android|webOS|iPhone|iPad|iPod|BlackBerry|Opera Mini|IEMobile/i);l=l.match(/iPhone/i);g&&t.add("esri-mobile",g);l&&t.add("esri-iPhone",l);t.add("esri-phonegap",!!n.cordova);
t.add("esri-cors",t("esri-phonegap")||"XMLHttpRequest"in n&&"withCredentials"in new XMLHttpRequest);t.add("esri-geolocation",function(){return!!navigator.geolocation});t.add("esri-canvas-svg-support",function(){return!(t("trident")||t("ie"))});t.add("esri-secure-context",function(){if("isSecureContext"in n)return n.isSecureContext;if(n.location&&n.location.origin)return 0===n.location.origin.indexOf("https:")});t.add("esri-wasm","WebAssembly"in n);t("host-webworker")||(t.add("esri-workers","Worker"in
n),t.add("esri-script-sandbox",function(){return"MessageChannel"in n&&"HTMLIFrameElement"in n&&"sandbox"in HTMLIFrameElement.prototype}),t.add("esri-url-encodes-apostrophe",function(){var f=n.document.createElement("a");f.href="?'";return-1<f.href.indexOf("?%27")}),a||(a=h()),t.add("esri-webgl",a.available),t.add("esri-webgl-high-precision-fragment",a.supportsHighPrecisionFragment),t.add("esri-webgl-vertex-shader-samplers",a.supportsVertexShaderSamplers),t.add("esri-webgl-element-index-uint",a.supportsElementIndexUint),
t.add("esri-webgl-standard-derivatives",a.supportsStandardDerivatives),t.add("esri-webgl-major-performance-caveat",a.majorPerformanceCaveat),t.add("esri-featurelayer-webgl-labeling",!0),b||(b=c()),t.add("esri-webgl2",b.available))})();var a=null,b=null;return t})},"esri/layers/vectorTiles/core/global":function(){define(["require","exports"],function(G,e){return function(){if("undefined"!==typeof global)return global;if("undefined"!==typeof window)return window;if("undefined"!==typeof self)return self}()})},
"esri/layers/vectorTiles/views/webgl/context-util":function(){define(["require","exports"],function(G,e){function t(c,a,b){void 0===a&&(a={});switch(b){case "webgl":var l=["webgl","experimental-webgl","webkit-3d","moz-webgl"];break;case "webgl2":l=["webgl2"];break;default:l=["webgl","experimental-webgl","webkit-3d","moz-webgl"]}b=null;for(var g=0;g<l.length;g++){var f=l[g];try{b=c.getContext(f,a)}catch(d){}if(b)break}return b}function n(c,a){(c=c.parentNode)&&(c.innerHTML='\x3ctable style\x3d"background-color: #8CE; width: 100%; height: 100%;"\x3e\x3ctr\x3e\x3ctd align\x3d"center"\x3e\x3cdiv style\x3d"display: table-cell; vertical-align: middle;"\x3e\x3cdiv style\x3d""\x3e'+
a+"\x3c/div\x3e\x3c/div\x3e\x3c/td\x3e\x3c/tr\x3e\x3c/table\x3e")}Object.defineProperty(e,"__esModule",{value:!0});e.createContextOrErrorHTML=function(c,a,b){void 0===a&&(a={});if(!window.WebGLRenderingContext)return n(c,p),null;a=t(c,a,b);return a?a:(n(c,h),null)};e.createContext=t;var p='This page requires a browser that supports WebGL.\x3cbr/\x3e\x3ca href\x3d"http://get.webgl.org"\x3eClick here to upgrade your browser.\x3c/a\x3e',h='It doesn\'t appear your computer can support WebGL.\x3cbr/\x3e\x3ca href\x3d"http://get.webgl.org/troubleshooting/"\x3eClick here for more information.\x3c/a\x3e'})},
"esri/layers/vectorTiles/core/urlUtils":function(){define(["require","exports","esri/urlUtils","dojo/_base/url"],function(G,e,t,n){function p(u){return t.normalize(u)}function h(u){return"data:"===u.slice(0,5)}function c(u){return a(u)||r.test(u)}function a(u){return u&&"/"===u[0]&&"/"===u[1]}function b(u){return t.urlToObject(u)}function l(u){if("string"===typeof u)return new n(f(u));u.scheme||(u.scheme=e.appUrl.scheme);return u}function g(u){if(h(u))return null;var y=u.indexOf("://");if(-1===y&&
a(u))y=2;else if(-1!==y)y+=3;else return null;y=u.indexOf("/",y);return-1===y?u:u.slice(0,y)}function f(u,y,x){void 0===y&&(y=e.appBaseUrl);if(a(u))return x&&x.preserveProtocolRelative?u:"http"===e.appUrl.scheme&&e.appUrl.authority===g(u).slice(2)?"http:"+u:"https:"+u;if(r.test(u))return u;"/"===u[0]&&(x=y.indexOf("//"),x=y.indexOf("/",x+2),y=-1===x?y:y.slice(0,x));return k(y,u)}function d(u,y,x){void 0===x&&(x=!1);u=l(u);y=l(y);return x||u.scheme===y.scheme?u.host.toLowerCase()===y.host.toLowerCase()&&
u.port===y.port:!1}function k(){for(var u=[],y=0;y<arguments.length;y++)u[y]=arguments[y];if(u&&u.length){y=[];if(c(u[0])){var x=u[0],z=x.indexOf("//");y.push(x.slice(0,z+1));q.test(u[0])&&(y[0]+="/");u[0]=x.slice(z+2)}else"/"===u[0][0]&&y.push("");u=u.reduce(function(A,E){return E?A.concat(E.split("/")):A},[]);for(x=0;x<u.length;x++)z=u[x],".."===z&&0<y.length?y.pop():!z||"."===z&&0!==y.length||y.push(z);return y.join("/")}}function m(u,y,x){if(!(y&&x&&u&&c(u)))return u;var z=u.indexOf("//"),A=u.indexOf("/",
z+2),E=u.indexOf(":",z+2);A=Math.min(0>A?u.length:A,0>E?u.length:E);if(u.slice(z+2,A).toLowerCase()!==y.toLowerCase())return u;y=u.slice(0,z+2);u=u.slice(A);return""+y+x+u}function v(u,y,x){void 0===y&&(y=e.appBaseUrl);if(!c(u))return u;var z=p(u),A=z.toLowerCase();y=p(y).toLowerCase().replace(/\/+$/,"");if((x=x?p(x).toLowerCase().replace(/\/+$/,""):null)&&0!==y.indexOf(x))return u;for(var E=function(D,I,M){M=D.indexOf(I,M);return-1===M?D.length:M},F=E(A,"/",A.indexOf("//")+2),B=-1;A.slice(0,F+1)===
y.slice(0,F)+"/";){B=F+1;if(F===A.length)break;F=E(A,"/",F+1)}if(-1===B||x&&B<x.length)return u;u=z.slice(B);z=y.slice(B-1).replace(/[^/]+/g,"").length;if(0<z)for(A=0;A<z;A++)u="../"+u;else u="./"+u;return u}Object.defineProperty(e,"__esModule",{value:!0});e.normalize=p;e.canUseXhr=function(u){return t.canUseXhr(u)};e.removeTrailingSlash=function(u){return u.replace(/\/+$/,"")};G=Function("return this")();e.appUrl=new n(G.location);e.appBaseUrl=function(){var u=e.appUrl.path;u=u.substring(0,u.lastIndexOf(u.split("/")[u.split("/").length-
1]));return e.appUrl.scheme+"://"+e.appUrl.host+(null!=e.appUrl.port?":"+e.appUrl.port:"")+u}();var q=/^\s*file:/i,r=/^\s*[a-z][a-z0-9-+.]*:[^0-9]/i;e.isDataProtocol=h;e.isAbsolute=c;e.isProtocolRelative=a;e.urlToObject=b;e.getOrigin=g;e.makeAbsolute=f;e.hasSameOrigin=d;e.join=k;e.removeFile=function(u){var y=0;if(c(u)){var x=u.indexOf("//");-1!==x&&(y=x+2)}x=u.lastIndexOf("/");return x<y?u:u.slice(0,x+1)};e.addProxy=function(u){return t.addProxy(u)};e.makeData=function(u){return u.isBase64?"data:"+
u.mediaType+";base64,"+u.data:"data:"+u.mediaType+","+u.data};var w=/^data:(.*?)(;base64)?,(.*)$/;e.dataComponents=function(u){return(u=u.match(w))?{mediaType:u[1],isBase64:!!u[2],data:u[3]}:null};e.changeDomain=m;e.read=function(u,y){var x=y&&y.url&&y.url.path;u&&x&&(u=f(u,x,{preserveProtocolRelative:!0}));(y=y&&y.portal)&&!y.isPortal&&y.urlKey&&y.customBaseUrl?(x=y.urlKey+"."+y.customBaseUrl,y=d(e.appUrl,e.appUrl.scheme+"://"+x)?m(u,y.portalHostname,x):m(u,x,y.portalHostname)):y=u;return y};e.write=
function(u,y){if(!u)return u;!c(u)&&y&&y.blockedRelativeUrls&&y.blockedRelativeUrls.push(u);var x=f(u);if(y){var z=y.verifyItemRelativeUrls&&y.verifyItemRelativeUrls.rootPath||y.url&&y.url.path;z&&(x=v(x,z,z),x!==u&&y.verifyItemRelativeUrls&&y.verifyItemRelativeUrls.writtenUrls.push(x))}u=x;x=(y=y&&y.portal)&&!y.isPortal&&y.urlKey&&y.customBaseUrl?m(u,y.urlKey+"."+y.customBaseUrl,y.portalHostname):u;return x};e.makeRelative=v;e.removeQueryParameters=function(u){u=b(u);Object.keys(u.query||{});return u.path}})},
"esri/layers/vectorTiles/core/workers/loaderConfig":function(){define(["require","exports","../tsSupport/assignHelper","dojo/has","../urlUtils"],function(G,e,t,n,p){Object.defineProperty(e,"__esModule",{value:!0});e.DEFAULT_LOADER_URL=p.makeAbsolute(p.removeQueryParameters(G.toUrl("./worker-init.js")));e.DEFAULT_CONFIG={baseUrl:function(){var h=p.removeQueryParameters(G.toUrl("dojo/x.js"));return p.makeAbsolute(h.slice(0,h.length-5))}(),packages:[{name:"esri"},{name:"dojo"},{name:"dojox"},{name:"dstore"},
{name:"moment",main:"moment"},{name:"@dojo"},{name:"cldrjs",main:"dist/cldr"},{name:"globalize",main:"dist/globalize"},{name:"maquette",main:"dist/maquette.umd"},{name:"maquette-css-transitions",main:"dist/maquette-css-transitions.umd"},{name:"maquette-jsx",main:"dist/maquette-jsx.umd"},{name:"tslib",main:"tslib"}],map:{globalize:{cldr:"cldrjs/dist/cldr","cldr/event":"cldrjs/dist/cldr/event","cldr/supplemental":"cldrjs/dist/cldr/supplemental","cldr/unresolved":"cldrjs/dist/cldr/unresolved"}}};e.default=
function(h){var c={async:h.async,isDebug:h.isDebug,locale:h.locale,baseUrl:h.baseUrl,has:t({},h.has),map:t({},h.map),packages:h.packages&&h.packages.concat()||[],paths:t({},h.paths)};h.hasOwnProperty("async")||(c.async=!0);h.hasOwnProperty("isDebug")||(c.isDebug=!1);h.baseUrl||(c.baseUrl=e.DEFAULT_CONFIG.baseUrl);e.DEFAULT_CONFIG.packages.forEach(function(g){a:{for(var f=c.packages,d=0;d<f.length;d++)if(f[d].name===g.name)break a;g=t({},g);d=p.removeQueryParameters(G.toUrl(g.name+"/x.js"));d=d.slice(0,
d.length-5);g.location=p.makeAbsolute(d);f.push(g)}});h=c.map=c.map||{};for(var a=0,b=Object.keys(e.DEFAULT_CONFIG.map);a<b.length;a++){var l=b[a];h[l]||(h[l]=e.DEFAULT_CONFIG.map[l])}return c}})},"esri/layers/vectorTiles/core/workers/WorkerFallback":function(){define(["require","exports","dojo/has","../global","./utils"],function(G,e,t,n,p){var h=function(){return function(){var b=this,l=document.createDocumentFragment();["addEventListener","dispatchEvent","removeEventListener"].forEach(function(g){b[g]=
function(){for(var f=[],d=0;d<arguments.length;d++)f[d]=arguments[d];return l[g].apply(l,f)}})}}(),c=n.MutationObserver||n.WebKitMutationObserver,a=function(){if(n.process&&n.process.nextTick)var b=function(f){n.process.nextTick(f)};else if(n.Promise)b=function(f){n.Promise.resolve().then(f)};else if(c){var l=[],g=document.createElement("div");(new c(function(){for(;0<l.length;)l.shift()()})).observe(g,{attributes:!0});b=function(f){l.push(f);g.setAttribute("queueStatus","1")}}return b}();return function(){function b(){this._dispatcher=
new h;this._isInitialized=!1;this._workerPostMessage({type:p.MessageType.HANDSHAKE})}b.prototype.terminate=function(){};Object.defineProperty(b.prototype,"onmessage",{get:function(){return this._onmessageHandler},set:function(l){this._onmessageHandler&&this.removeEventListener("message",this._onmessageHandler);(this._onmessageHandler=l)&&this.addEventListener("message",l)},enumerable:!0,configurable:!0});Object.defineProperty(b.prototype,"onerror",{get:function(){return this._onerrorHandler},set:function(l){this._onerrorHandler&&
this.removeEventListener("error",this._onerrorHandler);(this._onerrorHandler=l)&&this.addEventListener("error",l)},enumerable:!0,configurable:!0});b.prototype.postMessage=function(l,g){var f=this;a(function(){f._workerMessageHandler(new MessageEvent("message",{data:l}))})};b.prototype.dispatchEvent=function(l){return this._dispatcher.dispatchEvent(l)};b.prototype.addEventListener=function(l,g,f){this._dispatcher.addEventListener(l,g,f)};b.prototype.removeEventListener=function(l,g,f){this._dispatcher.removeEventListener(l,
g,f)};b.prototype._workerPostMessage=function(l,g){var f=this;a(function(){f.dispatchEvent(new MessageEvent("message",{data:l}))})};b.prototype._workerMessageHandler=function(l){var g=this;if(l=p.receiveMessage(l)){var f=l.jobId;switch(l.type){case p.MessageType.CONFIGURE:this._isInitialized||this._workerPostMessage({type:p.MessageType.CONFIGURED});break;case p.MessageType.OPEN:l=l.modulePath,t("esri-webpack")?G(["esri/core/workers/RemoteClient","esri/views/vectorTiles/WorkerTileHandler","esri/views/2d/layers/features/Pipeline",
"esri/views/3d/layers/PointCloudWorker","esri/views/3d/layers/SceneLayerWorker","esri/layers/graphics/sources/support/CSVSourceWorker","esri/views/3d/webgl-engine/lib/edgeRendering/EdgeProcessingWorker",l],function(d,k,m,v,q,r,w,u){switch(u){case "esri/views/vectorTiles/WorkerTileHandler":break;case "esri/views/2d/layers/features/Pipeline":k=m;break;case "esri/views/3d/layers/PointCloudWorker":k=v;break;case "esri/views/3d/layers/SceneLayerWorker":k=q;break;case "esri/layers/graphics/sources/support/CSVSourceWorker":k=
r;break;case "esri/views/3d/webgl-engine/lib/edgeRendering/EdgeProcessingWorker":k=w;break;default:k=u}d=d.connect(k);g._workerPostMessage({type:p.MessageType.OPENED,jobId:f,data:d})}):G(["./RemoteClient",l],function(d,k){d=d.connect(k);g._workerPostMessage({type:p.MessageType.OPENED,jobId:f,data:d})})}}};return b}()})},"esri/layers/vectorTiles/core/requireUtils":function(){define(["require","exports","dojo/Deferred"],function(G,e,t){function n(p,h){if(Array.isArray(h)){var c=new t;p(h,function(){for(var a=
[],b=0;b<arguments.length;b++)a[b]=arguments[b];c.resolve(a)});return c.promise}return n(p,[h]).then(function(a){return a[0]})}Object.defineProperty(e,"__esModule",{value:!0});e.when=n;e.getAbsMid=function(p,h,c){return h.toAbsMid?h.toAbsMid(p):c.id.replace(/\/[^\/]*$/gi,"/")+p}})},"esri/layers/rasterLib/function/rasterFunctionHelper":function(){define(["dojo/_base/declare","dojo/_base/lang","./rasterFunctionRegistry"],function(G,e,t){return{create:function(n,p){if(n){var h=n.renderTexture,c=Object.keys(n);
if(n.read&&!p)return n;n.read&&p&&(n=n.toJson());-1<c.indexOf("name")&&c.indexOf(!1)?(n=e.mixin({},n),p=this._parseV2(n,p)):(n="esri.layers.RasterFunction"===n.declaredClass?n.toJson():e.mixin({},n),p=this._parseV1(n,p));p.branchCount=p.updateBranchStructure();p.renderTexture||(p.renderTexture=!!h);return p}},_parseV1:function(n,p){var h=n.rasterFunction,c=n.rasterFunctionArguments,a=n.renderTexture||n.rasterFunctionArguments.renderTexture||!1,b,l,g,f,d,k,m;(f=c.raster||c.Raster)&&f.rasterFunction&&
(b=this._parseV1(f,p));(f=c.raster2||c.Raster2)&&f.rasterFunction&&(l=this._parseV1(f,p));(f=c.rasters||c.Rasters)&&0<f.length&&(g=f.map(e.hitch(this,function(v){return v&&v.rasterFunction?this._parseV1(v,p):v})));(f=c.dem||c.DEM)&&(f.functionName||f.rasterFunction)&&(d=this._parseV1(f,p));(f=c.fillRaster||c.FillRaster)&&(f.functionName||f.rasterFunction)&&(k=this._parseV1(f,p));f=t.functions[h];if(!f)return console.error("Function is not currently supported: "+h),null;h=new f(c);h.variableName&&
(f=c[h.variableName])&&(f.functionName||f.rasterFunction)&&(m=this._parseV1(f,p));n.outputPixelType&&(h.pixelType=n.outputPixelType);"$$"===b?h.functionArguments.raster=p&&p.raster:null!=b?h.functionArguments.raster=b:h.functionArguments.raster||(h.functionArguments.raster=p&&p.raster);null!=l&&(h.functionArguments.raster2=l);null!=g&&(h.functionArguments.rasters=g.map(function(v){"$$"===v&&(v=p&&p.raster);return v}));null!=d&&(h.functionArguments.dem=d);null!=k&&(h.functionArguments.fillRaster=k);
null!=m&&(h.functionArguments[h.variableName]=m);h.renderTexture=a;return h},_parseV2:function(n,p){if(!n)return null;n=e.clone(n);this._bindV2Args(n,p);var h={};this._convertTov1(n,h);return this._parseV1(h,p)},_bindV2Args:function(n,p){(n||p)&&Object.keys(n).forEach(function(h){n[h]["function"]&&n[h].arguments?this._bindV2Args(n[h].arguments,p):null!=p[n[h].name]&&(n[h].value=p[n[h].name])}.bind(this))},_convertV2Types:function(n){if(!n)return null;"ArgumentArray"===n.type?n.elements&&"RasterStatistics"===
n.elements[0].type&&(n=n.elements):n instanceof Array&&0===n.length&&(n=null);return n},_convertTov1:function(n,p){if((n||p)&&n["function"]){var h=n["function"],c=n.arguments;p.rasterFunction=h.type.replace("Function","");p.outputPixelType="UNKNOWN"===h.pixelType?"Unknown":h.pixelType;p.rasterFunctionArguments={};var a;Object.keys(c).forEach(function(b){c[b]["function"]&&c[b].arguments?(p.rasterFunctionArguments[b]={},this._convertTov1(c[b],p.rasterFunctionArguments[b])):(a=c[b].value,p.rasterFunctionArguments[b]=
"object"!==typeof a||a.functionArguments?a:this._convertV2Types(a))}.bind(this))}}}})},"esri/layers/rasterLib/function/rasterFunctionRegistry":function(){define("dojo/_base/declare dojo/_base/lang ../../rasterLib/function/AspectFunction ../../rasterLib/function/BandArithmeticFunction ../../rasterLib/function/ColormapFunction ../../rasterLib/function/CompositeBandFunction ../../rasterLib/function/ContrastBrightnessFunction ../../rasterLib/function/ConvolutionFunction ../../rasterLib/function/ExtractBandFunction ../../rasterLib/function/HillshadeFunction ../../rasterLib/function/LocalFunction ../../rasterLib/function/MaskFunction ../../rasterLib/function/NDVIFunction ../../rasterLib/function/SlopeFunction ../../rasterLib/function/StretchFunction ../../rasterLib/function/RemapFunction ../../rasterLib/function/IdentityFunction ../../rasterLib/function/ResampleFunction".split(" "),
function(G,e,t,n,p,h,c,a,b,l,g,f,d,k,m,v,q,r){return function(){function w(z){z.prototype.supportWebGL&&(y[z.prototype.functionName]=z);z.prototype.support2D&&(u[z.prototype.functionName]=z);x[z.prototype.functionName]=z}var u={},y={},x={};w(t);w(n);w(p);w(h);w(c);w(a);w(b);w(l);w(g);w(f);w(d);w(k);w(m);w(v);w(q);w(r);return{cpu:u,gpu:y,functions:x,register:w,getFunction:function(z){return x[z]},support:function(z,A){return!!("gpu"===A?y:"cpu"===A?u:x)[z]}}}()})},"esri/layers/rasterLib/function/AspectFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../../WKIDUnitConversion ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin ./surfaceUtils".split(" "),
function(G,e,t,n,p,h,c,a){return G([t,c],{declaredClass:"esri.layers.rasterLib.function.AspectFunction",functionName:"Aspect",supportWebGL:!0,support2D:!0,constructor:function(b){this.functionArguments=this.mixinIgnoreCase({raster:null},b)},bind:function(){var b=this.getSourceRasterInfo();if(!b.raster)return Error("The raster input to aspect function is invalid.");this.rasterInfo=e.mixin(b.raster,{bandCount:1,pixelType:this._calculatePixelType(this.pixelType,"F32"),statistics:[{min:0,max:360}],histograms:null});
this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType="Generic";return!0},read2D:function(b){this._performance.start();b=a.aspect(b.raster);this._addPerformanceMetric(this._performance.elapsed());return b},readGL:function(b){this._performance.start();this._initializeProgram({fragment:h.aspect,fragmentName:"Aspect"});var l=this._setupTextureData(b.raster),g=this.bindFrameBuffer(),f=this.gl,d=f.drawingBufferWidth;f=f.drawingBufferHeight;var k=l.extent;
this._setUniforms({u_resolution:b&&b.raster&&b.raster.pixelBlock?[1/b.raster.pixelBlock.width,1/b.raster.pixelBlock.height]:[1/d,1/f],u_cellSize:[(k.xmax-k.xmin)/d,(k.ymax-k.ymin)/f]});this._bindTexture(l.texture,"u_image");this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:l.extent,texture:g.texture}}})})},"esri/layers/rasterLib/function/RasterFunctionX":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/config ../raster/RasterInfo ../../../geometry/Extent ../../PixelBlock".split(" "),
function(G,e,t,n,p,h){return G(null,{functionName:null,functionArguments:null,pixelType:"Unknown",rasterInfo:null,constructor:function(c){c&&(this.pixelType=c.outputPixelType||c.OutputPixelType||this.pixelType,this.renderTexture=c.renderTexture,this._initFunction())},mixinIgnoreCase:function(c,a){var b=Object.keys(c),l=Object.keys(a),g,f,d=b.length;for(g=0;g<l.length;g++){var k=a[l[g]];if(null!=k)for(f=0;f<d;f++)if(b[f].toLowerCase()===l[g].toLowerCase()){c[b[f]]=k;break}}return c},bind:function(c){},
setProcessingContext:function(c){if(!c)throw"cannot bind to layer without options";this.useWebGL=!!c.useWebGL;this._tileMode=!!c.tileMode;this._glSetting=c.glSetting;this._rawRasterInfo=c.rawRasterInfo;this._xformSetting=c.xformSetting||this._xformSetting;if(!this.useWebGL||this._glSetting&&this._glSetting.gl){this.gl=this.useWebGL?this._glSetting.gl:null;this._glSetting&&(this._glSetting.pingpong=null,this._glSetting.branches=null);var a=this.functionArguments.raster,b=this.functionArguments.raster2,
l=this.functionArguments.dem,g=this.functionArguments.fillRaster,f=this.functionArguments.rasters;a&&a.functionArguments&&a.setProcessingContext(c);b&&b.functionArguments&&b.setProcessingContext(c);l&&l.functionArguments&&l.setProcessingContext(c);g&&g.functionArguments&&g.setProcessingContext(c);if(f)for(a=0;a<f.length;a++)f[a]&&f[a].functionArguments&&f[a].setProcessingContext(c);this.bind()}},updateBranchStructure:function(){var c=0,a=this.functionArguments;a.raster&&a.raster.read&&a.raster.functionArguments&&
(c+=a.raster.updateBranchStructure());a.raster2&&a.raster2.read&&a.raster2.functionArguments&&(c+=a.raster2.updateBranchStructure(),a.raster2.isBranch=!0,a.raster&&a.raster.read&&(a.raster.isBranch=!0));a.rasters&&(c=a.rasters.length,a.rasters.forEach(function(b){b.read&&b.functionArguments&&(b.isBranch=!0)}));a.dem&&a.dem.read&&a.dem.functionArguments&&(c+=a.dem.updateBranchStructure());return 1===c?0:c},read:function(c){c=this.processRasterArgument(c);return this.useWebGL?this.readGL(c):this.read2D(c)},
hasTilingEffects:function(){return!1},read2D:function(){},readGL:function(){},getSourceRasterInfo:function(){var c,a={};if(this.functionArguments.raster2)a.functionArguments.raster=this._bindRaster(this.functionArguments.raster),a.functionArguments.raster2=this._bindRaster(this.functionArguments.raster2);else if(this.functionArguments.rasters)for(a.rasters=[],c=0;c<this.functionArguments.rasters.length;c++)a.rasters[c]=this._bindRaster(this.functionArguments.rasters[c]);else a.raster=this._bindRaster(this.functionArguments.raster);
return this.sourceRasterInfo=a},processRasterArgument:function(c){var a=this.bind();if(!0!==a)throw a;var b={};if(this.functionArguments.raster2)b.raster=this._readRaster(this.functionArguments.raster,c),b.raster2=this._readRaster(this.functionArguments.raster2,c);else if(this.functionArguments.rasters)for(b.rasters=[],a=0;a<this.functionArguments.rasters.length;a++)b.rasters[a]=this._readRaster(this.functionArguments.rasters[a],c);else b.raster=this._readRaster(this.functionArguments.raster,c);return b},
toJson:function(){var c=this.functionArguments,a=c.raster,b=c.raster2;c=c.rasters;a=a?a.toJson?a.toJson():a:null;b=b?b.toJson?b.toJson():b:null;var l;c&&0<c.length&&(l=c.map(function(g){return g.toJson?g.toJson():g}));c=e.mixin({},this.functionArguments);c.raster=a;c.raster2=b;c.rasters=l;c=this._fixRasterFunctionJson(c);return{rasterFunction:this.functionName,rasterFunctionArguments:c,outputPixelType:this.pixelType}},_initFunction:function(c){},_getIntegerRange:function(c){switch(c){case "U8":var a=
[0,255];break;case "U16":a=[0,65535];break;case "U32":a=[0,4294967295];break;case "S8":a=[-128,127];break;case "S16":a=[-32768,32767];break;case "S32":a=[-2147483648,2147483647]}return a},_calculatePixelType:function(c,a){return c&&"unknown"!==c.toLowerCase()?c:a},_clonePixelData:function(c){if(null==c)return c;var a={};c.extent&&(a.extent=new p(c.extent.xmin,c.extent.ymin,c.extent.xmax,c.extent.ymax,c.extent.spatialReference));c=c.pixelBlock;if(null==c)return a;a.pixelBlock=c.clone?c.clone():h.prototype.clone(c);
return a},_readRaster:function(c,a){if(null==c||"$$"===c)var b=this._clonePixelData(a.src[Object.keys(a.src)[0]]);else c&&c.rasterInfo&&!c.functionArguments?b=this._clonePixelData(a.src[c._rasterId]):isNaN(c)?c.read&&(b=c.functionArguments?c.read(a):this._clonePixelData(a)):(b=a.src?a.src[Object.keys(a.src)[0]]:a,a=b.pixelBlock,a=new Float32Array(a.width*a.height),a.fill(parseFloat(c)),b=this._clonePixelData(b),b.pixelBlock.pixels=[a],b.isConstant=!0);return b},_bindRaster:function(c){if(c&&"$$"!==
c)isNaN(c)?c.rasterInfo?a=c.rasterInfo:c.bind&&c.bind()&&(a=c.rasterInfo):a={};else var a=this._rawRasterInfo;a&&(a=a.clone?a.clone():new n(a),a.bandCount=a.bandCount||3);return a},_getOutputBand:function(c,a){switch(c){case "U8":c=new Uint8Array(a);break;case "U16":c=new Uint16Array(a);break;case "U32":c=new Uint32Array(a);break;case "S8":c=new Int8Array(a);break;case "S16":c=new Int16Array(a);break;case "S32":c=new Int32Array(a);break;case "U32":c=new Uint32Array(a);break;case "F32":c=new Float32Array(a);
break;case "F64":c=new Float64Array(a);break;default:c=new Float32Array(a)}return c},_clampBand:function(c,a,b){if(("F64"===a||"F32"===a)&&!b)return c;var l,g=this._getIntegerRange(a),f=c.length;if(g)for(b=g[1],g=g[0],a=this._getOutputBand(a,f),l=0;l<f;l++){var d=c[l];a[l]=d>b?b:d<g?g:d}else a=c;return a},_performance:{start:function(){return this._start=self.performance&&self.performance.now()||new Date}.bind(this),elapsed:function(){return(self.performance&&self.performance.now()||new Date)-this._start}.bind(this)},
_addPerformanceMetric:function(c){t.isDebug&&(self.rasterFunctionPerformance||(self.rasterFunctionPerformance=[]),self.rasterFunctionPerformance.push(c),50<self.rasterFunctionPerformance.length&&self.rasterFunctionPerformance.shift())},_fixRasterFunctionJson:function(c){for(var a in c)c.hasOwnProperty(a)&&(null==c[a]?delete c[a]:c[a]instanceof Object&&!c[a].sourceType&&this._fixRasterFunctionJson(c[a],!0));return c}})})},"esri/layers/rasterLib/function/pixelShaders":function(){define(["dojo/_base/declare",
"dojo/_base/lang","./pixelShaderScripts"],function(G,e,t){G={shaderType:"fragment",getShader:function(n,p){var h=n.createShader(n.FRAGMENT_SHADER);n.shaderSource(h,p);n.compileShader(h);n.getShaderParameter(h,n.COMPILE_STATUS)||(h=null);return h}};e.mixin(G,t);return G})},"esri/layers/rasterLib/function/pixelShaderScripts":function(){define([],function(){return{aspect:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform vec2 u_resolution;\nuniform vec2 u_cellSize;\nfloat getNeighborHoodAlpha(float a, float b, float c, float d, float e, float f, float g, float h, float i){\nif (a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0 || a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0 || a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0) {\nreturn 0.0;\n}\nelse {\nreturn e;\n}\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\nfloat pi \x3d 3.141592653589793238;\nfloat dz_dx \x3d 0.0;\nfloat dz_dy \x3d 0.0;\nvec4 va, vb, vc,vd,ve,vf,vg,vh,vi;\nvec2 axy \x3d vec2(-1.0,-1.0);\nvec2 bxy \x3d vec2(0.0, -1.0);\nvec2 cxy \x3d vec2(1.0, -1.0);\nvec2 dxy \x3d vec2(-1.0, 0.0);\nvec2 fxy \x3d vec2(1.0, 0.0);\nvec2 gxy \x3d vec2(-1.0, 1.0);\nvec2 hxy \x3d vec2(0.0, 1.0);\nvec2 ixy \x3d vec2(1.0, 1.0);\nif (v_texCoord.s \x3c u_resolution.s)\n{\naxy[0] \x3d 1.0;\ndxy[0] \x3d 1.0;\ngxy[0] \x3d 1.0;\n}\nif (v_texCoord.t \x3c u_resolution.t)\n{\naxy[1] \x3d 1.0;\nbxy[1] \x3d 1.0;\ncxy[1] \x3d 1.0;\n}\nif (v_texCoord.s \x3e1.0-u_resolution.s)\n{\ncxy[0] \x3d -1.0;\nfxy[0] \x3d -1.0;\nixy[0] \x3d -1.0;\n}\nif (v_texCoord.t \x3e 1.0- u_resolution.t)\n{\ngxy[1] \x3d -1.0;\nhxy[1] \x3d -1.0;\nixy[1] \x3d -1.0;\n}\nif (v_texCoord.s \x3e\x3d u_resolution.s \x26\x26 (1.0-u_resolution.s)\x3e\x3dv_texCoord.s \x26\x26 v_texCoord.t \x3e\x3d u_resolution.t \x26\x26 (1.0-u_resolution.t)\x3e\x3dv_texCoord.t)\n{\nva \x3d texture2D(u_image, v_texCoord + u_resolution* axy);\nvb \x3d texture2D(u_image, v_texCoord + u_resolution* bxy);\nvc \x3d texture2D(u_image, v_texCoord + u_resolution* cxy);\nvd \x3d texture2D(u_image, v_texCoord + u_resolution* dxy);\nve \x3d texture2D(u_image, v_texCoord + u_resolution* vec2(0, 0));\nvf \x3d texture2D(u_image, v_texCoord + u_resolution* fxy);\nvg \x3d texture2D(u_image, v_texCoord + u_resolution* gxy);\nvh \x3d texture2D(u_image, v_texCoord + u_resolution* hxy);\nvi \x3d texture2D(u_image, v_texCoord + u_resolution* ixy);\n}\ndz_dx \x3d (vc+2.0*vf+vi - va - 2.0*vd - vg).r/(8.0*u_cellSize[0]);\ndz_dy \x3d -(vg+2.0*vh+vi - va - 2.0*vb - vc).r/(8.0*u_cellSize[1]);\nfloat alpha \x3d getNeighborHoodAlpha(va.a, vb.a, vc.a, vd.a, ve.a, vf.a, vg.a, vh.a, vi.a);\nfloat aspect_rad \x3d 0.0;\nif (dz_dx \x3d\x3d 0.0)\n{\nif (dz_dy \x3e 0.0)\naspect_rad \x3d 0.5 * pi;\nelse if (dz_dy \x3c 0.0)\naspect_rad \x3d 1.5 * pi;\nelse\nalpha \x3d 0.0;//undefined make it nodata\n}\nelse\n{\naspect_rad \x3d 0.5*pi + atan(dz_dy, -dz_dx);\nif (aspect_rad \x3c 0.0)\naspect_rad \x3d 2.0*pi + aspect_rad;\n}\nfloat aspect \x3d aspect_rad * 180.0 / pi;\ngl_FragColor \x3d vec4(aspect, aspect, aspect, alpha);\n}",
bandArithmetic:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform int u_bandId_nir;\nuniform int u_bandId_red;\nuniform bool u_scaled;\nuniform int u_bandCount;\nuniform int u_method;\nuniform float u_constants[6];\nvec4 calculateNDVI() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat red \x3d float(u_bandId_red \x3d\x3d 0 ? currentPixel.r : (u_bandId_red \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat nir \x3d float(u_bandId_nir \x3d\x3d 0 ? currentPixel.r : (u_bandId_nir \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat ndvi_denom \x3d nir + red;\nfloat ndvi;\nif (ndvi_denom \x3d\x3d 0.0) {\nndvi \x3d 0.0;\n} else {\nndvi \x3d (nir - red) / ndvi_denom;\nif (u_scaled) {\nndvi \x3d float(floor(ndvi * 100.0 + 100.5));\n}\n}\nreturn vec4(ndvi, ndvi, ndvi, currentPixel.a);\n}\nvec4 calculateSAVI() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat red \x3d float(u_bandId_red \x3d\x3d 0 ? currentPixel.r : (u_bandId_red \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat nir \x3d float(u_bandId_nir \x3d\x3d 0 ? currentPixel.r : (u_bandId_nir \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat savi_denom \x3d nir + red + u_constants[0];\nfloat savi;\nif (savi_denom \x3d\x3d 0.0) {\nsavi \x3d 0.0;\n} else {\nsavi \x3d (nir - red) / savi_denom * (1.0 + u_constants[0]);\n}\nreturn vec4(savi, savi, savi, currentPixel.a);\n}\nvec4 calculateMSAVI() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat red \x3d float(u_bandId_red \x3d\x3d 0 ? currentPixel.r : (u_bandId_red \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat nir \x3d float(u_bandId_nir \x3d\x3d 0 ? currentPixel.r : (u_bandId_nir \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat msavi \x3d 0.5 * (2.0 * (nir + 1.0) - sqrt(pow((2.0 * nir + 1.0), 2.0) - 8.0 * (nir - red)));\nreturn vec4(msavi, msavi, msavi, currentPixel.a);\n}\nvec4 calculateTSAVI() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat red \x3d float(u_bandId_red \x3d\x3d 0 ? currentPixel.r : (u_bandId_red \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat nir \x3d float(u_bandId_nir \x3d\x3d 0 ? currentPixel.r : (u_bandId_nir \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat s \x3d u_constants[0];\nfloat a \x3d u_constants[1];\nfloat x \x3d u_constants[2];\nfloat tsavi_denom \x3d a * nir + red - a * s + x * (1.0 + s * s);\nfloat tsavi;\nif (tsavi_denom \x3d\x3d 0.0) {\ntsavi \x3d 0.0;\n} else {\ntsavi \x3d s * (nir - s * red - a) / tsavi_denom;\n}\nreturn vec4(tsavi, tsavi, tsavi, currentPixel.a);\n}\nvec4 calculatePVI() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat red \x3d float(u_bandId_red \x3d\x3d 0 ? currentPixel.r : (u_bandId_red \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat nir \x3d float(u_bandId_nir \x3d\x3d 0 ? currentPixel.r : (u_bandId_nir \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat a \x3d u_constants[0];\nfloat b \x3d u_constants[1];\nfloat pvi \x3d (nir - a * red - b) / sqrt(1.0 + a * 2.0);\nreturn vec4(pvi, pvi, pvi, currentPixel.a);\n}\nvec4 calculateGEMI() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat red \x3d float(u_bandId_red \x3d\x3d 0 ? currentPixel.r : (u_bandId_red \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat nir \x3d float(u_bandId_nir \x3d\x3d 0 ? currentPixel.r : (u_bandId_nir \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat gemi;\nif (red \x3d\x3d 1.0) {\ngemi \x3d 0.0;\n} else {\nfloat eta \x3d (2.0 * (nir * nir - red * red) + 1.5 * nir + 0.5 * red) / (nir + red + 0.5);\nfloat gemi \x3d eta * (1.0 - 0.25*eta) - (red - 0.125) / (1.0 - red);\n}\nreturn vec4(gemi, gemi, gemi, currentPixel.a);\n}\nvec4 calculateVARI() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat red \x3d float(currentPixel.r);\nfloat green \x3d float(currentPixel.g);\nfloat blue \x3d float(currentPixel.b);\nfloat vari \x3d (green - red) /(green + red - blue);\nreturn vec4(vari, vari, vari, currentPixel.a);\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\nvec4 pv;\nif (u_method \x3c 4) {\nif (u_method \x3d\x3d 1) {\npv \x3d calculateNDVI();\n} else if (u_method \x3d\x3d 2) {\npv \x3d calculateSAVI();\n} else if (u_method \x3d\x3d 3) {\npv \x3d calculateTSAVI();\n} else if (u_method \x3d\x3d 4) {\npv \x3d calculateMSAVI();\n}\n} else {\nif (u_method \x3d\x3d 5) {\npv \x3d calculateGEMI();\n} else if (u_method \x3d\x3d 6) {\npv \x3d calculatePVI();\n} else if (u_method \x3d\x3d 7) {\npv \x3d calculateGEMI();\n} else if (u_method \x3d\x3d 9) {\npv \x3d calculateVARI();\n}\n}\ngl_FragColor \x3d pv;\n}",
colormap:"precision mediump float;\nuniform sampler2D u_image;\nuniform sampler2D u_image1;\nvarying vec2 v_texCoord;\nuniform float u_indexedColormapOffset;\nuniform float u_indexedColormapMaxIndex;\nvec4 colorize() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat clrIndex \x3d currentPixel.r - u_indexedColormapOffset;\nvec4 result;\nif (currentPixel.a \x3d\x3d 0.0 || clrIndex \x3e u_indexedColormapMaxIndex) {\nresult \x3d vec4(0.0, 0.0, 0.0, 0.0);\n}\nelse {\nvec2 clrPosition \x3d vec2(clrIndex / u_indexedColormapMaxIndex, 0.0);\nvec4 color \x3d texture2D(u_image1, clrPosition);\nresult \x3d vec4(color.r, color.g, color.b, color.a);\n}\nreturn result;\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d colorize();\n}",
compositeBand:"precision mediump float;\nuniform sampler2D u_image;\nuniform sampler2D u_image1;\nuniform sampler2D u_image2;\nvarying vec2 v_texCoord;\nuniform int u_rasterCount;\nvec4 composite() {\nvec4 p0, p1, p2;\np0 \x3d texture2D(u_image, v_texCoord);\nvec4 result;\nif (u_rasterCount \x3d\x3d 1){\nresult \x3d p0;\n}\nelse if (u_rasterCount \x3d\x3d 2){\np1 \x3d texture2D(u_image1, v_texCoord);\nresult \x3d vec4(p0.r,p1.r,0.0,min(p0.a,p1.a));\n}\nelse if (u_rasterCount \x3d\x3d 3){\np1 \x3d texture2D(u_image1, v_texCoord);\np2 \x3d texture2D(u_image2, v_texCoord);\nresult \x3d vec4(p0.r,p1.r,p2.r,min(min(p0.a,p1.a),p2.a));\n}\nreturn result;\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d composite();\n}",
constant:"precision mediump float;\nuniform vec4 u_color;\nvoid main() {\ngl_FragColor \x3d u_color;\n}",contrastBrightness:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform float u_contrastOffset;\nuniform float u_brightnessOffset;\nuniform float u_scaleFactor;\nvec4 adjustContrastBrightness() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat c \x3d u_contrastOffset;\nfloat b \x3d u_brightnessOffset;\nfloat maxI \x3d 255.0;\nfloat mid \x3d 128.0;\nvec4 v;\nif (c \x3e 0.0 \x26\x26 c \x3c 100.0) {\nv \x3d (200.0 * currentPixel - 100.0 * maxI + 2.0 * maxI * b) / (2.0 * (100.0 - c)) + mid;\n} else if (c \x3c\x3d 0.0 \x26\x26 c \x3e -100.0) {\nv \x3d (200.0 * currentPixel - 100.0 * maxI + 2.0 * maxI * b) * (100.0 + c) / 20000.0 + mid;\n} else if (c \x3d\x3d 100.0) {\nv \x3d (200.0 * currentPixel - 100.0 * maxI + (maxI + 1.0) * (100.0 - c) + 2.0 * maxI * b);\nv \x3d (sign(v) + 1.0) / 2.0; //binary contrast with extra mid tone at 0.5\n} else if (c \x3d\x3d -100.0) {\nv \x3d vec4(mid, mid, mid, currentPixel.a); //no contrast\n}\nreturn vec4(v.r / u_scaleFactor, v.g / u_scaleFactor, v.b / u_scaleFactor, currentPixel.a);\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d adjustContrastBrightness();\n}",
convolution:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform vec2 u_resolution;\nuniform float u_kernel[25];\nuniform int u_kernelSize;\nvec4 convolve33(){\nvec4 vp11, vp12, vp13, vp21, vp22, vp23, vp31, vp32, vp33;\nvec2 xy11 \x3d vec2(-1.0, -1.0);\nvec2 xy12 \x3d vec2(0.0, -1.0);\nvec2 xy13 \x3d vec2(1.0, -1.0);\nvec2 xy21 \x3d vec2(-1.0, 0.0);\nvec2 xy23 \x3d vec2(1.0, 0.0);\nvec2 xy31 \x3d vec2(-1.0, 1.0);\nvec2 xy32 \x3d vec2(0.0, 1.0);\nvec2 xy33 \x3d vec2(1.0, 1.0);\nif (v_texCoord.s \x3c u_resolution.s) {\nxy11[0] \x3d 1.0;\nxy21[0] \x3d 1.0;\nxy31[0] \x3d 1.0;\n}\nif (v_texCoord.t \x3c u_resolution.t) {\nxy11[1] \x3d 1.0;\nxy12[1] \x3d 1.0;\nxy13[1] \x3d 1.0;\n}\nif (v_texCoord.s \x3e 1.0 - u_resolution.s) {\nxy13[0] \x3d -1.0;\nxy23[0] \x3d -1.0;\nxy33[0] \x3d -1.0;\n}\nif (v_texCoord.t \x3e 1.0 - u_resolution.t) {\nxy31[1] \x3d -1.0;\nxy32[1] \x3d -1.0;\nxy33[1] \x3d -1.0;\n}\nvec4 convolResult \x3d\ntexture2D(u_image, v_texCoord + u_resolution * xy11) * u_kernel[0] +\ntexture2D(u_image, v_texCoord + u_resolution * xy12) * u_kernel[1] +\ntexture2D(u_image, v_texCoord + u_resolution * xy13) * u_kernel[2] +\ntexture2D(u_image, v_texCoord + u_resolution * xy21) * u_kernel[3] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(0, 0)) * u_kernel[4] +\ntexture2D(u_image, v_texCoord + u_resolution * xy23) * u_kernel[5] +\ntexture2D(u_image, v_texCoord + u_resolution * xy31) * u_kernel[6] +\ntexture2D(u_image, v_texCoord + u_resolution * xy32) * u_kernel[7] +\ntexture2D(u_image, v_texCoord + u_resolution * xy33) * u_kernel[8];\nreturn vec4(convolResult.rgb, texture2D(u_image, v_texCoord).a);\n}\nvec4 convolve55(){\nvec4 vp11, vp12, vp13, vp21, vp22, vp23, vp31, vp32, vp33;\nfloat xdif[5];//https://www.opengl.org/wiki/Data_Type_(GLSL) array constructor ES3.0\nfloat ydif[5];\nfloat a \x3d -2.0;\nfor (int i\x3d0; i\x3c5; i++){\nxdif[i] \x3d a;\nydif[i] \x3d a;\na++;\n}\nif (v_texCoord.s \x3c u_resolution.s *2.0) { //2 pixel\nxdif[0] \x3d 2.0;\nif (v_texCoord.s \x3c u_resolution.s) { //1 pixel\nxdif[1] \x3d 1.0;\n}\n}\nelse if (v_texCoord.s \x3e 1.0 - u_resolution.s *2.0) {\nxdif[0] \x3d -2.0;\nif (v_texCoord.s \x3e 1.0 - u_resolution.s) {\nxdif[1] \x3d -1.0;\n}\n}\nif (v_texCoord.t \x3c u_resolution.t *2.0) {\nydif[0] \x3d 2.0;\nif (v_texCoord.t \x3c u_resolution.t) {\nydif[1] \x3d 1.0;\n}\n}\nelse if (v_texCoord.t \x3e 1.0 - u_resolution.t*2.0) {\nydif[0] \x3d -2.0;\nif (v_texCoord.t \x3e 1.0 - u_resolution.t) {\nydif[1] \x3d -1.0;\n}\n}\nvec4 convolResult \x3d\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[0], ydif[0])) * u_kernel[0] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[1], ydif[0])) * u_kernel[1] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[2], ydif[0])) * u_kernel[2] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[3], ydif[0])) * u_kernel[3] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[4], ydif[0])) * u_kernel[4] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[0], ydif[1])) * u_kernel[5] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[1], ydif[1])) * u_kernel[6] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[2], ydif[1])) * u_kernel[7] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[3], ydif[1])) * u_kernel[8] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[4], ydif[1])) * u_kernel[9] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[0], ydif[2])) * u_kernel[10] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[1], ydif[2])) * u_kernel[11] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[2], ydif[2])) * u_kernel[12] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[3], ydif[2])) * u_kernel[13] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[4], ydif[2])) * u_kernel[14] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[0], ydif[3])) * u_kernel[15] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[1], ydif[3])) * u_kernel[16] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[2], ydif[3])) * u_kernel[17] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[3], ydif[3])) * u_kernel[18] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[4], ydif[3])) * u_kernel[19] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[0], ydif[4])) * u_kernel[20] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[1], ydif[4])) * u_kernel[21] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[2], ydif[4])) * u_kernel[22] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[3], ydif[4])) * u_kernel[23] +\ntexture2D(u_image, v_texCoord + u_resolution * vec2(xdif[4], ydif[4])) * u_kernel[24];\nreturn vec4(convolResult.rgb, texture2D(u_image, v_texCoord).a);\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\nif (u_kernelSize \x3d\x3d 9){\ngl_FragColor \x3d convolve33();\n}\nelse {\ngl_FragColor \x3d convolve55();\n}\n}",
extractBand:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform int u_bandIDs[3];\nuniform bool u_alterBand;\nvec4 extractBand() {\nvec4 p \x3d texture2D(u_image, v_texCoord);\nif (!u_alterBand){\nreturn p;\n}\nfloat r, g, b;\nif (u_bandIDs[0] \x3d\x3d0){\nr \x3d p.r;\n}\nelse if (u_bandIDs[0] \x3d\x3d1){\nr \x3d p.g;\n}\nelse if (u_bandIDs[0] \x3d\x3d2){\nr \x3d p.b;\n}\nif (u_bandIDs[1] \x3d\x3d0){\ng \x3d p.r;\n}\nelse if (u_bandIDs[1] \x3d\x3d1){\ng \x3d p.g;\n}\nelse if (u_bandIDs[1] \x3d\x3d2){\ng \x3d p.b;\n}\nif (u_bandIDs[2] \x3d\x3d0){\nb \x3d p.r;\n}\nelse if (u_bandIDs[2] \x3d\x3d1){\nb \x3d p.g;\n}\nelse if (u_bandIDs[2] \x3d\x3d2){\nb \x3d p.b;\n}\nreturn vec4(r, g, b, p.a);\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d extractBand();\n}",
hillshade:"precision mediump float;\nuniform sampler2D u_image;\nuniform sampler2D u_image1;\nvarying vec2 v_texCoord;\nuniform vec2 u_resolution;\nuniform int u_slopeType;\nuniform int u_hillshadeType;\nuniform int u_lightSourceCount;\nuniform float u_sinZcosA;\nuniform float u_sinZsinA;\nuniform float u_cosZ;\nuniform float u_sinZcosAs[6];\nuniform float u_sinZsinAs[6];\nuniform float u_cosZs[6];\nuniform float u_weights[6];\nuniform float u_xFactor;\nuniform float u_yFactor;\nuniform bool u_scaled;\nuniform float u_minValue;\nuniform float u_maxValue;\nuniform bool u_applyColorramp;\nuniform float u_indexedColormapOffset;\nuniform float u_indexedColormapMaxIndex;\nuniform vec2 u_rawResolution;\nuniform int u_resampling;\nvec4 getPixelValue(vec2 coords) {\nif (u_resampling \x3d\x3d 0) {\nreturn texture2D(u_image, coords);\n}\nvec2 pos_ul \x3d floor(coords / u_rawResolution) * u_rawResolution;\nvec2 pos_ur \x3d pos_ul + vec2(1.0, 0.0) * u_rawResolution;\nvec2 pos_ll \x3d pos_ul + vec2(0.0, 1.0) * u_rawResolution;\nvec2 pos_lr \x3d pos_ul + vec2(1.0, 1.0) * u_rawResolution;\nvec2 weight \x3d fract(coords / u_rawResolution);\nvec4 vp_ul \x3d texture2D(u_image, pos_ul);\nvec4 vp_ur \x3d texture2D(u_image, pos_ur);\nvec4 vp_ll \x3d texture2D(u_image, pos_ll);\nvec4 vp_lr \x3d texture2D(u_image, pos_lr);\nvec4 vp \x3d mix(mix(vp_ul, vp_ur, weight.x), mix(vp_ll, vp_lr, weight.x), weight.y);\nreturn vp;\n}\nfloat getNeighborHoodAlpha(float a, float b, float c, float d, float e, float f, float g, float h, float i){\nif (a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0 || a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0 || a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0) {\nreturn 0.0;\n}\nelse {\nreturn e;\n}\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvec3 rgb2hsv(vec3 c) {\nvec4 K \x3d vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec4 p \x3d c.g \x3c c.b ? vec4(c.bg, K.wz) : vec4(c.gb, K.xy);\nvec4 q \x3d c.r \x3c p.x ? vec4(p.xyw, c.r) : vec4(c.r, p.yzx);\nfloat d \x3d q.x - min(q.w, q.y);\nfloat e \x3d 1.0e-10;\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), min(d / (q.x + e), 1.0), q.x);\n}\nvec3 hsv2rgb(vec3 c) {\nvec4 K \x3d vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 p \x3d abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\nreturn c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\nvec4 overlay(float val, float minValue, float maxValue, float hillshade, float alpha) {\nfloat clrIndex \x3d clamp((val - minValue) / (maxValue - minValue), 0.0, 1.0);\nvec4 rgb \x3d texture2D(u_image1, vec2(clrIndex, 0.0));\nvec3 hsv \x3d rgb2hsv(rgb.xyz);\nhsv.z \x3d hillshade;\nreturn vec4(hsv2rgb(hsv) * alpha, alpha);\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\nvec4 va, vb, vc, vd, ve, vf, vg, vh, vi;\nvec2 axy \x3d vec2(-1.0, -1.0);\nvec2 bxy \x3d vec2(0.0, -1.0);\nvec2 cxy \x3d vec2(1.0, -1.0);\nvec2 dxy \x3d vec2(-1.0, 0.0);\nvec2 fxy \x3d vec2(1.0, 0.0);\nvec2 gxy \x3d vec2(-1.0, 1.0);\nvec2 hxy \x3d vec2(0.0, 1.0);\nvec2 ixy \x3d vec2(1.0, 1.0);\nif (v_texCoord.s \x3c u_resolution.s) {\naxy[0] \x3d 1.0;\ndxy[0] \x3d 1.0;\ngxy[0] \x3d 1.0;\n}\nif (v_texCoord.t \x3c u_resolution.t) {\naxy[1] \x3d 1.0;\nbxy[1] \x3d 1.0;\ncxy[1] \x3d 1.0;\n}\nif (v_texCoord.s \x3e 1.0 - u_resolution.s) {\ncxy[0] \x3d -1.0;\nfxy[0] \x3d -1.0;\nixy[0] \x3d -1.0;\n}\nif (v_texCoord.t \x3e 1.0 - u_resolution.t) {\ngxy[1] \x3d -1.0;\nhxy[1] \x3d -1.0;\nixy[1] \x3d -1.0;\n}\nva \x3d texture2D(u_image, v_texCoord + u_resolution * axy);\nvb \x3d texture2D(u_image, v_texCoord + u_resolution * bxy);\nvc \x3d texture2D(u_image, v_texCoord + u_resolution * cxy);\nvd \x3d texture2D(u_image, v_texCoord + u_resolution * dxy);\nve \x3d texture2D(u_image, v_texCoord + u_resolution * vec2(0, 0));\nvf \x3d texture2D(u_image, v_texCoord + u_resolution * fxy);\nvg \x3d texture2D(u_image, v_texCoord + u_resolution * gxy);\nvh \x3d texture2D(u_image, v_texCoord + u_resolution * hxy);\nvi \x3d texture2D(u_image, v_texCoord + u_resolution * ixy);\nfloat alpha \x3d getNeighborHoodAlpha(va.a, vb.a, vc.a, vd.a, ve.a, vf.a, vg.a, vh.a, vi.a);\nfloat dzx \x3d (vc + 2.0 * vf + vi - va - 2.0 * vd - vg).r * u_xFactor;\nfloat dzy \x3d (vg + 2.0 * vh + vi - va - 2.0 * vb - vc).r * u_yFactor; //flip\nfloat s2 \x3d sqrt(1.0 + dzx * dzx + dzy * dzy);\nfloat hillshade \x3d 0.0;\nif (u_hillshadeType \x3d\x3d 0){\nfloat cosDelta \x3d u_sinZsinA * dzy - u_sinZcosA * dzx;\nfloat z \x3d (u_cosZ + cosDelta) / s2;\nif (z \x3c 0.0)  z \x3d 0.0;\nhillshade \x3d z;\n}\nelse if (u_hillshadeType \x3d\x3d 1){\nfor (int k \x3d 0; k \x3c 6; k++) {\nfloat cosDelta \x3d u_sinZsinAs[k] * dzy - u_sinZcosAs[k] * dzx;\nfloat z \x3d (u_cosZs[k] + cosDelta) / s2;\nif (z \x3c 0.0) z \x3d 0.0;\nhillshade \x3d hillshade + z * u_weights[k];\nif (k \x3d\x3d u_lightSourceCount-1) break;\n}\n}\nif (u_applyColorramp) {\nvec4 result \x3d overlay(ve.r, u_minValue, u_maxValue, hillshade, alpha);\nif (u_scaled) {\nresult \x3d vec4(result.rgb * 255.0, result.a);\n}\ngl_FragColor \x3d result;\n} else {\nif (u_scaled) {\nhillshade \x3d hillshade * 255.0;\nif (hillshade\x3e 255.0) {\nhillshade \x3d 255.0;\n}\n}\ngl_FragColor \x3d vec4(hillshade, hillshade, hillshade, alpha);\n}\n}",
identity:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform int u_bandCount;\nfloat shift_right(float v, float amt) {\nv \x3d floor(v) + 0.5;\nreturn floor(v / exp2(amt));\n}\nfloat shift_left(float v, float amt) {\nreturn floor(v * exp2(amt) + 0.5);\n}\nfloat mask_last(float v, float bits) {\nreturn mod(v, shift_left(1.0, bits));\n}\nfloat extract_bits(float num, float from, float to) {\nfrom \x3d floor(from + 0.5);\nto \x3d floor(to + 0.5);\nreturn mask_last(shift_right(num, from), to - from);\n}\nvec4 encode_float(float val) {\nif (val \x3d\x3d 0.0)\nreturn vec4(0, 0, 0, 0);\nfloat sign \x3d val \x3e 0.0 ? 0.0 : 1.0;\nval \x3d abs(val);\nfloat exponent \x3d floor(log2(val));\nfloat biased_exponent \x3d exponent + 127.0;\nfloat fraction \x3d ((val / exp2(exponent)) - 1.0) * 8388608.0;\nfloat t \x3d biased_exponent / 2.0;\nfloat last_bit_of_biased_exponent \x3d fract(t) * 2.0;\nfloat remaining_bits_of_biased_exponent \x3d floor(t);\nfloat byte4 \x3d extract_bits(fraction, 0.0, 8.0) / 255.0;\nfloat byte3 \x3d extract_bits(fraction, 8.0, 16.0) / 255.0;\nfloat byte2 \x3d (last_bit_of_biased_exponent * 128.0 + extract_bits(fraction, 16.0, 23.0)) / 255.0;\nfloat byte1 \x3d (sign * 128.0 + remaining_bits_of_biased_exponent) / 255.0;\nreturn vec4(byte4, byte3, byte2, byte1);\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\nvec4 currentPixel \x3d  texture2D(u_image, v_texCoord);\ngl_FragColor \x3d vec4( currentPixel.rgb, currentPixel.a); //encode_float(currentPixel.r);\n}",
local:"precision mediump float;\nuniform sampler2D u_image;\nuniform sampler2D u_image1;\nuniform sampler2D u_image2;\nvarying vec2 v_texCoord;\nuniform int u_rasterCount;\nvec4 polyfill;\nvec4 localOp1() {\nvec4 a \x3d texture2D(u_image, v_texCoord);\nvec4 result;\nvec4 replaceme1;\nreturn result;\n}\nvec4 localOp2() {\nvec4 a \x3d texture2D(u_image, v_texCoord);\nvec4 b \x3d texture2D(u_image1, v_texCoord);\nvec4 result;\nvec4 replaceme2;\nreturn result;\n}\nvec4 localOp3() {\nvec4 a \x3d texture2D(u_image, v_texCoord);\nvec4 b \x3d texture2D(u_image1, v_texCoord);\nvec4 c \x3d texture2D(u_image2, v_texCoord);\nvec4 result;\nvec4 replaceme3;\nreturn result;\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d localOp1();\n}",
local0:"precision mediump float;\nuniform sampler2D u_image0;\nuniform sampler2D u_image1;\nvarying vec2 v_texCoord;\nuniform float u_minCutOff[3];\nuniform float u_maxCutOff[3];\nuniform float u_minOutput[3];\nuniform float u_maxOutput[3];\nuniform float u_factor[3];\nuniform int u_operation;\nuniform int u_constant[3];\nuniform vec4 gamma;\nfloat localOperate1(float a, float b, float c){\nfloat result;\nif (u_operation \x3d\x3d 1){\nresult \x3d a + b;\n}\nelse if (u_operation \x3d\x3d 2){\nresult \x3d a - b;\n}\nelse if (u_operation \x3d\x3d3){\nresult \x3d a * b;\n}\nelse if (u_operation \x3d\x3d4){\nresult \x3d sqrt(a);\n}\nelse if (u_operation \x3d\x3d5){\nresult \x3d pow(a, b);\n}\nelse if (u_operation \x3d\x3d6){\nresult \x3d acos(a);\n}\nelse if (u_operation \x3d\x3d7){\nresult \x3d asin(a);\n}\nelse if (u_operation \x3d\x3d8){\nresult \x3d atan(a);\n}\nelse if (u_operation \x3d\x3d9){\nresult \x3d 999.0; //atanh not available\n}\nelse if (u_operation \x3d\x3d10){\nresult \x3d abs(a);\n}\nelse if (u_operation \x3d\x3d13){\nresult \x3d 999.0; //bitwise not available\n}\nelse if (u_operation \x3d\x3d17){\nresult \x3d a !\x3d 0.0 \x26\x26 b !\x3d0.0;\n}\nelse if (u_operation \x3d\x3d18){\nresult \x3d a \x3d\x3d0.0? 1.0:0.0;\n}\nelse if (u_operation \x3d\x3d19){\nresult \x3d a !\x3d 0.0 || b !\x3d0.0;\n}\nelse if (u_operation \x3d\x3d20){\nresult \x3d a !\x3d 0.0 ^^ b !\x3d0.0; //exclusive or\n}\nelse if (u_operation \x3d\x3d21){\nresult \x3d cos(a);\n}\nelse if (u_operation \x3d\x3d23){\nresult \x3d a / b;\n}\nelse if (u_operation \x3d\x3d24){\nresult \x3d a \x3d\x3d b ? 1.0:0.0;\n}\nelse if (u_operation \x3d\x3d25){\nresult \x3d exp(a);\n}\nelse if (u_operation \x3d\x3d26){\nresult \x3d pow(10.0, a);\n}\nelse if (u_operation \x3d\x3d27){\nresult \x3d exp2(a);\n}\nelse if (u_operation \x3d\x3d28){\nresult \x3d a \x3e b? 1.0 : 0.0;\n}\nelse if (u_operation \x3d\x3d29){\nresult \x3d  a \x3e\x3d b? 1.0 : 0.0;\n}\nelse if (u_operation \x3d\x3d30){\nresult \x3d floor(a); //int\n}\nelse if (u_operation \x3d\x3d31){\nresult \x3d a \x3d\x3d0? 1.0:0.0; //null pass mask\n}\nelse if (u_operation \x3d\x3d32){\nresult \x3d a; //float\n}\nelse if (u_operation \x3d\x3d33){\nresult \x3d a \x3c b? 1.0 : 0.0;\n}\nelse if (u_operation \x3d\x3d34){\nresult \x3d a \x3c\x3d b? 1.0 : 0.0;\n}\nelse if (u_operation \x3d\x3d35){\nresult \x3d log(a);\n}\nelse if (u_operation \x3d\x3d36){\nresult \x3d log2(a) / log2(10.0);\n}\nelse if (u_operation \x3d\x3d37){\nresult \x3d log2(a);\n}\nelse if (u_operation \x3d\x3d44){\nresult \x3d mod(a, b);\n}\nelse if (u_operation \x3d\x3d45){\nresult \x3d -a;\n}\nelse if (u_operation \x3d\x3d46){\nresult \x3d a !\x3d b? 1.0 : 0.0;\n}\nelse if (u_operation \x3d\x3d48){\nresult \x3d ceil(a);\n}\nelse if (u_operation \x3d\x3d49){\nresult \x3d floor(a);\n}\nelse if (u_operation \x3d\x3d51){\nresult \x3d sin(a);\n}\nelse if (u_operation \x3d\x3d53){\nresult \x3d a * a;\n}\nelse if (u_operation \x3d\x3d56){\nresult \x3d tan(a);\n}\nelse if (u_operation \x3d\x3d57){\nresult \x3d 999.0; //tanh not available\n}\nelse if (u_operation \x3d\x3d59){\nresult \x3d 999.0; //acosh not available\n}\nelse if (u_operation \x3d\x3d60){\nresult \x3d 999.0; //asinh not available\n}\nelse if (u_operation \x3d\x3d61){\nresult \x3d atan(a, b);\n}\nelse if (u_operation \x3d\x3d64){\nresult \x3d a / b;\n}\nelse if (u_operation \x3d\x3d65){\nresult \x3d floor(a/b);\n}\nelse if (u_operation \x3d\x3d76){\nresult \x3d a !\x3d0? b:c;\n}\n}\nvoid main() {\nvec4 currentPixel0 \x3d  texture2D(u_image0, v_texCoord);\nfloat graya, reda, greena, bluea;\nif (u_bandCount \x3d\x3d 1) {\ngraya \x3d stretchOneaue(float(currentPixel.r), u_minCutOff[0], u_maxCutOff[0], u_minOutput[0], u_maxOutput[0], u_factor[0]);\ngl_FragColor \x3d vec4(graya, graya, graya, currentPixel.a);\n}\nelse if (u_bandCount \x3d\x3d 3) {\nreda \x3d stretchOneaue(float(currentPixel.r), u_minCutOff[0], u_maxCutOff[0], u_minOutput[0], u_maxOutput[0], u_factor[0]);\ngreena \x3d stretchOneaue(float(currentPixel.g), u_minCutOff[1], u_maxCutOff[1], u_minOutput[1], u_maxOutput[1], u_factor[1]);\nbluea \x3d stretchOneaue(float(currentPixel.b), u_minCutOff[2], u_maxCutOff[2], u_minOutput[2], u_maxOutput[2], u_factor[2]);\ngl_FragColor \x3d vec4(reda, greena, bluea, currentPixel.a);\n}\n}",
mask:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform float u_includedRanges[6];\nuniform bool u_includedRanges_specified;\nuniform float u_noDataValues[6];\nuniform bool u_noDataValues_specified;\nuniform int u_noDataInterpretation;\nuniform int u_bandCount;\nvec4 mask() {\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nvec4 processedPixel \x3d currentPixel;\nif (u_includedRanges_specified) {\nif (u_bandCount \x3d\x3d 1) {\nif (currentPixel.r \x3e u_includedRanges[0] \x26\x26 currentPixel.r \x3c u_includedRanges[1])\nprocessedPixel \x3d vec4(currentPixel.rgb, currentPixel.a);\nelse\nprocessedPixel \x3d vec4(currentPixel.rgb, 0);\n} else if (u_bandCount \x3d\x3d 3) {\nif (currentPixel.r \x3e u_includedRanges[0] \x26\x26 currentPixel.r \x3c u_includedRanges[1] \x26\x26 currentPixel.g \x3e u_includedRanges[2] \x26\x26 currentPixel.g \x3c u_includedRanges[3] \x26\x26 currentPixel.b \x3e u_includedRanges[4] \x26\x26 currentPixel.b \x3c u_includedRanges[5])\nprocessedPixel \x3d vec4(currentPixel.rgb, currentPixel.a);\nelse\nprocessedPixel \x3d vec4(currentPixel.rgb, 0);\n}\n}\nif (u_noDataValues_specified) {\nif (u_bandCount \x3d\x3d 1) {\nif (processedPixel.r \x3d\x3d u_noDataValues[0])\nprocessedPixel \x3d vec4(processedPixel.rgb, 0);\nelse\nprocessedPixel \x3d vec4(processedPixel.rgb, processedPixel.a);\n} else if (u_bandCount \x3d\x3d 3) {\nif (u_noDataInterpretation \x3d\x3d1 \x26\x26 processedPixel.r \x3d\x3d u_noDataValues[0] \x26\x26 processedPixel.g \x3d\x3d u_noDataValues[1] \x26\x26 processedPixel.b \x3d\x3d u_noDataValues[2])\nprocessedPixel \x3d vec4(processedPixel.rgb, 0);\nelse if (processedPixel.r \x3d\x3d u_noDataValues[0] || processedPixel.g \x3d\x3d u_noDataValues[1] || processedPixel.b \x3d\x3d u_noDataValues[2])\nprocessedPixel \x3d vec4(processedPixel.rgb, 0);\nelse\nprocessedPixel \x3d vec4(processedPixel.rgb, processedPixel.a);\n}\n}\nreturn processedPixel;\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d mask();\n}",
ndvi:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform int u_bandId_red;\nuniform int u_bandId_nir;\nuniform bool u_scaled;\nuniform int u_bandCount;\nvec4 calculateNDVI(){\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nfloat red \x3d float(u_bandId_red \x3d\x3d 0 ? currentPixel.r : (u_bandId_red \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat nir \x3d float(u_bandId_nir \x3d\x3d 0 ? currentPixel.r : (u_bandId_nir \x3d\x3d 1 ? currentPixel.g : currentPixel.b));\nfloat ndvi_denom \x3d nir + red;\nfloat ndvi;\nif (ndvi_denom \x3d\x3d 0.0) {\nndvi \x3d 0.0;\n}\nelse {\nndvi \x3d (nir - red) / ndvi_denom;\nif (u_scaled) {\nndvi \x3d float(floor(ndvi * 100.0 + 100.5));\n}\n}\nreturn vec4(ndvi, ndvi, ndvi, currentPixel.a);\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d calculateNDVI();\n}",
remap:"precision mediump float;\nuniform sampler2D u_image;\nuniform sampler2D u_image1;\nvarying vec2 v_texCoord;\nuniform float u_indexedColormapOffset;\nuniform float u_indexedColormapMaxIndex;\nuniform float u_breaks[16];\nuniform vec2 u_rawResolution;\nuniform int u_resampling;\nvec4 getPixelValue(vec2 coords) {\nif (u_resampling \x3d\x3d 0) {\nreturn texture2D(u_image, coords);\n}\nvec2 pos_ul \x3d floor(coords / u_rawResolution) * u_rawResolution;\nvec2 pos_ur \x3d pos_ul + vec2(1.0, 0.0) * u_rawResolution;\nvec2 pos_ll \x3d pos_ul + vec2(0.0, 1.0) * u_rawResolution;\nvec2 pos_lr \x3d pos_ul + vec2(1.0, 1.0) * u_rawResolution;\nvec2 weight \x3d fract(coords / u_rawResolution);\nvec4 vp_ul \x3d texture2D(u_image, pos_ul);\nvec4 vp_ur \x3d texture2D(u_image, pos_ur);\nvec4 vp_ll \x3d texture2D(u_image, pos_ll);\nvec4 vp_lr \x3d texture2D(u_image, pos_lr);\nvec4 vp \x3d mix(mix(vp_ul, vp_ur, weight.x), mix(vp_ll, vp_lr, weight.x), weight.y);\nreturn vp;\n}\nfloat getRemapIndex(float pixelValue) {\nif (pixelValue \x3c u_breaks[0] || pixelValue \x3e u_breaks[15]) {\nreturn -1.0;\n}\nfor (int i \x3d 0; i \x3c 16; i++) {\nif (pixelValue \x3c u_breaks[i]) {\nreturn float(i - 1);\n}\n}\nif (pixelValue \x3d\x3d u_breaks[15]) {\nreturn 15.0;\n}\nreturn 0.0;\n}\nvec4 colorize(float pv) {\nfloat clrIndex \x3d pv - u_indexedColormapOffset;\nvec4 result;\nif (clrIndex \x3e u_indexedColormapMaxIndex) {\nresult \x3d vec4(0.0, 0.0, 0.0, 0.0);\n}\nelse {\nvec2 clrPosition \x3d vec2(clrIndex / u_indexedColormapMaxIndex, 0.0);\nvec4 color \x3d texture2D(u_image1, clrPosition);\nresult \x3d vec4(color.r, color.g, color.b, color.a);\n}\nreturn result;\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\nvec4 currentPixel \x3d texture2D(u_image, v_texCoord);\nif (currentPixel.a \x3d\x3d 0.0) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn;\n}\nfloat remappedIndex \x3d getRemapIndex(currentPixel.r);\nif (remappedIndex \x3c 0.0) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn;\n}\ngl_FragColor \x3d colorize(remappedIndex);\n}",
resample:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform vec2 u_resamplingRatio;\nuniform int u_resamplingType;\nuniform vec2 u_anchor;\nuniform vec2 u_resolution;\nvec4 resample(){\nvec2 pos_nn, pos_ul, pos_ur, pos_ll, pos_lr, pos_offset;\nfloat weight,weight_total, weight_ul, weight_ur, weight_ll, weight_lr;\nvec4 vp;  //v_texCoord is canvas space 0-1\nvec2 originalResolution \x3d vec2(u_resolution.s*u_resamplingRatio.s, u_resolution.t*u_resamplingRatio.t);\nvec2 pos \x3d vec2(u_anchor.s+(v_texCoord.s-u_anchor.s),(u_anchor.t+(v_texCoord.t-u_anchor.t)));\nif (u_resamplingType \x3d\x3d 0)\n{//shift and scaling, y \x3d ax+b so x \x3d (y-b)/a\npos_nn \x3d vec2(floor(pos.s/originalResolution.s+0.5)*originalResolution.s,floor(pos.t/originalResolution.t+0.5)*originalResolution.t);\nif (pos_nn.s \x3c0.0 || pos_nn.s \x3e 1.0 || pos_nn.t \x3c0.0 || pos_nn.t \x3e 1.0){\nvp \x3d vec4(1.0, 0.0, 0.0, 1.0);//vec4(0.0, 1.0, 0.0, vp.a);\n}\nelse {\nvp \x3d texture2D(u_image, vec2(pos_nn.s, pos_nn.t));\n}\n}\nelse if (u_resamplingType \x3d\x3d 1)\n{//shift and scaling, 4 neighbors y \x3d ax+b so x \x3d (y-b)/a\npos_ul \x3d vec2(floor(pos.s/originalResolution.s)*originalResolution.s,floor(pos.t/originalResolution.t)*originalResolution.t);\npos_ur \x3d vec2(pos_ul.s+originalResolution.s, pos_ul.t);\npos_ll \x3d vec2(pos_ul.s, pos_ul.t+originalResolution.t);\npos_lr \x3d vec2(pos_ul.s+originalResolution.s, pos_ul.t+originalResolution.t);\npos_offset \x3d vec2(pos.s - floor(pos_ul.s),pos.t - floor(pos_ul.t));\nweight_lr \x3d sqrt(pow(pos_offset.s,2.0) + pow(pos_offset.t,2.0));\nweight_ul \x3d sqrt(pow( originalResolution.s- pos_offset.s,2.0)+ pow(originalResolution.t- pos_offset.t,2.0));\nweight_ur \x3d sqrt(pow( pos_offset.s,2.0)+ 1.0- pow(originalResolution.t - pos_offset.t,2.0));\nweight_ll \x3d sqrt(pow( originalResolution.s- pos_offset.s,2.0)+ pow(pos_offset.t,2.0));\nvp \x3d (texture2D(u_image, pos_ul) * weight_ul + texture2D(u_image, pos_ur) * weight_ur + texture2D(u_image, pos_ll) * weight_ll + texture2D(u_image, pos_lr) * weight_lr)/(weight_ul+weight_ur+weight_ll+weight_lr);\n}\nelse if (u_resamplingType \x3d\x3d 2)\n{//shift and scaling, 16 neighbors\nweight_total \x3d 0.0;\nvp \x3d vec4(0.0,0.0,0.0,0.0);\npos_ul \x3d vec2(floor(pos.s/originalResolution.s)*originalResolution.s-originalResolution.s,floor(pos.t/originalResolution.t)*originalResolution.t-originalResolution.t);\npos_offset \x3d vec2(pos.s - floor(pos_ul.s),pos.t - floor(pos_ul.t));\nfor (int i\x3d0; i\x3c4; i++){//row\nfor (int j\x3d0; j\x3c4; j++){//col\nweight \x3d sqrt(pow(pos_offset.s-float(j),2.0)+ pow(pos_offset.t-float(i),2.0));\nvp +\x3dtexture2D(u_image, vec2(pos_ul.s+float(i)*originalResolution.s,pos_ul.t+float(j)*originalResolution.t)) * weight;\nweight_total +\x3d weight;\n}\n}\nvp \x3d vp/weight_total;\n}\nreturn vp;\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d resample();\n}",
slope:"precision mediump float;\nuniform sampler2D u_image;\nvarying vec2 v_texCoord;\nuniform vec2 u_resolution;\nuniform vec2 u_cellSize;\nuniform float u_zfactor;\nuniform float u_altitude;\nuniform float u_azimuth;\nfloat shift_right(float v, float amt) {\nv \x3d floor(v) + 0.5;\nreturn floor(v / exp2(amt));\n}\nfloat shift_left(float v, float amt) {\nreturn floor(v * exp2(amt) + 0.5);\n}\nfloat mask_last(float v, float bits) {\nreturn mod(v, shift_left(1.0, bits));\n}\nfloat extract_bits(float num, float from, float to) {\nfrom \x3d floor(from + 0.5);\nto \x3d floor(to + 0.5);\nreturn mask_last(shift_right(num, from), to - from);\n}\nvec4 encode_float(float val) {\nif (val \x3d\x3d 0.0)\nreturn vec4(0, 0, 0, 0);\nfloat sign \x3d val \x3e 0.0 ? 0.0 : 1.0;\nval \x3d abs(val);\nfloat exponent \x3d floor(log2(val));\nfloat biased_exponent \x3d exponent + 127.0;\nfloat fraction \x3d ((val / exp2(exponent)) - 1.0) * 8388608.0;\nfloat t \x3d biased_exponent / 2.0;\nfloat last_bit_of_biased_exponent \x3d fract(t) * 2.0;\nfloat remaining_bits_of_biased_exponent \x3d floor(t);\nfloat byte4 \x3d extract_bits(fraction, 0.0, 8.0) / 255.0;\nfloat byte3 \x3d extract_bits(fraction, 8.0, 16.0) / 255.0;\nfloat byte2 \x3d (last_bit_of_biased_exponent * 128.0 + extract_bits(fraction, 16.0, 23.0)) / 255.0;\nfloat byte1 \x3d (sign * 128.0 + remaining_bits_of_biased_exponent) / 255.0;\nreturn vec4(byte4, byte3, byte2, byte1);\n}\nfloat getNeighborHoodAlpha(float a, float b, float c, float d, float e, float f, float g, float h, float i){\nif (a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0 || a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0 || a \x3d\x3d 0.0 || a \x3d\x3d 0.0 || a\x3d\x3d0.0) {\nreturn 0.0;\n}\nelse {\nreturn e;\n}\n}\nvec4 calculateSlope() {\nfloat pi \x3d 3.141592653589793238;\nfloat dzx \x3d 0.0;\nfloat dzy \x3d 0.0;\nvec4 va,  vb,  vc,  vd,  ve,  vf,  vg,  vh,  vi;\nvec2 axy \x3d vec2(-1.0, -1.0);\nvec2 bxy \x3d vec2(0.0, -1.0);\nvec2 cxy \x3d vec2(1.0, -1.0);\nvec2 dxy \x3d vec2(-1.0, 0.0);\nvec2 fxy \x3d vec2(1.0, 0.0);\nvec2 gxy \x3d vec2(-1.0, 1.0);\nvec2 hxy \x3d vec2(0.0, 1.0);\nvec2 ixy \x3d vec2(1.0, 1.0);\nif (v_texCoord.s \x3c u_resolution.s) {\naxy[0] \x3d 1.0;\ndxy[0] \x3d 1.0;\ngxy[0] \x3d 1.0;\n}\nif (v_texCoord.t \x3c u_resolution.t) {\naxy[1] \x3d 1.0;\nbxy[1] \x3d 1.0;\ncxy[1] \x3d 1.0;\n}\nif (v_texCoord.s \x3e 1.0 - u_resolution.s) {\ncxy[0] \x3d -1.0;\nfxy[0] \x3d -1.0;\nixy[0] \x3d -1.0;\n}\nif (v_texCoord.t \x3e 1.0 - u_resolution.t) {\ngxy[1] \x3d -1.0;\nhxy[1] \x3d -1.0;\nixy[1] \x3d -1.0;\n}\nif (v_texCoord.s \x3e\x3d u_resolution.s \x26\x26 (1.0 - u_resolution.s) \x3e\x3d v_texCoord.s \x26\x26 v_texCoord.t \x3e\x3d u_resolution.t \x26\x26 (1.0 - u_resolution.t) \x3e\x3d v_texCoord.t) {\nva \x3d texture2D(u_image, v_texCoord + u_resolution * axy);\nvb \x3d texture2D(u_image, v_texCoord + u_resolution * bxy);\nvc \x3d texture2D(u_image, v_texCoord + u_resolution * cxy);\nvd \x3d texture2D(u_image, v_texCoord + u_resolution * dxy);\nve \x3d texture2D(u_image, v_texCoord + u_resolution * vec2(0, 0));\nvf \x3d texture2D(u_image, v_texCoord + u_resolution * fxy);\nvg \x3d texture2D(u_image, v_texCoord + u_resolution * gxy);\nvh \x3d texture2D(u_image, v_texCoord + u_resolution * hxy);\nvi \x3d texture2D(u_image, v_texCoord + u_resolution * ixy);\n}\ndzx \x3d (vc + 2.0 * vf + vi - va - 2.0 * vd - vg).r / (8.0 * u_cellSize[0]);\ndzy \x3d -(vg + 2.0 * vh + vi - va - 2.0 * vb - vc).r / (8.0 * u_cellSize[1]);\nfloat alpha \x3d getNeighborHoodAlpha(va.a, vb.a, vc.a, vd.a, ve.a, vf.a, vg.a, vh.a, vi.a);\nfloat slope \x3d atan(u_zfactor * sqrt(dzx * dzx + dzy * dzy)) * 57.2957795;\nreturn vec4(slope, slope, slope, alpha);\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\ngl_FragColor \x3d calculateSlope();\n}",
stretch:"precision mediump float;\nuniform sampler2D u_image;\nuniform sampler2D u_image1;\nuniform sampler2D u_image2;\nvarying vec2 v_texCoord;\nuniform float u_minCutOff[3];\nuniform float u_maxCutOff[3];\nuniform float u_minOutput[3];\nuniform float u_maxOutput[3];\nuniform float u_factor[3];\nuniform int u_bandCount;\nuniform vec2 u_sourceDim;\nuniform vec2 u_targetDim;\nuniform int u_state;\nuniform bool u_minMaxTexture;\nuniform bool u_useGamma;\nuniform float u_gamma[4];\nuniform float u_gammaCorrection[4];\nuniform bool u_scaled;\nuniform vec2 u_rawResolution;\nuniform int u_resampling;\nvec4 getPixelValue(vec2 coords) {\nif (u_resampling \x3d\x3d 0) {\nreturn texture2D(u_image, coords);\n}\nvec2 pos_ul \x3d floor(coords / u_rawResolution) * u_rawResolution;\nvec2 pos_ur \x3d pos_ul + vec2(1.0, 0.0) * u_rawResolution;\nvec2 pos_ll \x3d pos_ul + vec2(0.0, 1.0) * u_rawResolution;\nvec2 pos_lr \x3d pos_ul + vec2(1.0, 1.0) * u_rawResolution;\nvec2 weight \x3d fract(coords / u_rawResolution);\nvec4 vp_ul \x3d texture2D(u_image, pos_ul);\nvec4 vp_ur \x3d texture2D(u_image, pos_ur);\nvec4 vp_ll \x3d texture2D(u_image, pos_ll);\nvec4 vp_lr \x3d texture2D(u_image, pos_lr);\nvec4 vp \x3d mix(mix(vp_ul, vp_ur, weight.x), mix(vp_ll, vp_lr, weight.x), weight.y);\nif (u_bandCount \x3d\x3d 1) {\nfloat alpha \x3d vp_ul.a * vp_ur.a * vp_ll.a * vp_lr.a;\nvec4 vp_nn \x3d texture2D(u_image, coords);\nreturn alpha \x3d\x3d 0.0 ? vp_nn : vec4(vp.rgb, alpha);\n}\nreturn vp;\n}\nvec4 findMin(vec4 p1, vec4 p2) {\nif (p1.a \x3d\x3d 0.0) {\nreturn p2;\n} else if (p2.a \x3d\x3d 0.0) {\nreturn p1;\n} else {\nreturn vec4(min(p1.r, p2.r),min(p1.g, p2.g),min(p1.b, p2.b),p1.a);\n}\n}\nvec4 findMax(vec4 p1, vec4 p2) {\nif (p1.a \x3d\x3d 0.0) {\nreturn p2;\n} else if (p2.a \x3d\x3d 0.0) {\nreturn p1;\n} else {\nreturn vec4(max(p1.r, p2.r),max(p1.g, p2.g),max(p1.b, p2.b),p1.a);\n}\n}\nvec4 findMinMax(vec4 p1, vec4 p2) {\nif (p1.a \x3d\x3d 0.0) {\nreturn p2;\n} else if (p2.a \x3d\x3d 0.0) {\nreturn p1;\n} else {\nreturn vec4(min(p1.r, p2.r), max(p1.g, p2.g), 0.0, p1.a);\n}\n}\nvec4 minMax(int state) {\nvec2 pixelFract \x3d fract(v_texCoord * u_sourceDim);\nfloat xshift \x3d ((pixelFract.s \x3e\x3d 0.5 || pixelFract.s \x3d\x3d 0.0) ? -1.0 : 1.0) / u_sourceDim.s; //take left pixel if \x3e 0.5\nfloat yshift \x3d ((pixelFract.s \x3e\x3d 0.5 || pixelFract.s \x3d\x3d 0.0) ? -1.0 : 1.0) / u_sourceDim.t; //take bottom pixel if \x3e 0.5\nif (u_sourceDim.s \x3d\x3d 1.0) {\nxshift \x3d 0.0;\n}\nif (u_sourceDim.t \x3d\x3d 1.0) {\nyshift \x3d 0.0;\n}\nvec4 p1 \x3d texture2D(u_image, v_texCoord);\nvec4 p2 \x3d texture2D(u_image, v_texCoord + vec2(xshift, 0.0));\nvec4 p3 \x3d texture2D(u_image, v_texCoord + vec2(0.0, yshift));\nvec4 p4 \x3d texture2D(u_image, v_texCoord + vec2(xshift, yshift));\nvec4 pval;\nif (state \x3d\x3d 2) {\npval \x3d findMinMax(findMinMax(p1, p2), findMinMax(p3, p4));\n} else if (state \x3d\x3d 1) {\npval \x3d findMax(findMax(p1, p2), findMax(p3, p4));\n} else if (state \x3d\x3d 0) {\npval \x3d findMin(findMin(p1, p2), findMin(p3, p4));\n}\nreturn pval;\n}\nfloat stretchOneValue(float val, float minCutOff, float maxCutOff, float minOutput, float maxOutput, float factor, bool scaled) {\nfloat stretchedVal;\nif (val \x3e minCutOff \x26\x26 val \x3c maxCutOff) {\nstretchedVal \x3d minOutput + (val - minCutOff) * factor;\n} else if (val \x3e\x3d maxCutOff) {\nstretchedVal \x3d maxOutput;\n} else {\nstretchedVal \x3d minOutput;\n}\nif (scaled) {\nreturn stretchedVal;\n}\nelse {\nreturn stretchedVal / maxOutput; //0-1\n}\n}\nfloat stretchOneValueGamma(float val, float minCutOff, float maxCutOff, float minOutput, float maxOutput, float factor, float gamma, float gammaCorrection, bool scaled) {\nfloat stretchedVal;\nfloat tempf \x3d 1.0;\nfloat outRange \x3d maxOutput - minOutput;\nfloat relativeVal \x3d (val - minCutOff) / (maxCutOff - minCutOff);\nif (val \x3e minCutOff \x26\x26 val \x3c maxCutOff) {\nif (gamma \x3e 1.0) {\ntempf -\x3d pow(1.0 / outRange, relativeVal * gammaCorrection);\n}\nstretchedVal \x3d floor(tempf * outRange * pow(relativeVal, 1.0 / gamma)) + minOutput;\n}\nelse if (val \x3e\x3d maxCutOff) {\nstretchedVal \x3d maxOutput;\n} else {\nstretchedVal \x3d minOutput;\n}\nif (scaled) {\nreturn stretchedVal;\n}\nelse {\nreturn stretchedVal / maxOutput; //0-1\n}\n}\nbool isOutside(){\nif (v_texCoord.t\x3e1.00001 ||v_texCoord.t\x3c-0.00001 || v_texCoord.s\x3e1.00001 ||v_texCoord.s\x3c-0.00001) {\ngl_FragColor \x3d vec4(0.0, 0.0, 0.0, 0.0);\nreturn true;\n}\nelse {\nreturn false;\n}\n}\nvoid main() {\nif (isOutside()) {\nreturn;\n}\nif (u_state \x3d\x3d 100) {\nvec4 currentPixel \x3d getPixelValue(v_texCoord);\nfloat grayVal,\nredVal,\ngreenVal,\nblueVal;\nfloat min0,\nmax0,\nmin1,\nmax1,\nmin2,\nmax2,\nfactor0,\nfactor1,\nfactor2;\nvec4 minV, maxV;\nif (u_minMaxTexture) {\nif (u_bandCount \x3d\x3d 1) {\nminV \x3d texture2D(u_image1, v_texCoord);\nmin0 \x3d minV.r;\nmax0 \x3d minV.g;\nfactor0 \x3d (u_maxOutput[0] - u_minOutput[0]) / (max0 - min0);\n} else {\nminV \x3d texture2D(u_image1, v_texCoord);\nmaxV \x3d texture2D(u_image2, v_texCoord);\nmin0 \x3d minV.r;\nmax0 \x3d maxV.r;\nmin1 \x3d minV.g;\nmax1 \x3d maxV.g;\nmin2 \x3d minV.b;\nmax2 \x3d maxV.b;\nfactor0 \x3d (u_maxOutput[0] - u_minOutput[0]) / (max0 - min0);\nfactor1 \x3d (u_maxOutput[1] - u_minOutput[1]) / (max1 - min1);\nfactor2 \x3d (u_maxOutput[2] - u_minOutput[2]) / (max2 - min2);\n}\n} else {\nmin0 \x3d u_minCutOff[0];\nmax0 \x3d u_maxCutOff[0];\nmin1 \x3d u_minCutOff[1];\nmax1 \x3d u_maxCutOff[1];\nmin2 \x3d u_minCutOff[2];\nmax2 \x3d u_maxCutOff[2];\nfactor0 \x3d u_factor[0];\nfactor1 \x3d u_factor[1];\nfactor2 \x3d u_factor[2];\n}\nif (u_useGamma){\nif (u_bandCount \x3d\x3d 1) {\ngrayVal \x3d stretchOneValueGamma(float(currentPixel.r), min0, max0, u_minOutput[0], u_maxOutput[0], factor0, u_gamma[0], u_gammaCorrection[0], u_scaled);\ngl_FragColor \x3d vec4(grayVal, grayVal, grayVal, currentPixel.a);\n} else {\nredVal \x3d stretchOneValueGamma(float(currentPixel.r), min0, max0, u_minOutput[0], u_maxOutput[0], factor0, u_gamma[0], u_gammaCorrection[0], u_scaled);\ngreenVal \x3d stretchOneValueGamma(float(currentPixel.g), min1, max1, u_minOutput[1], u_maxOutput[1], factor1, u_gamma[1], u_gammaCorrection[1], u_scaled);\nblueVal \x3d stretchOneValueGamma(float(currentPixel.b), min2, max2, u_minOutput[2], u_maxOutput[2], factor2, u_gamma[1], u_gammaCorrection[2], u_scaled);\ngl_FragColor \x3d vec4(redVal, greenVal, blueVal, currentPixel.a);\n}\n}\nelse {\nif (u_bandCount \x3d\x3d 1) {\ngrayVal \x3d stretchOneValue(float(currentPixel.r), min0, max0, u_minOutput[0], u_maxOutput[0], factor0, u_scaled);\ngl_FragColor \x3d vec4(grayVal, grayVal, grayVal, currentPixel.a);\n} else {\nredVal \x3d stretchOneValue(float(currentPixel.r), min0, max0, u_minOutput[0], u_maxOutput[0], factor0, u_scaled);\ngreenVal \x3d stretchOneValue(float(currentPixel.g), min1, max1, u_minOutput[1], u_maxOutput[1], factor1, u_scaled);\nblueVal \x3d stretchOneValue(float(currentPixel.b), min2, max2, u_minOutput[2], u_maxOutput[2], factor2, u_scaled);\ngl_FragColor \x3d vec4(redVal, greenVal, blueVal, currentPixel.a);\n}\n}\n} else {\nvec4 currentPixel \x3d minMax(u_state);\ngl_FragColor \x3d currentPixel;\n}\n}"}})},
"esri/layers/rasterLib/function/RasterFunctionWebGLMixin":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ./pixelShaders ./vertexShaders ./webglHelper ./convolutionKernel".split(" "),function(G,e,t,n,p,h,c){return G(null,{gl:null,rgbaFloatData:null,originalTexture:null,lastTexture:null,renderTexture:!1,constructor:function(a){this._isProgramInitialized=!1;this.gl=a&&a.gl;a&&a.renderTexture&&(this.renderTexture=a.renderTexture);this._xformSetting=a&&a._xformSetting||{requireProjection:!1,
meshSize:[20,20]}},bindFrameBuffer:function(){var a=this.gl;this._setupPingPongTextures();this._setupBranchingTextures();var b=this._glSetting;this.isBranch?(b.branchIndex=(b.branchIndex+1)%b.branchCount,b=b.branches[b.branchIndex]):(b.pingpongIndex=(b.pingpongIndex+1)%b.pingpong.length,b=b.pingpong[b.pingpongIndex]);a.bindFramebuffer(a.FRAMEBUFFER,b.frameBuffer);a.viewport(0,0,a.drawingBufferWidth,a.drawingBufferHeight);return b},_initializeProgram:function(a){if(this.gl)try{var b=this.gl;b.viewport(0,
0,b.drawingBufferWidth,b.drawingBufferHeight);var l=this._glSetting.programUniforms,g="local"===this.functionName?"local"+this.functionArguments.operation:this.functionName,f=l[g];if(f)this._uniforms=f.uniforms,this.rasterProgram=f.program;else{var d=(this._useMesh=this._tileMode&&this._xformSetting.requireProjection)?p.mesh:p.basic,k=p.getShader(b,a.vertex||d),m=n.getShader(b,a.fragment),v=this._loadProgram(k,m),q={rasterProgram:h.getUniforms(b,v)};l[g]={uniforms:q,program:v};this.rasterProgram=
v;this._uniforms=q}b.useProgram(this.rasterProgram);var r=b.getAttribLocation(this.rasterProgram,"a_texCoord"),w=b.createBuffer();b.bindBuffer(b.ARRAY_BUFFER,w);var u=h.createMesh(this._xformSetting.meshSize);b.bufferData(b.ARRAY_BUFFER,u,b.STATIC_DRAW);b.enableVertexAttribArray(r);b.vertexAttribPointer(r,2,b.FLOAT,!1,0,0);b.disable(b.DEPTH_TEST);b.blendFunc(b.SRC_ALPHA,b.ZERO);b.disable(b.BLEND);b.pixelStorei(b.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1);b.pixelStorei(b.UNPACK_FLIP_Y_WEBGL,!1);this._shaderInfo=
{fragment:a.fragmentName}}catch(y){console.error("webgl exception: "+y.message)}else console.error("WebGL is required.")},_setUniform:function(a,b,l){null!=b&&(l&&!this._uniforms[l]&&(this._uniforms[l]=h.getUniforms(this.gl,this[l])),l=l?this._uniforms[l]:this._uniforms.rasterProgram,(a=l[a]||l[a+"[0]"])&&h.setUniform(this.gl,a,b))},_setUniforms:function(a,b){var l=Object.keys(a),g,f=l.length;for(g=0;g<f;g++)this._setUniform(l[g],a[l[g]],b);this.rawInput?this._setUniform("u_flipY",!0,b):this._setUniform("u_flipY",
!1,b);this._tileMode?(this.rawInput?(a=this._xformSetting.offset,l=this._xformSetting.scale):(a=[0,0],l=[1,1]),this._setUniform("u_xformOffset",a,b),this._setUniform("u_xformScale",l,b),this._xformSetting.requireProjection&&(this.rawInput?(this._setupXformTexture(),this._setUniform("u_projection",!0,b),this._setUniform("u_transformGridSize",this._xformSetting.gridConfig.size,b),this._setUniform("u_transformSpacing",this._xformSetting.gridConfig.spacing,b),this._setUniform("u_targetImageSize",new Float32Array([this.gl.drawingBufferWidth,
this.gl.drawingBufferHeight]),b)):this._setUniform("u_projection",!1,b))):(a=[0,0],l=[1,1],this._setUniform("u_xformOffset",a,b),this._setUniform("u_xformScale",l,b));this.rawInput&&this._rawResolution&&("RSP_BilinearInterpolation"===this.interpolation||"RSP_CubicConvolution"===this.interpolation)?(this._setUniform("u_resampling",1),this._setUniform("u_rawResolution",this._rawResolution)):this._setUniform("u_resampling",0)},_setupTextureData:function(a,b){if(a.texture)return a;a.raster&&a.raster.pixelBlock&&
(a=a.raster);this.rawInput=!0;var l=b&&b.notOriginal,g=b&&b.bandIDs;b&&b.reCreate?b=!1:(b=this._tileMode?!this._xformSetting.hasNewTexture:!this._glSetting.hasNewTexture)&&this._originalBandIDs&&(b=g?this._originalBandIDs.join("")===g.join(""):!1);0<this._glSetting.branchCount&&(b=!1);if(b&&this.originalTexture)return{extent:a.extent,texture:this.originalTexture};b=this._createTexture();l||(this.originalTexture=b,this._originalBandIDs=g);l=this.gl;var f=a.pixelBlock;this._rawResolution=f?[1/a.pixelBlock.width,
1/a.pixelBlock.height]:[1/this.gl.drawingBufferWidth,1/this.gl.drawingBufferHeight];var d=0;g&&0<g.length&&f&&(d=Math.max.apply(null,g),f.pixels.length>d&&g&&(f.pixels=g.map(function(m){return f.pixels[m]}),f.statistics&&(f.statistics=g.map(function(m){return f.statistics[m]}))));g=f.width;d=f.height;l.getExtension("OES_texture_float");var k=f.getAsRGBAFloat();l.texImage2D(l.TEXTURE_2D,0,l.RGBA,g,d,0,l.RGBA,l.FLOAT,k);return{extent:a.extent,texture:b}},_setupPingPongTextures:function(){var a=this._glSetting;
if(!a||!a.pingpong){a.pingpong=[];var b=h.createBufferTexture(this.gl,!1);a.pingpong.push(b);b=h.createBufferTexture(this.gl,!1);a.pingpong.push(b);a.pingpongIndex=1}},_setupBranchingTextures:function(){var a=this._glSetting;if(!a||!a.branches){a.branches=[];var b=0,l=a.branchCount;if(0<l){for(b=0;b<l;b++){var g=h.createBufferTexture(this.gl,!1);a.branches.push(g)}a.branchIndex=l-1}}},_setupXformTexture:function(a){for(var b=this._createTexture(),l=this.gl,g=4*this._xformSetting.gridConfig.size[0],
f=this._xformSetting.gridConfig.size[1],d=new Float32Array(g*f*4),k=0,m=0;m<this._xformSetting.gridConfig.coefficients.length;m++)d[k++]=this._xformSetting.gridConfig.coefficients[m],2===m%3&&(d[k++]=1);l.getExtension("OES_texture_float");l.texImage2D(l.TEXTURE_2D,0,l.RGBA,g,f,0,l.RGBA,l.FLOAT,d);this._bindTexture(b,"u_transformGrid",a)},_createTexture:function(a){return h.createTexture(this.gl,a)},_bindTexture:function(a,b,l){b=b||"u_image";l=this._uniforms[l||"rasterProgram"];var g=this._getTextureIndex(b);
if(-1!==g){var f=this.gl;f.uniform1i(l[b].location,g);f.activeTexture(f.TEXTURE0+g);f.bindTexture(f.TEXTURE_2D,a)}},_getTextureIndex:function(a,b){b=this._uniforms[b||"rasterProgram"];if(!b||!b[a]||b[a].info.type!==this.gl.SAMPLER_2D)return-1;if("u_transformGrid"===a)return 0;a="u_image"===a?0:parseInt(a.replace("u_image",""));return this._xformSetting.requireProjection?a+1:a},_drawGL:function(a){var b=this.gl;this.renderTexture?(b.enable(b.BLEND),b.bindFramebuffer(b.FRAMEBUFFER,null)):b.disable(b.BLEND);
a||b.viewport(0,0,b.drawingBufferWidth,b.drawingBufferHeight);a=this._xformSetting.meshSize||[1,1];b.drawArrays(b.TRIANGLES,0,a[0]*a[1]*6);this._drawMesh()},_drawMesh:function(){if(this.renderTexture&&this._glSetting.drawMesh){this.meshProgram=this.meshProgram||this._setupMeshProgram();var a=this.gl;a.useProgram(this.meshProgram);a.bindFramebuffer(a.FRAMEBUFFER,null);var b=a.getAttribLocation(this.meshProgram,"a_texCoord"),l=a.createBuffer();a.bindBuffer(a.ARRAY_BUFFER,l);l=this._xformSetting.meshSize||
[1,1];var g=h.createMesh(l,!0);a.bufferData(a.ARRAY_BUFFER,g,a.STATIC_DRAW);a.enableVertexAttribArray(b);a.vertexAttribPointer(b,2,a.FLOAT,!1,0,0);a.disable(a.DEPTH_TEST);a.blendFunc(a.ONE,a.ZERO);this._setUniforms({u_color:[0,0,1,1],u_drawMeshLines:!0},"meshProgram");a.drawArrays(a.LINES,0,l[0]*l[1]*10)}},_setupMeshProgram:function(){var a=p.getShader(this.gl,p.mesh),b=n.getShader(this.gl,n.constant);return this._loadProgram(a,b)},_loadProgram:function(a,b){return h.loadProgram(this.gl,a,b)},_getShaderScript:function(a,
b){b=document.getElementById(b);if(!b)return null;a="";for(b=b.firstChild;b;)3==b.nodeType&&(a+=b.textContent),b=b.nextSibling;return a}})})},"esri/layers/rasterLib/function/vertexShaders":function(){define(["dojo/_base/declare","dojo/_base/lang","./vertexShaderScripts"],function(G,e,t){G={shaderType:"vertex",getShader:function(n,p){var h=n.createShader(n.VERTEX_SHADER);n.shaderSource(h,p);n.compileShader(h);n.getShaderParameter(h,n.COMPILE_STATUS)||(h=null);return h}};e.mixin(G,t);return G})},"esri/layers/rasterLib/function/vertexShaderScripts":function(){define([],
function(){return{basic:"varying vec2 v_texCoord;\nattribute vec2 a_texCoord;\nuniform vec2 u_xformOffset;\nuniform vec2 u_xformScale;\nuniform bool u_flipY;\nvoid main() {\nv_texCoord \x3d u_xformOffset + a_texCoord * u_xformScale;\nif (u_flipY) {\nv_texCoord.t \x3d 1.0 - v_texCoord.t;\n}\nvec2 position \x3d a_texCoord * 2.0 - 1.0;\ngl_Position \x3d vec4(position, 0.0, 1.0);\n}",histogram:"attribute float a_pixelIndex;\nuniform sampler2D u_image;\nuniform sampler2D u_image1;\nuniform sampler2D u_image2;\nuniform vec2 u_sourceDim;\nuniform vec2 u_halfPixel;\nuniform vec4 u_bandSelection;\nuniform vec4 u_mins;\nuniform vec4 u_factors;\nuniform float u_size;\nuniform int u_bandCount;\nuniform bool u_minMaxTexture;\nvoid main() {\nfloat row \x3d a_pixelIndex/u_sourceDim.s;\nvec2 coord \x3d vec2(fract(row), floor(row)/u_sourceDim.t);\nvec4 pv \x3d texture2D(u_image, coord + u_halfPixel);\nvec4 minVal, maxVal, pvm;\nif (u_minMaxTexture){\nif (u_bandCount \x3d\x3d1){ //min \x3d red, max \x3d green\nvec4 minmax \x3d texture2D(u_image1, vec2(0.5,0.5));\nminVal \x3d vec4(minmax.r, minmax.r, minmax.r, 0.0);\nmaxVal \x3d vec4(minmax.g, minmax.g, minmax.g, 0.0);\n}\nelse if (u_bandCount \x3d\x3d3){ //min \x3d red, max \x3d green\nminVal \x3d texture2D(u_image1, vec2(0.5,0.5));\nmaxVal \x3d texture2D(u_image2, vec2(0.5,0.5));\n}\nvec4 factors \x3d u_size/(maxVal-minVal+vec4(0.0,0.0,0.0,1.0)) * u_factors;\npvm \x3d (pv - minVal) * factors;\n}\nelse {\npvm \x3d (pv - u_mins) * u_factors;\n}\nfloat histVal \x3d min(floor(pvm.r+pvm.g+pvm.b), u_size-1.0);\nhistVal \x3d pv.a \x3d\x3d 1.0? histVal: u_size;\ngl_Position \x3d vec4((histVal+0.1) / (u_size+1.0) * 2.0 - 1.0, 0.5, 0, 1);\ngl_PointSize \x3d 1.0;\n}",
mesh:"varying vec2 v_texCoord;\nattribute vec2 a_texCoord;\nuniform bool u_drawMeshLines;\nuniform bool u_flipY;\nuniform vec2 u_xformOffset;\nuniform vec2 u_xformScale;\nuniform sampler2D u_transformGrid;\nuniform vec2 u_transformSpacing;\nuniform vec2 u_transformGridSize;\nuniform vec2 u_targetImageSize;\nuniform vec2 u_srcImageSize;\nuniform bool u_projection;\nvec2 projectPixelLocation(vec2 coords) {\nvec2 index_image \x3d floor(coords * u_targetImageSize);\nvec2 oneTransformPixel \x3d vec2(0.25 / u_transformGridSize.s, 1.0 / u_transformGridSize.t);\nvec2 index_transform \x3d floor(index_image / u_transformSpacing) / u_transformGridSize;\nvec2 pos \x3d fract((index_image + vec2(0.5, 0.5)) / u_transformSpacing);\nvec2 srcLocation;\nvec2 transform_location \x3d index_transform + oneTransformPixel * 0.5;\nif (pos.s \x3c\x3d pos.t) {\nvec4 ll_abc \x3d texture2D(u_transformGrid, vec2(transform_location.s, transform_location.t));\nvec4 ll_def \x3d texture2D(u_transformGrid, vec2(transform_location.s + oneTransformPixel.s, transform_location.t));\nsrcLocation.s \x3d dot(ll_abc.rgb, vec3(pos, 1.0));\nsrcLocation.t \x3d dot(ll_def.rgb, vec3(pos, 1.0));\n} else {\nvec4 ur_abc \x3d texture2D(u_transformGrid, vec2(transform_location.s + 2.0 * oneTransformPixel.s, transform_location.t));\nvec4 ur_def \x3d texture2D(u_transformGrid, vec2(transform_location.s + 3.0 * oneTransformPixel.s, transform_location.t));\nsrcLocation.s \x3d dot(ur_abc.rgb, vec3(pos, 1.0));\nsrcLocation.t \x3d dot(ur_def.rgb, vec3(pos, 1.0));\n}\nreturn srcLocation;// + halfPixel;\n}\nvoid main() {\nif (u_projection) {\nv_texCoord \x3d projectPixelLocation(a_texCoord);\n} else {\nv_texCoord \x3d u_xformOffset + a_texCoord * u_xformScale;\n}\nif (u_flipY) {\nv_texCoord.t \x3d 1.0 - v_texCoord.t;\n}\nvec2 position \x3d a_texCoord * 2.0 - 1.0;\nif (u_drawMeshLines){\nvec2 adjustedPos \x3d (v_texCoord - u_xformOffset) / u_xformScale;\ngl_Position \x3d vec4( adjustedPos * 2.0 - 1.0, 0.0, 1.0);\n}\nelse {\ngl_Position \x3d vec4(position, 0.0, 1.0);\n}\n}"}})},
"esri/layers/rasterLib/function/webglHelper":function(){define([],function(){var G={getUniforms:function(e,t){var n=e.getProgramParameter(t,e.ACTIVE_UNIFORMS),p,h,c={};for(p=0;p<n;p++)(h=e.getActiveUniform(t,p))&&(c[h.name]={location:e.getUniformLocation(t,h.name),info:h});return c},setUniform:function(e,t,n){var p=t.info,h=t.location,c=p.type;if(null==n)console.log("uniform "+t.info.name+" has null or undefined value");else switch(c){case e.FLOAT:1<p.size?0===n.length?console.log("uniform "+t.info.name+
" has length 0"):e.uniform1fv(h,n):e.uniform1f(h,n);break;case e.FLOAT_VEC2:if(0===n.length){console.log("uniform "+t.info.name+" has length 0");break}e.uniform2fv(h,n);break;case e.FLOAT_VEC3:if(0===n.length){console.log("uniform "+t.info.name+" has length 0");break}e.uniform3fv(h,n);break;case e.FLOAT_VEC4:if(0===n.length){console.log("uniform "+t.info.name+" has length 0");break}e.uniform4fv(h,n);break;case e.INT:case e.BOOL:1<p.size?0===n.length?console.log("uniform "+t.info.name+" has length 0"):
e.uniform1iv(h,n):e.uniform1i(h,n);break;case e.INT_VEC2:case e.BOOL_VEC2:if(0===n.length){console.log("uniform "+t.info.name+" has length 0");break}e.uniform2iv(h,n);break;case e.INT_VEC3:case e.BOOL_VEC3:if(0===n.length){console.log("uniform "+t.info.name+" has length 0");break}e.uniform3iv(h,n);break;case e.INT_VEC4:case e.BOOL_VEC4:0===n.length?console.log("uniform "+t.info.name+" has length 0"):e.uniform4iv(h,n)}},createTexture:function(e,t){var n=e.createTexture();e.bindTexture(e.TEXTURE_2D,
n);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,t?e.LINEAR:e.NEAREST);e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,t?e.LINEAR:e.NEAREST);return n},createBufferTexture:function(e,t,n){t=G.createTexture(e,t);e.getExtension("OES_texture_float");n=n||[e.drawingBufferWidth,e.drawingBufferHeight];e.texImage2D(e.TEXTURE_2D,0,e.RGBA,n[0],n[1],0,e.RGBA,e.FLOAT,null);n=e.createFramebuffer();
e.bindFramebuffer(e.FRAMEBUFFER,n);e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0);return{texture:t,frameBuffer:n}},getShader:function(e,t,n){n=n?e.createShader(e.VERTEX_SHADER):e.createShader(e.FRAGMENT_SHADER);e.shaderSource(n,t);e.compileShader(n);e.getShaderParameter(n,e.COMPILE_STATUS)||(console.log(e.getShaderInfoLog(n)),n=null);return n},loadProgram:function(e,t,n){var p=e.createProgram();e.attachShader(p,t);e.attachShader(p,n);e.linkProgram(p);e.getProgramParameter(p,
e.LINK_STATUS)||(console.warn("failed to load webgl program: "+e.getProgramInfoLog(p)),e.deleteProgram(p),p=null);return p},createMesh:function(e,t){if(!e||1===e[0]&&1===e[1])return new Float32Array([0,0,1,0,0,1,0,1,1,0,1,1]);var n=e&&t?new Float32Array(e[0]*e[1]*20):new Float32Array(e[0]*e[1]*12);var p=.9998/e[1],h=.9998/e[0],c,a,b=0;for(c=0;c<e[1];c++)for(a=0;a<e[0];a++){var l=1E-4+p*c;var g=1E-4+h*a;e&&!t?(n[b++]=l,n[b++]=g,n[b++]=l+p,n[b++]=g,n[b++]=l,n[b++]=g+h,n[b++]=l,n[b++]=g+h,n[b++]=l+p,
n[b++]=g,n[b++]=l+p,n[b++]=g+h):(n[b++]=l,n[b++]=g,n[b++]=l,n[b++]=g+h,n[b++]=l,n[b++]=g+h,n[b++]=l+p,n[b++]=g+h,n[b++]=l+p,n[b++]=g+h,n[b++]=l+p,n[b++]=g,n[b++]=l,n[b++]=g,n[b++]=l+p,n[b++]=g,n[b++]=l,n[b++]=g+h,n[b++]=l+p,n[b++]=g)}return n}};return G})},"esri/layers/rasterLib/function/convolutionKernel":function(){define([],function(){var G={Default:[0,0,0,0,1,0,0,0,0],LineDetectionHorizontal:[-1,-1,-1,2,2,2,-1,-1,-1],LineDetectionVertical:[-1,2,-1,-1,2,-1,-1,2,-1],LineDetectionLeftDiagonal:[2,
-1,-1,-1,2,-1,-1,-1,2],LineDetectionRightDiagonal:[-1,-1,2,-1,2,-1,2,-1,-1],GradientNorth:[-1,-2,-1,0,0,0,1,2,1],GradientWest:[-1,0,1,-2,0,2,-1,0,1],GradientEast:[1,0,-1,2,0,-2,1,0,-1],GradientSouth:[1,2,1,0,0,0,-1,-2,-1],GradientNorthEast:[0,-1,-2,1,0,-1,2,1,0],GradientNorthWest:[-2,-1,0,-1,0,1,0,1,2],SmoothArithmeticMean:[.111111111111,.111111111111,.111111111111,.111111111111,.111111111111,.111111111111,.111111111111,.111111111111,.111111111111],Smoothing3x3:[.0625,.125,.0625,.125,.25,.125,.0625,
.125,.0625],Smoothing5x5:[1,1,1,1,1,1,4,4,4,1,1,4,12,4,1,1,4,4,4,1,1,1,1,1,1],Sharpening3x3:[-1,-1,-1,-1,9,-1,-1,-1,-1],Sharpening5x5:[-1,-3,-4,-3,-1,-3,0,6,0,-3,-4,6,21,6,-4,-3,0,6,0,-3,-1,-3,-4,-3,-1],Laplacian3x3:[0,-1,0,-1,4,-1,0,-1,0],Laplacian5x5:[0,0,-1,0,0,0,-1,-2,-1,0,-1,-2,17,-2,-1,0,-1,-2,-1,0,0,0,-1,0,0],SobelHorizontal:[-1,-2,-1,0,0,0,1,2,1],SobelVertical:[-1,0,1,-2,0,2,-1,0,1],Sharpen:[0,-.25,0,-.25,2,-.25,0,-.25,0],Sharpen2:[-.25,-.25,-.25,-.25,3,-.25,-.25,-.25,-.25],PointSpread:[-.627,
.352,-.627,.352,2.923,.352,-.627,.352,-.627],getKernel:function(e){switch(e){case 0:return G.LineDetectionHorizontal;case 1:return G.LineDetectionVertical;case 2:return G.LineDetectionLeftDiagonal;case 3:return G.LineDetectionRightDiagonal;case 4:return G.GradientNorth;case 5:return G.GradientWest;case 6:return G.GradientEast;case 7:return G.GradientSouth;case 8:return G.GradientNorthEast;case 9:return G.GradientNorthWest;case 10:return G.SmoothArithmeticMean;case 11:return G.Smoothing3x3;case 12:return G.Smoothing5x5;
case 13:return G.Sharpening3x3;case 14:return G.Sharpening5x5;case 15:return G.Laplacian3x3;case 16:return G.Laplacian5x5;case 17:return G.SobelHorizontal;case 18:return G.SobelVertical;case 19:return G.Sharpen;case 20:return G.Sharpen2;case 21:return G.PointSpread;default:return G.Default}}};return G})},"esri/layers/rasterLib/function/surfaceUtils":function(){define(["dojo/_base/lang"],function(G){return{hillshade:function(e,t){if(null!==e&&null!==e.pixelBlock&&null!==e.pixelBlock.pixels){var n=
this._clonePixelBlock(e.pixelBlock),p=t.altitude,h=t.azimuth,c=t.zFactor,a=t.psPower,b=t.psFactor,l=t.hillshadeType,g=t.slopeType,f=t.isGCS;1===l&&(c*=2);t=n.width;var d=n.height,k=n.pixels[0],m=n.mask,v=new Uint8Array(t*d);m&&v.set(m);var q=new Uint8Array(t*d),r=(e.extent.xmax-e.extent.xmin)/t,w=(e.extent.ymax-e.extent.ymin)/d,u=c/(8*r),y=c/(8*w);.001<c&&f&&(u/=111E3,y/=111E3);3===g&&(f?(u=111E3*r,y=111E3*w,u=(c+Math.pow(u,a)*b)/(8*u),y=(c+Math.pow(y,a)*b)/(8*y)):(u=(c+Math.pow(r,a)*b)/(8*r),y=(c+
Math.pow(w,a)*b)/(8*w)));f=(90-p)*Math.PI/180;p=Math.cos(f);var x=(360-h+90)*Math.PI/180;h=Math.sin(f)*Math.cos(x);f=Math.sin(f)*Math.sin(x);c=[];a=[];b=[];r=[315,270,225,360,180,0];var z=[60,60,60,60,60,90];g=[3,5,3,2,1,4];var A=g.reduce(function(V,X){return V+X});w=g.map(function(V){return V/A});if(1===l){var E=r.length;for(g=0;g<E;g++)p=z[g],h=r[g],f=(90-p)*Math.PI/180,p=Math.cos(f),x=(360-h+90)*Math.PI/180,h=Math.sin(f)*Math.cos(x),f=Math.sin(f)*Math.sin(x),c.push(p),a.push(h),b.push(f)}var F=
0;for(g=1;g<d-1;g++)for(z=g*t,r=1;r<t-1;r++)if(m&&!m[z+r])q[z+r]=0;else{x=0;if(m&&(x=m[z-t+r-1]+m[z-t+r]+m[z-t+r+1]+m[z+r-1]+m[z+r+1]+m[z+t+r-1]+m[z+t+r]+m[z+t+r+1],7>x)){q[z+r]=0;v[z+r]=0;continue}if(7===x){var B=m[z-t+r-1]?k[z-t+r-1]:k[z+r];var D=m[z-t+r]?k[z-t+r]:k[z+r];var I=m[z-t+r+1]?k[z-t+r+1]:k[z+r];x=m[z+r-1]?k[z+r-1]:k[z+r];var M=m[z+r+1]?k[z+r+1]:k[z+r];F=m[z+t+r-1]?k[z+t+r-1]:k[z+r];var N=m[z+t+r]?k[z+t+r]:k[z+r];var Q=m[z+t+r+1]?k[z+t+r+1]:k[z+r]}else B=k[z-t+r-1],D=k[z-t+r],I=k[z-t+
r+1],x=k[z+r-1],M=k[z+r+1],F=k[z+t+r-1],N=k[z+t+r],Q=k[z+t+r+1];x=(I+M+M+Q-(B+x+x+F))*u;D=(F+N+N+Q-(B+D+D+I))*y;I=Math.sqrt(1+x*x+D*D);F=0;if(0===l)N=f*D-h*x,N=255*(p+N)/I,0>N&&(N=0),F=N;else if(1===l)for(B=0;B<E;B++)N=b[B]*D-a[B]*x,N=255*(c[B]+N)/I,0>N&&(N=0),F+=N*w[B];q[z+r]=F}for(g=0;g<d;g++)q[g*t]=q[g*t+1],q[(g+1)*t-1]=q[(g+1)*t-2];for(g=1;g<t-1;g++)q[g]=q[g+t],q[g+(d-1)*t]=q[g+(d-2)*t];n.pixelType="U8";n.pixels=[q];n.statistics=[{minValue:0,maxValue:255}];m&&(n.mask=v);return{extent:e.extent,
pixelBlock:n}}},slope:function(e,t){if(null!==e&&null!==e.pixelBlock&&null!==e.pixelBlock.pixels){var n=this._clonePixelBlock(e.pixelBlock),p=t.zFactor,h=t.psPower,c=t.psFactor,a=t.slopeType,b=t.isGCS;t=n.width;var l=n.height,g=n.pixels[0],f=n.mask,d=new Uint8Array(t*l);f&&d.set(f);var k=new Float32Array(t*l),m=(e.extent.xmax-e.extent.xmin)/t,v=(e.extent.ymax-e.extent.ymin)/l,q=p/(8*m),r=p/(8*v);1E-4>Math.abs(p-1)&&b&&(q/=111E3,r/=111E3);3===a&&(b?(q=111E3*m,r=111E3*v,q=(p+Math.pow(q,h)*c)/(8*q),
r=(p+Math.pow(r,h)*c)/(8*r)):(q=(p+Math.pow(m,h)*c)/(8*m),r=(p+Math.pow(v,h)*c)/(8*v)));for(p=1;p<l-1;p++)for(c=p*t,h=1;h<t-1;h++)if(f&&!f[c+h])k[c+h]=0;else{v=0;if(f&&(v=f[c-t+h-1]+f[c-t+h]+f[c-t+h+1]+f[c+h-1]+f[c+h+1]+f[c+t+h-1]+f[c+t+h]+f[c+t+h+1],7>v)){k[c+h]=0;d[c+h]=0;continue}if(7===v){v=f[c-t+h-1]?g[c-t+h-1]:g[c+h];b=f[c-t+h]?g[c-t+h]:g[c+h];m=f[c-t+h+1]?g[c-t+h+1]:g[c+h];var w=f[c+h-1]?g[c+h-1]:g[c+h];var u=f[c+h+1]?g[c+h+1]:g[c+h];var y=f[c+t+h-1]?g[c+t+h-1]:g[c+h];var x=f[c+t+h]?g[c+t+
h]:g[c+h];var z=f[c+t+h+1]?g[c+t+h+1]:g[c+h]}else v=g[c-t+h-1],b=g[c-t+h],m=g[c-t+h+1],w=g[c+h-1],u=g[c+h+1],y=g[c+t+h-1],x=g[c+t+h],z=g[c+t+h+1];w=(m+u+u+z-(v+w+w+y))*q;v=(y+x+x+z-(v+b+b+m))*r;v=Math.sqrt(w*w+v*v);k[c+h]=1===a||3===a?57.2957795*Math.atan(v):100*v}for(p=0;p<l;p++)k[p*t]=k[p*t+1],k[(p+1)*t-1]=k[(p+1)*t-2];for(p=1;p<t-1;p++)k[p]=k[p+t],k[p+(l-1)*t]=k[p+(l-2)*t];n.pixelType="F32";n.pixels=[k];n.statistics=[{minValue:0,maxValue:255}];f&&(n.mask=d);return{extent:e.extent,pixelBlock:n}}},
aspect:function(e){if(null!==e&&null!==e.pixelBlock&&null!==e.pixelBlock.pixels){var t=this._clonePixelBlock(e.pixelBlock),n=t.width,p=t.height,h=t.pixels[0],c=t.mask,a=new Uint8Array(n*p);c&&a.set(c);var b=new Float32Array(n*p),l=1/((e.extent.xmax-e.extent.xmin)/n),g=1/((e.extent.ymax-e.extent.ymin)/p),f,d;for(f=1;f<p-1;f++){var k=f*n;for(d=1;d<n-1;d++)if(c&&!c[k+d])b[k+d]=0;else{var m=0;if(c&&(m=c[k-n+d-1]+c[k-n+d]+c[k-n+d+1]+c[k+d-1]+c[k+d+1]+c[k+n+d-1]+c[k+n+d]+c[k+n+d+1],7>m)){b[k+d]=0;a[k+d]=
0;continue}if(7===m){m=c[k-n+d-1]?h[k-n+d-1]:h[k+d];var v=c[k-n+d]?h[k-n+d]:h[k+d];var q=c[k-n+d+1]?h[k-n+d+1]:h[k+d];var r=c[k+d-1]?h[k+d-1]:h[k+d];var w=c[k+d+1]?h[k+d+1]:h[k+d];var u=c[k+n+d-1]?h[k+n+d-1]:h[k+d];var y=c[k+n+d]?h[k+n+d]:h[k+d];var x=c[k+n+d+1]?h[k+n+d+1]:h[k+d]}else m=h[k-n+d-1],v=h[k-n+d],q=h[k-n+d+1],r=h[k+d-1],w=h[k+d+1],u=h[k+n+d-1],y=h[k+n+d],x=h[k+n+d+1];r=(q+w+w+x-(m+r+r+u))*l;m=(u+y+y+x-(m+v+v+q))*g;0===r&&0===m?m=-1:(m=90-57.29578*Math.atan2(m,-r),0>m&&(m+=360),360===m?
m=0:360<m&&(m%=360));b[k+d]=m}}for(f=0;f<p;f++)b[f*n]=b[f*n+1],b[(f+1)*n-1]=b[(f+1)*n-2];for(f=1;f<n-1;f++)b[f]=b[f+n],b[f+(p-1)*n]=b[f+(p-2)*n];t.pixelType="F32";t.pixels=[b];t.statistics={minValue:0,maxValue:360};c&&(t.mask=a);return{extent:e.extent,pixelBlock:t}}},_clonePixelBlock:function(e){return e.clone?e.clone():G.clone(e)}}})},"esri/layers/rasterLib/function/BandArithmeticFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin ./rasterIndex".split(" "),
function(G,e,t,n,p,h,c){return G([t,h],{declaredClass:"esri.layers.rasterLib.function.BandArithmeticFunction",functionName:"BandArithmetic",supportWebGL:!0,support2D:!0,constructor:function(a){this.functionArguments=this.mixinIgnoreCase({method:1,bandIndexes:"",raster:null},a)},bind:function(a){a=this.getSourceRasterInfo(a);if(!a.raster)return Error("The raster input to band arithmetic function is invalid.");this.rasterInfo=e.mixin(a.raster,{bandCount:8===this.functionArguments.method?a.raster.bandCount:
1,pixelType:this._calculatePixelType(this.pixelType,"F32"),statistics:null,histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType="Generic";return!0},read2D:function(a){this._performance.start();a=a.raster;var b=c.calculate(a.pixelBlock,{bandIndexes:this.functionArguments.bandIndexes,method:this.functionArguments.method});this._addPerformanceMetric(this._performance.elapsed());"Unknown"!==this.pixelType&&(b.pixelType=this.pixelType);
return{extent:a.extent,pixelBlock:b}},readGL:function(a){this._performance.start();this._initializeProgram({fragment:p.bandArithmetic,fragmentName:"bandArithmetic"});var b=this.functionArguments.bandIndexes.trim().split(" ").map(function(d){return parseInt(d,10)});this._infraredBandID=b[0]-1;this._visibleBandID=b[1]-1;this._alterBand=2<Math.max(this._infraredBandID,this._visibleBandID)?!0:!1;a=this._setupTextureData(a.raster,this._alterBand&&2==b.length?{bandIDs:[this._infraredBandID,this._visibleBandID,
this._infraredBandID]}:{bandIDs:[b[0]-1,b[1]-1,b[2]-1]});var l=this.bindFrameBuffer(),g=this.functionArguments.method,f=2<b.length?b.slice(2):null;this._alterBand?this._setUniforms({u_method:g,u_bandId_nir:0,u_bandId_red:1,u_constants:f}):this._setUniforms({u_method:g,u_bandId_nir:b[0]-1,u_bandId_red:b[1]-1,u_constants:f});this._bindTexture(a.texture,"u_image");this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:a.extent,texture:l.texture}}})})},"esri/layers/rasterLib/function/rasterIndex":function(){define(["dojo/_base/lang"],
function(G){return{calculate:function(e,t){if(e&&e.pixels&&e.pixels.length){var n=t&&t.bandIndexes;t=t&&t.method;var p=n.trim().split(" ").map(function(a){return parseInt(a,10)}).filter(function(a){return null!=a});e=this._clonePixelBlock(e);var h=e.pixels,c=e.mask;switch(t){case 1:h=this._calculateNDVI(c,h[p[0]-1],h[p[1]-1]);break;case 2:h=this._calculateSAVI(c,h[p[0]-1],h[p[1]-1],p[2]);break;case 3:h=this._calculateTSAVI(c,h[p[0]-1],h[p[1]-1],p[2],p[3],p[4]);break;case 4:h=this._calculateMSAVI(c,
h[p[0]-1],h[p[1]-1]);break;case 5:h=this._calculateGEMI(c,h[p[0]-1],h[p[1]-1]);break;case 6:h=this._calculatePVI(c,h[p[0]-1],h[p[1]-1],p[2],p[3]);break;case 7:h=this._calculateGVITM(c,h[p[0]-1],h[p[1]-1],h[p[2]-1],h[p[3]-1],h[p[4]-1],h[p[5]-1]);break;case 8:h=this._calculateSultan(c,h[p[0]-1],h[p[1]-1],h[p[2]-1],h[p[3]-1],h[p[4]-1],h[p[5]-1]);break;case 9:h=this._calculateVARI(c,h[p[0]-1],h[p[1]-1],h[p[2]-1]);break;case 0:h=this._calculateUserDefined(c,h,n)}e.pixels=h;e.pixelType="F32";e.calculateStatistics();
return e}},_clonePixelBlock:function(e){return e.clone?e.clone():G.clone(e)},_parseUserDefined:function(e,t){e=e.replace(" ","");0===e.indexOf("-")&&(e="0"+e);0===e.indexOf("+")&&(e=e.slice(1,e.length));e=e.split("");var n=[],p=[],h="+-*/()".split(""),c,a="";for(c=0;c<e.length;c++){var b=e[c];h.some(function(l){return l===b})?(""!==a&&p.push(parseFloat(a)),n.push(b),a=""):"b"===b.toLowerCase()?(c++,a=b.concat(e[c]),p.push(t[parseInt(a[1],10)-1]),a=""):(a=a.concat(b),c===e.length-1&&p.push(parseFloat(a)))}return{ops:n,
nums:p}},_op:function(e,t,n,p){if(n.constructor===Number&&p.constructor===Number)return n+p;var h;if(n.constructor===Number){var c=p.length;var a=n;n=new Float32Array(c);for(h=0;h<c;h++)n[h]=a}else if(c=n.length,p.constructor===Number)for(a=p,p=new Float32Array(c),h=0;h<c;h++)p[h]=a;a=new Float32Array(c);if(null==e)if("+"===t)for(h=0;h<c;h++)a[h]=n[h]+p[h];else if("-"===t)for(h=0;h<c;h++)a[h]=n[h]-p[h];else if("*"===t)for(h=0;h<c;h++)a[h]=n[h]*p[h];else{if("/"===t)for(h=0;h<c;h++)a[h]=n[h]/p[h]}else if("+"===
t)for(h=0;h<c;h++)e[h]&&(a[h]=n[h]+p[h]);else if("-"===t)for(h=0;h<c;h++)e[h]&&(a[h]=n[h]-p[h]);else if("*"===t)for(h=0;h<c;h++)e[h]&&(a[h]=n[h]*p[h]);else if("/"===t)for(h=0;h<c;h++)e[h]&&(a[h]=n[h]/p[h]);return a},_shrinkOp:function(e,t){e.splice(t,1);var n=t=0,p=0;do{for(t=p=n=0;t<e.length;t++)if("("===e[t])n=t;else if(")"===e[t]){p=t;break}p===n+1&&e.splice(n,2)}while(p===n+1);return e},_getPriorityOpIndex:function(e,t){if(1===e.length)return{opIndex:0,numIndex:0};var n=t=0,p=0,h=-1,c=0;for(t=
0;t<e.length;t++)if("("===e[t])n=t;else if(")"===e[t]){p=t;break}var a=0===p?e:e.slice(n+1,p);for(t=0;t<a.length;t++)if("*"===a[t]||"/"===a[t]){h=t;break}if(!(-1<h))for(t=0;t<a.length;t++)if("+"===a[t]||"-"===a[t]){h=t;break}0<p&&(h+=n+1);for(t=0;t<h;t++)"("===e[t]&&c++;return{opIndex:h,numIndex:h-c}},_calculateUserDefined:function(e,t,n){t=this._parseUserDefined(n,t);n=t.ops;for(var p=t.nums,h,c,a;0<n.length&&(t=this._getPriorityOpIndex(n,p),h=n[t.opIndex],c=p[t.numIndex],a=p[t.numIndex+1],h=this._op(e,
h,c,a),1!==n.length);)n=this._shrinkOp(n,t.opIndex),p.splice(t.numIndex,2,h);return[h]},_calculateNDVI:function(e,t,n){var p=n.length,h=new Float32Array(p),c;if(null==e)for(c=0;c<p;c++){var a=n[c];var b=t[c];h[c]=(b-a)/(b+a)}else for(c=0;c<p;c++)e[c]&&(a=n[c],b=t[c],h[c]=(b-a)/(b+a));return[h]},_calculateSAVI:function(e,t,n,p){var h=n.length,c=new Float32Array(h),a;if(null==e)for(a=0;a<h;a++){var b=n[a];var l=t[a];c[a]=(l-b)/(l+b+p)*(1+p)}else for(a=0;a<h;a++)e[a]&&(b=n[a],l=t[a],c[a]=(l-b)/(l+b+
p)*(1+p));return[c]},_calculateTSAVI:function(e,t,n,p,h,c){var a=n.length,b=new Float32Array(a),l=-h*p+c*(1+p*p);if(null==e)for(c=0;c<a;c++){var g=n[c];var f=t[c];b[c]=p*(f-p*g-h)/(h*f+g+l)}else for(c=0;c<a;c++)e[c]&&(g=n[c],f=t[c],b[c]=p*(f-p*g-h)/(h*f+g+l));return[b]},_calculateMSAVI:function(e,t,n){var p=n.length,h=new Float32Array(p),c;if(null==e)for(c=0;c<p;c++){var a=n[c];var b=t[c];h[c]=.5*(2*(b+1)-Math.sqrt(Math.pow(2*b+1,2)-8*(b-a)))}else for(c=0;c<p;c++)e[c]&&(h[c]=.5*(2*(b+1)-Math.sqrt(Math.pow(2*
b+1,2)-8*(b-a))));return[h]},_calculateGEMI:function(e,t,n){var p=n.length,h=new Float32Array(p),c;if(null==e)for(c=0;c<p;c++){var a=n[c];var b=t[c];b=(2*(b*b-a*a)+1.5*b+.5*a)/(b+a+.5);h[c]=b*(1-.25*b)-(a-.125)/(1-a)}else for(c=0;c<p;c++)e[c]&&(a=n[c],b=t[c],b=(2*(b*b-a*a)+1.5*b+.5*a)/(b+a+.5),h[c]=b*(1-.25*b)-(a-.125)/(1-a));return[h]},_calculatePVI:function(e,t,n,p,h){var c=n.length,a=new Float32Array(c),b,l=Math.sqrt(1+p*p);if(null==e)for(b=0;b<c;b++){var g=n[b];var f=t[b];a[b]=(f-p*g-h)/l}else for(b=
0;b<c;b++)e[b]&&(g=n[b],f=t[b],a[b]=(f-p*g-h)/l);return[a]},_calculateGVITM:function(e,t,n,p,h,c,a){var b=t.length,l=new Float32Array(b),g;if(null==e)for(g=0;g<b;g++)l[g]=-.2848*t[g]-.2435*n[g]-.5436*p[g]+.7243*h[g]+.084*c[g]-1.18*a[g];else for(g=0;g<b;g++)e[g]&&(l[g]=-.2848*t[g]-.2435*n[g]-.5436*p[g]+.7243*h[g]+.084*c[g]-1.18*a[g]);return[l]},_calculateSultan:function(e,t,n,p,h,c,a){n=t.length;var b=new Float32Array(n),l=new Float32Array(n),g=new Float32Array(n),f;if(null==e)for(f=0;f<n;f++)b[f]=
c[f]/a[f]*100,l[f]=c[f]/t[f]*100,g[f]=p[f]/h[f]*(c[f]/h[f])*100;else for(f=0;f<n;f++)e[f]&&(b[f]=c[f]/a[f]*100,l[f]=c[f]/t[f]*100,g[f]=p[f]/h[f]*(c[f]/h[f])*100);return[b,l,g]},_calculateVARI:function(e,t,n,p){var h=t.length,c=new Float32Array(h),a;if(null==e)for(a=0;a<h;a++){var b=t[a];var l=n[a];var g=p[a];c[a]=(l-b)/(l+b-g)}else for(a=0;a<h;a++)if(e[a])for(a=0;a<h;a++)b=t[a],l=n[a],g=p[a],c[a]=(l-b)/(l+b-g);return[c]}}})},"esri/layers/rasterLib/function/ColormapFunction":function(){define("dojo/_base/declare dojo/_base/lang ../../../renderers/colorRampGenerator ./RasterFunctionX ./pixelShaders ./RasterFunctionWebGLMixin ./rasterUtils".split(" "),
function(G,e,t,n,p,h,c){return G([n,h],{declaredClass:"esri.layers.rasterLib.function.ColormapFunction",functionName:"Colormap",pixelType:"U8",renderTexture:!1,supportWebGL:!0,support2D:!0,constructor:function(a){this.functionArguments=this.mixinIgnoreCase({colormap:null,colorRampName:null,colorRamp:null,colorMapName:null,raster:null},a);this.invert=a&&a.invert;a=a.colormap||a.Colormap;if(a){if(a.features||a[0].attributes){a=a.features||a;var b=Object.keys(a[0].attributes);var l=b.filter(function(v){return"alpha"===
v.toLowerCase()})[0];var g=b.filter(function(v){return"value"===v.toLowerCase()})[0];var f=b.filter(function(v){return"red"===v.toLowerCase()})[0];var d=b.filter(function(v){return"green"===v.toLowerCase()})[0];var k=b.filter(function(v){return"blue"===v.toLowerCase()})[0];if(!(g&&f&&d&&k))throw"invalid colormap";a=a.map(function(v){return l?[v.attributes[g],v.attributes[f],v.attributes[d],v.attributes[k],v.attributes[l]]:[v.attributes[g],v.attributes[f],v.attributes[d],v.attributes[k]]});var m=1.1>
Math.max.apply(null,a.map(function(v){return v[1]}));b=l&&1.1>Math.max.apply(null,a.map(function(v){return v[4]}));if(m)for(m=0;m<a.length;m++)a[m][1]=Math.round(255*a[m][1]),a[m][2]=Math.round(255*a[m][2]),a[m][3]=Math.round(255*a[m][3]),b&&(a[m][4]=Math.round(255*a[m][4]))}this.functionArguments.colormap=this._sortClr(a)}this._initialize()},bind:function(a){this._initialize();a=this.getSourceRasterInfo(a);if(!a.raster||"F32"===a.raster.pixelType)return Error("The raster input to colormap function is invalid. It must be integer type.");
this.rasterInfo=e.mixin(a.raster,{bandCount:3,pixelType:this._calculatePixelType(this.pixelType,"U8"),statistics:null,histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType="Processed";return!0},read2D:function(a){return this._colorize(a.raster)},readGL:function(a){return this._colorizeGL(a.raster)},_colorize:function(a){this._performance.start();var b=c.colorize(a.pixelBlock,{indexedColormap:this._indexedColormap,indexedColormapOffset:this._indexedColormapOffset,
indexed2DColormap:this._indexed2DColormap,alphaSpecified:this._alphaSpecified});this._addPerformanceMetric(this._performance.elapsed());return{extent:a.extent,pixelBlock:b}},_binarySearchClr:function(a,b){for(var l=0,g=a.length-1,f=0,d=0;l<g;)if(f=Math.floor((l+g)/2),d=a[f],d[0]<b)l=f;else if(d[0]>b)g=f;else return d.slice(1);return null},_sortClr:function(a,b){var l,g=[];for(l=0;l<a.length;l++)g.push(a[l]);for(l=0;l<g.length-1;l++){var f=g[l];for(a=l+1;a<g.length;a++)f[0]>g[a][0]&&(f=g[a],g[a]=g[l],
g[l]=f)}if(b)for(l=0;l<g.length/2;l++)f=g[l],g[g.length-1-l]=g[l],g[l]=f;return g},_invertColorRamp:function(a){if(!a)return a;var b={type:a.type};"random"===a.type?b=a:"multipart"===a.type?b.colorRamps=a.colorRamps.map(function(l){return{fromColor:l.toColor,toColor:l.fromColor}}).reverse():(b.fromColor=a.toColor,b.toColor=a.fromColor);return b},_initialize:function(){this._indexedColormapOffset=0;if(this.functionArguments.colormap){var a=c.buildIndexedColormap(this.functionArguments.colormap);this._alphaSpecified=
a&&a.alphaSpecified;this._indexedColormap=a&&a.indexedColormap;this._indexedColormapOffset=a&&a.offset;this._indexedColormap||(this._indexed2DColormap=this._getIndexed2DColormap())}else this.functionArguments.colorRamp?this._indexedColormap="multipart"===this.functionArguments.colorRamp.type?this.invert?t.createMultiPartColorRamp(this._invertColorRamp(this.functionArguments.colorRamp)):t.createMultiPartColorRamp(this.functionArguments.colorRamp):this.invert?t.createAlgorithmicColorRamp(this._invertColorRamp(this.functionArguments.colorRamp)):
t.createAlgorithmicColorRamp(this.functionArguments.colorRamp):this.functionArguments.colormapName&&"random"===this.functionArguments.colormapName.toLowerCase()&&(this._indexedColormap=t.createRandomColorRamp())},_getIndexed2DColormap:function(){var a=this.functionArguments.colormap;if(!a)return null;var b=0;0>a[0][0]&&(b=a[0][0]);var l=[],g=5===a[0].length,f;for(f=0;f<a.length;f++)l[a[f][0]-b]=g?a[f].slice(1):a[f].slice(1).concat([255]);return l},_colorizeGL:function(a){this._performance.start();
this._initializeProgram({fragment:p.colormap,fragmentName:"Colormap"});var b=this._indexedColormap,l=this._indexedColormapOffset;this._clrTexture||(this._clrTexture=this._setupColormapTexture(b));var g=this._clrTexture,f=this.bindFrameBuffer();a=this._setupTextureData(a);this._setUniforms({u_indexedColormapOffset:l,u_indexedColormapMaxIndex:b.length/4-1});this._bindTexture(g,"u_image1");this._bindTexture(a.texture,"u_image");this._drawGL();return{extent:a.extent,texture:f.texture}},_setupColormapTexture:function(a){var b=
this._createTexture(),l=this.gl,g=a.length/4,f=new Float32Array(a.length),d,k=this.renderTexture?255:1;for(d=0;d<a.length;d++)f[d]=a[d]/k;l.getExtension("OES_texture_float");l.texImage2D(l.TEXTURE_2D,0,l.RGBA,g,1,0,l.RGBA,l.FLOAT,f);return b}})})},"esri/renderers/colorRampGenerator":function(){define(["dojo/_base/declare","dojo/_base/lang","../renderers/colorUtils"],function(G,e,t){return{createAlgorithmicColorRamp:function(n,p){if(!n)return null;var h=n.fromColor,c=n.toColor;if(!h||!c)return null;
void 0===h.r&&3<=h.length&&(h={r:h[0],g:h[1],b:h[2]});void 0===c.r&&3<=c.length&&(c={r:c[0],g:c[1],b:c[2]});var a=n.size||256;n=n.algorithm||"cie-lab";if(1===a)var b=[h.r,h.g,h.b,255];else if(2===a)b=[h.r,h.g,h.b,255,c.r,c.g,h.b,255];else if(-1<n.toLowerCase().indexOf("hsv")){b=t.toHSV(h);c=t.toHSV(c);a=a||256;var l=0===b.s,g=0===c.s;h=b.h;n=c.h;l&&!g?h=b.h=n:g&&!l&&(n=c.h=h);l=Math.abs(n-h);180>l?n=(n-h)/(a-1):(l=360-l,n=h>n?l/(a-1):-l/(a-1));l=(c.s-b.s)/(a-1);g=(c.v-b.v)/(a-1);var f=b.s;b=b.v;var d,
k=new Uint8Array(4*a);for(d=0;d<a-1;d++){var m=t.toRGB({h:h,s:f,v:b});k[4*d]=m.r;k[4*d+1]=m.g;k[4*d+2]=m.b;k[4*d+3]=255;h+=n;f+=l;b+=g;360<h?h-=360:0>h&&(h+=360)}m=t.toRGB(c);k[4*(a-1)]=m.r;k[4*(a-1)+1]=m.g;k[4*(a-1)+2]=m.b;k[4*(a-1)+3]=255;b=k}else if(-1<n.toLowerCase().indexOf("lch")){f=t.toLCH(h);c=t.toLCH(c);a=a||256;b=(c.l-f.l)/(a-1);h=(c.c-f.c)/(a-1);n=(c.h-f.h)/(a-1);l=f.l;g=f.c;f=f.h;k=new Uint8Array(4*a);for(d=0;d<a-1;d++)m=t.toRGB({l:l,c:g,h:f}),k[4*d]=m.r,k[4*d+1]=m.g,k[4*d+2]=m.b,k[4*
d+3]=255,l+=b,g+=h,f+=n;m=t.toRGB(c);k[4*(a-1)]=m.r;k[4*(a-1)+1]=m.g;k[4*(a-1)+2]=m.b;k[4*(a-1)+3]=255;b=k}else if(-1<n.toLowerCase().indexOf("lab")){f=t.toLAB(h);c=t.toLAB(c);a=a||256;b=(c.l-f.l)/(a-1);h=(c.a-f.a)/(a-1);n=(c.b-f.b)/(a-1);l=f.l;g=f.a;f=f.b;k=new Uint8Array(4*a);for(d=0;d<a-1;d++)m=t.toRGB({l:l,a:g,b:f}),k[4*d]=m.r,k[4*d+1]=m.g,k[4*d+2]=m.b,k[4*d+3]=255,l+=b,g+=h,f+=n;m=t.toRGB(c);k[4*(a-1)]=m.r;k[4*(a-1)+1]=m.g;k[4*(a-1)+2]=m.b;k[4*(a-1)+3]=255;b=k}if(p&&!1===p.flattened)for(p=b,
b=[],c=0;c<b/4;c++)b[c]=p.slice(4*c,4*c+4);return b},createMultiPartColorRamp:function(n,p){if(!n)return null;p=p&&e.clone(p)||{flattened:!0};var h=n.colorRamps;if(!h||0===h.length)return null;var c=n.size||256;n=Math.max(Math.floor(c/h.length),1);var a=Math.max(n,c-(h.length-1)*n),b=!1!==p.flattened;p.flattened=!0;c=(h.length-1)*n+a;var l=new Uint8Array(4*c);for(c=0;c<h.length;c++){var g={fromColor:h[c].fromColor,toColor:h[c].toColor,size:c===h.length-1?a:n};l instanceof Array?l.concat(this.createAlgorithmicColorRamp(g,
p)):l.set(this.createAlgorithmicColorRamp(g,p),n*c*4)}if(!b)for(p=l,l=[],c=0;c<l/4;c++)l[c]=p.slice(4*c,4*c+4);return l},createRandomColorRamp:function(n){n=n||{};var p=n.size||256,h=!1===n.flattened;var c=h?new Uint8Array(4*p):[];for(n=0;n<p;n++)h?(c[4*n]=Math.round(255*Math.random()),c[4*n+1]=Math.round(255*Math.random()),c[4*n+2]=Math.round(255*Math.random()),c[4*n+3]=255):c[n]=[Math.round(255*Math.random()),Math.round(255*Math.random()),Math.round(255*Math.random()),255];return c}}})},"esri/layers/rasterLib/function/rasterUtils":function(){define(["dojo/_base/lang"],
function(G){return{mask:function(e,t){if(e&&e.pixels&&e.pixels.length){e=this._clonePixelBlock(e);var n=t.includedRanges,p=t.noDataInterpretation;t=t.noDataValues;if(null===n&&null===t)return e;var h=e.pixels,c=e.mask,a=e.width*e.height,b=h.length,l;if(null!==t&&t.length!==b)throw"expect "+b+" elements in noDataValues";if(null!==n&&n.length!==2*b)throw"expect "+2*b+" elements in IncludeRanges";if(null==c){c=new Uint8Array(a);for(l=0;l<a;l++)c[l]=1;e.mask=c}if(0===p)for(p=0;p<b;p++){var g=h[p];var f=
null===n?null:n[2*p];var d=null===n?null:n[2*p+1];var k=null===t?null:parseFloat(t[p]);if(null===f||null===d)for(l=0;l<a;l++){if(c[l]){var m=g[l];m===k&&(c[l]=0)}}else if(null===k)for(l=0;l<a;l++)c[l]&&(m=g[l],m<f||m>d)&&(c[l]=0);else for(l=0;l<a;l++)c[l]&&(m=g[l],m<f||m>d||m===k)&&(c[l]=0)}else{var v=new Uint8Array(a);for(l=0;l<a;l++)v[l]=c[l];for(p=0;p<b;p++)if(g=h[p],f=null===n?null:n[2*p],d=null===n?null:n[2*p+1],k=null===t?null:parseFloat(t[p]),null===f||null===d)for(l=0;l<a;l++)v[l]&&(m=g[l],
m!==k&&(v=0));else if(null===k)for(l=0;l<a;l++)v[l]&&(m=g[l],m<=f&&m<=d&&(v=0));else for(l=0;l<a;l++)v[l]&&(m=g[l],m<=f&&m<=d&&m!==k&&(v=0));for(l=0;l<a;l++)c[l]&&v[l]&&(c[l]=0)}return e}},calculateStatisticsHistograms:function(e,t){e=this._clonePixelBlock(e);t=e.pixelType;var n=e.pixels,p=e.mask,h=n.length,c,a,b=[],l;for(c=0;c<h;c++){var g={min:-.5,max:255.5,size:256,counts:new Uint32Array(256)};var f=g.counts;var d=n[c];if("U8"===t)if(p)for(a=0;a<e.width*e.height;a++)p[a]&&f[d[a]]++;else for(a=
0;a<e.width*e.height;a++)f[d[a]]++;else{var k=e.statistics[c].minValue;var m=e.statistics[c].maxValue;g.min=k;g.max=m;m=(m-k)/256;var v=new Uint32Array(257);if(p)for(a=0;a<e.width*e.height;a++)p[a]&&v[Math.floor((d[a]-k)/m)]++;else for(a=0;a<e.width*e.height;a++)v[Math.floor((d[a]-k)/m)]++;for(a=0;255>a;a++)f[a]=v[a];f[255]=v[255]+v[256]}b.push(g);k=e.statistics[c].minValue;m=e.statistics[c].maxValue;for(a=v=l=d=0;a<g.size;a++)d+=f[a],l+=a*f[a];l/=d;for(a=0;a<g.size;a++)v+=f[a]*Math.pow(a-l,2);f=
Math.sqrt(v/(d-1));a=(l+.5)*(g.max-g.min)/g.size+g.min;g=f*(g.max-g.min)/g.size;e.statistics[c]={min:k,minValue:k,max:m,maxValue:m,mean:a,stddev:g}}e.histograms=b;return e},buildIndexedColormap:function(e,t){if(!e)return null;var n=0;0>e[0][0]&&(n=e[0][0]);var p=Math.max(256,e[e.length-1][0]-n);if(65536<p)return null;var h=new Uint8Array(4*p),c=[],a=0,b=5===e[0].length;if(t)for(c=e[a],t=c[0]-n;t<p;t++)h[4*t]=c[1],h[4*t+1]=c[2],h[4*t+2]=c[3],h[4*t+3]=b?c[4]:255,t===c[0]-n&&(c=a===e.length-1?c:e[++a]);
else for(t=0;t<e.length;t++)c=e[t],a=4*(c[0]-n),h[a]=c[1],h[a+1]=c[2],h[a+2]=c[3],h[a+3]=b?c[4]:255;return{indexedColormap:h,offset:n,alphaSpecified:b}},colorize:function(e,t){if(null!==e&&null!==e.pixels){e=this._clonePixelBlock(e);var n=e.pixels,p=e.width*e.height,h=e.mask,c=t.indexedColormap,a=t.indexedColormapOffset,b=c&&c.length-1,l=t.indexed2DColormap;t=t.alphaSpecified;if(3<=n.length)throw"colormap only works on single band image";var g=n[0],f=new Uint8Array(g.length),d=new Uint8Array(g.length),
k=new Uint8Array(g.length),m=0;if(c)if(h)for(n=0;n<p;n++)h[n]&&(m=4*(g[n]-a),m<a||m>b?h[n]=0:(f[n]=c[m],d[n]=c[m+1],k[n]=c[m+2],h[n]=c[m+3]));else{h=new Uint8Array(p);for(n=0;n<p;n++)m=4*(g[n]-a),m<a||m>b?h[n]=0:(f[n]=c[m],d[n]=c[m+1],k[n]=c[m+2],h[n]=c[m+3]);e.mask=h}else if(h)for(n=0;n<p;n++)h[n]&&(c=l[g[n]],f[n]=c[0],d[n]=c[1],k[n]=c[2],h[n]=c[3]);else{h=new Uint8Array(p);for(n=0;n<p;n++)c=l[g[n]],f[n]=c[0],d[n]=c[1],k[n]=c[2],h[n]=c[3];e.mask=h}e.pixels=[f,d,k];e.statistics=null;e.pixelType="U8";
e.maskIsAlpha=t;return e}},convolute:function(e,t){e=this._clonePixelBlock(e);var n=e.pixels,p=e.width,h=e.height,c=p*h,a=n.length,b,l,g,f,d=[],k=[],m=t.normalizedKernel,v=t.kernelRows,q=t.kernelCols;for(t=0;t<a;t++){var r=n[t];var w=new Float32Array(c);w.set(r);for(g=1;g<h-1;g++){var u=g*p;for(f=1;f<p-1;f++){for(b=k=0;b<v;b++)for(l=0;l<q;l++)k+=r[u+f+(b-1)*p+l-1]*m[b*q+l];w[u+f]=k}}d.push(w)}e.pixels=d;return e},contrastBrightnessStretch:function(e,t){if(null!==e&&null!==e.pixels){e=this._clonePixelBlock(e);
var n=e.pixels,p=e.mask,h=e.width*e.height,c=n.length;var a=t&&t.contrastOffset;t=t&&t.brightnessOffset;if("U8"!==e.pixelType)throw"the contrast and brightness function only supports 8 bit unsigned integer data";var b=this._createContrastBrightnessLUT(a,t);if(null==p)for(a=0;a<h;a++)for(t=0;t<c;t++)n[t][a]=b[n[t][a]];else for(a=0;a<h;a++)if(p[a])for(t=0;t<c;t++)n[t][a]=b[n[t][a]];e.pixelType="U8";return e}},isNull:function(e,t){if(null!==e&&null!==e.pixels){e=this._clonePixelBlock(e);t=e.mask;var n=
e.pixels[0],p=n.length,h;if(t){for(h=0;h<p;h++)n[h]=t[h]?0:1;e.mask=null}else if(n.fill)n.fill(0);else for(h=0;h<p;h++)n[h]=0;return e}},setNull:function(e){if(null!==t&&null!==t.pixels){var t=this._clonePixelBlock(e);e=t.mask;var n=t.pixels[0],p=n.length,h;e=e||new Uint8Array(p);for(h=0;h<p;h++)e[h]=n[h]?0:1;t.mask=e;return t}},local:function(e,t){if(!t)return e[0];var n=t.rasterCountNeeded;t=t.functor;var p=this._clonePixelBlock(e[0]);if(null!==p&&null!==p.pixels){var h=p.width*p.height,c;e=(c=
e[1])&&c.pixels[0];var a=c&&c.mask,b=p.mask,l=p.pixels[0];if(2===n)if(!b&&a)b=a;else if(b&&a)for(c=0;c<h;c++)b[c]=b[c]&&a[c]?1:0;p.mask=b;if(1===n)if(null==b)for(c=0;c<h;c++)l[c]=t(l[c]);else for(c=0;c<h;c++)b[c]&&(l[c]=t(l[c]));else if(2===n)if(null==b)for(c=0;c<h;c++)l[c]=t(l[c],e[c]);else for(c=0;c<h;c++)b[c]&&(l[c]=t(l[c],e[c]));p.mask=b;p.calculateStatistics();return p}},remapColor:function(e,t){e=this._clonePixelBlock(e);var n=e.width*e.height,p=t.length,h=Math.floor(p/2),c=t[Math.floor(h)],
a=t[0].value,b=t[t.length-1].value,l=e.pixels[0],g,f,d=!1,k=new Uint8Array(n),m=new Uint8Array(n),v=new Uint8Array(n),q=e.mask,r=4===t[0].mappedColor.length;q&&0!==q.length||(q=new Uint8Array(n),q.fill(r?255:1),e.mask=q);for(f=0;f<n;f++)if(q[f]){var w=l[f];if(w<a||w>b)k[f]=m[f]=v[f]=q[f]=0;else{d=!1;var u=h;var y=c;var x=0;for(g=p-1;1<g-x;){if(w===y.value){d=!0;break}w>y.value?x=u:g=u;u=Math.floor((x+g)/2);y=t[Math.floor(u)]}d||(y=w===t[g].value?t[g]:t[x]);k[f]=y.mappedColor[0];m[f]=y.mappedColor[1];
v[f]=y.mappedColor[2];q[f]=y.mappedColor[3]}}e.pixels=[k,m,v];e.mask=q;e.pixelType="u8";e.maskIsAlpha=r;return e},_clonePixelBlock:function(e){if(e.clone)return e.clone();var t=G.clone(e),n;if(e.pixels&&e.pixels[0]&&0<e.pixels[0].length&&!(t.pixels&&t.pixels[0]&&0<t.pixels[0].length)){t.pixels=[];var p=e.pixels.length;for(n=0;n<p;n++)t.pixels[n]=new e.pixels[n].constructor(e.pixels[n])}if(e.statistics)for(t.statistics=[],p=e.statistics.length,n=0;n<p;n++)t.statistics[n]=G.clone(e.statistics[n]);e.mask&&
(t.mask=new Uint8Array(e.mask));return t},_createContrastBrightnessLUT:function(e,t){if(this._contrastCache&&this._contrastCache.contrastOffset===e&&this._contrastCache.brightnessOffset===t)return this._contrastCache.lut;var n=Math.min(Math.max(e,-100),100),p=Math.min(Math.max(t,-100),100),h,c=new Uint8Array(256);for(h=0;256>h;h++){if(0<n&&100>n)var a=(200*h-25500+510*p)/(2*(100-n))+128;else 0>=n&&-100<n?a=(200*h-25500+510*p)*(100+n)/2E4+128:100===n?(a=200*h-25500+256*(100-n)+510*p,a=0<a?255:0):-100===
n&&(a=128);c[h]=255<a?255:0>a?0:a}this._contrastCache={contrastOffset:e,brightnessOffset:t,lut:c};return c}}})},"esri/layers/rasterLib/function/CompositeBandFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin".split(" "),function(G,e,t,n,p,h){return G([t,h],{declaredClass:"esri.layers.rasterLib.function.CompositeBandFunction",functionName:"CompositeBand",supportWebGL:!0,support2D:!0,constructor:function(c){this.functionArguments=
this.mixinIgnoreCase({rasters:null},c)},bind:function(c){c=this.getSourceRasterInfo(c);if(!c.rasters)return Error("The rasters input to composite band function is invalid.");var a=[],b=[],l=c.rasters.length,g;if(c.rasters[0].statistics)for(g=0;g<l;g++)a.push(c.rasters[g].statistics[0]);if(c.rasters[0].histograms)for(g=0;g<l;g++)b.push(c.rasters[g].histograms[0]);this.rasterInfo=e.mixin(c.rasters[0],{bandCount:l,pixelType:this._calculatePixelType(this.pixelType,c.rasters[0].pixelType),statistics:a,
histograms:b});return!0},read2D:function(c){c=c.rasters;if(null!=c&&0!==c.length){var a=this._clonePixelData(c[0]),b=a.pixelBlock,l=[],g=[];for(f=0;f<c.length;f++)l.push(c[f].pixelBlock.pixels[0]),g.push(c[f].pixelBlock.statistics[0]);b.pixels=l;b.stackedStatistics=g;b.planes=c.length;var f;g=b.width*b.height;for(f=0;f<c.length;f++)if(b=c[f].pixelBlock.mask,d&&b)for(l=0;l<g;l++)d[l]&=b[l];else var d=d||b;a.maks=d;return a}},readGL:function(c){this._performance.start();this._initializeProgram({fragment:p.compositeBand,
fragmentName:"CompositeBand"});var a=c.rasters;if(null!=a&&0!==a.length){a=a.length;var b,l=this.bindFrameBuffer();for(b=0;b<a;b++){var g=this._setupTextureData(c.rasters[b],{notOriginal:0<b});var f=0<b?b.toString():"";this._bindTexture(g.texture,"u_image"+f)}this._setUniforms({u_rasterCount:a});this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:g.extent,texture:l.texture}}}})})},"esri/layers/rasterLib/function/ContrastBrightnessFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin ./rasterUtils".split(" "),
function(G,e,t,n,p,h,c){return G([t,h],{declaredClass:"esri.layers.rasterLib.function.ContrastBrightnessFunction",renderTexture:!0,functionName:"ContrastBrightness",supportWebGL:!0,support2D:!0,pixelType:"U8",constructor:function(a){this.functionArguments=this.mixinIgnoreCase({contrastOffset:0,brightnessOffset:0,raster:null},a)},bind:function(a){a=this.getSourceRasterInfo(a);if(!a.raster)return Error("The raster input to contrast and brightness function is invalid.");this.rasterInfo=e.mixin(a.raster,
{bandCount:a.raster.bandCount,pixelType:this._calculatePixelType(this.pixelType,"U8"),statistics:null,histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType="Processed";return!0},read2D:function(a){a=a.raster;if(null!==a&&null!==a.pixelBlock&&null!==a.pixelBlock.pixels){var b=c.contrastBrightnessStretch(a.pixelBlock,{contrastOffset:this.functionArguments.contrastOffset,brightnessOffset:this.functionArguments.brightnessOffset});"Unknown"!==
this.pixelType&&(b.pixelType=this.pixelType,b.pixels=b.pixels.map(e.hitch(this,function(l){return this._clampBand(l,b.pixelType)})));return{extent:a.extent,pixelBlock:b}}},readGL:function(a){return this._cbGL(a.raster)},_cbGL:function(a){this._performance.start();this._initializeProgram({fragment:p.contrastBrightness,fragmentName:"ContrastBrightness"});a=this._setupTextureData(a);this._setUniforms({u_contrastOffset:Math.min(Math.max(this.functionArguments.contrastOffset,-100),100),u_brightnessOffset:Math.min(Math.max(this.functionArguments.brightnessOffset,
-100),100),u_scaleFactor:this.renderTexture?255:1});this._bindTexture(a.texture,"u_image");var b=this.bindFrameBuffer();this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:a.extent,texture:b.texture}}})})},"esri/layers/rasterLib/function/ConvolutionFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./convolutionKernel ./pixelShaders ./RasterFunctionWebGLMixin ./rasterUtils".split(" "),function(G,e,t,n,p,h,c,a){return G([t,
c],{declaredClass:"esri.layers.rasterLib.function.ConvolutionFunction",functionName:"Convolution",supportWebGL:!0,support2D:!0,constructor:function(b){this.functionArguments=this.mixinIgnoreCase({columns:3,rows:3,type:0,kernel:null,raster:null},b)},bind:function(b){b=this.getSourceRasterInfo(b);if(!b.raster)return Error("The raster input to convolution function is invalid.");this.rasterInfo=e.mixin(b.raster,{bandCount:b.raster.bandCount,pixelType:this._calculatePixelType(this.pixelType,b.raster.pixelType),
statistics:b.raster.statistics,histograms:b.raster.histograms});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType="Generic";return!0},read2D:function(b){this._performance.start();b=b.raster;var l=this._analyzeKernel(),g=a.convolute(b.pixelBlock,{normalizedKernel:l.normalizedKernel,kernelCols:this.functionArguments.columns,kernelRows:this.functionArguments.rows});this._addPerformanceMetric(this._performance.elapsed());"Unknown"!==this.pixelType&&
(g.pixelType=this.pixelType);g.pixels=g.pixels.map(e.hitch(this,function(f){return this._clampBand(f,g.pixelType)}));return{extent:b.extent,pixelBlock:g}},readGL:function(b){this._performance.start();this._initializeProgram({fragment:h.convolution,fragmentName:"Convolution"});var l=this._setupTextureData(b.raster),g=this.bindFrameBuffer(),f=this.gl,d=f.drawingBufferWidth;f=f.drawingBufferHeight;var k=this.functionArguments.kernel;this._setUniforms({u_resolution:b&&b.raster&&b.raster.pixelBlock?[1/
b.raster.pixelBlock.width,1/b.raster.pixelBlock.height]:[1/d,1/f],u_kernel:k,u_kernelSize:k.length});this._bindTexture(l.texture,"u_image");this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:l.extent,texture:g.texture}},_analyzeKernel:function(){var b=this.functionArguments.kernel,l=b.reduce(function(d,k){return d+k});0!==l&&1!==l&&(b=b.map(function(d){return d/l}));var g,f=[];for(g=0;g<b.length;g++)f.some(function(d){return d===b[g]})||f.push(b[g]);return{normalizedKernel:b,
distinctValues:f}},_analyzeKernelPattern:function(){var b=this.functionArguments.rows,l=this.functionArguments.columns,g=this.functionArguments.kernel,f=[],d,k;for(d=0;d<b;d++)f.push({weights:g.slice(d*l,(d+1)*l)});var m;for(d=1;d<b;d++){var v=f[d].weights;for(g=0;g<d;g++)if(m=f[g].weights){var q=v[0]/m[0];for(k=1;k<l;k++)v[k]/m[k]!==q&&(q=null);null!==q&&(f[d]={row:g,factor:q})}}return f}})})},"esri/layers/rasterLib/function/ExtractBandFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin".split(" "),
function(G,e,t,n,p,h){return G([t,h],{declaredClass:"esri.layers.rasterLib.function.ExtractBandFunction",functionName:"ExtractBand",supportWebGL:!0,support2D:!0,constructor:function(c){this.functionArguments=this.mixinIgnoreCase({bandIDs:[],missingBandAction:0,raster:null},c)},bind:function(c){c=this.getSourceRasterInfo(c);if(!c.raster)return Error("The raster input to extract band function is invalid.");var a=[],b=c.raster.statistics,l=[],g=c.raster.histograms,f=this.functionArguments.bandIDs.length||
c.raster.bandCount;this.functionArguments.bandIDs.forEach(e.hitch(this,function(d){if(d>=f-1){if(1===this.functionArguments.missingBandAction)return Error("missing band "+d);d=f-1}if(0>d)return Error("missing band "+d);void 0!==b&&null!==b&&0<b.length&&a.push(b[d]);void 0!==g&&null!==g&&0<g.length&&l.push(g[d])}));this.rasterInfo=e.mixin(c.raster,{bandCount:f,pixelType:this._calculatePixelType(this.pixelType,c.raster.pixelType),statistics:a,histograms:l});return!0},read2D:function(c){c=this._clonePixelData(c.raster);
if(null!==c&&null!==c.pixelBlock&&null!==c.pixelBlock.pixels){this._performance.start();var a=c.pixelBlock,b=a.statistics,l=a.pixels,g=l.length;if(null==this.functionArguments.bandIDs)throw"missing bandIDs parameter";if(0===this.functionArguments.bandIDs.length)return c;var f=[],d=[];this.functionArguments.bandIDs.forEach(function(k){if(k>=g-1){if(1===this.functionArguments.missingBandAction)throw"missing band "+k;k=g-1}if(0>k)throw"missing band "+k;f.push(l[k]);void 0!==b&&null!==b&&0<b.length&&
d.push(b[k])});a.pixels=f;a.statistics=d;a.planes=this.functionArguments.bandIDs.length;return c}},readGL:function(c){this._performance.start();if(null==this.functionArguments.bandIDs)throw"missing bandIDs parameter";if(3<this.functionArguments.bandIDs.length)throw"this version does not support more than 3 bands yet";this._initializeProgram({fragment:p.extractBand,fragmentName:"ExtractBand"});var a=this.functionArguments.bandIDs;1===a.length&&(a=[a[0],a[0],a[0]]);this._bandIDs=a;this._alterBand=!(0===
this.functionArguments.bandIDs.length||0===a[0]&&1===a[1]&&2===a[2]);var b=!!(this._alterBand&&c.raster&&c.raster.texture);c=this._setupTextureData(c.raster,{bandIDs:a});var l=this.bindFrameBuffer();b?this._setUniforms({u_bandIDs:a,u_alterBand:this._alterBand}):this._setUniforms({u_bandIDs:a,u_alterBand:!1});this._bindTexture(c.texture,"u_image");this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:c.extent,texture:l.texture}}})})},"esri/layers/rasterLib/function/HillshadeFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../../renderers/colorRampGenerator ../../../WKIDUnitConversion ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin ./surfaceUtils ./rasterUtils".split(" "),
function(G,e,t,n,p,h,c,a,b,l){return G([t,a],{declaredClass:"esri.layers.rasterLib.function.HillshadeFunction",functionName:"Hillshade",supportWebGL:!0,support2D:!0,renderTexture:!0,constructor:function(g){this.functionArguments=this.mixinIgnoreCase({hillshadeType:0,altitude:45,azimuth:315,zFactor:1,slopeType:1,psPower:.664,psFactor:.024,colorRamp:null,raster:null},g);this._azimuths=[315,270,225,360,180,0];this._altitudes=[60,60,60,60,60,90];this._weights=[3,5,3,2,1,4];var f=this._weights.reduce(function(d,
k){return d+k});this._weights=this._weights.map(function(d){return d/f})},bind:function(g){g=this.getSourceRasterInfo(g);if(!g.raster)return Error("The raster input to hillshade function is invalid.");g.raster.statistics&&(this.srcStatistics=g.raster.statistics);this.rasterInfo=e.mixin(g.raster,{bandCount:1,pixelType:this._calculatePixelType(this.pixelType,"U8"),statistics:[{min:0,max:255}],histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType=
"Generic";this._initializeColormap();return!0},read2D:function(g){this._performance.start();g=g.raster;g=b.hillshade(g,{altitude:this.functionArguments.altitude,azimuth:this.functionArguments.azimuth,zFactor:this.functionArguments.zFactor,psPower:this.functionArguments.psPower,psFactor:this.functionArguments.psFactor,hillshadeType:this.functionArguments.hillshadeType,slopeType:this.functionArguments.slopeType,isGCS:g.extent.spatialReference.wkid&&null==p[g.extent.spatialReference.wkid]});this._addPerformanceMetric(this._performance.elapsed());
return g},readGL:function(g){this._performance.start();this._initializeProgram({fragment:c.hillshade,fragmentName:"Hillshade"});this.functionArguments.colorRamp&&this._indexedColormap&&!this._clrTexture&&(this._clrTexture=this._setupColormapTexture(this._indexedColormap));var f=this._setupTextureData(g.raster),d=this.bindFrameBuffer(),k=this.gl,m=k.drawingBufferWidth;k=k.drawingBufferHeight;var v=f.extent,q=(v.xmax-v.xmin)/m,r=(v.ymax-v.ymin)/k,w=this.functionArguments.altitude,u=this.functionArguments.azimuth,
y=this.functionArguments.zFactor;1===this.functionArguments.hillshadeType&&(y*=2);var x=y/(8*q),z=y/(8*r);.001<y&&v.spatialReference.wkid&&null==p[v.spatialReference.wkid]&&(x/=111E3,z/=111E3);var A=this.functionArguments.psPower,E=this.functionArguments.psFactor;3===this.functionArguments.slopeType&&((x=v.spatialReference.wkid&&null==p[v.spatialReference.wkid])?(x=111E3*q,z=111E3*r,x=(y+Math.pow(x,A)*E)/(8*x),z=(y+Math.pow(z,A)*E)/(8*z)):(x=(y+Math.pow(q,A)*E)/(8*q),z=(y+Math.pow(r,A)*E)/(8*r)));
var F=(90-w)*Math.PI/180;w=Math.cos(F);var B=(360-u+90)*Math.PI/180;u=Math.sin(F)*Math.cos(B);F=Math.sin(F)*Math.sin(B);A=Array(6);E=Array(6);v=Array(6);var D=this._weights,I;if(1===this.functionArguments.hillshadeType){var M=this._azimuths.length;for(I=0;I<M;I++)w=this._altitudes[I],u=this._azimuths[I],F=(90-w)*Math.PI/180,w=Math.cos(F),B=(360-u+90)*Math.PI/180,u=Math.sin(F)*Math.cos(B),F=Math.sin(F)*Math.sin(B),A[I]=w,E[I]=u,v[I]=F}else A[0]=w,E[0]=u,v[0]=F;A=A.map(function(N){return parseFloat(N)});
E=E.map(function(N){return parseFloat(N)});v=v.map(function(N){return parseFloat(N)});this._setUniforms({u_cellSize:[q,r],u_zfactor:y,u_xFactor:x,u_yFactor:z,u_sinZcosA:u,u_sinZsinA:F,u_cosZ:w,u_sinZcosAs:E,u_sinZsinAs:v,u_cosZs:A,u_weights:D,u_hillshadeType:this.functionArguments.hillshadeType,u_resolution:g&&g.raster&&g.raster.pixelBlock?[1/g.raster.pixelBlock.width,1/g.raster.pixelBlock.height]:[1/m,1/k],u_scaled:!this.renderTexture,u_applyColorramp:this._clrTexture?!0:!1,u_minValue:this.srcStatistics[0].min,
u_maxValue:this.srcStatistics[0].max,u_indexedColormapOffset:this._indexedColormapOffset||0,u_indexedColormapMaxIndex:this._indexedColormap?this._indexedColormap.length/4-1:0});this._clrTexture&&this._bindTexture(this._clrTexture,"u_image1");this._bindTexture(f.texture,"u_image");this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:f.extent,texture:d.texture}},_initializeColormap:function(){this._indexedColormapOffset=0;var g=this._indexedColormap,f=this.functionArguments.colorRamp;
this.functionArguments.colormap?(this._alphaSpecified=(f=l.buildIndexedColormap(this.functionArguments.colormap))&&f.alphaSpecified,this._indexedColormap=f&&f.indexedColormap,this._indexedColormapOffset=f&&f.offset):f?(this._indexedColormap="multipart"===f.type?this.invert?n.createMultiPartColorRamp(this._invertColorRamp(f)):n.createMultiPartColorRamp(f):this.invert?n.createAlgorithmicColorRamp(this._invertColorRamp(f)):n.createAlgorithmicColorRamp(f),f.fromColor&&f.toColor&&"000"===f.fromColor.slice(0,
3).join("")&&"255255255"===f.toColor.slice(0,3).join("")&&(this._clrTexture=this._indexedColormap=null)):this.functionArguments.colormapName?"random"===this.functionArguments.colormapName.toLowerCase()&&(this._indexedColormap=n.createRandomColorRamp()):this._clrTexture=this._indexedColormap=null;if(g&&this._indexedColormap){f=!0;for(var d=0;d<g.length;d++)if(g[d]!==this._indexedColormap[d]){f=!1;break}f||(this._clrTexture=null)}},_setupColormapTexture:function(g){var f=this._createTexture(),d=this.gl,
k=g.length/4,m=new Float32Array(g.length),v;for(v=0;v<g.length;v++)m[v]=g[v]/255;d.getExtension("OES_texture_float");d.texImage2D(d.TEXTURE_2D,0,d.RGBA,k,1,0,d.RGBA,d.FLOAT,m);return f}})})},"esri/layers/rasterLib/function/LocalFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin ./rasterUtils".split(" "),function(G,e,t,n,p,h,c){return G([t,h],{declaredClass:"esri.layers.rasterLib.function.LocalFunction",functionName:"Local",
supportWebGL:!0,support2D:!0,constructor:function(a){this.functionArguments=this.mixinIgnoreCase({operation:null,rasters:null},a)},bind:function(a){a=this.getSourceRasterInfo(a);var b=0;a.raster?b=a.raster.bandCount:a.rasters&&(b=Math.max.apply(null,a.rasters.map(function(l){return l.bandCount})));if(0===b)return Error("The raster input to local function is invalid. It only takes single band input.");a=a.raster||a.rasters.filter(function(l){return!!l.extent})[0];this.rasterInfo=e.mixin(a,{bandCount:1,
pixelType:this._calculatePixelType(this.pixelType,"F32"),statistics:null,histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType="Generic";return!0},read2D:function(a){var b=[];b=a.raster?a.raster2?[a.raster,a.raster2]:[a.raster]:a.rasters;a=b.map(function(k){return k.pixelBlock});var l=this.functionArguments.operation;if(null===l)return b[0];this._performance.start();var g=this._getOperations(),f=g.operators[l-1];g=g.functors[l-1];
if(!this.functionArguments.rasters){if(1!==f)throw"no sufficient rasters, require "+f;}else if(999!==f&&this.functionArguments.rasters.length!==f)throw"number of rasters does not meet (short or exceed) the operation requirment, require "+f;var d=31===l?c.isNull(a[0]):50===l?c.setNull(a[0]):c.local(a,{rasterCountNeeded:f,functor:g});"Unknown"!==this.pixelType&&(d.pixelType=this.pixelType,d.pixels=d.pixels.map(e.hitch(this,function(k){return this._clampBand(k,d.pixelType)})));d.statistics||d.calculateStatistics();
return{extent:b[0].extent,pixelBlock:d}},readGL:function(a){this._performance.start();var b=this.functionArguments.operation,l=this._getWebGLOperations(),g=l.operators[b-1],f=p.local;l="result\x3d"+l.functors[b-1]+";";31!==b&&50!==b&&(l+="result \x3d vec4(result.rgb, a.a);");f=f.replace("vec4 replaceme"+g+";",l);l=this.gl.getParameter(this.gl.VERSION);var d="";if(-1<l.toLowerCase().indexOf("webgl 1.0")||-1<l.toLowerCase().indexOf("webgl 0."))d=this._getPolyfill(b);f=f.replace("vec4 polyfill;",d);
1<g&&(f=f.replace("gl_FragColor \x3d localOp1();","gl_FragColor \x3d localOp1();".replace("1",g.toString())));this._initializeProgram({fragment:f,fragmentName:"Local"});b=a.rasters;if(null!=b&&0!==b.length){b=b.length;l=this.bindFrameBuffer();for(g=0;g<b;g++){f=0<g?g.toString():"";var k=this._setupTextureData(a.rasters[g],{reCreate:!0});this._bindTexture(k.texture,"u_image"+f)}this._setUniforms({});this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:k.extent,texture:l.texture}}},
_getOperations:function(){return{operators:[2,2,2,1,2,1,1,1,1,1,2,2,1,2,2,2,2,1,2,2,1,1,2,2,1,1,1,2,2,1,1,1,2,2,1,1,1,999,999,999,999,999,999,2,1,2,999,1,1,1,1,1,1,999,999,1,1,999,1,1,2,2,2,999,999,999,999,999,999,999,999,999,999,3],functors:[function(a,b){return a+b},function(a,b){return a-b},function(a,b){return a*b},function(a){return Math.sqrt(a)},function(a,b){return Math.pow(a,b)},function(a){return Math.acos(a)},function(a){return Math.asin(a)},function(a){return Math.atan(a)},function(a){return Math.atanh(a)},
function(a){return Math.abs(a)},function(a,b){return a&b},function(a,b){return a<<b},function(a){return~a},function(a,b){return a|b},function(a,b){return a>>b},function(a,b){return a^b},function(a,b){return a&&b},function(a){return!a},function(a,b){return a||b},function(a,b){return a!=b},function(a){return Math.cos(a)},function(a,b){return Math.cosh(a)},function(a,b){return a/b},function(a,b){return a==b},function(a){return Math.exp(a)},function(a){return Math.pow(10,a)},function(a){return Math.pow(2,
a)},function(a,b){return a>b?1:0},function(a,b){return a>=b?1:0},function(a,b){return Math.floor(a)},function(a){return!a},function(a){return a},function(a,b){return a<b?1:0},function(a,b){return a<=b?1:0},function(a){return Math.log(a)},function(a,b){return Math.log10(a)},function(a,b){return Math.log2(a)},999,999,999,999,999,999,function(a,b){return a%b},function(a){return-a},function(a,b){return a!=b?1:0},999,function(a,b){return Math.floor(a)},function(a,b){return Math.ceil(a)},function(a,b){return b?
0:a},function(a,b){return Math.sin(a)},function(a,b){return Math.sinh(a)},function(a,b){return a*a},999,999,function(a){return Math.tan(a)},function(a){return Math.tanh(a)},999,function(a){return Math.acosh(a)},function(a){return Math.asinh(a)},function(a,b){return Math.atan2(a,b)},function(a,b){return a/b},function(a,b){return Math.floor(a/b)},999,999,999,999,999,999,999,999,999,999,function(a,b,l){return a?b:l}]}},_polyfill:{sinh:"vec4 sinh(vec4 x) {\nvec4 halfexp \x3d exp(x)/2.0;\nreturn halfexp - 1.0/halfexp;\n}",
asinh:"vec4 asinh(vec4 x) {\nvec4 halfexp \x3d exp(x)/2.0;\nreturn 1.0/(halfexp - 1.0/halfexp);\n}",cosh:"vec4 cosh(vec4 x) {\nvec4 halfexp \x3d exp(x)/2.0;\nreturn halfexp + 1.0/halfexp;\n}",acosh:"vec4 acosh(vec4 x) {\nvec4 halfexp \x3d exp(x)/2.0;\nreturn 1.0/(halfexp + 1.0/halfexp);\n}",tanh:"vec4 tanh(vec4 x) {\nvec4 expx \x3d exp(x);\nreturn (expx - 1.0/expx)/(expx + 1.0/expx);\n}",atanh:"vec4 atanh(vec4 x) {\nvec4 expx \x3d exp(x);\nreturn (expx + 1.0/expx)/(expx - 1.0/expx);\n}"},_getPolyfill:function(a){var b=
"";switch(a){case 9:b=this._polyfill.atanh;break;case 22:b=this._polyfill.cosh;break;case 52:b=this._polyfill.sinh;break;case 57:b=this._polyfill.tanh;break;case 59:b=this._polyfill.acosh;break;case 60:b=this._polyfill.asinh}return b},_getWebGLOperations:function(){return{operators:[2,2,2,1,2,1,1,1,1,1,2,2,1,2,2,2,2,1,2,2,1,1,2,2,1,1,1,2,2,1,1,1,2,2,1,1,1,999,999,999,999,999,999,2,1,2,999,1,1,1,1,1,1,999,999,1,1,999,1,1,2,2,2,999,999,999,999,999,999,999,999,999,999,3],functors:["(a + b)","(a - b)",
"(a * b)","sqrt(a)","pow(a, b)","acos(a)","asin(a)","atan(a)","atanh(a)","abs(a)","a","a","a","a","a","a","(a.r\x3d\x3d0.0 || b.r\x3d\x3d0.0) ? vec4(0.0,0.0,0.0,a.a) : vec4(1.0,1.0,1.0,a.a)","a.r\x3d\x3d0.0?vec4(1.0,1.0,1.0,a.a) : vec4(0.0,0.0,0.0,a.a)","(a.r\x3d\x3d0.0 \x26\x26 b.r\x3d\x3d0.0) ? vec4(0.0,0.0,0.0,a.a) : vec4(1.0,1.0,1.0,a.a)","(a.r\x3d\x3d0.0 ^^ b.r\x3d\x3d0.0) ? vec4(1.0,1.0,1.0,a.a) : vec4(0.0,0.0,0.0,a.a)","cos(a)","cosh(a)","a / b","a.r \x3d\x3d b.r? vec4(1.0,1.0,1.0,a.a) : vec4(0.0,0.0,0.0,a.a)",
"exp(a)","pow(10.0, a)","pow(2.0, a)","a.r \x3e b.r ? vec4(1.0,1.0,1.0,a.a) : vec4(0.0,0.0,0.0,a.a)","a.r \x3e\x3d b.r ? vec4(1.0,1.0,1.0,a.a) : vec4(0.0,0.0,0.0,a.a)","floor(a)","a.a \x3d\x3d 0.0? vec4(1.0,1.0,1.0,1.0) : vec4(0.0,0.0,0.0,1.0)","a","a.r \x3c b.r ? vec4(1.0,1.0,1.0,a.a) : vec4(0.0,0.0,0.0,a.a)","a.r \x3c\x3d b.r ? vec4(1.0,1.0,1.0,a.a) : vec4(0.0,0.0,0.0,a.a)","log(a)","log2(a) / log2(10.0)","log2(a)",999,999,999,999,999,999,"mod(a, b)","-a","a.r !\x3d b.r ? vec4(1.0,1.0,1.0,a.a) : vec4(0.0,0.0,0.0,a.a)",
999,"floor(a)","ceil(a)","a.r !\x3d 0.0 ? vec4(0.0,0.0,0.0,0.0) : a","sin(a)","sinh(a)","a * a",999,999,"tan(a)","tanh(a)",999,"acosh(a)","asinh(a)","atan(a, b)","a / b","floor(a / b)",999,999,999,999,999,999,999,999,999,999,"a.r!\x3d0 ? b : c"]}}})})},"esri/layers/rasterLib/function/MaskFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin ./rasterUtils".split(" "),function(G,e,t,n,p,h,c){return G([t,h],{declaredClass:"esri.layers.rasterLib.function.MaskFunction",
functionName:"Mask",supportWebGL:!0,support2D:!0,constructor:function(a){this.functionArguments=this.mixinIgnoreCase({includedRanges:null,noDataInterpretation:0,noDataValues:null,raster:null},a)},bind:function(a){a=this.getSourceRasterInfo(a);if(!a.raster)return Error("The raster input to mask function is invalid.");this.rasterInfo=e.mixin(a.raster,{bandCount:a.raster.bandCount,pixelType:this._calculatePixelType(this.pixelType,a.raster.pixelType),statistics:a.raster.statistics,histograms:a.raster.histograms});
return!0},read2D:function(a){this._performance.start();a=a.raster;var b=c.mask(a.pixelBlock,{includedRanges:this.functionArguments.includedRanges,noDataInterpretation:this.functionArguments.noDataInterpretation,noDataValues:this.functionArguments.noDataValues});this._addPerformanceMetric(this._performance.elapsed());"Unknown"!==this.pixelType&&(b.pixelType=this.pixelType);return{extent:a.extent,pixelBlock:b}},readGL:function(a){this._performance.start();this._initializeProgram({fragment:p.mask,fragmentName:"Mask"});
a=this._setupTextureData(a.raster);var b=this.bindFrameBuffer(),l=this.functionArguments.includedRanges,g=this.functionArguments.noDataValues?this.functionArguments.noDataValues.map(function(f){return parseFloat(f,10)}):null;this._setUniforms({u_includedRanges:l,u_includedRanges_specified:l?!0:!1,u_noDataValues:g,u_noDataValues_specified:g?!0:!1,u_noDataInterpretation:this.functionArguments.noDataInterpretation,u_bandCount:Math.min(this.sourceRasterInfo.raster.bandCount,3)});this._bindTexture(a.texture,
"u_image");this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:a.extent,texture:b.texture}}})})},"esri/layers/rasterLib/function/NDVIFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin ./rasterIndex".split(" "),function(G,e,t,n,p,h,c){return G([t,h],{declaredClass:"esri.layers.rasterLib.function.NDVIFunction",functionName:"NDVI",supportWebGL:!0,support2D:!0,constructor:function(a){this.functionArguments=
this.mixinIgnoreCase({visibleBandID:1,infraredBandID:2,scaled:!0,raster:null},a)},bind:function(a){a=this.getSourceRasterInfo(a);if(!(a.raster&&1<a.raster.bandCount))return Error("The raster input to ndvi function is invalid. It requires more than 1 band.");this.rasterInfo=e.mixin(a.raster,{bandCount:1,pixelType:this._calculatePixelType(this.pixelType,this.scaled?"U8":"F32"),statistics:this.scaled?[{min:0,max:200}]:[{min:-1,max:1}],histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||
{};this.rasterInfo.keyProperties.DataType="Generic";return!0},read2D:function(a){this._performance.start();a=a.raster;var b=c.calculate(a.pixelBlock,{bandIndexes:[this.functionArguments.infraredBandID+1,this.functionArguments.visibleBandID+1].join(" "),method:1}),l;if(this.functionArguments.scaled){var g=b.pixels[0];var f=b.mask;var d=g.length;var k=new Uint8Array(d);if(null==f)for(l=0;l<d;l++)k[l]=100*g[l]+100&255;else for(l=0;l<d;l++)f[l]&&(k[l]=100*g[l]+100&255);b.pixels[0]=k;b.pixelType="U8"}this._addPerformanceMetric(this._performance.elapsed());
"Unknown"!==this.pixelType&&(b.pixelType=this.pixelType);return{extent:a.extent,pixelBlock:b}},readGL:function(a){this._performance.start();this._initializeProgram({fragment:p.ndvi,fragmentName:"NDVI"});var b=this.functionArguments.visibleBandID,l=this.functionArguments.infraredBandID,g=this.functionArguments.scaled||!1;this._alterBand=2<Math.max(l,b)?!0:!1;a=this._setupTextureData(a.raster,{bandIDs:this._alterBand?{bandIDs:[l,b,l]}:null});var f=this.bindFrameBuffer();this._alterBand?this._setUniforms({u_bandId_nir:0,
u_bandId_red:1,u_scaled:g}):this._setUniforms({u_bandId_nir:l,u_bandId_red:b,u_scaled:g});this._bindTexture(a.texture,"u_image");this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:a.extent,texture:f.texture}}})})},"esri/layers/rasterLib/function/SlopeFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../../WKIDUnitConversion ../../PixelBlock ./pixelShaders ./RasterFunctionWebGLMixin ./surfaceUtils".split(" "),function(G,e,t,n,p,h,
c,a){return G([t,c],{declaredClass:"esri.layers.rasterLib.function.SlopeFunction",functionName:"Slope",supportWebGL:!0,support2D:!0,constructor:function(b){this.functionArguments=this.mixinIgnoreCase({zFactor:1,slopeType:1,psPower:.664,psFactor:.024,raster:null},b)},bind:function(b){b=this.getSourceRasterInfo(b);if(!b.raster)return Error("The raster input to slope function is invalid.");this.rasterInfo=e.mixin(b.raster,{bandCount:1,pixelType:this._calculatePixelType(this.outputPixelType,"F32"),statistics:1===
this.slopeType||3===this.slopeType?[{min:0,max:90}]:null,histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType="Generic";return!0},read2D:function(b){this._performance.start();b=b.raster;b=a.slope(b,{zFactor:this.functionArguments.zFactor,psPower:this.functionArguments.psPower,psFactor:this.functionArguments.psFactor,slopeType:this.functionArguments.slopeType,isGCS:b.extent.spatialReference.wkid&&null==n[b.extent.spatialReference.wkid]});
this._addPerformanceMetric(this._performance.elapsed());return b},readGL:function(b){this._performance.start();this._initializeProgram({fragment:h.slope,fragmentName:"Slope"});var l=this._setupTextureData(b.raster),g=this.bindFrameBuffer(),f=this.gl,d=f.drawingBufferWidth;f=f.drawingBufferHeight;var k=l.extent;this._setUniforms({u_resolution:b&&b.raster&&b.raster.pixelBlock?[1/b.raster.pixelBlock.width,1/b.raster.pixelBlock.height]:[1/d,1/f],u_cellSize:[(k.xmax-k.xmin)/d,(k.ymax-k.ymin)/f],u_zfactor:this.functionArguments.zFactor});
this._bindTexture(l.texture,"u_image");this._drawGL();this._addPerformanceMetric(this._performance.elapsed());return{extent:l.extent,texture:g.texture}}})})},"esri/layers/rasterLib/function/StretchFunction":function(){define("dojo/_base/declare dojo/_base/lang ./RasterFunctionX ../../PixelBlock ./vertexShaders ./pixelShaders ./RasterFunctionWebGLMixin".split(" "),function(G,e,t,n,p,h,c){return G([t,c],{declaredClass:"esri.layers.rasterLib.function.StretchFunction",functionName:"Stretch",supportWebGL:!0,
support2D:!0,constructor:function(a){this.functionArguments=this.mixinIgnoreCase({stretchType:0,min:0,max:255,numberOfStandardDeviations:2,statistics:null,histograms:null,dra:!1,minPercent:.25,maxPercent:.5,useGamma:!1,gamma:null,raster:null,computeGamma:!1},a);this.functionArguments.statistics=this._convertStats(this.functionArguments.statistics);-1===[0,3,5,6].indexOf(this.functionArguments.stretchType)&&(console.error("The specific stretch type has not been implemented: "+this.functionArguments.stretchType),
this.functionArguments.stretchType=5);this.min=null==this.min?0:this.min;this.max=null==this.max?255:this.max},bind:function(a){a=this.getSourceRasterInfo(a);if(!a.raster)return Error("The raster input to stretch function is invalid.");a.raster.statistics&&(this.srcStatistics=this._convertStats(a.raster.statistics));a.raster.histograms&&(this.srcHistograms=a.raster.histograms);this.rasterInfo=e.mixin({},a.raster,{bandCount:a.raster.bandCount,pixelType:this._calculatePixelType(this.pixelType,"U8"),
statistics:null,histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType="Generic";return!0},read2D:function(a){a=a.raster;this._stretch(a);return a},hasTilingEffects:function(a){a=a||this.functionArguments;return!!(a.dra||a.raster&&"object"===typeof a.raster&&a.raster.dra)},_convertStats:function(a){return a?a.map(function(b){return b&&null!=b.min?[b.min,b.max,b.mean,b.stddev]:b}):null},_updateStatistisHistograms:function(a){var b=this.functionArguments,
l=b.histograms||this.srcHistograms;if(a&&a.pixelBlock&&a.pixelBlock.pixels){if(0===b.stretchType)this._statistics=b.statistics&&0<b.statistics.length?b.statistics:this.srcStatistics,this._histograms=l;else{var g=a.pixelBlock,f=g.pixels.length,d=6===b.stretchType&&(b.dra||!l)||3===b.stretchType&&b.dra;d&&(g.statistics||g.calculateStatistics(),this._calculateStatisticsHistograms(a));if(b.dra)if(g.statistics||g.calculateStatistics(),d)this._statistics=g.statistics,this._histograms=g.histograms;else for(b=
g.statistics,this._statistics=[],a=0;a<f;a++)this._statistics[a]=[b[a].minValue,b[a].maxValue,0,0];else this._statistics=b.statistics&&0<b.statistics.length?b.statistics:this.srcStatistics,this._histograms=l}this._statistics=this._convertStats(this._statistics);this._gammaCorrection=this._getGammaCorrection()}else this._statistics=b.statistics&&0<b.statistics.length?b.statistics:this.srcStatistics,this._histograms=l,this._gammaCorrection=this._getGammaCorrection(),this._statistics=this._convertStats(this._statistics)},
_getGammaCorrection:function(){var a=this.functionArguments.gamma;if(a){var b=[],l;for(l=0;l<a.length;l++)b[l]=1<a[l]?2<a[l]?6.5+Math.pow(a[l]-2,2.5):6.5+100*Math.pow(2-a[l],4):1;return b}},_stretch:function(a){if(null!==a&&null!==a.pixelBlock&&null!==a.pixelBlock.pixels&&0!==this.functionArguments.stretchType){this._updateStatistisHistograms(a);var b=a.pixelBlock,l=b.pixels;b=b.width*b.height;var g=l.length,f,d;this._createLUT(a);if(null==this.LUT)return this._filterNoLUT(a);var k=this.LUT,m=this.LUTOffset;
for(f=0;f<g;f++){var v=k[f];for(d=0;d<b;d++){var q=l[f][d];l[f][d]=v[q-m]}}a.pixelBlock.pixelType="U8"}},_calculateStatisticsHistograms:function(a){a=a.pixelBlock;var b=a.pixelType,l=a.pixels,g=a.mask,f=l.length,d,k,m=function(E){this.min=-.5;this.max=255.5;this.size=256;e.mixin(this,E);this.counts=this.counts||new Uint32Array(this.size)},v=[],q,r;for(d=0;d<f;d++){var w=new m;var u=w.counts;var y=l[d];if("U8"===b)if(g)for(k=0;k<a.width*a.height;k++)g[k]&&u[y[k]]++;else for(k=0;k<a.width*a.height;k++)u[y[k]]++;
else{var x=a.statistics[d].minValue;var z=a.statistics[d].maxValue;w.min=x;w.max=z;z=(z-x)/256;var A=new Uint32Array(257);if(g)for(k=0;k<a.width*a.height;k++)g[k]&&A[Math.floor((y[k]-x)/z)]++;else for(k=0;k<a.width*a.height;k++)A[Math.floor((y[k]-x)/z)]++;for(k=0;255>k;k++)u[k]=A[k];u[255]=A[255]+A[256]}v.push(w);y=[];x=a.statistics[d].minValue;z=a.statistics[d].maxValue;for(k=r=q=A=0;k<w.size;k++)A+=u[k],q+=k*u[k];q/=A;for(k=0;k<w.size;k++)r+=u[k]*Math.pow(k-q,2);u=Math.sqrt(r/(A-1));k=(q+.5)*(w.max-
w.min)/w.size+w.min;w=u*(w.max-w.min)/w.size;y.push(x);y.push(z);y.push(k);y.push(w);a.statistics[d]={min:x,minValue:x,max:z,maxValue:z,mean:k,stddev:w}}a.histograms=v},_getCutOffPoints:function(a){var b=this.functionArguments,l=999;a&&a.pixelBlock?l=a.pixelBlock.pixels.length:a&&a.texture&&(l=3);a=Math.min(l,this._statistics.length);var g=[],f=[],d,k;switch(b.stretchType){case 5:for(d=0;d<a;d++)g[d]=this._statistics[d][0],f[d]=this._statistics[d][1];break;case 3:for(d=0;d<a;d++)g[d]=this._statistics[d][2]-
b.numberOfStandardDeviations*this._statistics[d][3],f[d]=this._statistics[d][2]+b.numberOfStandardDeviations*this._statistics[d][3],g[d]<this._statistics[d][0]&&(g[d]=this._statistics[d][0]),f[d]>this._statistics[d][1]&&(f[d]=this._statistics[d][1]);break;case 6:for(d=0;d<a;d++){l=this._histograms[d];var m=new Uint32Array(l.size);var v=l.counts;var q=0;var r=-.5===l.min&&1===(l.max-l.min)/v?.5:0;for(k=0;k<l.size;k++)q+=v[k],m[k]=q;v=b.minPercent*q/100;for(k=0;k<l.size;k++)if(m[k]>v){g[d]=l.min+(l.max-
l.min)/l.size*(k+r);break}v=(1-b.maxPercent/100)*q;for(k=l.size-2;0<=k;k--)if(m[k]<v){f[d]=l.min+(l.max-l.min)/l.size*(k+2-r);break}}break;default:for(d=0;d<l;d++)g[d]=0,f[d]=255}return{minCutOff:g,maxCutOff:f}},_createLUT:function(a){var b=this.functionArguments,l=a.pixelBlock,g=l.pixelType;if("U8"===g||"U16"===g||"S8"===g||"S16"===g){if(this._LUTSignature&&(g=this._computeLutSignature(),g.length===this._LUTSignature.length&&!g.some(function(F,B){return F!==this._LUTSignature[B]}.bind(this))))return;
g=l.pixels.length;var f=[],d=[],k=b.max,m=b.min,v=b.gamma,q=k-m,r=this._getCutOffPoints(a);a=r.minCutOff;r=r.maxCutOff;var w=0,u=256;"S8"===l.pixelType?w=-127:"S16"===l.pixelType&&(w=-32767);if("U16"===l.pixelType||"S16"===l.pixelType)u=65536;for(l=0;l<g;l++)f[l]=r[l]-a[l];var y=this._gammaCorrection;if(b.useGamma)for(l=0;l<g;l++){var x=[];for(b=0;b<u;b++){var z=b+w;var A=(z-a[l])/f[l];var E=1;1<v[l]&&(E-=Math.pow(1/q,A*y[l]));z<r[l]&&z>a[l]?x[b]=Math.floor(E*q*Math.pow(A,1/v[l]))+m:z>r[l]?x[b]=k:
z<a[l]&&(x[b]=m)}d[l]=x}else for(l=0;l<g;l++){x=[];for(b=0;b<u;b++)z=b+w,x[b]=z<a[l]?m:z>r[l]?k:Math.floor((z-a[l])/f[l]*q)+m;d[l]=x}this.LUT=d;this.LUTOffset=w;this._LUTSignature=this._computeLutSignature()}},_computeLutSignature:function(){var a=this.functionArguments,b=[],l,g;b.push(a.stretchType);b.push(a.min);b.push(a.max);b.push(a.numberOfStandardDeviations);if(this._statistics)for(l=0;l<this._statistics.length;l++)for(g=0;g<this._statistics[l].length;g++)b.push(this._statistics[l][g]);b.push(a.dra?
1:0);b.push(a.minPercent);b.push(a.maxPercent);if(a.gamma)for(l=0;l<this._statistics.length;l++)b.push(a.gamma[l]);b.push(a.useGamma?1:0);return b},_filterNoLUT:function(a){if(null!==a&&null!==a.pixelBlock&&null!==a.pixelBlock.pixels){var b=this.functionArguments,l=a.pixelBlock,g=l.pixels,f=l.mask;l=l.width*l.height;var d=g.length,k=[],m=[],v=b.max,q=b.min,r=b.gamma,w=v-q;var u=this._getCutOffPoints(a);var y=u.minCutOff,x=u.maxCutOff;for(u=0;u<d;u++)k[u]=x[u]-y[u];if(b.useGamma&&null!==r&&r.length>=
d)for(u=0;u<d;u++)m[u]=1<r[u]?2<r[u]?6.5+Math.pow(r[u]-2,2.5):6.5+100*Math.pow(2-r[u],4):1;if(b.useGamma)if(void 0!==f&&null!==f)for(b=0;b<l;b++){if(f[b])for(u=0;u<d;u++){var z=g[u][b];var A=(z-y[u])/k[u];var E=1;1<r[u]&&(E-=Math.pow(1/w,A*m[u]));z<x[u]&&z>y[u]?g[u][b]=Math.floor(E*w*Math.pow(A,1/r[u]))+q:z>x[u]?g[u][b]=v:z<y[u]&&(g[u][b]=q)}}else for(b=0;b<l;b++)for(u=0;u<d;u++)z=g[u][b],A=(z-y[u])/k[u],E=1,1<r[u]&&(E-=Math.pow(1/w,A*m[u])),z<x[u]&&z>y[u]?g[u][b]=Math.floor(E*w*Math.pow(A,1/r[u]))+
q:z>x[u]?g[u][b]=v:z<y[u]&&(g[u][b]=q);else if(void 0!==f&&null!==f)for(b=0;b<l;b++){if(f[b])for(u=0;u<d;u++)z=g[u][b],z<x[u]&&z>y[u]?g[u][b]=Math.floor((z-y[u])/k[u]*w)+q:z>x[u]?g[u][b]=v:z<y[u]&&(g[u][b]=q)}else for(b=0;b<l;b++)for(u=0;u<d;u++)z=g[u][b],z<x[u]&&z>y[u]?g[u][b]=Math.floor((z-y[u])/k[u]*w)+q:z>x[u]?g[u][b]=v:z<y[u]&&(g[u][b]=q);a.pixelBlock.pixelType="U8";return a}},_computeGammaValues:function(a){var b=this._statistics.length,l,g=[];for(l=0;l<b;l++){var f=this._statistics[l][2];"U8"!==
a&&(f=255*(f-this._statistics[l][0])/(this._statistics[l][1]-this._statistics[l][0]));g.push(this._computeGammaValue(f))}return g},_computeGammaValue:function(a){if(0!==a&&!(255<a||0>a)){var b=0;0<a&&150!=a&&255>a&&(b=150>=a?45*Math.cos(.01047*a):17*Math.sin(.021*a));b=Math.log((a+b)/255);if(0!==b&&(a=Math.log(a/255)/b,!isNaN(a)))return Math.min(9.9,Math.max(.01,a))}},readGL:function(a){return this._stretchGL(a.raster)},_stretchGL:function(a){this._performance.start();var b=this.renderTexture,l,g=
a.pixelBlock&&a.pixelBlock.pixels&&a.pixelBlock.pixels.length||this.sourceRasterInfo.raster.bandCount,f=a.pixelBlock,d=this.gl,k=d.drawingBufferWidth,m=d.drawingBufferHeight;if(!f&&this.functionArguments.dra){var v=new Float32Array(k*m*4),q=new Uint8Array(k*m);var r=new Float32Array(k*m);var w=new Float32Array(k*m);var u=new Float32Array(k*m);d.checkFramebufferStatus(d.FRAMEBUFFER)==d.FRAMEBUFFER_COMPLETE&&d.readPixels(0,0,k,m,d.RGBA,d.FLOAT,v);for(l=0;l<k*m;l++)r[l]=v[4*l],w[l]=v[4*l+1],u[l]=v[4*
l+2],q[l]=v[4*l+3];a.pixelBlock=new n({width:k,height:m,pixels:[r,w,u],mask:q});a.pixelBlock.calculateStatistics()}!f&&this.functionArguments.dra&&this._useGPUStats?(r=new Float32Array(g),w=new Float32Array(g)):(this._updateStatistisHistograms(a),v=this._getCutOffPoints(a),r=new Float32Array(g),w=new Float32Array(g),r.set(v.minCutOff.slice(0,g)),w.set(v.maxCutOff.slice(0,g)));this._initializeProgram({fragment:h.stretch,fragmentName:"Stretch"});v=this._setupTextureData(a);q=this.bindFrameBuffer();
this.renderTexture=!1;this._performance.start();if(!f&&this.functionArguments.dra&&this._useGPUStats){this._setUniforms({u_sourceDim:[k,m],u_bandCount:g});if(1===g)var y=this._readMinMax(v,2);else{y=this._readMinMax(v,0);var x=this._readMinMax(v,1)}if(6===this.functionArguments.stretchType||3===this.functionArguments.stretchType&&this.functionArguments.dra)l=this._readHistogram(y,x,a),r=l.minCutOff||r,w=l.minCutOff||w}u=this.functionArguments.max-this.functionArguments.min;a=new Float32Array(g);for(l=
0;l<g;l++)a[l]=u/(w[l]-r[l]);this._useGPUStats&&this._initializeProgram({fragment:h.stretch,fragmentName:"Stretch"});d.blendFunc(d.SRC_ALPHA,d.ZERO);u=new Float32Array(3);var z=new Float32Array(3);for(l=0;3>l;l++)u[l]=this.functionArguments.min,z[l]=this.functionArguments.max;l=this.functionArguments.useGamma;var A=this.functionArguments.gamma,E=this._gammaCorrection;Array.isArray(A)&&A.length>=g||(l=!1);this._setUniforms({u_sourceDim:[k,m],u_bandCount:g,u_minOutput:u,u_maxOutput:z,u_minCutOff:r,
u_maxCutOff:w,u_factor:a,u_state:100,u_useGamma:l,u_gamma:A,u_scaled:!b,u_gammaCorrection:E,u_minMaxTexture:!f&&this.functionArguments.dra&&this._useGPUStats?!0:!1});this.renderTexture=b;d.viewport(0,0,k,m);this._bindTexture(v.texture,"u_image");!f&&this.functionArguments.dra&&this._useGPUStats&&(b=d.getUniformLocation(this.rasterProgram,"u_image1"),d.uniform1i(b,1),d.activeTexture(d.TEXTURE1),d.bindTexture(d.TEXTURE_2D,y.texture),1<g&&(g=d.getUniformLocation(this.rasterProgram,"u_image2"),d.uniform1i(g,
2),d.activeTexture(d.TEXTURE2),d.bindTexture(d.TEXTURE_2D,x.texture)));this._drawGL();return{extent:v.extent,texture:q.texture}},_readMinMax:function(a,b){var l=this.gl,g=a.width||l.drawingBufferWidth,f=a.height||l.drawingBufferHeight;this._setUniforms({u_state:b});this.renderTexture=!1;var d=a.texture;for(l.activeTexture(l.TEXTURE0);1<g||1<f;){var k=this._createTexture();b=Math.max(Math.ceil(g/2),1);var m=Math.max(Math.ceil(f/2),1);l.getExtension("OES_texture_float");l.texImage2D(l.TEXTURE_2D,0,
l.RGBA,b,m,0,l.RGBA,l.FLOAT,null);a=l.createFramebuffer();l.bindFramebuffer(l.FRAMEBUFFER,a);l.framebufferTexture2D(l.FRAMEBUFFER,l.COLOR_ATTACHMENT0,l.TEXTURE_2D,k,0);l.viewport(0,0,b,m);l.bindTexture(l.TEXTURE_2D,d);this._setUniforms({u_sourceDim:[g,f]});g=b;f=m;this._drawGL(!0);d=k}a=new Float32Array(g*f*4);l.checkFramebufferStatus(l.FRAMEBUFFER)==l.FRAMEBUFFER_COMPLETE&&l.readPixels(0,0,g,f,l.RGBA,l.FLOAT,a);return{texture:k,minmax:a}},_readHistogram:function(a,b,l){if(a)try{var g=this.gl,f=g.drawingBufferWidth,
d=g.drawingBufferHeight,k,m,v;if(a.texture instanceof WebGLTexture){var q=!0;var r=[1,0,0,1];if(b){var w=a.minmax;var u=b.minmax}else w=[a.minmax[0]],u=[a.minmax[1]]}else for(u=b,w=a,r=new Float32Array(u.length),k=0;k<u.length;k++)r[k]=256/(u[k]-w[k]);var y=new Float32Array(f*d);for(v=0;v<y.length;v++)y[v]=v;if(!this.histogramProgram){var x=p.getShader(g,p.histogram),z=h.getShader(g,h.constant);this.histogramProgram=this._loadProgram(x,z)}g.blendFunc(g.ONE,g.ONE);g.enable(g.BLEND);g.useProgram(this.histogramProgram);
var A=g.getAttribLocation(this.histogramProgram,"a_pixelIndex"),E=g.createBuffer();g.bindBuffer(g.ARRAY_BUFFER,E);g.bufferData(g.ARRAY_BUFFER,y,g.STATIC_DRAW);g.enableVertexAttribArray(A);g.vertexAttribPointer(A,1,g.FLOAT,!1,0,0);var F=this._setupHistTexture(l),B=this._createTexture();g.getExtension("OES_texture_float");g.texImage2D(g.TEXTURE_2D,0,g.RGBA,257,1,0,g.RGBA,g.FLOAT,null);var D=g.createFramebuffer();g.bindFramebuffer(g.FRAMEBUFFER,D);g.framebufferTexture2D(g.FRAMEBUFFER,g.COLOR_ATTACHMENT0,
g.TEXTURE_2D,B,0);g.viewport(0,0,257,1);var I=g.getUniformLocation(this.histogramProgram,"u_image");g.uniform1i(I,0);g.activeTexture(g.TEXTURE0);g.bindTexture(g.TEXTURE_2D,F);var M=g.getUniformLocation(this.histogramProgram,"u_sourceDim");g.uniform2f(M,f,d);var N=g.getUniformLocation(this.histogramProgram,"u_bandCount");g.uniform1i(N,3);var Q=g.getUniformLocation(this.histogramProgram,"u_halfPixel");g.uniform2f(Q,.5/f,.5/d);var V=g.getUniformLocation(this.histogramProgram,"u_minMaxTexture");if(q){g.uniform1i(V,
1);var X=g.getUniformLocation(this.histogramProgram,"u_image1");g.uniform1i(X,1);g.activeTexture(g.TEXTURE1);g.bindTexture(g.TEXTURE_2D,a.texture);if(b){var W=g.getUniformLocation(this.histogramProgram,"u_image2");g.uniform1i(W,2);g.activeTexture(g.TEXTURE2);g.bindTexture(g.TEXTURE_2D,b.texture)}}else{var Z=g.getUniformLocation(this.histogramProgram,"u_mins");g.uniform4f(Z,w[0],w[0],w[0],w[0]);g.uniform1i(V,0)}var aa=g.getUniformLocation(this.histogramProgram,"u_color"),J=g.getUniformLocation(this.histogramProgram,
"u_factors"),O=g.getUniformLocation(this.histogramProgram,"u_size");g.uniform1f(O,256);a=[];b=[];g.uniform4fv(aa,[1,0,0,1]);g.uniform4fv(J,[r[0],0,0,1]);g.drawArrays(g.POINTS,0,y.length);var S=this.sourceRasterInfo.raster.bandCount;1<S&&(g.uniform4fv(aa,[0,1,0,1]),g.uniform4fv(J,[0,r[0],0,1]),g.drawArrays(g.POINTS,0,y.length),g.uniform4fv(aa,[0,0,1,1]),g.uniform4fv(J,[0,0,r[0],1]),g.drawArrays(g.POINTS,0,y.length));if(g.checkFramebufferStatus(g.FRAMEBUFFER)==g.FRAMEBUFFER_COMPLETE){var T=new Float32Array(1028);
g.readPixels(0,0,257,1,g.RGBA,g.FLOAT,T);g=0;var C=-.5===w[0]&&1===(u[0]-w[0])/256?.5:0;for(k=0;k<S;k++){var H=new Float32Array(257);var K=new Float32Array(257);for(v=g=0;256>v;v++)g+=T[4*v+k],H[v]=g,K[v]=T[4*v+k];K[256]=T[1024+k];H[256]=g+T[1024+k];var L=this.functionArguments.minPercent*g/100;if(u){for(m=0;256>m;m++)if(H[m]>L){a[k]=w[0]+(u[0]-w[0])/256*(m+C);break}L=(1-this.functionArguments.maxPercent/100)*g;for(m=254;0<=m;m--)if(H[m]<L){b[k]=w[0]+(u[0]-w[0])/256*(m+2-C);break}}}}return{histogram:T,
minCutOff:a,maxCutOff:b}}catch(P){console.debug("webgl filter exception: "+P.message)}},_setupHistTexture:function(a){if(a instanceof WebGLTexture)return a;var b=this.originalHistTexture=this._createTexture(),l=this.gl;a=a.pixelBlock;var g=a.width,f=a.height;l.getExtension("OES_texture_float");this.rgbaFloatData=a.getAsRGBAFloat();l.texImage2D(l.TEXTURE_2D,0,l.RGBA,g,f,0,l.RGBA,l.FLOAT,this.rgbaFloatData);return b}})})},"esri/layers/rasterLib/function/RemapFunction":function(){define("dojo/_base/declare dojo/_base/lang ../../../renderers/colorRampGenerator ./RasterFunctionX ./pixelShaders ./RasterFunctionWebGLMixin ./rasterUtils".split(" "),
function(G,e,t,n,p,h,c){return G([n,h],{declaredClass:"esri.layers.rasterLib.function.RemapFunction",functionName:"Remap",pixelType:"U8",renderTexture:!1,supportWebGL:!0,support2D:!0,constructor:function(a){this.functionArguments=this.mixinIgnoreCase({inputRanges:null,outputValues:null,outputColors:null,colorBreaks:null,raster:null},a)},bind:function(a){a=this.getSourceRasterInfo(a);if(!a.raster)return Error("The raster input is not available.");var b=!(!this.functionArguments.outputColors&&!this.functionArguments.colorBreaks);
this.rasterInfo=e.mixin(a.raster,{bandCount:b?3:1,pixelType:this._calculatePixelType(this.pixelType,"U8"),statistics:null,histograms:null});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};this.rasterInfo.keyProperties.DataType=b?"Processed":"Thematic";return!0},read2D:function(a){return this._remap(a.raster)},readGL:function(a){return this._remapGL(a.raster)},_remap:function(a){this._performance.start();var b=c.remapColor(a.pixelBlock,this.functionArguments.colorBreaks);this._addPerformanceMetric(this._performance.elapsed());
return{extent:a.extent,pixelBlock:b}},_remapGL:function(a){this._performance.start();this._initializeProgram({fragment:p.remap,fragmentName:"Remap"});var b=new Uint8Array(64),l=this.functionArguments.colorBreaks;l.forEach(function(k,m){b[4*m]=k.mappedColor[0];b[4*m+1]=k.mappedColor[1];b[4*m+2]=k.mappedColor[2];b[4*m+3]=1>=k.mappedColor[3]?255*k.mappedColor[3]:k.mappedColor[3]});var g=l[l.length-1],f=g.mappedColor;b[60]=f[0];b[61]=f[1];b[62]=f[2];b[63]=1>=f[3]?255*f[3]:f[3];var d=new Float32Array(16);
l.forEach(function(k,m){d[m]=k.value});d[15]=g.value;this._clrTexture||(this._clrTexture=this._setupColormapTexture(b));l=this._clrTexture;g=this.bindFrameBuffer();a=this._setupTextureData(a);this._setUniforms({u_indexedColormapOffset:0,u_indexedColormapMaxIndex:b.length/4-1,u_breaks:d});this._bindTexture(l,"u_image1");this._bindTexture(a.texture,"u_image");this._drawGL();return{extent:a.extent,texture:g.texture}},_setupColormapTexture:function(a){var b=this._createTexture(),l=a.length/4,g=new Float32Array(a.length),
f=this.renderTexture?255:1,d,k=this.gl;for(d=0;d<a.length;d++)g[d]=a[d]/f;k.getExtension("OES_texture_float");k.texImage2D(k.TEXTURE_2D,0,k.RGBA,l,1,0,k.RGBA,k.FLOAT,g);return b}})})},"esri/layers/rasterLib/function/IdentityFunction":function(){define(["dojo/_base/declare","dojo/_base/lang","./pixelShaders","./RasterFunctionX","./RasterFunctionWebGLMixin"],function(G,e,t,n,p){return G([n,p],{declaredClass:"esri.layers.rasterLib.function.IdentityFunction",functionName:"Identity",supportWebGL:!0,support2D:!0,
constructor:function(h){this.functionArguments={raster:null}},bind:function(h){h=this.getSourceRasterInfo(h);if(!h.raster)return Error("The raster input to identity function is invalid.");this.rasterInfo=e.mixin(h.raster,{});return!0},read2D:function(h){return h.raster},readGL:function(h){this._initializeProgram({fragment:t.identity,fragmentName:"identity"});h=this._setupTextureData(h.raster);var c=this.bindFrameBuffer();this._bindTexture(h.texture,"u_image");this._drawGL();return{extent:h.extent,
texture:c.texture}}})})},"esri/layers/rasterLib/function/ResampleFunction":function(){define(["dojo/_base/declare","dojo/_base/lang","./pixelShaders","./RasterFunctionX","./RasterFunctionWebGLMixin"],function(G,e,t,n,p){return G([n,p],{declaredClass:"esri.layers.rasterLib.function.ResampleFunction",renderTexture:!0,resamplingOrigin:null,resamplingRatio:null,zFactor:1,functionName:"Resample",supportWebGL:!0,support2D:!1,constructor:function(h){this.functionArguments=this.mixinIgnoreCase({resamplingType:0},
h)},bind:function(h){h=this.getSourceRasterInfo(h);if(!h.raster)return Error("The raster input to convolution function is invalid.");this.rasterInfo=e.mixin(h.raster,{bandCount:h.raster.bandCount,pixelType:this._calculatePixelType(this.pixelType,h.raster.pixelType),statistics:h.raster.statistics,histograms:h.raster.histograms});this.rasterInfo.keyProperties=this.rasterInfo.keyProperties||{};return!0},readGL:function(h){this._performance.start();this._initializeProgram({fragment:t.resample,fragmentName:"Resample"});
var c=this._setupTextureData(h.raster),a=this.bindFrameBuffer(),b=this.gl,l=b.drawingBufferWidth;b=b.drawingBufferHeight;var g=h.raster;void 0!==g.pixelBlock?(c=c||this._setupTextureData(g),h=g.pixelBlock.width,g=g.pixelBlock.height):(c=c||g,h=l,g=b);this._setUniforms({u_resamplingRatio:this.resamplingRatio||[h/l,g/b],u_anchor:this.resamplingOrigin||[0,1],u_resamplingType:this.functionArguments.resamplingType,u_resolution:[1/l,1/b]});this._drawGL();this._addPerformanceMetric(this._performance.elapsed());
return{extent:c.extent,texture:a.texture}}})})},"esri/layers/rasterLib/renderer/rasterRendererHelper":function(){define("dojo/_base/declare dojo/_base/lang ../../PixelBlock ./RasterColormapRenderer ./RasterUniqueValueRenderer ./RasterRGBRenderer ./RasterStretchColorRampRenderer ./RasterClassBreaksRenderer ./RasterShadedReliefRenderer".split(" "),function(G,e,t,n,p,h,c,a,b){var l=function(){function g(d){f[d.prototype.rendererName]=d}var f={};g(n);g(h);g(c);g(p);g(a);g(b);return f}();return{wellKnownRenderers:l,
isSupported:function(g){if(!g)return!1;var f=!0;l[g.rendererName]||(f=!1);return f},create:function(g){if(!g)return null;if(g.rendererName){var f=g.rendererName;g=g.rendererArguments}else f="uniqueValue rasterStretch rasterShadedRelief rgb rasterColormap classBreaks".split(" ").indexOf(g.type),f="UniqueValue Stretch ShadedRelief RGB Colormap ClassBreaks".split(" ")[f],"rasterStretch"===g.type&&g.bandIndex&&1<g.bandIndex.length&&(f="RGB");return(f=l[f])?new f(g):null},createDefaultRenderer:function(g){if(g&&
g.raster){var f=g.raster.rasterInfo,d=g.raster.dataType;if(f){var k=g.raster.rasterFunction,m=["Stretch","Colormap","ContrastAndBrightness"];if(k&&"U8"===f.pixelType&&-1<m.indexOf(k.functionName))k.renderTexture=!0;else if("Processed"!==d||!(g.useWebGL&&k&&k.renderTexture||!g.useWebGL&&"U8"===f.pixelType)){k&&(f=k.rasterInfo);k=f.bandCount;var v=f.colormap,q=f.vat;m=f.histograms;m&&0===m.length&&(m=null);var r=f.statistics&&f.statistics.map(function(y){return[y.min,y.max,y.mean,y.stddev]});if(1===
k&&v&&0<v.length)var w=this._getDefaultColormapRenderer(q,v);else if(1===k&&q&&q.features&&0<q.features.length)w=new p({});else{v=0;q=!1;d||!g.raster||!g.raster.tileInfo||void 0!==g.raster.tileInfo.tileType&&"Map"!==g.raster.tileInfo.tileType?"U8"===f.pixelType&&"Processed"===d?(v=5,r=r||[[0,255,0,0],[0,255,0,0],[0,255,0,0]],q=!1):"U8"===f.pixelType||"Elevation"===d?(v=5,q=r?!1:!0):"Scientific"===d||"StdTime"===d?(v=5,q=r?!1:!0,w=this._getDefaultScientificColorRamp()):m&&0<m.length?(v=6,q=!1):r?(v=
5,q=!1):(v=6,q=!0):(r=[[0,255,0,0],[0,255,0,0],[0,255,0,0]],v=5,q=!1);r||(v=5,q=!0);var u;3<=k&&!(g.bandIds||g.raster&&g.raster.imageServiceParams&&g.raster.imageServiceParams.bandIds)&&(u=this.getDefaultBandCombination(f));u&&(r=u.map(function(y){return r[y]}));g={stretchType:v,min:0,max:255,dra:q,minPercent:.25,maxPercent:.25,useGamma:!1,computeGamma:!1,statistics:r,histograms:m,numberOfStandardDeviations:2.5,bandIndex:u};1===k||u&&1===u.length?(w&&(g.colorRamp=w,g.invert=!1),w=new c(g)):w=new h(g)}return w}}}},
getDefaultBandCombination:function(g){var f=g.bandCount;if(1===f)return null;if(2===f)return[0];var d=(g=g.keyProperties)&&g.ChangeAnalysisParameters&&g.ChangeAnalysisParameters.AnalysisType;if(d&&("ccdc"===d.toLowerCase()||"landtrendr"===d.toLowerCase()))return[0];g=g&&g.BandProperties;var k;if(g&&g.length===f){var m=this.getWellKnownBandIndexes(g);g=m.red;d=m.green;var v=m.blue;m=m.nir;null!=g&&null!=d&&null!=v?k=[g,d,v]:null!=m&&null!=g&&null!=d&&(k=[m,g,d])}!k&&3<=f&&(k=[0,1,2]);return k},getWellKnownBandIndexes:function(g){for(var f=
{},d=0;d<g.length;d++){var k=g[d],m=k.BandName&&k.BandName.toLowerCase();"red"===m?f.red=d:"green"===m?f.green=d:"blue"===m?f.blue=d:"nearinfrared"===m||"nearinfrared_1"===m||"nir"===m?f.nir=d:k.WavelengthMax&&k.WavelengthMin&&(m=k.WavelengthMin,k=k.WavelengthMax,null==f.blue&&410<=m&&480>=m&&480<=k&&540>=k?f.blue=d:null==f.green&&490<=m&&560>=m&&560<=k&&610>=k?f.green=d:null==f.red&&595<=m&&670>=m&&660<=k&&730>=k?f.red=d:null==f.nir&&700<=m&&860>=m&&800<=k&&950>=k&&(f.nir=d))}return f},_getDefaultColormapRenderer:function(g,
f){if(f||f.length){var d=[],k=this._ratContainsColormap(g);if(k)var m=this._getRATValueClassNameMap(g);f.forEach(function(v){var q=m?m[v[0]]:v[0];d.push({color:[v[1],v[2],v[3]],value:v[0],label:k?null!=q?q:"":v[0]})});return new n({colormapInfos:d})}},_ratContainsColormap:function(g){if(!g||!g.fields)return!1;var f,d,k;return g.fields.some(function(m){m&&m.name&&(m=m.name.toLowerCase(),"red"===m&&(f=!0),"green"===m&&(d=!0),"blue"===m&&(k=!0));return f&&d&&k})},_getRATValueClassNameMap:function(g){if(!g||
!g.fields)return null;var f={},d,k;g.fields.forEach(function(m){if("classname"===m.name.toLowerCase()||"class_name"===m.name.toLowerCase())d=m.name;"value"===m.name.toLowerCase()&&(k=m.name)});g.features.forEach(function(m){m=m.attributes;f[m[k]]=d?m[d]:m[k]});return f},_getDefaultScientificColorRamp:function(){return{type:"multipart",colorRamps:[{fromColor:[255,0,0],toColor:[255,255,0]},{fromColor:[255,255,0],toColor:[0,255,255]},{fromColor:[0,255,255],toColor:[0,0,255]}].map(function(g){return{fromColor:g.toColor,
toColor:g.fromColor}}).reverse()}}}})},"esri/layers/rasterLib/renderer/RasterColormapRenderer":function(){define(["dojo/_base/declare","dojo/_base/lang","./RasterRenderer","../function/ColormapFunction"],function(G,e,t,n){return G([t],{declaredClass:"esri.layers.rasterLib.renderer.RasterColormapRenderer",rendererName:"Colormap",renderTexture:!0,constructor:function(p){p&&p.colormapInfos&&(p.colormap=p.colormapInfos.map(function(h){return[h.value].concat(h.color)}));this._function=new n(p);this._function.outputPixelType=
"U8";this._function.renderTexture=!0},draw2D:function(p){this._updateColormapParameters();p=this._clonePixelData(p);return p=this._function._colorize(p)},drawGL:function(p){this._updateColormapParameters();this._function._colorizeGL(p)},toJson:function(){var p=this._function.toJson().rasterFunctionArguments;return{rendererName:this.rendererName,rendererArguments:p}},toCommonRendererJson:function(){return{type:"rasterColormap",colormapInfos:this.colormapInfos||this.colormap.map(function(p){return{value:p[0],
color:p.slice(1),label:p[0]}})}},_updateColormapParameters:function(){var p=this._function.functionArguments;p.colormap=this.colormap;p.colormapName=this.colormapName;p.colorRamp=this.colorRamp;p.colorRampName=this.colorRampName}})})},"esri/layers/rasterLib/renderer/RasterRenderer":function(){define(["dojo/_base/declare","dojo/_base/lang","../../../geometry/Extent","../../PixelBlock"],function(G,e,t,n){return G(null,{declaredClass:"esri.layers.rasterLib.renderer.RasterRenderer",raster:null,constructor:function(p){p=
p||{};this.raster=p.raster||p.Raster||this.raster;this.draw=e.hitch(this,this.draw);this.bind=e.hitch(this,this.bind);p=e.clone(p);Object.keys(p).forEach(function(h){null==p[h]&&delete p[h]});e.mixin(this,p)},bind:function(p){if(!p)throw"failed to bind without options";var h=p;p.layer&&(p=p.layer,h={id:p.id,rawRasterInfo:p.raster.rasterInfo,glSetting:p._glSetting,xformSetting:p.tileManager&&p.tileManager.xformSetting,useWebGL:p.useWebGL,resampling:p.tileMode&&p.tileManager&&p.tileManager.xformSetting.requireProjection&&
!p._hasTilingEffects&&"Thematic"!==p.raster.dataType?1:0,tileMode:p.tileMode});this._rawRasterInfo=h.rawRasterInfo;this.useWebGL=h.useWebGL;this._function&&this._function.setProcessingContext(e.mixin({useProcessedData:!0},h));this._processingContext=h},hasTilingEffects:function(){},draw:function(p){return this.useWebGL?this.drawGL(p):this.draw2D(p)},toJson:function(){},_clonePixelData:function(p){if(null==p)return p;var h={};p.extent&&(h.extent=new t(p.extent.xmin,p.extent.ymin,p.extent.xmax,p.extent.ymax,
p.extent.spatialReference));p=p.processedPixelBlock||p.pixelBlock;if(null==p)return h;h.pixelBlock=p.clone?p.clone():n.prototype.clone(p);return h}})})},"esri/layers/rasterLib/renderer/RasterUniqueValueRenderer":function(){define(["dojo/_base/declare","dojo/_base/lang","./RasterRenderer","../function/ColormapFunction","../../../renderers/colorRampGenerator"],function(G,e,t,n,p){return G([t],{declaredClass:"esri.layers.rasterLib.renderer.RasterUniqueValueRenderer",rendererName:"UniqueValue",field:"",
alias:"",uniqueValueInfos:null,constructor:function(h){h&&h.colormap&&(this.colormap=h.colormap,this._function=new n(h),this._function.outputPixelType="U8",this._function.renderTexture=!0)},bind:function(h){this.inherited(arguments);if(!this._function){var c=(this.raster&&this.raster.rasterInfo||this._rawRasterInfo).vat;if(!c)throw"uv renderer requires data source to have raster attribute table";var a=this.attributeField||this.field1||this.field,b=this.infos||this.uniqueValueInfos;this.defaultColor=
this.defaultColor||this.defaultSymbol&&this.defaultSymbol.color;var l=c.fields.filter(function(w){return"value"===w.name.toLowerCase()})[0];if(l)var g=l.name;a||((a=c.fields.filter(function(w){return-1<["classname","category"].indexOf(w.name.toLowerCase())})[0])||(a=c.fields.filter(function(w){return"esriFieldTypeString"===w.type})[0]),this.alias=(this.field=a=a&&a.name||g)&&a.alias||g);var f=[],d;if(!b){b=[];var k=c.fields.filter(function(w){return"alpha"===w.name.toLowerCase()})[0];var m=c.fields.filter(function(w){return"red"===
w.name.toLowerCase()})[0];var v=c.fields.filter(function(w){return"green"===w.name.toLowerCase()})[0];var q=c.fields.filter(function(w){return"blue"===w.name.toLowerCase()})[0];for(l=0;l<c.features.length;l++){var r=c.features[l].attributes;(d=b.some(function(w){w.value===r[a]}))||(k&&m&&v&&q?b.push({value:r[a],alias:r[a],color:[r[m.name],r[v.name],r[q.name],r[k.name]]}):m&&v&&q?b.push({value:r[a],alias:r[a],color:[r[m.name],r[v.name],r[q.name]]}):b.push({value:r[a],alias:r[a]}))}if(!(m&&v&&q))for(d=
p.createRandomColorRamp({size:b.length}),l=0;l<b.length;l++)b[l].color=d[l];this.uniqueValueInfos=b}if(b)b.forEach(function(w){f=f.concat(c.features.filter(function(u){return w.value==u.attributes[a]}).map(function(u){return[u.attributes[g]].concat(w.color||w.symbol&&w.symbol.color)}))}),this.defaultColor&&c.features.filter(function(w){f.some(function(u){return u[0]===w.attributes[g]})||f.push([w.attributes[g]].concat(this.defaultColor))});else throw"missing uniqueValueInfos property";this._function=
new n({colormap:f});this.colormap=f;this._function.outputPixelType="U8";this._function.renderTexture=!0;this._function.setProcessingContext(this._processingContext)}},draw2D:function(h){h=this._clonePixelData(h);return h=this._function._colorize(h)},drawGL:function(h){this._function._colorizeGL(h)},toJson:function(h){var c={field:this.field,uniqueValueInfos:this.uniqueValueInfos,defaultColor:this.defaultColor};h&&(c.colormap=this.colormap);return{rendererName:this.rendererName,rendererArguments:c}},
toCommonRendererJson:function(){var h=this.attributeField||this.field1||this.field,c=(this.infos||this.uniqueValueInfos).map(function(a){return{value:a.value,label:a.alias+"",symbol:{color:3===a.color.length?a.color.concat([255]):a.color,type:"esriSFS",style:"esriSFSSolid"}}});return{type:"uniqueValue",field1:h,uniqueValueInfos:c}}})})},"esri/layers/rasterLib/renderer/RasterRGBRenderer":function(){define("dojo/_base/declare dojo/_base/lang ./RasterRenderer ../function/StretchFunction ../function/ContrastBrightnessFunction ../function/rasterUtils".split(" "),
function(G,e,t,n,p,h){return G([t],{declaredClass:"esri.layers.rasterLib.renderer.RasterRGBRenderer",rendererName:"RGB",bandIndex:null,stretchType:0,min:0,max:255,numberOfStandardDeviations:2,statistics:null,histograms:null,dra:!1,minPercent:.25,maxPercent:.5,useGamma:!1,gamma:null,computeGamma:!1,sigmoidStrengthLevel:1,constructor:function(c){this.stretchType="number"===typeof this.stretchType?this.stretchType:"none   standardDeviation histogramEqualization minMax percentClip   sigmoid".split(" ").indexOf(this.stretchType);
c=e.mixin({},c,{stretchType:this.stretchType});this._stretchFunction=new n(c);this._stretchFunction.outputPixelType="U8";this._stretchFunction.renderTexture=!1;this.bandIndex=c.bandIndex||c.BandIndex;this._function=new p(c);this._function.functionArguments.raster=this._stretchFunction;this._function.renderTexture=!0},hasTilingEffects:function(){return this._stretchFunction.hasTilingEffects()},draw2D:function(c){this._updateStretchParameters();c=this._clonePixelData(c);if("U8"===c.pixelBlock.pixelType&&
!this.contrastOffset&&!this.brightnessOffset)return c;this._stretchFunction._stretch(c);var a=c.pixelBlock,b=this.bandIndex,l=Math.max.apply(null,b);a&&a.pixels.length>l&&b&&(a.pixels=b.map(function(g){return a.pixels[g]}),a.statistics&&(a.statistics=b.map(function(g){return a.statistics[g]})));if(this.contrastOffset||this.brightnessOffset)c.pixelBlock=h.contrastBrightnessStretch(c.pixelBlock,{contrastOffset:this.contrastOffset,brightnessOffset:this.brightnessOffset});return c},drawGL:function(c){this._updateStretchParameters();
c.pixelBlock&&(c=this._clonePixelData(c));var a=c.pixelBlock,b=this.bandIndex,l=Math.max.apply(null,b),g=this.statistics&&0<this.statistics.length?this.statistics:this._stretchFunction&&this._stretchFunction.srcStatistics,f=this.histograms&&0<this.histograms.length?this.histograms:this._stretchFunction&&this._stretchFunction.srcHistograms,d,k;a&&a.pixels.length>l&&b&&(a.pixels=b.map(function(m){return a.pixels[m]}),a.statistics&&(a.statistics=b.map(function(m){return a.statistics[m]})),g&&0<g.length&&
g.length!==b.length&&(d=b.map(function(m){return g[m]})),f&&0<f.length&&f.length!==b.length&&(k=b.map(function(m){return f[m]})));this._stretchFunction.functionArguments.statistics=d||g;this._stretchFunction.functionArguments.histograms=k||f;this.contrastOffset||this.brightnessOffset?(this._stretchFunction.renderTexture=!1,this._function.renderTexture=!0,c=this._stretchFunction._stretchGL(c),this._function._cbGL(c)):(this._stretchFunction.renderTexture=!0,this._stretchFunction._stretchGL(c))},toJson:function(){var c=
this._stretchFunction.toJson().rasterFunctionArguments;c.bandIndex=this.bandIndex;c.contrastOffset=this.contrastOffset;c.brightnessOffset=this.brightnessOffset;return{rendererName:this.rendererName,rendererArguments:c}},toCommonRendererJson:function(){return{type:"rasterStretch",stretchType:"none   standardDeviation histogramEqualization minMax percentClip   sigmoid".split(" ")[this.stretchType]||"minMax",min:this.min,max:this.max,numberOfStandardDeviations:this.numberOfStandardDeviations,statistics:e.clone(this.statistics),
dra:this.dra,minPercent:this.minPercent,maxPercent:this.maxPercent,useGamma:this.useGamma,gamma:e.clone(this.gamma),computeGamma:this.computeGamma,sigmoidStrengthLevel:this.sigmoidStrengthLevel}},_updateStretchParameters:function(){var c=this._stretchFunction.functionArguments;c.stretchType=this.stretchType;c.min=this.min;c.max=this.max;c.numberOfStandardDeviations=this.numberOfStandardDeviations;c.statistics=this.statistics;c.histograms=this.histograms;c.dra=this.dra;c.minPercent=this.minPercent;
c.maxPercent=this.maxPercent;c.useGamma=this.useGamma;c.gamma=this.gamma;c.computeGamma=this.computeGamma;this._stretchFunction.interpolation=this.interpolation}})})},"esri/layers/rasterLib/renderer/RasterStretchColorRampRenderer":function(){define("dojo/_base/declare dojo/_base/lang ./RasterRenderer ../function/ResampleFunction ../function/StretchFunction ../function/ContrastBrightnessFunction ../function/ColormapFunction ../function/rasterUtils".split(" "),function(G,e,t,n,p,h,c,a){return G([t],
{declaredClass:"esri.layers.rasterLib.renderer.RasterStretchColorRampRenderer",rendererName:"Stretch",bandIndex:[0],colorRamp:null,invert:!1,stretchType:0,min:0,max:255,numberOfStandardDeviations:2,statistics:null,histograms:null,dra:!1,minPercent:.25,maxPercent:.5,useGamma:!1,gamma:null,computeGamma:!1,sigmoidStrengthLevel:1,constructor:function(b){this.stretchType="number"===typeof this.stretchType?this.stretchType:"none   standardDeviation histogramEqualization minMax percentClip   sigmoid".split(" ").indexOf(this.stretchType);
b=e.mixin({},b,{stretchType:this.stretchType});Object.keys(b).forEach(function(l){null==b[l]&&delete b[l]});this._function=new h(b);this._stretchFunction=new p(b);this._stretchFunction.outputPixelType="U8";this._stretchFunction.renderTexture=!1;this._clrFunction=new c(b);this._clrFunction.functionArguments.raster=this._stretchFunction;this._clrFunction.renderTexture=!1;this._function.functionArguments.raster=this._clrFunction},hasTilingEffects:function(){return this._stretchFunction.hasTilingEffects()},
draw2D:function(b){this._updateStretchParameters();b=this._clonePixelData(b);if("U8"===b.pixelBlock.pixelType&&!(this.contrastOffset||this.brightnessOffset||this.colorRamp))return b;this._stretchFunction._stretch(b);var l=b.pixelBlock,g=this.bandIndex?this.bandIndex[0]:0;l&&1<l.pixels.length&&l.pixels.length>g&&(l.pixels=[l.pixels[g]],l.statistics&&(l.statistics=[l.statistics[g]]));this.colorRamp&&(b=this._clrFunction._colorize(b));if(this.contrastOffset||this.brightnessOffset)b.pixelBlock=a.contrastBrightnessStretch(b.pixelBlock,
{contrastOffset:this.contrastOffset,brightnessOffset:this.brightnessOffset});return b},drawGL:function(b){this._updateStretchParameters();b.pixelBlock&&(b=this._clonePixelData(b));var l=b.pixelBlock,g=this.bandIndex?this.bandIndex[0]||0:0,f=this.statistics&&0<this.statistics.length?this.statistics:this._stretchFunction&&this._stretchFunction.srcStatistics,d=this.histograms&&0<this.histograms.length?this.histograms:this._stretchFunction&&this._stretchFunction.srcHistograms,k,m;l&&1<l.pixels.length&&
l.pixels.length>g&&(l.pixels=[l.pixels[g]],l.statistics&&(l.statistics=[l.statistics[g]]),f&&f.length>g&&(k=[f[g]]),d&&d.length>g&&(m=[d[g]]));this._stretchFunction.functionArguments.statistics=k||f;this._stretchFunction.functionArguments.histograms=m||d;l=!!this.colorRamp;this.contrastOffset||this.brightnessOffset?(this._stretchFunction.renderTexture=!1,this._clrFunction.renderTexture=!1,this._function.renderTexture=!0,b=this._stretchFunction._stretchGL(b),l&&(b=this._clrFunction._colorizeGL(b)),
this._function._cbGL(b)):l?(this._stretchFunction.renderTexture=!1,this._clrFunction.renderTexture=!0,b=this._stretchFunction._stretchGL(b),this._clrFunction._colorizeGL(b)):(this._stretchFunction.renderTexture=!0,this._stretchFunction._stretchGL(b))},toJson:function(){var b=this._stretchFunction.toJson().rasterFunctionArguments;b.colorRamp=this.colorRamp||"";this.invert&&(b.invert=!0);b.contrastOffset=this.contrastOffset;b.brightnessOffset=this.brightnessOffset;return{rendererName:this.rendererName,
rendererArguments:b}},toCommonRendererJson:function(){return{type:"rasterStretch",stretchType:"none   standardDeviation histogramEqualization minMax percentClip   sigmoid".split(" ")[this.stretchType]||"minMax",colorRamp:this.colorRamp&&this.colorRamp.toJson?this.colorRamp.toJson():this.colorRamp,min:this.min,max:this.max,numberOfStandardDeviations:this.numberOfStandardDeviations,statistics:e.clone(this.statistics),dra:this.dra,minPercent:this.minPercent,maxPercent:this.maxPercent,useGamma:this.useGamma,
gamma:e.clone(this.gamma),computeGamma:this.computeGamma,sigmoidStrengthLevel:this.sigmoidStrengthLevel}},_updateStretchParameters:function(){var b=this._stretchFunction.functionArguments;b.stretchType=this.stretchType;b.min=this.min;b.max=this.max;b.numberOfStandardDeviations=this.numberOfStandardDeviations;b.statistics=this.statistics;b.histograms=this.histograms;b.dra=this.dra;b.minPercent=this.minPercent;b.maxPercent=this.maxPercent;b.useGamma=this.useGamma;b.gamma=this.gamma;b.computeGamma=this.computeGamma;
this._stretchFunction.interpolation=this.interpolation}})})},"esri/layers/rasterLib/renderer/RasterClassBreaksRenderer":function(){define(["dojo/_base/declare","dojo/_base/lang","./RasterRenderer","../function/ColormapFunction","../function/RemapFunction"],function(G,e,t,n,p){return G([t],{declaredClass:"esri.layers.rasterLib.renderer.RasterClassBreaksRenderer",rendererName:"ClassBreaks",renderTexture:!0,constructor:function(h){h=h||{};this._function=new p(h);this._function.outputPixelType="U8";var c=
h.classBreakInfos;h=h.minValue;null!=h&&c&&(this._function.functionArguments.colorBreaks=this._getSortedColorBreaks(h,c))},bind:function(h){this.inherited(arguments);this.isColormapFunction=!1;var c=this.raster&&this.raster.rasterInfo||this._rawRasterInfo,a=c&&c.vat;if(a&&"u8"===c.pixelType.toLowerCase()&&this.classBreakInfos){var b=this.field;if(c=a.fields.filter(function(m){return"value"===m.name.toLowerCase()})[0])var l=c.name;var g=a.features.sort(function(m,v){return parseFloat(m.attributes[b])-
parseFloat(v.attributes[b])})[0].attributes[b];this.isColormapFunction=!0;var f=[],d=this.field,k=this.classBreakInfos;k.forEach(function(m,v){a.features.forEach(function(q){var r=k[v-1]&&k[v-1].classMaxValue||g;q.attributes[d]<=m.classMaxValue&&(q.attributes[d]>r||q.attributes[d]===g)&&(r=m.symbol.color,f.some(function(w){return w[0]===q.attributes[l]})||f.push([q.attributes[l]].concat(r)))})});this._function=new n({colormap:f});this.colormap=f;this._function.outputPixelType="U8";this._function.renderTexture=
!0}this._function&&this._function.setProcessingContext(e.mixin({useProcessedData:!0},this._processingContext))},draw2D:function(h){if(this.isColormapFunction)return this._updateColormapParameters(),h=this._clonePixelData(h),h=this._function._colorize(h);this._updateRemapParameters();return this._function._remap(h)},drawGL:function(h){this.isColormapFunction?(this._updateColormapParameters(),this._function._colorizeGL(h)):(this._function.renderTexture=!0,this._updateRemapParameters(),this._function._remapGL(h))},
toJson:function(){var h=this._function.toJson().rasterFunctionArguments;return{rendererName:this.rendererName,rendererArguments:h}},toCommonRendererJson:function(){var h,c=this.classBreakInfos,a=this.colorBreaks;if(null==c&&a)for(c=[],h=0;h<a.length-1;h++)c.push({classMaxValue:a[h+1].value,symbol:{color:a[h].mappedColor,type:"esriSFS",style:"esriSFSSolid"},label:a[h].value+" - "+a[h+1].value});return{type:"classBreaks",field:"Value",minValue:null!=this.minValue?this.minValue:a[0].value,classBreakInfos:c}},
_updateRemapParameters:function(){var h=this.classBreakInfos,c=this.minValue;null!=c&&h&&(this._function.functionArguments.colorBreaks=this._getSortedColorBreaks(c,h))},_getSortedColorBreaks:function(h,c){c=c.map(function(b){return{maxValue:b.classMaxValue,color:b.symbol.color}}).sort(function(b,l){return b.maxValue-l.maxValue});var a=[{value:h,mappedColor:c[0].color}];for(h=0;h<c.length;h++)a.push({value:c[h].maxValue,mappedColor:h===c.length-1?c[h].color:c[h+1].color});return a},_updateColormapParameters:function(){this._function.functionArguments.colormap=
this.colormap;this._function.interpolation=this.interpolation}})})},"esri/layers/rasterLib/renderer/RasterShadedReliefRenderer":function(){define("dojo/_base/declare dojo/_base/lang ./RasterRenderer ../function/HillshadeFunction ../function/ContrastBrightnessFunction ../function/ColormapFunction ../function/rasterUtils".split(" "),function(G,e,t,n,p,h,c){return G([t],{declaredClass:"esri.layers.rasterLib.renderer.RasterShadedReliefRenderer",rendererName:"ShadedRelief",hillshadeType:null,azimuth:315,
altitude:45,zFactor:1,slopeType:null,psPower:.664,psFactor:.024,raster:null,constructor:function(a){this.hillshadeType="number"===typeof this.hillshadeType?this.hillshadeType:["traditional","multi-directional"].indexOf(this.hillshadeType);a&&a.scalingType&&(this.slopeType="adjusted"===a.scalingType?3:1);a&&a.pixelSizePower&&(this.psPower=a.pixelSizePower);a&&a.pixelSizeFactor&&(this.psFactor=a.pixelSizeFactor);a=e.mixin({},a,{hillshadeType:this.hillshadeType,psPower:this.psPower,psFactor:this.psFactor,
slopeType:this.slopeType});Object.keys(a).forEach(function(b){null==a[b]&&delete a[b]});this._function=new p(a);this._hillshadeFunction=new n(a);this._hillshadeFunction.outputPixelType="U8";this._hillshadeFunction.renderTexture=!1;this._function.functionArguments.raster=this._hillshadeFunction},hasTilingEffects:function(){return this._hillshadeFunction.hasTilingEffects()},draw2D:function(a){this._updateHillshadeParameters();a=this._clonePixelData(a);a=this._hillshadeFunction.read2D({raster:a});if(this.contrastOffset||
this.brightnessOffset)a.pixelBlock=c.contrastBrightnessStretch(a.pixelBlock,{contrastOffset:this.contrastOffset,brightnessOffset:this.brightnessOffset});return a},drawGL:function(a){this._updateHillshadeParameters();this.contrastOffset||this.brightnessOffset?(this._hillshadeFunction.renderTexture=!1,this._function.renderTexture=!0,a=this._hillshadeFunction.readGL({raster:a}),this._function._cbGL(a)):(this._hillshadeFunction.renderTexture=!0,this._hillshadeFunction.readGL({raster:a}))},toJson:function(){var a=
this._hillshadeFunction.toJson().rasterFunctionArguments;a.colorRamp=this.colorRamp||"";this.invert&&(a.invert=!0);a.contrastOffset=this.contrastOffset;a.brightnessOffset=this.brightnessOffset;return{rendererName:this.rendererName,rendererArguments:a}},toCommonRendererJson:function(){return{type:"rasterShadedRelief",hillshadeType:["traditional","multi-directional"][this.hillshadeType]||"traditional",azimuth:this.azimuth,altitude:this.altitude,zFactor:this.zFactor,scalingType:3===this.slopeType?"adjusted":
"none",pixelSizePower:this.psPower,pixelSizeFactor:this.psFactor,colorRamp:this.colorRamp&&this.colorRamp.toJson?this.colorRamp.toJson():this.colorRamp}},_updateHillshadeParameters:function(){var a=this._hillshadeFunction.functionArguments;a.hillshadeType=this.hillshadeType;a.azimuth=this.azimuth;a.altitude=this.altitude;a.zFactor=this.zFactor;a.slopeType=this.slopeType;a.psPower=this.psPower;a.psFactor=this.psFactor}})})},"esri/layers/rasterLib/raster/rasterProjectionHelper":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/Deferred dojo/sniff ../../../kernel ../../../WKIDUnitConversion ../../../geometry/Extent ../../../geometry/projection ../../../geometry/webMercatorUtils ../../../SpatialReference ../../../geometry/Point".split(" "),
function(G,e,t,n,p,h,c,a,b,l,g){G={requirePE:function(d,k){return!(d.equals(k)||d._canProject(k))},load:function(){var d=new t;if(!this._loadPromise)if(a.isSupported())this._loadPromise=a.load();else{var k=new t;k.reject("projection engine is not supported on this version of the browser, please try with a modern browser");this._loadPromise=k.promise}this._loadPromise.isFulfilled()?this._loadPromise.isResolved()?d.resolve():this._loadPromise.isRejected()&&d.resolve():(this._pendingdfds=this._pendingdfds||
[],this._pendingdfds.push(d),this._loadPromise.then(e.hitch(this,function(){this._pendingdfds.forEach(function(m){m.isFulfilled()||m.resolve()})}),e.hitch(this,function(){this._pendingdfds.forEach(function(m){m.isFulfilled()||m.reject()})})));return d.promise},computeError:function(d,k){return[Math.abs((d[0]+d[4]+d[4*k.rows]+d[4*k.rows+4])/4-d[2*k.rows+2]),Math.abs((d[1]+d[5]+d[4*k.rows+1]+d[4*k.rows+5])/4-d[2*k.rows+3])]},getDefaultDatumTransformationForDataset:function(d,k,m){if(!(k&&d.spatialReference&&
this.requirePE(d.spatialReference,k)&&a.isLoaded()))return null;d=new c(d.toJson());k=new l(k.toJson());return m?a.getTransformation(k,d.spatialReference,d):a.getTransformation(d.spatialReference,k,d)},project:function(d,k,m){if(!k||d.spatialReference.equals(k))return d;var v=a.isLoaded()?a:b;"esri.geometry.Extent"===d.declaredClass?d=new c(d.toJson()):"esri.geometry.Point"===d.declaredClass&&(d=new g(d.toJson()));k=new l(k.toJson());(d=v.project(d,k))&&"esri.geometry.Extent"===d.declaredClass?(d=
new c(d.toJson()),m&&(1E-5>Math.abs(d.xmin+180)&&1E-5>Math.abs(d.xmax-180)?(d.xmin=0,d.xmax=360):(0>d.xmin&&(d.xmin+=360,d.xmax+=360),0>d.xmax&&(d.xmax+=360)))):d&&"esri.geometry.Point"===d.declaredClass&&(d=new g(d.toJson()),m&&0>d.x&&(d.x+=360));return d},projectResolution:function(d,k,m){var v=m.xmin+(m.xmax-m.xmin)/2;m=m.ymin+(m.ymax-m.ymin)/2;d=new c(v,m,v+d.x,m+d.y,d.spatialReference);d=this.project(d,k);return new g(d.xmax-d.xmin,d.ymax-d.ymin,k)},getProjectionOffsetGrid:function(d,k,m,v,q,
r,w){null==w&&(w=[32,32]);var u=d.xmin,y=d.ymin,x=d.xmax,z=d.ymax,A=d.spatialReference,E=k.spatialReference,F=a.isLoaded()?a:b,B=q?-q:null,D=w[0]*m.x,I=w[1]*m.y;x={cols:Math.ceil((x-u)/D)+1,rows:Math.ceil((z-y)/I)+1};d=[];for(z=0;z<x.cols;z++){var M=N;var N=[];for(m=0;m<x.rows;m++){var Q=new g({x:u+D*z,y:y+I*m,spatialReference:A});Q=F.project(Q,E,r);if(!Q)return null;v&&0>Q.x&&(Q.x+=360);N.push(Q);0<z&&null!=B&&Q.x<M[m].x&&(Q.x+=q-B,Q.x<M[m].x&&(Q.x+=q-B));d.push((Q.x-k.xmin)/(k.xmax-k.xmin));d.push((Q.y-
k.ymin)/(k.ymax-k.ymin))}}k=this.computeError(d,x);v=new Float32Array((x.cols-1)*(x.rows-1)*12);q=new Float32Array([-0,-1,1,-1,1,-0,1,-0,-0]);r=new Float32Array([-1,1,0,0,-1,1,1,0,0]);for(z=0;z<x.cols-1;z++)for(m=0;m<x.rows-1;m++){D=z*x.rows*2+2*m;u=d[D];y=d[D+1];N=d[D+2];A=d[D+3];D+=2*x.rows;E=d[D];F=d[D+1];B=d[D+2];I=d[D+3];M=0;Q=12*(m*(x.cols-1)+z);for(D=0;3>D;D++)v[Q++]=q[M++]*u+q[M++]*N+q[M++]*B;for(D=M=0;3>D;D++)v[Q++]=q[M++]*y+q[M++]*A+q[M++]*I;for(D=M=0;3>D;D++)v[Q++]=r[M++]*u+r[M++]*E+r[M++]*
B;for(D=M=0;3>D;D++)v[Q++]=r[M++]*y+r[M++]*F+r[M++]*I}return{offsets:d,error:k,coefficients:v,spacing:w,size:[x.cols-1,x.rows-1]}},getHalfWorldWidth:function(d){var k=d&&d.wkid;if(null!=k)return d.isWebMercator()&&(k=3857),null==h[k]?180:f[k]}};n("extend-esri")&&e.setObject("layers.rasterLib.raster.rasterProjectionHelper",G,p);var f={3395:2.0037508342789244E7,3410:1.7334193943686873E7,3832:3339584.723798206,3857:2.0037508342788905E7,3975:1.7367530445161372E7,4087:2.0037508342789244E7,4088:2.0015108787169147E7,
6933:1.7367530445161372E7,8858:7396237.374497803,8859:2465412.4581659334,32662:2.0037508342789244E7,53001:2.001508679602057E7,53002:1.000754339801029E7,53003:2.001508679602057E7,53004:2.001508679602057E7,53016:1.4152803599503474E7,53017:1.7333573624304302E7,53025:7276828.3848298555,53031:1.0384677558821043E7,53034:2.001508679602057E7,53036:7389443.187332862,53037:2463147.729110953,53079:2.0015114352186374E7,53080:2.0015114352186374E7,54001:2.0037508342789244E7,54002:1.0018754171394624E7,54003:2.0037508342789244E7,
54004:2.0037508342789244E7,54016:1.4168658027268292E7,54017:1.736753044516137E7,54025:7311399.09166516,54031:1.0396310810074743E7,54034:2.0037508342789244E7,54050:808820.9223376509,54053:1920897.3915568967,54079:2.0037508342789244E7,54080:2.0037508342789244E7,54099:1.3524439768288724E7,54100:2.0037508342789244E7,54101:2.0037508342789244E7,102038:4297258.582585486,102299:5013965.117483125};return G})},"esri/geometry/projection":function(){define("require exports dojo/Deferred ./pe ../SpatialReference ./GeographicTransformation".split(" "),
function(G,e,t,n,p,h){function c(f,d,k,m,v){void 0===m&&(m=null);void 0===v&&(v=!1);if(null===m){var q=h.cacheKey(d,k);void 0!==g[q]?m=g[q]:(m=a(d,k,null),null===m&&(m=new h),g[q]=m)}return b._project(f,d,k instanceof p||!1===v?k:new p(k),m,v)}function a(f,d,k){void 0===k&&(k=null);f=b._getTransformation(f,d,k);return null!==f?h.fromGE(f):null}Object.defineProperty(e,"__esModule",{value:!0});var b=null;e.isLoaded=function(){return!!b&&n.isLoaded()};e.isSupported=function(){return n.isSupported()};
var l=null;e.load=function(){if(l)return l.promise;l=new t;var f=n.load();G(["./geometryEngine"],function(d){b=d;f.then(function(){b._enableProjection(n);l.resolve()},function(k){l.reject(k)})});return l.promise};e.project=function(f,d,k){void 0===k&&(k=null);return f instanceof Array?0===f.length?[]:c(f,f[0].spatialReference,d,k):c([f],f.spatialReference,d,k)[0]};var g={};e.projectMany=c;e.getTransformation=a;e.getTransformations=function(f,d,k){void 0===k&&(k=null);f=b._getTransformationBySuitability(f,
d,k);if(null!==f){d=[];for(k=0;k<f.length;k++)d.push(h.fromGE(f[k]));return d}return[]}})},"esri/geometry/pe":function(){define(["require","exports","../core/tsSupport/extendsHelper","dojo/Deferred","../core/sniff"],function(G,e,t,n,p){function h(q){function r(x,z,A){x[z]=A(x[z])}e._pe=q;f.init();d.init();k.init();m.init();v.init();e.PeGCSExtent=function(x){function z(){return null!==x&&x.apply(this,arguments)||this}t(z,x);z.prototype.destroy=function(){e._pe.destroy(this)};return z}(e._pe.PeGCSExtent);
for(var w=0,u=[e._pe.PeDatum,e._pe.PeGeogcs,e._pe.PeGeogtran,e._pe.PeObject,e._pe.PeParameter,e._pe.PePrimem,e._pe.PeProjcs,e._pe.PeSpheroid,e._pe.PeUnit];w<u.length;w++)q=u[w],r(q.prototype,"getName",function(x){return function(){return x.call(this,Array(f.PE_NAME_MAX))}});w=0;for(u=[e._pe.PeGeogtran,e._pe.PeProjcs];w<u.length;w++)q=u[w],r(q.prototype,"getParameters",function(x){return function(){for(var z=Array(f.PE_PARM_MAX),A=x.call(this),E=0;E<z.length;E++){var F=e._pe.getValue(A,"*");z[E]=F?
e._pe.wrapPointer(F,e._pe.PeParameter):null;A+=Int32Array.BYTES_PER_ELEMENT}return z}});r(e._pe.PeHorizon.prototype,"getCoord",function(x){return function(){var z=this.getSize();if(!z)return null;var A=[],E=x.call(this);l(A,z,E);return A}});r(e._pe.PeGTlistExtendedEntry.prototype,"getEntries",function(x){var z=e._pe._pe_getPeGTlistExtendedGTsSize();return function(){var A=null,E=x.call(this);if(!e._pe.compare(E,e._pe.NULL)){A=[E];var F=this.getSteps();if(1<F){E=e._pe.getPointer(E);for(var B=1;B<F;B++)A.push(e._pe.wrapPointer(E+
z*B,e._pe.PeGTlistExtendedGTs))}}return A}});var y=e._pe._pe_getPeHorizonSize();q=function(x){return function(){var z=this._cache;z||(this._cache=z=new Map);if(z.has(x))return z.get(x);var A=null,E=x.call(this);if(!e._pe.compare(E,e._pe.NULL)){A=[E];var F=E.getNump();if(1<F){E=e._pe.getPointer(E);for(var B=1;B<F;B++)A.push(e._pe.wrapPointer(E+y*B,e._pe.PeHorizon))}}z.set(x,A);return A}};r(e._pe.PeProjcs.prototype,"horizonGcsGenerate",q);r(e._pe.PeProjcs.prototype,"horizonPcsGenerate",q);e._pe.PeObject.prototype.toString=
function(x){void 0===x&&(x=f.PE_STR_OPTS_NONE);e._pe.ensureCache.prepare();var z=e._pe.getPointer(this),A=e._pe.ensureInt8(Array(f.PE_BUFFER_MAX));return e._pe.UTF8ToString(e._pe._pe_object_to_string_ext(z,x,A))}}function c(q){if(q){var r=e._pe.getClass(q);r&&(r=e._pe.getCache(r))&&(q=e._pe.getPointer(q))&&delete r[q]}}function a(q,r){var w=[];r=Array(r);for(var u=0;u<q;u++)w.push(e._pe.ensureInt8(r));return w}function b(q){if(Array.isArray(q[0])){var r=[];q.forEach(function(w){r.push(w[0],w[1])})}else r=
q;return r}function l(q,r,w,u){void 0===u&&(u=!1);if(u)for(u=0;u<2*r;u++)q[u]=e._pe.getValue(w+u*Float64Array.BYTES_PER_ELEMENT,"double");else{var y=0===q.length;for(u=0;u<r;u++)y&&(q[u]=Array(2)),q[u][0]=e._pe.getValue(w,"double"),q[u][1]=e._pe.getValue(w+Float64Array.BYTES_PER_ELEMENT,"double"),w+=2*Float64Array.BYTES_PER_ELEMENT}}Object.defineProperty(e,"__esModule",{value:!0});var g;e._pe=null;e.isLoaded=function(){return!!e._pe};e.isSupported=function(){return!!p("esri-wasm")};e.load=function(){if(g)return g.promise;
g=new n;G(["./support/pe-wasm"],function(q){q({locateFile:function(r){return G.toUrl("./support/"+r)},onAbort:function(r){g.reject(Error(r))}}).then(function(r){h(r);g.resolve()})});return g.promise};(function(q){function r(y,x,z){e._pe.ensureCache.prepare();var A=b(z),E=z===A;A=e._pe.ensureFloat64(A);(y=e._pe._pe_geog_to_proj(e._pe.getPointer(y),x,A))&&l(z,x,A,E);return y}function w(y,x,z){return u(y,x,z,0)}function u(y,x,z,A){e._pe.ensureCache.prepare();var E=b(z),F=z===E;E=e._pe.ensureFloat64(E);
(y=e._pe._pe_proj_to_geog_center(e._pe.getPointer(y),x,E,A))&&l(z,x,E,F);return y}q.geogToProj=r;q.projGeog=function(y,x,z,A){switch(A){case f.PE_TRANSFORM_P_TO_G:return w(y,x,z);case f.PE_TRANSFORM_G_TO_P:return r(y,x,z)}return 0};q.projToGeog=w;q.projToGeogCenter=u})(e.PeCSTransformations||(e.PeCSTransformations={}));var f;(function(q){q.init=function(){q.PE_BUFFER_MAX=e._pe.PeDefs.prototype.PE_BUFFER_MAX;q.PE_NAME_MAX=e._pe.PeDefs.prototype.PE_NAME_MAX;q.PE_MGRS_MAX=e._pe.PeDefs.prototype.PE_MGRS_MAX;
q.PE_USNG_MAX=e._pe.PeDefs.prototype.PE_USNG_MAX;q.PE_DD_MAX=e._pe.PeDefs.prototype.PE_DD_MAX;q.PE_DDM_MAX=e._pe.PeDefs.prototype.PE_DDM_MAX;q.PE_DMS_MAX=e._pe.PeDefs.prototype.PE_DMS_MAX;q.PE_UTM_MAX=e._pe.PeDefs.prototype.PE_UTM_MAX;q.PE_PARM_MAX=e._pe.PeDefs.prototype.PE_PARM_MAX;q.PE_TYPE_NONE=e._pe.PeDefs.prototype.PE_TYPE_NONE;q.PE_TYPE_GEOGCS=e._pe.PeDefs.prototype.PE_TYPE_GEOGCS;q.PE_TYPE_PROJCS=e._pe.PeDefs.prototype.PE_TYPE_PROJCS;q.PE_TYPE_GEOGTRAN=e._pe.PeDefs.prototype.PE_TYPE_GEOGTRAN;
q.PE_TYPE_COORDSYS=e._pe.PeDefs.prototype.PE_TYPE_COORDSYS;q.PE_TYPE_UNIT=e._pe.PeDefs.prototype.PE_TYPE_UNIT;q.PE_STR_OPTS_NONE=e._pe.PeDefs.prototype.PE_STR_OPTS_NONE;q.PE_STR_AUTH_NONE=e._pe.PeDefs.prototype.PE_STR_AUTH_NONE;q.PE_STR_AUTH_TOP=e._pe.PeDefs.prototype.PE_STR_AUTH_TOP;q.PE_STR_NAME_CANON=e._pe.PeDefs.prototype.PE_STR_NAME_CANON;q.PE_PARM_X0=e._pe.PeDefs.prototype.PE_PARM_X0;q.PE_PARM_ND=e._pe.PeDefs.prototype.PE_PARM_ND;q.PE_TRANSFORM_1_TO_2=e._pe.PeDefs.prototype.PE_TRANSFORM_1_TO_2;
q.PE_TRANSFORM_2_TO_1=e._pe.PeDefs.prototype.PE_TRANSFORM_2_TO_1;q.PE_TRANSFORM_P_TO_G=e._pe.PeDefs.prototype.PE_TRANSFORM_P_TO_G;q.PE_TRANSFORM_G_TO_P=e._pe.PeDefs.prototype.PE_TRANSFORM_G_TO_P;q.PE_HORIZON_RECT=e._pe.PeDefs.prototype.PE_HORIZON_RECT;q.PE_HORIZON_POLY=e._pe.PeDefs.prototype.PE_HORIZON_POLY;q.PE_HORIZON_LINE=e._pe.PeDefs.prototype.PE_HORIZON_LINE;q.PE_HORIZON_DELTA=e._pe.PeDefs.prototype.PE_HORIZON_DELTA}})(f=e.PeDefs||(e.PeDefs={}));(function(q){function r(x,z){var A=null,E=u[x];
E||(E={},u[x]=E);E.hasOwnProperty(String(z))?A=E[z]:(x=e._pe.PeFactory.prototype.factoryByType(x,z),e._pe.compare(x,e._pe.NULL)||(A=x,E[z]=A));return A=w(A)}function w(x){if(x){var z=x.getType();switch(z){case f.PE_TYPE_GEOGCS:x=e._pe.castObject(x,e._pe.PeGeogcs);break;case f.PE_TYPE_PROJCS:x=e._pe.castObject(x,e._pe.PeProjcs);break;case f.PE_TYPE_GEOGTRAN:x=e._pe.castObject(x,e._pe.PeGeogtran);break;default:z&f.PE_TYPE_UNIT&&(x=e._pe.castObject(x,e._pe.PeUnit))}}return x}var u={},y={};q.initialize=
function(){e._pe.PeFactory.prototype.initialize(null)};q.coordsys=function(x){return r(f.PE_TYPE_COORDSYS,x)};q.factoryByType=r;q.fromString=function(x,z){var A=null,E=y[x];E||(E={},y[x]=E);E.hasOwnProperty(z)?A=E[z]:(x=e._pe.PeFactory.prototype.fromString(x,z),e._pe.compare(x,e._pe.NULL)||(A=x,E[z]=A));return A=w(A)};q.geogcs=function(x){return r(f.PE_TYPE_GEOGCS,x)};q.geogtran=function(x){return r(f.PE_TYPE_GEOGTRAN,x)};q.getCode=function(x){return e._pe.PeFactory.prototype.getCode(x)};q.projcs=
function(x){return r(f.PE_TYPE_PROJCS,x)};q.unit=function(x){return r(f.PE_TYPE_UNIT,x)}})(e.PeFactory||(e.PeFactory={}));e.PeGCSExtent=null;var d;(function(q){var r;q.init=function(){q.PE_GTLIST_OPTS_COMMON=e._pe.PeGTlistExtended.prototype.PE_GTLIST_OPTS_COMMON;r=e._pe._pe_getPeGTlistExtendedEntrySize()};q.getGTlist=function(w,u,y,x,z,A){var E=null,F=new e._pe.PeInteger(A);try{var B=e._pe.PeGTlistExtended.prototype.getGTlist(w,u,y,x,z,F);if(A=F.val)if(E=[B],1<A){var D=e._pe.getPointer(B);for(w=1;w<
A;w++)E.push(e._pe.wrapPointer(D+r*w,e._pe.PeGTlistExtendedEntry))}}finally{e._pe.destroy(F)}return E}})(d=e.PeGTlistExtended||(e.PeGTlistExtended={}));(function(q){q.destroy=function(r){if(r&&r.length){for(var w=0;w<r.length;w++){var u=r[w];c(u);u.getEntries().forEach(function(y){c(y);y=y.getGeogtran();c(y);y.getParameters().forEach(c);[y.getGeogcs1(),y.getGeogcs2()].forEach(function(x){c(x);var z=x.getDatum();c(z);c(z.getSpheroid());c(x.getPrimem());c(x.getUnit())})})}e._pe.PeGTlistExtendedEntry.prototype.Delete(r[0])}}})(e.PeGTlistExtendedEntry||
(e.PeGTlistExtendedEntry={}));(function(q){q.geogToGeog=function(r,w,u,y,x){e._pe.ensureCache.prepare();var z=b(u),A=u===z;z=e._pe.ensureFloat64(z);var E=0;y&&(E=e._pe.ensureFloat64(y));(r=e._pe._pe_geog_to_geog(e._pe.getPointer(r),w,z,E,x))&&l(u,w,z,A);return r}})(e.PeGTTransformations||(e.PeGTTransformations={}));(function(q){function r(u,y,x,z,A,E){e._pe.ensureCache.prepare();switch(u){case "dd":var F=e._pe._pe_geog_to_dd;var B=f.PE_DD_MAX;break;case "ddm":F=e._pe._pe_geog_to_ddm;B=f.PE_DDM_MAX;
break;case "dms":F=e._pe._pe_geog_to_dms,B=f.PE_DMS_MAX}u=0;y&&(u=e._pe.getPointer(y));y=b(z);y=e._pe.ensureFloat64(y);B=a(x,B);z=e._pe.ensureInt32(B);if(A=F(u,x,y,A,z))for(F=0;F<x;F++)E[F]=e._pe.UTF8ToString(B[F]);return A}function w(u,y,x,z,A){e._pe.ensureCache.prepare();switch(u){case "dd":var E=e._pe._pe_dd_to_geog;break;case "ddm":E=e._pe._pe_ddm_to_geog;break;case "dms":E=e._pe._pe_dms_to_geog}u=0;y&&(u=e._pe.getPointer(y));y=z.map(function(F){return e._pe.ensureString(F)});z=e._pe.ensureInt32(y);
y=e._pe.ensureFloat64(Array(2*x));(E=E(u,x,z,y))&&l(A,x,y);return E}q.geog_to_dms=function(u,y,x,z,A){return r("dms",u,y,x,z,A)};q.dms_to_geog=function(u,y,x,z){return w("dms",u,y,x,z)};q.geog_to_ddm=function(u,y,x,z,A){return r("ddm",u,y,x,z,A)};q.ddm_to_geog=function(u,y,x,z){return w("ddm",u,y,x,z)};q.geog_to_dd=function(u,y,x,z,A){return r("dd",u,y,x,z,A)};q.dd_to_geog=function(u,y,x,z){return w("dd",u,y,x,z)}})(e.PeNotationDms||(e.PeNotationDms={}));var k;(function(q){q.init=function(){q.PE_MGRS_STYLE_NEW=
e._pe.PeNotationMgrs.prototype.PE_MGRS_STYLE_NEW;q.PE_MGRS_STYLE_OLD=e._pe.PeNotationMgrs.prototype.PE_MGRS_STYLE_OLD;q.PE_MGRS_STYLE_AUTO=e._pe.PeNotationMgrs.prototype.PE_MGRS_STYLE_AUTO;q.PE_MGRS_180_ZONE_1_PLUS=e._pe.PeNotationMgrs.prototype.PE_MGRS_180_ZONE_1_PLUS;q.PE_MGRS_ADD_SPACES=e._pe.PeNotationMgrs.prototype.PE_MGRS_ADD_SPACES};q.geog_to_mgrs_extended=function(r,w,u,y,x,z,A){e._pe.ensureCache.prepare();var E=0;r&&(E=e._pe.getPointer(r));r=b(u);u=e._pe.ensureFloat64(r);r=a(w,f.PE_MGRS_MAX);
var F=e._pe.ensureInt32(r);if(y=e._pe._pe_geog_to_mgrs_extended(E,w,u,y,x,z,F))for(x=0;x<w;x++)A[x]=e._pe.UTF8ToString(r[x]);return y};q.mgrs_to_geog_extended=function(r,w,u,y,x){e._pe.ensureCache.prepare();var z=0;r&&(z=e._pe.getPointer(r));r=u.map(function(A){return e._pe.ensureString(A)});u=e._pe.ensureInt32(r);r=e._pe.ensureFloat64(Array(2*w));(y=e._pe._pe_mgrs_to_geog_extended(z,w,u,y,r))&&l(x,w,r);return y}})(k=e.PeNotationMgrs||(e.PeNotationMgrs={}));(function(q){q.geog_to_usng=function(r,
w,u,y,x,z,A){e._pe.ensureCache.prepare();var E=0;r&&(E=e._pe.getPointer(r));r=b(u);u=e._pe.ensureFloat64(r);r=a(w,f.PE_MGRS_MAX);var F=e._pe.ensureInt32(r);if(y=e._pe._pe_geog_to_usng(E,w,u,y,x,z,F))for(x=0;x<w;x++)A[x]=e._pe.UTF8ToString(r[x]);return y};q.usng_to_geog=function(r,w,u,y){e._pe.ensureCache.prepare();var x=0;r&&(x=e._pe.getPointer(r));r=u.map(function(z){return e._pe.ensureString(z)});u=e._pe.ensureInt32(r);r=e._pe.ensureFloat64(Array(2*w));(x=e._pe._pe_usng_to_geog(x,w,u,r))&&l(y,w,
r);return x}})(e.PeNotationUsng||(e.PeNotationUsng={}));var m;(function(q){q.init=function(){q.PE_UTM_OPTS_NONE=e._pe.PeNotationUtm.prototype.PE_UTM_OPTS_NONE;q.PE_UTM_OPTS_ADD_SPACES=e._pe.PeNotationUtm.prototype.PE_UTM_OPTS_ADD_SPACES;q.PE_UTM_OPTS_NS=e._pe.PeNotationUtm.prototype.PE_UTM_OPTS_NS};q.geog_to_utm=function(r,w,u,y,x){e._pe.ensureCache.prepare();var z=0;r&&(z=e._pe.getPointer(r));r=b(u);u=e._pe.ensureFloat64(r);r=a(w,f.PE_UTM_MAX);var A=e._pe.ensureInt32(r);if(y=e._pe._pe_geog_to_utm(z,
w,u,y,A))for(z=0;z<w;z++)x[z]=e._pe.UTF8ToString(r[z]);return y};q.utm_to_geog=function(r,w,u,y,x){e._pe.ensureCache.prepare();var z=0;r&&(z=e._pe.getPointer(r));r=u.map(function(A){return e._pe.ensureString(A)});u=e._pe.ensureInt32(r);r=e._pe.ensureFloat64(Array(2*w));(y=e._pe._pe_utm_to_geog(z,w,u,y,r))&&l(x,w,r);return y}})(m=e.PeNotationUtm||(e.PeNotationUtm={}));var v;(function(q){var r=new Map;q.init=function(){q.PE_PCSINFO_OPTION_NONE=e._pe.PePCSInfo.prototype.PE_PCSINFO_OPTION_NONE;q.PE_PCSINFO_OPTION_DOMAIN=
e._pe.PePCSInfo.prototype.PE_PCSINFO_OPTION_DOMAIN;q.PE_POLE_OUTSIDE_BOUNDARY=e._pe.PePCSInfo.prototype.PE_POLE_OUTSIDE_BOUNDARY;q.PE_POLE_POINT=e._pe.PePCSInfo.prototype.PE_POLE_POINT};q.generate=function(w,u){void 0===u&&(u=q.PE_PCSINFO_OPTION_DOMAIN);var y;if(r.has(w)){var x=r.get(w);x[u]&&(y=x[u])}y||(y=e._pe.PePCSInfo.prototype.generate(w,u),x||(x=[],r.set(w,x)),x[u]=y);return y}})(v=e.PePCSInfo||(e.PePCSInfo={}));(function(q){q.version_string=function(){return e._pe.PeVersion.prototype.version_string()}})(e.PeVersion||
(e.PeVersion={}));e._init=h})},"esri/core/tsSupport/extendsHelper":function(){define([],function(){return function(){var G=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])};return function(e,t){function n(){this.constructor=e}G(e,t);e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}}()})},"esri/geometry/GeographicTransformation":function(){define(["require","exports","./GeographicTransformationStep"],
function(G,e,t){return function(){function n(p){this.steps=[];this._cached_projection={};this._chain="";this._gtlistentry=null;if(p&&p.steps){var h=0;for(p=p.steps;h<p.length;h++){var c=p[h];c instanceof t?this.steps.push(c):this.steps.push(new t({wkid:c.wkid,wkt:c.wkt,isInverse:c.isInverse}))}}}n.cacheKey=function(p,h){return[void 0!==p.wkid&&null!==p.wkid?p.wkid.toString():"-1",void 0!==p.wkt&&null!==p.wkt?p.wkt.toString():"",void 0!==h.wkid&&null!==h.wkid?h.wkid.toString():"-1",void 0!==h.wkt&&
null!==h.wkt?h.wkt.toString():""].join()};n.fromGE=function(p){var h=new n,c="",a=0;for(p=p.steps;a<p.length;a++){var b=t.fromGE(p[a]);h.steps.push(b);c+=b.uid.toString()+","}h._cached_projection={};h._gtlistentry=null;h._chain=c;return h};n.prototype.getInverse=function(){var p=new n;p.steps=[];for(var h=this.steps.length-1;0<=h;h--)p.steps.push(this.steps[h].getInverse());return p};n.prototype.getGTListEntry=function(){for(var p="",h=0,c=this.steps;h<c.length;h++)p+=c[h].uid.toString()+",";p!==
this._chain&&(this._gtlistentry=null,this._cached_projection={},this._chain=p);return this._gtlistentry};n.prototype.assignCachedGe=function(p,h,c){this._cached_projection[n.cacheKey(p,h)]=c};n.prototype.getCachedGeTransformation=function(p,h){for(var c="",a=0,b=this.steps;a<b.length;a++)c+=b[a].uid.toString()+",";c!==this._chain&&(this._gtlistentry=null,this._cached_projection={},this._chain=c);p=this._cached_projection[n.cacheKey(p,h)];return void 0===p?null:p};return n}()})},"esri/geometry/GeographicTransformationStep":function(){define(["require",
"exports"],function(G,e){var t=0;return function(){function n(p){void 0===p&&(p=null);this.uid=t++;p?(this._wkt=void 0!==p.wkt?p.wkt:null,this._wkid=void 0!==p.wkid?p.wkid:-1,this._isInverse=void 0!==p.isInverse?!0===p.isInverse:!1):(this._wkt=null,this._wkid=-1,this._isInverse=!1)}n.fromGE=function(p){var h=new n;h._wkt=p.wkt;h._wkid=p.wkid;h._isInverse=p.isInverse;return h};Object.defineProperty(n.prototype,"wkt",{get:function(){return this._wkt},set:function(p){this._wkt=p;this.uid=t++},enumerable:!0,
configurable:!0});Object.defineProperty(n.prototype,"wkid",{get:function(){return this._wkid},set:function(p){this._wkid=p;this.uid=t++},enumerable:!0,configurable:!0});Object.defineProperty(n.prototype,"isInverse",{get:function(){return this._isInverse},set:function(p){this._isInverse=p;this.uid=t++},enumerable:!0,configurable:!0});n.prototype.getInverse=function(){var p=new n;p._wkt=this.wkt;p._wkid=this._wkid;p._isInverse=!this.isInverse;return p};return n}()})},"esri/layers/rasterLib/raster/TileServiceRaster":function(){define("require dojo/_base/declare dojo/_base/lang dojo/_base/Deferred dojo/_base/array dojo/_base/config dojo/_base/json dojo/sniff dojo/DeferredList dojo/when ../../../kernel ../../../Evented ../../../request ../../../geometry/Extent ../../../geometry/Point ../../../SpatialReference ../../../deferredUtils ../../../urlUtils ../../PixelBlock ../../rasterFormats/rasterCodec ../tile/RasterTileInfo ./RasterInfo ./BasicRaster".split(" "),
function(G,e,t,n,p,h,c,a,b,l,g,f,d,k,m,v,q,r,w,u,y,x,z){G=e([z],{declaredClass:"esri.layers.rasterLib.raster.TileServiceRaster",constructor:function(A){},open:function(){var A=new n,E=this.serviceInfo||this._getServiceInfo(null),F=t.hitch(this,function(D){this.serviceInfo=D;this.version=D.currentVersion;this.rasterInfo=this._parseRasterInfo(D);this.loaded=!0;this._getRasterIdentifier();A.resolve(this)}),B=t.hitch(this,function(D){this.loaded=!0;this._getRasterIdentifier();A.reject(D)});l(E,F,B);return A.promise},
read:function(A){var E=this.url+"/tile/"+A.level+"/"+A.row+"/"+A.col,F={width:this.tileInfo.cols,height:this.tileInfo.rows,planes:null,pixelType:null,format:null,decodeFunc:null,isPoint:"elevation"===this.tileType.toLowerCase()?!0:!1};return this._requestPixels({url:E+(this.disableClientCaching?"?_ts\x3d "+(new Date).getTime():""),payload:{},decodeParams:F,tileOptions:A})},identify:function(A,E){null==E&&(E=this.tileInfo.lods[this.tileInfo.lods.length-1].level);var F=(A.x-this.tileInfo.origin.x)/
this.tileInfo.lods[E].resolution/this.tileInfo.cols;A=(this.tileInfo.origin.y-A.y)/this.tileInfo.lods[E].resolution/this.tileInfo.rows;var B=Math.floor(F),D=Math.floor(A),I=Math.floor((F-B)*this.tileInfo.cols);I=Math.min(I,this.tileInfo.cols-1);var M=Math.floor((A-D)*this.tileInfo.rows);M=Math.min(M,this.tileInfo.rows-1);var N=new n;this.read({level:E,row:D,col:B}).then(function(Q){var V=M*Q.width+I;Q&&Q.pixels&&0<Q.pixels.length?(Q=Q.mask?Q.mask[V]?Q.pixels.map(function(X){return X[V]}):null:Q.pixels.map(function(X){return X[V]}),
N.resolve(Q)):N.reject("no valid data")},function(Q){N.reject(Q)});return N.promise},setFetchParameters:function(A,E){},_getRasterIdentifier:function(){this._rasterId||(this._rasterId=this.url.replace("http:","").replace("https:",""));return this._rasterId},_getServiceInfo:function(){var A=this.url,E=new n(q._dfdCanceller);E._pendingDfd=d({url:A,content:{f:"json"},handleAs:"json",callbackParamName:"callback"});E._pendingDfd.then(function(F){E.callback(F)},function(F){E.errback(F)});return E},_parseRasterInfo:function(A){var E=
new x;E.extent=new k(A.fullExtent);E.spatialReference=new v(A.spatialReference);this.tileType=A.cacheType||"Map";switch(this.tileType){case "Map":E.bandCount=3;E.pixelType="U8";this.dataType="Processed";break;case "Elevation":E.bandCount=1;E.pixelType=A.pixelType||"F32";this.dataType="Elevation";break;case "Raster":E.bandCount=null,E.pixelType=null,this.dataType=A.serviceDataType&&A.serviceDataType.replace("esriImageServiceDataType","")||"Generic"}var F=A.tileInfo;E.width=Math.floor((A.fullExtent.xmax-
A.fullExtent.xmin)/F.lods[F.lods.length-1].resolution+.5);E.height=Math.floor((A.fullExtent.ymax-A.fullExtent.ymin)/F.lods[F.lods.length-1].resolution+.5);E.cellSize=new m({x:F.lods[F.lods.length-1].resolution,y:F.lods[F.lods.length-1].resolution,spatialReference:A.spatialReference});this.tileInfo=new y(F);this.tileInfo.tileType=this.tileType;return E}});a("extend-esri")&&t.setObject("layers.rasterLib.raster.TileServiceRaster",G,g);return G})},"esri/layers/rasterLib/raster/TileRaster":function(){define("require dojo/_base/declare dojo/_base/lang dojo/_base/Deferred dojo/_base/array dojo/_base/config dojo/_base/json dojo/sniff dojo/DeferredList dojo/when ../../../kernel ../../../Evented ../../../request ../../../geometry/Extent ../../../geometry/Point ../../../SpatialReference ../../../deferredUtils ../../../urlUtils ../../PixelBlock ../../rasterFormats/rasterCodec ../tile/RasterTileInfo ./RasterInfo ./BasicRaster".split(" "),
function(G,e,t,n,p,h,c,a,b,l,g,f,d,k,m,v,q,r,w,u,y,x,z){G=e([z],{declaredClass:"esri.layers.rasterLib.raster.TileRaster",sourceType:"TileCache",_RECORD_SIZE:8,constructor:function(A){this._cloudBlobStorage=A&&A._cloudBlobStorage},open:function(){var A=new n,E=this.datasetInfo||this._getDatasetInfo(null),F=t.hitch(this,function(D){this.datasetInfo=D;this.rasterInfo=D=this._parseRasterInfo(D);this.tileType="Cache/LERC"===D.format?"Elevation":"Cache/MIXED"===D.format||"Cache/JPEG"===D.format||"Cache/PNG"===
D.format?"Map":"Raster";this.tileInfo=D.tileInfo;this.dataType=["Generic","Elevation","Processed"][["Raster","Elevation","Map"].indexOf(this.tileType)];this._HEADER_SIZE=D.packetSize*D.packetSize*this._RECORD_SIZE+64;this.loaded=!0;this._cloudBlobStorage=this._cloudBlobStorage||-1<this.url.toLowerCase().indexOf("s3.amazonaws.com")||-1<this.url.toLowerCase().indexOf("windows.net")||-1<this.url.toLowerCase().indexOf("googleapis.com");this._getRasterIdentifier();A.resolve(this)}),B=t.hitch(this,function(D){this.loaded=
!0;this._getRasterIdentifier();A.reject(D)});l(E,F,B);return A.promise},read:function(A){var E=new n,F=A.level,B=A.row,D=A.col,I=this._buildCacheFilePath(this.url,F,B,D),M=this._getIndexRecordFromBundle(F,B,D);d({url:I,content:{},headers:{Range:"bytes\x3d0-"+(this._HEADER_SIZE-1).toString()},handleAs:"arraybuffer"}).then(t.hitch(this,function(N,Q){if(!E.isCanceled()){console.log("time in ms request "+(new Date-V));var V=new Date;N=new Uint8Array(N);N=this._getTileEndAndContentType(N,M);Q={width:this.tileInfo.cols,
height:this.tileInfo.rows,planes:null,pixelType:null,format:null,decodeFunc:null,isPoint:"elevation"===this.tileType.toLowerCase()?!0:!1};this._requestPixels({url:I+(this.disableClientCaching?"?_ts\x3d "+(new Date).getTime():""),payload:{},headers:{Range:"bytes\x3d"+N.position.toString()+"-"+(N.position+N.recordSize).toString()},decodeParams:Q,tileOptions:A}).then(function(X){E.isCanceled()||E.resolve(X)},function(X){E.isCanceled()||E.reject(X)})}}));return E.promise},identify:function(){return null},
setFetchParameters:function(A,E){},toJson:function(){return{url:this.url,tileInfo:this.tileInfo.toJson(),rasterInfo:this.rasterInfo.toJson(),datasetInfo:this.datasetInfo,sourceType:this.sourceType,tileType:this.tileType,_rasterId:this._rasterId}},_getDatasetInfo:function(){return d({url:this.url+"/conf.json",handleAs:"json",content:{}})},_parseRasterInfo:function(A){var E=new x;switch(A.pixelType){case 1:var F="U1";break;case 1:F="U2";break;case 2:F="U4";break;case 3:F="U8";break;case 4:F="S8";break;
case 5:F="U16";break;case 6:F="S16";break;case 7:F="U32";break;case 8:F="S32";break;case 9:F="F32";break;default:F="F32"}var B,D=[],I=A.LODInfos;for(B=0;B<I.levels.length;B++)D.push({level:I.levels[B],resolution:I.resolutions[B],scale:96/.0254*I.resolutions[B]});B=new v(A.extent.spatialReference||A.geodataXform.spatialReference);D=new y({rows:A.blockHeight,cols:A.blockWidth,dpi:96,format:A.format,compressionQuality:0,origin:A.origin,spatialReference:B,lods:D});E.pixelType=F;E.bandCount=A.bandCount;
E.spatialReference=B;E.extent=new k({xmin:A.extent.xmin,ymin:A.extent.ymin,xmax:A.extent.xmax,ymax:A.extent.ymax,spatialReference:B});E.cellSize=new m({x:A.pixelSizeX,y:A.pixelSizeY,spatialReference:B});E.width=Math.floor((E.extent.xmax-E.extent.xmin)/E.cellSize.x+.5);E.height=Math.floor((E.extent.ymax-E.extent.ymin)/E.cellSize.y+.5);E.statistics=A.statistics.map(function(M){Object.keys(M).forEach(function(N){isNaN(M[N])&&(M[N]=null)});return M});E.histograms=A.histograms;E.geodataXform=A.geodataXform;
E.packetSize=A.packetSize;E.format=A.format;E.compressionQuality=A.compressionQuality;E.tileInfo=D;return E},_getRasterIdentifier:function(){this._rasterId||(this._rasterId=this.url.replace("http:","").replace("https:",""));return this._rasterId},_buildCacheFilePath:function(A,E,F,B){var D=this.rasterInfo.packetSize;B=Math.floor(B/D)*D;F="R"+this._toHexString4(Math.floor(F/D)*D)+"C"+this._toHexString4(B);D="L";D=10<=E?D+E.toString():D+("0"+E.toString());return this._cloudBlobStorage?A+"/_alllayers/"+
D+"/"+F+".bundle":A+"/"+D+"_"+F+"/bundle"},_getIndexRecordFromBundle:function(A,E,F){A=this.rasterInfo.packetSize;E=E%A*A+F%A;if(0>E)throw"Invalid level / row / col";return E*this._RECORD_SIZE+64},_getTileEndAndContentType:function(A,E){A=A.subarray(E,E+8);E=0;var F;for(F=0;5>F;F++)E|=(A[F]&255)<<8*F;var B=E&0xffffffffff;E=0;for(F=5;8>F;F++)E|=(A[F]&255)<<8*(F-5);return{position:B,recordSize:E&0xffffffffff}},_toHexString4:function(A){A=A.toString(16);if(4!=A.length)for(var E=4-A.length;0<E--;)A="0"+
A;return A}});a("extend-esri")&&t.setObject("layers.rasterLib.raster.TileRaster",G,g);return G})},"esri/layers/rasterLib/raster/FunctionRaster":function(){define("require dojo/_base/declare dojo/_base/lang dojo/_base/Deferred dojo/_base/array dojo/_base/config dojo/_base/json dojo/sniff ../DeferredList2 dojo/when ../../../kernel ../../../Evented ../../../request ../../../deferredUtils ../../../geometry/Extent ../../../geometry/Point ../../../SpatialReference ../../../deferredUtils ../../../urlUtils ../../rasterFormats/rasterCodec ./RasterInfo ./BasicRaster ../../rasterLib/function/rasterFunctionHelper".split(" "),
function(G,e,t,n,p,h,c,a,b,l,g,f,d,k,m,v,q,r,w,u,y,x,z){G=e([x],{declaredClass:"esri.layers.rasterLib.raster.FunctionRaster",rasterFunction:null,sourceType:"Function",constructor:function(A){A&&A.rasterFx&&this._init(A.rasterFx,A.rasterFxArgs)},open:function(){var A=this.getMemberRasters().map(function(F){return F.open()});this.identifiers=this.getMemberRasters().map(function(F){return F._rasterId});var E=new n;(new b(A,null,null,!0)).then(function(F){F.some(function(B){return!B[0]})?E.reject(F):
(this.rasterFunction.bind(),this.rasterInfo=this.rasterFunction.rasterInfo,this.dataType=this.rasterInfo.keyProperties&&this.rasterInfo.keyProperties.DataType||"Generic",this.tileInfo=F[0][1].tileInfo,E.resolve(this))}.bind(this));return E.promise},getProjectedFullExtent:function(A){var E=new n;this.getMemberRasters()[0].getProjectedFullExtent(A).then(t.hitch(this,function(F){this.projectedFullExtent=F;E.resolve(F)}));return E.promise},setProcessingContext:function(A){var E=A;A.layer&&(A=A.layer,
E={id:A.id,rawRasterInfo:A.raster.rasterInfo,glSetting:A._glSetting,xformSetting:A.tileManager&&A.tileManager.xformSetting,useWebGL:A.useWebGL,resampling:A.tileMode&&A.tileManager&&A.tileManager.xformSetting.requireProjection&&!A._hasTilingEffects&&"Thematic"!==A.raster.dataType?1:0,tileMode:A.tileMode});this.rasterFunction.setProcessingContext(E);this._layerOptions=E},alterDefinition:function(A){if(A=A||this.rasterFunction)1===this.memberRasters.length&&!A._bindComplete&&(this.rasterFunction=z.create(A,
{raster:this.memberRasters[0]}))&&(this.rasterFunction.bind(),this.rasterInfo=this.rasterFunction.rasterInfo,this.dataType=this.rasterInfo.keyProperties&&this.rasterInfo.keyProperties.DataType||"Generic",this.rasterFunction.setProcessingContext(this._layerOptions)),this._rasterHandler&&this._rasterHandler._connected&&this.rasterFunction&&this._rasterHandler.setRasterFunction({layerId:this._layerOptions.id,data:this.rasterFunction.toJson(!0)})},setFetchParameters:function(A,E){var F=this.getMemberRasters();
F&&1===F.length&&F[0].setFetchParameters(A,E)},getMemberRasters:function(){this.memberRasters||(this.memberRasters=[],this._getMemberRasters(this.rasterFunction.functionArguments,this.memberRasters));return this.memberRasters},read:function(A){var E=new n(k._dfdCanceller);if(A.src){var F=this.rasterFunction.read(A);E.resolve(F);return E.promise}var B=this.getMemberRasters().map(function(N){return N.read(A)});B=new b(B);var D,I,M=this.identifiers;E._pendingDfd=B;B.then(t.hitch(this,function(N){if(D=
N.some(function(Q){return Q[0]}))I={},N.forEach(function(Q,V){I[M[V]]=Q[0]?Q[1]:null});F=I?this.rasterFunction.read({extent:A.extent,src:I}):null;F.srcData=I;E.resolve(F)}));return E},_init:function(A,E){if(this.rasterFunction=z.create(A,E))this.rasterFunction._bindComplete=!0;else throw"Cannot initialize a function raster without a raster function";},_getMemberRasters:function(A,E){var F=Object.keys(A),B,D,I;for(B=0;B<F.length;B++)if(I=A[F[B]]){var M=I instanceof Array?I:[I];for(D=0;D<M.length;D++)(I=
M[D])&&("function"===typeof I||"object"===typeof I)&&I.read&&(I.functionArguments?this._getMemberRasters(I.functionArguments,E):I.sourceType&&"Function"!==I.sourceType&&(I._identifier=I._getRasterIdentifier(),E.some(function(N){return N._identifier===I._identifier})||E.push(I)))}return E}});a("extend-esri")&&t.setObject("layers.rasterLib.raster.FunctionRaster",G,g);return G})},"esri/layers/rasterLib/DeferredList2":function(){define(["dojo/DeferredList"],function(G){return function(e,t,n,p,h){this.list=
e;t=new G(e,t,n,p,h);var c=t.resolve.bind(t),a=t.cancel.bind(t);t.cancel=function(){e&&e.forEach(function(b){b.cancel&&b.cancel()});a.apply(this,arguments)}.bind(t);t.resolve=function(){this.isFulfilled()||c.apply(this,arguments)}.bind(t);return t}})},"esri/layers/rasterLib/tile/RasterTileManager":function(){define("dojo/_base/declare dojo/_base/lang dojo/Deferred dojo/when ../DeferredList2 ../../../geometry/Extent ../../../SpatialReference ../../../geometry/Point ../../PixelBlock ./RasterTileInfo ../raster/rasterProjectionHelper".split(" "),
function(G,e,t,n,p,h,c,a,b,l,g){var f=function(d,k){var m;for(m=0;m<d.length;m++)if(k(d[m]))return m;return-1};return G(null,{declaredClass:"esri.layers.rasterLib.tile.RasterTileManager",count:null,fullBoundary:null,tileBoundary:null,tiles:null,resolution:null,virtual:!0,prefetchBufferSize:0,_progressiveGlobal:!1,_MAX_TILES:128,_defaultMatrixResolution:20,constructor:function(d){this.tiles=[];this.xformSetting={};this.mapSpatialReference=d&&d.mapSR;this.layer=d&&d.layer;this.identifiers=this.layer.raster.rasterFunction?
this.layer.raster.getMemberRasters().map(function(k){return k._rasterId}):[this.layer.raster._rasterId];(d=d&&d.tileInfo)&&this.setTileInfo(d)},setTileInfo:function(d){this.tileInfo=d;this.virtual=d.virtual;this.mapResolution=null;this.tiles.length=0;this.xformSetting.requireProjection=!this.virtual&&!this.mapSpatialReference.equals(this.tileInfo.spatialReference);this.xformSetting.requirePE=g.requirePE(this.mapSpatialReference,this.tileInfo.spatialReference);this.xformSetting.meshSize=this.xformSetting.requireProjection?
[this._defaultMatrixResolution,this._defaultMatrixResolution]:[1,1];this.halfWorldWidth=g.getHalfWorldWidth(d.spatialReference)},updateResolution:function(d,k){if(!(this.mapResolution&&d&&this._resolutionEqual(this.mapResolution.x,d.x)&&this._resolutionEqual(this.mapResolution.y,d.y))){this.resetTiles();var m=this.xformSetting.requireProjection;this.mapResolution=this.resolution=d;m&&(this.resolution=g.projectResolution(d,this.tileInfo.spatialReference,this.layer.projectedFullExtent||k));this._resolution=
this.resolution;d=this.resolution;if(!this.tileInfo.virtual){m=.75*Math.min(d.x,d.y)+.25*Math.max(d.x,d.y);if(m>=this.tileInfo.lods[0].resolution){var v=this.tileInfo.lods[0];this.ooe=!0}else{if(m<=this.tileInfo.lods[this.tileInfo.lods.length-1].resolution)v=this.tileInfo.lods[this.tileInfo.lods.length-1];else for(d=0;d<this.tileInfo.lods.length-1;d++)if(v=this.tileInfo.lods[d],k=this.tileInfo.lods[d+1],v.resolution>=m&&k.resolution<=m){v.resolution-m>m-k.resolution&&(v=k);break}this.ooe=!1}this.level=
v&&v.level;d=this.resolution=new a({x:v.resolution,y:v.resolution,spatialReference:this.tileInfo.spatialReference})}m=this.layer.raster.rasterInfo.extent;v=this.tileInfo.origin;k=this.tileInfo.cols;var q=this.tileInfo.rows;this.fullBoundary={rowStart:Math.floor((v.y-m.ymax)/d.y/q),rowEnd:Math.floor((v.y-m.ymin-d.y)/d.y/q),colStart:Math.floor((m.xmin-v.x)/d.x/k),colEnd:Math.floor((m.xmax-v.x-d.x)/d.x/k)};if(m=this.halfWorldWidth){q=Math.ceil(m/d.x/(k/2));var r=this.tileInfo.applyGCS360Transform?360:
m,w=Math.round(k-(r-v.x)/d.x%k);w===k&&(w=0);this.fullBoundary.colRange=q;this.fullBoundary.paddingRight=w;this.fullBoundary.paddingLeft=Math.round((q*k*d.x+v.x-r-(this.tileInfo.applyGCS360Transform?0:v.x+m))/d.x)}this.hasNewData=!0}},getXformGrid:function(){var d=this.mapExtent,k=this.layer._hasTilingEffects?this.extent:this.fullExtent,m=this.layer.getCurrentResolution(),v=JSON.stringify(d.toJson())+JSON.stringify(k.toJson());this._datumTransformationInitialized||(this._datumTransformationInitialized=
!0,this._datumTransformation=g.getDefaultDatumTransformationForDataset(this.layer.raster.rasterInfo.extent,d.spatialReference,!0));this._cachedExtentString&&this._cachedExtentString===v||(this._cachedExtentString=v,this._xformGrid=d=g.getProjectionOffsetGrid(d,k,m,this.tileInfo.applyGCS360Transform,this.halfWorldWidth,this._datumTransformation));d=this._xformGrid;this.xformSetting.meshSize=d&&d.size;return d},getWrapTimes:function(d){var k=g.getHalfWorldWidth(d.spatialReference);if(!k)return 0;var m=
2*k;k=this.tileInfo.applyGCS360Transform?0:-k;return Math.floor((d.xmax-k)/m)-Math.floor((d.xmin-k)/m)},normalizeCoordinate:function(d,k){if(!k)return 0;var m=2*k;if(0<d){for(;d>k;)d-=m;return d}for(;d<-k;)d+=m;return d},resetTiles:function(){this.tiles.forEach(e.hitch(this,function(d){d.fetch&&!d.fetch.isCanceled()&&d.fetch.cancel();d.update&&!d.update.isCanceled()&&d.update.cancel()}));this.tiles.length=0},updateExtent:function(d,k){this.mapExtent=this.extent=d;var m=this.xformSetting.requireProjection;
if(m){this.extent=g.project(d,this.tileInfo.spatialReference,this.tileInfo.applyGCS360Transform);if(!this.extent)return;this.extent.spatialReference=new c(this.extent.spatialReference.toJson())}this.updateResolution(k,d);var v=this.extent,q=this.tileInfo,r=q.cols,w=q.rows;k=this.resolution;var u=v;m=m?this.layer.raster.rasterInfo.extent:this.layer.raster.projectedFullExtent;this.ooe&&(u=this._getIntersect(v,m));var y=Math.floor((u.xmin-q.origin.x)/k.x/r)-this.prefetchBufferSize,x=Math.floor((u.xmax-
q.origin.x)/k.x/r)+this.prefetchBufferSize,z=null;d=this.getWrapTimes(d);var A=this.fullBoundary&&this.fullBoundary.colRange;d&&this.halfWorldWidth&&(x===y&&(z=y),x+=d*A);var E=this.halfWorldWidth&&this.tiles.length&&(d!==this.wrapTimes||z!==this._circlularColId);E&&(this._wrapSwitchCount=this._wrapSwitchCount?this._wrapSwitchCount+1:1);this.wrapTimes=d;this._circlularColId=z;var F=Math.floor((q.origin.y-u.ymax)/k.y/w)-this.prefetchBufferSize;z=Math.floor((q.origin.y-u.ymin)/k.y/w)+this.prefetchBufferSize;
this.tileBoundary={rowStart:F,rowEnd:z,colStart:y,colEnd:x};var B,D;((u=(z-F+1)*(x-y+1)>this._MAX_TILES||!this.virtual&&this._resolution.x>8*this.tileInfo.lods[0].resolution)||2<d||E)&&this.resetTiles();if(!(u||2<d)){E=this.tiles;u=!1;for(B=E.length-1;0<=B;B--){var I=E[B].row;var M=E[B].wrapCol;if(I<F||I>z||M<y||M>x)E[B].fetch&&!E[B].fetch.isCanceled()&&E[B].fetch.cancel(),E[B].update&&!E[B].update.isCanceled()&&E[B].update.cancel(),E.splice(B,1),u=!0}for(B=F;B<=z;B++)for(D=y;D<=x;D++){F=new h(q.origin.x+
k.x*r*D,q.origin.y-k.y*w*(B+1),q.origin.x+k.x*r*(D+1),q.origin.y-k.y*w*B,v.spatialReference);var N=d&&A?0<=D?D%A:A- -D%A:D;I=f(E,function(Q){return Q.row===B&&Q.col===N&&Q.wrapCol===D});M=m.xmax>=F.xmax?r:Math.round((m.xmax-F.xmin)/k.x);-1===I&&(E.push({row:B,col:N,wrapCol:D,cellsizeX:k.x,cellsizeY:k.y,width:r,height:w,actualWidth:M,extent:F,normalizedExtent:this._wrapExtent(F,N),pixelBlock:null,virtual:this.virtual,level:this.level,tileType:this.tileInfo.tileType||"Raster"}),u=!0)}u&&this._sortTiles();
k=this.tileInfo.rows*(this.tileBoundary.rowEnd-this.tileBoundary.rowStart+1);this.width=this.tileInfo.cols*(this.tileBoundary.colEnd-this.tileBoundary.colStart+1);this.height=k;this.count=E.length;k=Math.min.apply(null,E.map(function(Q){return Q.extent.xmin}));q=Math.max.apply(null,E.map(function(Q){return Q.extent.xmax}));r=Math.min.apply(null,E.map(function(Q){return Q.extent.ymin}));w=Math.max.apply(null,E.map(function(Q){return Q.extent.ymax}));k=this.fullExtent=new h(k,r,q,w,v.spatialReference);
if(this.layer.roaming||this.layer.useWebGL)this.layer._hasTilingEffects?(this.xformSetting.offset=[0,0],this.xformSetting.scale=[1,1]):(u&&(this._tilesChanged=!0),this.xformSetting.offset=[(v.xmin-k.xmin)/(k.xmax-k.xmin),-(k.ymin-v.ymin)/(k.ymax-k.ymin)],this.xformSetting.scale=[(v.xmax-v.xmin)/(k.xmax-k.xmin),(v.ymax-v.ymin)/(k.ymax-k.ymin)])}},fetchTiles:function(d){(this._tilesChanged||d)&&this._fetchTiles(d)},_fetchTiles:function(d){this._fetchCounter=0;var k=this.extent;this.fetchAllCompleted=
d?new t:null;(this._tilesChanged||d&&this.layer._hasTilingEffects)&&this.tiles.forEach(e.hitch(this,function(v){v.updateCompleted=!1}));var m={};!this.layer.roaming&&this.layer._hasTilingEffects&&d?(this.identifiers.forEach(function(v,q){m[v]={extent:this.extent,pixelBlock:new b({width:this.layer._map.width,height:this.layer._map.height,pixels:[],pixelType:"",mask:null,statistics:[]})}}.bind(this)),this.originalPixelData={extent:this.extent,src:m,isEmpty:!0}):this._tilesChanged&&(this.identifiers.forEach(function(v,
q){m[v]={extent:this.fullExtent,pixelBlock:new b({width:128,height:128,pixels:[],pixelType:"",mask:null,statistics:[]})}}.bind(this)),this.originalPixelData={extent:this.fullExtent,src:m,isEmpty:!0});this.tiles.forEach(e.hitch(this,function(v){if(v.fetch)v.update||(v.update=this.updateTile(v));else{if(this._isTileOutSide(v,k)){v.updateCompleted=!0;return}this._requestTile(v)}this.layer.roaming&&this.layer.useWebGL?this._fillPixelData(v):v.src&&d&&(this.layer._hasTilingEffects||this.layer.useWebGL)&&
(this._fillPixelData(v),this.layer._hasTilingEffects&&(v.updateCompleted=!0),v.processedPixelBlock=null,v.renderedPixelBlock=null)}));0===this._fetchCounter&&(this._fetched=!0);this._tilesChanged=!1;d&&this._updateFetchStatus()},updateTile:function(d,k){var m=new t;if(!d.src&&!d.fetch)return m.resolve(d),m.promise;n(d.src||d._fetched||d.fetch,e.hitch(this,function(){var v=this.layer.tileMode&&this.layer._rasterHandler&&!(this.layer._hasTilingEffects||this.layer.useWebGL),q=this.layer._drawTile,r=
this._validateRawPixelBlocks(d);this.layer._hasTilingEffects&&!this.layer.useWebGL&&(q=q&&(this._progressiveGlobal||k));if((k||!k&&r)&&(v||q||this.layer.roaming)){if(this.xformSetting.requireProjection&&this.layer.useWebGL&&(this.xformSetting.gridConfig=this.getXformGrid(),null==this.xformSetting.gridConfig))return m.cancel(),m.promise;this._processTile(d,k).then(e.hitch(this,function(w){m.isCanceled()||this._renderTile(w,k).then(e.hitch(this,function(u){this.hasNewData=!1;m.isCanceled()||m.resolve(u)}))}))}else k||
r||(d.updateCompleted=!0),this.layer.useWebGL||this.layer._hasTilingEffects?m.resolve(this.originalPixelData):m.resolve()}));return m.promise},setLayer:function(d){this.layer=d},fillupTiles:function(){this.tiles.forEach(e.hitch(this,function(d){d.update&&d.updateCompleted&&!d.filled&&(d.updateCompleted=!1,this._fillPixelData(d),d.updateCompleted=!0)}))},_validateRawPixelBlocks:function(d){return d&&d.src&&!this.identifiers.some(function(k){return!(d.src[k].pixelBlock&&0!==d.src[k].pixelBlock.validPixelCount&&
d.src[k].pixelBlock.pixels&&0<d.src[k].pixelBlock.pixels.length)})},_wrapExtent:function(d,k){if(d){if(this.tileInfo.applyGCS360Transform){var m=this.normalizeCoordinate(d.xmin,180);0>m&&(m+=360);return new h({xmin:m,ymin:d.ymin,xmax:d.xmax-d.xmin+m,ymax:d.ymax,spatialReference:d.spatialReference})}if(this.halfWorldWidth){m=null!=k?new h({xmin:this.tileInfo.origin.x+this.tileInfo.cols*k*this.resolution.x,ymin:d.ymin,xmax:this.tileInfo.origin.x+this.tileInfo.cols*(k+1)*this.resolution.x,ymax:d.ymax,
spatialReference:d.spatialReference}):new h({xmin:d.xmin,ymin:d.ymin,xmax:d.xmax,ymax:d.ymax,spatialReference:d.spatialReference});k=this.normalizeCoordinate(m.xmin,this.halfWorldWidth);var v=k-m.xmin;.01<Math.abs(v)&&(m.xmin=k,m.xmax+=v)}return m||d}},_getIntersect:function(d,k){return new h(Math.max(d.xmin,k.xmin),Math.max(d.ymin,k.ymin),Math.min(d.xmax,k.xmax),Math.min(d.ymax,k.ymax),d.spatialReference)},_isTileOutSide:function(d,k){var m=!1;if(d.virtual){var v=d.normalizedExtent;if(k=k||(this.xformSetting.requireProjection?
this.layer.raster.rasterInfo.extent:this.layer.raster.projectedFullExtent)){d=v.xmin-this.prefetchBufferSize*this.tileInfo.cols*this.resolution.x;m=v.ymin-this.prefetchBufferSize*this.tileInfo.rows*this.resolution.y;var q=v.xmax+this.prefetchBufferSize*this.tileInfo.cols*this.resolution.x;v=v.ymax+this.prefetchBufferSize*this.tileInfo.rows*this.resolution.y;m=q<=k.xmin||d>=k.xmax||v<=k.ymin||m>=k.ymax}else m=!1}else m=0>d.level||d.row<this.fullBoundary.rowStart||d.row>this.fullBoundary.rowEnd||d.col<
this.fullBoundary.colStart||d.col>this.fullBoundary.colEnd;return m},_resolutionEqual:function(d,k){return d===k||d&&k&&Math.abs(d-k)<Math.abs(k/1E4)?!0:!1},_requestTile:function(d){var k=this.identifiers,m;if(this._isTileOutSide(d)){var v=new t;d.updateCompleted=!0;v.resolve(null);v=v.promise}else v=this.layer.raster.rasterFunction?new p(this.layer.raster.getMemberRasters().map(function(q){return q.read(d)})):new p([this.layer.raster.read(d)]);d.fetch=v;this._fetchCounter++;n(d.src||d._fetched||
v,e.hitch(this,function(q){if(m=q&&q.some(function(w){return w[0]})){var r={};q.forEach(function(w,u){r[k[u]]=w[0]&&w[1]?{extent:w[1].extent,pixelBlock:w[1].pixelBlock,width:w[1].width,height:w[1].height}:null});d.src=r}else d.src=null;this._fetchCounter--;0===this._fetchCounter&&(this._fetched=!0);d._fetched=!0;this._updateFetchStatus()}),e.hitch(this,function(){this._fetchCounter--;0===this._fetchCounter&&(this._fetched=!0);d._fetched=!0;this._updateFetchStatus()}));d.update=this.updateTile(d)},
_updateFetchStatus:function(){this.layer._drawTile&&this.fetchAllCompleted&&!this.fetchAllCompleted.isResolved()&&!this.tiles.some(function(d){return!d._fetched})&&(this.tiles.forEach(e.hitch(this,function(d){this._fillPixelData(d)})),this.fetchAllCompleted.resolve())},_fillPixelData:function(d,k){if(d&&!d.updateCompleted)if(Math.abs(d.cellsizeX-this.resolution.x)>d.cellsizeX/10)d.updateCompleted=!0;else if(!1===this._validateRawPixelBlocks(d))d.updateCompleted=!0;else{var m=d.extent;if(this.layer.roaming||
this.layer.useWebGL&&!this.layer._hasTilingEffects){var v=this.fullExtent;var q=this.tileInfo.cols*(this.tileBoundary.colEnd-this.tileBoundary.colStart+1);var r=this.tileInfo.rows*(this.tileBoundary.rowEnd-this.tileBoundary.rowStart+1);k?this.originalPixelData.renderedPixelBlock||(this.originalPixelData.renderedPixelBlock=new b({width:q,height:r,pixels:[],pixelType:"",mask:null,statistics:[]})):this.identifiers.forEach(e.hitch(this,function(u){this.originalPixelData.src[u].pixelBlock.width=q;this.originalPixelData.src[u].pixelBlock.height=
r}))}else v=this.extent,q=this.layer._map.width,r=this.layer._map.height,k?this.originalPixelData.renderedPixelBlock||(this.originalPixelData.renderedPixelBlock=new b({width:q,height:r,pixels:[],pixelType:"",mask:null,statistics:[]})):this.identifiers.forEach(e.hitch(this,function(u){this.originalPixelData.src[u].pixelBlock.width=q;this.originalPixelData.src[u].pixelBlock.height=r}));if(v.xmax<=m.xmin||v.xmin>=m.xmax||v.ymax<=m.ymin||v.ymin>=m.ymax)return null;var w=this.originalPixelData.isEmpty=
!1;this.identifiers.forEach(e.hitch(this,function(u){d.src&&(this._fillPixelBlock(d.src[u],this.originalPixelData.src[u],{extent:v,width:q,height:r,normalizedExtent:d.normalizedExtent},!1),w=!0)}));d.filled=w;this.hasNewData=!0}},_fillPixelBlock:function(d,k,m,v){var q=d.extent,r=m.extent;v=m.width;var w=m.height;if(d.pixelBlock&&d.pixelBlock.pixels&&d.pixelBlock.pixels[0]){var u=(q.xmax-q.xmin)/d.width,y=Math.max(q.xmin,r.xmin),x=Math.min(q.ymax,r.ymax),z=Math.round((y-q.xmin)/u),A=d.width-Math.round(Math.abs(q.xmax-
Math.min(q.xmax,r.xmax))/u),E=Math.round(Math.abs(q.ymax-x)/u),F=d.height-Math.round((Math.max(q.ymin,r.ymin)-q.ymin)/u),B=this.halfWorldWidth;y=Math.round((y-r.xmin)/u);m=m.normalizedExtent;if(!(this.wrapTimes&&B&&q.xmin<-B)){if(this.wrapTimes&&B){if(this.tileInfo.applyGCS360Transform)360<q.xmin&&(y-=this.fullBoundary.paddingLeft);else if(q.xmin>B){y-=this.fullBoundary.paddingLeft;var D=this.normalizeCoordinate(q.xmin,B);var I=this.normalizeCoordinate(q.xmax,B)}else D=q.xmin,I=q.xmax;this.tileInfo.applyGCS360Transform?
m&&360>m.xmin&&360<m.xmax&&(A-=this.fullBoundary.paddingRight):m&&m.xmin<B&&m.xmax>B?A-=this.fullBoundary.paddingRight:D<B&&I>B&&(A-=this.fullBoundary.paddingRight)}D=Math.round(Math.abs(r.ymax-x)/u);I=d.pixelBlock.pixels.length;k=k.pixelBlock;m=d.width;q=k.mask||new Uint8Array(v*w);var M=d.pixelBlock,N=M.mask,Q=0;for(u=0;u<I;u++){x=M.pixels[u];B=k.pixels[u]||new x.constructor(v*w);for(d=E;d<F;d++)for(Q=(D+d-E)*v+y,r=z;r<A;r++)B[Q+r-z]=x[d*m+r];k.pixels[u]=B}if(N)for(d=E;d<F;d++)for(Q=(D+d-E)*v+y,
r=z;r<A;r++)q[Q+r-z]=N[d*m+r];else for(d=E;d<F;d++)for(Q=(D+d-E)*v+y,r=z;r<A;r++)q[Q+r-z]=1;k.pixelType=k.pixelType||M.pixelType;k.mask=q;if(!(k.statistics&&0<k.statistics.length))for(k.statistics=[],d=0;d<M.statistics.length;d++)k.statistics[d]={minValue:M.statistics[d].minValue,maxValue:M.statistics[d].maxValue};else if(M.statistics&&k.statistics)for(d=0;d<k.statistics.length;d++)k.statistics[d].minValue=Math.min(M.statistics[d].minValue,k.statistics[d].minValue),k.statistics[d].maxValue=Math.max(M.statistics[d].maxValue,
k.statistics[d].maxValue)}}},_processTile:function(d,k){var m=new t,v=this.layer._hasTilingEffects,q=this.layer.useWebGL,r=v||q,w=this.layer.raster.rasterFunction&&d&&(v||q||!d.processedPixelBlock);if(k)var u=d;else this._fillPixelData(d),u=r?this.originalPixelData:d;this.xformSetting.hasNewTexture=this.hasNewData;var y;w?(this.identifiers.forEach(function(x){if(0===u.src[x].pixelBlock.pixels.length||0===u.src[x].pixelBlock.pixels[0].length)y=!0}),y?m.resolve({extent:u.extent,processedPixelBlock:u.src[this.identifiers[0]],
pixelBlock:u.src[this.identifiers[0]]}):q?(this.processedPixelData=this.layer.raster.rasterFunction.read(u),m.resolve(this.processedPixelData)):this.layer._rasterHandler?this.layer._rasterHandler.process({extent:u.extent,src:u.src}).then(function(x){v?(this.processedPixelData=x,m.resolve(this.processedPixelData)):(d.processedPixelBlock=x.pixelBlock,m.resolve(d))}):(k=this.layer.raster.rasterFunction.read(d),d.processedPixelBlock=k.pixelBlock,m.resolve(d))):r?m.resolve(u.src[this.identifiers[0]]):
(d.pixelBlock=u.src[this.identifiers[0]]&&u.src[this.identifiers[0]].pixelBlock,m.resolve(d));return m.promise},_renderTile:function(d){var k=new t,m=this.layer._hasTilingEffects,v=this.layer.useWebGL,q=Math.abs((d.extent.xmax-d.extent.xmin)/d.width-this.layer.getCurrentResolution().x)>this.resolution.x/10;q=this.layer.useWebGL&&(q||this._isTileOutSide(d,this.layer._map.extent));this.xformSetting.hasNewTexture=this.hasNewData;this.layer._rasterRenderer&&d&&(d.texture||d.src||d.pixelBlock||d.processedPixelBlock)?
(this.layer._rasterRenderer.interpolation=this.layer.interpolation,v&&!q?(this.layer.raster.rasterFunction&&this.layer.raster.rasterFunction.renderTexture||this.layer._rasterRenderer.draw(d),k.resolve(d)):this.layer._rasterHandler?this.layer._rasterHandler.render({extent:d.extent,pixelBlock:d.processedPixelBlock||d.pixelBlock}).then(function(r){m?(r.renderedPixelBlock=r.pixelBlock,k.resolve(r)):(d.renderedPixelBlock=r.pixelBlock,k.resolve(d))}.bind(this)):(d.renderedPixelBlock=this.layer._rasterRenderer.draw(d).pixelBlock,
k.resolve(d))):(d.renderedPixelBlock=d.processedPixelBlock||d.pixelBlock,k.resolve(d));return k.promise},_sortTiles:function(){this.tiles.sort(function(d,k){return d.row<k.row||d.row==k.row&&d.col<k.col?-1:1})}})})},"widgets/BasemapGallery/a11y/Widget":function(){define("dojo/_base/lang dojo/_base/html dojo/query dojo/on dojo/keys dojo/_base/array jimu/utils".split(" "),function(G,e,t,n,p,h,c){return{a11y_initGalleryNodesAttrs:function(){var a=t(".esriBasemapGalleryNode",this.domNode);a.length&&(h.forEach(a,
function(b){var l=t("a",b)[0];e.setAttr(l,"tabindex","-1");var g=t("span",b)[0];e.setAttr(b,"aria-label",g.innerHTML);e.setAttr(b,"tabindex","0");e.setAttr(b,"role","button");n(b,"keydown",G.hitch(this,function(f){f.keyCode===p.ENTER&&l.click()}))}),c.initFirstFocusNode(this.domNode,a[0]),c.initLastFocusNode(this.domNode,a[a.length-1]),this.openAtStartAysn=!0,c.isAutoFocusFirstNodeWidget(this)&&a[0].focus())}}})},"widgets/BasemapGallery/utils":function(){define("dojo/_base/lang dojo/Deferred dojo/json dojo/_base/array dojo/promise/all esri/SpatialReference jimu/portalUtils jimu/shared/basePortalUrlUtils esri/request dojo/text!./esri_tileinfo.json".split(" "),
function(G,e,t,n,p,h,c,a,b,l){function g(q){if(!q)return null;var r=q.indexOf("?");return 0===q.search(/http|\/\//)&&-1!==r?q.slice(0,r).replace(/\/*$/g,""):q}function f(q){return q?a.removeProtocol(g(q)):""}function d(q){var r=new e;c.getPortalSelfInfo(q).then(G.hitch(this,function(w){var u=w.basemapGalleryGroupQuery;!0===w.useVectorBasemaps&&w.vectorBasemapGalleryGroupQuery&&(u=w.vectorBasemapGalleryGroupQuery);m.getBasemapGalleryGroup(q,u).then(G.hitch(this,function(y){y.queryItems({start:1,num:100,
f:"json",q:c.webMapQueryStr}).then(G.hitch(this,function(x){r.resolve(x)}),G.hitch(this,function(){r.reject()}))}),G.hitch(this,function(){r.reject()}))}));return r}function k(q){return b({url:q,content:{f:"json"},handleAs:"json",callbackParamName:"callback"}).then(function(r){return r},function(){return null})}var m={},v=t.parse(l);m._loadPortalBaseMaps=function(q,r){var w=new e,u=[];d(q).then(function(y){n.forEach(y.results,function(x){var z=new e,A=f(x.thumbnailUrl);u.push(z);x.getItemData().then(function(E){m._getBasemapSpatialReference(x,
E).then(G.hitch(this,function(F){var B=E.baseMap.baseMapLayers;m.isBasemapCompatibleWithMap(F,B,r).then(G.hitch(this,function(D){D?z.resolve({layers:B,title:x.title||E.baseMap.title,thumbnailUrl:A,spatialReference:F}):z.resolve({})}))}))})});p(u).then(function(x){x=n.filter(x,function(z){return z&&z.title?!0:!1},this);w.resolve(x)})},function(y){w.reject(y)});return w};m.isBasemapCompatibleWithMap=function(q,r,w){var u=new e,y=w.spatialReference,x=w.width>w.height?w.width:w.height;if(!y||!r||0>=r.length||
!q||!y.equals(new h(+q.wkid)))return u.resolve(!1),u;0===w.getNumLevels()?"OpenStreetMap"===r[0].layerType||r[0].layerType&&-1<r[0].layerType.indexOf("BingMaps")||"WebTiledLayer"===r[0].layerType||"VectorTileLayer"===r[0].layerType||"ArcGISImageServiceVectorLayer"===r[0].layerType||"ArcGISTiledImageServiceLayer"===r[0].layerType?u.resolve(!1):u.resolve(!0):r[0].layerType&&0===r[0].layerType.indexOf("ArcGIS")&&r[0].url?k(r[0].url).then(function(z){(r[0].serviceInfoResponse=z)&&z.tileInfo?u.resolve(m.tilingSchemeCompatible(w.__tileInfo,
z.tileInfo,x)):z&&z.capabilities&&(0<=z.capabilities.indexOf("Map")||0<=z.capabilities.indexOf("Image"))?u.resolve(!0):z&&z.error&&499===z.error.code?u.resolve(!0):u.resolve(!1)}):"WMS"===r[0].layerType?u.resolve(!0):m.isNoUrlLayerMap(r)||"VectorTileLayer"===r[0].layerType?u.resolve(m.tilingSchemeCompatible(w.__tileInfo,v,x)):u.resolve(m.tilingSchemeCompatible(w.__tileInfo,r[0].tileInfo,x));return u};m.tilingSchemeCompatible=function(q,r,w){if(q&&r){var u=!1,y=!1,x,z;for(x=0;x<q.lods.length;x++){var A=
q.lods[x].scale;q.dpi!==r.dpi&&(A=q.lods[x].scale/q.dpi);for(z=0;z<r.lods.length;z++){var E=r.lods[z].scale;q.dpi!==r.dpi&&(E=r.lods[z].scale/r.dpi);if(Math.abs(E-A)/E<1/w)if(u){y=!0;break}else u=!0;if(E<A)break}if(y)break}q=y?!0:!u||1!==q.lods.length&&1!==r.lods.length?!1:!0;return q}return!0};m.isSameBasemapLayer=function(q,r){if(q.layerType&&r.layerType){if(q.layerType!==r.layerType)return!1;if("ArcGISImageServiceVectorLayer"===q.layerType||"ArcGISTiledImageServiceLayer"===q.layerType||"ArcGISTiledMapServiceLayer"===
q.layerType||"ArcGISMapServiceLayer"===q.layerType||"ArcGISImageServiceLayer"===q.layerType)return q=f(q.url||""),r=f(r.url||""),q.toLowerCase()===r.toLowerCase();if("BingMapsAerial"===q.layerType||"BingMapsRoad"===q.layerType||"BingMapsHybrid"===q.layerType||"OpenStreetMap"===q.layerType)return!0;if("VectorTileLayer"===q.layerType)return q=f(q.styleUrl||""),r=f(r.styleUrl||""),q.toLowerCase()===r.toLowerCase();if("WMS"===q.layerType)return q=f(q.mapUrl||""),r=f(r.mapUrl||""),q.toLowerCase()===r.toLowerCase();
if("WebTiledLayer"===q.layerType){if(q.templateUrl&&r.templateUrl)return q=f(q.templateUrl||""),r=f(r.templateUrl||""),q.toLowerCase()===r.toLowerCase();if(q.wmtsInfo&&r.wmtsInfo)return q=f(q.wmtsInfo.url||""),r=f(r.wmtsInfo.url||""),q.toLowerCase()===r.toLowerCase()}}else return q=f(q.url||""),r=f(r.url||""),q.toLowerCase()===r.toLowerCase();return!1};m.compareSameBasemapByOrder=function(q,r){q=q.layers;r=r.layers;if(q.length!==r.length)return!1;for(var w=0;w<q.length;w++)if(!m.isSameBasemapLayer(q[w],
r[w]))return!1;return!0};m.isBingMap=function(q){if(!q||!q.layers)return!1;for(var r=0;r<q.layers.length;r++)if("BingMapsAerial"===q.layers[r].type||"BingMapsRoad"===q.layers[r].type||"BingMapsHybrid"===q.layers[r].type)return!0;return!1};m.isNoUrlLayerMap=function(q){for(var r=0;r<q.length;r++)if("BingMapsAerial"===q[r].type||"BingMapsRoad"===q[r].type||"BingMapsHybrid"===q[r].type||"OpenStreetMap"===q[r].type)return!0;return!1};m.getToken=function(q){q=c.getPortal(q);q.updateCredential();return q.credential?
"?token\x3d"+q.credential.token:""};m.removeUrlQuery=function(q){return g(q)};m.getStanderdUrl=function(q){return f(q)};m.getUniqueTitle=function(q,r){if(!r||0===r.length)return q;r=n.filter(r,function(w){return w===q?!0:0===w.indexOf(q)?(w=w.substr(q.length+1),!isNaN(+w)):!1});if(0===r.length)return q;r=n.map(r,function(w){return w===q?0:+w.substr(q.length+1)});r=r.sort();return q+" "+(r[r.length-1]+1)};m.getBasemapInfo=function(q,r){var w,u;return c.getPortal(q).getItemById(r).then(function(y){w=
y;return y.getItemData()}).then(function(y){u=y;return m._getBasemapSpatialReference(w,y)}).then(function(y){return{thumbnailUrl:w.thumbnailUrl,title:w.title||u.baseMap.title,layers:u.baseMap.baseMapLayers,spatialReference:new h(y)}})};m.getBasemapGalleryGroup=function(q,r){var w=new e;q=c.getPortal(q);var u=r.indexOf("esri_");if(0<=u){var y={id:"ind",uk:"ukr"},x=dojoConfig.locale.slice(0,2);u=r.slice(u,u+7);y="uk"===x&&0>r.indexOf("esri_ukr")||"id"===x&&0>r.indexOf("esri_ind")?"esri_"+y[x]:"esri_"+
x;r=r.replace(u,y)}q.queryGroups({f:"json",q:r}).then(G.hitch(this,function(z){0<z.results.length?w.resolve(z.results[0]):w.reject()}),G.hitch(this,function(){w.reject()}));return w};m._getBasemapSpatialReference=function(q,r){var w=null,u=!1,y=new e;if(q.owner&&0===q.owner.indexOf("esri_")||m.isNoUrlLayerMap(r.baseMap.baseMapLayers))w={wkid:"102100"};else if(r.spatialReference||q.spatialReference)w=r.spatialReference||q.spatialReference;else if(r.baseMap.baseMapLayers&&r.baseMap.baseMapLayers[0])if(q=
r.baseMap.baseMapLayers[0],q.url&&0<q.url.indexOf("rest/services"))u=!0,k(r.baseMap.baseMapLayers[0].url).then(G.hitch(this,function(x){x&&x.spatialReference&&(w=x.spatialReference);y.resolve(w)}),function(x){console.error(x);y.resolve(null)});else if("VectorTileLayer"===q.layerType)w={wkid:"102100"};else if(r=q.fullExtent||q.initialExtent)w=r.spatialReference;u||y.resolve(w);return y};return m})},"widgets/BasemapGallery/_build-generate_module":function(){define(["dojo/text!./Widget.html","dojo/text!./css/style.css",
"dojo/i18n!./nls/strings"],function(){})},"url:esri/dijit/templates/BasemapGallery.html":'\x3cdiv class\x3d"esriBasemapGallery"\x3e\r\n  \x3cdiv dojoAttachPoint\x3d"flowContainer"\x3e\r\n  \x3c/div\x3e\r\n\x3c/div\x3e',"url:widgets/BasemapGallery/esri_tileinfo.json":'{\r\n  "rows": 256,\r\n  "cols": 256,\r\n  "dpi": 96,\r\n  "compressionQuality": 75,\r\n  "origin": {\r\n   "x": -2.0037508342787E7,\r\n   "y": 2.0037508342787E7\r\n  },\r\n  "spatialReference": {\r\n   "wkid": 102100,\r\n   "latestWkid": 3857\r\n  },\r\n  "lods": [\r\n   {\r\n    "level": 0,\r\n    "resolution": 156543.03392800014,\r\n    "scale": 5.91657527591555E8\r\n   },\r\n   {\r\n    "level": 1,\r\n    "resolution": 78271.51696399994,\r\n    "scale": 2.95828763795777E8\r\n   },\r\n   {\r\n    "level": 2,\r\n    "resolution": 39135.75848200009,\r\n    "scale": 1.47914381897889E8\r\n   },\r\n   {\r\n    "level": 3,\r\n    "resolution": 19567.87924099992,\r\n    "scale": 7.3957190948944E7\r\n   },\r\n   {\r\n    "level": 4,\r\n    "resolution": 9783.93962049996,\r\n    "scale": 3.6978595474472E7\r\n   },\r\n   {\r\n    "level": 5,\r\n    "resolution": 4891.96981024998,\r\n    "scale": 1.8489297737236E7\r\n   },\r\n   {\r\n    "level": 6,\r\n    "resolution": 2445.98490512499,\r\n    "scale": 9244648.868618\r\n   },\r\n   {\r\n    "level": 7,\r\n    "resolution": 1222.992452562495,\r\n    "scale": 4622324.434309\r\n   },\r\n   {\r\n    "level": 8,\r\n    "resolution": 611.4962262813797,\r\n    "scale": 2311162.217155\r\n   },\r\n   {\r\n    "level": 9,\r\n    "resolution": 305.74811314055756,\r\n    "scale": 1155581.108577\r\n   },\r\n   {\r\n    "level": 10,\r\n    "resolution": 152.87405657041106,\r\n    "scale": 577790.554289\r\n   },\r\n   {\r\n    "level": 11,\r\n    "resolution": 76.43702828507324,\r\n    "scale": 288895.277144\r\n   },\r\n   {\r\n    "level": 12,\r\n    "resolution": 38.21851414253662,\r\n    "scale": 144447.638572\r\n   },\r\n   {\r\n    "level": 13,\r\n    "resolution": 19.10925707126831,\r\n    "scale": 72223.819286\r\n   },\r\n   {\r\n    "level": 14,\r\n    "resolution": 9.554628535634155,\r\n    "scale": 36111.909643\r\n   },\r\n   {\r\n    "level": 15,\r\n    "resolution": 4.77731426794937,\r\n    "scale": 18055.954822\r\n   },\r\n   {\r\n    "level": 16,\r\n    "resolution": 2.388657133974685,\r\n    "scale": 9027.977411\r\n   },\r\n   {\r\n    "level": 17,\r\n    "resolution": 1.1943285668550503,\r\n    "scale": 4513.988705\r\n   },\r\n   {\r\n    "level": 18,\r\n    "resolution": 0.5971642835598172,\r\n    "scale": 2256.994353\r\n   },\r\n   {\r\n    "level": 19,\r\n    "resolution": 0.29858214164761665,\r\n    "scale": 1128.497176\r\n   },\r\n   {\r\n    "level": 20,\r\n    "resolution": 0.14929107082380833,\r\n    "scale": 564.248588\r\n   },\r\n   {\r\n    "level": 21,\r\n    "resolution": 0.07464553541190416,\r\n    "scale": 282.124294\r\n   },\r\n   {\r\n    "level": 22,\r\n    "resolution": 0.03732276770595208,\r\n    "scale": 141.062147\r\n   },\r\n   {\r\n    "level": 23,\r\n    "resolution": 0.01866138385297604,\r\n    "scale": 70.5310735\r\n   }\r\n  ]\r\n }',
"url:widgets/BasemapGallery/Widget.html":'\x3cdiv\x3e\r\n\t\x3cdiv data-dojo-attach-point\x3d"basemapGalleryDiv" \x3e\x3c/div\x3e\r\n\t\x3cdiv data-dojo-type\x3d"jimu/dijit/LoadingIndicator" data-dojo-attach-point\x3d"loadingShelter" data-dojo-props\x3d\'hidden:true\'\x3e\x3c/div\x3e\r\n\x3c/div\x3e\r\n\r\n\r\n',"url:widgets/BasemapGallery/css/style.css":".jimu-widget-basemapgallery {height: 100%;}.jimu-widget-basemapgallery .esriBasemapGalleryNode:hover{color: #51B1FE;}.jimu-widget-basemapgallery .esriBasemapGalleryThumbnail {border: 1px solid #fff; margin: 1px; -moz-box-shadow: 0px 0px 0px #000; -webkit-box-shadow: 0px 0px 0px #000; box-shadow: 0px 0px 7px #000;}.jimu-widget-basemapgallery .esriBasemapGallerySelectedNode{color: #51B1FE;}.jimu-widget-basemapgallery .esriBasemapGalleryLabelContainer{padding-top: 2px;}.jimu-widget-basemapgallery .esriBasemapGalleryThumbnail{width: 100px; height: 67px;}.jimu-widget-basemapgallery .esriBasemapGallerySelectedNode .esriBasemapGalleryThumbnail{border-color: #51B1FE !important;}.jimu-widget-basemapgallery .esriBasemapGalleryNode {margin: 5px 10px 0 10px;}.jimu-rtl .jimu-widget-basemapgallery .esriBasemapGalleryNode {float: right;}.jimu-widget-basemapgallery .esriBasemapGalleryThumbnail {display: block; margin: 1px auto;}",
"*now":function(G){G(['dojo/i18n!*preload*widgets/BasemapGallery/nls/Widget*["ar","bs","ca","cs","da","de","en","el","es","et","fi","fr","he","hr","hu","id","it","ja","ko","lt","lv","nb","nl","pl","pt-br","pt-pt","ro","ru","sk","sl","sr","sv","th","tr","zh-cn","uk","vi","zh-hk","zh-tw","ROOT"]'])},"*noref":1}});
define("dojo/_base/declare dijit/_WidgetsInTemplateMixin dojo/Deferred jimu/BaseWidget jimu/portalUtils jimu/PanelManager jimu/portalUrlUtils jimu/utils esri/dijit/Basemap esri/dijit/BasemapLayer esri/dijit/BasemapGallery ./a11y/Widget dojo/_base/lang dojo/_base/array dojo/_base/html dojo/query dojo/on dojo/promise/all ./utils jimu/dijit/LoadingIndicator".split(" "),function(G,e,t,n,p,h,c,a,b,l,g,f,d,k,m,v,q,r,w){G=G([n,e],{name:"BasemapGallery",baseClass:"jimu-widget-basemapgallery",basemapGallery:null,
spatialRef:null,startup:function(){this.inherited(arguments);this.initBasemaps()},resize:function(){this._responsive()},_responsive:function(){setTimeout(d.hitch(this,function(){var u=v("#"+this.id)[0];u=m.getStyle(u,"width");var y=parseInt(u/110,10);if(0<y){var x=5+parseInt(u%110/y,10)/2;v(".esriBasemapGalleryNode",this.id).forEach(function(z){m.setStyle(z,"margin-left",x+"px");m.setStyle(z,"margin-right",x+"px")})}}),100)},initBasemaps:function(){var u=d.clone(this.config.basemapGallery);this.loadingShelter.show();
if(1===u.mode)var y=w._loadPortalBaseMaps(this.appConfig.portalUrl,this.map);else y=new t,y.resolve(u.basemaps);var x=p.getPortal(this.appConfig.portalUrl).loadSelfInfo();r({portalSelf:x,basemaps:y}).then(d.hitch(this,function(z){var A=z.basemaps,E=[],F=0,B=this._getWebmapBasemap();A=k.filter(A,function(M){if(!M||!M.title)return!1;var N=w.isBingMap(M)?z.portalSelf.bingKey?!0:!1:!0;return M.title&&N},this);for(F=0;F<A.length&&!w.compareSameBasemapByOrder(A[F],B);F++);F===A.length&&A.push(B);for(F=
0;F<A.length;F++){B=A[F].layers.length;for(var D=[],I=0;I<B;I++)D.push(new l(A[F].layers[I]));A[F].layers=D;A[F].thumbnailUrl?/^(https?:)?\/\//.test(A[F].thumbnailUrl)&&0>A[F].thumbnailUrl.indexOf("token\x3d")?A[F].thumbnailUrl+=w.getToken(this.appConfig.portalUrl):A[F].thumbnailUrl=a.processUrlInWidgetConfig(A[F].thumbnailUrl,this.folderUrl):A[F].thumbnailUrl=this.folderUrl+"images/default.jpg";E.push(new b(A[F]))}u.map=this.map;this.appConfig.portalUrl&&(u.portalUrl=this.appConfig.portalUrl);u.basemaps=
E;u.showArcGISBasemaps=!1;u.bingMapsKey=z.portalSelf.bingKey;this.basemapGallery=new g(u,this.basemapGalleryDiv);this.basemapGallery.startup();this.a11y_initGalleryNodesAttrs();this.own(q(this.basemapGallery,"selection-change",d.hitch(this,this.selectionChange)));this._responsive();this.loadingShelter.hide()})).otherwise(d.hitch(this,function(){this.loadingShelter.hide()}))},_getWebmapBasemap:function(){var u=this.map.itemInfo.item.thumbnail?c.getItemUrl(this.appConfig.portalUrl,this.map.itemInfo.item.id)+
"/info/"+this.map.itemInfo.item.thumbnail:null;return{title:this.map.itemInfo.itemData.baseMap.title,thumbnailUrl:u,layers:this.map.itemInfo.itemData.baseMap.baseMapLayers,spatialReference:this.map.spatialReference}},selectionChange:function(){this.updateExtent();"widgetOnScreen"===this.gid&&h.getInstance().closePanel(this.id+"_panel")},updateExtent:function(){if(0<this.map.getNumLevels()){var u=this.basemapGallery.getSelected().getLayers(),y=this.map.__tileInfo.lods[this.map.getLevel()],x;if(0<u.length&&
(u=u[0],(x=u.tileInfo||u.serviceInfoResponse&&u.serviceInfoResponse.tileInfo)&&y)){var z=y.scale/this.map.__tileInfo.dpi,A;k.forEach(x.lods,function(E){E=E.scale/x.dpi;if(!A||Math.abs(E-z)<Math.abs(A-z))A=E});Math.abs(A-z)/z>1/this.map.width&&this.map.setScale(A*x.dpi)}}}});G.extend(f);return G});