// All material copyright ESRI, All Rights Reserved, unless otherwise specified.
// See http://@sbaseurl@/jsapi/jsapi/esri/copyright.txt and http://www.arcgis.com/apps/webappbuilder/copyright.txt for details.

//>>built
define(["esri/geometry/Point"],function(p){var e=6378137;var c=.00669437999;var m=c/(1-c);var l=(1-Math.sqrt(1-c))/(1+Math.sqrt(1-c));return{setSpheroid:function(a){a=a.toUpperCase();switch(a){case "AIRY 1830":e=6377563.396;c=.00667053999998536;break;case "AIRY MODIFIED":e=6377340.189;c=.00667053999998536;break;case "AVERAGE TERRESTRIAL SYSTEM 1977":e=6378135;c=.00669438499958795;break;case "AUSTRALIAN NATIONAL":e=6378160;c=.00669454185458764;break;case "BESSEL 1841":e=6377397.155;c=.00667437223180214;
break;case "BESSEL MODIFIED":e=6377492.018;c=.00667437223180214;break;case "BESSEL NAMIBIA":e=6377483.865;c=.00667437223180214;break;case "CLARKE 1858":e=6378293.639;c=.00678514600473303;break;case "NAD27":case "CLARKE 1866":e=6378206.4;c=.00676865799760964;break;case "CLARKE 1866 MICHIGAN":e=6378450.047;c=.00676865830738507;break;case "CLARKE 1880":e=6378249.138;c=.00680348101883452;break;case "CLARKE 1880 (ARC)":e=6378249.145;c=.00680348101883452;break;case "CLARKE 1880 (BENOIT)":e=6378300.79;c=
.00680348271028565;break;case "CLARKE 1880 (IGN)":e=6378249.2;c=.00680348767623919;break;case "CLARKE 1880 (RGS)":e=6378249.145;c=.00680351128284906;break;case "CLARKE 1880 (SGA)":e=6378249.2;c=.00680348860198551;break;case "EVEREST 1830 (DEFINITION)":e=6377299.36;c=.00663784663019969;break;case "EVEREST 1830 (MODIFIED)":e=6377304.063;c=.00663784663019969;break;case "EVEREST (ADJUSTMENT 1937)":e=6377276.345;c=.00663784663019969;break;case "EVEREST (DEFINITION 1962)":e=6377301.243;c=.00663784606842344;
break;case "EVEREST (DEFINITION 1967)":e=6377298.556;c=.00663784663019969;break;case "EVEREST (DEFINITION 1975)":e=6377299.151;c=.00663784606842344;break;case "NAD83":case "GEM GRAVITY POTENTIAL MODEL":case "GRS 1980":e=6378137;c=.00669438002290079;break;case "GRS 1967 \x3d INTERNATIONAL 1967":e=6378160;c=.00669460532856765;break;case "HELMERT 1906":e=6378200;c=.00669342162296594;break;case "INDONESIAN NATIONAL":e=6378160;c=.0066946090804091;break;case "INTERNATIONAL 1924":e=6378388;c=.00672267002233332;
break;case "INTERNATIONAL 1967":e=6378160;c=.00669454185458764;break;case "KRASOVSKY 1940":e=6378245;c=.00669342162296594;break;case "TRANSIT PRECISE EPHEMERIS":e=6378145;c=.00669454185458764;break;case "OSU 1986 GEOIDAL MODEL":e=6378136.2;c=.00669438006997852;break;case "OSU 1991 GEOIDAL MODEL":e=6378136.3;c=.00669438006997852;break;case "PLESSIS 1817":e=6376523;c=.00646954373789485;break;case "STRUVE 1860":e=6378298.3;c=.00677435980080942;break;case "WAR OFFICE":e=6378300.583;c=.00674534331628926;
break;case "NWL-10D \x3d\x3d WGS 1972":e=6378135;c=.00669431777826672;break;case "WGS 1972":e=6378135;c=.00669431777826672;break;case "WGS84":case "WGS 1984":e=6378137;c=.00669437999014132;break;case "WGS 1966":e=6378145;c=.00669454185458764;break;case "FISCHER 1960":e=6378166;c=.00669342162296594;break;case "FISCHER 1968":e=6378150;c=.00669342162296594;break;case "FISCHER MODIFIED":e=6378155;c=.00669342162296594;break;case "HOUGH 1960":e=6378270;c=.00672267002233332;break;case "EVEREST MODIFIED 1969":e=
6377295.664;c=.00663784663019969;break;case "WALBECK":e=6376896;c=.00659454809414964;break;case "GRS 1967 TRUNCATED":e=6378160,c=.00669454185458764}m=c/(1-c);l=(1-Math.sqrt(1-c))/(1+Math.sqrt(1-c))},getSpheroidList:function(){return"AIRY 1830;AIRY MODIFIED;AUSTRALIAN NATIONAL;AVERAGE TERRESTRIAL SYSTEM 1977;BESSEL 1841;BESSEL MODIFIED;BESSEL NAMIBIA;CLARKE 1858;CLARKE 1866 MICHIGAN;CLARKE 1866;CLARKE 1880 (ARC);CLARKE 1880 (BENOIT);CLARKE 1880 (IGN);CLARKE 1880 (RGS);CLARKE 1880 (SGA);CLARKE 1880;EVEREST (ADJUSTMENT 1937);EVEREST (DEFINITION 1962);EVEREST (DEFINITION 1967);EVEREST (DEFINITION 1975);EVEREST 1830 (DEFINITION);EVEREST 1830 (MODIFIED);EVEREST MODIFIED 1969;FISCHER 1960;FISCHER 1968;FISCHER MODIFIED;GEM GRAVITY POTENTIAL MODEL;GRS 1967 \x3d INTERNATIONAL 1967;GRS 1967 TRUNCATED;GRS 1980;HELMERT 1906;HOUGH 1960;INDONESIAN NATIONAL;INTERNATIONAL 1924;INTERNATIONAL 1967;KRASOVSKY 1940;NWL-10D \x3d\x3d WGS 1972;OSU 1986 GEOIDAL MODEL;OSU 1991 GEOIDAL MODEL;PLESSIS 1817;STRUVE 1860;TRANSIT PRECISE EPHEMERIS;WALBECK;WAR OFFICE;WGS 1966;WGS 1972;WGS 1984".split(";")},
getZoneNumber:function(a,b){a=parseFloat(a);b=parseFloat(b);if(360<b||-180>b){for(;-180>b;)b+=360;for(;180<b;)b-=360}b=b+180-360*Math.floor((b+180)/360)-180;var d=Math.floor((b+180)/6)+1;56<=a&&64>a&&3<=b&&12>b&&(d=32);72<=a&&84>a&&(0<=b&&9>b?d=31:9<=b&&21>b?d=33:21<=b&&33>b?d=35:33<=b&&42>b&&(d=37));return d},LLtoUTM:function(a,b,d){a=parseFloat(a);b=parseFloat(b);if(84<a||-80>a)return"undefined, ensure 84N \x3e Lat \x3e 80S";if(360<b||-180>b){for(;-180>b;)b+=360;for(;180<b;)b-=360}var h=b+180-360*
Math.floor((b+180)/360)-180;var k=a*Math.PI/180;h=h*Math.PI/180;b=d?d:this.getZoneNumber(a,b);var g=(6*(b-1)-180+3)*Math.PI/180;a=b+""+this.UTMLetterDesignator(a)+" ";d=e/Math.sqrt(1-c*Math.sin(k)*Math.sin(k));var f=Math.tan(k)*Math.tan(k);var n=m*Math.cos(k)*Math.cos(k);g=Math.cos(k)*(h-g);h=.9996*d*(g+(1-f+n)*g*g*g/6+(5-18*f+f*f+72*n-58*m)*g*g*g*g*g/120)+5E5;k=.9996*(e*((1-c/4-3*c*c/64-5*c*c*c/256)*k-(3*c/8+3*c*c/32+45*c*c*c/1024)*Math.sin(2*k)+(15*c*c/256+45*c*c*c/1024)*Math.sin(4*k)-35*c*c*c/
3072*Math.sin(6*k))+d*Math.tan(k)*(g*g/2+(5-f+9*n+4*n*n)*g*g*g*g/24+(61-58*f+f*f+600*n-330*m)*g*g*g*g*g*g/720));d={};d.z=b;d.s=a;d.x=Math.round(h);d.y=0>k?Math.round(1E7+k):Math.round(k);return[h,k,b,d]},LLtoUSNG:function(a,b,d,h){d=d||5;var k=h?h:this.getZoneNumber(a,b);a=parseFloat(a);b=parseFloat(b);var g=this.LLtoUTM(a,b,k);h=g[0];var f=g[1];0>a&&(f+=1E7);g=this.findGridLetters(k,f,h);k=Math.round(f)%1E5;h=Math.round(h)%1E5;k=Math.floor(k/Math.pow(10,5-d));h=Math.floor(h/Math.pow(10,5-d));a=this.getZoneNumber(a,
b)+this.UTMLetterDesignator(a)+" "+g+" ";for(b=String(h).length;b<d;b++)a+="0";a+=h+" ";for(b=String(k).length;b<d;b++)a+="0";return a+k},UTMLetterDesignator:function(a){a=parseFloat(a);return 84>=a&&72<=a?"X":72>a&&64<=a?"W":64>a&&56<=a?"V":56>a&&48<=a?"U":48>a&&40<=a?"T":40>a&&32<=a?"S":32>a&&24<=a?"R":24>a&&16<=a?"Q":16>a&&8<=a?"P":8>a&&0<=a?"N":0>a&&-8<=a?"M":-8>a&&-16<=a?"L":-16>a&&-24<=a?"K":-24>a&&-32<=a?"J":-32>a&&-40<=a?"H":-40>a&&-48<=a?"G":-48>a&&-56<=a?"F":-56>a&&-64<=a?"E":-64>a&&-72<=
a?"D":-72>a&&-80<=a?"C":"Z"},findSet:function(a){a=parseInt(a,10);switch(a%6){case 0:return 6;case 1:return 1;case 2:return 2;case 3:return 3;case 4:return 4;case 5:return 5;default:return-1}},findGridLetters:function(a,b,d){a=parseInt(a,10);b=parseFloat(b);d=parseFloat(d);var h=1;for(b=Math.round(b);1E5<=b;)b-=1E5,h++;h%=20;b=0;for(d=Math.round(d);1E5<=d;)d-=1E5,b++;b%=8;return this.lettersHelper(this.findSet(a),h,b)},lettersHelper:function(a,b,d){0===b?b=19:b--;0===d?d=7:d--;switch(a){case 1:return a=
"ABCDEFGHJKLMNPQRSTUV","ABCDEFGH".charAt(d)+a.charAt(b);case 2:return a="FGHJKLMNPQRSTUVABCDE","JKLMNPQR".charAt(d)+a.charAt(b);case 3:return a="ABCDEFGHJKLMNPQRSTUV","STUVWXYZ".charAt(d)+a.charAt(b);case 4:return a="FGHJKLMNPQRSTUVABCDE","ABCDEFGH".charAt(d)+a.charAt(b);case 5:return a="ABCDEFGHJKLMNPQRSTUV","JKLMNPQR".charAt(d)+a.charAt(b);case 6:return a="FGHJKLMNPQRSTUVABCDE","STUVWXYZ".charAt(d)+a.charAt(b)}},UTMtoLL:function(a,b,d){b=parseFloat(b)-5E5;a=parseFloat(a);d=parseInt(d,10);a=a/.9996/
(e*(1-c/4-3*c*c/64-5*c*c*c/256));a=a+(3*l/2-27*l*l*l/32)*Math.sin(2*a)+(21*l*l/16-55*l*l*l*l/32)*Math.sin(4*a)+151*l*l*l/96*Math.sin(6*a);var h=e/Math.sqrt(1-c*Math.sin(a)*Math.sin(a)),k=Math.tan(a)*Math.tan(a),g=m*Math.cos(a)*Math.cos(a),f=b/(.9996*h);b=a-h*Math.tan(a)/(e*(1-c)/Math.pow(1-c*Math.sin(a)*Math.sin(a),1.5))*(f*f/2-(5+3*k+10*g-4*g*g-9*m)*f*f*f*f/24+(61+90*k+298*g+45*k*k-252*m-3*g*g)*f*f*f*f*f*f/720);b=180*b/Math.PI;a=(f-(1+2*k+g)*f*f*f/6+(5-2*g+28*k-3*g*g+8*m+24*k*k)*f*f*f*f*f/120)/Math.cos(a);
a=6*(d-1)-180+3+180*a/Math.PI;d={};d.lat=b;d.lon=a;return d},USNGtoUTM:function(a,b,d,h,k,g){d=1+"ABCDEFGHJKLMNPQRSTUVWXYZ".indexOf(d)%8;var f="CDEFGHJKLMNPQRSTUVWX".indexOf(b);h=a%2?"ABCDEFGHJKLMNPQRSTUV".indexOf(h):"FGHJKLMNPQRSTUVABCDE".indexOf(h);h=Number([0,2,2,2,4,4,6,6,8,8,0,0,0,2,2,4,4,6,6,6][f])+h/10;h<[1.1,2,2.9,3.8,4.7,5.6,6.5,7.3,8.2,9.1,0,.8,1.7,2.6,3.5,4.4,5.3,6.2,7,7.9][f]&&(h+=2);f={};f.N=1E6*h+Number(g)*Math.pow(10,5-g.length);f.E=1E5*d+Number(k)*Math.pow(10,5-k.length);f.zone=a;
f.letter=b;return f},USNGtoLL:function(a){a=this.parseUSNG_str(a);var b=this.USNGtoUTM(a.zone,a.ltr,a.sq1,a.sq2,a.east,a.north);"N">a.ltr&&(b.N-=1E7);b=this.UTMtoLL(b.N,b.E,a.zone);return[b.lat,b.lon]},parseUSNG_str:function(a){var b=[];a=a.toUpperCase();b=/%20/g;b=a.replace(b,"");b=/ /g;b=a.replace(b,"");if(7>b.length)return 0;a={};var d=0;a.zone=10*b.charAt(d++)+1*b.charAt(d++);a.ltr=b.charAt(d++);a.sq1=b.charAt(d++);a.sq2=b.charAt(d++);a.precision=(b.length-d)/2;a.east="";a.north="";for(var h=
0;h<a.precision;h++)a.east+=b.charAt(d++);" "===b[d]&&d++;for(h=0;h<a.precision;h++)a.north+=b.charAt(d++);return a},isUSNG:function(a){a=a.toUpperCase();var b=/%20/g;a=a.replace(b,"");b=/ /g;a=a.replace(b,"");if(15<a.length)return 0;b=/^[0-9]{2}[CDEFGHJKLMNPQRSTUVWX]$/;if(a.match(b))return 0;b=/^[0-9]{2}[CDEFGHJKLMNPQRSTUVWX][ABCDEFGHJKLMNPQRSTUVWXYZ][ABCDEFGHJKLMNPQRSTUV]([0-9][0-9]){0,5}/;return!a.match(b)||7>a.length?0:a},LLtoMGRS:function(a,b,d){return this.LLtoUSNG(a,b,d||5).replace(/ /g,"")},
USNGtoPoint:function(a){a=this.USNGtoLL(a);return new p(a[1],a[0])},pointToUSNG:function(a,b){var d=a.getLatitude();a=a.getLongitude();return this.LLtoUSNG(d,a,b)},LLtoUSNG_nad27:function(a,b,d){return this.LLtoUSNG(a,b,d||5)+" (NAD27)"}}});