// All material copyright ESRI, All Rights Reserved, unless otherwise specified.
// See http://@sbaseurl@/jsapi/jsapi/esri/copyright.txt and http://www.arcgis.com/apps/webappbuilder/copyright.txt for details.

//>>built
require({cache:{"esri/tasks/locator":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/array dojo/_base/Deferred dojo/_base/json dojo/has ../kernel ../request ../deferredUtils ./Task ./AddressCandidate".split(" "),function(L,y,H,J,w,E,M,l,q,G,N){L=L(G,{declaredClass:"esri.tasks.Locator",_eventMap:{"address-to-locations-complete":["addresses"],"addresses-to-locations-complete":["addresses"],"location-to-address-complete":["address"],"suggest-locations-complete":["suggestions"]},constructor:function(c){this._geocodeHandler=
y.hitch(this,this._geocodeHandler);this._geocodeAddressesHandler=y.hitch(this,this._geocodeAddressesHandler);this._reverseGeocodeHandler=y.hitch(this,this._reverseGeocodeHandler);this.registerConnectEvents()},outSpatialReference:null,setOutSpatialReference:function(c){this.outSpatialReference=c},_geocodeHandler:function(c,z,C,x,A){try{var O=c.candidates;z=[];var p,v=O.length,t=c.spatialReference,d;for(p=0;p<v;p++){var m=O[p];if(d=m.location)d.spatialReference=t;z[p]=new N(m)}this._successHandler([z],
"onAddressToLocationsComplete",C,A)}catch(g){this._errorHandler(g,x,A)}},_geocodeAddressesHandler:function(c,z,C,x,A){try{var O=c.locations;z=[];var p,v=O.length,t=c.spatialReference,d;for(p=0;p<v;p++){if(d=O[p].location)d.spatialReference=t;z[p]=new N(O[p])}this._successHandler([z],"onAddressesToLocationsComplete",C,A)}catch(m){this._errorHandler(m,x,A)}},addressToLocations:function(c,z,C,x,A){var O;if(c.address){x=C;C=z;z=c.outFields;A=c.searchExtent;var p=c.countryCode;var v=c.magicKey;var t=c.distance;
var d=c.categories;c.location&&this.normalization&&(O=c.location.normalize());var m=c.locationType;var g=c.maxLocations;var k=c.forStorage;c=c.address}A&&(A=A.shiftCentralMeridian());var K=this.outSpatialReference;c=this._encode(y.mixin({},this._url.query,c,{f:"json",outSR:K&&w.toJson(K.toJson()),outFields:z&&z.join(",")||null,searchExtent:A&&w.toJson(A.toJson()),category:d&&d.join(",")||null,countryCode:p||null,magicKey:v||null,distance:t||null,location:O||null,locationType:m||null,maxLocations:g||
null,forStorage:k||null}));var I=this._geocodeHandler,r=this._errorHandler,f=new J(q._dfdCanceller);f._pendingDfd=l({url:this._url.path+"/findAddressCandidates",content:c,callbackParamName:"callback",load:function(e,h){I(e,h,C,x,f)},error:function(e){r(e,x,f)}});return f},suggestLocations:function(c){var z=new J(q._dfdCanceller);c.hasOwnProperty("location")&&this.normalization&&(c.location=c.location.normalize());c.searchExtent&&(c.searchExtent=c.searchExtent.shiftCentralMeridian());c=this._encode(y.mixin({},
this._url.query,{f:"json",text:c.text,maxSuggestions:c.maxSuggestions,searchExtent:c.searchExtent&&w.toJson(c.searchExtent.toJson()),category:c.categories&&c.categories.join(",")||null,countryCode:c.countryCode||null,location:c.location||null,distance:c.distance||null},{f:"json"}));c=l({url:this._url.path+"/suggest",content:c,callbackParamName:"callback"});z._pendingDfd=c;c.then(y.hitch(this,function(C){C=C.suggestions||[];this.onSuggestLocationsComplete(C);z.resolve(C)}),y.hitch(this,function(C){this._errorHandler(C);
z.reject(C)}));return z},addressesToLocations:function(c,z,C){var x=this.outSpatialReference,A=[],O=c.categories,p=c.locationType,v=c.countryCode;H.forEach(c.addresses,function(g,k){A.push({attributes:g})});c=this._encode(y.mixin({},this._url.query,{category:O&&O.join(",")||null,locationType:p||null,sourceCountry:v||null},{addresses:w.toJson({records:A})},{f:"json",outSR:x&&w.toJson(x.toJson())}));var t=this._geocodeAddressesHandler,d=this._errorHandler,m=new J(q._dfdCanceller);m._pendingDfd=l({url:this._url.path+
"/geocodeAddresses",content:c,callbackParamName:"callback",load:function(g,k){t(g,k,z,C,m)},error:function(g){d(g,C,m)}});return m},_reverseGeocodeHandler:function(c,z,C,x,A){try{var O=new N({address:c.address,location:c.location,score:100});this._successHandler([O],"onLocationToAddressComplete",C,A)}catch(p){this._errorHandler(p,x,A)}},locationToAddress:function(c,z,C,x){c&&this.normalization&&(c=c.normalize());var A=this.outSpatialReference;c=this._encode(y.mixin({},this._url.query,{outSR:A&&w.toJson(A.toJson()),
location:c&&w.toJson(c.toJson()),distance:z,f:"json"}));var O=this._reverseGeocodeHandler,p=this._errorHandler,v=new J(q._dfdCanceller);v._pendingDfd=l({url:this._url.path+"/reverseGeocode",content:c,callbackParamName:"callback",load:function(t,d){O(t,d,C,x,v)},error:function(t){p(t,x,v)}});return v},onSuggestLocationsComplete:function(){},onAddressToLocationsComplete:function(){},onAddressesToLocationsComplete:function(){},onLocationToAddressComplete:function(){}});E("extend-esri")&&y.setObject("tasks.Locator",
L,M);return L})},"esri/tasks/AddressCandidate":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/has","../kernel","../geometry/Point"],function(L,y,H,J,w){L=L(null,{declaredClass:"esri.tasks.AddressCandidate",constructor:function(E){y.mixin(this,E);this.location=new w(this.location)}});H("extend-esri")&&y.setObject("tasks.AddressCandidate",L,J);return L})},"esri/tasks/BufferParameters":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/array dojo/_base/json dojo/has ../kernel ../geometry/Polygon ../geometry/jsonUtils".split(" "),
function(L,y,H,J,w,E,M,l){L=L(null,{declaredClass:"esri.tasks.BufferParameters",geometries:null,outSpatialReference:null,bufferSpatialReference:null,distances:null,unit:null,unionResults:!1,geodesic:!1,toJson:function(){var q={unit:this.unit,unionResults:this.unionResults,geodesic:this.geodesic},G=this.distances,N=this.outSpatialReference,c=this.bufferSpatialReference,z=H.map(this.geometries,function(A){A="extent"===A.type?M.fromExtent(A):A;return A.toJson()},this),C=this.geometries;if(C&&0<C.length){var x=
"extent"===C[0].type?"esriGeometryPolygon":l.getJsonType(C[0]);q.geometries=J.toJson({geometryType:x,geometries:z});q.inSR=C[0].spatialReference.wkid?C[0].spatialReference.wkid:J.toJson(C[0].spatialReference.toJson())}G&&(q.distances=G.join(","));N&&(q.outSR=N.wkid?N.wkid:J.toJson(N.toJson()));c&&(q.bufferSR=c.wkid?c.wkid:J.toJson(c.toJson()));return q}});w("extend-esri")&&y.setObject("tasks.BufferParameters",L,E);return L})},"widgets/IncidentAnalysis/js/SummaryInfo":function(){define("dojo/_base/declare dojo/_base/array dojo/_base/lang dojo/_base/Color dojo/dom dojo/dom-class dojo/dom-construct dojo/dom-style dojo/number dojo/on dojo/has dijit/form/Button jimu/dijit/Popup jimu/CSVUtils jimu/utils esri/config esri/geometry/geometryEngine esri/geometry/mathUtils esri/geometry/Point esri/geometry/webMercatorUtils esri/graphic esri/layers/FeatureLayer esri/symbols/SimpleMarkerSymbol esri/symbols/SimpleLineSymbol esri/symbols/Font esri/symbols/TextSymbol esri/tasks/query".split(" "),
function(L,y,H,J,w,E,M,l,q,G,N,c,z,C,x,A,O,p,v,t,d,m,g,k,K,I,r){return L("SummaryInfo",null,{summaryLayer:null,summaryFields:[],summaryIds:[],summaryFeatures:[],constructor:function(f,e,h){this.tab=f;this.container=e;this.parent=h;this.config=h.config;this.buffer=this.incident=this.summaryLayer=null},updateForIncident:function(f,e){this.container.innerHTML="";E.add(this.container,"loading");this.incident=f;this.buffer=e;this.summaryIds=[];this.summaryFeatures=[];if(this.summaryLayer)this._queryFeatures(e.geometry);
else{var h=new m(this.tab.tabLayers[0].url);G(h,"load",H.hitch(this,function(){h.capabilities&&-1<h.capabilities.indexOf("Query")?(this.summaryLayer=h,this.summaryFields=this._getFields(this.summaryLayer),this._queryFeatures(e.geometry)):this._processError()}));G(this.parent.opLayers,"layerInfosFilterChanged",H.hitch(this,this._layerFilterChanged))}},_layerFilterChanged:function(f){if(null!==this.summaryLayer&&null!==this.incident&&null!==this.buffer){var e=this.tab.tabLayers[0].id;y.forEach(f,H.hitch(this,
function(h){e===h.id&&this.updateForIncident(this.incident,this.buffer)}))}},_queryFeatures:function(f){var e=this.tab.tabLayers[0].id,h="";this.parent.opLayers.traversal(function(D){if(e===D.id&&D.getFilter())return h=D.getFilter(),!0});var B=new r;B.geometry=f;B.where=h;this.summaryLayer.queryIds(B,H.hitch(this,function(D){D?(this.summaryIds=D,0<this.summaryIds.length?this._queryFeaturesByIds():this._processResults()):this._processResults()}))},_queryFeaturesByIds:function(){var f=this.summaryLayer.maxRecordCount||
1E3,e=this.summaryIds.slice(0,f);this.summaryIds.splice(0,f);f=new r;var h=!1;y.some(this.summaryFields,function(D){if("area"===D.type||"length"===D.type)return h=!0});f.returnGeometry=h;var B=[];y.forEach(this.summaryFields,function(D){B.push(D.field)});f.outFields=B;f.objectIds=e;this.summaryLayer.queryFeatures(f,H.hitch(this,function(D){this.summaryFeatures=this.summaryFeatures.concat(D.features);this._processResults();0<this.summaryIds.length?(w.byId("IMT_download")&&E.replace(w.byId("IMT_download"),
"processing","download"),setTimeout(H.hitch(this,this._queryFeaturesByIds),900)):w.byId("IMT_download")&&E.replace(w.byId("IMT_download"),"download","processing")}))},_prepResults:function(){for(var f=0;f<this.summaryFields.length;f++){var e=this.summaryFields[f],h=e.field,B=e.value;switch(e.type){case "count":B=this.summaryFeatures.length;break;case "area":B=this._getArea();break;case "length":B=this._getLength();break;case "sum":B=this._getSum(h);break;case "avg":B=this._getSum(h)/this.summaryFeatures.length;
break;case "min":B=this._getMin(h);break;case "max":B=this._getMax(h)}e.value=B}},_sortResults:function(f){return function(e,h){return e.attributes[f]<h.attributes[f]?-1:e.attributes[f]>h.attributes[f]?1:0}},_getSum:function(f){var e=0;y.forEach(this.summaryFeatures,function(h){e+=h.attributes[f]});return e},_getMin:function(f){this.summaryFeatures.sort(this._sortResults(f));return this.summaryFeatures[0].attributes[f]},_getMax:function(f){this.summaryFeatures.sort(this._sortResults(f));this.summaryFeatures.reverse();
return this.summaryFeatures[0].attributes[f]},_getArea:function(){var f=0,e=H.clone(this.config.distanceSettings);e.miles=109413;e.kilometers=109414;e.feet=109405;e.meters=109404;e.yards=109442;e.nauticalMiles=109409;var h=e[this.config.distanceUnits];y.forEach(this.summaryFeatures,function(B){f+=O.geodesicArea(B.geometry,h)});return f},_getLength:function(){var f=0,e=this.config.distanceSettings[this.config.distanceUnits];y.forEach(this.summaryFeatures,function(h){f+=O.geodesicLength(h.geometry,
e)});return f},_processError:function(){this.container.innerHTML="";E.remove(this.container,"loading");this.container.innerHTML=this.parent.nls.noFeaturesFound},_processResults:function(){this._prepResults();this.container.innerHTML="";E.remove(this.container,"loading");var f=this.summaryFields,e=0,h=M.create("div",{id:"tpc",style:"width:"+220*(f.length+1)+"px;"},this.container);E.add(h,"IMT_tabPanelContent");var B=M.create("div",{},h);E.add(B,"IMTcol");B=M.create("div",{id:"IMT_download",innerHTML:this.parent.nls.downloadCSV},
B);E.add(B,["btnExport","download"]);G(B,"click",H.hitch(this,this._exportToCSV));for(B=0;B<f.length;B++){e=f[B];var D=x.sanitizeHTML(e.alias?e.alias:"")+"\x3cbr/\x3e";e=e.alias===this.parent.nls.area||e.alias===this.parent.nls.length?e.value:Math.round(e.value);isNaN(e)&&(e=0);D+="\x3cdiv class\x3d'colSummary'\x3e"+q.format(e)+"\x3c/div\x3e\x3cbr/\x3e";D=M.create("div",{id:"Demographics_"+B,innerHTML:D},h);E.add(D,"IMTcol")}},_exportToCSV:function(){if(0===this.summaryFeatures.length)return!1;console.log(this.tab);
var f=this.tab.layers,e=[],h=[];y.forEach(this.summaryFeatures,function(D){e.push(D.attributes)});for(var B in e[0])h.push(B);C.exportCSV(f,e,h)},_getFields:function(f){var e=[];if(this.tab.advConfig&&this.tab.advConfig.fields&&0<this.tab.advConfig.fields.length)return y.forEach(this.tab.advConfig.fields,H.hitch(this,function(R){var V="";"count"!==R.type&&"area"!==R.type&&"length"!==R.type&&(V=" (\x3cspan style\x3d'font-size:7pt;'\x3e"+this.parent.nls[R.type]+"\x3c/span\x3e)");e.push({field:R.expression,
alias:R.label+V,type:R.type,value:0})})),e;var h=f.infoTemplate?f.infoTemplate.info.fieldInfos:f.fields;for(var B=0;B<h.length;B++){var D=h[B],Q=D.fieldName||D.name,S=this._getFieldType(f.fields,Q),T=null;Q===f.objectIdField||"esriFieldTypeDouble"!==S&&"esriFieldTypeInteger"!==S&&"esriFieldTypeSmallInteger"!==S||("undefined"!==typeof D.visible?D.visible&&(T={field:D.fieldName,alias:D.label,type:"sum",value:0}):T={field:D.name,alias:D.alias,type:"sum",value:0},T&&e.push(T))}return e},_getFieldType:function(f,
e){var h;y.some(f,function(B){if(B.name===e)return h=B.type,!0});return h}})})},"widgets/IncidentAnalysis/js/WeatherInfo":function(){define("dojo/_base/declare dojo/_base/lang dojo/dom-class dojo/dom-construct esri/geometry/webMercatorUtils esri/request jimu/utils".split(" "),function(L,y,H,J,w,E,M){return L("WeatherInfo",null,{constructor:function(l,q,G){this.tab=l;this.container=q;this.parent=G;this.weatherURL=l.url;this.weatherDict={119:["Cloudy","cloudy5.png","cloudy5.png"],377:["Moderate or heavy showers of ice pellets",
"hail.png","hail.png"],374:["Light showers of ice pellets","hail.png","hail.png"],350:["Ice pellets","hail.png","hail.png"],353:["Light rain shower","light_rain.png","light_rain.png"],302:["Moderate rain","light_rain.png","light_rain.png"],296:["Light rain","light_rain.png","light_rain.png"],293:["Patchy light rain","light_rain.png","light_rain.png"],266:["Light drizzle","light_rain.png","light_rain.png"],263:["Patchy light drizzle","light_rain.png","light_rain.png"],122:["Overcast","overcast.png",
"overcast.png"],359:["Torrential rain shower","shower3.png","shower3.png"],308:["Heavy rain","shower3.png","shower3.png"],365:["Moderate or heavy sleet showers","sleet.png","sleet.png"],362:["Light sleet showers","sleet.png","sleet.png"],320:["Moderate or heavy sleet","sleet.png","sleet.png"],317:["Light sleet","sleet.png","sleet.png"],314:["Moderate or Heavy freezing rain","sleet.png","sleet.png"],311:["Light freezing rain","sleet.png","sleet.png"],284:["Heavy freezing drizzle","sleet.png","sleet.png"],
281:["Freezing drizzle","sleet.png","sleet.png"],185:["Patchy freezing drizzle nearby","sleet.png","sleet.png"],182:["Patchy sleet nearby","sleet.png","sleet.png"],395:["Moderate or heavy snow in area with thunder","snow4.png","snow4.png"],335:["Patchy heavy snow","snow4.png","snow4.png"],230:["Blizzard","snow4.png","snow4.png"],227:["Blowing snow","snow4.png","snow4.png"],371:["Moderate or heavy snow showers","snow5.png","snow5.png"],338:["Heavy snow","snow5.png","snow5.png"],389:["Moderate or heavy rain in area with thunder",
"tstorm3.png","tstorm3.png"],392:["Patchy light snow in area with thunder","snow2.png","snow2_night.png"],386:["Patchy light rain in area with thunder","tstorm1.png","tstorm1_night.png"],368:["Light snow showers","snow2.png","snow2_night.png"],356:["Moderate or heavy rain shower","shower2.png","shower2_night.png"],332:["Moderate snow","snow3.png","snow3_night.png"],329:["Patchy moderate snow","snow2.png","snow2_night.png"],326:["Light snow","snow1.png","snow1_night.png"],323:["Patchy light snow",
"snow1.png","snow1_night.png"],305:["Heavy rain at times","shower2.png","shower2_night.png"],299:["Moderate rain at times","shower2.png","shower2_night.png"],260:["Freezing fog","fog.png","fog_night.png"],248:["Fog","fog.png","fog_night.png"],200:["Thundery outbreaks in nearby","tstorm1.png","tstorm1_night.png"],179:["Patchy snow nearby","snow1.png","snow1_night.png"],176:["Patchy rain nearby","shower1.png","shower1_night.png"],143:["Mist","mist.png","mist_night.png"],116:["Partly Cloudy","cloudy3.png",
"cloudy3_night.png"],113:["Clear/Sunny","sunny.png","sunny_night.png"]}},updateForIncident:function(l){this.container.innerHTML="";H.add(this.container,"loading");var q=l=l.geometry;"point"!==l.type&&(q=l.getExtent().getCenter());l=w.webMercatorToGeographic(q);E({url:this.weatherURL+"\x26callbackNode\x3d"+this.parent.name+"\x26q\x3d"+(l.y+","+l.x),callbackParamName:"callback"},{useProxy:!1}).then(y.hitch(this,function(G){return this._resultsHandler(G)}),y.hitch(this,function(G){G=this._errorHandler(G);
console.log(G)}))},_resultsHandler:function(l){l=l.data;console.log(l);var q=l.current_condition;l=l.weather;var G=1;this.container.innerHTML="";H.remove(this.container,"loading");var N=J.create("div",{id:"tpc",style:"width:"+165*(l.length+3)+"px;"},this.container);H.add(N,"IMT_tabPanelContent");if(0<q.length){q=q[0];var c=q.localObsDateTime.split(" ");var z=c[2];c=c[1].split(":");c=parseInt(c[0],10);if("AM"===z){if(6>c||12===c)G=2}else 6<c&&12>c&&(G=2);z=q.temp_F;this.parent.config.celsius&&(z=q.temp_C);
c=q.weatherCode;c=this.weatherDict[parseInt(c,10)];c=this.parent.nls.now+"\x3cbr/\x3e\x3cimg style\x3d'height:45px' src\x3d'"+this.parent.folderUrl+"images/w/"+c[G]+"' /\x3e\x3cbr/\x3e"+z+"\x26deg;";z=J.create("div",{innerHTML:M.sanitizeHTML(c?c:"")},N);H.add(z,"IMTcolSmall");z=q.windspeedMiles;c=" MPH";this.parent.config.celsius&&(z=q.windspeedKmph,c=" KMPH");c=this.parent.nls.wind+"\x3cbr/\x3e\x3cspan style\x3d'font-size: 30px; line-height:47px'\x3e"+q.winddir16Point+"\x3c/span\x3e\x3cbr/\x3e"+
z+c;q=J.create("div",{innerHTML:M.sanitizeHTML(c?c:"")},N);H.add(q,"IMTcolSmall")}for(z=0;z<l.length;z++){q=l[z];var C=this._getDay(q.date),x=q.tempMaxF||q.maxtempF,A=q.tempMinF||q.mintempF;this.parent.config.celsius&&(x=q.tempMaxC||q.maxtempC,A=q.tempMinC||q.mintempC);c=q.weatherCode||q.hourly[0].weatherCode;c=this.weatherDict[parseInt(c,10)];c=C+"\x3cbr/\x3e\x3cimg style\x3d'height:45px' src\x3d'"+this.parent.folderUrl+"images/w/"+c[G]+"' /\x3e\x3cbr/\x3e"+x+"\x26deg; | "+A+"\x26deg;";q=J.create("div",
{innerHTML:M.sanitizeHTML(c?c:"")},N);H.add(q,"IMTcolSmall")}l=J.create("div",{innerHTML:'\x3cbr/\x3e\x3cbr/\x3e\x3cbr/\x3e\x3cspan style\x3d"font-size:11px;color:#6e6e6e"\x3ePowered by\x3cbr/\x3e\x3ca style\x3d"color:#6e6e6e;text-decoration:none" href\x3d"https://darksky.net/poweredby/" title\x3d"Dark Sky" target\x3d"_blank"\x3eDark Sky\x3c/a\x3e\x3c/span\x3e'},N);H.add(l,"IMTcolSmall");H.add(l,"IMTcolLast")},_getDay:function(l){l=l.split("-");l="SUN MON TUE WED THU FRI SAT".split(" ")[(new Date(l[0],
l[1]-1,l[2])).getDay()];return this.parent.nls[l]},_errorHandler:function(l){console.log(l.message);l=l.message;l=J.create("div",{innerHTML:M.sanitizeHTML(l?l:"")},this.container);H.add(l,"IMTcolSmall")}})})},"widgets/IncidentAnalysis/js/ClosestInfo":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/Color dojo/_base/array dojo/dom-class dojo/dom-construct dojo/dom-style dojo/on esri/geometry/geometryEngine esri/graphic esri/layers/FeatureLayer esri/symbols/SimpleMarkerSymbol esri/symbols/SimpleLineSymbol esri/symbols/Font esri/symbols/TextSymbol esri/tasks/query jimu/utils".split(" "),
function(L,y,H,J,w,E,M,l,q,G,N,c,z,C,x,A,O){return L("ClosestInfo",null,{constructor:function(p,v,t){this.tab=p;this.container=v;this.parent=t;this.graphicsLayer=this.distance=this.incident=this.featureLayer=null;this.map=t.map;this.specialFields={}},updateForIncident:function(p,v,t){if(this.featureLayer)this.processIncident(p,v,t);else if(0<this.tab.tabLayers.length){var d=new N(this.tab.tabLayers[0].url);l(d,"load",y.hitch(this,function(){d.capabilities&&-1<d.capabilities.indexOf("Query")?(this.featureLayer=
d,this.processIncident(p,v,t)):this._processError()}));l(this.parent.opLayers,"layerInfosFilterChanged",y.hitch(this,this._layerFilterChanged))}},_layerFilterChanged:function(p){if(null!==this.featureLayer&&null!==this.incident&&null!==this.distance&&null!==this.graphicsLayer){var v=this.tab.tabLayers[0].id;J.forEach(p,y.hitch(this,function(t){v===t.id&&this.processIncident(this.incident,this.distance,this.graphicsLayer)}))}},processIncident:function(p,v,t){this.container.innerHTML="";w.add(this.container,
"loading");var d=[];this.incident=p;this.distance=v;v=q.buffer(p.geometry,v,this.parent.config.distanceSettings[this.parent.config.distanceUnits]);this.graphicsLayer=t;this.graphicsLayer.clear();var m=this.tab.tabLayers[0].id,g="";this.parent.opLayers.traversal(function(k){if(m===k.id&&k.getFilter())return g=k.getFilter(),!0});t=new A;t.returnGeometry=!0;t.geometry=v;t.where=g;t.outFields=this._getFields(this.featureLayer);t.outSpatialReference=this.parent.map.spatialReference;this.featureLayer.queryFeatures(t,
y.hitch(this,function(k){var K=this._getFields(this.featureLayer);k=k.features;if(0<k.length){for(var I=0;I<k.length;I++){for(var r=k[I],f={DISTANCE:this._getDistance(p.geometry,r.geometry)},e=0;e<K.length;e++)f[K[e]]=r.attributes[K[e]];r.attributes=f}k.sort(this._compareDistance);d.push(k[0])}this._processResults(d)}),y.hitch(this,this._processError))},_processError:function(){this.container.innerHTML="";w.remove(this.container,"loading");this.container.innerHTML=this.parent.nls.noFeaturesFound},
_processResults:function(p){this.container.innerHTML="";w.remove(this.container,"loading");0===p.length&&(this.container.innerHTML=this.parent.nls.noFeaturesFound);var v=E.create("div",{id:"tpc",style:"width:"+220*p.length+"px;"},this.container);w.add(v,"IMT_tabPanelContent");for(var t=this.parent.nls[this.parent.config.distanceUnits],d=0;d<p.length;d++){var m=d+1,g=p[d],k=g.geometry,K=k;"point"!==k.type&&(K=k.getExtent().getCenter());g=g.attributes;var I=t+": "+Math.round(100*g.DISTANCE)/100;k="";
var r=0,f;for(f in g)"DISTANCE"!==f&&3>r&&(k+=this._getFieldValue(f,g[f])+"\x3cbr/\x3e",r+=1);r=E.create("div",{id:"Feature_"+m},v);w.add(r,"IMTcolRec");var e=E.create("div",{},r);w.add(e,"IMTcolRecBar");var h=E.create("div",{innerHTML:m},e);w.add(h,"IMTcolRecNum");M.set(h,"backgroundColor",this.parent.config.color);l(h,"click",y.hitch(this,this._zoomToLocation,K));I=E.create("div",{innerHTML:I},e);w.add(I,"IMTcolDistance");this.parent.config.enableRouting&&(I=E.create("div",{},e),w.add(I,"IMTcolDir"),
l(I,"click",y.hitch(this,this._routeToIncident,K)));k=E.create("div",{innerHTML:O.sanitizeHTML(k?k:"")},r);w.add(k,"IMTcolInfo");k=new z(z.STYLE_SOLID,new H.fromString(this.parent.config.color),1);k=new c(c.STYLE_CIRCLE,24,k,new H.fromString(this.parent.config.color));r=new C;r.family="Arial";r.size="12px";m=new x(m,r,"#ffffff");m.setOffset(0,-4);this.graphicsLayer.add(new G(K,k,g));this.graphicsLayer.add(new G(K,m,g))}},_getFields:function(p){var v=[];if(this.tab.advConfig&&this.tab.advConfig.fields&&
0<this.tab.advConfig.fields.length)J.forEach(this.tab.advConfig.fields,function(k){v.push(k.expression)});else{var t=p.infoTemplate?p.infoTemplate.info.fieldInfos:p.fields;for(var d=0;d<t.length;d++){var m=t[d];"undefined"!==typeof m.visible?m.visible&&v.push(m.fieldName):v.push(m.name)}}var g={};J.forEach(p.fields,function(k){if("esriFieldTypeDate"===k.type||k.domain)g[k.name]=k});this.specialFields=g;return v},_getFieldValue:function(p,v){var t=v;this.specialFields[p]&&(p=this.specialFields[p],
"esriFieldTypeDate"===p.type?t=(new Date(v)).toLocaleString():J.some(p.domain.codedValues,function(d){if(d.code===v)return t=d.name,!0}));return t},_getDistance:function(p,v){var t=0,d=this.parent.config.distanceUnits;t=q.distance(p,v,9001);switch(d){case "miles":t*=6.21371E-4;break;case "kilometers":t*=.001;break;case "feet":t*=3.28084;break;case "yards":t*=1.09361;break;case "nauticalMiles":t*=5.39957E-4}return t},_compareDistance:function(p,v){return p.attributes.DISTANCE<v.attributes.DISTANCE?
-1:p.attributes.DISTANCE>v.attributes.DISTANCE?1:0},_zoomToLocation:function(p){this.parent.zoomToLocation(p)},_routeToIncident:function(p){this.parent.routeToIncident(p)}})})},"widgets/IncidentAnalysis/js/ProximityInfo":function(){define("dojo/_base/declare dojo/_base/lang dojo/_base/Color dojo/_base/array dojo/dom-class dojo/dom-construct dojo/dom-style dojo/on esri/geometry/geometryEngine esri/geometry/Polyline esri/geometry/webMercatorUtils esri/graphic esri/layers/FeatureLayer esri/symbols/SimpleMarkerSymbol esri/symbols/SimpleLineSymbol esri/symbols/Font esri/symbols/TextSymbol esri/tasks/query jimu/CSVUtils jimu/utils".split(" "),
function(L,y,H,J,w,E,M,l,q,G,N,c,z,C,x,A,O,p,v,t){return L("ProximityInfo",null,{constructor:function(d,m,g){this.tab=d;this.container=m;this.parent=g;this.graphicsLayer=this.buffer=this.incident=this.featureLayer=null;this.specialFields={}},updateForIncident:function(d,m,g){if(this.featureLayer)this.processIncident(d,m,g);else if(0<this.tab.tabLayers.length){var k=new z(this.tab.tabLayers[0].url);l(k,"load",y.hitch(this,function(){k.capabilities&&-1<k.capabilities.indexOf("Query")?(this.featureLayer=
k,this.processIncident(d,m,g)):this._processError()}));l(this.parent.opLayers,"layerInfosFilterChanged",y.hitch(this,this._layerFilterChanged))}},_layerFilterChanged:function(d){if(null!==this.featureLayer&&null!==this.incident&&null!==this.buffer&&null!==this.graphicsLayer){var m=this.tab.tabLayers[0].id;J.forEach(d,y.hitch(this,function(g){m===g.id&&this.processIncident(this.incident,this.buffer,this.graphicsLayer)}))}},processIncident:function(d,m,g){this.container.innerHTML="";w.add(this.container,
"loading");var k=[];this.incident=d;this.buffer=m;this.graphicsLayer=g;this.graphicsLayer.clear();var K=this.tab.tabLayers[0].id,I="";this.parent.opLayers.traversal(function(r){if(K===r.id&&r.getFilter())return I=r.getFilter(),!0});g=new p;g.returnGeometry=!0;g.geometry=m.geometry;g.where=I;g.outFields=this._getFields(this.featureLayer);g.outSpatialReference=this.parent.map.spatialReference;this.featureLayer.queryFeatures(g,y.hitch(this,function(r){var f=this._getFields(this.featureLayer);r=r.features;
if(0<r.length)for(var e=0;e<r.length;e++){for(var h=r[e],B={DISTANCE:this._getDistance(d.geometry,h.geometry)},D=0;D<f.length;D++)B[f[D]]=h.attributes[f[D]];h.attributes=B;k.push(h)}this._processResults(k)}),y.hitch(this,this._processError))},_processError:function(){this.container.innerHTML="";w.remove(this.container,"loading");this.container.innerHTML=this.parent.nls.noFeaturesFound},_processResults:function(d){this.container.innerHTML="";w.remove(this.container,"loading");this.graphicsLayer.clear();
if(0===d.length)this.container.innerHTML=this.parent.nls.noFeaturesFound;else{d.sort(this._compareDistance);var m=E.create("div",{id:"tpc",style:"width:"+220*(d.length+1)+"px;"},this.container);w.add(m,"IMT_tabPanelContent");var g=E.create("div",{},m);w.add(g,"IMTcol");g=E.create("div",{innerHTML:this.parent.nls.downloadCSV},g);w.add(g,"btnExport");l(g,"click",y.hitch(this,this._exportToCSV,d));g=this.parent.nls[this.parent.config.distanceUnits];for(var k=0;k<d.length;k++){var K=k+1,I=d[k],r=I.geometry,
f=r;"point"!==r.type&&(f=r.getExtent().getCenter());I=I.attributes;var e=g+": "+Math.round(100*I.DISTANCE)/100;r="";var h=0,B;for(B in I)"DISTANCE"!==B&&3>h&&(r+=this._getFieldValue(B,I[B])+"\x3cbr/\x3e",h+=1);h=E.create("div",{id:"Feature_"+K},m);w.add(h,"IMTcolRec");var D=E.create("div",{},h);w.add(D,"IMTcolRecBar");var Q=E.create("div",{innerHTML:K},D);w.add(Q,"IMTcolRecNum");M.set(Q,"backgroundColor",this.parent.config.color);l(Q,"click",y.hitch(this,this._zoomToLocation,f));e=E.create("div",
{innerHTML:e},D);w.add(e,"IMTcolDistance");this.parent.config.enableRouting&&(e=E.create("div",{},D),w.add(e,"IMTcolDir"),l(e,"click",y.hitch(this,this._routeToIncident,f)));r=E.create("div",{innerHTML:t.sanitizeHTML(r?r:"")},h);w.add(r,"IMTcolInfo");r=new x(x.STYLE_SOLID,new H.fromString(this.parent.config.color),1);r=new C(C.STYLE_CIRCLE,24,r,new H.fromString(this.parent.config.color));h=new A;h.family="Arial";h.size="12px";K=new O(K,h,"#ffffff");K.setOffset(0,-4);this.graphicsLayer.add(new c(f,
r,I));this.graphicsLayer.add(new c(f,K,I))}}},_exportToCSV:function(d){if(0===d.length)return!1;var m=this.tab.layers,g=[],k=[];J.forEach(d,function(I){g.push(I.attributes)});for(var K in g[0])k.push(K);v.exportCSV(m,g,k)},_getFields:function(d){var m=[];if(this.tab.advConfig&&this.tab.advConfig.fields&&0<this.tab.advConfig.fields.length)J.forEach(this.tab.advConfig.fields,function(r){m.push(r.expression)});else{var g=d.infoTemplate?d.infoTemplate.info.fieldInfos:d.fields;for(var k=0;k<g.length;k++){var K=
g[k];"undefined"!==typeof K.visible?K.visible&&m.push(K.fieldName):m.push(K.name)}}var I={};J.forEach(d.fields,function(r){if("esriFieldTypeDate"===r.type||r.domain)I[r.name]=r});this.specialFields=I;return m},_getFieldValue:function(d,m){var g=m;this.specialFields[d]&&(d=this.specialFields[d],"esriFieldTypeDate"===d.type?g=(new Date(m)).toLocaleString():J.some(d.domain.codedValues,function(k){if(k.code===m)return g=k.name,!0}));return g},_getDistance:function(d,m){var g=0;4326===d.spatialReference.wkid&&
(d=N.geographicToWebMercator(d));g="point"===d.type?d:d.getExtent().getCenter();4326===m.spatialReference.wkid&&(m=N.geographicToWebMercator(m));d="point"===m.type?m:m.getExtent().getCenter();m=this.parent.config.distanceUnits;var k=new G(g.spatialReference);k.addPath([g,d]);g=g.spatialReference.isWebMercator()?q.geodesicLength(k,9001):q.planarLength(k,9001);switch(m){case "miles":g*=6.21371E-4;break;case "kilometers":g*=.001;break;case "feet":g*=3.28084;break;case "yards":g*=1.09361;break;case "nauticalMiles":g*=
5.39957E-4}return g},_compareDistance:function(d,m){return d.attributes.DISTANCE<m.attributes.DISTANCE?-1:d.attributes.DISTANCE>m.attributes.DISTANCE?1:0},_zoomToLocation:function(d){this.parent.zoomToLocation(d)},_routeToIncident:function(d){this.parent.routeToIncident(d)}})})},"widgets/IncidentAnalysis/_build-generate_module":function(){define(["dojo/text!./Widget.html","dojo/text!./css/style.css","dojo/i18n!./nls/strings"],function(){})},"url:widgets/IncidentAnalysis/Widget.html":'\x3cdiv\x3e\r\n  \x3cdiv data-dojo-attach-point\x3d"panelBottom" class\x3d"panelBottom"\x3e\r\n    \x3c!--Panel Container --\x3e\r\n    \x3cdiv data-dojo-attach-point\x3d"panelContainer" class\x3d"panelContainer"\x3e\r\n      \x3c!-- Panel Incident --\x3e\r\n      \x3cdiv id\x3d"tabPanel0" class\x3d"IMT_tabPanel"\x3e\r\n        \x3cdiv class\x3d"IMT_tabPanelContent" style\x3d"width: 660px"\x3e\r\n          \x3cdiv id\x3d"incidentsLocate" class\x3d"IMTcol"\x3e\r\n            \x3cdiv data-dojo-attach-point\x3d"locate_lbl" class\x3d"label"\x3e\r\n              ${nls.locate_incident}\r\n            \x3c/div\x3e\r\n            \x3cbr/\x3e\r\n            \x3cdiv class\x3d"colBar"\x3e\r\n              \x3cspan class\x3d"btn32"\x3e \x3cimg id\x3d"btn0"\x3e \x3c/img\x3e \x3c/span\x3e\r\n              \x3cspan class\x3d"btn32"\x3e \x3cimg id\x3d"btn1"\x3e \x3c/img\x3e \x3c/span\x3e\r\n              \x3cspan class\x3d"btn32"\x3e \x3cimg id\x3d"btn2"\x3e \x3c/img\x3e \x3c/span\x3e\r\n              \x3cspan class\x3d"btn32 btnClear" data-dojo-attach-event\x3d"onclick:_clear"\x3e \x3cimg id\x3d"btn3"\x3e \x3c/img\x3e \x3c/span\x3e\r\n            \x3c/div\x3e\r\n          \x3c/div\x3e\r\n          \x3cdiv id\x3d"incidentsDistance" class\x3d"IMTcol"\x3e\r\n            \x3cdiv class\x3d"label" data-dojo-attach-point\x3d"buffer_lbl"\x3e\x3c/div\x3e\r\n            \x3cbr/\x3e\r\n            \x3cdiv class\x3d"colBar"\x3e\r\n              \x3cdiv id\x3d"horizontalSliderDiv" data-dojo-attach-point\x3d"horizontalSliderDiv"\x3e\x3c/div\x3e\r\n              \x3cdiv style\x3d"text-align:center; margin-top: -4px;"\x3e\r\n                \x3cinput data-dojo-type\x3d"dijit/form/TextBox" style\x3d"width:60px;align:left;" data-dojo-attach-point\x3d"sliderValue" name\x3d"sliderValue" value\x3d"15" /\x3e\r\n              \x3c/div\x3e\r\n            \x3c/div\x3e\r\n          \x3c/div\x3e\r\n          \x3cdiv data-dojo-attach-point\x3d"div_reverse_geocoding" class\x3d"IMTcol" style\x3d"visibility:hidden"\x3e\r\n            \x3cdiv class\x3d"label"\x3e\r\n              ${nls.reverse_geocoded_address}\r\n            \x3c/div\x3e\r\n            \x3c/br\x3e\r\n            \x3cdiv class\x3d"label" style\x3d"width:100%;" data-dojo-attach-point\x3d"div_reversed_address"\x3e\x3c/div\x3e\r\n          \x3c/div\x3e\r\n        \x3c/div\x3e\r\n      \x3c/div\x3e\r\n    \x3c/div\x3e\r\n    \x3c!-- Panel Message --\x3e\r\n    \x3cdiv id\x3d"panelMessage" data-dojo-attach-point\x3d"messageNode"\x3e\r\n      \x3cspan id\x3d"msgText" data-dojo-attach-point\x3d"messageTextNode"\x3e\x3c/span\x3e\r\n    \x3c/div\x3e\r\n    \x3c!-- Panel Footer --\x3e\r\n    \x3cdiv id\x3d"panelFooter" data-dojo-attach-point\x3d"footerNode" class\x3d"jimu-main-background"\x3e\r\n      \x3cdiv id\x3d"panelFooterContent" data-dojo-attach-point\x3d"footerContentNode"\x3e\r\n        \x3c!-- Tabs --\x3e\r\n        \x3cdiv id\x3d"IMT_tabs" data-dojo-attach-point\x3d"tabsNode"\x3e\x3c/div\x3e\r\n      \x3c/div\x3e\r\n      \x3cdiv id\x3d"panelClose" data-dojo-attach-event\x3d"onclick:_close"\x3e\x3c/div\x3e\r\n    \x3c/div\x3e\r\n  \x3c/div\x3e\r\n\x3c/div\x3e\r\n',
"url:widgets/IncidentAnalysis/css/style.css":".jimu-widget-IMT {color: #ffffff !important; background-color: #4c4c4c; left: 0px !important; right: 0px !important; bottom: 0px; height: 140px !important; display: block;}.jimu-widget-IMT .rounded {-moz-border-radius: 5px 5px 5px 5px; -webkit-border-radius: 5px 5px 5px 5px; border-radius: 5px 5px 5px 5px;}.jimu-widget-IMT .roundedL {-moz-border-radius: 5px 0px 0px 5px; -webkit-border-radius: 5px 0px 0px 5px; border-radius: 5px 0px 0px 5px;}.jimu-widget-IMT .roundedR {-moz-border-radius: 0px 5px 5px 0px; -webkit-border-radius: 0px 5px 5px 0px; border-radius: 0px 5px 5px 0px;}.jimu-widget-IMT .panelBottom {position: absolute; width: 100%; height: 140px; left: 0px; top: 0px; text-align: center; color: #ffffff; padding: 0px;}.jimu-widget-IMT #panelMessage {position: absolute; top: 0px; text-align: center; width: 100%; height: 40px; line-height: 40px; display: none;}.jimu-widget-IMT #panelFooter {position: absolute; bottom: 0px; left: 0px; right: 0px; height: 40px; line-height: 40px; overflow: hidden; background-color: #393939; background-color: rgba(0, 0, 0, 0.25); border-bottom: 1px solid #353535; border-bottom: 1px solid rgba(0, 0, 0, 0.3);}.jimu-widget-IMT #panelFooterContent {position: absolute; left: 0px; right: 24px; height: 90px; overflow-x: auto; overflow-y: hidden; display: block;}.jimu-rtl .jimu-widget-IMT #panelFooterContent {position: absolute; left: 24px; right: 0px;}.jimu-widget-IMT #panelClose {position: absolute; left: auto; right: 0px; width: 24px; height: 40px; line-height: 40px; text-align: center; display: block; cursor: pointer; background-image: url('images/x.png'); background-repeat: no-repeat; background-position: center center; background-size: 18px;}.jimu-rtl .jimu-widget-IMT #panelClose {position: absolute; left: 0px; right: auto;}.jimu-widget-IMT .panelContainer {position: absolute; width: 100%; height: 100px; overflow: hidden; display: block;}.jimu-widget-IMT .IMT_tabPanel {position: absolute; top: 10px; left: 0px; right: 0px; height: 90px; display: none; overflow-x: auto !important; overflow-y: hidden !important;}.jimu-widget-IMT .IMT_tabPanelContent {position: absolute; top: 0px; width: auto; height: 80px; white-space: nowrap; display: block; overflow-x: visible; overflow-y: hidden;}.jimu-widget-IMT #IMT_tabs {position: absolute; white-space: nowrap; height: 40px; padding: 0px; overflow-x: visible; overflow-y: hidden;}.jimu-widget-IMT .IMTTab {width: auto; max-width: 220px; overflow: hidden; text-overflow: ellipsis; height: 40px; float: left; line-height: 40px; font-size: 13px; padding: 0 35px 0 10px; background-image: url('images/tab.png'); background-repeat: no-repeat; background-position: right center; cursor: pointer;}.jimu-rtl .jimu-widget-IMT .IMTTab {float: right;}.jimu-widget-IMT .active {color: #ffffff; background-color: #353535; background-color: rgba(0, 0, 0, 0.3); background-image: url('images/tabon.png'); background-position: right center; background-repeat: no-repeat;}.jimu-widget-IMT .IMTcol {float: left; height: 80px; width: 220px; border-left: none; border-right: 1px solid #ffffff; border-right: 1px solid rgba(255, 255, 255, 0.5); margin-left: 0; padding: 0 20px; overflow: hidden; text-overflow: ellipsis;}.jimu-rtl .jimu-widget-IMT .IMTcol {float: right; border-left: 1px solid #ffffff; border-left: 1px solid rgba(255, 255, 255, 0.5); border-right: none;}.jimu-widget-IMT .IMTcolSmall {float: left; height: 80px; width: 165px; border-left: none; border-right: 1px solid #ffffff; border-right: 1px solid rgba(255, 255, 255, 0.5); margin-left: 0; padding: 0 20px; overflow: hidden; text-overflow: ellipsis;}.jimu-rtl .jimu-widget-IMT .IMTcolSmall {float: right; border-left: 1px solid #ffffff; border-left: 1px solid rgba(255, 255, 255, 0.5); border-right: none;}.jimu-widget-IMT .IMTcolLast {border-left: none; border-right: none;}.jimu-widget-IMT .IMTcol .label,.jimu-widget-IMT .IMTcolSmall .label {font-size: 13px; padding: 2px 0; overflow: hidden; text-overflow: ellipsis; width: 100%;}.jimu-widget-IMT .IMTcol .colBar {position: relative; height: 32px; display: block; z-index: 0;}.jimu-widget-IMT .btn32 {float: left; width: 32px; height: 32px; padding: 0; color: #ffffff; background-color: #393939; background-color: rgba(0, 0, 0, 0.25); border-radius: 2px; display: block; margin-right: 8px; cursor: pointer;}.jimu-rtl .jimu-widget-IMT .btn32 {float: right;}.jimu-widget-IMT .btn32:hover {background-color: #262626; background-color: rgba(0, 0, 0, 0.5);}.jimu-widget-IMT .btnOn {border: 1px solid #ffffff; border: 1px solid rgba(255, 255, 255, 0.75); background-color: #262626; background-color: rgba(0, 0, 0, 0.5);}.jimu-widget-IMT .btn32 img {padding: 8px;}.jimu-widget-IMT .btnClear {background-color: #bb0000; margin-left: 16px;}.jimu-rtl .jimu-widget-IMT .btnClear {margin-right: 16px; margin-left: 0;}.jimu-widget-IMT .btnClear:hover {background-color: #ff0000;}.jimu-widget-IMT .dijitTextBox,.jimu-widget-IMT .dijitTextBoxHover,.jimu-widget-IMT .dijitTextBoxFocused,.jimu-widget-IMT .dijitTextBoxHoverFocused {background-color: #393939; background-color: rgba(0, 0, 0, 0.25) !important; color: #ffffff !important; border: 1px solid #a6a6a6; border: 1px solid rgba(255, 255, 255, 0.5) !important; height: 26px !important; line-height: 26px !important;}.jimu-widget-IMT .dijitTextBoxFocused,.jimu-widget-IMT .dijitInputInner,.jimu-widget-IMT .dijitInputContainer {background: transparent !important; color: #ffffff !important; height: 26px !important; line-height: 26px !important;}.jimu-widget-IMT .dijitInputField {padding: 0px 10px !important;}.jimu-widget-IMT .btnExport {background-color: #393939; background-color: rgba(0, 0, 0, 0.25); border-radius: 2px; padding: 10px 44px 10px 10px; background-image: url('images/download.png'); background-repeat: no-repeat; background-position: right center; cursor: pointer;}.jimu-widget-IMT .btnExport:hover {background-color: #262626; background-color: rgba(0, 0, 0, 0.5);}.jimu-widget-IMT .download {background-image: url('images/download.png'); background-repeat: no-repeat; background-position: right 0px center;}.jimu-widget-IMT .processing {background-image: url('images/processing.gif'); background-repeat: no-repeat; background-position: right 10px center;}.jimu-widget-IMT .loading {background-image: url('images/loading.gif'); background-repeat: no-repeat; background-position: center 10px;}.jimu-widget-IMT .colSummary {height: 36px; line-height: 36px; font-size: 28px; padding-top: 25px;}.jimu-widget-IMT .IMTcolRec {float: left; height: 80px; width: 220px; border-left: none; border-right: 1px solid #ffffff; border-right: 1px solid rgba(255, 255, 255, 0.5); margin-left: 0; padding: 0 20px; overflow: hidden; text-align: left; text-overflow: ellipsis;}.jimu-rtl .jimu-widget-IMT .IMTcolRec {float: right; border-left: 1px solid #ffffff; border-left: 1px solid rgba(255, 255, 255, 0.5); border-right: none; text-align: right;}.jimu-widget-IMT .IMTcolRecBar {position: relative; height: 26px; width: 100%; display: block;}.jimu-widget-IMT .IMTcolRecNum {position: absolute; width: 26px; height: 26px; background-color: #4c4c4c; color: #ffffff; line-height: 26px; text-align: center; border-radius: 13px; font-size: 11px; cursor: pointer;}.jimu-widget-IMT .IMTcolDir {position: absolute; right: 0px; width: 26px; height: 26px; background-image: url('images/car.png'); background-repeat: no-repeat; background-position: center center; cursor: pointer;}.jimu-rtl .jimu-widget-IMT .IMTcolDir {position: absolute; left: 0px; right: auto;}.jimu-widget-IMT .IMTcolDistance {position: absolute; left: 30px; right: 30px; height: 26px; font-size: 11px; line-height: 26px;}.jimu-widget-IMT .IMTcolInfo {position: relative; margin-top: 4px; height: 60px; line-height: 13px; width: 100%; display: block; overflow: hidden; text-overflow: ellipsis;}.claro .dijitSlider {background: transparent; border: 0 none; -webkit-border-radius: 3px; border-radius: 3px; padding: 0;}.claro .dijitSliderBar {border-style: solid; outline: 1px;}.claro .dijitRuleLabelsContainer {color: #2b2e34;}.claro .dijitSliderDisabled {opacity: 0.65; -ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity\x3d65)\"; filter: alpha(opacity\x3d65);}.claro .dijitRuleLabelsContainerH {padding: 8px 0 !important; color: #6e6e6e !important;}.claro .dijitSliderBarH,.claro .dijitSliderBumperH {height: 4px;}.claro .dijitSlider .dijitSliderLeftBumper {-webkit-border-radius: 2px 0 0 2px; border-radius: 2px 0 0 2px; border-width: 1px 0 1px 1px; margin-left: 4px;}.claro .dijitSlider .dijitSliderRightBumper {-webkit-border-radius: 0 2px 2px 0; border-radius: 0 2px 2px 0; border-width: 1px 1px 1px 0; margin-left: -2px; margin-right: 4px;}.claro .dijitSlider .dijitSliderProgressBarH {border-color: #ebebeb; background-color: #ebebeb; background-image: none; -webkit-box-shadow: none; box-shadow: none;}.claro .dijitSlider .dijitSliderLeftBumper {border-color: #ebebeb; background-color: #ebebeb; background-image: none; -webkit-box-shadow: none; box-shadow: none; -webkit-border-radius: 2px 0 0 2px; border-radius: 2px 0 0 2px;}.claro .dijitSlider .dijitSliderRemainingBarH,.claro .dijitSlider .dijitSliderRightBumper {border-color: #878787; background-color: #878787; -webkit-border-radius: 2px; border-radius: 2px;}.claro .dijitSliderHover .dijitSliderProgressBarH,.claro .dijitSliderHover .dijitSliderLeftBumper {border-color: #ebebeb; background-color: #ebebeb; background-image: none; -webkit-box-shadow: none; box-shadow: none;}.claro .dijitSliderFocused .dijitSliderProgressBarH,.claro .dijitSliderFocused .dijitSliderLeftBumper {border-color: #ebebeb;}.claro .dijitSliderFocused .dijitSliderRemainingBarH,.claro .dijitSliderFocused .dijitSliderRightBumper {border-color: #878787; background-color: #878787; -webkit-box-shadow: none; box-shadow: none;}.claro .dijitSliderImageHandle {background: #ffffff; -webkit-border-radius: 50%; border-radius: 50%; border: 0 none; width: 16px; height: 16px; margin-top: -2px; position: absolute;}.claro .dijitSliderImageHandle:after {content: \"\"; display: block; background: #6e6e6e; -webkit-border-radius: 50%; border-radius: 50%; height: 8px; width: 8px; left: 4px; top: 4px; position: absolute;}.claro .dijitSliderDisabled.dijitSliderFocused .dijitSliderImageHandle:after {display: none; outline: none;}.claro .dijitSliderDecrementIconH,.claro .dijitSliderIncrementIconH {padding: 0; height: 20px; width: 20px; background-color: transparent; border: 0 none;}.IMT_tabPanel::-webkit-scrollbar {width: 6px; height: 6px; background-color: rgba(0, 0, 0, 0.1);}.IMT_tabPanel::-webkit-scrollbar-thumb {background-color: rgba(0, 0, 0, 0.4);}.IMT_tabPanel {scrollbar-base-color: #4c4c4c; scrollbar-3dlight-color: #4c4c4c; scrollbar-highlight-color: #4c4c4c; scrollbar-track-color: #444444; scrollbar-arrow-color: #2e2e2e; scrollbar-shadow-color: #4c4c4c; scrollbar-dark-shadow-color: #4c4c4c; scrollbar-face-color: #2e2e2e;}",
"*now":function(L){L(['dojo/i18n!*preload*widgets/IncidentAnalysis/nls/Widget*["ar","bs","ca","cs","da","de","en","el","es","et","fi","fr","he","hr","hu","id","it","ja","ko","lt","lv","nb","nl","pl","pt-br","pt-pt","ro","ru","sk","sl","sr","sv","th","tr","zh-cn","uk","vi","zh-hk","zh-tw","ROOT"]'])},"*noref":1}});
define("dojo/_base/declare dijit/_WidgetsInTemplateMixin jimu/BaseWidget jimu/dijit/Message jimu/utils jimu/LayerInfos/LayerInfos dojo/_base/Color dojo/_base/html dojo/dom dojo/on dojo/dom-style dojo/dom-class dojo/dom-construct dojo/dom-geometry dojo/_base/lang dojo/_base/array dojo/_base/xhr dojo/query dojo/json dijit/form/HorizontalSlider dijit/form/HorizontalRuleLabels esri/geometry/Extent esri/geometry/geometryEngine esri/geometry/Polygon esri/geometry/Point esri/geometry/Multipoint esri/geometry/Polyline esri/geometry/webMercatorUtils esri/graphic esri/layers/GraphicsLayer esri/symbols/Font esri/symbols/SimpleLineSymbol esri/symbols/SimpleFillSymbol esri/symbols/SimpleMarkerSymbol esri/symbols/TextSymbol esri/tasks/locator esri/tasks/BufferParameters esri/toolbars/draw ./js/SummaryInfo ./js/WeatherInfo ./js/ClosestInfo ./js/ProximityInfo dojo/keys dojo/domReady!".split(" "),function(L,
y,H,J,w,E,M,l,q,G,N,c,z,C,x,A,O,p,v,t,d,m,g,k,K,I,r,f,e,h,B,D,Q,S,T,R,V,U,X,Y,Z,aa,ba){return L([H,y],{baseClass:"jimu-widget-IMT",name:"IncidentAnalysis",opLayers:null,curTab:0,lyrBuffer:null,lyrIncidents:null,lyrClosest:null,lyrProximity:null,tabLayersVisibility:{},toolbar:null,tool:-1,symPoint:null,symLine:null,symPoly:null,symBuffer:null,symRoute:null,incident:null,buffer:null,locator:null,stops:[],Incident_Local_Storage_Key:"IMT_Incident",SLIDER_MAX_VALUE:1E4,postCreate:function(){this.inherited(arguments)},
startup:function(){this.inherited(arguments);this._getStyleColor();this._createUI();this._loadUI();this._initLayers();this._verifyRouting();this.SLIDER_MAX_VALUE=this.config.bufferRange.maximum;this.opLayers=this.map.itemInfo.itemData.operationalLayers;this._mapLoaded();this._restoreIncidents()},onOpen:function(){this.inherited(arguments);this._getTabLayersVisibility();this._clickTab(0)},onClose:function(){this._clear();this._toggleTabLayersOld();this._setTabLayersVisibility();this.inherited(arguments)},
onDeActive:function(){this._clickIncidentsButton(-1)},destroy:function(){this._clear();this._toggleTabLayersOld();this.lyrBuffer&&this.map.removeLayer(this.lyrBuffer);this.lyrIncidents&&this.map.removeLayer(this.lyrIncidents);this.lyrClosest&&this.map.removeLayer(this.lyrClosest);this.lyrProximity&&this.map.addLayer(this.lyrProximity);this.inherited(arguments)},onAppConfigChanged:function(a,b,n){switch(b){case "styleChange":this._updateUI(n);break;case "widgetPoolChange":this._verifyRouting()}},_updateUI:function(a){this._getStyleColor(a)},
_getStyleColor:function(a){var b=this.appConfig.theme.name,n=this.appConfig.theme.styles[0];a&&(n=a);O.get({url:"./themes/"+b+"/manifest.json",handleAs:"json",load:x.hitch(this,function(u){u=u.styles;for(var F=0;F<u.length;F++){var P=u[F];P.name===n&&(N.set(this.footerNode,"background-color",P.styleColor),this.config.color=P.styleColor,this._setupSymbols(),this._bufferIncident())}})})},setPosition:function(a,b){if("BoxTheme"===this.appConfig.theme.name||"DartTheme"===this.appConfig.theme.name||"LaunchpadTheme"===
this.appConfig.theme.name)this.inherited(arguments);else{this.position={left:"0px",right:"0px",bottom:"0px",height:"140px"};var n=w.getPositionStyle(this.position);n.position="absolute";b=this.map.id;l.place(this.domNode,b);l.setStyle(this.domNode,n);this.started&&this.resize();"TabTheme"===this.appConfig.theme.name&&(n=this.widgetManager.getControllerWidgets()[0],this.widgetManager.minimizeWidget(n.id))}},disableWebMapPopup:function(){this.map&&this.map.setInfoWindowOnClick(!1)},enableWebMapPopup:function(){this.map&&
this.map.setInfoWindowOnClick(!0)},_setEventLocation:function(a){this.onReceiveData("","",{eventType:"IncidentLocation",dataValue:a})},_initLayers:function(){this.locator=new R(this.config.geocodeService.url);this.own(G(this.locator,"location-to-address-complete",x.hitch(this,this._showIncidentAddress)));this.own(G(this.locator,"error",x.hitch(this,this._onAddressError)));this.lyrBuffer=new h;this.map.addLayer(this.lyrBuffer);this.lyrIncidents=new h;this.map.addLayer(this.lyrIncidents);this.lyrClosest=
new h;this.lyrClosest.setVisibility(!1);this.map.addLayer(this.lyrClosest);this.lyrProximity=new h;this.lyrProximity.setVisibility(!1);this.map.addLayer(this.lyrProximity)},_mapLoaded:function(){p("[data-reference]").style("z-index",0);this.map.itemId&&E.getInstance(this.map,this.map.itemInfo).then(x.hitch(this,function(a){this.opLayers=a;this._processOperationalLayers()}));this._clickTab(0)},_processOperationalLayers:function(){for(var a=0;a<this.config.tabs.length;a++){var b=this.config.tabs[a];
b.layers&&""!==b.layers&&(b.tabLayers=this._getTabLayers(b.layers,!1),0===b.tabLayers.length&&(b.tabLayers=this._getTabLayers(b.layers,!0)))}},_createUI:function(){var a=this.config.distanceUnits,b=w.sanitizeHTML(this.config.bufferLabel?this.config.bufferLabel:"");b+=" ("+this.nls[a]+")";this.buffer_lbl.innerHTML=b;this.buffer_lbl.title=b;a=q.byId("horizontalSliderDiv");b=document.createElement("div");a.appendChild(b);b=document.createElement("div");a.appendChild(b);b=new d({container:"bottomDecoration",
minimum:this.config.bufferRange.minimum,maximum:this.config.bufferRange.maximum,labels:[this.config.bufferRange.minimum,this.config.bufferRange.maximum],style:"height:2em;font-size:75%;color:#fff"},b);var n=Math.abs(Math.round(this.config.bufferRange.maximum-this.config.bufferRange.minimum))+1,u=this.config.bufferRange.minimum+10;u>this.config.bufferRange.maximum&&(u=this.config.bufferRange.minimum);this.horizontalSlider=new t({value:u,minimum:this.config.bufferRange.minimum,maximum:this.config.bufferRange.maximum,
discreteValues:n,intermediateChanges:!1,showButtons:!1,style:"width:180px;"},a);this.own(G(this.horizontalSlider,"change",x.hitch(this,this._sliderChange)));this.horizontalSlider.startup();b.startup();this.sliderValue.set("value",u);a={type:"incidents",label:this.nls.incident,color:this.config.color};this.config.incidentLabel&&(a.label=this.config.incidentLabel);this.config.locateLabel&&(this.locate_lbl.innerHTML=w.sanitizeHTML(this.config.locateLabel?this.config.locateLabel:""));this.config.tabs.splice(0,
0,a);a=this.panelContainer;b=q.byId("IMT_tabs");for(u=n=0;u<this.config.tabs.length;u++){var F=this.config.tabs[u],P=F.label;"weather"===F.type&&(P=this.nls.weather);P&&""!==P||(P=F.title||F.layers);P=z.create("div",{id:"tab"+u,innerHTML:w.sanitizeHTML(P?P:"")},b);c.add(P,"IMTTab");n+=C.position(P).w;G(P,"click",x.hitch(this,this._clickTab,u));0<u&&(P=z.create("div",{id:"tabPanel"+u,innerHTML:this.nls.defaultTabMsg},a),c.add(P,"IMT_tabPanel"),"summary"===F.type&&(F.summaryInfo=new X(F,P,this)),"weather"===
F.type&&(F.weatherInfo=new Y(F,P,this)),"closest"===F.type&&(F.closestInfo=new Z(F,P,this)),"proximity"===F.type&&(F.proximityInfo=new aa(F,P,this)))}N.set(b,"width",n+10+"px")},_loadUI:function(){for(var a=0;4>a;a++){var b=q.byId("btn"+a);l.setAttr(b,"src",this.folderUrl+"images/btn"+a+".png");this.own(G(b,"click",x.hitch(this,this._clickIncidentsButton,a)))}this.toolbar=new U(this.map,{tooltipOffset:20,drawTime:90});this.toolbar.on("draw-end",x.hitch(this,this._drawIncident));this.own(G(this.horizontalSlider,
"change",x.hitch(this,this._sliderChange)));this.own(G(this.sliderValue,"keyup",x.hitch(this,function(n){n.keyCode===ba.ENTER?this._updateSliderValue():(n=this.sliderValue.get("value"),isNaN(n)?this.sliderValue.set("value",this.horizontalSlider.value):(n<this.config.bufferRange.minimum&&this.sliderValue.set("value",this.config.bufferRange.minimum),n>this.SLIDER_MAX_VALUE&&this.sliderValue.set("value",this.SLIDER_MAX_VALUE)))})))},_locateBuffer:function(a){if(null!==a&&(a="extent"===a.type?a:a.geometry.getExtent(),
null!==a)){a=a.expand(1.5);var b=80/this.map.height,n=a.getHeight();a.update(a.xmin,a.ymin-n*b,a.xmax,a.ymax-n*b,this.map.spatialReference);this.map.setExtent(a,!0)}},_clickIncidentsButton:function(a){if(3>a){for(var b=0;3>b;b++){var n=q.byId("btn"+b);c.remove(n,"btnOn")}-1<a&&a!==this.tool?(n=q.byId("btn"+a),c.add(n,"btnOn"),this.tool=a):this.tool=-1;switch(this.tool){case -1:this.toolbar.deactivate();this.enableWebMapPopup();break;case 0:this._clear();this.toolbar.activate(U.POINT);this.disableWebMapPopup();
break;case 1:this._clear();this.toolbar.activate(U.POLYLINE);this.disableWebMapPopup();break;case 2:this._clear(),this.toolbar.activate(U.POLYGON),this.disableWebMapPopup()}}else this._clear()},_clear:function(){this.map.graphics.clear();this.lyrIncidents.clear();this.lyrBuffer.clear();this.lyrProximity.clear();this.lyrClosest.clear();this.buffer=this.incident=null;this.div_reversed_address.innerHTML="";l.setStyle(this.div_reverse_geocoding,"visibility","hidden");for(var a=1;a<this.config.tabs.length;a++)q.byId("tabPanel"+
a)&&(q.byId("tabPanel"+a).innerHTML=this.nls.defaultTabMsg)},_sliderChange:function(){this.sliderValue.set("value",this.horizontalSlider.value);this._bufferIncident()},_sliderTextChange:function(){0>this.sliderValue.value||this.sliderValue.value>this.SLIDER_MAX_VALUE?this.sliderValue.set("value",this.horizontalSlider.value):this.horizontalSlider.set("value",this.sliderValue.value)},_updateSliderValue:function(){0>this.sliderValue.displayedValue||this.sliderValue.displayedValue>this.SLIDER_MAX_VALUE?
this.sliderValue.set("value",this.horizontalSlider.value):this.horizontalSlider.set("value",this.sliderValue.displayedValue)},_clickTab:function(a){this._toggleTabs(a);this._toggleTabLayers(a);this.curTab=a;this._clickIncidentsButton(-1)},_toggleTabs:function(a){for(var b=0;b<this.config.tabs.length;b++)b===a?(c.add("tab"+b,"active"),N.set("tabPanel"+b,"display","block")):(c.remove("tab"+b,"active"),N.set("tabPanel"+b,"display","none"));this._scrollToTab(a)},_getTabLayersVisibility:function(){this.config.disableLayerManagement||
(A.forEach(this.config.tabs,x.hitch(this,function(a){A.forEach(a.tabLayers,x.hitch(this,function(b){"undefined"!==typeof b.visible&&(this.tabLayersVisibility[b.id]=b.visible?!0:!1)}))})),A.forEach(this.config.tabs,x.hitch(this,function(a){A.forEach(a.tabLayers,x.hitch(this,function(b){"undefined"!==typeof b.visible&&b.setVisibility(!1)}))})))},_setTabLayersVisibility:function(){this.config.disableLayerManagement||A.forEach(this.config.tabs,x.hitch(this,function(a){A.forEach(a.tabLayers,x.hitch(this,
function(b){b.id in this.tabLayersVisibility&&b.setVisibility(this.tabLayersVisibility[b.id])}))}))},_toggleTabLayers:function(a){this._toggleTabLayersOld();this._toggleTabLayersNew(a)},_toggleTabLayersOld:function(){var a=this.config.tabs[this.curTab];a&&(this.lyrClosest.setVisibility(!1),this.lyrProximity.setVisibility(!1),this.config.disableLayerManagement||a.tabLayers&&A.forEach(a.tabLayers,function(b){"undefined"!==typeof b.visible&&b.setVisibility(!1)}))},_toggleTabLayersNew:function(a){a=this.config.tabs[a];
switch(a.type){case "summary":this.incident&&!0===a.updateFlag&&(a.summaryInfo.updateForIncident(this.incident,this.buffer),a.updateFlag=!1);break;case "weather":this.incident&&!0===a.updateFlag&&(a.weatherInfo.updateForIncident(this.incident),a.updateFlag=!1);break;case "closest":this.lyrClosest.setVisibility(!0);this.incident&&(a.closestInfo.updateForIncident(this.incident,this.config.maxDistance,this.lyrClosest),a.updateFlag=!1);break;case "proximity":this.lyrProximity.setVisibility(!0),this.incident&&
(a.proximityInfo.updateForIncident(this.incident,this.buffer,this.lyrProximity),a.updateFlag=!1)}a.updateFlag=!1;this.config.disableLayerManagement||a.tabLayers&&A.forEach(a.tabLayers,function(b){"undefined"!==typeof b.visible&&b.setVisibility(!0)})},_drawIncident:function(a){var b=a.geometry.type,n=this.symPoint;"polyline"===b&&(n=this.symLine);"polygon"===b&&(n=this.symPoly);this.incident=new e(a.geometry,n);this.lyrIncidents.add(this.incident);this.toolbar.deactivate();this._clickIncidentsButton(-1);
this._bufferIncident();"point"===b&&this._getIncidentAddress(a.geometry);this.div_reversed_address.innerHTML="";l.setStyle(this.div_reverse_geocoding,"visibility","hidden")},_getIncidentAddress:function(a){this.map.graphics.clear();this.locator.locationToAddress(a,100)},_showIncidentAddress:function(a){if(a.address.address){var b=a.address.address.Address,n=a.address.location,u=new B;u.family="Arial";u.size="18px";u=new T(b,u,"#000000");u.setOffset(20,-4);u.horizontalAlignment="left";this.map.graphics.add(new e(n,
u,{}));b+="\x3c/br\x3e";a.address.address.City&&(b+=a.address.address.City+", ");a.address.address.Region&&(b+=a.address.address.Region);a.address.address.Postal&&(b+=" "+a.address.address.Postal);this.div_reversed_address.innerHTML=w.sanitizeHTML(b?b:"");l.setStyle(this.div_reverse_geocoding,"visibility","visible")}},_onAddressError:function(){this.div_reversed_address.innerHTML=this.nls.reverse_geocoded_error;l.setStyle(this.div_reverse_geocoding,"visibility","visible")},_bufferIncident:function(){if(null!==
this.incident){for(var a=0;a<this.config.tabs.length;a++)this.config.tabs[a].updateFlag=!0;a=this.incident;this.buffer=null;this.lyrBuffer.clear();var b=this.horizontalSlider.value,n=this.config.distanceSettings[this.config.distanceUnits];0===b&&(b=.001);if(0<b){var u=a.geometry.spatialReference.wkid;a=4326===u||3857===u||102100===u?g.geodesicBuffer(a.geometry,b,n):g.buffer(a.geometry,b,n);this._locateBuffer(a.getExtent());this.buffer=new e(a,this.symBuffer);this.lyrBuffer.add(this.buffer);this._performAnalysis()}}},
_performAnalysis:function(){this._toggleTabLayersNew(this.curTab)},_verifyRouting:function(){if(this.config.enableRouting){this.config.enableRouting=!1;var a=this.appConfig.getConfigElementsByName("Directions");A.forEach(a,x.hitch(this,function(b){"Directions"===b.name&&(this.dirConfig=b,this.config.enableRouting=!0)}))}},zoomToLocation:function(a){this.map.centerAt(a)},routeToIncident:function(a){var b=this.incident.geometry,n=b;"point"!==b.type&&(n=b.getExtent().getCenter());this.stops=[a,n];this.widgetManager.triggerWidgetOpen(this.dirConfig.id).then(x.hitch(this,
function(u){u.addStop(this.stops[0]);u.addStop(this.stops[1])}))},_getTabLayers:function(a,b){var n=[];A.forEach(this.opLayers._layerInfos,x.hitch(this,function(u){var F=u.originOperLayer.layerType;if(0<u.newSubLayers.length)this._recurseOpLayers(u.newSubLayers,n,a,b);else{var P=u.id;b&&(P=u.title);a===P&&("ArcGISFeatureLayer"===F&&u.originOperLayer.featureCollection?n.push(u.originOperLayer):n.push(u.layerObject))}}));return n},_recurseOpLayers:function(a,b,n,u){A.forEach(a,x.hitch(this,function(F){var P=
F.originOperLayer.layerType;if(0<F.newSubLayers.length)this._recurseOpLayers(F.newSubLayers,b,n);else{var W=F.id;u&&(W=F.title);n===W&&("ArcGISFeatureLayer"===P&&F.originOperLayer.featureCollection?b.push(F.originOperLayer):(F.layerObject.id=F.layerObject.id?F.layerObject.id:F.id,b.push(F.layerObject)))}}))},_setupSymbols:function(){var a=M.fromString(this.config.color),b=a.toRgb();b.push(.2);var n=M.fromString("#000000");a=M.blendColors(a,n,.2).toRgb();n=new D(D.STYLE_SOLID,new M([255,255,255,.25]),
1);this.symPoint=new S(S.STYLE_CIRCLE,20,n,new M([a[0],a[1],a[2],.7]));this.symLine=new D(D.STYLE_SOLID,new M([a[0],a[1],a[2],.7]),3);this.symPoly=new Q(Q.STYLE_SOLID,this.symLine,new M([a[0],a[1],a[2],.3]));this.symBuffer=new Q(Q.STYLE_SOLID,n,new M(b))},onReceiveData:function(a,b,n){null!==n&&n.eventType&&("IncidentLocation"===n.eventType?n.dataValue&&null!==n.dataValue&&(this._clear(),this._clickTab(0),a=n.dataValue,a.attributes[this.shapeFlagFieldName]?(this.incident=a,this._bufferIncident()):
this._drawIncident(a)):"WebMapChanged"===n.eventType&&this._storeIncidents())},_storeIncidents:function(){if(null!==this.incident){var a={location:v.stringify(this.incident.geometry),hasBuffer:0<this.lyrBuffer.graphics.length,buffer_dist:this.horizontalSlider.value,unit:this.config.distanceUnits};a=v.stringify(a);window.localStorage.setItem(this.Incident_Local_Storage_Key,a);console.log("Inclident saved to storage")}this.publishData({eventType:"WebMapChangedACK"});console.log("eventType WebMapChangedACK fired")},
_restoreIncidents:function(){var a=window.localStorage.getItem(this.Incident_Local_Storage_Key);if(null!==a&&"null"!==a){window.localStorage.setItem(this.Incident_Local_Storage_Key,null);a=v.parse(a,!0);var b=a.buffer_dist;this.sliderValue.set("value",b);this.horizontalSlider.set("value",b);b=v.parse(a.location);var n=a.hasBuffer;if(b){a={};var u=null;"extent"===b.type?u=new m(b):"multipoint"===b.type?u=new I(b):"point"===b.type?u=new K(b):"polygon"===b.type?u=new k(b):"polyline"===b.type&&(u=new r(b));
a.geometry=u;this._drawIncident(a,n)}}},_scrollToTab:function(a){var b=C.position(this.footerContentNode).w;C.position(this.tabsNode).w>b&&(a=C.getMarginBox("tab"+a),this.footerContentNode.scrollLeft=a.l-(b-a.w)/2)},_close:function(){this.widgetManager.closeWidget(this.id)}})});